/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.exam.neighbours;

import java.util.Set;
import org.cpsolver.exam.model.Exam;
import org.cpsolver.exam.model.ExamModel;
import org.cpsolver.exam.model.ExamPeriodPlacement;
import org.cpsolver.exam.model.ExamPlacement;
import org.cpsolver.exam.model.ExamRoomPlacement;
import org.cpsolver.exam.neighbours.ExamSimpleNeighbour;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.heuristics.NeighbourSelection;
import org.cpsolver.ifs.model.Neighbour;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.ToolBox;

public class ExamRandomMove
implements NeighbourSelection<Exam, ExamPlacement> {
    private boolean iCheckStudentConflicts = false;
    private boolean iCheckDistributionConstraints = true;

    public ExamRandomMove(DataProperties properties) {
        this.iCheckStudentConflicts = properties.getPropertyBoolean("ExamRandomMove.CheckStudentConflicts", this.iCheckStudentConflicts);
        this.iCheckDistributionConstraints = properties.getPropertyBoolean("ExamRandomMove.CheckDistributionConstraints", this.iCheckDistributionConstraints);
    }

    @Override
    public void init(Solver<Exam, ExamPlacement> solver) {
    }

    @Override
    public Neighbour<Exam, ExamPlacement> selectNeighbour(Solution<Exam, ExamPlacement> solution) {
        ExamModel model = (ExamModel)solution.getModel();
        Assignment<Exam, ExamPlacement> assignment = solution.getAssignment();
        Exam exam = (Exam)ToolBox.random(model.variables());
        int px = ToolBox.random(exam.getPeriodPlacements().size());
        for (int p = 0; p < exam.getPeriodPlacements().size(); ++p) {
            Set<ExamRoomPlacement> rooms;
            ExamPeriodPlacement period = exam.getPeriodPlacements().get((p + px) % exam.getPeriodPlacements().size());
            if (this.iCheckStudentConflicts && exam.countStudentConflicts(assignment, period) > 0 || this.iCheckDistributionConstraints && !exam.checkDistributionConstraints(assignment, period) || (rooms = exam.findBestAvailableRooms(assignment, period)) == null) continue;
            return new ExamSimpleNeighbour(assignment, new ExamPlacement(exam, period, rooms));
        }
        return null;
    }
}

