/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.exam.criteria;

import java.util.Set;
import org.cpsolver.exam.criteria.PerturbationPenalty;
import org.cpsolver.exam.model.Exam;
import org.cpsolver.exam.model.ExamPlacement;
import org.cpsolver.exam.model.ExamRoomPlacement;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.util.DataProperties;

public class RoomPerturbationPenalty
extends PerturbationPenalty {
    @Override
    public String getWeightName() {
        return "Exams.RoomPerturbationWeight";
    }

    @Override
    public String getXmlWeightName() {
        return "roomPerturbationWeight";
    }

    @Override
    public double getWeightDefault(DataProperties config) {
        return 0.01;
    }

    @Override
    public double getValue(Assignment<Exam, ExamPlacement> assignment, ExamPlacement value, Set<ExamPlacement> conflicts) {
        if (!this.isMPP()) {
            return 0.0;
        }
        Exam exam = (Exam)value.variable();
        ExamPlacement initial = (ExamPlacement)exam.getInitialAssignment();
        if (initial == null) {
            return 0.0;
        }
        int penalty = 0;
        if (value.getRoomPlacements() != null) {
            for (ExamRoomPlacement rp : value.getRoomPlacements()) {
                if (initial.getRoomPlacements() != null && initial.getRoomPlacements().contains(rp)) continue;
                ++penalty;
            }
        }
        return penalty;
    }

    @Override
    public String toString(Assignment<Exam, ExamPlacement> assignment) {
        return this.isMPP() ? "IRP:" + sDoubleFormat.format(this.getValue(assignment)) : "";
    }

    @Override
    public boolean isPeriodCriterion() {
        return false;
    }
}

