/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.exam.criteria;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.cpsolver.exam.criteria.InstructorNotAvailableConflicts;
import org.cpsolver.exam.criteria.StudentDirectConflicts;
import org.cpsolver.exam.model.Exam;
import org.cpsolver.exam.model.ExamInstructor;
import org.cpsolver.exam.model.ExamModel;
import org.cpsolver.exam.model.ExamPeriod;
import org.cpsolver.exam.model.ExamPlacement;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.util.DataProperties;

public class InstructorDirectConflicts
extends StudentDirectConflicts {
    @Override
    public String getWeightName() {
        return "Exams.InstructorDirectConflictWeight";
    }

    @Override
    public String getXmlWeightName() {
        return "instructorDirectConflictWeight";
    }

    @Override
    public double getWeightDefault(DataProperties config) {
        return 1000.0;
    }

    @Override
    public double getValue(Assignment<Exam, ExamPlacement> assignment, ExamPlacement value, Set<ExamPlacement> conflicts) {
        Exam exam = (Exam)value.variable();
        int penalty = 0;
        ExamPeriod period = value.getPeriod();
        ExamModel m = (ExamModel)this.getModel();
        Map<ExamInstructor, Set<Exam>> instructors = m.getInstructorsOfPeriod(assignment, period);
        for (ExamInstructor s : exam.getInstructors()) {
            int nrExams;
            Set<Exam> exams = instructors.get(s);
            if (exams == null || (nrExams = exams.size() + (exams.contains(exam) ? 0 : 1)) <= 1) continue;
            ++penalty;
        }
        if (m.isCheckForPeriodOverlaps()) {
            for (ExamPeriod p : m.getPeriods()) {
                if (!period.hasIntersection(p)) continue;
                Map<ExamInstructor, Set<Exam>> others = m.getInstructorsOfPeriod(assignment, p);
                block2: for (ExamInstructor s : exam.getInstructors()) {
                    Set<Exam> other;
                    Set<Exam> exams = instructors.get(s);
                    if (exams != null && exams.size() + (exams.contains(exam) ? 0 : 1) > 1 || (other = others.get(s)) == null || other.isEmpty()) continue;
                    for (Exam x : other) {
                        if (!period.hasIntersection(exam, x, p)) continue;
                        ++penalty;
                        continue block2;
                    }
                }
            }
        }
        return penalty;
    }

    @Override
    public double getValue(Assignment<Exam, ExamPlacement> assignment, Collection<Exam> variables) {
        int ret = 0;
        ExamModel m = (ExamModel)this.getModel();
        for (ExamPeriod p : m.getPeriods()) {
            Map<ExamInstructor, Set<Exam>> instructors = m.getInstructorsOfPeriod(assignment, p);
            for (Set<Exam> exams : instructors.values()) {
                int nrExams = exams.size();
                if (nrExams <= 1) continue;
                ret += nrExams - 1;
            }
        }
        if (m.isCheckForPeriodOverlaps()) {
            for (ExamPeriod p : m.getPeriods()) {
                for (ExamPeriod q : m.getPeriods()) {
                    if (p.getIndex() >= q.getIndex() || !p.hasIntersection(q)) continue;
                    Map<ExamInstructor, Set<Exam>> s1 = m.getInstructorsOfPeriod(assignment, p);
                    Map<ExamInstructor, Set<Exam>> s2 = m.getInstructorsOfPeriod(assignment, q);
                    block4: for (Map.Entry<ExamInstructor, Set<Exam>> e : s1.entrySet()) {
                        Set<Exam> x;
                        ExamInstructor s = e.getKey();
                        if (e.getValue().isEmpty() || (x = s2.get(s)) == null || !x.isEmpty()) continue;
                        for (Exam x1 : e.getValue()) {
                            for (Exam x2 : x) {
                                if (!p.hasIntersection(x1, x2, q)) continue;
                                ++ret;
                                continue block4;
                            }
                        }
                    }
                }
            }
        }
        return ret;
    }

    @Override
    public String getName() {
        return "Instructor Direct Conflicts";
    }

    @Override
    public void getInfo(Assignment<Exam, ExamPlacement> assignment, Map<String, String> info) {
        InstructorNotAvailableConflicts na = (InstructorNotAvailableConflicts)this.getModel().getCriterion(InstructorNotAvailableConflicts.class);
        if (this.getValue(assignment) != 0.0 || na != null && na.getValue(assignment) != 0.0) {
            info.put(this.getName(), sDoubleFormat.format(this.getValue(assignment) + (na == null ? 0.0 : na.getValue(assignment))) + (na == null || na.getValue(assignment) == 0.0 ? "" : " (" + sDoubleFormat.format(na.getValue(assignment)) + " N/A)"));
        }
    }

    @Override
    public String toString(Assignment<Exam, ExamPlacement> assignment) {
        return "iDC:" + sDoubleFormat.format(this.getValue(assignment));
    }
}

