/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.exam;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cpsolver.exam.model.Exam;
import org.cpsolver.exam.model.ExamModel;
import org.cpsolver.exam.model.ExamPlacement;
import org.cpsolver.exam.model.ExamRoom;
import org.cpsolver.exam.model.ExamRoomPlacement;
import org.cpsolver.exam.model.ExamStudent;
import org.cpsolver.ifs.assignment.DefaultSingleAssignment;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.Progress;
import org.cpsolver.ifs.util.ToolBox;
import org.dom4j.io.SAXReader;

public class MistaTables {
    private static Logger sLog = LogManager.getLogger(MistaTables.class);
    private static DecimalFormat sNF = new DecimalFormat("###,##0", new DecimalFormatSymbols(Locale.US));
    private static DecimalFormat sDF = new DecimalFormat("###,##0.000", new DecimalFormatSymbols(Locale.US));

    public static void main(String[] args) {
        try {
            ToolBox.configureLogging();
            DataProperties config = new DataProperties();
            Table[] tables = new Table[]{new Problems(), new Rooms()};
            for (int i = 0; i < args.length; ++i) {
                File file = new File(args[i]);
                sLog.info("Loading " + file);
                ExamModel model = new ExamModel(config);
                DefaultSingleAssignment<Exam, ExamPlacement> assignment = new DefaultSingleAssignment<Exam, ExamPlacement>();
                model.load(new SAXReader().read(file), assignment);
                String name = file.getName();
                if (name.contains(".")) {
                    name = name.substring(0, name.indexOf(46));
                }
                for (Table table : tables) {
                    table.add(name, model);
                }
                Progress.removeInstance(model);
            }
            sLog.info("Saving tables...");
            File output = new File("tables");
            output.mkdir();
            for (Table table : tables) {
                table.save(output);
            }
            sLog.info("All done.");
        }
        catch (Exception e) {
            sLog.error(e.getMessage(), (Throwable)e);
        }
    }

    public static class Rooms
    extends Table {
        @Override
        public void add(String problem, ExamModel model) {
            int i;
            int[] sizes = new int[]{0, 100, 200, 400, 600};
            int[] nrRooms = new int[]{0, 0, 0, 0, 0};
            int[] nrRoomsAlt = new int[]{0, 0, 0, 0, 0};
            int[] nrExams = new int[]{0, 0, 0, 0, 0};
            int[] nrExamsAlt = new int[]{0, 0, 0, 0, 0};
            double[] density = new double[]{0.0, 0.0, 0.0, 0.0, 0.0};
            HashSet<ExamRoom> rooms = new HashSet<ExamRoom>();
            for (Exam exam : model.variables()) {
                for (ExamRoomPlacement room : exam.getRoomPlacements()) {
                    if (!rooms.add(room.getRoom())) continue;
                    for (int i2 = 0; i2 < sizes.length; ++i2) {
                        if (room.getRoom().getSize() >= sizes[i2]) {
                            int n = i2;
                            nrRooms[n] = nrRooms[n] + 1;
                        }
                        if (room.getRoom().getAltSize() < sizes[i2]) continue;
                        int n = i2;
                        nrRoomsAlt[n] = nrRoomsAlt[n] + 1;
                    }
                }
                for (int i3 = 0; i3 < sizes.length; ++i3) {
                    if (exam.getSize() < sizes[i3]) continue;
                    int n = i3;
                    nrExams[n] = nrExams[n] + 1;
                    if (exam.hasAltSeating()) {
                        int n2 = i3;
                        nrExamsAlt[n2] = nrExamsAlt[n2] + 1;
                    }
                    for (Exam x : exam.getStudentCorrelatedExams()) {
                        if (x.getSize() < sizes[i3]) continue;
                        int n3 = i3;
                        density[n3] = density[n3] + 1.0;
                    }
                }
            }
            for (i = 0; i < sizes.length; ++i) {
                this.add(problem, "Rooms" + (sizes[i] == 0 ? "" : " (\u2265 " + sizes[i] + " seats)"), sNF.format(nrRooms[i]) + (sizes[i] == 0 ? "" : " (" + sNF.format(nrRoomsAlt[i]) + ")"));
            }
            for (i = 0; i < sizes.length; ++i) {
                this.add(problem, "Exams" + (sizes[i] == 0 ? "" : " (\u2265 " + sizes[i] + " seats)"), sNF.format(nrExams[i]) + (sizes[i] == 0 ? "" : " (" + sNF.format(nrExamsAlt[i]) + ")"));
            }
            for (i = 0; i < sizes.length; ++i) {
                this.add(problem, "Density" + (sizes[i] == 0 ? "" : " (\u2265 " + sizes[i] + " seats)"), sDF.format(100.0 * density[i] / (double)(nrExams[i] * (nrExams[i] - 1))) + "%");
            }
        }
    }

    public static class Problems
    extends Table {
        @Override
        public void add(String problem, ExamModel model) {
            int enrollments = 0;
            for (ExamStudent student : model.getStudents()) {
                enrollments += student.variables().size();
            }
            int examSeating = 0;
            int examsFixedInTime = 0;
            int examsFixedInRoom = 0;
            int examsLarge = 0;
            int examsToSplit = 0;
            int examsWithOriginalRoom = 0;
            Counter avgPeriods = new Counter();
            Counter avgRooms = new Counter();
            Counter avgBigRooms = new Counter();
            double density = 0.0;
            for (Exam exam : model.variables()) {
                if (exam.hasAltSeating()) {
                    ++examSeating;
                }
                if (exam.getPeriodPlacements().size() <= 2) {
                    ++examsFixedInTime;
                }
                if (exam.getRoomPlacements().size() <= 2) {
                    ++examsFixedInRoom;
                }
                for (ExamRoomPlacement room : exam.getRoomPlacements()) {
                    if (room.getPenalty() >= -2) continue;
                    ++examsWithOriginalRoom;
                    break;
                }
                int bigEnoughRooms = 0;
                for (ExamRoomPlacement room : exam.getRoomPlacements()) {
                    if (room.getSize(exam.hasAltSeating()) < exam.getSize()) continue;
                    ++bigEnoughRooms;
                }
                if (bigEnoughRooms == 0) {
                    ++examsToSplit;
                }
                if (exam.getSize() >= 600) {
                    ++examsLarge;
                }
                avgPeriods.inc(exam.getPeriodPlacements().size());
                avgRooms.inc(exam.getRoomPlacements().size());
                avgBigRooms.inc(bigEnoughRooms);
                density += (double)exam.nrStudentCorrelatedExams();
            }
            this.add(problem, "Exams", model.variables().size());
            this.add(problem, "   with exam seating", examSeating);
            this.add(problem, "Students", model.getStudents().size());
            this.add(problem, "Enrollments", enrollments);
            this.add(problem, "Distribution constraints", model.getDistributionConstraints().size());
            this.add(problem, "Exams fixed in time", examsFixedInTime);
            this.add(problem, "Exams fixed in room", examsFixedInRoom);
            this.add(problem, "Large exams (600+)", examsLarge);
            this.add(problem, "Exams needing a room split", examsToSplit);
            this.add(problem, "Exams with original room", examsWithOriginalRoom);
            this.add(problem, "Density", sDF.format(100.0 * density / (double)(model.variables().size() * (model.variables().size() - 1))) + "%");
            this.add(problem, "Average periods", avgPeriods);
            this.add(problem, "Average rooms", avgRooms);
            this.add(problem, "   that are big enough", avgBigRooms);
        }
    }

    public static abstract class Table {
        private List<String> iProblems = new ArrayList<String>();
        private List<String> iProperties = new ArrayList<String>();
        private Map<String, Map<String, String>> iData = new HashMap<String, Map<String, String>>();

        public abstract void add(String var1, ExamModel var2);

        protected void add(String problem, String property, int value) {
            this.add(problem, property, sNF.format(value));
        }

        protected void add(String problem, String property, double value) {
            this.add(problem, property, sDF.format(value));
        }

        protected void add(String problem, String property, Counter value) {
            this.add(problem, property, sDF.format(value.avg()) + " \u00b1 " + sDF.format(value.rms()));
        }

        protected void add(String problem, String property, String value) {
            Map<String, String> table;
            if (!this.iProblems.contains(problem)) {
                this.iProblems.add(problem);
            }
            if (!this.iProperties.contains(property)) {
                this.iProperties.add(property);
            }
            if ((table = this.iData.get(problem)) == null) {
                table = new HashMap<String, String>();
                this.iData.put(problem, table);
            }
            table.put(property, value);
        }

        public void save(File folder) throws IOException {
            PrintWriter pw = new PrintWriter(new File(folder, this.getClass().getSimpleName() + ".csv"));
            pw.print("Problem");
            for (String problem : this.iProblems) {
                pw.print(",\"" + problem + "\"");
            }
            pw.println();
            for (String property : this.iProperties) {
                pw.print("\"" + property + "\"");
                for (String problem : this.iProblems) {
                    String value = this.iData.get(problem).get(property);
                    pw.print("," + (value == null ? "" : "\"" + value + "\""));
                }
                pw.println();
            }
            pw.flush();
            pw.close();
        }
    }

    public static class Counter {
        private double iTotal = 0.0;
        private double iMin = 0.0;
        private double iMax = 0.0;
        private double iTotalSquare = 0.0;
        private int iCount = 0;

        public void inc(double value) {
            if (this.iCount == 0) {
                this.iTotal = value;
                this.iMin = value;
                this.iMax = value;
                this.iTotalSquare = value * value;
            } else {
                this.iTotal += value;
                this.iMin = Math.min(this.iMin, value);
                this.iMax = Math.max(this.iMax, value);
                this.iTotalSquare += value * value;
            }
            ++this.iCount;
        }

        public int count() {
            return this.iCount;
        }

        public double sum() {
            return this.iTotal;
        }

        public double min() {
            return this.iMin;
        }

        public double max() {
            return this.iMax;
        }

        public double rms() {
            return this.iCount == 0 ? 0.0 : Math.sqrt(this.iTotalSquare / (double)this.iCount) - Math.abs(this.avg());
        }

        public double avg() {
            return this.iCount == 0 ? 0.0 : this.iTotal / (double)this.iCount;
        }

        public String toString() {
            return sDF.format(this.sum()) + " (min: " + sDF.format(this.min()) + ", max: " + sDF.format(this.max()) + ", avg: " + sDF.format(this.avg()) + ", rms: " + sDF.format(this.rms()) + ", cnt: " + this.count() + ")";
        }
    }
}

