/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.coursett.heuristics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.TimetableModel;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.extension.Extension;
import org.cpsolver.ifs.extension.MacPropagation;
import org.cpsolver.ifs.heuristics.VariableSelection;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.ToolBox;

public class LectureSelection
implements VariableSelection<Lecture, Placement> {
    private double iRandomWalkProb;
    private double iDomainSizeWeight;
    private double iGoodValuesWeight;
    private double iConstraintsWeight;
    private double iInitialAssignmentWeight;
    private boolean iRouletteWheelSelection;
    private boolean iUnassignWhenNotGood;
    private boolean iSubSetSelection;
    private double iSelectionSubSetPart;
    private int iSelectionSubSetMinSize;
    private boolean iInteractiveMode;
    private boolean iRW = false;
    private boolean iMPP = false;
    private MacPropagation<Lecture, Placement> iProp = null;
    private int iTabuSize = 0;
    private ArrayList<Lecture> iTabu = null;
    private int iTabuPos = 0;

    public LectureSelection(DataProperties properties) {
        this.iRouletteWheelSelection = properties.getPropertyBoolean("Lecture.RouletteWheelSelection", true);
        this.iUnassignWhenNotGood = properties.getPropertyBoolean("Lecture.UnassignWhenNotGood", false);
        this.iRW = properties.getPropertyBoolean("General.RandomWalk", true);
        this.iRandomWalkProb = !this.iRW ? 0.0 : properties.getPropertyDouble("Lecture.RandomWalkProb", 1.0);
        this.iGoodValuesWeight = properties.getPropertyDouble("Lecture.GoodValueProb", 1.0);
        this.iDomainSizeWeight = properties.getPropertyDouble("Lecture.DomainSizeWeight", 30.0);
        this.iInteractiveMode = properties.getPropertyBoolean("General.InteractiveMode", false);
        this.iConstraintsWeight = properties.getPropertyDouble("Lecture.NrConstraintsWeight", 0.0);
        this.iMPP = properties.getPropertyBoolean("General.MPP", false);
        this.iInitialAssignmentWeight = !this.iMPP ? 0.0 : properties.getPropertyDouble("Lecture.InitialAssignmentWeight", 20.0);
        this.iSubSetSelection = properties.getPropertyBoolean("Lecture.SelectionSubSet", true);
        this.iSelectionSubSetMinSize = properties.getPropertyInt("Lecture.SelectionSubSetMinSize", 10);
        this.iSelectionSubSetPart = properties.getPropertyDouble("Lecture.SelectionSubSetPart", 0.2);
        this.iTabuSize = properties.getPropertyInt("Lecture.TabuSize", 20);
        if (this.iTabuSize > 0) {
            this.iTabu = new ArrayList(this.iTabuSize);
        }
    }

    @Override
    public void init(Solver<Lecture, Placement> solver) {
        for (Extension<Lecture, Placement> extension : solver.getExtensions()) {
            if (!MacPropagation.class.isInstance(extension)) continue;
            this.iProp = (MacPropagation)extension;
        }
    }

    @Override
    public Lecture selectVariable(Solution<Lecture, Placement> solution) {
        Lecture selectedVariable;
        TimetableModel model = (TimetableModel)solution.getModel();
        Assignment<Lecture, Placement> assignment = solution.getAssignment();
        Collection<Lecture> unassignedVariables = model.unassignedVariables(assignment);
        if (this.iInteractiveMode) {
            unassignedVariables = new ArrayList<Lecture>(unassignedVariables.size());
            for (Lecture variable : model.unassignedVariables(assignment)) {
                if (variable.values(solution.getAssignment()).isEmpty()) continue;
                unassignedVariables.add(variable);
            }
        }
        if (unassignedVariables.isEmpty()) {
            Collection<Lecture> variables = model.perturbVariables(assignment);
            if (variables.isEmpty()) {
                variables = model.assignedVariables(assignment);
            }
            if (this.iRW && ToolBox.random() <= this.iRandomWalkProb) {
                return ToolBox.random(variables);
            }
            ArrayList<Lecture> selectionVariables = new ArrayList<Lecture>();
            double worstValue = 0.0;
            for (Lecture selectedVariable2 : this.iSubSetSelection ? ToolBox.subSet(variables, this.iSelectionSubSetPart, this.iSelectionSubSetMinSize) : variables) {
                if (this.iTabu != null && this.iTabu.contains(selectedVariable2)) continue;
                double value = assignment.getValue(selectedVariable2).toDouble(assignment);
                if (selectionVariables.isEmpty() || value > worstValue) {
                    selectionVariables.clear();
                    selectionVariables.add(selectedVariable2);
                    worstValue = value;
                    continue;
                }
                if (worstValue != value) continue;
                selectionVariables.add(selectedVariable2);
            }
            Lecture selectedVariable3 = (Lecture)ToolBox.random(selectionVariables);
            if (selectedVariable3 == null) {
                selectedVariable3 = ToolBox.random(variables);
            }
            if (selectedVariable3 != null && this.iTabu != null) {
                if (this.iTabu.size() == this.iTabuPos) {
                    this.iTabu.add(selectedVariable3);
                } else {
                    this.iTabu.set(this.iTabuPos, selectedVariable3);
                }
                this.iTabuPos = (this.iTabuPos + 1) % this.iTabuSize;
            }
            return selectedVariable3;
        }
        if (ToolBox.random() <= this.iRandomWalkProb) {
            return ToolBox.random(unassignedVariables);
        }
        if (this.iProp != null && this.iUnassignWhenNotGood) {
            ArrayList<Lecture> noGoodVariables = new ArrayList<Lecture>();
            for (Lecture variable : ToolBox.subSet(unassignedVariables, this.iSelectionSubSetPart, this.iSelectionSubSetMinSize)) {
                if (!this.iProp.goodValues(assignment, variable).isEmpty()) continue;
                noGoodVariables.add(variable);
            }
            if (!noGoodVariables.isEmpty()) {
                if (ToolBox.random() < 0.02) {
                    return ToolBox.random(assignment.assignedVariables());
                }
                for (int attempt = 0; attempt < 10; ++attempt) {
                    Lecture noGoodVariable = (Lecture)ToolBox.random(noGoodVariables);
                    Placement noGoodValue = ToolBox.random(noGoodVariable.values(solution.getAssignment()));
                    if (this.iProp.noGood(assignment, noGoodValue).isEmpty()) continue;
                    return (Lecture)ToolBox.random(this.iProp.noGood(assignment, noGoodValue)).variable();
                }
            }
        }
        if (this.iRouletteWheelSelection) {
            int iMaxDomainSize = 0;
            int iMaxGoodDomainSize = 0;
            int iMaxConstraints = 0;
            Collection<Lecture> variables = this.iSubSetSelection ? ToolBox.subSet(unassignedVariables, this.iSelectionSubSetPart, this.iSelectionSubSetMinSize) : unassignedVariables;
            for (Lecture variable : variables) {
                if (this.iTabu != null && this.iTabu.contains(variable)) continue;
                iMaxDomainSize = Math.max(iMaxDomainSize, variable.values(solution.getAssignment()).size());
                iMaxGoodDomainSize = this.iProp == null ? 0 : Math.max(iMaxGoodDomainSize, this.iProp.goodValues(assignment, variable).size());
                iMaxConstraints = Math.max(iMaxConstraints, variable.constraints().size());
            }
            ArrayList<Integer> points = new ArrayList<Integer>();
            int totalPoints = 0;
            for (Lecture variable : variables) {
                long pointsThisVariable = Math.round(this.iDomainSizeWeight * ((double)(iMaxDomainSize - variable.values(solution.getAssignment()).size()) / (double)iMaxDomainSize) + (this.iProp == null ? 0.0 : this.iGoodValuesWeight * ((double)(iMaxGoodDomainSize - this.iProp.goodValues(assignment, variable).size()) / (double)iMaxGoodDomainSize)) + this.iConstraintsWeight * ((double)(iMaxConstraints - variable.constraints().size()) / (double)iMaxConstraints) + this.iInitialAssignmentWeight * (variable.getInitialAssignment() != null ? (double)model.conflictValues(assignment, variable.getInitialAssignment()).size() : 0.0));
                if (pointsThisVariable <= 0L) continue;
                totalPoints = (int)((long)totalPoints + pointsThisVariable);
                points.add(totalPoints);
            }
            if (totalPoints > 0) {
                int rndPoints = ToolBox.random(totalPoints);
                Iterator<Lecture> x = variables.iterator();
                for (int i = 0; x.hasNext() && i < points.size(); ++i) {
                    Lecture variable = x.next();
                    int tp = (Integer)points.get(i);
                    if (tp <= rndPoints) continue;
                    if (variable != null && this.iTabu != null) {
                        if (this.iTabu.size() == this.iTabuPos) {
                            this.iTabu.add(variable);
                        } else {
                            this.iTabu.set(this.iTabuPos, variable);
                        }
                        this.iTabuPos = (this.iTabuPos + 1) % this.iTabuSize;
                    }
                    return variable;
                }
            }
        } else {
            ArrayList<Lecture> selectionVariables = null;
            long bestGood = 0L;
            for (Lecture variable : ToolBox.subSet(unassignedVariables, this.iSelectionSubSetPart, this.iSelectionSubSetMinSize)) {
                if (this.iTabu != null && this.iTabu.contains(variable)) continue;
                long good = (long)(this.iDomainSizeWeight * (double)variable.values(solution.getAssignment()).size() + this.iGoodValuesWeight * (double)(this.iProp == null ? 0 : this.iProp.goodValues(assignment, variable).size()) + this.iConstraintsWeight * (double)variable.constraints().size() + this.iInitialAssignmentWeight * (variable.getInitialAssignment() != null ? (double)model.conflictValues(assignment, variable.getInitialAssignment()).size() : 0.0));
                if (selectionVariables == null || bestGood > good) {
                    if (selectionVariables == null) {
                        selectionVariables = new ArrayList<Lecture>();
                    } else {
                        selectionVariables.clear();
                    }
                    bestGood = good;
                    selectionVariables.add(variable);
                    continue;
                }
                if (good != bestGood) continue;
                selectionVariables.add(variable);
            }
            if (!selectionVariables.isEmpty()) {
                Lecture selectedVariable4 = (Lecture)ToolBox.random(selectionVariables);
                if (selectedVariable4 != null && this.iTabu != null) {
                    if (this.iTabu.size() == this.iTabuPos) {
                        this.iTabu.add(selectedVariable4);
                    } else {
                        this.iTabu.set(this.iTabuPos, selectedVariable4);
                    }
                    this.iTabuPos = (this.iTabuPos + 1) % this.iTabuSize;
                }
                return selectedVariable4;
            }
        }
        if ((selectedVariable = ToolBox.random(unassignedVariables)) != null && this.iTabu != null) {
            if (this.iTabu.size() == this.iTabuPos) {
                this.iTabu.add(selectedVariable);
            } else {
                this.iTabu.set(this.iTabuPos, selectedVariable);
            }
            this.iTabuPos = (this.iTabuPos + 1) % this.iTabuSize;
        }
        return selectedVariable;
    }
}

