/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.coursett.criteria.additional;

import java.util.Collection;
import java.util.Map;
import org.cpsolver.coursett.criteria.StudentConflict;
import org.cpsolver.coursett.criteria.additional.IgnoredCommittedStudentConflict;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.criteria.Criterion;
import org.cpsolver.ifs.util.DataProperties;

public class IgnoredStudentConflict
extends StudentConflict {
    @Override
    public boolean isApplicable(Lecture l1, Lecture l2) {
        return l1 != null && l2 != null && IgnoredStudentConflict.ignore(l1, l2) && IgnoredStudentConflict.applicable(l1, l2);
    }

    @Override
    public double getWeightDefault(DataProperties config) {
        return config.getPropertyDouble("Comparator.IgnoredStudentConflictWeight", 0.0);
    }

    @Override
    public String getPlacementSelectionWeightName() {
        return "Placement.NrIgnoredStudConfsWeight";
    }

    @Override
    public void getInfo(Assignment<Lecture, Placement> assignment, Map<String, String> info) {
        super.getInfo(assignment, info);
        double conf = this.getValue(assignment);
        if (conf > 0.0) {
            Criterion<Lecture, Placement> c = this.getModel().getCriterion(IgnoredCommittedStudentConflict.class);
            double committed = c == null ? 0.0 : c.getValue(assignment);
            info.put("Ignored student conflicts", sDoubleFormat.format(conf) + (committed > 0.0 ? " [committed: " + sDoubleFormat.format(committed) + "]" : ""));
        }
    }

    @Override
    public void getInfo(Assignment<Lecture, Placement> assignment, Map<String, String> info, Collection<Lecture> variables) {
        super.getInfo(assignment, info, variables);
        double conf = this.getValue(assignment, variables);
        if (conf > 0.0) {
            Criterion<Lecture, Placement> c = this.getModel().getCriterion(IgnoredCommittedStudentConflict.class);
            double committed = c == null ? 0.0 : c.getValue(assignment, variables);
            info.put("Ignored student conflicts", sDoubleFormat.format(conf) + (committed > 0.0 ? " [committed: " + sDoubleFormat.format(committed) + "]" : ""));
        }
    }
}

