/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.coursett.constraint;

import java.util.BitSet;
import java.util.Set;
import org.cpsolver.coursett.Constants;
import org.cpsolver.coursett.constraint.InstructorConstraint;
import org.cpsolver.coursett.criteria.additional.InstructorConflict;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.ifs.assignment.Assignment;

public class SoftInstructorConstraint
extends InstructorConstraint {
    public SoftInstructorConstraint(Long id, String puid, String name, boolean ignDist) {
        super(id, puid, name, ignDist);
    }

    @Override
    public void computeConflicts(Assignment<Lecture, Placement> assignment, Placement placement, Set<Placement> conflicts) {
    }

    @Override
    public boolean inConflict(Assignment<Lecture, Placement> assignment, Placement placement) {
        return false;
    }

    @Override
    public boolean isConsistent(Placement p1, Placement p2) {
        return true;
    }

    @Override
    public boolean isHard() {
        return false;
    }

    @Override
    public InstructorConstraint.InstructorConstraintContext createAssignmentContext(Assignment<Lecture, Placement> assignment) {
        return new SoftInstructorConstraintContext(assignment);
    }

    public int getConflicts(Assignment<Lecture, Placement> assignment) {
        return ((SoftInstructorConstraintContext)this.getContext((Assignment)assignment)).getConflicts();
    }

    public int getConflicts(Assignment<Lecture, Placement> assignment, Placement placement) {
        if (((SoftInstructorConstraintContext)this.getContext((Assignment)assignment)).inConflict(assignment, placement)) {
            return 1;
        }
        return 0;
    }

    public int getWorstConflicts() {
        if (this.variables().size() < 2) {
            return 0;
        }
        return this.variables().size() - 1;
    }

    public class SoftInstructorConstraintContext
    extends InstructorConstraint.InstructorConstraintContext {
        private int iConficts;

        public SoftInstructorConstraintContext(Assignment<Lecture, Placement> assignment) {
            super(SoftInstructorConstraint.this, assignment);
            this.iConficts = 0;
            this.iConficts = this.countConflicts(assignment);
            SoftInstructorConstraint.this.getModel().getCriterion(InstructorConflict.class).inc(assignment, this.iConficts);
        }

        @Override
        public void assigned(Assignment<Lecture, Placement> assignment, Placement placement) {
            super.assigned(assignment, placement);
            SoftInstructorConstraint.this.getModel().getCriterion(InstructorConflict.class).inc(assignment, -this.iConficts);
            this.iConficts = this.countConflicts(assignment);
            SoftInstructorConstraint.this.getModel().getCriterion(InstructorConflict.class).inc(assignment, this.iConficts);
        }

        @Override
        public void unassigned(Assignment<Lecture, Placement> assignment, Placement placement) {
            super.unassigned(assignment, placement);
            SoftInstructorConstraint.this.getModel().getCriterion(InstructorConflict.class).inc(assignment, -this.iConficts);
            this.iConficts = this.countConflicts(assignment);
            SoftInstructorConstraint.this.getModel().getCriterion(InstructorConflict.class).inc(assignment, this.iConficts);
        }

        public int getConflicts() {
            return this.iConficts;
        }

        protected int countConflicts(Assignment<Lecture, Placement> assignment) {
            int conflicts = 0;
            for (Lecture lecture : SoftInstructorConstraint.this.variables()) {
                Placement placement = assignment.getValue(lecture);
                if (placement == null || !this.inConflict(assignment, placement)) continue;
                ++conflicts;
            }
            return conflicts;
        }

        public boolean inConflict(Assignment<Lecture, Placement> assignment, Placement placement) {
            Lecture lecture = (Lecture)placement.variable();
            Placement current = assignment.getValue(lecture);
            BitSet weekCode = placement.getTimeLocation().getWeekCode();
            if (!SoftInstructorConstraint.this.isAvailable(lecture, placement)) {
                return true;
            }
            TimeLocation.IntEnumeration e = placement.getTimeLocation().getSlots();
            while (e.hasMoreElements()) {
                int slot = (Integer)e.nextElement();
                for (Placement p : this.getPlacements(slot)) {
                    if (p.equals(current) || !p.getTimeLocation().shareWeeks(weekCode) || p.canShareRooms(placement) && p.sameRooms(placement)) continue;
                    return true;
                }
            }
            if (!SoftInstructorConstraint.this.isIgnoreDistances()) {
                e = placement.getTimeLocation().getStartSlots();
                while (e.hasMoreElements()) {
                    int nextSlot;
                    int startSlot = (Integer)e.nextElement();
                    int prevSlot = startSlot - 1;
                    if (prevSlot >= 0 && prevSlot / 288 == startSlot / 288) {
                        for (Placement placement2 : this.getPlacements(prevSlot, placement)) {
                            if (lecture.equals(placement2.variable()) || placement2.canShareRooms(placement) && placement2.sameRooms(placement) || !(Placement.getDistanceInMeters(SoftInstructorConstraint.this.getDistanceMetric(), placement, placement2) > SoftInstructorConstraint.this.getDistanceMetric().getInstructorProhibitedLimit())) continue;
                            return true;
                        }
                    }
                    if ((nextSlot = startSlot + placement.getTimeLocation().getLength()) / 288 == startSlot / 288) {
                        for (Placement c2 : this.getPlacements(nextSlot, placement)) {
                            if (lecture.equals(c2.variable()) || c2.canShareRooms(placement) && c2.sameRooms(placement) || !(Placement.getDistanceInMeters(SoftInstructorConstraint.this.getDistanceMetric(), placement, c2) > SoftInstructorConstraint.this.getDistanceMetric().getInstructorProhibitedLimit())) continue;
                            return true;
                        }
                    }
                    if (!SoftInstructorConstraint.this.getDistanceMetric().doComputeDistanceConflictsBetweenNonBTBClasses()) continue;
                    TimeLocation timeLocation = placement.getTimeLocation();
                    for (Lecture other : SoftInstructorConstraint.this.variables()) {
                        Placement otherPlacement = assignment.getValue(other);
                        if (otherPlacement == null || other.equals(placement.variable())) continue;
                        TimeLocation t2 = otherPlacement.getTimeLocation();
                        if (timeLocation == null || t2 == null || !timeLocation.shareDays(t2) || !timeLocation.shareWeeks(t2) || !(timeLocation.getStartSlot() + timeLocation.getLength() < t2.getStartSlot() ? Placement.getDistanceInMinutes(SoftInstructorConstraint.this.getDistanceMetric(), placement, otherPlacement) > timeLocation.getBreakTime() + Constants.SLOT_LENGTH_MIN * (t2.getStartSlot() - timeLocation.getStartSlot() - timeLocation.getLength()) : t2.getStartSlot() + t2.getLength() < timeLocation.getStartSlot() && Placement.getDistanceInMinutes(SoftInstructorConstraint.this.getDistanceMetric(), placement, otherPlacement) > t2.getBreakTime() + Constants.SLOT_LENGTH_MIN * (timeLocation.getStartSlot() - t2.getStartSlot() - t2.getLength()))) continue;
                        return true;
                    }
                }
            }
            return false;
        }
    }
}

