/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.coursett;

public class Constants
extends org.cpsolver.ifs.Constants {
    public static final int SLOTS_PER_DAY = 288;
    public static int[] DAY_CODES = new int[]{64, 32, 16, 8, 4, 2, 1};
    public static int DAY_CODE_ALL = 127;
    public static int DAY_CODE_WEEK = 124;
    public static int SLOT_LENGTH_MIN = 5;
    public static int FIRST_SLOT_TIME_MIN = 0;
    public static int DAY_SLOTS_FIRST = 90;
    public static int DAY_SLOTS_LAST = 209;
    public static int SLOTS_PER_DAY_NO_EVENINGS = DAY_SLOTS_LAST - DAY_SLOTS_FIRST + 1;
    public static String[] DAY_NAMES_SHORT = new String[]{"M", "T", "W", "Th", "F", "S", "Su"};
    public static int NR_DAYS = DAY_CODES.length;
    public static int NR_DAYS_WEEK = 5;
    public static final String sPreferenceProhibited = "P";
    public static final String sPreferenceRequired = "R";
    public static final String sPreferenceStronglyDiscouraged = "2";
    public static final String sPreferenceDiscouraged = "1";
    public static final String sPreferencePreferred = "-1";
    public static final String sPreferenceStronglyPreferred = "-2";
    public static final String sPreferenceNeutral = "0";
    public static int sPreferenceLevelProhibited = 100;
    public static int sPreferenceLevelRequired = -100;
    public static int sPreferenceLevelStronglyDiscouraged = 4;
    public static int sPreferenceLevelDiscouraged = 1;
    public static int sPreferenceLevelPreferred = -1;
    public static int sPreferenceLevelStronglyPreferred = -4;
    public static int sPreferenceLevelNeutral = 0;

    public static int preference2preferenceLevel(String prologPref) {
        if (sPreferenceRequired.equals(prologPref)) {
            return sPreferenceLevelRequired;
        }
        if (sPreferenceStronglyPreferred.equals(prologPref)) {
            return sPreferenceLevelStronglyPreferred;
        }
        if (sPreferencePreferred.equals(prologPref)) {
            return sPreferenceLevelPreferred;
        }
        if (sPreferenceDiscouraged.equals(prologPref)) {
            return sPreferenceLevelDiscouraged;
        }
        if (sPreferenceStronglyDiscouraged.equals(prologPref)) {
            return sPreferenceLevelStronglyDiscouraged;
        }
        if (sPreferenceProhibited.equals(prologPref)) {
            return sPreferenceLevelProhibited;
        }
        return sPreferenceLevelNeutral;
    }

    public static String preferenceLevel2preference(int intPref) {
        if (intPref >= sPreferenceLevelProhibited / 2) {
            return sPreferenceProhibited;
        }
        if (intPref >= sPreferenceLevelStronglyDiscouraged) {
            return sPreferenceStronglyDiscouraged;
        }
        if (intPref > sPreferenceLevelNeutral) {
            return sPreferenceDiscouraged;
        }
        if (intPref <= sPreferenceLevelRequired / 2) {
            return sPreferenceRequired;
        }
        if (intPref <= sPreferenceLevelStronglyPreferred) {
            return sPreferenceStronglyPreferred;
        }
        if (intPref < sPreferenceLevelNeutral) {
            return sPreferencePreferred;
        }
        return sPreferenceNeutral;
    }

    public static int time2slot(int hour, int min) {
        return (hour * 60 + min - FIRST_SLOT_TIME_MIN) / SLOT_LENGTH_MIN;
    }
}

