/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.util.duration;

import java.util.Iterator;
import org.unitime.timetable.gwt.server.DayCode;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.TimePattern;
import org.unitime.timetable.util.duration.MinutesPerWeek;

public class SemesterMinutes
extends MinutesPerWeek {
    public SemesterMinutes(String parameter) {
        super(parameter);
    }

    @Override
    public boolean isValidCombination(int semesterMinutes, DatePattern datePattern, TimePattern timePattern) {
        if (datePattern == null) {
            return false;
        }
        if (timePattern.isExactTime()) {
            return true;
        }
        if (datePattern.isPatternSet()) {
            for (DatePattern child : datePattern.findChildren()) {
                if (!this.isValidCombination(semesterMinutes, child, timePattern)) continue;
                return true;
            }
            return false;
        }
        return (float)semesterMinutes == datePattern.getEffectiveNumberOfWeeks() * (float)timePattern.getNrMeetings().intValue() * (float)timePattern.getMinPerMtg().intValue();
    }

    @Override
    public int getExactTimeMinutesPerMeeting(int semesterMinutes, DatePattern datePattern, int dayCode) {
        Iterator<DatePattern> iterator;
        if (datePattern == null) {
            return 0;
        }
        if (datePattern.isPatternSet() && (iterator = datePattern.findChildren().iterator()).hasNext()) {
            DatePattern child = iterator.next();
            return Math.round((float)semesterMinutes / ((float)DayCode.nrDays(dayCode) * child.getEffectiveNumberOfWeeks()));
        }
        return Math.round((float)semesterMinutes / ((float)DayCode.nrDays(dayCode) * datePattern.getEffectiveNumberOfWeeks()));
    }

    @Override
    public Integer getArrangedHours(int semesterMinutes, DatePattern datePattern) {
        Iterator<DatePattern> iterator;
        if (semesterMinutes <= 0 || datePattern == null) {
            return null;
        }
        if (datePattern.isPatternSet() && (iterator = datePattern.findChildren().iterator()).hasNext()) {
            DatePattern child = iterator.next();
            return Math.round((float)semesterMinutes / (50.0f * child.getEffectiveNumberOfWeeks()));
        }
        return Math.round((float)semesterMinutes / (50.0f * datePattern.getEffectiveNumberOfWeeks()));
    }
}

