/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.util;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.URLEncoder;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.interfaces.RoomUrlProvider;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.NonUniversityLocation;
import org.unitime.timetable.model.Room;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.onlinesectioning.AcademicSessionInfo;
import org.unitime.timetable.onlinesectioning.custom.ExternalTermProvider;

public class DefaultRoomUrlProvider
implements RoomUrlProvider {
    private static final long serialVersionUID = 8009417407983850965L;
    private transient ExternalTermProvider iExternalTermProvider = null;

    protected String replaceExternal(String url, Session session) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, ClassNotFoundException, UnsupportedEncodingException {
        if (url == null) {
            return null;
        }
        if (url.contains(":xterm") || url.contains(":xcampus")) {
            if (this.iExternalTermProvider == null) {
                String clazz = ApplicationProperty.CustomizationExternalTerm.value();
                if (clazz == null || clazz.isEmpty()) {
                    return url;
                }
                this.iExternalTermProvider = (ExternalTermProvider)Class.forName(clazz).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            AcademicSessionInfo info = new AcademicSessionInfo(session);
            return this.replace(url, ":xterm", this.iExternalTermProvider.getExternalTerm(info), ":xcampus", this.iExternalTermProvider.getExternalCampus(info));
        }
        return url;
    }

    protected String replaceParameter(String url, String parameter, String value) throws UnsupportedEncodingException {
        if (url == null) {
            return null;
        }
        if (url.contains(parameter)) {
            if (value == null) {
                return null;
            }
            return url.replace(parameter, URLEncoder.encode(value, "utf-8"));
        }
        return url;
    }

    protected String replace(String url, String ... params) throws UnsupportedEncodingException {
        for (int i = 0; i < params.length && url != null; i += 2) {
            url = this.replaceParameter(url, params[i], params[i + 1]);
        }
        return url;
    }

    @Override
    public String getRoomUrl(Location location) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, ClassNotFoundException, UnsupportedEncodingException {
        if (location instanceof Room) {
            String url = ApplicationProperty.DefaultRoomUrlRoom.value();
            if (url == null || url.isEmpty()) {
                return null;
            }
            Room room = (Room)location;
            Session session = room.getSession();
            return this.replaceExternal(this.replace(url, ":year", session.getAcademicYear(), ":term", session.getAcademicTerm(), ":campus", session.getAcademicInitiative(), ":building", room.getBuildingAbbv(), ":roomNbr", room.getRoomNumber(), ":name", room.getLabel(), ":roomId", room.getExternalUniqueId(), ":id", room.getExternalUniqueId(), ":buildingId", room.getBuilding().getExternalUniqueId()), session);
        }
        if (location instanceof NonUniversityLocation) {
            String url = ApplicationProperty.DefaultRoomUrlLoncation.value();
            if (url == null || url.isEmpty()) {
                return null;
            }
            NonUniversityLocation room = (NonUniversityLocation)location;
            Session session = room.getSession();
            return this.replaceExternal(this.replace(url, ":year", session.getAcademicYear(), ":term", session.getAcademicTerm(), ":campus", session.getAcademicInitiative(), ":name", room.getLabel(), ":id", room.getExternalUniqueId()), session);
        }
        return null;
    }
}

