/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.util;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.hibernate.Transaction;
import org.hibernate.boot.Metadata;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.unitime.commons.hibernate.util.HibernateUtil;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.model.ArrangeCreditUnitConfig;
import org.unitime.timetable.model.Building;
import org.unitime.timetable.model.BuildingPref;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseCatalog;
import org.unitime.timetable.model.CourseCreditUnitConfig;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.CourseSubpartCredit;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.DatePatternPref;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentRoomFeature;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.DistributionObject;
import org.unitime.timetable.model.DistributionPref;
import org.unitime.timetable.model.DistributionType;
import org.unitime.timetable.model.EventServiceProvider;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.ExternalBuilding;
import org.unitime.timetable.model.ExternalRoom;
import org.unitime.timetable.model.ExternalRoomDepartment;
import org.unitime.timetable.model.ExternalRoomFeature;
import org.unitime.timetable.model.FixedCreditUnitConfig;
import org.unitime.timetable.model.GlobalRoomFeature;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.InstructorAttribute;
import org.unitime.timetable.model.LearningManagementSystemInfo;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.NonUniversityLocation;
import org.unitime.timetable.model.NonUniversityLocationPicture;
import org.unitime.timetable.model.OverrideType;
import org.unitime.timetable.model.PreferenceGroup;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.Room;
import org.unitime.timetable.model.RoomDept;
import org.unitime.timetable.model.RoomFeature;
import org.unitime.timetable.model.RoomFeaturePref;
import org.unitime.timetable.model.RoomFeatureType;
import org.unitime.timetable.model.RoomGroup;
import org.unitime.timetable.model.RoomGroupPref;
import org.unitime.timetable.model.RoomPicture;
import org.unitime.timetable.model.RoomPref;
import org.unitime.timetable.model.RoomTypeOption;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.SessionConfig;
import org.unitime.timetable.model.SolverGroup;
import org.unitime.timetable.model.StandardEventNote;
import org.unitime.timetable.model.StandardEventNoteDepartment;
import org.unitime.timetable.model.StandardEventNoteSession;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.TimePattern;
import org.unitime.timetable.model.TimePref;
import org.unitime.timetable.model.TimetableManager;
import org.unitime.timetable.model.TravelTime;
import org.unitime.timetable.model.VariableFixedCreditUnitConfig;
import org.unitime.timetable.model.VariableRangeCreditUnitConfig;
import org.unitime.timetable.model.base.BaseCourseSubpartCredit;
import org.unitime.timetable.model.base.BaseDatePattern;
import org.unitime.timetable.model.base.BaseExternalRoom;
import org.unitime.timetable.model.base.BaseNonUniversityLocation;
import org.unitime.timetable.model.base.BaseRoom;
import org.unitime.timetable.model.base.BaseRoomFeature;
import org.unitime.timetable.model.base.BaseRoomGroup;
import org.unitime.timetable.model.base.BaseStandardEventNoteDepartment;
import org.unitime.timetable.model.comparators.ClassComparator;
import org.unitime.timetable.model.comparators.InstrOfferingConfigComparator;
import org.unitime.timetable.model.comparators.SchedulingSubpartComparator;
import org.unitime.timetable.model.dao.BuildingDAO;
import org.unitime.timetable.model.dao.Class_DAO;
import org.unitime.timetable.model.dao.CourseCatalogDAO;
import org.unitime.timetable.model.dao.CourseOfferingDAO;
import org.unitime.timetable.model.dao.DatePatternDAO;
import org.unitime.timetable.model.dao.DepartmentDAO;
import org.unitime.timetable.model.dao.DepartmentRoomFeatureDAO;
import org.unitime.timetable.model.dao.DepartmentalInstructorDAO;
import org.unitime.timetable.model.dao.DistributionPrefDAO;
import org.unitime.timetable.model.dao.DistributionTypeDAO;
import org.unitime.timetable.model.dao.GlobalRoomFeatureDAO;
import org.unitime.timetable.model.dao.InstrOfferingConfigDAO;
import org.unitime.timetable.model.dao.InstructionalOfferingDAO;
import org.unitime.timetable.model.dao.InstructorAttributeDAO;
import org.unitime.timetable.model.dao.LearningManagementSystemInfoDAO;
import org.unitime.timetable.model.dao.LocationDAO;
import org.unitime.timetable.model.dao.NonUniversityLocationDAO;
import org.unitime.timetable.model.dao.NonUniversityLocationPictureDAO;
import org.unitime.timetable.model.dao.RoomDAO;
import org.unitime.timetable.model.dao.RoomDeptDAO;
import org.unitime.timetable.model.dao.RoomFeatureDAO;
import org.unitime.timetable.model.dao.RoomFeatureTypeDAO;
import org.unitime.timetable.model.dao.RoomGroupDAO;
import org.unitime.timetable.model.dao.RoomPictureDAO;
import org.unitime.timetable.model.dao.SchedulingSubpartDAO;
import org.unitime.timetable.model.dao.SessionConfigDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.model.dao.SolverGroupDAO;
import org.unitime.timetable.model.dao.SubjectAreaDAO;
import org.unitime.timetable.model.dao.TimePatternDAO;
import org.unitime.timetable.model.dao.TimetableManagerDAO;
import org.unitime.timetable.model.dao.TravelTimeDAO;
import org.unitime.timetable.util.LocationPermIdGenerator;
import org.unitime.timetable.util.SessionRollForward;

public class AcademicSessionMerge {
    protected static final GwtMessages MESSAGES = Localization.create(GwtMessages.class);
    private SessionRollForward iSessionRollForward;
    private Log iLog;
    private RoomFeatureType iCampusRoomFeatureType;
    private HashMap<String, GlobalRoomFeature> iPrefixRoomFeatureMap = new HashMap();
    private HashMap<Object, Set<Location>> iRoomList;
    private Session iMergedSession;
    private Session iPrimarySession;
    private Session iSecondarySession;
    private boolean iUseCampusPrefixForDepartments;
    private boolean iUseCampusPrefixForSubjectAreas;
    private String iPrefixSeparator;
    private HashMap<String, String> iDepartmentCodesWithDifferentPrefix;
    private boolean iResetClassSuffix;
    private HashMap<String, HashMap<String, Long>> dbColumnLengths = new HashMap();
    private HashMap<Long, HashSet<String>> iOfferingPrefixesCache = new HashMap();

    public AcademicSessionMerge(Long mergedSessionId, Long primarySessionId, Long secondarySessionId, boolean useCampusPrefixForDepartments, boolean useCampusPrefixForSubjectAreas, String prefixSeparator, String primarySessionDefaultPrefix, String secondarySessionDefaultPrefix, HashMap<String, String> departmentCodesWithDifferentPrefix, String classPrefsAction, String subpartLocationPrefsAction, String subpartTimePrefsAction, boolean mergeWaitListsProhibitedOverrides, SessionRollForward.DistributionMode distributionPrefMode, SessionRollForward.CancelledClassAction cancelledClassAction, org.hibernate.Session hibSession, Log log) {
        if (hibSession.getTransaction() != null && hibSession.getTransaction().isActive()) {
            hibSession.getTransaction().commit();
        }
        this.iUseCampusPrefixForDepartments = useCampusPrefixForDepartments;
        this.iUseCampusPrefixForSubjectAreas = useCampusPrefixForSubjectAreas;
        this.iPrefixSeparator = prefixSeparator;
        this.iDepartmentCodesWithDifferentPrefix = departmentCodesWithDifferentPrefix;
        this.iLog = log;
        this.iResetClassSuffix = ApplicationProperty.RollForwardResetClassSuffix.isTrue();
        this.initDbColumnLengths();
        try {
            log.info((Object)"Pull the departments from both sessions together into set of departments");
            this.resetHibSession(hibSession, mergedSessionId, primarySessionId, secondarySessionId);
            log.info((Object)("Copying Primary Session Departments: " + this.iPrimarySession.getLabel()));
            this.copyMergeDepartmentsToSession(this.iPrimarySession, primarySessionDefaultPrefix);
            this.resetHibSession(hibSession, mergedSessionId, primarySessionId, secondarySessionId);
            log.info((Object)("Copying Secondary Session Departments: " + this.iSecondarySession.getLabel()));
            this.copyMergeDepartmentsToSession(this.iSecondarySession, secondarySessionDefaultPrefix);
            this.resetHibSession(hibSession, mergedSessionId, primarySessionId, secondarySessionId);
            log.info((Object)"Use the session roll forward to roll use the session configuration from the primary session");
            this.copyMergeConfigurationToSession(this.iPrimarySession, primarySessionDefaultPrefix);
            log.info((Object)"Pull the timetable managers from both sessions together");
            this.resetHibSession(hibSession, mergedSessionId, primarySessionId, secondarySessionId);
            log.info((Object)("Copying Primary Session Managers: " + this.iPrimarySession.getLabel()));
            this.copyMergeTimetableManagersToSession(this.iPrimarySession, primarySessionDefaultPrefix);
            this.resetHibSession(hibSession, mergedSessionId, primarySessionId, secondarySessionId);
            log.info((Object)("Copying Secondary Session Managers: " + this.iSecondarySession.getLabel()));
            this.copyMergeTimetableManagersToSession(this.iSecondarySession, secondarySessionDefaultPrefix);
            log.info((Object)"Pull the room features from both sessions together");
            this.resetHibSession(hibSession, mergedSessionId, primarySessionId, secondarySessionId);
            log.info((Object)("Copying Primary Session Room Features: " + this.iPrimarySession.getLabel()));
            this.copyMergeRoomFeaturesToSession(this.iPrimarySession, primarySessionDefaultPrefix);
            this.resetHibSession(hibSession, mergedSessionId, primarySessionId, secondarySessionId);
            this.copyMergeRoomFeaturesToSession(this.iSecondarySession, secondarySessionDefaultPrefix);
            log.info((Object)"Pull the room groups from both sessions together");
            this.resetHibSession(hibSession, mergedSessionId, primarySessionId, secondarySessionId);
            log.info((Object)("Copying Primary Session Room Groups: " + this.iPrimarySession.getLabel()));
            this.copyMergeRoomGroupsToSession(this.iPrimarySession, primarySessionDefaultPrefix);
            this.resetHibSession(hibSession, mergedSessionId, primarySessionId, secondarySessionId);
            log.info((Object)("Copying Secondary Session Room Groups: " + this.iSecondarySession.getLabel()));
            this.copyMergeRoomGroupsToSession(this.iSecondarySession, secondarySessionDefaultPrefix);
            log.info((Object)"Pull the buildings from both sessions together");
            this.resetHibSession(hibSession, mergedSessionId, primarySessionId, secondarySessionId);
            log.info((Object)("Copying Primary Session Buildings: " + this.iPrimarySession.getLabel()));
            this.copyMergeBuildingsToSession(this.iPrimarySession);
            this.resetHibSession(hibSession, mergedSessionId, primarySessionId, secondarySessionId);
            log.info((Object)("Copying Secondary Session Buildings: " + this.iSecondarySession.getLabel()));
            this.copyMergeBuildingsToSession(this.iSecondarySession);
            log.info((Object)"Pull the locations from both sessions together");
            this.resetHibSession(hibSession, mergedSessionId, primarySessionId, secondarySessionId);
            log.info((Object)("Copying Primary Session Locations: " + this.iPrimarySession.getLabel()));
            this.copyMergeLocationsToSession(this.iPrimarySession, primarySessionDefaultPrefix);
            this.resetHibSession(hibSession, mergedSessionId, primarySessionId, secondarySessionId);
            log.info((Object)("Copying Secondary Session Locations: " + this.iSecondarySession.getLabel()));
            this.copyMergeLocationsToSession(this.iSecondarySession, secondarySessionDefaultPrefix);
            log.info((Object)"Pull the travel times from both sessions together");
            this.resetHibSession(hibSession, mergedSessionId, primarySessionId, secondarySessionId);
            log.info((Object)("Copying Primary Session Travel Times: " + this.iPrimarySession.getLabel()));
            this.copyMergeTravelTimesToSession(this.iPrimarySession);
            this.resetHibSession(hibSession, mergedSessionId, primarySessionId, secondarySessionId);
            log.info((Object)("Copying Secondary Session Travel Times: " + this.iSecondarySession.getLabel()));
            this.copyMergeTravelTimesToSession(this.iSecondarySession);
            log.info((Object)"Pull the date patterns from the primary session into the session");
            this.resetHibSession(hibSession, mergedSessionId, primarySessionId, secondarySessionId);
            log.info((Object)("Copying Primary Session Date Patterns: " + this.iPrimarySession.getLabel()));
            this.copyMergeDatePatternsToSession(this.iPrimarySession, primarySessionDefaultPrefix);
            this.resetHibSession(hibSession, mergedSessionId, primarySessionId, secondarySessionId);
            log.info((Object)"Pull the time patterns from the primary session into the session");
            this.copyMergeTimePatternsToSession(this.iPrimarySession, primarySessionDefaultPrefix);
            log.info((Object)"Pull the learning management system info from both sessions together");
            this.resetHibSession(hibSession, mergedSessionId, primarySessionId, secondarySessionId);
            log.info((Object)("Copying Primary Session Learning Management System Info: " + this.iPrimarySession.getLabel()));
            this.copyMergeLearningManagementSystemInfoToSession(this.iPrimarySession);
            this.resetHibSession(hibSession, mergedSessionId, primarySessionId, secondarySessionId);
            log.info((Object)("Copying Secondary Session Learning Management System Info: " + this.iSecondarySession.getLabel()));
            this.copyMergeLearningManagementSystemInfoToSession(this.iSecondarySession);
            log.info((Object)"Pull the subjectAreas from both sessions together");
            this.resetHibSession(hibSession, mergedSessionId, primarySessionId, secondarySessionId);
            log.info((Object)("Copying Primary Session Subject Areas: " + this.iPrimarySession.getLabel()));
            this.copyMergeSubjectAreasToSession(this.iPrimarySession, primarySessionDefaultPrefix);
            this.resetHibSession(hibSession, mergedSessionId, primarySessionId, secondarySessionId);
            log.info((Object)("Copying Secondary Session Subject Areas: " + this.iSecondarySession.getLabel()));
            this.copyMergeSubjectAreasToSession(this.iSecondarySession, secondarySessionDefaultPrefix);
            log.info((Object)"Pull the departmental instructors from both sessions together");
            this.resetHibSession(hibSession, mergedSessionId, primarySessionId, secondarySessionId);
            log.info((Object)("Copying Primary Session Departmental Instructors: " + this.iPrimarySession.getLabel()));
            this.copyMergeInstructorDataToSession(this.iPrimarySession, primarySessionDefaultPrefix);
            this.resetHibSession(hibSession, mergedSessionId, primarySessionId, secondarySessionId);
            log.info((Object)("Copying Secondary Session Departmental Instructors: " + this.iSecondarySession.getLabel()));
            this.copyMergeInstructorDataToSession(this.iSecondarySession, secondarySessionDefaultPrefix);
            log.info((Object)"Pull the courses from both sessions together");
            this.resetHibSession(hibSession, mergedSessionId, primarySessionId, secondarySessionId);
            log.info((Object)("Copying Primary Session Course Offerings: " + this.iPrimarySession.getLabel()));
            this.copyMergeCourseOfferingsToSession(this.iPrimarySession, classPrefsAction, subpartLocationPrefsAction, subpartTimePrefsAction, mergeWaitListsProhibitedOverrides, distributionPrefMode, cancelledClassAction, primarySessionDefaultPrefix);
            this.resetHibSession(hibSession, mergedSessionId, primarySessionId, secondarySessionId);
            log.info((Object)("Copying Secondary Session Course Offerings: " + this.iSecondarySession.getLabel()));
            this.copyMergeCourseOfferingsToSession(this.iSecondarySession, classPrefsAction, subpartLocationPrefsAction, subpartTimePrefsAction, mergeWaitListsProhibitedOverrides, distributionPrefMode, cancelledClassAction, secondarySessionDefaultPrefix);
            this.resetHibSession(hibSession, mergedSessionId, primarySessionId, secondarySessionId);
            log.info((Object)("Copying Primary Session Instructors onto Classes: " + this.iPrimarySession.getLabel()));
            this.copyMergeClassInstructorsToSession(this.iPrimarySession, primarySessionDefaultPrefix);
            this.resetHibSession(hibSession, mergedSessionId, primarySessionId, secondarySessionId);
            log.info((Object)("Copying Secondary Session Instructors onto Classes: " + this.iSecondarySession.getLabel()));
            this.copyMergeClassInstructorsToSession(this.iSecondarySession, secondarySessionDefaultPrefix);
            this.resetHibSession(hibSession, mergedSessionId, primarySessionId, secondarySessionId);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
            e.printStackTrace();
        }
    }

    private void resetHibSession(org.hibernate.Session hibSession, Long mergedSessionId, Long primarySessionId, Long secondarySessionId) {
        org.hibernate.Session hs = null;
        Long msi = null;
        Long psi = null;
        Long ssi = null;
        hs = hibSession != null ? hibSession : SessionDAO.getInstance().getSession();
        if (mergedSessionId != null) {
            msi = mergedSessionId;
        } else if (this.iMergedSession != null) {
            msi = this.iMergedSession.getUniqueId();
        }
        if (primarySessionId != null) {
            psi = primarySessionId;
        } else if (this.iPrimarySession != null) {
            psi = this.iPrimarySession.getUniqueId();
        }
        if (secondarySessionId != null) {
            ssi = secondarySessionId;
        } else if (this.iSecondarySession != null) {
            ssi = this.iSecondarySession.getUniqueId();
        }
        if (msi != null && psi != null && ssi != null) {
            if (hs.getTransaction() != null && hs.getTransaction().isActive()) {
                hs.getTransaction().commit();
            }
            hs = SessionDAO.getInstance().getSession();
            hs.flush();
            hs.clear();
            hs.close();
            this.iMergedSession = Session.getSessionById(msi);
            this.iPrimarySession = Session.getSessionById(psi);
            this.iSecondarySession = Session.getSessionById(ssi);
            this.iPrefixRoomFeatureMap = new HashMap();
            this.iSessionRollForward = new SessionRollForward(this.iLog);
        }
    }

    private void resetHibSession(org.hibernate.Session hibSession) {
        this.resetHibSession(hibSession, null, null, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addPrefixToDeptFields(Department department, String suffix) throws Exception {
        if (!this.isNewStringOfValidLength(suffix, this.iPrefixSeparator, department.getDeptCode(), Department.class.getName(), "deptCode")) {
            throw new Exception("Prefix will make department code too long:  " + suffix + this.iPrefixSeparator + department.getDeptCode());
        }
        department.setDeptCode(suffix + this.iPrefixSeparator + department.getDeptCode());
        if (department.getAbbreviation() == null || department.getAbbreviation().trim().isEmpty()) {
            if (!this.isNewStringOfValidLength(suffix, this.iPrefixSeparator, department.getDeptCode(), Department.class.getName(), "abbreviation")) throw new Exception("Prefix will make department abbreviation too long:  " + suffix + this.iPrefixSeparator + department.getDeptCode());
            department.setAbbreviation(department.getDeptCode());
        } else {
            if (!this.isNewStringOfValidLength(suffix, this.iPrefixSeparator, department.getAbbreviation(), Department.class.getName(), "abbreviation")) throw new Exception("Prefix will make department abbreviation too long:  " + suffix + this.iPrefixSeparator + department.getAbbreviation());
            department.setAbbreviation(suffix + this.iPrefixSeparator + department.getAbbreviation());
        }
        if (!this.isNewStringOfValidLength(suffix, this.iPrefixSeparator, department.getName(), Department.class.getName(), "name")) {
            throw new Exception("Prefix will make department name too long:  " + suffix + this.iPrefixSeparator + department.getName());
        }
        department.setName(suffix + this.iPrefixSeparator + department.getName());
        if (!department.isExternalManager().booleanValue()) return;
        if (!this.isNewStringOfValidLength(suffix, this.iPrefixSeparator, department.getExternalMgrAbbv(), Department.class.getName(), "externalMgrAbbv")) {
            throw new Exception("Prefix will make department external manager abbreviation too long:  " + suffix + this.iPrefixSeparator + department.getExternalMgrAbbv());
        }
        department.setExternalMgrAbbv(suffix + this.iPrefixSeparator + department.getExternalMgrAbbv());
        if (!this.isNewStringOfValidLength(suffix, this.iPrefixSeparator, department.getExternalMgrLabel(), Department.class.getName(), "externalMgrLabel")) throw new Exception("Prefix will make department external manager label too long:  " + suffix + this.iPrefixSeparator + department.getExternalMgrLabel());
        department.setExternalMgrLabel(suffix + this.iPrefixSeparator + department.getExternalMgrLabel());
    }

    private String findPrefix(String deptCode, String defaultPrefix) {
        String prefix = null;
        if (defaultPrefix != null && this.iPrefixSeparator != null) {
            prefix = defaultPrefix;
            if (this.iDepartmentCodesWithDifferentPrefix != null && this.iDepartmentCodesWithDifferentPrefix.containsKey(deptCode)) {
                prefix = this.iDepartmentCodesWithDifferentPrefix.get(deptCode);
            }
        }
        return prefix;
    }

    private void mergeGlobalInstructorAttributesToSession(Session fromSession) {
        HashMap<Long, InstructorAttribute> attributes = new HashMap<Long, InstructorAttribute>();
        for (InstructorAttribute oldAttribute : InstructorAttribute.getAllGlobalAttributes(this.iMergedSession.getUniqueId())) {
            InstructorAttributeDAO.getInstance().getSession().remove((Object)oldAttribute);
        }
        List<InstructorAttribute> globalAttributes = InstructorAttribute.getAllGlobalAttributes(fromSession.getUniqueId());
        for (InstructorAttribute fromAttribute : globalAttributes) {
            InstructorAttribute toAttribute = new InstructorAttribute();
            toAttribute.setSession(this.iMergedSession);
            toAttribute.setCode(fromAttribute.getCode());
            toAttribute.setName(fromAttribute.getName());
            toAttribute.setType(fromAttribute.getType());
            toAttribute.setInstructors(new HashSet<DepartmentalInstructor>());
            toAttribute.setChildAttributes(new HashSet<InstructorAttribute>());
            attributes.put(fromAttribute.getUniqueId(), toAttribute);
            InstructorAttributeDAO.getInstance().getSession().persist((Object)toAttribute);
        }
        for (InstructorAttribute fromChildAttribute : globalAttributes) {
            if (fromChildAttribute.getParentAttribute() == null) continue;
            InstructorAttribute toChildAttribute = (InstructorAttribute)attributes.get(fromChildAttribute.getUniqueId());
            InstructorAttribute toParentAttribute = (InstructorAttribute)attributes.get(fromChildAttribute.getParentAttribute().getUniqueId());
            if (toParentAttribute == null) continue;
            toChildAttribute.setParentAttribute(toParentAttribute);
            toParentAttribute.getChildAttributes().add(toChildAttribute);
            InstructorAttributeDAO.getInstance().getSession().merge((Object)toChildAttribute);
        }
    }

    public void copyMergeConfigurationToSession(Session fromSession, String defaultPrefix) {
        Department newDepartment;
        org.hibernate.Session hibSession = SessionConfigDAO.getInstance().getSession();
        for (SessionConfig config : hibSession.createQuery("from SessionConfig where session.uniqueId = :sessionId", SessionConfig.class).setParameter("sessionId", (Object)this.iMergedSession.getUniqueId()).list()) {
            hibSession.remove((Object)config);
        }
        for (SessionConfig config : hibSession.createQuery("from SessionConfig where session.uniqueId = :sessionId", SessionConfig.class).setParameter("sessionId", (Object)fromSession.getUniqueId()).list()) {
            SessionConfig newConfig = new SessionConfig();
            newConfig.setKey(config.getKey());
            newConfig.setDescription(config.getDescription());
            newConfig.setValue(config.getValue());
            newConfig.setSession(this.iMergedSession);
            hibSession.persist((Object)newConfig);
        }
        for (StandardEventNote note : hibSession.createQuery("from StandardEventNoteSession where session.uniqueId = :sessionId", StandardEventNoteSession.class).setParameter("sessionId", (Object)this.iMergedSession.getUniqueId()).list()) {
            hibSession.remove((Object)note);
        }
        for (StandardEventNote note : hibSession.createQuery("from StandardEventNoteDepartment where department.session.uniqueId = :sessionId", StandardEventNoteDepartment.class).setParameter("sessionId", (Object)this.iMergedSession.getUniqueId()).list()) {
            hibSession.remove((Object)note);
        }
        for (StandardEventNote note : hibSession.createQuery("from StandardEventNoteSession where session.uniqueId = :sessionId", StandardEventNoteSession.class).setParameter("sessionId", (Object)fromSession.getUniqueId()).list()) {
            StandardEventNoteSession newNote = new StandardEventNoteSession();
            newNote.setNote(note.getNote());
            newNote.setReference(note.getReference());
            newNote.setSession(this.iMergedSession);
            hibSession.persist((Object)newNote);
        }
        for (StandardEventNote note : hibSession.createQuery("from StandardEventNoteDepartment where department.session.uniqueId = :sessionId", StandardEventNoteDepartment.class).setParameter("sessionId", (Object)fromSession.getUniqueId()).list()) {
            newDepartment = this.findToDepartment(((BaseStandardEventNoteDepartment)note).getDepartment(), defaultPrefix);
            if (newDepartment == null) continue;
            StandardEventNoteDepartment newNote = new StandardEventNoteDepartment();
            newNote.setNote(note.getNote());
            newNote.setReference(note.getReference());
            newNote.setDepartment(newDepartment);
            hibSession.persist((Object)newNote);
        }
        for (RoomTypeOption option : hibSession.createQuery("from RoomTypeOption where department.session.uniqueId = :sessionId", RoomTypeOption.class).setParameter("sessionId", (Object)this.iMergedSession.getUniqueId()).list()) {
            hibSession.remove((Object)option);
        }
        for (RoomTypeOption option : hibSession.createQuery("from RoomTypeOption where department.session.uniqueId = :sessionId", RoomTypeOption.class).setParameter("sessionId", (Object)fromSession.getUniqueId()).list()) {
            newDepartment = this.findToDepartment(option.getDepartment(), defaultPrefix);
            if (newDepartment == null) continue;
            RoomTypeOption newOption = new RoomTypeOption();
            newOption.setBreakTime(option.getBreakTime());
            newOption.setDepartment(newDepartment);
            newOption.setMessage(option.getMessage());
            newOption.setRoomType(option.getRoomType());
            newOption.setStatus(RoomTypeOption.getDefaultStatus());
            newOption.setEventEmail(option.getEventEmail());
            hibSession.persist((Object)newOption);
        }
        for (EventServiceProvider provider : hibSession.createQuery("from EventServiceProvider where session.uniqueId = :sessionId", EventServiceProvider.class).setParameter("sessionId", (Object)this.iMergedSession.getUniqueId()).list()) {
            hibSession.remove((Object)provider);
        }
        for (EventServiceProvider provider : hibSession.createQuery("from EventServiceProvider where session.uniqueId = :sessionId", EventServiceProvider.class).setParameter("sessionId", (Object)fromSession.getUniqueId()).list()) {
            if (!provider.isVisible().booleanValue()) continue;
            EventServiceProvider newProvider = new EventServiceProvider();
            newProvider.setReference(provider.getReference());
            newProvider.setLabel(provider.getLabel());
            newProvider.setEmail(provider.getEmail());
            newProvider.setNote(provider.getNote());
            newProvider.setAllRooms(provider.getAllRooms());
            newProvider.setVisible(provider.getVisible());
            newProvider.setSession(this.iMergedSession);
            if (provider.getDepartment() != null) {
                Department newDepartment2 = this.findToDepartment(provider.getDepartment(), defaultPrefix);
                if (newDepartment2 == null) continue;
                newProvider.setDepartment(newDepartment2);
            }
            hibSession.persist((Object)newProvider);
        }
        this.mergeGlobalInstructorAttributesToSession(fromSession);
        ApplicationProperties.clearSessionProperties(this.iMergedSession.getUniqueId());
        hibSession.flush();
    }

    public void copyMergeDepartmentsToSession(Session fromSession, String defaultPrefix) throws Exception {
        Department toDepartment = null;
        DepartmentDAO dDao = DepartmentDAO.getInstance();
        SolverGroup sg = null;
        String prefix = null;
        boolean failedToCopy = false;
        List<Department> departments = DepartmentDAO.getInstance().findBySession(dDao.getSession(), fromSession.getUniqueId());
        dDao.getSession().refresh((Object)this.iMergedSession);
        for (Department fromDepartment : departments) {
            toDepartment = null;
            sg = null;
            prefix = null;
            if (fromDepartment == null) continue;
            if (!this.iUseCampusPrefixForDepartments) {
                toDepartment = Department.findByDeptCode(fromDepartment.getDeptCode(), this.iMergedSession.getUniqueId(), dDao.getSession());
            } else {
                toDepartment = this.findToDepartment(fromDepartment, defaultPrefix);
                if (toDepartment != null) continue;
                prefix = this.findPrefix(fromDepartment.getDeptCode(), defaultPrefix);
            }
            if (toDepartment == null) {
                toDepartment = (Department)fromDepartment.clone();
                toDepartment.setStatusType(null);
                if (this.iUseCampusPrefixForDepartments && prefix != null) {
                    try {
                        this.addPrefixToDeptFields(toDepartment, prefix);
                    }
                    catch (Exception e) {
                        this.iLog.error((Object)e.getMessage());
                        failedToCopy = true;
                        continue;
                    }
                }
                toDepartment.setSession(this.iMergedSession);
                this.iMergedSession.addToDepartments(toDepartment);
                dDao.getSession().persist((Object)toDepartment);
            }
            if (fromDepartment.getSolverGroup() != null && toDepartment.getSolverGroup() == null) {
                sg = this.findToSolverGroup(fromDepartment.getSolverGroup(), fromDepartment, defaultPrefix);
                if (sg == null) {
                    sg = (SolverGroup)fromDepartment.getSolverGroup().clone();
                    if (prefix != null) {
                        try {
                            this.addPrefixToSolverGroupFields(sg, prefix);
                        }
                        catch (Exception e) {
                            this.iLog.error((Object)e.getMessage());
                            failedToCopy = true;
                            continue;
                        }
                    }
                    sg.setSession(this.iMergedSession);
                }
                if (sg != null) {
                    if (null == sg.getDepartments()) {
                        sg.setDepartments(new HashSet<Department>());
                    }
                    sg.getDepartments().add(toDepartment);
                    toDepartment.setSolverGroup(sg);
                    SolverGroupDAO sgDao = SolverGroupDAO.getInstance();
                    if (sg.getUniqueId() == null) {
                        sgDao.getSession().persist((Object)sg);
                    } else {
                        sgDao.getSession().merge((Object)sg);
                    }
                }
            }
            dDao.getSession().merge((Object)toDepartment);
            DistributionTypeDAO dtDao = DistributionTypeDAO.getInstance();
            List l = dtDao.getSession().createQuery("select dt from DistributionType dt inner join dt.departments as d where d.uniqueId = " + fromDepartment.getUniqueId().toString(), DistributionType.class).list();
            if (l == null || l.isEmpty()) continue;
            for (DistributionType distributionType : l) {
                distributionType.getDepartments().add(toDepartment);
                dtDao.getSession().merge((Object)distributionType);
            }
        }
        dDao.getSession().flush();
        if (failedToCopy) {
            throw new Exception("Not all merged departments were successfully created.");
        }
    }

    private void addPrefixToSolverGroupFields(SolverGroup solverGroup, String prefix) throws Exception {
        if (!this.isNewStringOfValidLength(prefix, this.iPrefixSeparator, solverGroup.getAbbv(), SolverGroup.class.getName(), "abbv")) {
            throw new Exception("Prefix will make solver group abbreviation too long:  " + prefix + this.iPrefixSeparator + solverGroup.getAbbv());
        }
        solverGroup.setAbbv(prefix + this.iPrefixSeparator + solverGroup.getAbbv());
        if (!this.isNewStringOfValidLength(prefix, this.iPrefixSeparator, solverGroup.getName(), SolverGroup.class.getName(), "name")) {
            throw new Exception("Prefix will make solver group abbreviation too long:  " + prefix + this.iPrefixSeparator + solverGroup.getName());
        }
        solverGroup.setName(prefix + this.iPrefixSeparator + solverGroup.getName());
    }

    private Department findToDepartment(Department fromDepartment, String defaultPrefix) {
        String prefix = null;
        Department toDepartment = null;
        if (!this.iUseCampusPrefixForDepartments) {
            toDepartment = fromDepartment.findSameDepartmentInSession(this.iMergedSession);
        } else {
            prefix = this.findPrefix(fromDepartment.getDeptCode(), defaultPrefix);
            if (prefix != null) {
                toDepartment = Department.findByDeptCode(prefix + this.iPrefixSeparator + fromDepartment.getDeptCode(), this.iMergedSession.getUniqueId(), DepartmentDAO.getInstance().getSession());
            }
        }
        return toDepartment;
    }

    private SolverGroup findToSolverGroup(SolverGroup fromSolverGroup, Department fromDepartment, String defaultPrefix) {
        String prefix = null;
        if (this.iUseCampusPrefixForDepartments) {
            prefix = this.findPrefix(fromDepartment.getDeptCode(), defaultPrefix);
        }
        return SolverGroup.findBySessionIdAbbv(this.iMergedSession.getUniqueId(), (String)(prefix == null ? fromSolverGroup.getAbbv() : prefix + this.iPrefixSeparator + fromSolverGroup.getAbbv()));
    }

    public void copyMergeTimetableManagersToSession(Session fromSession, String defaultPrefix) {
        Department toDepartment = null;
        TimetableManagerDAO tmDao = TimetableManagerDAO.getInstance();
        SolverGroupDAO sgDao = SolverGroupDAO.getInstance();
        try {
            List<Department> departments = DepartmentDAO.getInstance().findBySession(tmDao.getSession(), fromSession.getUniqueId());
            for (Department fromDepartment : departments) {
                if (fromDepartment == null || fromDepartment.getTimetableManagers() == null || (toDepartment = this.findToDepartment(fromDepartment, defaultPrefix)) == null) continue;
                if (toDepartment.getTimetableManagers() == null) {
                    toDepartment.setTimetableManagers(new HashSet<TimetableManager>());
                }
                for (TimetableManager tm : fromDepartment.getTimetableManagers()) {
                    if (tm == null) continue;
                    toDepartment.getTimetableManagers().add(tm);
                    tm.getDepartments().add(toDepartment);
                    tmDao.getSession().merge((Object)tm);
                    if (!tm.getSolverGroups(this.iMergedSession).isEmpty()) continue;
                    for (SolverGroup fromSg : tm.getSolverGroups(fromSession)) {
                        SolverGroup toSg = this.findToSolverGroup(fromSg, fromDepartment, defaultPrefix);
                        if (toSg == null || tm.getSolverGroups().contains(toSg)) continue;
                        toSg.addToTimetableManagers(tm);
                        tm.addToSolverGroups(toSg);
                        sgDao.getSession().merge((Object)toSg);
                    }
                    tmDao.getSession().merge((Object)tm);
                }
            }
            tmDao.getSession().flush();
        }
        catch (Exception e) {
            this.iLog.error((Object)"Failed to merge all timetable managers to session.", (Throwable)e);
        }
    }

    private DepartmentRoomFeature findToDeptRoomFeature(DepartmentRoomFeature fromDeptRoomFeature, String defaultPrefix) {
        Department toDepartment = this.findToDepartment(fromDeptRoomFeature.getDepartment(), defaultPrefix);
        String query = "from DepartmentRoomFeature rf where rf.department.uniqueId = :deptId and rf.label = :label";
        return (DepartmentRoomFeature)DepartmentRoomFeatureDAO.getInstance().getSession().createQuery(query, DepartmentRoomFeature.class).setParameter("deptId", (Object)toDepartment.getUniqueId()).setParameter("label", (Object)fromDeptRoomFeature.getLabel()).uniqueResult();
    }

    private RoomGroup findToDeptRoomGroup(RoomGroup fromDeptRoomGroup, String defaultPrefix) {
        Department toDepartment = this.findToDepartment(fromDeptRoomGroup.getDepartment(), defaultPrefix);
        String query = "from RoomGroup rg where rg.global = false and rg.department.uniqueId = :deptId and rg.name = :name";
        return (RoomGroup)DepartmentRoomFeatureDAO.getInstance().getSession().createQuery(query, RoomGroup.class).setParameter("deptId", (Object)toDepartment.getUniqueId()).setParameter("name", (Object)fromDeptRoomGroup.getName()).uniqueResult();
    }

    private RoomFeatureType getCampusRoomFeatureType() {
        if (this.iCampusRoomFeatureType == null) {
            RoomFeatureTypeDAO rftDao = RoomFeatureTypeDAO.getInstance();
            this.iCampusRoomFeatureType = (RoomFeatureType)rftDao.getSession().createQuery("from RoomFeatureType rft where rft.reference = 'campus'", RoomFeatureType.class).uniqueResult();
            if (this.iCampusRoomFeatureType == null) {
                this.iCampusRoomFeatureType = new RoomFeatureType();
                this.iCampusRoomFeatureType.setReference("campus");
                this.iCampusRoomFeatureType.setLabel(MESSAGES.labelCampus());
                this.iCampusRoomFeatureType.setShowInInstructorSurvey(false);
                this.iCampusRoomFeatureType.setShowInEventManagement(true);
                rftDao.getSession().persist((Object)this.iCampusRoomFeatureType);
            }
        }
        return this.iCampusRoomFeatureType;
    }

    private GlobalRoomFeature getCampusRoomFeature(String campusPrefix) {
        if (campusPrefix == null) {
            return null;
        }
        GlobalRoomFeature rf = this.iPrefixRoomFeatureMap.get(campusPrefix);
        if (rf == null && (rf = GlobalRoomFeature.findGlobalRoomFeatureForAbbv(this.iMergedSession, campusPrefix)) == null) {
            rf = new GlobalRoomFeature();
            rf.setAbbv(campusPrefix);
            rf.setLabel(campusPrefix);
            rf.setFeatureType(this.getCampusRoomFeatureType());
            rf.setSession(this.iMergedSession);
            GlobalRoomFeatureDAO.getInstance().getSession().persist((Object)rf);
            this.iPrefixRoomFeatureMap.put(campusPrefix, rf);
        }
        return rf;
    }

    public void copyMergeRoomFeaturesToSession(Session fromSession, String defaultPrefix) {
        DepartmentRoomFeature fromRoomFeature2 = null;
        DepartmentRoomFeature toRoomFeature = null;
        RoomFeatureDAO rfDao = RoomFeatureDAO.getInstance();
        List<DepartmentRoomFeature> fromRoomFeatures = DepartmentRoomFeature.getAllRoomFeaturesForSession(fromSession);
        try {
            if (fromRoomFeatures != null && !fromRoomFeatures.isEmpty()) {
                for (DepartmentRoomFeature fromRoomFeature2 : fromRoomFeatures) {
                    if (fromRoomFeature2 == null || (toRoomFeature = this.findToDeptRoomFeature(fromRoomFeature2, defaultPrefix)) != null) continue;
                    toRoomFeature = (DepartmentRoomFeature)fromRoomFeature2.clone();
                    toRoomFeature.setDepartment(this.findToDepartment(fromRoomFeature2.getDepartment(), defaultPrefix));
                    rfDao.getSession().persist((Object)toRoomFeature);
                }
                rfDao.getSession().flush();
            }
            for (GlobalRoomFeature fromRoomFeatureGlobal : GlobalRoomFeature.getAllGlobalRoomFeatures(fromSession)) {
                GlobalRoomFeature toRoomFeatureGlobal = GlobalRoomFeature.findGlobalRoomFeatureForLabel(this.iMergedSession, fromRoomFeatureGlobal.getLabel());
                if (toRoomFeatureGlobal != null) continue;
                toRoomFeatureGlobal = (GlobalRoomFeature)fromRoomFeatureGlobal.clone();
                toRoomFeatureGlobal.setSession(this.iMergedSession);
                rfDao.getSession().persist((Object)toRoomFeatureGlobal);
            }
            rfDao.getSession().flush();
        }
        catch (Exception e) {
            this.iLog.error((Object)"Failed to merge all room features to session.", (Throwable)e);
        }
    }

    public void copyMergeRoomGroupsToSession(Session fromSession, String defaultPrefix) {
        RoomGroup toRoomGroup = null;
        RoomGroupDAO rgDao = RoomGroupDAO.getInstance();
        List<RoomGroup> fromRoomGroups = RoomGroup.getAllRoomGroupsForSession(fromSession);
        try {
            if (fromRoomGroups != null && !fromRoomGroups.isEmpty()) {
                for (RoomGroup fromRoomGroup : fromRoomGroups) {
                    if (fromRoomGroup == null || (toRoomGroup = fromRoomGroup.isGlobal() != false ? RoomGroup.findGlobalRoomGroupForName(this.iMergedSession, fromRoomGroup.getName()) : this.findToDeptRoomGroup(fromRoomGroup, defaultPrefix)) != null) continue;
                    toRoomGroup = (RoomGroup)fromRoomGroup.clone();
                    toRoomGroup.setSession(this.iMergedSession);
                    if (fromRoomGroup.getDepartment() != null) {
                        toRoomGroup.setDepartment(this.findToDepartment(fromRoomGroup.getDepartment(), defaultPrefix));
                    }
                    rgDao.getSession().persist((Object)toRoomGroup);
                }
                rgDao.getSession().flush();
            }
        }
        catch (Exception e) {
            this.iLog.error((Object)"Failed to merge all room groups to session.", (Throwable)e);
        }
    }

    public void copyMergeBuildingsToSession(Session fromSession) {
        BuildingDAO bDao = BuildingDAO.getInstance();
        List<Building> fromBuildings = bDao.findBySession(bDao.getSession(), fromSession.getUniqueId());
        if (fromBuildings != null && !fromBuildings.isEmpty()) {
            try {
                ExternalBuilding toExternalBuilding = null;
                for (Building fromBldg : fromBuildings) {
                    Building toBldg = null;
                    if (fromBldg.getExternalUniqueId() != null) {
                        toBldg = Building.findByExternalIdAndSession(fromBldg.getExternalUniqueId(), this.iMergedSession);
                    }
                    if (toBldg != null || (toBldg = Building.findByBldgAbbv(fromBldg.getAbbreviation(), this.iMergedSession.getUniqueId())) != null) continue;
                    if (fromBldg.getExternalUniqueId() != null && this.iSessionRollForward.sessionHasExternalBuildingList(this.iMergedSession)) {
                        toExternalBuilding = ExternalBuilding.findExternalBuildingForSession(fromBldg.getExternalUniqueId(), this.iMergedSession);
                        if (toExternalBuilding == null) continue;
                        toBldg = new Building();
                        toBldg.setAbbreviation(toExternalBuilding.getAbbreviation());
                        toBldg.setCoordinateX(toExternalBuilding.getCoordinateX());
                        toBldg.setCoordinateY(toExternalBuilding.getCoordinateY());
                        toBldg.setExternalUniqueId(toExternalBuilding.getExternalUniqueId());
                        toBldg.setName(toExternalBuilding.getDisplayName());
                    } else {
                        toBldg = (Building)fromBldg.clone();
                    }
                    toBldg.setSession(this.iMergedSession);
                    this.iMergedSession.addToBuildings(toBldg);
                    bDao.getSession().persist((Object)toBldg);
                }
                bDao.getSession().flush();
            }
            catch (Exception e) {
                this.iLog.error((Object)"Failed to merge all buildings to session.", (Throwable)e);
            }
        }
    }

    private void copyMergeRoomFeaturesForLocation(Location fromLocation, Location toLocation, HashMap<RoomFeature, RoomFeature> roomFeatureCache, String defaultPrefix) {
        if (fromLocation.getFeatures() != null && !fromLocation.getFeatures().isEmpty()) {
            ExternalRoom er;
            Room toRoom;
            GlobalRoomFeature toGlobalFeature = null;
            RoomFeature toFeature = null;
            boolean mergeGlobalFeaturesFromFromLocationToSession = true;
            if (toLocation instanceof Room && (toRoom = (Room)toLocation).getExternalUniqueId() != null && (er = ExternalRoom.findExternalRoomForSession(toRoom.getExternalUniqueId(), this.iMergedSession)) != null) {
                mergeGlobalFeaturesFromFromLocationToSession = false;
                if (er.getRoomFeatures() != null) {
                    for (ExternalRoomFeature erf : er.getRoomFeatures()) {
                        toGlobalFeature = GlobalRoomFeature.findGlobalRoomFeatureForLabel(this.iMergedSession, erf.getValue());
                        toLocation.addTofeatures(toGlobalFeature);
                    }
                }
            }
            for (RoomFeature fromFeature : fromLocation.getFeatures()) {
                if (fromFeature instanceof GlobalRoomFeature && !mergeGlobalFeaturesFromFromLocationToSession || (toFeature = roomFeatureCache.get(fromFeature)) != null || (toFeature = fromFeature.findSameFeatureInSession(this.iMergedSession)) == null) continue;
                roomFeatureCache.put(fromFeature, toFeature);
                toLocation.addTofeatures(toFeature);
                if (toFeature.getRooms() == null) {
                    toFeature.setRooms(new HashSet<Location>());
                }
                toFeature.getRooms().add(toLocation);
            }
        }
        if (defaultPrefix != null) {
            for (RoomDept rd : fromLocation.getRoomDepts()) {
                String prefix = this.findPrefix(rd.getDepartment().getDeptCode(), defaultPrefix);
                if (prefix == null) continue;
                toLocation.addTofeatures(this.getCampusRoomFeature(prefix));
            }
        }
    }

    private void copyMergeRoomGroupsForLocation(Location fromLocation, Location toLocation, HashMap<RoomGroup, RoomGroup> roomGroupCache) {
        if (fromLocation.getRoomGroups() != null && !fromLocation.getRoomGroups().isEmpty()) {
            RoomGroup toRoomGroup = null;
            for (RoomGroup fromRoomGroup : fromLocation.getRoomGroups()) {
                toRoomGroup = roomGroupCache.get(fromRoomGroup);
                if (toRoomGroup == null) {
                    toRoomGroup = fromRoomGroup.findSameRoomGroupInSession(this.iMergedSession);
                }
                if (toRoomGroup == null) continue;
                roomGroupCache.put(fromRoomGroup, toRoomGroup);
                if (toLocation.getRoomGroups() == null) {
                    toLocation.setRoomGroups(new HashSet<RoomGroup>());
                }
                toLocation.getRoomGroups().add(toRoomGroup);
                if (toRoomGroup.getRooms() == null) {
                    toRoomGroup.setRooms(new HashSet<Location>());
                }
                toRoomGroup.getRooms().add(toLocation);
            }
        }
    }

    public void copyMergeLocationsToSession(Session fromSession, String defaultPrefix) {
        LocationDAO lDao = LocationDAO.getInstance();
        List<Location> fromLocations = lDao.findBySession(lDao.getSession(), fromSession.getUniqueId());
        if (fromLocations != null && !fromLocations.isEmpty()) {
            for (Location location : fromLocations) {
                if (location instanceof Room) {
                    this.copyMergeRoomToSession(location, defaultPrefix);
                } else if (location instanceof NonUniversityLocation) {
                    this.copyMergeNonUniversityLocationToSession(location, defaultPrefix);
                }
                LocationDAO.getInstance().getSession().flush();
            }
        }
        if (this.iSessionRollForward.sessionHasExternalRoomList(this.iMergedSession)) {
            Room.addNewExternalRoomsToSession(this.iMergedSession);
        }
    }

    private Room findRoomInMergeSession(Room fromRoom) {
        Room toRoom = null;
        try {
            toRoom = fromRoom.findSameRoomInSession(this.iMergedSession);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (toRoom == null) {
            Building b = null;
            try {
                b = fromRoom.getBuilding().findSameBuildingInSession(this.iMergedSession);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (b != null) {
                toRoom = Room.findByBldgIdRoomNbr(b.getUniqueId(), fromRoom.getRoomNumber(), this.iMergedSession.getUniqueId());
            }
        }
        return toRoom;
    }

    private NonUniversityLocation findNonUniversityLocationInMergeSession(NonUniversityLocation fromNonUniversityLocation) {
        Location location;
        NonUniversityLocation toNonUniversityLocation = null;
        try {
            toNonUniversityLocation = fromNonUniversityLocation.findSameNonUniversityLocationInSession(this.iMergedSession);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (toNonUniversityLocation == null && (location = NonUniversityLocation.findByName(NonUniversityLocationDAO.getInstance().getSession(), this.iMergedSession.getUniqueId(), fromNonUniversityLocation.getName())) instanceof NonUniversityLocation) {
            toNonUniversityLocation = (NonUniversityLocation)location;
        }
        return toNonUniversityLocation;
    }

    private void copyMergeRoomDept(RoomDept fromRoomDept, Location toLocation, Location fromLocation, String defaultPrefix) {
        Department toDept = this.findToDepartment(fromRoomDept.getDepartment(), defaultPrefix);
        RoomDept toRoomDept = null;
        RoomDeptDAO rdDao = RoomDeptDAO.getInstance();
        if (toDept != null) {
            toRoomDept = new RoomDept();
            toRoomDept.setRoom(toLocation);
            toRoomDept.setControl(fromRoomDept.isControl());
            toRoomDept.setDepartment(toDept);
            toLocation.addToRoomDepts(toRoomDept);
            toDept.addToRoomDepts(toRoomDept);
            rdDao.getSession().persist((Object)toRoomDept);
            PreferenceLevel fromRoomPrefLevel = fromLocation.getRoomPreferenceLevel(fromRoomDept.getDepartment());
            if (!fromRoomPrefLevel.getPrefProlog().equals(PreferenceLevel.sNeutral)) {
                RoomPref toRoomPref = new RoomPref();
                toRoomPref.setOwner(toDept);
                toRoomPref.setPrefLevel(fromRoomPrefLevel);
                toRoomPref.setRoom(toLocation);
                toDept.addToPreferences(toRoomPref);
                rdDao.getSession().merge((Object)toDept);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void copyMergeRoomToSession(Location location, String defaultPrefix) {
        Room fromRoom = null;
        Room toRoom = null;
        RoomDAO rDao = RoomDAO.getInstance();
        DepartmentDAO dDao = DepartmentDAO.getInstance();
        Building toBuilding = null;
        Department toDept = null;
        Department fromDept = null;
        HashMap<RoomFeature, RoomFeature> roomFeatureCache = new HashMap<RoomFeature, RoomFeature>();
        HashMap<RoomGroup, RoomGroup> roomGroupCache = new HashMap<RoomGroup, RoomGroup>();
        try {
            fromRoom = (Room)location;
            toRoom = this.findRoomInMergeSession(fromRoom);
            if (toRoom == null) {
                boolean foundDept;
                Object toExternalRoom;
                if (fromRoom.getExternalUniqueId() != null && this.iSessionRollForward.sessionHasExternalRoomList(this.iMergedSession)) {
                    ExternalRoom toExternalRoom2 = ExternalRoom.findExternalRoomForSession(fromRoom.getExternalUniqueId(), this.iMergedSession);
                    if (toExternalRoom2 == null) return;
                    toRoom = new Room();
                    toRoom.setCapacity(toExternalRoom2.getCapacity());
                    toRoom.setExamCapacity(toExternalRoom2.getExamCapacity());
                    toRoom.setClassification(toExternalRoom2.getClassification());
                    toRoom.setCoordinateX(toExternalRoom2.getCoordinateX());
                    toRoom.setCoordinateY(toExternalRoom2.getCoordinateY());
                    toRoom.setArea(toExternalRoom2.getArea());
                    toRoom.setDisplayName(toExternalRoom2.getDisplayName());
                    toRoom.setExternalUniqueId(toExternalRoom2.getExternalUniqueId());
                    toRoom.setIgnoreRoomCheck(fromRoom.isIgnoreRoomCheck());
                    toRoom.setIgnoreTooFar(fromRoom.isIgnoreTooFar());
                    toRoom.setPattern(fromRoom.getPattern());
                    toRoom.setRoomNumber(toExternalRoom2.getRoomNumber());
                    toRoom.setRoomType(toExternalRoom2.getRoomType());
                    toRoom.setExamTypes(new HashSet<ExamType>(fromRoom.getExamTypes()));
                    toRoom.setEventStatus(null);
                    toRoom.setBreakTime(fromRoom.getBreakTime());
                    toRoom.setNote(fromRoom.getNote());
                    toRoom.setEventEmail(fromRoom.getEventEmail());
                    toRoom.setEventAvailability(fromRoom.getEventAvailability());
                    LocationPermIdGenerator.setPermanentId(toRoom);
                } else {
                    toRoom = (Room)fromRoom.clone();
                }
                toRoom.setSession(this.iMergedSession);
                if (fromRoom.getEventDepartment() != null) {
                    toRoom.setEventDepartment(this.findToDepartment(fromRoom.getEventDepartment(), defaultPrefix));
                }
                if ((toBuilding = Building.findByBldgAbbv(rDao.getSession(), this.iMergedSession.getUniqueId(), fromRoom.getBuilding().getAbbreviation())) != null) {
                    toRoom.setBuilding(toBuilding);
                    if (fromRoom.getManagerIds() != null && fromRoom.getManagerIds().length() != 0) {
                        Object toManagerStr = "";
                        StringTokenizer stk = new StringTokenizer(fromRoom.getManagerIds(), ",");
                        while (stk.hasMoreTokens()) {
                            Long fromDeptId = Long.valueOf(stk.nextToken());
                            if (fromDeptId == null || (fromDept = (Department)dDao.get(fromDeptId)) == null || (toDept = this.findToDepartment(fromDept, defaultPrefix)) == null) continue;
                            if (((String)toManagerStr).length() != 0) {
                                toManagerStr = (String)toManagerStr + ",";
                            }
                            toManagerStr = (String)toManagerStr + toDept.getUniqueId().toString();
                        }
                        toRoom.setManagerIds((String)toManagerStr);
                    } else {
                        toRoom.setPattern(null);
                    }
                    this.copyMergeRoomFeaturesForLocation(fromRoom, toRoom, roomFeatureCache, defaultPrefix);
                    this.copyMergeRoomGroupsForLocation(fromRoom, toRoom, roomGroupCache);
                    rDao.getSession().persist((Object)toRoom);
                }
                boolean mergeExistingRoomDepts = true;
                if (fromRoom.getExternalUniqueId() != null && this.iSessionRollForward.sessionHasExternalRoomDeptList(this.iMergedSession) && ((BaseExternalRoom)(toExternalRoom = ExternalRoom.findExternalRoomForSession(fromRoom.getExternalUniqueId(), this.iMergedSession))).getRoomDepartments() != null && !((BaseExternalRoom)toExternalRoom).getRoomDepartments().isEmpty()) {
                    for (ExternalRoomDepartment toExternalRoomDept : ((BaseExternalRoom)toExternalRoom).getRoomDepartments()) {
                        foundDept = false;
                        for (RoomDept fromRoomDept : fromRoom.getRoomDepts()) {
                            if (!fromRoomDept.getDepartment().getDeptCode().equals(toExternalRoomDept.getDepartmentCode())) continue;
                            foundDept = true;
                            break;
                        }
                        if (foundDept) continue;
                        mergeExistingRoomDepts = false;
                    }
                }
                if (mergeExistingRoomDepts) {
                    if (fromRoom.getRoomDepts() != null && !fromRoom.getRoomDepts().isEmpty()) {
                        for (RoomDept fromRoomDept : fromRoom.getRoomDepts()) {
                            this.copyMergeRoomDept(fromRoomDept, toRoom, fromRoom, defaultPrefix);
                        }
                    }
                } else {
                    toRoom.setPattern(null);
                    toRoom.setManagerIds(null);
                    toExternalRoom = ExternalRoom.findExternalRoomForSession(fromRoom.getExternalUniqueId(), this.iMergedSession);
                    for (ExternalRoomDepartment toExternalRoomDept : ((BaseExternalRoom)toExternalRoom).getRoomDepartments()) {
                        foundDept = false;
                        RoomDept foundFromRoomDept = null;
                        for (RoomDept fromRoomDept : fromRoom.getRoomDepts()) {
                            if (!fromRoomDept.getDepartment().getDeptCode().equals(toExternalRoomDept.getDepartmentCode())) continue;
                            foundDept = true;
                            foundFromRoomDept = fromRoomDept;
                            break;
                        }
                        if (foundDept) {
                            this.copyMergeRoomDept(foundFromRoomDept, toRoom, fromRoom, defaultPrefix);
                            continue;
                        }
                        toRoom.addExternalRoomDept(toExternalRoomDept, ((BaseExternalRoom)toExternalRoom).getRoomDepartments());
                    }
                }
                rDao.getSession().merge((Object)toRoom);
                RoomPictureDAO rpDao = RoomPictureDAO.getInstance();
                for (RoomPicture fromPicture : fromRoom.getPictures()) {
                    RoomPicture toPicture = fromPicture.clonePicture();
                    toPicture.setLocation(toRoom);
                    toRoom.addToPictures(toPicture);
                    rpDao.getSession().persist((Object)toPicture);
                }
                for (EventServiceProvider fromProvider : fromRoom.getAllowedServices()) {
                    EventServiceProvider toProvider = fromProvider.findInSession(this.iMergedSession.getUniqueId());
                    if (toProvider == null) continue;
                    toRoom.addToAllowedServices(toProvider);
                }
                rDao.getSession().merge((Object)toRoom);
                return;
            }
            if (fromRoom.getRoomDepts() != null && !fromRoom.getRoomDepts().isEmpty()) {
                for (RoomDept fromRoomDept : fromRoom.getRoomDepts()) {
                    if (toRoom.hasRoomDept(this.findToDepartment(fromRoomDept.getDepartment(), defaultPrefix))) continue;
                    this.copyMergeRoomDept(fromRoomDept, toRoom, fromRoom, defaultPrefix);
                }
                rDao.getSession().merge((Object)toRoom);
            }
            this.copyMergeRoomFeaturesForLocation(fromRoom, toRoom, roomFeatureCache, defaultPrefix);
            this.copyMergeRoomGroupsForLocation(fromRoom, toRoom, roomGroupCache);
            rDao.getSession().merge((Object)toRoom);
            return;
        }
        catch (Exception e) {
            this.iLog.error((Object)"Failed to merge all rooms to session.", (Throwable)e);
        }
    }

    private void copyMergeNonUniversityLocationToSession(Location location, String defaultPrefix) {
        NonUniversityLocation fromNonUniversityLocation = null;
        NonUniversityLocation toNonUniversityLocation = null;
        NonUniversityLocationDAO nulDao = NonUniversityLocationDAO.getInstance();
        DepartmentDAO dDao = DepartmentDAO.getInstance();
        Department toDept = null;
        Department fromDept = null;
        HashMap<RoomFeature, RoomFeature> roomFeatureCache = new HashMap<RoomFeature, RoomFeature>();
        HashMap<RoomGroup, RoomGroup> roomGroupCache = new HashMap<RoomGroup, RoomGroup>();
        try {
            fromNonUniversityLocation = (NonUniversityLocation)location;
            toNonUniversityLocation = this.findNonUniversityLocationInMergeSession(fromNonUniversityLocation);
            if (toNonUniversityLocation == null) {
                toNonUniversityLocation = (NonUniversityLocation)fromNonUniversityLocation.clone();
                toNonUniversityLocation.setSession(this.iMergedSession);
                if (fromNonUniversityLocation.getEventDepartment() != null) {
                    toNonUniversityLocation.setEventDepartment(this.findToDepartment(fromNonUniversityLocation.getEventDepartment(), defaultPrefix));
                }
                if (fromNonUniversityLocation.getManagerIds() != null && fromNonUniversityLocation.getManagerIds().length() != 0) {
                    Object toManagerStr = "";
                    Iterator<Comparable<EventServiceProvider>> stk = new StringTokenizer(fromNonUniversityLocation.getManagerIds(), ",");
                    while (((StringTokenizer)((Object)stk)).hasMoreTokens()) {
                        Long fromDeptId = Long.valueOf(((StringTokenizer)((Object)stk)).nextToken());
                        if (fromDeptId == null || (fromDept = (Department)dDao.get(fromDeptId)) == null || (toDept = this.findToDepartment(fromDept, defaultPrefix)) == null) continue;
                        if (((String)toManagerStr).length() != 0) {
                            toManagerStr = (String)toManagerStr + ",";
                        }
                        toManagerStr = (String)toManagerStr + toDept.getUniqueId().toString();
                    }
                    toNonUniversityLocation.setManagerIds((String)toManagerStr);
                } else {
                    toNonUniversityLocation.setPattern(null);
                }
                this.copyMergeRoomFeaturesForLocation(fromNonUniversityLocation, toNonUniversityLocation, roomFeatureCache, defaultPrefix);
                this.copyMergeRoomGroupsForLocation(fromNonUniversityLocation, toNonUniversityLocation, roomGroupCache);
                nulDao.getSession().persist((Object)toNonUniversityLocation);
                NonUniversityLocationPictureDAO nulpDao = NonUniversityLocationPictureDAO.getInstance();
                for (NonUniversityLocationPicture fromPicture : fromNonUniversityLocation.getPictures()) {
                    NonUniversityLocationPicture toPicture = fromPicture.clonePicture();
                    toPicture.setLocation(toNonUniversityLocation);
                    toNonUniversityLocation.addToPictures(toPicture);
                    nulpDao.getSession().persist((Object)toPicture);
                }
                for (EventServiceProvider fromProvider : fromNonUniversityLocation.getAllowedServices()) {
                    EventServiceProvider toProvider = fromProvider.findInSession(this.iMergedSession.getUniqueId());
                    if (toProvider == null) continue;
                    toNonUniversityLocation.addToAllowedServices(toProvider);
                }
                if (fromNonUniversityLocation.getRoomDepts() != null && !fromNonUniversityLocation.getRoomDepts().isEmpty()) {
                    for (RoomDept fromRoomDept : fromNonUniversityLocation.getRoomDepts()) {
                        this.copyMergeRoomDept(fromRoomDept, toNonUniversityLocation, fromNonUniversityLocation, defaultPrefix);
                    }
                    nulDao.getSession().merge((Object)toNonUniversityLocation);
                }
            } else {
                if (fromNonUniversityLocation.getRoomDepts() != null && !fromNonUniversityLocation.getRoomDepts().isEmpty()) {
                    for (RoomDept fromRoomDept : fromNonUniversityLocation.getRoomDepts()) {
                        if (toNonUniversityLocation.hasRoomDept(this.findToDepartment(fromRoomDept.getDepartment(), defaultPrefix))) continue;
                        this.copyMergeRoomDept(fromRoomDept, toNonUniversityLocation, fromNonUniversityLocation, defaultPrefix);
                    }
                    nulDao.getSession().merge((Object)toNonUniversityLocation);
                }
                this.copyMergeRoomFeaturesForLocation(fromNonUniversityLocation, toNonUniversityLocation, roomFeatureCache, defaultPrefix);
                this.copyMergeRoomGroupsForLocation(fromNonUniversityLocation, toNonUniversityLocation, roomGroupCache);
                nulDao.getSession().merge((Object)toNonUniversityLocation);
            }
        }
        catch (Exception e) {
            this.iLog.error((Object)"Failed to merge all non university locations to session.", (Throwable)e);
        }
    }

    private Location findLocation(Long locationId, Long sessionId) {
        TravelTimeDAO dao = TravelTimeDAO.getInstance();
        Room room = (Room)dao.getSession().createQuery("select r2 from Room r1, Room r2 where r1.uniqueId = :locationId and r2.building.session.uniqueId=:sessionId and ((r1.externalUniqueId is not null and r1.externalUniqueId = r2.externalUniqueId) or (r1.externalUniqueId is null and r1.building.abbreviation = r2.building.abbreviation and r1.roomNumber = r2.roomNumber))", Room.class).setParameter("sessionId", (Object)sessionId).setParameter("locationId", (Object)locationId).setCacheable(true).setMaxResults(1).uniqueResult();
        if (room != null) {
            return room;
        }
        return (Location)dao.getSession().createQuery("select r2 from NonUniversityLocation r1, NonUniversityLocation r2 where r1.uniqueId = :locationId and r2.session.uniqueId=:sessionId and r1.name = r2.name", NonUniversityLocation.class).setParameter("sessionId", (Object)sessionId).setParameter("locationId", (Object)locationId).setCacheable(true).setMaxResults(1).uniqueResult();
    }

    private void copyMergeTravelTimesToSession(Session fromSession) {
        TravelTimeDAO dao = TravelTimeDAO.getInstance();
        for (TravelTime travel : dao.getSession().createQuery("from TravelTime where session.uniqueId = :sessionId", TravelTime.class).setParameter("sessionId", (Object)fromSession.getUniqueId()).list()) {
            Location to;
            Location from = this.findLocation(travel.getLocation1Id(), this.iMergedSession.getUniqueId());
            if (from == null || (to = this.findLocation(travel.getLocation2Id(), this.iMergedSession.getUniqueId())) == null) continue;
            TravelTime time = null;
            String query = "from TravelTime where session.uniqueId = :sessionId and location1Id = :loc1Id and location2Id = :loc2Id";
            time = (TravelTime)dao.getSession().createQuery(query, TravelTime.class).setParameter("sessionId", (Object)this.iMergedSession.getUniqueId()).setParameter("loc1Id", (Object)from.getUniqueId()).setParameter("loc2Id", (Object)to.getUniqueId()).uniqueResult();
            if (time != null) continue;
            time = new TravelTime();
            time.setSession(this.iMergedSession);
            time.setLocation1Id(Math.min(from.getUniqueId(), to.getUniqueId()));
            time.setLocation2Id(Math.max(from.getUniqueId(), to.getUniqueId()));
            time.setDistance(travel.getDistance());
            dao.getSession().persist((Object)time);
        }
        dao.getSession().flush();
    }

    private void mergeDatePatternOntoDepartmentsToSession(DatePattern fromDatePattern, DatePattern toDatePattern, String defaultPrefix) {
        if (fromDatePattern.getDepartments() != null && !fromDatePattern.getDepartments().isEmpty()) {
            for (Department fromDept : fromDatePattern.getDepartments()) {
                Department toDepartment = this.findToDepartment(fromDept, defaultPrefix);
                if (toDepartment == null) continue;
                if (null == toDepartment.getDatePatterns()) {
                    toDepartment.setDatePatterns(new HashSet<DatePattern>());
                }
                toDepartment.getDatePatterns().add(toDatePattern);
                if (null == toDatePattern.getDepartments()) {
                    toDatePattern.addToDepartments(toDepartment);
                }
                toDatePattern.addToDepartments(toDepartment);
            }
        }
    }

    public void copyMergeDatePatternsToSession(Session fromSession, String defaultPrefix) {
        List<DatePattern> fromDatePatterns = DatePattern.findAll(fromSession, true, null, null);
        DatePattern toDatePattern = null;
        DatePatternDAO dpDao = DatePatternDAO.getInstance();
        HashMap<DatePattern, DatePattern> fromToDatePatternMap = new HashMap<DatePattern, DatePattern>();
        try {
            DatePattern defDp;
            for (DatePattern fromDatePattern : fromDatePatterns) {
                if (fromDatePattern == null) continue;
                toDatePattern = DatePattern.findByName(this.iMergedSession, fromDatePattern.getName());
                if (toDatePattern == null) {
                    toDatePattern = (DatePattern)fromDatePattern.clone();
                    toDatePattern.setSession(this.iMergedSession);
                    this.mergeDatePatternOntoDepartmentsToSession(fromDatePattern, toDatePattern, defaultPrefix);
                    dpDao.getSession().persist((Object)toDatePattern);
                }
                fromToDatePatternMap.put(fromDatePattern, toDatePattern);
            }
            for (DatePattern fromDp : fromToDatePatternMap.keySet()) {
                DatePattern toDp = (DatePattern)fromToDatePatternMap.get(fromDp);
                if (fromDp.getParents() == null || fromDp.getParents().isEmpty()) continue;
                for (DatePattern fromParent : fromDp.getParents()) {
                    DatePattern toParent = (DatePattern)fromToDatePatternMap.get(fromParent);
                    if (toParent == null) continue;
                    toDp.addToParents(toParent);
                    toParent.addToChildren(toDp);
                }
                dpDao.getSession().merge((Object)toDp);
            }
            if (fromSession.getDefaultDatePattern() != null && (defDp = DatePattern.findByName(this.iMergedSession, fromSession.getDefaultDatePattern().getName())) != null) {
                this.iMergedSession.setDefaultDatePattern(defDp);
                SessionDAO sDao = SessionDAO.getInstance();
                sDao.getSession().merge((Object)this.iMergedSession);
            }
            dpDao.getSession().flush();
        }
        catch (Exception e) {
            this.iLog.error((Object)"Failed to merge all date patterns to session.", (Throwable)e);
        }
    }

    private void mergeTimePatternOntoDepartmentsToSession(TimePattern fromTimePattern, TimePattern toTimePattern, String defaultPrefix) {
        if (fromTimePattern.getDepartments() != null && !fromTimePattern.getDepartments().isEmpty()) {
            for (Department fromDept : fromTimePattern.getDepartments()) {
                Department toDepartment = this.findToDepartment(fromDept, defaultPrefix);
                if (toDepartment == null) continue;
                if (null == toDepartment.getTimePatterns()) {
                    toDepartment.setTimePatterns(new HashSet<TimePattern>());
                }
                toDepartment.getTimePatterns().add(toTimePattern);
                if (null == toTimePattern.getDepartments()) {
                    toTimePattern.setDepartments(new HashSet<Department>());
                }
                toTimePattern.addToDepartments(toDepartment);
            }
        }
    }

    public void copyMergeTimePatternsToSession(Session fromSession, String defaultPrefix) {
        List<TimePattern> fromDatePatterns = TimePattern.findAll(fromSession, null);
        TimePattern toTimePattern = null;
        TimePatternDAO tpDao = TimePatternDAO.getInstance();
        try {
            for (TimePattern fromTimePattern : fromDatePatterns) {
                if (fromTimePattern == null || (toTimePattern = TimePattern.findByName(this.iMergedSession, fromTimePattern.getName())) != null) continue;
                toTimePattern = (TimePattern)fromTimePattern.clone();
                toTimePattern.setSession(this.iMergedSession);
                this.mergeTimePatternOntoDepartmentsToSession(fromTimePattern, toTimePattern, defaultPrefix);
                tpDao.getSession().persist((Object)toTimePattern);
            }
            tpDao.getSession().flush();
        }
        catch (Exception e) {
            this.iLog.error((Object)"Failed to merge all time patterns to session.", (Throwable)e);
        }
    }

    public void copyMergeLearningManagementSystemInfoToSession(Session fromSession) {
        List<LearningManagementSystemInfo> fromLearningManagementSystems = LearningManagementSystemInfo.findAll(fromSession.getUniqueId());
        LearningManagementSystemInfo toLms = null;
        LearningManagementSystemInfoDAO lmsDao = LearningManagementSystemInfoDAO.getInstance();
        try {
            for (LearningManagementSystemInfo fromLms : fromLearningManagementSystems) {
                if (fromLms == null || (toLms = LearningManagementSystemInfo.findBySessionIdAndReference(this.iMergedSession.getUniqueId(), fromLms.getReference())) != null) continue;
                toLms = (LearningManagementSystemInfo)fromLms.clone();
                toLms.setSession(this.iMergedSession);
                lmsDao.getSession().persist((Object)toLms);
            }
            lmsDao.getSession().flush();
        }
        catch (Exception e) {
            this.iLog.error((Object)"Failed to merge all learning management system infos to session.", (Throwable)e);
        }
    }

    private HashSet<String> findSubjectPrefixes(SubjectArea fromSubjectArea, String defaultPrefix) {
        HashSet<String> prefixes = new HashSet<String>();
        if (this.iUseCampusPrefixForSubjectAreas && this.iPrefixSeparator != null) {
            StringBuffer query = new StringBuffer();
            query.append("select distinct c.managingDept").append(" from Class_ c inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings as co").append(" where co.subjectArea.uniqueId = :subjId");
            for (Department managingDept : DepartmentDAO.getInstance().getSession().createQuery(query.toString(), Department.class).setParameter("subjId", (Object)fromSubjectArea.getUniqueId()).list()) {
                String prefix = defaultPrefix;
                if (this.iDepartmentCodesWithDifferentPrefix != null && this.iDepartmentCodesWithDifferentPrefix.containsKey(managingDept.getDeptCode())) {
                    prefix = this.iDepartmentCodesWithDifferentPrefix.get(managingDept.getDeptCode());
                }
                prefixes.add(prefix);
            }
            if (prefixes.size() == 0) {
                prefixes.add(defaultPrefix);
            }
        } else {
            prefixes.add(null);
        }
        return prefixes;
    }

    private SubjectArea findToSubjectArea(SubjectArea fromSubjectArea, String prefix) {
        SubjectArea toSubjectArea = null;
        if (!this.iUseCampusPrefixForSubjectAreas || prefix == null || prefix.isEmpty()) {
            toSubjectArea = fromSubjectArea.findSameSubjectAreaInSession(this.iMergedSession);
        } else if (this.iPrefixSeparator != null) {
            toSubjectArea = SubjectArea.findByAbbv(this.iMergedSession.getUniqueId(), prefix + this.iPrefixSeparator + fromSubjectArea.getSubjectAreaAbbreviation());
        }
        return toSubjectArea;
    }

    private void addPrefixToSubjectFields(SubjectArea subjectArea, String prefix) throws Exception {
        if (prefix != null && !prefix.trim().isEmpty() && !this.iPrefixSeparator.trim().isEmpty()) {
            if (!this.isNewStringOfValidLength(prefix, this.iPrefixSeparator, subjectArea.getSubjectAreaAbbreviation(), SubjectArea.class.getName(), "subjectAreaAbbreviation")) {
                throw new Exception("Prefix will make subject area abbreviation too long:  " + prefix + this.iPrefixSeparator + subjectArea.getSubjectAreaAbbreviation());
            }
            subjectArea.setSubjectAreaAbbreviation(prefix + this.iPrefixSeparator + subjectArea.getSubjectAreaAbbreviation());
            if (this.isNewStringOfValidLength(prefix, this.iPrefixSeparator, subjectArea.getTitle(), SubjectArea.class.getName(), "title")) {
                subjectArea.setTitle(prefix + this.iPrefixSeparator + subjectArea.getTitle());
            } else {
                throw new Exception("Prefix will make subject area title too long:  " + prefix + this.iPrefixSeparator + subjectArea.getTitle());
            }
        }
    }

    public void copyMergeSubjectAreasToSession(Session fromSession, String prefix) throws Exception {
        SubjectArea toSubjectArea = null;
        Department toDepartment = null;
        SubjectAreaDAO sDao = SubjectAreaDAO.getInstance();
        boolean failedToCopy = false;
        try {
            if (this.iSessionRollForward.sessionHasCourseCatalog(this.iMergedSession)) {
                SubjectArea fromSubjectArea = null;
                CourseCatalogDAO ccDao = CourseCatalogDAO.getInstance();
                List subjects = ccDao.getSession().createQuery("select distinct cc.subject, cc.previousSubject from CourseCatalog cc where cc.session.uniqueId=:sessionId and cc.previousSubject is not null", Object[].class).setParameter("sessionId", (Object)this.iMergedSession.getUniqueId()).list();
                if (subjects != null) {
                    String toSubject = null;
                    String fromSubject = null;
                    for (Object[] subjectInfo : subjects) {
                        if (subjectInfo == null || subjectInfo.length != 2) continue;
                        toSubject = (String)subjectInfo[0];
                        fromSubject = (String)subjectInfo[1];
                        fromSubjectArea = SubjectArea.findByAbbv(fromSession.getUniqueId(), fromSubject);
                        if (fromSubjectArea == null) continue;
                        HashSet<String> subjectAreaPrefixes = this.findSubjectPrefixes(fromSubjectArea, prefix);
                        for (String subjectPrefix : subjectAreaPrefixes) {
                            toSubjectArea = this.findToSubjectArea(fromSubjectArea, subjectPrefix);
                            if (toSubjectArea != null) continue;
                            toSubjectArea = (SubjectArea)fromSubjectArea.clone();
                            toSubjectArea.setDepartment(null);
                            toSubjectArea.setSubjectAreaAbbreviation(toSubject);
                            if (subjectPrefix != null) {
                                try {
                                    this.addPrefixToSubjectFields(toSubjectArea, subjectPrefix);
                                }
                                catch (Exception e) {
                                    this.iLog.error((Object)e.getMessage());
                                    failedToCopy = true;
                                    continue;
                                }
                            }
                            if (fromSubjectArea.getFundingDept() != null) {
                                Department toFundingDept = this.findToDepartment(fromSubjectArea.getFundingDept(), prefix);
                                toSubjectArea.setFundingDept(toFundingDept);
                            }
                            toSubjectArea.setSession(this.iMergedSession);
                            this.iMergedSession.addToSubjectAreas(toSubjectArea);
                            if (fromSubjectArea.getDepartment() == null || (toDepartment = this.findToDepartment(fromSubjectArea.getDepartment(), prefix)) == null) continue;
                            toSubjectArea.setDepartment(toDepartment);
                            toDepartment.addToSubjectAreas(toSubjectArea);
                            sDao.getSession().persist((Object)toSubjectArea);
                        }
                    }
                }
                List newSubjects = ccDao.getSession().createQuery("select distinct subject from CourseCatalog cc where cc.session.uniqueId=:sessionId and cc.previousSubject is null and cc.subject not in (select sa.subjectAreaAbbreviation from SubjectArea sa where sa.session.uniqueId=:sessionId)", String.class).setParameter("sessionId", (Object)this.iMergedSession.getUniqueId()).list();
                toDepartment = Department.findByDeptCode("TEMP", this.iMergedSession.getUniqueId());
                if (toDepartment == null) {
                    toDepartment = new Department();
                    toDepartment.setAbbreviation("TEMP");
                    toDepartment.setAllowReqRoom(false);
                    toDepartment.setAllowReqTime(false);
                    toDepartment.setAllowReqDistribution(false);
                    toDepartment.setDeptCode("TEMP");
                    toDepartment.setExternalManager(false);
                    toDepartment.setExternalUniqueId(null);
                    toDepartment.setName("Temp Department For New Subjects");
                    toDepartment.setSession(this.iMergedSession);
                    toDepartment.setDistributionPrefPriority(0);
                    toDepartment.setInheritInstructorPreferences(true);
                    toDepartment.setAllowEvents(false);
                    toDepartment.setAllowStudentScheduling(true);
                    this.iMergedSession.addToDepartments(toDepartment);
                    DepartmentDAO.getInstance().getSession().persist((Object)toDepartment);
                }
                for (String toSubject : newSubjects) {
                    if (toSubject == null) continue;
                    toSubjectArea = new SubjectArea();
                    toSubjectArea.setDepartment(toDepartment);
                    toSubjectArea.setTitle("New Subject");
                    toSubjectArea.setSession(this.iMergedSession);
                    toSubjectArea.setSubjectAreaAbbreviation(toSubject);
                    toDepartment.addToSubjectAreas(toSubjectArea);
                    this.iMergedSession.addToSubjectAreas(toSubjectArea);
                    sDao.getSession().persist((Object)toSubjectArea);
                }
            } else {
                List<SubjectArea> fromSubjects = sDao.findBySession(sDao.getSession(), fromSession.getUniqueId());
                sDao.getSession().refresh((Object)this.iMergedSession);
                if (fromSubjects != null && !fromSubjects.isEmpty()) {
                    for (SubjectArea fromSubjectArea : fromSubjects) {
                        if (fromSubjectArea == null) continue;
                        HashSet<String> subjectAreaPrefixes = this.findSubjectPrefixes(fromSubjectArea, prefix);
                        for (String subjectPrefix : subjectAreaPrefixes) {
                            toSubjectArea = this.findToSubjectArea(fromSubjectArea, subjectPrefix);
                            if (toSubjectArea != null) continue;
                            toSubjectArea = (SubjectArea)fromSubjectArea.clone();
                            if (fromSubjectArea.getFundingDept() != null) {
                                Department toFundingDept = this.findToDepartment(fromSubjectArea.getFundingDept(), prefix);
                                toSubjectArea.setFundingDept(toFundingDept);
                            }
                            if (subjectPrefix != null) {
                                try {
                                    this.addPrefixToSubjectFields(toSubjectArea, subjectPrefix);
                                }
                                catch (Exception e) {
                                    this.iLog.error((Object)e.getMessage());
                                    failedToCopy = true;
                                    continue;
                                }
                            }
                            toSubjectArea.setDepartment(null);
                            toSubjectArea.setSession(this.iMergedSession);
                            this.iMergedSession.addToSubjectAreas(toSubjectArea);
                            if (fromSubjectArea.getDepartment() == null || (toDepartment = this.findToDepartment(fromSubjectArea.getDepartment(), prefix)) == null) continue;
                            toSubjectArea.setDepartment(toDepartment);
                            toDepartment.addToSubjectAreas(toSubjectArea);
                            sDao.getSession().persist((Object)toSubjectArea);
                        }
                    }
                }
            }
            sDao.getSession().flush();
            if (failedToCopy) {
                throw new Exception("Failed to merge subject areas due to prefix issues.");
            }
        }
        catch (Exception e) {
            this.iLog.error((Object)"Failed to merge all subject areas to session.", (Throwable)e);
        }
    }

    public HashMap<Object, Set<Location>> getRoomList() {
        if (this.iRoomList == null) {
            this.iRoomList = new HashMap();
        }
        return this.iRoomList;
    }

    private Department findManagingDepartmentForPrefGroup(PreferenceGroup prefGroup) {
        Class_ toClass_;
        Department toDepartment = null;
        if (prefGroup instanceof DepartmentalInstructor) {
            DepartmentalInstructor toInstructor = (DepartmentalInstructor)prefGroup;
            toDepartment = toInstructor.getDepartment();
        } else if (prefGroup instanceof SchedulingSubpart) {
            SchedulingSubpart toSchedSubpart = (SchedulingSubpart)prefGroup;
            if (toSchedSubpart.getInstrOfferingConfig().getInstructionalOffering().getControllingCourseOffering() != null) {
                toDepartment = toSchedSubpart.getManagingDept();
            }
        } else if (prefGroup instanceof Class_ && (toDepartment = (toClass_ = (Class_)prefGroup).getManagingDept()) == null) {
            toDepartment = toClass_.getSchedulingSubpart().getControllingDept();
        }
        return toDepartment;
    }

    private Department findToManagingDepartmentForPrefGroup(PreferenceGroup toPrefGroup, PreferenceGroup fromPrefGroup, String defaultPrefix) {
        Department fromDepartment;
        Department toDepartment = this.findManagingDepartmentForPrefGroup(toPrefGroup);
        if (toDepartment == null && (fromDepartment = this.findManagingDepartmentForPrefGroup(fromPrefGroup)) != null) {
            toDepartment = this.findToDepartment(fromDepartment, defaultPrefix);
            return toDepartment;
        }
        return toDepartment;
    }

    private static String buildRoomQueryForDepartment(Department dept, Session sess, String locType) {
        StringBuffer sb = new StringBuffer();
        sb.append("select l from " + locType + " as l inner join l.roomDepts as rd where l.session.uniqueId = ");
        sb.append(sess.getUniqueId().toString());
        sb.append(" and rd.department.uniqueId = ");
        sb.append(dept.getUniqueId().toString());
        return sb.toString();
    }

    private static Set<Location> buildRoomListForDepartment(Department department, Session session) {
        TreeSet<Location> ts = new TreeSet<Location>();
        for (Room r : RoomDAO.getInstance().getSession().createQuery(AcademicSessionMerge.buildRoomQueryForDepartment(department, session, "Room"), Room.class).list()) {
            for (RoomDept rd : r.getRoomDepts()) {
                rd.getDepartment();
            }
            ts.add(r);
        }
        for (NonUniversityLocation l : NonUniversityLocationDAO.getInstance().getSession().createQuery(AcademicSessionMerge.buildRoomQueryForDepartment(department, session, "NonUniversityLocation"), NonUniversityLocation.class).list()) {
            for (RoomDept rd : l.getRoomDepts()) {
                rd.getDepartment();
            }
            ts.add(l);
        }
        return ts;
    }

    private Set<Location> getLocationsFor(PreferenceGroup fromPrefGroup, PreferenceGroup toPrefGroup, String defaultPrefix) {
        if (fromPrefGroup instanceof Exam) {
            Exam exam = (Exam)fromPrefGroup;
            if (!this.getRoomList().containsKey(exam.getExamType())) {
                this.getRoomList().put(exam.getExamType(), Location.findAllExamLocations(this.iMergedSession.getUniqueId(), exam.getExamType()));
            }
            return this.getRoomList().get(exam.getExamType());
        }
        Department toDepartment = this.findToManagingDepartmentForPrefGroup(toPrefGroup, fromPrefGroup, defaultPrefix);
        if (toDepartment == null) {
            return null;
        }
        if (!this.getRoomList().containsKey(toDepartment)) {
            this.getRoomList().put(toDepartment, AcademicSessionMerge.buildRoomListForDepartment(toDepartment, this.iMergedSession));
        }
        return this.getRoomList().get(toDepartment);
    }

    private void createToBuildingPref(BuildingPref fromBuildingPref, PreferenceGroup fromPrefGroup, PreferenceGroup toPrefGroup, Set<Location> locations, boolean isExamPref, boolean isClassMerge) throws Exception {
        if (fromPrefGroup instanceof Class_ && !isClassMerge) {
            return;
        }
        BuildingPref toBuildingPref = null;
        Building toBuilding = fromBuildingPref.getBuilding().findSameBuildingInSession(this.iMergedSession);
        if (toBuilding != null) {
            boolean deptHasRoomInBuilding = false;
            if (!isExamPref) {
                for (Location loc : locations) {
                    Room r;
                    if (!(loc instanceof Room) || (r = (Room)loc).getBuilding() == null || !r.getBuilding().getUniqueId().equals(toBuilding.getUniqueId())) continue;
                    deptHasRoomInBuilding = true;
                    break;
                }
            }
            if (isExamPref || deptHasRoomInBuilding) {
                toBuildingPref = new BuildingPref();
                toBuildingPref.setBuilding(toBuilding);
                toBuildingPref.setPrefLevel(fromBuildingPref.getPrefLevel());
                toBuildingPref.setDistanceFrom(fromBuildingPref.getDistanceFrom());
                toBuildingPref.setOwner(toPrefGroup);
                toPrefGroup.addToPreferences(toBuildingPref);
            }
        }
    }

    protected void mergeBuildingPrefs(PreferenceGroup fromPrefGroup, PreferenceGroup toPrefGroup, boolean isClassMerge, boolean isSubpartMerge, boolean isClassPrefsPushUp, SessionRollForward.CancelledClassAction cancelledClassAction, String defaultPrefix) throws Exception {
        Set<Location> locations = null;
        boolean isExamPref = false;
        if (fromPrefGroup instanceof Exam) {
            isExamPref = true;
        }
        if (!(fromPrefGroup.getBuildingPreferences() == null || fromPrefGroup.getBuildingPreferences().isEmpty() || fromPrefGroup instanceof Class_ && !isClassMerge || fromPrefGroup instanceof SchedulingSubpart && !isSubpartMerge)) {
            locations = this.getLocationsFor(fromPrefGroup, toPrefGroup, defaultPrefix);
            if (!isExamPref && locations == null) {
                return;
            }
            Iterator<BuildingPref> it = fromPrefGroup.getBuildingPreferences().iterator();
            while (it.hasNext()) {
                this.createToBuildingPref(it.next(), fromPrefGroup, toPrefGroup, locations, isExamPref, isClassMerge);
            }
        }
        if (fromPrefGroup instanceof SchedulingSubpart && isClassPrefsPushUp && (toPrefGroup.getBuildingPreferences() == null || toPrefGroup.getBuildingPreferences().isEmpty())) {
            SchedulingSubpart ss = (SchedulingSubpart)fromPrefGroup;
            if (locations == null) {
                locations = this.getLocationsFor(fromPrefGroup, toPrefGroup, defaultPrefix);
            }
            if (locations != null && locations.size() > 0 && ss.getClasses() != null && !ss.getClasses().isEmpty()) {
                HashMap<CallSite, BuildingPref> prefMap = new HashMap<CallSite, BuildingPref>();
                HashMap<CallSite, Integer> prefCount = new HashMap<CallSite, Integer>();
                int clsCnt = 0;
                for (Class_ c : ss.getClasses()) {
                    if (SessionRollForward.CancelledClassAction.SKIP == cancelledClassAction && c.isCancelled().booleanValue()) continue;
                    ++clsCnt;
                    if (c.getBuildingPreferences() == null || c.getBuildingPreferences().isEmpty()) continue;
                    for (BuildingPref rfp : c.getBuildingPreferences()) {
                        String key = rfp.getPrefLevel().getPrefName() + rfp.getBuilding().getUniqueId().toString();
                        prefMap.put((CallSite)((Object)key), rfp);
                        int cnt = 0;
                        if (prefCount.containsKey(key)) {
                            cnt = (Integer)prefCount.get(key);
                        }
                        prefCount.put((CallSite)((Object)key), ++cnt);
                    }
                }
                for (String pref : prefCount.keySet()) {
                    if ((Integer)prefCount.get(pref) != clsCnt) continue;
                    this.createToBuildingPref((BuildingPref)prefMap.get(pref), fromPrefGroup, toPrefGroup, locations, isExamPref, isClassMerge);
                }
            }
        }
    }

    private void mergeDepartmentalInstructorAttributesToSession(Department fromDepartment, Department toDepartment) {
        HashMap<Long, InstructorAttribute> attributes = new HashMap<Long, InstructorAttribute>();
        List<InstructorAttribute> departmentalAttributes = InstructorAttribute.getAllDepartmentalAttributes(fromDepartment.getUniqueId());
        HashMap<String, InstructorAttribute> existingToDepartmentalAttributes = new HashMap<String, InstructorAttribute>();
        for (InstructorAttribute ia : InstructorAttribute.getAllDepartmentalAttributes(toDepartment.getUniqueId())) {
            existingToDepartmentalAttributes.put(ia.getNameWithType(), ia);
        }
        for (InstructorAttribute fromAttribute : departmentalAttributes) {
            InstructorAttribute toAttribute = (InstructorAttribute)existingToDepartmentalAttributes.get(fromAttribute.getNameWithType());
            if (toAttribute == null) {
                toAttribute = new InstructorAttribute();
                toAttribute.setSession(toDepartment.getSession());
                toAttribute.setDepartment(toDepartment);
                toAttribute.setCode(fromAttribute.getCode());
                toAttribute.setName(fromAttribute.getName());
                toAttribute.setType(fromAttribute.getType());
                toAttribute.setInstructors(new HashSet<DepartmentalInstructor>());
                toAttribute.setChildAttributes(new HashSet<InstructorAttribute>());
                attributes.put(fromAttribute.getUniqueId(), toAttribute);
                InstructorAttributeDAO.getInstance().getSession().persist((Object)toAttribute);
            }
            attributes.put(fromAttribute.getUniqueId(), toAttribute);
        }
        for (InstructorAttribute fromChildAttribute : departmentalAttributes) {
            if (fromChildAttribute.getParentAttribute() == null) continue;
            InstructorAttribute toChildAttribute = (InstructorAttribute)attributes.get(fromChildAttribute.getUniqueId());
            InstructorAttribute toParentAttribute = (InstructorAttribute)attributes.get(fromChildAttribute.getParentAttribute().getUniqueId());
            if (toParentAttribute == null) continue;
            toChildAttribute.setParentAttribute(toParentAttribute);
            toParentAttribute.getChildAttributes().add(toChildAttribute);
            InstructorAttributeDAO.getInstance().getSession().merge((Object)toChildAttribute);
        }
    }

    public HashSet<Department> findToDepartmentsForInstructor(DepartmentalInstructor fromDepartmentalInstructor, String defaultPrefix) {
        HashSet<Department> departments = new HashSet<Department>();
        Department d = null;
        d = this.findToDepartment(fromDepartmentalInstructor.getDepartment(), defaultPrefix);
        if (d != null) {
            departments.add(d);
        }
        for (ClassInstructor ci : fromDepartmentalInstructor.getClasses()) {
            if (ci.getClassInstructing().getManagingDept() == null || !this.iDepartmentCodesWithDifferentPrefix.containsKey(ci.getClassInstructing().getManagingDept().getDeptCode()) || (d = this.findToDepartment(ci.getClassInstructing().getManagingDept(), defaultPrefix)) == null) continue;
            departments.add(d);
        }
        return departments;
    }

    private void createToRoomPref(RoomPref fromRoomPref, PreferenceGroup fromPrefGroup, PreferenceGroup toPrefGroup, Set<Location> locations, boolean isClassMerge) {
        if (fromPrefGroup instanceof Class_ && !isClassMerge) {
            return;
        }
        RoomPref toRoomPref = new RoomPref();
        if (fromRoomPref.getRoom() instanceof Room) {
            Location loc;
            Room fromRoom = (Room)fromRoomPref.getRoom();
            BaseRoom toRoom = null;
            Iterator<Location> iterator = locations.iterator();
            while (!(!iterator.hasNext() || (loc = iterator.next()) instanceof Room && ((toRoom = (Room)loc).getBuilding().getExternalUniqueId() != null && fromRoom.getBuilding().getExternalUniqueId() != null && toRoom.getBuilding().getExternalUniqueId().equals(fromRoom.getBuilding().getExternalUniqueId()) || (toRoom.getBuilding().getExternalUniqueId() == null || fromRoom.getBuilding().getExternalUniqueId() == null) && toRoom.getBuilding().getAbbreviation().equals(fromRoom.getBuilding().getAbbreviation())) && toRoom.getRoomNumber().equals(fromRoom.getRoomNumber()))) {
            }
            if (toRoom != null && (toRoom.getBuilding().getExternalUniqueId() != null && fromRoom.getBuilding().getExternalUniqueId() != null && toRoom.getBuilding().getExternalUniqueId().equals(fromRoom.getBuilding().getExternalUniqueId()) || (toRoom.getBuilding().getExternalUniqueId() == null || fromRoom.getBuilding().getExternalUniqueId() == null) && toRoom.getBuilding().getAbbreviation().equals(fromRoom.getBuilding().getAbbreviation())) && toRoom.getRoomNumber().equals(fromRoom.getRoomNumber())) {
                toRoomPref.setRoom(toRoom);
                toRoomPref.setPrefLevel(fromRoomPref.getPrefLevel());
                toRoomPref.setOwner(toPrefGroup);
                toPrefGroup.addToPreferences(toRoomPref);
            }
        } else if (fromRoomPref.getRoom() instanceof NonUniversityLocation) {
            Location loc;
            NonUniversityLocation fromNonUniversityLocation = (NonUniversityLocation)fromRoomPref.getRoom();
            BaseNonUniversityLocation toNonUniversityLocation = null;
            Iterator<Location> iterator = locations.iterator();
            while (!(!iterator.hasNext() || (loc = iterator.next()) instanceof NonUniversityLocation && (toNonUniversityLocation = (NonUniversityLocation)loc).getName().equals(fromNonUniversityLocation.getName()))) {
            }
            if (toNonUniversityLocation != null && toNonUniversityLocation.getName().equals(fromNonUniversityLocation.getName())) {
                toRoomPref.setRoom(toNonUniversityLocation);
                toRoomPref.setPrefLevel(fromRoomPref.getPrefLevel());
                toRoomPref.setOwner(toPrefGroup);
                toPrefGroup.addToPreferences(toRoomPref);
            }
        }
    }

    protected void mergeRoomPrefsToSession(PreferenceGroup fromPrefGroup, PreferenceGroup toPrefGroup, boolean isClassMerge, boolean isSubpartMerge, boolean isClassPrefsPushUp, SessionRollForward.CancelledClassAction cancelledClassAction, String defaultPrefix) {
        Set<Location> locations = null;
        if (!(fromPrefGroup.getRoomPreferences() == null || fromPrefGroup.getRoomPreferences().isEmpty() || fromPrefGroup instanceof Class_ && !isClassMerge || fromPrefGroup instanceof SchedulingSubpart && !isSubpartMerge || (locations = this.getLocationsFor(fromPrefGroup, toPrefGroup, defaultPrefix)) == null || locations.size() <= 0)) {
            Iterator<RoomPref> it = fromPrefGroup.getRoomPreferences().iterator();
            while (it.hasNext()) {
                this.createToRoomPref(it.next(), fromPrefGroup, toPrefGroup, locations, isClassMerge);
            }
        }
        if (fromPrefGroup instanceof SchedulingSubpart && isClassPrefsPushUp && (toPrefGroup.getRoomPreferences() == null || toPrefGroup.getRoomPreferences().isEmpty())) {
            SchedulingSubpart ss = (SchedulingSubpart)fromPrefGroup;
            if (locations == null) {
                locations = this.getLocationsFor(fromPrefGroup, toPrefGroup, defaultPrefix);
            }
            if (locations != null && locations.size() > 0 && ss.getClasses() != null && !ss.getClasses().isEmpty()) {
                HashMap<CallSite, RoomPref> prefMap = new HashMap<CallSite, RoomPref>();
                HashMap<CallSite, Integer> prefCount = new HashMap<CallSite, Integer>();
                int clsCnt = 0;
                for (Class_ c : ss.getClasses()) {
                    if (SessionRollForward.CancelledClassAction.SKIP == cancelledClassAction && c.isCancelled().booleanValue()) continue;
                    ++clsCnt;
                    if (c.getRoomPreferences() == null || c.getRoomPreferences().isEmpty()) continue;
                    for (RoomPref rfp : c.getRoomPreferences()) {
                        String key = rfp.getPrefLevel().getPrefName() + rfp.getRoom().getUniqueId().toString();
                        prefMap.put((CallSite)((Object)key), rfp);
                        int cnt = 0;
                        if (prefCount.containsKey(key)) {
                            cnt = (Integer)prefCount.get(key);
                        }
                        prefCount.put((CallSite)((Object)key), ++cnt);
                    }
                }
                for (String pref : prefCount.keySet()) {
                    if ((Integer)prefCount.get(pref) != clsCnt) continue;
                    this.createToRoomPref((RoomPref)prefMap.get(pref), fromPrefGroup, toPrefGroup, locations, isClassMerge);
                }
            }
        }
    }

    private void createToRoomFeaturePref(RoomFeaturePref fromRoomFeaturePref, PreferenceGroup fromPrefGroup, PreferenceGroup toPrefGroup, boolean isClassMerge, String defaultPrefix) {
        if (fromPrefGroup instanceof Class_ && !isClassMerge) {
            return;
        }
        RoomFeaturePref toRoomFeaturePref = new RoomFeaturePref();
        if (fromRoomFeaturePref.getRoomFeature() instanceof GlobalRoomFeature) {
            GlobalRoomFeature grf = GlobalRoomFeature.findGlobalRoomFeatureForLabel(this.iMergedSession, fromRoomFeaturePref.getRoomFeature().getLabel());
            if (grf != null) {
                toRoomFeaturePref.setRoomFeature(grf);
                toRoomFeaturePref.setPrefLevel(fromRoomFeaturePref.getPrefLevel());
                toRoomFeaturePref.setOwner(toPrefGroup);
                toPrefGroup.addToPreferences(toRoomFeaturePref);
            }
        } else {
            Department toDepartment = this.findToManagingDepartmentForPrefGroup(toPrefGroup, fromPrefGroup, defaultPrefix);
            if (toDepartment == null) {
                return;
            }
            List<DepartmentRoomFeature> l = DepartmentRoomFeature.getAllDepartmentRoomFeatures(toDepartment);
            DepartmentRoomFeature fromDepartmentRoomFeature = (DepartmentRoomFeature)fromRoomFeaturePref.getRoomFeature();
            if (l != null && l.size() > 0) {
                BaseRoomFeature toDepartmentRoomFeature = null;
                Iterator rfIt = l.iterator();
                while (rfIt.hasNext() && !(toDepartmentRoomFeature = (DepartmentRoomFeature)rfIt.next()).getLabel().equals(fromDepartmentRoomFeature.getLabel())) {
                }
                if (toDepartmentRoomFeature.getLabel().equals(fromDepartmentRoomFeature.getLabel())) {
                    toRoomFeaturePref.setRoomFeature((RoomFeature)toDepartmentRoomFeature);
                    toRoomFeaturePref.setPrefLevel(fromRoomFeaturePref.getPrefLevel());
                    toRoomFeaturePref.setOwner(toPrefGroup);
                    toPrefGroup.addToPreferences(toRoomFeaturePref);
                }
            }
        }
    }

    protected void mergeRoomFeaturePrefsToSession(PreferenceGroup fromPrefGroup, PreferenceGroup toPrefGroup, boolean isClassMerge, boolean isSubpartMerge, boolean isClassPrefsPushUp, SessionRollForward.CancelledClassAction cancelledClassAction, String defaultPrefix) {
        SchedulingSubpart ss;
        if (!(fromPrefGroup.getRoomFeaturePreferences() == null || fromPrefGroup.getRoomFeaturePreferences().isEmpty() || fromPrefGroup instanceof Class_ && !isClassMerge || fromPrefGroup instanceof SchedulingSubpart && !isSubpartMerge)) {
            Iterator<RoomFeaturePref> it = fromPrefGroup.getRoomFeaturePreferences().iterator();
            while (it.hasNext()) {
                this.createToRoomFeaturePref(it.next(), fromPrefGroup, toPrefGroup, isClassMerge, defaultPrefix);
            }
        }
        if (fromPrefGroup instanceof SchedulingSubpart && isClassPrefsPushUp && (toPrefGroup.getRoomFeaturePreferences() == null || toPrefGroup.getRoomFeaturePreferences().isEmpty()) && (ss = (SchedulingSubpart)fromPrefGroup).getClasses() != null && !ss.getClasses().isEmpty()) {
            HashMap<CallSite, RoomFeaturePref> prefMap = new HashMap<CallSite, RoomFeaturePref>();
            HashMap<CallSite, Integer> prefCount = new HashMap<CallSite, Integer>();
            int clsCnt = 0;
            for (Class_ c : ss.getClasses()) {
                if (SessionRollForward.CancelledClassAction.SKIP == cancelledClassAction && c.isCancelled().booleanValue()) continue;
                ++clsCnt;
                if (c.getRoomFeaturePreferences() == null || c.getRoomFeaturePreferences().isEmpty()) continue;
                for (RoomFeaturePref rfp : c.getRoomFeaturePreferences()) {
                    String key = rfp.getPrefLevel().getPrefName() + rfp.getRoomFeature().getUniqueId().toString();
                    prefMap.put((CallSite)((Object)key), rfp);
                    int cnt = 0;
                    if (prefCount.containsKey(key)) {
                        cnt = (Integer)prefCount.get(key);
                    }
                    prefCount.put((CallSite)((Object)key), ++cnt);
                }
            }
            for (String pref : prefCount.keySet()) {
                if ((Integer)prefCount.get(pref) != clsCnt) continue;
                this.createToRoomFeaturePref((RoomFeaturePref)prefMap.get(pref), fromPrefGroup, toPrefGroup, isClassMerge, defaultPrefix);
            }
        }
    }

    private void createToRoomGroupPref(RoomGroupPref fromRoomGroupPref, PreferenceGroup fromPrefGroup, PreferenceGroup toPrefGroup, boolean isClassMerge, String defaultPrefix) {
        if (fromPrefGroup instanceof Class_ && !isClassMerge) {
            return;
        }
        RoomGroupPref toRoomGroupPref = new RoomGroupPref();
        RoomGroup toDefaultRoomGroup = RoomGroup.getGlobalDefaultRoomGroup(this.iMergedSession);
        if (fromRoomGroupPref.getRoomGroup().isDefaultGroup().booleanValue() && toDefaultRoomGroup != null) {
            toRoomGroupPref.setRoomGroup(toDefaultRoomGroup);
            toRoomGroupPref.setPrefLevel(fromRoomGroupPref.getPrefLevel());
            toRoomGroupPref.setOwner(toPrefGroup);
            toPrefGroup.addToPreferences(toRoomGroupPref);
        } else if (fromRoomGroupPref.getRoomGroup().isGlobal().booleanValue()) {
            RoomGroup toRoomGroup = RoomGroup.findGlobalRoomGroupForName(this.iMergedSession, fromRoomGroupPref.getRoomGroup().getName());
            if (toRoomGroup != null) {
                toRoomGroupPref.setRoomGroup(toRoomGroup);
                toRoomGroupPref.setPrefLevel(fromRoomGroupPref.getPrefLevel());
                toRoomGroupPref.setOwner(toPrefGroup);
                toPrefGroup.addToPreferences(toRoomGroupPref);
            }
        } else {
            Department toDepartment = this.findToManagingDepartmentForPrefGroup(toPrefGroup, fromPrefGroup, defaultPrefix);
            if (toDepartment == null) {
                return;
            }
            List<RoomGroup> l = RoomGroup.getAllDepartmentRoomGroups(toDepartment);
            if (l != null && l.size() > 0) {
                BaseRoomGroup toRoomGroup = null;
                Iterator itRg = l.iterator();
                while (itRg.hasNext() && !(toRoomGroup = (RoomGroup)itRg.next()).getName().equals(fromRoomGroupPref.getRoomGroup().getName())) {
                }
                if (toRoomGroup.getName().equals(fromRoomGroupPref.getRoomGroup().getName())) {
                    toRoomGroupPref.setRoomGroup((RoomGroup)toRoomGroup);
                    toRoomGroupPref.setPrefLevel(fromRoomGroupPref.getPrefLevel());
                    toRoomGroupPref.setOwner(toPrefGroup);
                    toPrefGroup.addToPreferences(toRoomGroupPref);
                }
            }
        }
    }

    protected void mergeRoomGroupPrefsToSession(PreferenceGroup fromPrefGroup, PreferenceGroup toPrefGroup, boolean isClassMerge, boolean isSubpartMerge, boolean isClassPrefsPushUp, SessionRollForward.CancelledClassAction cancelledClassAction, String defaultPrefix) {
        SchedulingSubpart ss;
        if (!(fromPrefGroup.getRoomGroupPreferences() == null || fromPrefGroup.getRoomGroupPreferences().isEmpty() || fromPrefGroup instanceof Class_ && !isClassMerge || fromPrefGroup instanceof SchedulingSubpart && !isSubpartMerge)) {
            Iterator<RoomGroupPref> it = fromPrefGroup.getRoomGroupPreferences().iterator();
            while (it.hasNext()) {
                this.createToRoomGroupPref(it.next(), fromPrefGroup, toPrefGroup, isClassMerge, defaultPrefix);
            }
        }
        if (fromPrefGroup instanceof SchedulingSubpart && isClassPrefsPushUp && (toPrefGroup.getRoomGroupPreferences() == null || toPrefGroup.getRoomGroupPreferences().isEmpty()) && (ss = (SchedulingSubpart)fromPrefGroup).getClasses() != null && !ss.getClasses().isEmpty()) {
            HashMap<CallSite, RoomGroupPref> prefMap = new HashMap<CallSite, RoomGroupPref>();
            HashMap<CallSite, Integer> prefCount = new HashMap<CallSite, Integer>();
            int clsCnt = 0;
            for (Class_ c : ss.getClasses()) {
                if (SessionRollForward.CancelledClassAction.SKIP == cancelledClassAction && c.isCancelled().booleanValue()) continue;
                ++clsCnt;
                if (c.getRoomGroupPreferences() == null || c.getRoomGroupPreferences().isEmpty()) continue;
                for (RoomGroupPref rfp : c.getRoomGroupPreferences()) {
                    String key = rfp.getPrefLevel().getPrefName() + rfp.getRoomGroup().getUniqueId().toString();
                    prefMap.put((CallSite)((Object)key), rfp);
                    int cnt = 0;
                    if (prefCount.containsKey(key)) {
                        cnt = (Integer)prefCount.get(key);
                    }
                    prefCount.put((CallSite)((Object)key), ++cnt);
                }
            }
            for (String pref : prefCount.keySet()) {
                if ((Integer)prefCount.get(pref) != clsCnt) continue;
                this.createToRoomGroupPref((RoomGroupPref)prefMap.get(pref), fromPrefGroup, toPrefGroup, isClassMerge, defaultPrefix);
            }
        }
    }

    protected void mergeTimePrefsToSession(PreferenceGroup fromPrefGroup, PreferenceGroup toPrefGroup, boolean isClassMerge, boolean isSubpartMerge, boolean isClassPrefsPushUp, SessionRollForward.CancelledClassAction cancelledClassAction) {
        SchedulingSubpart ss;
        TimePref toTimePref;
        TimePref fromTimePref2;
        if (!(fromPrefGroup.getTimePreferences() == null || fromPrefGroup.getTimePreferences().isEmpty() || fromPrefGroup instanceof Class_ && !isClassMerge || fromPrefGroup instanceof SchedulingSubpart && !isSubpartMerge)) {
            fromTimePref2 = null;
            toTimePref = null;
            for (TimePref fromTimePref2 : fromPrefGroup.getTimePreferences()) {
                if (fromTimePref2.getTimePattern() == null) {
                    toTimePref = (TimePref)fromTimePref2.clone();
                } else if (fromTimePref2.getTimePattern().isExactTime()) {
                    TimePattern toTimePattern = TimePattern.findExactTime(this.iMergedSession.getUniqueId());
                    if (toTimePattern == null) {
                        this.iLog.warn((Object)("To Time Pattern not found, merge session does not contain an 'Exact Time' time pattern:  " + fromTimePref2.getTimePattern().getName() + " for " + fromPrefGroup.htmlLabel()));
                    } else {
                        toTimePref = (TimePref)fromTimePref2.clone();
                        toTimePref.setTimePattern(toTimePattern);
                    }
                } else {
                    toTimePref = TimePattern.getMatchingTimePreference(this.iMergedSession.getUniqueId(), fromTimePref2);
                    if (toTimePref == null) {
                        this.iLog.warn((Object)("To Time Pattern not found:  " + fromTimePref2.getTimePattern().getName() + " for " + fromPrefGroup.htmlLabel()));
                    }
                }
                if (toTimePref == null) continue;
                toTimePref.setOwner(toPrefGroup);
                toPrefGroup.addToPreferences(toTimePref);
            }
        }
        if (fromPrefGroup instanceof SchedulingSubpart && !isSubpartMerge) {
            fromTimePref2 = null;
            toTimePref = null;
            for (TimePref fromTimePref2 : fromPrefGroup.getTimePreferences()) {
                if (fromTimePref2.getTimePattern() == null) {
                    toTimePref = (TimePref)fromTimePref2.clone();
                } else {
                    toTimePref = TimePattern.getMatchingTimePreference(this.iMergedSession.getUniqueId(), fromTimePref2);
                    if (toTimePref == null) {
                        this.iLog.warn((Object)("To Time Pattern not found:  " + fromTimePref2.getTimePattern().getName() + " for " + fromPrefGroup.htmlLabel()));
                    }
                }
                if (toTimePref == null) continue;
                toTimePref.setPreference(null);
                toTimePref.setOwner(toPrefGroup);
                toPrefGroup.addToPreferences(toTimePref);
            }
        }
        if (fromPrefGroup instanceof SchedulingSubpart && isClassPrefsPushUp && ((ss = (SchedulingSubpart)fromPrefGroup).getTimePreferences() == null || ss.getTimePreferences().isEmpty()) && ss.getClasses() != null && !ss.getClasses().isEmpty()) {
            TimePref toTimePref2;
            HashMap<CallSite, TimePref> prefMap = new HashMap<CallSite, TimePref>();
            HashMap<CallSite, Integer> prefCount = new HashMap<CallSite, Integer>();
            HashSet<TimePattern> timePatterns = new HashSet<TimePattern>();
            int clsCnt = 0;
            for (Class_ c : ss.getClasses()) {
                if (SessionRollForward.CancelledClassAction.SKIP == cancelledClassAction && c.isCancelled().booleanValue()) continue;
                ++clsCnt;
                if (c.getTimePreferences() == null || c.getTimePreferences().isEmpty()) continue;
                for (TimePref tp : c.getTimePreferences()) {
                    String key = tp.getPrefLevel().getPrefName() + tp.getTimePattern().getUniqueId().toString() + tp.getPreference();
                    prefMap.put((CallSite)((Object)key), tp);
                    timePatterns.add(tp.getTimePattern());
                    int cnt = 0;
                    if (prefCount.containsKey(key)) {
                        cnt = (Integer)prefCount.get(key);
                    }
                    prefCount.put((CallSite)((Object)key), ++cnt);
                }
            }
            for (String pref : prefCount.keySet()) {
                if ((Integer)prefCount.get(pref) != clsCnt) continue;
                TimePref fromTimePref3 = (TimePref)prefMap.get(pref);
                toTimePref2 = null;
                if (fromTimePref3.getTimePattern() == null) {
                    toTimePref2 = (TimePref)fromTimePref3.clone();
                } else {
                    if (fromTimePref3.getTimePattern().getType().intValue() == TimePattern.TimePatternType.ExactTime.ordinal()) continue;
                    toTimePref2 = TimePattern.getMatchingTimePreference(this.iMergedSession.getUniqueId(), fromTimePref3);
                    if (toTimePref2 == null) {
                        this.iLog.warn((Object)("To Time Pattern not found:  " + fromTimePref3.getTimePattern().getName() + " for " + fromPrefGroup.htmlLabel()));
                    }
                }
                if (toTimePref2 != null) {
                    toTimePref2.setOwner(toPrefGroup);
                    toPrefGroup.addToPreferences(toTimePref2);
                    if (toTimePref2.getPreference().contains("R") || toTimePref2.getPreference().contains("P")) {
                        toTimePref2.setPreference(null);
                    }
                }
                timePatterns.remove(fromTimePref3.getTimePattern());
            }
            for (TimePattern fromTp : timePatterns) {
                if (fromTp.getType().intValue() == TimePattern.TimePatternType.ExactTime.ordinal()) continue;
                TimePattern toTp = TimePattern.getMatchingTimePattern(this.iMergedSession.getUniqueId(), fromTp);
                toTimePref2 = null;
                if (toTp != null) {
                    toTimePref2 = new TimePref();
                    toTimePref2.setOwner(toPrefGroup);
                    toTimePref2.setTimePattern(toTp);
                    toTimePref2.setPrefLevel(PreferenceLevel.getPreferenceLevel("R"));
                    toPrefGroup.addToPreferences(toTimePref2);
                    continue;
                }
                this.iLog.warn((Object)("To Time Pattern not found:  " + fromTp.getName() + " for " + fromPrefGroup.htmlLabel()));
            }
        }
    }

    protected void mergeInstructorDistributionPrefsToSession(DepartmentalInstructor fromInstructor, DepartmentalInstructor toInstructor) {
        if (fromInstructor.getDistributionPreferences() != null && fromInstructor.getDistributionPreferences().size() > 0) {
            DistributionPref fromDistributionPref2 = null;
            DistributionPref toDistributionPref = null;
            for (DistributionPref fromDistributionPref2 : fromInstructor.getDistributionPreferences()) {
                toDistributionPref = new DistributionPref();
                if (fromDistributionPref2.getDistributionType() != null) {
                    toDistributionPref.setDistributionType(fromDistributionPref2.getDistributionType());
                }
                if (fromDistributionPref2.getGrouping() != null) {
                    toDistributionPref.setGrouping(fromDistributionPref2.getGrouping());
                }
                toDistributionPref.setPrefLevel(fromDistributionPref2.getPrefLevel());
                toDistributionPref.setOwner(toInstructor);
                toInstructor.addToPreferences(toDistributionPref);
            }
        }
    }

    public void copyMergeInstructorDataToSession(Session fromSession, String defaultPrefix) {
        block9: {
            DepartmentalInstructor toInstructor = null;
            DepartmentalInstructorDAO iDao = DepartmentalInstructorDAO.getInstance();
            try {
                if (fromSession.getDepartments() == null) break block9;
                Department primaryToDepartment = null;
                String existingQuery = "select di.department.deptCode || di.externalUniqueId from DepartmentalInstructor di where di.department.session.uniqueId = :sessionId and di.externalUniqueId is not null";
                List existingInstructors = iDao.getSession().createQuery(existingQuery, String.class).setParameter("sessionId", (Object)this.iMergedSession.getUniqueId()).list();
                String existingNoExtIdQuery = "select di.department.deptCode || di.lastName || ',' || di.firstName || ',' || di.middleName from DepartmentalInstructor di where di.department.session.uniqueId = :sessionId and di.externalUniqueId is null";
                List existingNoExtIdInstructors = iDao.getSession().createQuery(existingNoExtIdQuery, String.class).setParameter("sessionId", (Object)this.iMergedSession.getUniqueId()).list();
                List<Department> departments = DepartmentDAO.getInstance().findBySession(iDao.getSession(), fromSession.getUniqueId());
                for (Department fromDepartment : departments) {
                    if (fromDepartment == null || fromDepartment.getInstructors() == null || fromDepartment.getInstructors().isEmpty()) continue;
                    primaryToDepartment = this.findToDepartment(fromDepartment, defaultPrefix);
                    if (primaryToDepartment != null) {
                        this.mergeDepartmentalInstructorAttributesToSession(fromDepartment, primaryToDepartment);
                        for (DepartmentalInstructor fromInstructor : fromDepartment.getInstructors()) {
                            for (Department toDepartment : this.findToDepartmentsForInstructor(fromInstructor, defaultPrefix)) {
                                if (fromInstructor.getExternalUniqueId() != null && !fromInstructor.getExternalUniqueId().isEmpty() && existingInstructors.contains(toDepartment.getDeptCode() + fromInstructor.getExternalUniqueId())) {
                                    this.iLog.info((Object)(fromInstructor.toString() + ": already exists in term, not merging"));
                                    continue;
                                }
                                if ((fromInstructor.getExternalUniqueId() == null || fromInstructor.getExternalUniqueId().isEmpty()) && existingNoExtIdInstructors.contains(toDepartment.getDeptCode() + fromInstructor.getLastName() + "," + fromInstructor.getFirstName() + "," + fromInstructor.getMiddleName())) {
                                    this.iLog.info((Object)(fromInstructor.toString() + ": already exists in term, not merging"));
                                    continue;
                                }
                                toInstructor = (DepartmentalInstructor)fromInstructor.clone();
                                toInstructor.setDepartment(toDepartment);
                                toInstructor.setAttributes(new HashSet<InstructorAttribute>());
                                for (InstructorAttribute fromAttribute : fromInstructor.getAttributes()) {
                                    InstructorAttribute toAttribute = fromAttribute.findSameAttributeInSession(this.iMergedSession);
                                    if (toAttribute == null) continue;
                                    toAttribute.addToInstructors(toInstructor);
                                    toInstructor.addToAttributes(toAttribute);
                                }
                                this.mergeBuildingPrefs(fromInstructor, toInstructor, false, false, false, null, defaultPrefix);
                                this.mergeRoomPrefsToSession(fromInstructor, toInstructor, false, false, false, null, defaultPrefix);
                                this.mergeRoomFeaturePrefsToSession(fromInstructor, toInstructor, false, false, false, null, defaultPrefix);
                                this.mergeRoomGroupPrefsToSession(fromInstructor, toInstructor, false, false, false, null, defaultPrefix);
                                this.mergeTimePrefsToSession(fromInstructor, toInstructor, false, false, false, null);
                                this.mergeInstructorDistributionPrefsToSession(fromInstructor, toInstructor);
                                iDao.getSession().persist((Object)toInstructor);
                            }
                        }
                        continue;
                    }
                    this.iLog.info((Object)("Primary To Department Not Found For:  " + fromDepartment.getLabel()));
                }
                iDao.getSession().flush();
            }
            catch (Exception e) {
                this.iLog.error((Object)"Failed to merge all instructors to session.", (Throwable)e);
            }
        }
    }

    private HashSet<String> getPrefixesForOffering(InstructionalOffering instructionalOffering, String defaultPrefix) {
        HashSet<String> prefixList = new HashSet<String>();
        if (this.iOfferingPrefixesCache.containsKey(instructionalOffering.getUniqueId())) {
            return this.iOfferingPrefixesCache.get(instructionalOffering.getUniqueId());
        }
        if (this.iUseCampusPrefixForSubjectAreas) {
            for (InstrOfferingConfig ioc : instructionalOffering.getInstrOfferingConfigs()) {
                prefixList.add(this.getPrefixForInstrOfferingConfig(ioc, defaultPrefix));
            }
            if (prefixList.isEmpty()) {
                prefixList.add(defaultPrefix);
            }
        }
        if (prefixList.isEmpty()) {
            prefixList.add(null);
        }
        this.iOfferingPrefixesCache.put(instructionalOffering.getUniqueId(), prefixList);
        return prefixList;
    }

    private String getPrefixForInstrOfferingConfig(InstrOfferingConfig instrOfferingConfig, String defaultPrefix) {
        String iocPrefix = null;
        for (SchedulingSubpart ss : instrOfferingConfig.getSchedulingSubparts()) {
            Department managingDept = ss.getManagingDept();
            if (this.iDepartmentCodesWithDifferentPrefix.containsKey(managingDept.getDeptCode())) {
                if (iocPrefix == null) {
                    iocPrefix = this.iDepartmentCodesWithDifferentPrefix.get(managingDept.getDeptCode());
                    continue;
                }
                if (iocPrefix.equals(this.iDepartmentCodesWithDifferentPrefix.get(managingDept.getDeptCode()))) continue;
                iocPrefix = defaultPrefix;
                break;
            }
            if (iocPrefix != null) continue;
            iocPrefix = defaultPrefix;
            break;
        }
        return iocPrefix;
    }

    private HashMap<String, InstructionalOffering> createToInstructionalOfferingsFromFromInstructionalOffering(InstructionalOffering fromInstructionalOffering, String defaultPrefix, boolean mergeWaitListsProhibitedOverrides) {
        HashMap<String, InstructionalOffering> offeringMap = new HashMap<String, InstructionalOffering>();
        for (String prefix : this.getPrefixesForOffering(fromInstructionalOffering, defaultPrefix)) {
            offeringMap.put(prefix, this.createToInstructionalOfferingFromFromInstructionalOffering(fromInstructionalOffering, prefix, mergeWaitListsProhibitedOverrides));
        }
        return offeringMap;
    }

    private InstructionalOffering createToInstructionalOfferingFromFromInstructionalOffering(InstructionalOffering fromInstructionalOffering, String prefix, boolean mergeWaitListsProhibitedOverrides) {
        if (fromInstructionalOffering == null) {
            return null;
        }
        InstructionalOffering toInstructionalOffering = null;
        CourseOffering fromControlingCourse = fromInstructionalOffering.getControllingCourseOffering();
        CourseOffering toControllingCourse = null;
        String subject = (String)(prefix != null ? prefix + this.iPrefixSeparator : "") + fromControlingCourse.getSubjectArea().getSubjectAreaAbbreviation();
        toControllingCourse = CourseOffering.findBySessionSubjAreaAbbvCourseNbr(this.iMergedSession.getUniqueId(), subject, fromControlingCourse.getCourseNbr());
        if (toControllingCourse != null) {
            toInstructionalOffering = toControllingCourse.getInstructionalOffering();
        } else {
            toInstructionalOffering = new InstructionalOffering();
            toInstructionalOffering.setSession(this.iMergedSession);
        }
        toInstructionalOffering.setNotOffered(fromInstructionalOffering.isNotOffered());
        toInstructionalOffering.setUniqueIdRolledForwardFrom(fromInstructionalOffering.getUniqueId());
        toInstructionalOffering.setInstrOfferingPermId(fromInstructionalOffering.getInstrOfferingPermId());
        toInstructionalOffering.setByReservationOnly(fromInstructionalOffering.isByReservationOnly());
        toInstructionalOffering.setLastWeekToEnroll(fromInstructionalOffering.getLastWeekToEnroll());
        toInstructionalOffering.setLastWeekToChange(fromInstructionalOffering.getLastWeekToChange());
        toInstructionalOffering.setLastWeekToDrop(fromInstructionalOffering.getLastWeekToDrop());
        toInstructionalOffering.setNotes(fromInstructionalOffering.getNotes());
        if (mergeWaitListsProhibitedOverrides) {
            toInstructionalOffering.setWaitlistMode(fromInstructionalOffering.getWaitlistMode());
        } else {
            toInstructionalOffering.setWaitlistMode(null);
        }
        CourseOffering fromCourseOffering2 = null;
        CourseOffering toCourseOffering = null;
        for (CourseOffering fromCourseOffering2 : fromInstructionalOffering.getCourseOfferings()) {
            Department toFundingDept;
            SubjectArea toSa = this.findToSubjectArea(fromCourseOffering2.getSubjectArea(), prefix);
            if (toSa == null || (toCourseOffering = CourseOffering.findBySessionSubjAreaAbbvCourseNbr(this.iMergedSession.getUniqueId(), subject, fromControlingCourse.getCourseNbr())) != null) continue;
            toCourseOffering = new CourseOffering();
            toCourseOffering.setSubjectArea(toSa);
            toCourseOffering.setCourseNbr(fromCourseOffering2.getCourseNbr());
            if (fromInstructionalOffering.getCourseOfferings().size() == 1) {
                toCourseOffering.setIsControl(true);
            } else {
                toCourseOffering.setIsControl(fromCourseOffering2.isIsControl());
            }
            toCourseOffering.setExternalUniqueId(fromCourseOffering2.getExternalUniqueId());
            toCourseOffering.setNbrExpectedStudents(fromCourseOffering2.getNbrExpectedStudents());
            toCourseOffering.setDemand(fromCourseOffering2.getDemand());
            toCourseOffering.setPermId(fromCourseOffering2.getPermId());
            toCourseOffering.setScheduleBookNote(fromCourseOffering2.getScheduleBookNote());
            toCourseOffering.setTitle(fromCourseOffering2.getTitle());
            toCourseOffering.setUniqueIdRolledForwardFrom(fromCourseOffering2.getUniqueId());
            toCourseOffering.setInstructionalOffering(toInstructionalOffering);
            toCourseOffering.setReservation(fromCourseOffering2.getReservation());
            toCourseOffering.setConsentType(fromCourseOffering2.getConsentType());
            toCourseOffering.setCourseType(fromCourseOffering2.getCourseType());
            if (fromCourseOffering2.getFundingDept() != null && (toFundingDept = this.findToDepartment(fromCourseOffering2.getDepartment(), prefix)) != null) {
                toCourseOffering.setFundingDept(toFundingDept);
            }
            toInstructionalOffering.addToCourseOfferings(toCourseOffering);
            if (mergeWaitListsProhibitedOverrides && fromCourseOffering2.getDisabledOverrides() != null) {
                toCourseOffering.setDisabledOverrides(new HashSet<OverrideType>(fromCourseOffering2.getDisabledOverrides()));
            }
            if (fromCourseOffering2.getCreditConfigs() == null || fromCourseOffering2.getCreditConfigs().isEmpty()) continue;
            CourseCreditUnitConfig ccuc2 = null;
            for (CourseCreditUnitConfig ccuc2 : fromCourseOffering2.getCreditConfigs()) {
                if (ccuc2 instanceof ArrangeCreditUnitConfig) {
                    ArrangeCreditUnitConfig fromAcuc = (ArrangeCreditUnitConfig)ccuc2;
                    ArrangeCreditUnitConfig toAcuc = (ArrangeCreditUnitConfig)fromAcuc.clone();
                    toAcuc.setOwner(toCourseOffering);
                    toCourseOffering.addToCreditConfigs(toAcuc);
                    continue;
                }
                if (ccuc2 instanceof FixedCreditUnitConfig) {
                    FixedCreditUnitConfig fromFcuc = (FixedCreditUnitConfig)ccuc2;
                    FixedCreditUnitConfig toFcuc = (FixedCreditUnitConfig)fromFcuc.clone();
                    toFcuc.setOwner(toCourseOffering);
                    toCourseOffering.addToCreditConfigs(toFcuc);
                    continue;
                }
                if (ccuc2 instanceof VariableRangeCreditUnitConfig) {
                    VariableRangeCreditUnitConfig fromVrcuc = (VariableRangeCreditUnitConfig)ccuc2;
                    VariableRangeCreditUnitConfig toVrcuc = (VariableRangeCreditUnitConfig)fromVrcuc.clone();
                    toVrcuc.setOwner(toCourseOffering);
                    toCourseOffering.addToCreditConfigs(toVrcuc);
                    continue;
                }
                if (!(ccuc2 instanceof VariableFixedCreditUnitConfig)) continue;
                VariableFixedCreditUnitConfig fromVfcuc = (VariableFixedCreditUnitConfig)ccuc2;
                VariableFixedCreditUnitConfig toVfcuc = (VariableFixedCreditUnitConfig)fromVfcuc.clone();
                toVfcuc.setOwner(toCourseOffering);
                toCourseOffering.addToCreditConfigs(toVfcuc);
            }
        }
        if (toInstructionalOffering.getInstrOfferingPermId() == null) {
            toInstructionalOffering.generateInstrOfferingPermId();
        }
        if (toInstructionalOffering.getUniqueId() == null) {
            InstructionalOfferingDAO.getInstance().getSession().persist((Object)toInstructionalOffering);
        } else {
            int ctrlCount = 0;
            for (CourseOffering co : toInstructionalOffering.getCourseOfferings()) {
                if (!co.isIsControl().booleanValue()) continue;
                ++ctrlCount;
            }
            if (ctrlCount != 1) {
                boolean first = true;
                for (CourseOffering co : toInstructionalOffering.getCourseOfferings()) {
                    if (first) {
                        co.setIsControl(true);
                        continue;
                    }
                    co.setIsControl(false);
                }
            }
            InstructionalOfferingDAO.getInstance().getSession().merge((Object)toInstructionalOffering);
        }
        return toInstructionalOffering;
    }

    private HashMap<String, InstructionalOffering> findToInstructionalOffering(InstructionalOffering fromInstructionalOffering, String defaultPrefix, boolean mergeWaitListsProhibitedOverrides) {
        if (fromInstructionalOffering == null) {
            return null;
        }
        HashMap<String, InstructionalOffering> offeringMap = new HashMap<String, InstructionalOffering>();
        if (this.iDepartmentCodesWithDifferentPrefix == null || this.iDepartmentCodesWithDifferentPrefix.isEmpty()) {
            InstructionalOffering toInstructionalOffering;
            CourseOffering co = CourseOffering.findByIdRolledForwardFrom(this.iMergedSession.getUniqueId(), fromInstructionalOffering.getControllingCourseOffering().getUniqueId());
            if (co == null && ApplicationProperty.CourseOfferingNumberMustBeUnique.isTrue()) {
                co = CourseOffering.findBySessionSubjAreaAbbvCourseNbr(this.iMergedSession.getUniqueId(), fromInstructionalOffering.getControllingCourseOffering().getSubjectArea().getSubjectAreaAbbreviation(), fromInstructionalOffering.getControllingCourseOffering().getCourseNbr());
            }
            if (co != null && (toInstructionalOffering = co.getInstructionalOffering()) != null) {
                toInstructionalOffering.deleteAllClasses(InstructionalOfferingDAO.getInstance().getSession());
                toInstructionalOffering.deleteAllDistributionPreferences(InstructionalOfferingDAO.getInstance().getSession());
                toInstructionalOffering.getInstrOfferingConfigs().clear();
                offeringMap.put(defaultPrefix, toInstructionalOffering);
                return offeringMap;
            }
        }
        return this.createToInstructionalOfferingsFromFromInstructionalOffering(fromInstructionalOffering, defaultPrefix, mergeWaitListsProhibitedOverrides);
    }

    protected void mergeDatePatternPrefsToSession(PreferenceGroup fromPrefGroup, PreferenceGroup toPrefGroup, boolean isClassMerge, boolean isClassPrefsPushUp, SessionRollForward.CancelledClassAction cancelledClassAction, String defaultPrefix) {
        if (!(fromPrefGroup.getDatePatternPreferences() == null || fromPrefGroup.getDatePatternPreferences().isEmpty() || fromPrefGroup instanceof Class_ && !isClassMerge || fromPrefGroup instanceof SchedulingSubpart && !isClassMerge)) {
            DatePatternPref fromDatePatternPref22 = null;
            DatePatternPref toDatePatternPref = null;
            for (DatePatternPref fromDatePatternPref22 : fromPrefGroup.getDatePatternPreferences()) {
                DatePattern toDatePattern = DatePattern.findByName(this.iMergedSession, fromDatePatternPref22.getDatePattern().getName());
                if (toDatePattern == null) {
                    this.iLog.warn((Object)("To Date Pattern not found:  " + fromDatePatternPref22.getDatePattern().getName() + " for " + fromPrefGroup.htmlLabel()));
                    continue;
                }
                toDatePatternPref = (DatePatternPref)fromDatePatternPref22.clone();
                toDatePatternPref.setDatePattern(toDatePattern);
                toDatePatternPref.setOwner(toPrefGroup);
                toPrefGroup.addToPreferences(toDatePatternPref);
            }
        }
        if (fromPrefGroup instanceof SchedulingSubpart && isClassPrefsPushUp && (toPrefGroup.getDatePatternPreferences() == null || toPrefGroup.getDatePatternPreferences().isEmpty())) {
            SchedulingSubpart ss = (SchedulingSubpart)fromPrefGroup;
            Class_DAO cDao = Class_DAO.getInstance();
            if (ss.getClasses() != null && !ss.getClasses().isEmpty()) {
                HashMap<CallSite, DatePatternPref> prefMap = new HashMap<CallSite, DatePatternPref>();
                HashMap<CallSite, Integer> prefCount = new HashMap<CallSite, Integer>();
                int clsCnt = 0;
                BaseDatePattern firstDp = null;
                int dpCount = 0;
                for (Class_ class_ : ss.getClasses()) {
                    if (SessionRollForward.CancelledClassAction.SKIP == cancelledClassAction && class_.isCancelled().booleanValue()) continue;
                    ++clsCnt;
                    DatePattern dp = class_.effectiveDatePattern();
                    if (dp != null) {
                        if (firstDp == null) {
                            firstDp = dp;
                            ++dpCount;
                        } else if (firstDp.equals(dp)) {
                            ++dpCount;
                        }
                    }
                    if (class_.getDatePatternPreferences() == null || class_.getDatePatternPreferences().isEmpty()) continue;
                    for (DatePatternPref dfp : class_.getDatePatternPreferences()) {
                        String key = dfp.getPrefLevel().getPrefName() + dfp.getDatePattern().getUniqueId().toString();
                        prefMap.put((CallSite)((Object)key), dfp);
                        int cnt = 0;
                        if (prefCount.containsKey(key)) {
                            cnt = (Integer)prefCount.get(key);
                        }
                        prefCount.put((CallSite)((Object)key), ++cnt);
                    }
                }
                if (firstDp != null && dpCount == clsCnt && !firstDp.equals(ss.effectiveDatePattern())) {
                    DatePattern toDatePattern = DatePattern.findByName(this.iMergedSession, firstDp.getName());
                    if (toDatePattern == null) {
                        this.iLog.warn((Object)("To Date Pattern not found:  " + firstDp.getName() + " for " + fromPrefGroup.htmlLabel()));
                    } else {
                        ((SchedulingSubpart)toPrefGroup).setDatePattern(toDatePattern);
                        for (Class_ c : ((SchedulingSubpart)toPrefGroup).getClasses()) {
                            c.setDatePattern(null);
                            cDao.getSession().merge((Object)c);
                        }
                    }
                }
                for (String string : prefCount.keySet()) {
                    if ((Integer)prefCount.get(string) != clsCnt) continue;
                    DatePatternPref fromDatePatternPref = (DatePatternPref)prefMap.get(string);
                    DatePattern toDatePattern = DatePattern.findByName(this.iMergedSession, fromDatePatternPref.getDatePattern().getName());
                    if (toDatePattern == null) {
                        this.iLog.warn((Object)("To Date Pattern not found:  " + fromDatePatternPref.getDatePattern().getName() + " for " + fromPrefGroup.htmlLabel()));
                        continue;
                    }
                    DatePatternPref toDatePatternPref = (DatePatternPref)fromDatePatternPref.clone();
                    toDatePatternPref.setDatePattern(toDatePattern);
                    toDatePatternPref.setOwner(toPrefGroup);
                    toPrefGroup.addToPreferences(toDatePatternPref);
                }
            }
        }
    }

    public boolean isMergeDistributionsToSession(DistributionPref dp, SessionRollForward.DistributionMode distributionPrefMode) {
        switch (distributionPrefMode) {
            case ALL: {
                return true;
            }
            case NONE: {
                return false;
            }
            case SUBPART: {
                for (DistributionObject distObj : dp.getDistributionObjects()) {
                    if (!(distObj.getPrefGroup() instanceof Class_)) continue;
                    return false;
                }
                return true;
            }
            case MIXED: {
                for (DistributionObject distObj : dp.getDistributionObjects()) {
                    if (!(distObj.getPrefGroup() instanceof SchedulingSubpart)) continue;
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    protected void mergeDistributionPrefsToSession(PreferenceGroup fromPrefGroup, PreferenceGroup toPrefGroup, SessionRollForward.DistributionMode distributionPrefMode, String defaultPrefix) {
        if (fromPrefGroup.getDistributionObjects() != null && !fromPrefGroup.getDistributionObjects().isEmpty()) {
            DistributionObject fromDistObj2 = null;
            DistributionObject toDistObj = null;
            DistributionPref fromDistributionPref = null;
            DistributionPref toDistributionPref = null;
            DistributionPrefDAO dpDao = DistributionPrefDAO.getInstance();
            for (DistributionObject fromDistObj2 : fromPrefGroup.getDistributionObjects()) {
                toDistObj = new DistributionObject();
                fromDistributionPref = fromDistObj2.getDistributionPref();
                if (!this.isMergeDistributionsToSession(fromDistributionPref, distributionPrefMode)) continue;
                toDistributionPref = DistributionPref.findByIdRolledForwardFrom(fromDistributionPref.getUniqueId(), this.iMergedSession.getUniqueId());
                if (toDistributionPref == null) {
                    toDistributionPref = new DistributionPref();
                    toDistributionPref.setDistributionType(fromDistributionPref.getDistributionType());
                    toDistributionPref.setGrouping(fromDistributionPref.getGrouping());
                    toDistributionPref.setPrefLevel(fromDistributionPref.getPrefLevel());
                    toDistributionPref.setUniqueIdRolledForwardFrom(fromDistributionPref.getUniqueId());
                    Department toDept = this.findToDepartment((Department)fromDistributionPref.getOwner(), defaultPrefix);
                    if (toDept == null) continue;
                    toDistributionPref.setOwner(toDept);
                    toDept.addToPreferences(toDistributionPref);
                }
                toDistObj.setDistributionPref(toDistributionPref);
                toDistObj.setPrefGroup(toPrefGroup);
                toDistObj.setSequenceNumber(fromDistObj2.getSequenceNumber());
                toPrefGroup.addToDistributionObjects(toDistObj);
                if (toDistributionPref.getUniqueId() == null) {
                    dpDao.getSession().persist((Object)toDistributionPref);
                    continue;
                }
                dpDao.getSession().merge((Object)toDistributionPref);
            }
        }
    }

    private void mergeCourseCreditUnitConfigForSchedSubpart(SchedulingSubpart fromSubpart, SchedulingSubpart toSubpart) {
        if (this.iSessionRollForward.sessionHasCourseCatalog(toSubpart.getSession())) {
            CourseCatalog courseCatalogEntry;
            if (fromSubpart.getParentSubpart() != null && !fromSubpart.getParentSubpart().getItype().getItype().equals(fromSubpart.getItype().getItype()) && (courseCatalogEntry = CourseCatalog.findCourseInCatalogForSession(toSubpart.getControllingCourseOffering(), toSubpart.getSession())) != null && courseCatalogEntry.getSubparts() != null) {
                BaseCourseSubpartCredit csc = null;
                boolean found = false;
                Iterator<CourseSubpartCredit> cscIt = courseCatalogEntry.getSubparts().iterator();
                while (cscIt.hasNext() && !found) {
                    csc = cscIt.next();
                    if (!csc.getSubpartId().equals(toSubpart.getItype().getItype().toString())) continue;
                    found = true;
                }
                if (found) {
                    CourseCreditUnitConfig ccuc = CourseCreditUnitConfig.createCreditUnitConfigOfFormat(csc.getCreditFormat(), csc.getCreditType(), csc.getCreditUnitType(), csc.getFixedMinimumCredit(), csc.getMaximumCredit(), csc.isFractionalCreditAllowed(), (Boolean)true);
                    ccuc.setOwner(toSubpart);
                    toSubpart.setCredit(ccuc);
                }
            }
        } else if (fromSubpart.getCredit() != null) {
            Float units = null;
            Float maxUnits = null;
            Boolean fractionalIncrementsAllowed = null;
            if (fromSubpart.getCredit() instanceof FixedCreditUnitConfig) {
                FixedCreditUnitConfig fcuc = (FixedCreditUnitConfig)fromSubpart.getCredit();
                units = fcuc.getFixedUnits();
            } else if (fromSubpart.getCredit() instanceof VariableFixedCreditUnitConfig) {
                VariableFixedCreditUnitConfig vfcuc = (VariableFixedCreditUnitConfig)fromSubpart.getCredit();
                units = vfcuc.getMinUnits();
                maxUnits = vfcuc.getMaxUnits();
            } else if (fromSubpart.getCredit() instanceof VariableRangeCreditUnitConfig) {
                VariableRangeCreditUnitConfig vrcuc = (VariableRangeCreditUnitConfig)fromSubpart.getCredit();
                units = vrcuc.getMinUnits();
                maxUnits = vrcuc.getMaxUnits();
                fractionalIncrementsAllowed = vrcuc.isFractionalIncrementsAllowed();
            }
            CourseCreditUnitConfig ccuc = CourseCreditUnitConfig.createCreditUnitConfigOfFormat(fromSubpart.getCredit().getCreditFormat(), fromSubpart.getCredit().getCreditType(), fromSubpart.getCredit().getCreditUnitType(), units, maxUnits, fractionalIncrementsAllowed, (Boolean)false);
            ccuc.setOwner(toSubpart);
            toSubpart.setCredit(ccuc);
        }
    }

    private Class_ mergeClassToSession(Class_ fromClass, SchedulingSubpart toSubpart, boolean isClassMerge, boolean isSubpartTimePrefMerge, boolean isSubpartLocationPrefMerge, boolean isClassPrefsPushUp, SessionRollForward.DistributionMode distributionPrefMode, SessionRollForward.CancelledClassAction cancelledClassAction, String defaultPrefix) throws Exception {
        GlobalRoomFeature rf;
        Department toFundingDept;
        Class_ toClass = new Class_();
        toClass.setEnabledForStudentScheduling(fromClass.isEnabledForStudentScheduling());
        toClass.setDisplayInstructor(fromClass.isDisplayInstructor());
        toClass.setExpectedCapacity(fromClass.getExpectedCapacity());
        toClass.setMaxExpectedCapacity(fromClass.getMaxExpectedCapacity());
        toClass.setNbrRooms(fromClass.getNbrRooms());
        toClass.setNotes(fromClass.getNotes());
        toClass.setRoomRatio(fromClass.getRoomRatio());
        toClass.setSchedulePrintNote(fromClass.getSchedulePrintNote());
        toClass.setSchedulingSubpart(toSubpart);
        toClass.setUniqueIdRolledForwardFrom(fromClass.getUniqueId());
        if (fromClass.getFundingDept() != null && (toFundingDept = this.findToDepartment(fromClass.getFundingDept(), defaultPrefix)) != null) {
            toClass.setFundingDept(toFundingDept);
        }
        if (fromClass.getLmsInfo() != null) {
            LearningManagementSystemInfo lms = LearningManagementSystemInfo.findBySessionIdAndReference(this.iMergedSession.getUniqueId(), fromClass.getLmsInfo().getReference());
            toClass.setLms(lms);
        }
        if (!this.iResetClassSuffix) {
            toClass.setClassSuffix(fromClass.getClassSuffix());
            toClass.setExternalUniqueId(fromClass.getExternalUniqueId());
        }
        if (SessionRollForward.CancelledClassAction.KEEP == cancelledClassAction) {
            toClass.setCancelled(fromClass.isCancelled());
        } else {
            toClass.setCancelled(false);
        }
        toSubpart.addToClasses(toClass);
        if (fromClass.getManagingDept() != null && !fromClass.getManagingDept().equals(fromClass.getControllingDept())) {
            toClass.setManagingDept(this.findToDepartment(fromClass.getManagingDept(), defaultPrefix));
        }
        if (fromClass.getDatePattern() != null) {
            DatePattern toDp = DatePattern.findByName(this.iMergedSession, fromClass.getDatePattern().getName());
            if (toDp == null) {
                toDp = fromClass.getDatePattern().findCloseMatchDatePatternInSession(this.iMergedSession);
            }
            toClass.setDatePattern(toDp);
        }
        if (isClassMerge) {
            this.mergeTimePrefsToSession(fromClass, toClass, isClassMerge, isSubpartTimePrefMerge, isClassPrefsPushUp, cancelledClassAction);
            this.mergeBuildingPrefs(fromClass, toClass, isClassMerge, isSubpartLocationPrefMerge, isClassPrefsPushUp, cancelledClassAction, defaultPrefix);
            this.mergeRoomPrefsToSession(fromClass, toClass, isClassMerge, isSubpartLocationPrefMerge, isClassPrefsPushUp, cancelledClassAction, defaultPrefix);
            this.mergeRoomGroupPrefsToSession(fromClass, toClass, isClassMerge, isSubpartLocationPrefMerge, isClassPrefsPushUp, cancelledClassAction, defaultPrefix);
            this.mergeRoomFeaturePrefsToSession(fromClass, toClass, isClassMerge, isSubpartLocationPrefMerge, isClassPrefsPushUp, cancelledClassAction, defaultPrefix);
            this.mergeDatePatternPrefsToSession(fromClass, toClass, isClassMerge, isClassPrefsPushUp, cancelledClassAction, defaultPrefix);
        }
        if (distributionPrefMode != null && distributionPrefMode != SessionRollForward.DistributionMode.NONE) {
            this.mergeDistributionPrefsToSession(fromClass, toClass, distributionPrefMode, defaultPrefix);
        }
        if (fromClass.getCommittedAssignment() != null && (rf = this.getCampusRoomFeature(this.findPrefix(fromClass.getManagingDept().getDeptCode(), defaultPrefix))) != null) {
            RoomFeaturePref rfp = new RoomFeaturePref();
            rfp.setOwner(toClass);
            rfp.setPrefLevel(PreferenceLevel.getPreferenceLevel(PreferenceLevel.sRequired));
            rfp.setRoomFeature(rf);
            toClass.addToPreferences(rfp);
        }
        return toClass;
    }

    private void mergeSchedulingSubpartToSession(InstrOfferingConfig toInstrOffrConfig, SchedulingSubpart fromSubpart, MergeSchedSubpart parentSubpart, boolean isClassMerge, boolean isSubpartTimePrefMerge, boolean isSubpartLocationPrefMerge, boolean isClassPrefsPushUp, SessionRollForward.DistributionMode distributionPrefMode, SessionRollForward.CancelledClassAction cancelledClassAction, String defaultPrefix) throws Exception {
        SchedulingSubpart toSubpart = new SchedulingSubpart();
        toSubpart.setAutoSpreadInTime(fromSubpart.isAutoSpreadInTime());
        toSubpart.setStudentAllowOverlap(fromSubpart.isStudentAllowOverlap());
        toSubpart.setInstrOfferingConfig(toInstrOffrConfig);
        toInstrOffrConfig.addToschedulingSubparts(toSubpart);
        toSubpart.setMinutesPerWk(fromSubpart.getMinutesPerWk());
        toSubpart.setItype(fromSubpart.getItype());
        toSubpart.setUniqueIdRolledForwardFrom(fromSubpart.getUniqueId());
        this.mergeCourseCreditUnitConfigForSchedSubpart(fromSubpart, toSubpart);
        if (fromSubpart.getDatePattern() != null) {
            DatePattern toDp = null;
            toDp = DatePattern.findByName(this.iMergedSession, fromSubpart.getDatePattern().getName());
            if (toDp == null) {
                toDp = fromSubpart.getDatePattern().findCloseMatchDatePatternInSession(this.iMergedSession);
            }
            toSubpart.setDatePattern(toDp);
        }
        MergeSchedSubpart rfSs = new MergeSchedSubpart();
        rfSs.setFromSubpart(fromSubpart);
        rfSs.setToSubpart(toSubpart);
        if (parentSubpart != null) {
            rfSs.setFromParentSubpart(parentSubpart.getFromSubpart());
            parentSubpart.addToFromChildSubparts(fromSubpart);
            rfSs.setToParentSubpart(parentSubpart.getToSubpart());
            parentSubpart.addToToChildSubparts(toSubpart);
            toSubpart.setParentSubpart(parentSubpart.getToSubpart());
            parentSubpart.getToSubpart().addToChildSubparts(toSubpart);
        }
        SchedulingSubpartDAO.getInstance().getSession().persist((Object)toSubpart);
        InstrOfferingConfigDAO iocDao = InstrOfferingConfigDAO.getInstance();
        iocDao.getSession().merge((Object)toInstrOffrConfig);
        if (fromSubpart.getClasses() != null && fromSubpart.getClasses().size() > 0) {
            ArrayList<Class_> classes = new ArrayList<Class_>(fromSubpart.getClasses());
            Collections.sort(classes, new ClassComparator(5));
            Class_ toClass = null;
            for (Class_ fromClass : classes) {
                if (SessionRollForward.CancelledClassAction.SKIP == cancelledClassAction && fromClass.isCancelled().booleanValue()) continue;
                toClass = this.mergeClassToSession(fromClass, toSubpart, isClassMerge, isSubpartTimePrefMerge, isSubpartLocationPrefMerge, isClassPrefsPushUp, distributionPrefMode, cancelledClassAction, defaultPrefix);
                MergeClass rfc = new MergeClass();
                rfc.setToClass(toClass);
                rfc.setFromClass(fromClass);
                rfc.setFromParentClass(fromClass.getParentClass());
                rfc.setParentSubpart(rfSs);
                rfSs.addToMergeClasses(rfc);
                if (fromClass.getChildClasses() != null && fromClass.getChildClasses().size() > 0) {
                    Iterator<Class_> ccIt = fromClass.getChildClasses().iterator();
                    while (ccIt.hasNext()) {
                        rfc.addToLastLikeChildClasses(ccIt.next());
                    }
                }
                if (parentSubpart != null) {
                    Class_ parentClass = parentSubpart.findParentClassMatchingFromParentClass(fromClass.getParentClass());
                    toClass.setParentClass(parentClass);
                    parentClass.addToChildClasses(toClass);
                }
                Class_DAO.getInstance().getSession().persist((Object)toClass);
            }
        }
        iocDao.getSession().merge((Object)toInstrOffrConfig);
        this.mergeTimePrefsToSession(fromSubpart, toSubpart, isClassMerge, isSubpartTimePrefMerge, isClassPrefsPushUp, cancelledClassAction);
        this.mergeBuildingPrefs(fromSubpart, toSubpart, isClassMerge, isSubpartLocationPrefMerge, isClassPrefsPushUp, cancelledClassAction, defaultPrefix);
        this.mergeRoomPrefsToSession(fromSubpart, toSubpart, isClassMerge, isSubpartLocationPrefMerge, isClassPrefsPushUp, cancelledClassAction, defaultPrefix);
        this.mergeRoomGroupPrefsToSession(fromSubpart, toSubpart, isClassMerge, isSubpartLocationPrefMerge, isClassPrefsPushUp, cancelledClassAction, defaultPrefix);
        this.mergeRoomFeaturePrefsToSession(fromSubpart, toSubpart, isClassMerge, isSubpartLocationPrefMerge, isClassPrefsPushUp, cancelledClassAction, defaultPrefix);
        this.mergeDatePatternPrefsToSession(fromSubpart, toSubpart, isClassMerge, isClassPrefsPushUp, cancelledClassAction, defaultPrefix);
        if (distributionPrefMode != null) {
            this.mergeDistributionPrefsToSession(fromSubpart, toSubpart, distributionPrefMode, defaultPrefix);
        }
        if (fromSubpart.getChildSubparts() != null && fromSubpart.getChildSubparts().size() > 0) {
            ArrayList<SchedulingSubpart> childSubparts = new ArrayList<SchedulingSubpart>(fromSubpart.getChildSubparts());
            Collections.sort(childSubparts, new SchedulingSubpartComparator());
            for (SchedulingSubpart childSubpart : childSubparts) {
                this.mergeSchedulingSubpartToSession(toInstrOffrConfig, childSubpart, rfSs, isClassMerge, isSubpartTimePrefMerge, isSubpartLocationPrefMerge, isClassPrefsPushUp, distributionPrefMode, cancelledClassAction, defaultPrefix);
            }
        }
        iocDao.getSession().merge((Object)toInstrOffrConfig);
    }

    private void mergeSchedSubpartsForAConfigToSession(InstrOfferingConfig ioc, InstrOfferingConfig newIoc, boolean isClassMerge, boolean isSubpartTimePrefMerge, boolean isSubpartLocationPrefMerge, boolean isClassPrefsPushUp, SessionRollForward.DistributionMode distributionPrefMode, SessionRollForward.CancelledClassAction cancelledClassAction, String defaultPrefix) throws Exception {
        if (ioc.getSchedulingSubparts() != null && ioc.getSchedulingSubparts().size() > 0) {
            ArrayList<SchedulingSubpart> subparts = new ArrayList<SchedulingSubpart>(ioc.getSchedulingSubparts());
            Collections.sort(subparts, new SchedulingSubpartComparator());
            for (SchedulingSubpart ss : subparts) {
                if (ss.getParentSubpart() != null) continue;
                this.mergeSchedulingSubpartToSession(newIoc, ss, null, isClassMerge, isSubpartTimePrefMerge, isSubpartLocationPrefMerge, isClassPrefsPushUp, distributionPrefMode, cancelledClassAction, defaultPrefix);
            }
        }
    }

    public void mergeInstructionalOfferingToSession(InstructionalOffering fromInstructionalOffering, Session fromSession, boolean mergeWaitListsProhibitedOverrides, boolean isClassMerge, boolean isSubpartTimePrefMerge, boolean isSubpartLocationPrefMerge, boolean isClassPrefsPushUp, SessionRollForward.DistributionMode distributionPrefMode, SessionRollForward.CancelledClassAction cancelledClassAction, String defaultPrefix) {
        block9: {
            InstructionalOfferingDAO ioDao = InstructionalOfferingDAO.getInstance();
            InstrOfferingConfigDAO iocDao = InstrOfferingConfigDAO.getInstance();
            this.iLog.info((Object)("Merging " + fromInstructionalOffering.getCourseNameWithTitle()));
            Transaction trns = null;
            try {
                HashMap<String, InstructionalOffering> toInstructionalOfferingMap;
                if (ioDao.getSession().getTransaction() == null || !ioDao.getSession().getTransaction().isActive()) {
                    trns = ioDao.getSession().beginTransaction();
                }
                if ((toInstructionalOfferingMap = this.findToInstructionalOffering(fromInstructionalOffering, defaultPrefix, mergeWaitListsProhibitedOverrides)) == null) {
                    return;
                }
                for (InstructionalOffering toInstructionalOffering : toInstructionalOfferingMap.values()) {
                    if (toInstructionalOffering == null) continue;
                    if (toInstructionalOffering.getInstrOfferingConfigs() != null && toInstructionalOffering.getInstrOfferingConfigs().size() > 0) {
                        toInstructionalOffering.getInstrOfferingConfigs().clear();
                    }
                    toInstructionalOffering.setNotOffered(fromInstructionalOffering.isNotOffered());
                    toInstructionalOffering.setUniqueIdRolledForwardFrom(fromInstructionalOffering.getUniqueId());
                }
                InstrOfferingConfig fromInstrOffrConfig2 = null;
                InstrOfferingConfig toInstrOffrConfig = null;
                if (fromInstructionalOffering.getInstrOfferingConfigs() != null && fromInstructionalOffering.getInstrOfferingConfigs().size() > 0) {
                    ArrayList<InstrOfferingConfig> fromInstrOffrConfigs = new ArrayList<InstrOfferingConfig>(fromInstructionalOffering.getInstrOfferingConfigs());
                    Collections.sort(fromInstrOffrConfigs, new InstrOfferingConfigComparator(null));
                    for (InstrOfferingConfig fromInstrOffrConfig2 : fromInstrOffrConfigs) {
                        InstructionalOffering toInstructionalOffering = toInstructionalOfferingMap.get(this.getPrefixForInstrOfferingConfig(fromInstrOffrConfig2, defaultPrefix));
                        if (toInstructionalOffering == null) continue;
                        toInstrOffrConfig = new InstrOfferingConfig();
                        toInstrOffrConfig.setLimit(fromInstrOffrConfig2.getLimit());
                        toInstrOffrConfig.setInstructionalOffering(toInstructionalOffering);
                        toInstrOffrConfig.setName(fromInstrOffrConfig2.getName());
                        toInstrOffrConfig.setUnlimitedEnrollment(fromInstrOffrConfig2.isUnlimitedEnrollment());
                        toInstrOffrConfig.setUniqueIdRolledForwardFrom(fromInstrOffrConfig2.getUniqueId());
                        toInstrOffrConfig.setClassDurationType(fromInstrOffrConfig2.getClassDurationType());
                        toInstrOffrConfig.setInstructionalMethod(fromInstrOffrConfig2.getInstructionalMethod());
                        toInstructionalOffering.addToInstrOfferingConfigs(toInstrOffrConfig);
                        iocDao.getSession().persist((Object)toInstrOffrConfig);
                        ioDao.getSession().merge((Object)toInstructionalOffering);
                        this.mergeSchedSubpartsForAConfigToSession(fromInstrOffrConfig2, toInstrOffrConfig, isClassMerge, isSubpartTimePrefMerge, isSubpartLocationPrefMerge, isClassPrefsPushUp, distributionPrefMode, cancelledClassAction, defaultPrefix);
                        ioDao.getSession().merge((Object)toInstructionalOffering);
                    }
                }
                if (trns != null && trns.isActive()) {
                    trns.commit();
                }
                ioDao.getSession().flush();
            }
            catch (Exception e) {
                this.iLog.error((Object)("Failed to merge " + fromInstructionalOffering.getCourseName()), (Throwable)e);
                if (trns == null || !trns.isActive()) break block9;
                trns.rollback();
            }
        }
    }

    public void mergeInstructionalOfferingsForASubjectAreaToSession(SubjectArea subjectArea, Session fromSession, boolean mergeWaitListsProhibitedOverrides, boolean isClassMerge, boolean isSubpartTimePrefMerge, boolean isSubpartLocationPrefMerge, boolean isClassPrefsPushUp, SessionRollForward.DistributionMode distributionPrefMode, SessionRollForward.CancelledClassAction cancelledClassAction, String prefix) {
        CourseOfferingDAO coDao = CourseOfferingDAO.getInstance();
        String query = "from CourseOffering as co where co.subjectArea.subjectAreaAbbreviation = '" + subjectArea.getSubjectAreaAbbreviation() + "' and co.isControl = true and co.subjectArea.session.uniqueId = " + fromSession.getUniqueId();
        List l = coDao.getSession().createQuery(query, CourseOffering.class).list();
        if (l != null) {
            CourseOffering co2 = null;
            for (CourseOffering co2 : l) {
                this.mergeInstructionalOfferingToSession(co2.getInstructionalOffering(), fromSession, mergeWaitListsProhibitedOverrides, isClassMerge, isSubpartTimePrefMerge, isSubpartLocationPrefMerge, isClassPrefsPushUp, distributionPrefMode, cancelledClassAction, prefix);
            }
        }
    }

    public void copyMergeCourseOfferingsToSession(Session fromSession, String classPrefsAction, String subpartLocationPrefsAction, String subpartTimePrefsAction, boolean mergeWaitListsProhibitedOverrides, SessionRollForward.DistributionMode distributionPrefMode, SessionRollForward.CancelledClassAction cancelledClassAction, String prefix) {
        boolean isSubpartLocationPrefMerge;
        boolean isClassMerge = classPrefsAction != null && classPrefsAction.equalsIgnoreCase(SessionRollForward.ROLL_PREFS_ACTION);
        boolean isClassPrefsPushUp = classPrefsAction != null && classPrefsAction.equalsIgnoreCase(SessionRollForward.PUSH_UP_ACTION);
        boolean isSubpartTimePrefMerge = subpartTimePrefsAction == null || !subpartTimePrefsAction.equalsIgnoreCase(SessionRollForward.DO_NOT_ROLL_ACTION);
        boolean bl = isSubpartLocationPrefMerge = subpartLocationPrefsAction == null || !subpartLocationPrefsAction.equalsIgnoreCase(SessionRollForward.DO_NOT_ROLL_ACTION);
        if (this.iMergedSession.getSubjectAreas() != null) {
            List<SubjectArea> fromSubjectAreas = SubjectAreaDAO.getInstance().findBySession(SubjectAreaDAO.getInstance().getSession(), fromSession.getUniqueId());
            TreeSet<SubjectArea> fSa = new TreeSet<SubjectArea>();
            fSa.addAll(fromSubjectAreas);
            ArrayList<Long> subjectAreaIds = new ArrayList<Long>();
            for (SubjectArea sa : fSa) {
                subjectAreaIds.add(sa.getUniqueId());
            }
            Long fromSessionId = fromSession.getUniqueId();
            for (Long subjectAreaId : subjectAreaIds) {
                this.resetHibSession(null);
                SubjectArea sa = (SubjectArea)SubjectAreaDAO.getInstance().get(subjectAreaId);
                Session fs = (Session)SessionDAO.getInstance().get(fromSessionId);
                this.mergeInstructionalOfferingsForASubjectAreaToSession(sa, fs, mergeWaitListsProhibitedOverrides, isClassMerge, isSubpartTimePrefMerge, isSubpartLocationPrefMerge, isClassPrefsPushUp, distributionPrefMode, cancelledClassAction, prefix);
            }
        }
    }

    public void copyMergeClassInstructorsToSession(Session fromSession, String prefix) {
        SubjectAreaDAO sDao = SubjectAreaDAO.getInstance();
        List<SubjectArea> subjects = sDao.findBySession(sDao.getSession(), fromSession.getUniqueId());
        if (this.iMergedSession.getSubjectAreas() != null) {
            for (SubjectArea subjectArea : subjects) {
                this.copyMergeClassInstructorsForASubjectArea(subjectArea.getSubjectAreaAbbreviation(), prefix);
            }
        }
    }

    private void copyMergeClassInstructorsForASubjectArea(String subjectAreaAbbreviation, String defaultPrefix) {
        this.iLog.info((Object)("Rolling forward class instructors for:  " + subjectAreaAbbreviation));
        Class_DAO clsDao = new Class_DAO();
        org.hibernate.Session hibSession = clsDao.getSession();
        List<Class_> classes = Class_.findAllForControllingSubjectArea(subjectAreaAbbreviation, this.iMergedSession.getUniqueId(), hibSession);
        if (classes != null && !classes.isEmpty()) {
            Class_ toClass2 = null;
            Class_ fromClass = null;
            for (Class_ toClass2 : classes) {
                if (toClass2.getUniqueIdRolledForwardFrom() == null || (fromClass = (Class_)clsDao.get(toClass2.getUniqueIdRolledForwardFrom(), hibSession)) == null || fromClass.getClassInstructors() == null || fromClass.getClassInstructors().isEmpty()) continue;
                ClassInstructor fromClassInstr2 = null;
                ClassInstructor toClassInstr = null;
                DepartmentalInstructor toDeptInstr = null;
                for (ClassInstructor fromClassInstr2 : fromClass.getClassInstructors()) {
                    if (fromClassInstr2.getTeachingRequest() != null || (toDeptInstr = DepartmentalInstructor.findByPuidDepartmentId(fromClassInstr2.getInstructor().getExternalUniqueId(), toClass2.getControllingDept().getUniqueId())) == null) continue;
                    toClassInstr = new ClassInstructor();
                    toClassInstr.setClassInstructing(toClass2);
                    toClassInstr.setInstructor(toDeptInstr);
                    toClassInstr.setLead(fromClassInstr2.isLead());
                    toClassInstr.setPercentShare(fromClassInstr2.getPercentShare());
                    toClassInstr.setResponsibility(fromClassInstr2.getResponsibility());
                    toClassInstr.setUniqueId(null);
                    toClass2.addToClassInstructors(toClassInstr);
                    toDeptInstr.addToClasses(toClassInstr);
                }
                Transaction t = hibSession.beginTransaction();
                hibSession.merge((Object)toClass2);
                t.commit();
            }
        }
    }

    private void initDbColumnLengths() {
        if (this.dbColumnLengths.isEmpty()) {
            Metadata metaData = HibernateUtil.getHibernateContext().getMetadata();
            ArrayList persistentClasses = new ArrayList(metaData.getEntityBindings());
            for (PersistentClass pc : persistentClasses) {
                String cn = pc.getClassName();
                for (Property property : pc.getProperties()) {
                    Iterator iterator;
                    if (!property.isBasicPropertyAccessor() || !property.isUpdateable()) continue;
                    String pn = property.getName();
                    if (property.getColumns() == null || !(iterator = property.getColumns().iterator()).hasNext()) continue;
                    Column c = (Column)iterator.next();
                    long length = c.getLength();
                    HashMap<String, Long> columnLengths = null;
                    if (this.dbColumnLengths.get(cn) == null) {
                        this.dbColumnLengths.put(cn, new HashMap());
                    }
                    columnLengths = this.dbColumnLengths.get(cn);
                    columnLengths.put(pn, length);
                }
            }
        }
    }

    private int getColumnLength(String className, String propertyName) {
        HashMap<String, Long> columnLengths = this.dbColumnLengths.get(className);
        int length = -1;
        if (columnLengths != null) {
            length = columnLengths.get(propertyName).intValue();
        }
        return length;
    }

    private boolean isNewStringOfValidLength(String prefix, String prefixSeparator, String currentString, String className, String propertyName) {
        return currentString != null && prefix != null && prefixSeparator != null && currentString.length() + prefix.length() + prefixSeparator.length() <= this.getColumnLength(className, propertyName);
    }

    private class MergeSchedSubpart {
        private SchedulingSubpart fromParentSubpart;
        private SchedulingSubpart toParentSubpart;
        private SchedulingSubpart fromSubpart;
        private SchedulingSubpart toSubpart;
        private List<SchedulingSubpart> fromChildSubparts;
        private List<SchedulingSubpart> toChildSubparts;
        private List<MergeClass> mergeClasses;

        private MergeSchedSubpart() {
        }

        public List<SchedulingSubpart> getFromChildSubparts() {
            return this.fromChildSubparts;
        }

        public Class_ findParentClassMatchingFromParentClass(Class_ fromParentClass) {
            if (this.getMergeClasses() != null && this.getMergeClasses().size() > 0) {
                for (MergeClass rfc : this.getMergeClasses()) {
                    if (!rfc.getFromClass().equals(fromParentClass)) continue;
                    return rfc.getToClass();
                }
            }
            return null;
        }

        public void setFromChildSubparts(List<SchedulingSubpart> fromChildSubparts) {
            this.fromChildSubparts = fromChildSubparts;
        }

        public void addToFromChildSubparts(SchedulingSubpart fromChildSubpart) {
            if (this.fromChildSubparts == null) {
                this.fromChildSubparts = new ArrayList<SchedulingSubpart>();
            }
            this.fromChildSubparts.add(fromChildSubpart);
        }

        public SchedulingSubpart getFromParentSubpart() {
            return this.fromParentSubpart;
        }

        public void setFromParentSubpart(SchedulingSubpart fromParentSubpart) {
            this.fromParentSubpart = fromParentSubpart;
        }

        public SchedulingSubpart getFromSubpart() {
            return this.fromSubpart;
        }

        public void setFromSubpart(SchedulingSubpart fromSubpart) {
            this.fromSubpart = fromSubpart;
        }

        public List<SchedulingSubpart> getToChildSubparts() {
            return this.toChildSubparts;
        }

        public void setToChildSubparts(List<SchedulingSubpart> toChildSubparts) {
            this.toChildSubparts = toChildSubparts;
        }

        public void addToToChildSubparts(SchedulingSubpart toChildSubpart) {
            if (this.toChildSubparts == null) {
                this.toChildSubparts = new ArrayList<SchedulingSubpart>();
            }
            this.toChildSubparts.add(toChildSubpart);
        }

        public SchedulingSubpart getToParentSubpart() {
            return this.toParentSubpart;
        }

        public void setToParentSubpart(SchedulingSubpart toParentSubpart) {
            this.toParentSubpart = toParentSubpart;
        }

        public SchedulingSubpart getToSubpart() {
            return this.toSubpart;
        }

        public void setToSubpart(SchedulingSubpart toSubpart) {
            this.toSubpart = toSubpart;
        }

        public List<MergeClass> getMergeClasses() {
            return this.mergeClasses;
        }

        public void setMergeClasses(List<MergeClass> mergeClasses) {
            this.mergeClasses = mergeClasses;
        }

        public void addToMergeClasses(MergeClass mergeClasses) {
            if (this.mergeClasses == null) {
                this.mergeClasses = new ArrayList<MergeClass>();
            }
            this.mergeClasses.add(mergeClasses);
        }
    }

    private class MergeClass {
        private Class_ fromParentClass;
        private Class_ toParentClass;
        private Class_ fromClass;
        private Class_ toClass;
        private List<Object> fromChildClasses;
        private List<Class_> toChildClasses;
        private MergeSchedSubpart parentSubpart;

        private MergeClass() {
        }

        public List<Object> getFromChildClasses() {
            return this.fromChildClasses;
        }

        public void setFromChildClasses(List<Object> lastLikeChildClasses) {
            this.fromChildClasses = lastLikeChildClasses;
        }

        public void addToLastLikeChildClasses(Object fromChildClass) {
            if (this.fromChildClasses == null) {
                this.fromChildClasses = new ArrayList<Object>();
            }
            this.fromChildClasses.add(fromChildClass);
        }

        public Class_ getFromClass() {
            return this.fromClass;
        }

        public void setFromClass(Class_ fromClass) {
            this.fromClass = fromClass;
        }

        public Class_ getFromParentClass() {
            return this.fromParentClass;
        }

        public void setFromParentClass(Class_ fromParentClass) {
            this.fromParentClass = fromParentClass;
        }

        public List<Class_> getToChildClasses() {
            return this.toChildClasses;
        }

        public void setToChildClasses(List<Class_> newChildClasses) {
            this.toChildClasses = newChildClasses;
        }

        public void addToNewChildClasses(Class_ toChildClass) {
            if (this.toChildClasses == null) {
                this.toChildClasses = new ArrayList<Class_>();
            }
            this.toChildClasses.add(toChildClass);
        }

        public Class_ getToClass() {
            return this.toClass;
        }

        public void setToClass(Class_ toClass) {
            this.toClass = toClass;
        }

        public Class_ getToParentClass() {
            return this.toParentClass;
        }

        public void setToParentClass(Class_ toParentClass) {
            this.toParentClass = toParentClass;
        }

        public MergeSchedSubpart getParentSubpart() {
            return this.parentSubpart;
        }

        public void setParentSubpart(MergeSchedSubpart parentSubpart) {
            this.parentSubpart = parentSubpart;
        }
    }
}

