/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.test;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.unitime.commons.hibernate.util.HibernateUtil;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DistributionObject;
import org.unitime.timetable.model.DistributionPref;
import org.unitime.timetable.model.DistributionType;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentClassEnrollment;
import org.unitime.timetable.model.StudentGroup;
import org.unitime.timetable.model.StudentGroupReservation;
import org.unitime.timetable.model.base.BaseClass_;
import org.unitime.timetable.model.base.BaseReservation;
import org.unitime.timetable.model.base.BaseStudentGroup;
import org.unitime.timetable.model.base.BaseStudentGroupReservation;
import org.unitime.timetable.model.dao._RootDAO;

public class ReadLearningCommunities {
    protected static Log sLog = LogFactory.getLog(ReadLearningCommunities.class);

    private static String abbv(String name) {
        StringBuffer sb = new StringBuffer();
        StringTokenizer stk = new StringTokenizer(name, " .");
        while (stk.hasMoreTokens()) {
            String word = stk.nextToken();
            if ("and".equalsIgnoreCase(word)) {
                sb.append("&");
                continue;
            }
            if ("in".equalsIgnoreCase(word)) continue;
            if (word.replaceAll("[a-zA-Z\\.]*", "").length() == 0) {
                for (int i = 0; i < word.length(); ++i) {
                    if (i == 0) {
                        sb.append(word.substring(i, i + 1).toUpperCase());
                        continue;
                    }
                    if ((i != 1 || word.length() <= 3) && (word.charAt(i) < 'A' || word.charAt(i) > 'Z')) continue;
                    sb.append(word.charAt(i));
                }
                continue;
            }
            sb.append(word);
        }
        return sb.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static void main(String[] args) {
        try {
            HibernateUtil.configureHibernate(ApplicationProperties.getProperties());
            org.hibernate.Session hibSession = new _RootDAO().getSession();
            Session session = Session.getSessionUsingInitiativeYearTerm(ApplicationProperties.getProperty("initiative", "PWL"), ApplicationProperties.getProperty("year", "2011"), ApplicationProperties.getProperty("term", "Fall"));
            if (session == null) {
                sLog.error((Object)"Academic session not found, use properties initiative, year, and term to set academic session.");
                System.exit(0);
            } else {
                sLog.info((Object)("Session: " + session));
            }
            DistributionType linkedSections = (DistributionType)hibSession.createQuery("select d from DistributionType d where d.reference = :type", DistributionType.class).setParameter("type", (Object)"LINKED_SECTIONS").uniqueResult();
            BufferedReader r = new BufferedReader(new FileReader(ApplicationProperties.getProperty("file", "/Users/muller/Downloads/Fall 2011 LC Course Matrix.csv")));
            Document document = DocumentHelper.createDocument();
            document.addComment("Learning comunities for " + session);
            Element root = document.addElement("constraints");
            Element group = null;
            String line = null;
            DistributionPref dpLinkedSections = null;
            ArrayList<DistributionPref> distPrefs = new ArrayList<DistributionPref>();
            BaseReservation reservation = null;
            ArrayList<BaseReservation> reservations = new ArrayList<BaseReservation>();
            BaseStudentGroup studentGroup = null;
            ArrayList<BaseStudentGroup> groups = new ArrayList<BaseStudentGroup>();
            HashMap<SchedulingSubpart, HashSet<Class_>> classes = new HashMap<SchedulingSubpart, HashSet<Class_>>();
            while ((line = r.readLine()) != null) {
                if (line.trim().isEmpty()) {
                    if (group != null) {
                        HashSet<Student> students = null;
                        for (Map.Entry entry : classes.entrySet()) {
                            HashSet<Student> studentsThisSubpart = new HashSet<Student>();
                            for (Object c : (Set)entry.getValue()) {
                                for (StudentClassEnrollment e : ((BaseClass_)c).getStudentEnrollments()) {
                                    studentsThisSubpart.add(e.getStudent());
                                }
                            }
                            if (students == null) {
                                students = studentsThisSubpart;
                                continue;
                            }
                            Iterator i = students.iterator();
                            while (i.hasNext()) {
                                if (studentsThisSubpart.contains(i.next())) continue;
                                i.remove();
                            }
                        }
                        studentGroup.setStudents(students);
                    }
                    group = null;
                    continue;
                }
                String[] cols = line.split(",");
                if (cols.length <= 9) {
                    sLog.info((Object)("Skipping " + line));
                    continue;
                }
                if (group == null) {
                    group = root.addElement("linked-sections");
                    if (!cols[0].trim().isEmpty()) {
                        group.addAttribute("name", cols[0].trim());
                    }
                    dpLinkedSections = new DistributionPref();
                    dpLinkedSections.setDistributionType(linkedSections);
                    dpLinkedSections.setPrefLevel(PreferenceLevel.getPreferenceLevel(PreferenceLevel.sRequired));
                    dpLinkedSections.setStructure(DistributionPref.Structure.AllClasses);
                    dpLinkedSections.setDistributionObjects(new HashSet<DistributionObject>());
                    distPrefs.add(dpLinkedSections);
                    studentGroup = new StudentGroup();
                    studentGroup.setGroupName(cols[0].trim());
                    studentGroup.setGroupAbbreviation(ReadLearningCommunities.abbv(cols[0].trim()));
                    studentGroup.setSession(session);
                    groups.add(studentGroup);
                    reservation = new StudentGroupReservation();
                    reservation.setClasses(new HashSet<Class_>());
                    ((BaseStudentGroupReservation)reservation).setGroup((StudentGroup)studentGroup);
                    reservations.add(reservation);
                    classes.clear();
                }
                String string = cols[2].trim();
                Class_ clazz = (Class_)hibSession.createQuery("from Class_ c where c.classSuffix like :crn and c.schedulingSubpart.instrOfferingConfig.instructionalOffering.session.uniqueId = :sessionId", Class_.class).setParameter("crn", (Object)(string + "%")).setParameter("sessionId", (Object)session.getUniqueId()).setMaxResults(1).uniqueResult();
                if (clazz != null) {
                    group.addElement("section").addAttribute("offering", clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().getUniqueId().toString()).addAttribute("id", clazz.getUniqueId().toString()).addAttribute("name", clazz.getClassLabel());
                    if (dpLinkedSections.getOwner() == null) {
                        dpLinkedSections.setOwner(clazz.getManagingDept());
                    } else if (!dpLinkedSections.getOwner().equals(clazz.getManagingDept()) && ((Department)dpLinkedSections.getOwner()).getDistributionPrefPriority() < clazz.getManagingDept().getDistributionPrefPriority()) {
                        dpLinkedSections.setOwner(clazz.getManagingDept());
                    }
                    reservation.getClasses().add(clazz);
                    HashSet<Class_> c = (HashSet<Class_>)classes.get(clazz.getSchedulingSubpart());
                    if (c == null) {
                        c = new HashSet<Class_>();
                        classes.put(clazz.getSchedulingSubpart(), c);
                    }
                    c.add(clazz);
                    DistributionObject o = new DistributionObject();
                    o.setDistributionPref(dpLinkedSections);
                    o.setPrefGroup(clazz);
                    o.setSequenceNumber(dpLinkedSections.getDistributionObjects().size());
                    dpLinkedSections.getDistributionObjects().add(o);
                    continue;
                }
                sLog.warn((Object)("Unable to find class " + string + " (" + cols[3] + " " + cols[4] + " " + cols[7] + " " + cols[8] + " " + cols[9] + ")"));
            }
            r.close();
            new XMLWriter((OutputStream)System.out, OutputFormat.createPrettyPrint()).write(document);
            for (StudentGroup studentGroup2 : groups) {
                sLog.info((Object)(studentGroup2.getGroupAbbreviation() + ": " + studentGroup2.getGroupName() + " has " + studentGroup2.getStudents().size() + " students."));
            }
            for (DistributionPref distributionPref : distPrefs) {
                for (DistributionObject obj : new ArrayList<DistributionObject>(distributionPref.getDistributionObjects())) {
                    block10: for (Class_ p = ((Class_)obj.getPrefGroup()).getParentClass(); p != null; p = p.getParentClass()) {
                        for (DistributionObject distributionObject : distributionPref.getDistributionObjects()) {
                            if (!distributionObject.getPrefGroup().equals(p)) continue;
                            distributionPref.getDistributionObjects().remove(distributionObject);
                            continue block10;
                        }
                    }
                }
                if (distributionPref.getDistributionObjects().size() <= 1) continue;
                int idx = 0;
                for (DistributionObject obj : new TreeSet<DistributionObject>(distributionPref.getDistributionObjects())) {
                    obj.setSequenceNumber(idx++);
                }
                hibSession.persist((Object)distributionPref);
            }
            for (StudentGroup studentGroup3 : groups) {
                if (studentGroup3.getUniqueId() == null) {
                    hibSession.persist((Object)studentGroup3);
                    continue;
                }
                hibSession.merge((Object)studentGroup3);
            }
            for (StudentGroupReservation studentGroupReservation : reservations) {
                HashMap<InstructionalOffering, StudentGroupReservation> of2res = new HashMap<InstructionalOffering, StudentGroupReservation>();
                for (Class_ clazz : studentGroupReservation.getClasses()) {
                    void var22_43;
                    InstructionalOffering offering = clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering();
                    StudentGroupReservation studentGroupReservation2 = (StudentGroupReservation)of2res.get(offering);
                    if (studentGroupReservation2 == null) {
                        StudentGroupReservation studentGroupReservation3 = new StudentGroupReservation();
                        studentGroupReservation3.setClasses(new HashSet<Class_>());
                        studentGroupReservation3.setGroup(studentGroupReservation.getGroup());
                        studentGroupReservation3.setConfigurations(new HashSet<InstrOfferingConfig>());
                        studentGroupReservation3.setInstructionalOffering(offering);
                        studentGroupReservation3.setLimit(studentGroupReservation.getGroup().getStudents().size());
                        of2res.put(offering, studentGroupReservation3);
                    }
                    var22_43.getClasses().add(clazz);
                }
                for (StudentGroupReservation x : of2res.values()) {
                    for (Class_ class_ : new ArrayList<Class_>(x.getClasses())) {
                        for (Class_ p = class_.getParentClass(); p != null; p = p.getParentClass()) {
                            if (!x.getClasses().contains(p)) continue;
                            x.getClasses().remove(p);
                        }
                    }
                    if (x.getUniqueId() == null) {
                        hibSession.persist((Object)x);
                        continue;
                    }
                    hibSession.merge((Object)x);
                }
            }
            hibSession.flush();
            sLog.info((Object)"All done.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

