/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.test;

import java.util.List;
import java.util.Properties;
import org.cpsolver.ifs.util.ToolBox;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.unitime.commons.hibernate.util.HibernateUtil;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.ClassEvent;
import org.unitime.timetable.model.EventDateMapping;
import org.unitime.timetable.model.Solution;
import org.unitime.timetable.model.dao._RootDAO;

public class MakeEventsForAllCommitedAssignments {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] args) {
        try {
            ToolBox.configureLogging();
            HibernateUtil.configureHibernate(new Properties());
            Session hibSession = new _RootDAO().getSession();
            List commitedSolutions = hibSession.createQuery("select s from Solution s where s.commited = true", Solution.class).list();
            int idx = 0;
            for (Solution s : commitedSolutions) {
                EventDateMapping.Class2EventDateMap class2eventDates = EventDateMapping.getMapping(s.getSession().getUniqueId());
                System.out.println("Procession solution " + ++idx + "/" + commitedSolutions.size() + " (" + s.getOwner().getName() + " of " + s.getSession().getLabel() + ", committed " + s.getCommitDate() + ")");
                Transaction tx = null;
                try {
                    tx = hibSession.beginTransaction();
                    for (ClassEvent e : hibSession.createQuery("select e from Solution s inner join s.assignments a, ClassEvent e where e.clazz=a.clazz and s.uniqueId=:solutionId", ClassEvent.class).setParameter("solutionId", (Object)s.getUniqueId()).list()) {
                        hibSession.remove((Object)e);
                    }
                    for (Assignment a : hibSession.createQuery("select a from Assignment a where a.solution.uniqueId = :solutionId", Assignment.class).setParameter("solutionId", (Object)s.getUniqueId()).list()) {
                        ClassEvent event = a.generateCommittedEvent(null, true, class2eventDates);
                        if (event != null && !event.getMeetings().isEmpty()) {
                            System.out.println("  " + a.getClassName() + " " + a.getPlacement().getLongName(true));
                            if (event.getUniqueId() == null) {
                                hibSession.persist((Object)event);
                            } else {
                                hibSession.merge((Object)event);
                            }
                        }
                        if (event == null || !event.getMeetings().isEmpty() || event.getUniqueId() == null) continue;
                        hibSession.remove((Object)event);
                    }
                    tx.commit();
                }
                catch (Exception e) {
                    if (tx == null) throw e;
                    tx.rollback();
                    throw e;
                    return;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

