/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.test;

import java.io.File;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cpsolver.ifs.util.ToolBox;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.hibernate.NonUniqueResultException;
import org.hibernate.Transaction;
import org.unitime.commons.hibernate.util.HibernateUtil;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.Building;
import org.unitime.timetable.model.BuildingPref;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.DistributionObject;
import org.unitime.timetable.model.DistributionPref;
import org.unitime.timetable.model.DistributionType;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.ItypeDesc;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.Preference;
import org.unitime.timetable.model.PreferenceGroup;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.RoomFeature;
import org.unitime.timetable.model.RoomFeaturePref;
import org.unitime.timetable.model.RoomGroup;
import org.unitime.timetable.model.RoomGroupPref;
import org.unitime.timetable.model.RoomPref;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.Solution;
import org.unitime.timetable.model.SolverGroup;
import org.unitime.timetable.model.Staff;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.TeachingResponsibility;
import org.unitime.timetable.model.TimePattern;
import org.unitime.timetable.model.TimePatternDays;
import org.unitime.timetable.model.TimePatternTime;
import org.unitime.timetable.model.TimePref;
import org.unitime.timetable.model.TimetableManager;
import org.unitime.timetable.model.dao.SessionDAO;

public class ImportPreferences {
    private static Log sLog = LogFactory.getLog(ImportPreferences.class);
    private Hashtable iAllClasses = null;
    private Hashtable iAllSubparts = null;
    private Hashtable iAllInstructionalOfferings = null;
    private org.hibernate.Session hibSession = null;
    private Transaction tx = null;
    private Session iSession = null;
    private SolverGroup iManager = null;
    private Solution iSolution = null;

    public TimePattern importTimePattern(Element element) {
        String name = element.attributeValue("name");
        TimePattern timePattern = TimePattern.findByName(this.iSession, name);
        if (timePattern != null) {
            return timePattern;
        }
        sLog.info((Object)("Creating time pattern " + name));
        timePattern = new TimePattern();
        timePattern.setName(name);
        timePattern.setSession(this.iSession);
        timePattern.setMinPerMtg(Integer.valueOf(element.attributeValue("minPerMtg")));
        timePattern.setSlotsPerMtg(Integer.valueOf(element.attributeValue("slotsPerMtg")));
        timePattern.setNrMeetings(Integer.valueOf(element.attributeValue("nrMeetings")));
        timePattern.setVisible(Boolean.valueOf(element.attributeValue("visible")));
        timePattern.setType(Integer.valueOf(element.attributeValue("type")));
        HashSet<TimePatternDays> days = new HashSet<TimePatternDays>();
        Iterator i = element.elementIterator("dayCode");
        while (i.hasNext()) {
            TimePatternDays d = new TimePatternDays();
            d.setDayCode(Integer.valueOf(((Element)i.next()).getText()));
            days.add(d);
        }
        HashSet<TimePatternTime> times = new HashSet<TimePatternTime>();
        Iterator i2 = element.elementIterator("startSlot");
        while (i2.hasNext()) {
            TimePatternTime t = new TimePatternTime();
            t.setStartSlot(Integer.valueOf(((Element)i2.next()).getText()));
            times.add(t);
        }
        timePattern.setDays(days);
        timePattern.setTimes(times);
        this.hibSession.persist((Object)timePattern);
        return timePattern;
    }

    public DatePattern importDatePattern(Element element) {
        String name = element.attributeValue("name");
        DatePattern datePattern = DatePattern.findByName(this.iSession, name);
        if (datePattern != null) {
            return datePattern;
        }
        sLog.info((Object)("Creating date pattern " + name));
        datePattern = new DatePattern();
        datePattern.setName(name);
        datePattern.setVisible(Boolean.valueOf(element.attributeValue("visible")));
        datePattern.setType(Integer.valueOf(element.attributeValue("type")));
        datePattern.setSession(this.iSession);
        datePattern.setOffset(Integer.valueOf(element.attributeValue("offset")));
        datePattern.setPattern(element.attributeValue("pattern"));
        this.hibSession.persist((Object)datePattern);
        return datePattern;
    }

    public void importPreferences(PreferenceGroup owner, Element element) {
        PreferenceLevel level;
        Element el;
        if (!owner.getPreferences().isEmpty()) {
            sLog.info((Object)("  -- preference group " + owner + " already has the following preferences:"));
            for (Preference p : owner.getPreferences()) {
                if (p instanceof TimePref) {
                    sLog.info((Object)("    -- " + p.getPrefLevel().getPrefName() + " " + ((TimePref)p).getTimePattern().getName() + " " + ((TimePref)p).getPreference()));
                    continue;
                }
                if (p instanceof RoomPref) {
                    sLog.info((Object)("    -- " + p.getPrefLevel().getPrefName() + " " + ((RoomPref)p).getRoom().getLabel()));
                    continue;
                }
                if (p instanceof BuildingPref) {
                    sLog.info((Object)("    -- " + p.getPrefLevel().getPrefName() + " " + ((BuildingPref)p).getBuilding().getAbbreviation()));
                    continue;
                }
                if (p instanceof RoomFeaturePref) {
                    sLog.info((Object)("    -- " + p.getPrefLevel().getPrefName() + " " + ((RoomFeaturePref)p).getRoomFeature().getLabel()));
                    continue;
                }
                if (p instanceof RoomGroupPref) {
                    sLog.info((Object)("    -- " + p.getPrefLevel().getPrefName() + " " + ((RoomGroupPref)p).getRoomGroup().getName()));
                    continue;
                }
                sLog.info((Object)("    -- " + p.getPrefLevel().getPrefName() + " " + p.toString()));
            }
            owner.getPreferences().clear();
        }
        Iterator i = element.elementIterator("timePref");
        while (i.hasNext()) {
            el = (Element)i.next();
            level = PreferenceLevel.getPreferenceLevel(el.attributeValue("level"));
            TimePattern timePattern = TimePattern.findByName(this.iSession, el.attributeValue("timePattern"));
            if (timePattern == null) {
                sLog.error((Object)("Unable to find time pattern with name " + el.attributeValue("timePattern")));
                continue;
            }
            TimePref tp = new TimePref();
            tp.setOwner(owner);
            tp.setPrefLevel(level);
            tp.setTimePattern(timePattern);
            tp.setPreference(el.attributeValue("preference"));
            this.hibSession.persist((Object)tp);
            sLog.info((Object)("  -- added time preference " + tp.getTimePattern().getName() + " " + tp.getPreference()));
        }
        i = element.elementIterator("roomPref");
        while (i.hasNext()) {
            el = (Element)i.next();
            level = PreferenceLevel.getPreferenceLevel(el.attributeValue("level"));
            String roomName = el.attributeValue("room");
            Location location = null;
            for (Location l : owner.getAvailableRooms()) {
                if (!l.getLabel().equals(roomName)) continue;
                location = l;
                break;
            }
            if (location == null) {
                sLog.error((Object)("Unable to find room with name " + roomName));
                continue;
            }
            RoomPref rp = new RoomPref();
            rp.setOwner(owner);
            rp.setPrefLevel(level);
            rp.setRoom(location);
            this.hibSession.persist((Object)rp);
            sLog.info((Object)("  -- added room preference " + rp.getPrefLevel().getPrefName() + " " + rp.getRoom().getLabel()));
        }
        i = element.elementIterator("buildingPref");
        while (i.hasNext()) {
            el = (Element)i.next();
            level = PreferenceLevel.getPreferenceLevel(el.attributeValue("level"));
            String bldgName = el.attributeValue("building");
            Building building = null;
            for (Building b : owner.getAvailableBuildings()) {
                if (!b.getAbbreviation().equals(bldgName)) continue;
                building = b;
                break;
            }
            if (building == null) {
                sLog.error((Object)("Unable to find building with name " + bldgName));
                continue;
            }
            BuildingPref bp = new BuildingPref();
            bp.setOwner(owner);
            bp.setPrefLevel(level);
            bp.setBuilding(building);
            this.hibSession.persist((Object)bp);
            sLog.info((Object)("  -- added building preference " + bp.getPrefLevel().getPrefName() + " " + bp.getBuilding().getName()));
        }
        i = element.elementIterator("roomFeaturePref");
        while (i.hasNext()) {
            el = (Element)i.next();
            level = PreferenceLevel.getPreferenceLevel(el.attributeValue("level"));
            String featureName = el.attributeValue("feature");
            RoomFeature feature = null;
            for (RoomFeature f : owner.getAvailableRoomFeatures()) {
                if (!f.getLabel().equals(featureName)) continue;
                feature = f;
                break;
            }
            if (feature == null) {
                sLog.error((Object)("Unable to find room feature with name " + featureName));
                continue;
            }
            RoomFeaturePref fp = new RoomFeaturePref();
            fp.setOwner(owner);
            fp.setPrefLevel(level);
            fp.setRoomFeature(feature);
            this.hibSession.persist((Object)fp);
            sLog.info((Object)("  -- added room feature preference " + fp.getPrefLevel().getPrefName() + " " + fp.getRoomFeature().getLabel()));
        }
        i = element.elementIterator("roomGroupPref");
        while (i.hasNext()) {
            el = (Element)i.next();
            level = PreferenceLevel.getPreferenceLevel(el.attributeValue("level"));
            String groupName = el.attributeValue("group");
            RoomGroup group = null;
            for (RoomGroup g : owner.getAvailableRoomGroups()) {
                if (!g.getName().equals(groupName)) continue;
                group = g;
                break;
            }
            if (group == null) {
                sLog.error((Object)("Unable to find room group with name " + groupName));
                continue;
            }
            RoomGroupPref gp = new RoomGroupPref();
            gp.setOwner(owner);
            gp.setPrefLevel(level);
            gp.setRoomGroup(group);
            this.hibSession.persist((Object)gp);
            sLog.info((Object)("  -- added time preference " + gp.getPrefLevel().getPrefName() + " " + gp.getRoomGroup().getName()));
        }
    }

    public Department getDepartment(String deptCode) {
        if ("LLR".equals(deptCode) || "LAB".equals(deptCode)) {
            return (Department)this.hibSession.createQuery("select d from Department d where d.session.uniqueId=:sessionId and d.externalManager=true and d.externalMgrAbbv=:deptCode", Department.class).setParameter("sessionId", (Object)this.iSession.getUniqueId()).setParameter("deptCode", (Object)deptCode).uniqueResult();
        }
        return (Department)this.hibSession.createQuery("select d from Department d where d.session.uniqueId=:sessionId and d.deptCode=:deptCode", Department.class).setParameter("sessionId", (Object)this.iSession.getUniqueId()).setParameter("deptCode", (Object)deptCode).uniqueResult();
    }

    public Class_ importClass(Element element) {
        Iterator<ClassInstructor> i;
        String datePattern;
        int expectedCapacity;
        String subjectArea = element.attributeValue("subjectArea");
        String courseNbr = element.attributeValue("courseNbr");
        String itype = element.attributeValue("itype");
        int section = Integer.parseInt(element.attributeValue("section"));
        String suffix = element.attributeValue("suffix");
        String notes = element.attributeValue("notes");
        Class_ clazz = (Class_)this.iAllClasses.get(new ClassHash(element));
        if (clazz == null) {
            sLog.error((Object)("Unable to find class " + subjectArea + " " + courseNbr + " " + itype + " " + section + suffix));
            return null;
        }
        sLog.info((Object)("Processing class " + clazz.getClassLabel()));
        String manager = element.attributeValue("manager");
        if (!clazz.getManagingDept().getDeptCode().equals(manager)) {
            sLog.info((Object)("  -- changing managing department to " + manager + " (was " + clazz.getManagingDept().getDeptCode() + ")"));
            clazz.setManagingDept(this.getDepartment(manager));
            this.hibSession.merge((Object)clazz);
            this.hibSession.flush();
            this.hibSession.refresh((Object)clazz);
        }
        int maxExpectedCapacity = expectedCapacity = Integer.parseInt(element.attributeValue("expectedCapacity"));
        int numberOfRooms = Integer.parseInt(element.attributeValue("numberOfRooms"));
        float roomRatio = 1.0f;
        if (element.attributeValue("roomRatio") != null) {
            roomRatio = Float.parseFloat(element.attributeValue("roomRatio"));
            maxExpectedCapacity = Integer.parseInt(element.attributeValue("maxExpectedCapacity"));
        } else {
            int roomCapacity = Integer.parseInt(element.attributeValue("roomCapacity"));
            if (expectedCapacity == 0) {
                roomRatio = 0.0f;
                expectedCapacity = roomCapacity;
            } else {
                roomRatio = (float)roomCapacity / (float)expectedCapacity;
            }
        }
        if (clazz.getExpectedCapacity() != expectedCapacity) {
            sLog.info((Object)("  -- changing min. class limit to " + expectedCapacity + " (was " + clazz.getExpectedCapacity() + ")"));
            clazz.setExpectedCapacity(expectedCapacity);
        }
        if (clazz.getMaxExpectedCapacity() != maxExpectedCapacity) {
            sLog.info((Object)("  -- changing max. class limit to " + maxExpectedCapacity + " (was " + clazz.getMaxExpectedCapacity() + ")"));
            clazz.setMaxExpectedCapacity(maxExpectedCapacity);
        }
        if (clazz.getNbrRooms() != numberOfRooms) {
            sLog.info((Object)("  -- changing number of rooms to " + numberOfRooms + " (was " + clazz.getNbrRooms() + ")"));
            clazz.setNbrRooms(numberOfRooms);
        }
        if (clazz.getRoomRatio().floatValue() != roomRatio) {
            sLog.info((Object)("  -- changing room ratio to " + roomRatio + " (was " + clazz.getRoomRatio() + ")"));
            clazz.setRoomRatio(Float.valueOf(roomRatio));
        }
        if (!ToolBox.equals((Object)notes, (Object)clazz.getNotes())) {
            sLog.info((Object)("  -- changing notes to " + notes + " (was " + clazz.getNotes() + ")"));
            clazz.setNotes(notes);
        }
        if ((datePattern = element.attributeValue("datePattern")) == null && clazz.getDatePattern() != null) {
            sLog.info((Object)("  -- changing date pattern to default (was " + clazz.getDatePattern().getName() + ")"));
            clazz.setDatePattern(null);
        }
        if (!(datePattern == null || clazz.getDatePattern() != null && clazz.getDatePattern().getName().equals(datePattern))) {
            sLog.info((Object)("  -- changing date pattern to " + datePattern + " (was " + (clazz.getDatePattern() == null ? "not set" : clazz.getDatePattern().getName()) + ")"));
            DatePattern dp = DatePattern.findByName(clazz.getSession(), datePattern);
            if (dp == null) {
                sLog.error((Object)("Unable to find date pattern named '" + datePattern + "'."));
            } else {
                clazz.setDatePattern(dp);
            }
        }
        if (!clazz.getClassInstructors().isEmpty()) {
            sLog.info((Object)("  -- class " + clazz.getClassLabel() + " already has the following instructors:"));
            i = clazz.getClassInstructors().iterator();
            while (i.hasNext()) {
                ClassInstructor ci = i.next();
                sLog.info((Object)("    -- " + ci.nameLastNameFirst() + " (lead:" + ci.isLead() + ", share:" + ci.getPercentShare() + ")"));
                this.hibSession.remove((Object)ci);
                i.remove();
            }
        }
        i = element.elementIterator("instructor");
        while (i.hasNext()) {
            Element el = (Element)i.next();
            String puid = el.attributeValue("puid");
            DepartmentalInstructor instructor = null;
            try {
                instructor = (DepartmentalInstructor)this.hibSession.createQuery("select i from DepartmentalInstructor i where i.puid=:puid and i.department.uniqueId=:deptId", DepartmentalInstructor.class).setParameter("puid", (Object)puid).setParameter("deptId", (Object)clazz.getControllingDept().getUniqueId()).uniqueResult();
            }
            catch (NonUniqueResultException e) {
                sLog.error((Object)("Two or more instructors with puid " + puid + " (department: " + clazz.getControllingDept().getDeptCode() + ")"));
                continue;
            }
            if (instructor == null) {
                List staffs;
                Staff staff = null;
                try {
                    staff = (Staff)this.hibSession.createQuery("select distinct s from Staff s where s.dept=:dept and s.puid=:puid", Staff.class).setParameter("dept", (Object)clazz.getControllingDept().getDeptCode()).setParameter("puid", (Object)puid).uniqueResult();
                }
                catch (NonUniqueResultException e) {
                    sLog.error((Object)("Two or more staffs with puid " + puid + " (department: " + clazz.getControllingDept().getDeptCode() + ")"));
                    continue;
                }
                if (staff == null && !(staffs = this.hibSession.createQuery("select distinct s from Staff s where s.puid=:puid", Staff.class).setParameter("puid", (Object)puid).list()).isEmpty()) {
                    staff = (Staff)staffs.get(0);
                }
                if (staff != null) {
                    instructor = new DepartmentalInstructor();
                    instructor.setExternalUniqueId(staff.getExternalUniqueId());
                    instructor.setDepartment(clazz.getControllingDept());
                    if (staff.getFirstName() != null) {
                        instructor.setFirstName(staff.getFirstName());
                    }
                    if (staff.getMiddleName() != null) {
                        instructor.setMiddleName(staff.getMiddleName());
                    }
                    if (staff.getLastName() != null) {
                        instructor.setLastName(staff.getLastName());
                    }
                    if (staff.getPositionType() != null) {
                        instructor.setPositionType(staff.getPositionType());
                    }
                    this.hibSession.persist((Object)instructor);
                    this.hibSession.flush();
                    this.hibSession.refresh((Object)instructor);
                    sLog.info((Object)("  -- instructor " + instructor.nameLastNameFirst() + " created"));
                }
            }
            if (instructor == null) {
                sLog.error((Object)("Unable to find instructor with puid " + puid + " (department: " + clazz.getControllingDept().getDeptCode() + ")"));
                continue;
            }
            ClassInstructor ci = new ClassInstructor();
            ci.setInstructor(instructor);
            ci.setLead(Boolean.valueOf(el.attributeValue("isLead")));
            ci.setPercentShare(Integer.valueOf(el.attributeValue("percentShare")));
            ci.setLead(Boolean.valueOf(el.attributeValue("isTentative", "false")));
            String responsibility = el.attributeValue("responsibility");
            if (responsibility != null) {
                ci.setResponsibility(TeachingResponsibility.getTeachingResponsibility(responsibility, this.hibSession));
            }
            ci.setInstructor(instructor);
            ci.setClassInstructing(clazz);
            this.hibSession.persist((Object)ci);
            sLog.info((Object)("  -- added instructor " + ci.nameLastNameFirst() + " (lead:" + ci.isLead() + ", share:" + ci.getPercentShare() + ")"));
        }
        this.importPreferences(clazz, element);
        if (element.attributeValue("assignedDays") != null) {
            Assignment assignment = new Assignment();
            assignment.setClazz(clazz);
            assignment.setSolution(this.iSolution);
            assignment.setClassName(clazz.getClassLabel());
            assignment.setDays(Integer.valueOf(element.attributeValue("assignedDays")));
            assignment.setStartSlot(Integer.valueOf(element.attributeValue("assignedSlot")));
            assignment.setTimePattern(TimePattern.findByName(this.iSession, element.attributeValue("assignedTimePattern")));
            HashSet<Location> rooms = new HashSet<Location>();
            Iterator i2 = element.element("assignedRooms").elementIterator("room");
            while (i2.hasNext()) {
                String roomName = ((Element)i2.next()).attributeValue("name");
                Location location = null;
                for (Location l : clazz.getAvailableRooms()) {
                    if (!l.getLabel().equals(roomName)) continue;
                    location = l;
                    break;
                }
                if (location == null) {
                    sLog.error((Object)("Unable to find room with name " + roomName));
                    continue;
                }
                rooms.add(location);
            }
            assignment.setRooms(rooms);
            this.hibSession.persist((Object)assignment);
            sLog.info((Object)("  -- assignment " + assignment.getPlacement().getName()));
        }
        this.hibSession.merge((Object)clazz);
        this.hibSession.flush();
        this.hibSession.refresh((Object)clazz);
        return clazz;
    }

    public SchedulingSubpart importSchedulingSubpart(Element element) {
        String subjectArea = element.attributeValue("subjectArea");
        String courseNbr = element.attributeValue("courseNbr");
        String itype = element.attributeValue("itype");
        String suffix = element.attributeValue("suffix");
        SchedulingSubpart subpart = (SchedulingSubpart)this.iAllSubparts.get(new ClassHash(element));
        if (subpart == null) {
            sLog.error((Object)("Unable to find scheduling subpart " + subjectArea + " " + courseNbr + " " + itype + " " + (String)(suffix.length() == 0 ? "" : " (" + suffix + ")")));
            return null;
        }
        sLog.info((Object)("Processing subpart " + subjectArea + " " + courseNbr + " " + itype + " " + (String)(suffix.length() == 0 ? "" : " (" + suffix + ")")));
        String datePattern = element.attributeValue("datePattern");
        if (datePattern == null && subpart.getDatePattern() != null) {
            sLog.info((Object)"  -- changing date pattern to default");
            subpart.setDatePattern(null);
        }
        if (!(datePattern == null || subpart.getDatePattern() != null && subpart.getDatePattern().getName().equals(datePattern))) {
            sLog.info((Object)("  -- changing date pattern to " + datePattern));
            DatePattern dp = DatePattern.findByName(subpart.getSession(), datePattern);
            if (dp == null) {
                sLog.error((Object)("Unable to find date pattern named '" + datePattern + "'."));
            } else {
                subpart.setDatePattern(dp);
            }
        }
        int minutesPerWk = Integer.parseInt(element.attributeValue("minutesPerWk"));
        if (subpart.getMinutesPerWk() != minutesPerWk) {
            sLog.info((Object)("  -- changing minutes per meeting to " + minutesPerWk + " (was " + subpart.getMinutesPerWk() + ")"));
            subpart.setMinutesPerWk(minutesPerWk);
        }
        this.importPreferences(subpart, element);
        this.hibSession.merge((Object)subpart);
        this.hibSession.flush();
        this.hibSession.refresh((Object)subpart);
        return subpart;
    }

    public DepartmentalInstructor importInstructor(Element element) {
        String deptCode = element.attributeValue("deptCode");
        String puid = element.attributeValue("puid");
        DepartmentalInstructor instructor = (DepartmentalInstructor)this.hibSession.createQuery("select id from DepartmentalInstructor id where id.department.deptCode=:deptCode and id.department.session.uniqueId=:sessionId and id.puid=:puid", DepartmentalInstructor.class).setParameter("deptCode", (Object)deptCode).setParameter("sessionId", (Object)this.iSession.getUniqueId()).setParameter("puid", (Object)puid).uniqueResult();
        if (instructor == null) {
            sLog.error((Object)("Unable to find instructor " + puid + " for department " + deptCode));
            return null;
        }
        sLog.info((Object)("Processing instructor " + instructor.getLastName() + " (puid:" + puid + ")"));
        this.importPreferences(instructor, element);
        this.hibSession.merge((Object)instructor);
        this.hibSession.flush();
        this.hibSession.refresh((Object)instructor);
        return instructor;
    }

    public void clearExistingDistributionPrefs() {
        Iterator<Department> i = this.iManager.getDepartments().iterator();
        while (i.hasNext()) {
            Department d = i.next();
            for (Preference p : d.getPreferences()) {
                if (!(p instanceof DistributionPref)) continue;
                DistributionPref dp = (DistributionPref)p;
                sLog.info((Object)("Removing existing distribution preference " + dp.getPrefLevel().getPrefName() + " " + dp.getLabel() + " between"));
                for (DistributionObject dobj : dp.getDistributionObjects()) {
                    if (dobj.getPrefGroup() instanceof Class_) {
                        sLog.info((Object)("  -- class " + ((Class_)dobj.getPrefGroup()).getClassLabel()));
                        continue;
                    }
                    if (!(dobj.getPrefGroup() instanceof SchedulingSubpart)) continue;
                    SchedulingSubpart s = (SchedulingSubpart)dobj.getPrefGroup();
                    sLog.info((Object)("  -- scheduling subpart " + s.getCourseName() + " " + s.getItypeDesc() + (String)(s.getSchedulingSubpartSuffix().length() == 0 ? "" : " (" + s.getSchedulingSubpartSuffix() + ")")));
                }
                this.hibSession.remove((Object)dp);
                i.remove();
            }
            this.hibSession.flush();
            this.hibSession.refresh((Object)d);
        }
    }

    public DistributionPref importDistributionPref(Element element) {
        String itype;
        String courseNbr;
        String subjectArea;
        Element x;
        PreferenceLevel level = PreferenceLevel.getPreferenceLevel(element.attributeValue("level"));
        DistributionType type = (DistributionType)this.hibSession.createQuery("select t from DistributionType t where t.reference=:reference", DistributionType.class).setParameter("reference", (Object)element.attributeValue("type")).uniqueResult();
        if (type == null) {
            sLog.error((Object)("Unable to find distribution preference type " + element.attributeValue("type")));
            return null;
        }
        sLog.info((Object)("Processing distribution preference " + level.getPrefName() + " " + type.getLabel()));
        DistributionPref distPref = new DistributionPref();
        distPref.setDistributionType(type);
        distPref.setPrefLevel(level);
        distPref.setGrouping(Integer.valueOf(element.attributeValue("grouping")));
        if (element.attributeValue("manager") != null) {
            distPref.setOwner(this.getDepartment(element.attributeValue("manager")));
        }
        HashSet<DistributionObject> distObjects = new HashSet<DistributionObject>();
        Iterator i = element.elementIterator("class");
        while (i.hasNext()) {
            x = (Element)i.next();
            subjectArea = x.attributeValue("subjectArea");
            courseNbr = x.attributeValue("courseNbr");
            itype = x.attributeValue("itype");
            int section = Integer.parseInt(x.attributeValue("section"));
            String suffix = x.attributeValue("suffix");
            Class_ clazz = (Class_)this.iAllClasses.get(new ClassHash(x));
            if (clazz == null) {
                sLog.error((Object)("Unable to find class " + subjectArea + " " + courseNbr + " " + itype + " " + section + suffix));
                continue;
            }
            DistributionObject dobj = new DistributionObject();
            dobj.setPrefGroup(clazz);
            dobj.setSequenceNumber(Integer.valueOf(x.attributeValue("sequenceNumber")));
            dobj.setDistributionPref(distPref);
            distObjects.add(dobj);
            sLog.info((Object)("  -- added clazz " + clazz.getClassLabel()));
            if (element.attributeValue("manager") != null) continue;
            if (distPref.getOwner() == null) {
                distPref.setOwner(clazz.getManagingDept());
                continue;
            }
            if (!((Department)distPref.getOwner()).isExternalManager().booleanValue() || clazz.getManagingDept().isExternalManager().booleanValue()) continue;
            distPref.setOwner(clazz.getManagingDept());
        }
        i = element.elementIterator("schedulingSubpart");
        while (i.hasNext()) {
            x = (Element)i.next();
            subjectArea = x.attributeValue("subjectArea");
            courseNbr = x.attributeValue("courseNbr");
            itype = x.attributeValue("itype");
            String suffix = x.attributeValue("suffix");
            SchedulingSubpart subpart = (SchedulingSubpart)this.iAllSubparts.get(new ClassHash(x));
            if (subpart == null) {
                sLog.error((Object)("Unable to find scheduling subpart " + subjectArea + " " + courseNbr + " " + itype + " " + (String)(suffix.length() == 0 ? "" : " (" + suffix + ")")));
                continue;
            }
            DistributionObject dobj = new DistributionObject();
            dobj.setPrefGroup(subpart);
            dobj.setSequenceNumber(Integer.valueOf(x.attributeValue("sequenceNumber")));
            dobj.setDistributionPref(distPref);
            distObjects.add(dobj);
            sLog.info((Object)("  -- added subpart " + subjectArea + " " + courseNbr + " " + itype + " " + (String)(suffix.length() == 0 ? "" : " (" + suffix + ")")));
            if (element.attributeValue("manager") != null) continue;
            if (distPref.getOwner() == null) {
                distPref.setOwner(subpart.getManagingDept());
                continue;
            }
            if (!((Department)distPref.getOwner()).isExternalManager().booleanValue() || subpart.getManagingDept().isExternalManager().booleanValue()) continue;
            distPref.setOwner(subpart.getManagingDept());
        }
        if (distObjects.isEmpty()) {
            sLog.error((Object)("No distribution objects found for constraint " + level.getPrefName() + " " + type.getLabel()));
            return null;
        }
        distPref.setDistributionObjects(distObjects);
        this.hibSession.persist((Object)distPref);
        return distPref;
    }

    public void importInstructionalOffering(Element element) {
        InstrOfferingConfig c;
        Element x;
        Iterator<CourseOffering> i;
        InstructionalOffering io = (InstructionalOffering)this.iAllInstructionalOfferings.get(new ClassHash(element));
        sLog.info((Object)("Processing instructional offering " + element.attributeValue("subjectArea") + " " + element.attributeValue("courseNbr")));
        if (io == null) {
            sLog.info((Object)"  -- creating new offering");
            HashSet<CourseOffering> courseOfferings = new HashSet<CourseOffering>();
            i = element.elementIterator("courseOffering");
            while (i.hasNext()) {
                x = (Element)i.next();
                SubjectArea sa = (SubjectArea)this.hibSession.createQuery("select sa from SubjectArea sa where sa.subjectAreaAbbreviation=:subjectAreaAbbreviation and sa.session.uniqueId=:sessionId", SubjectArea.class).setParameter("sessionId", (Object)this.iSession.getUniqueId()).setParameter("subjectAreaAbbreviation", (Object)x.attributeValue("subjectArea")).uniqueResult();
                CourseOffering co = (CourseOffering)this.hibSession.createQuery("select co from CourseOffering co where co.subjectArea.uniqueId=:subjectAreaId and co.courseNbr=:courseNbr", CourseOffering.class).setParameter("subjectAreaId", (Object)sa.getUniqueId()).setParameter("courseNbr", (Object)x.attributeValue("courseNbr")).uniqueResult();
                if (co == null) {
                    co = new CourseOffering();
                    co.setSubjectArea(sa);
                    co.setCourseNbr(x.attributeValue("courseNbr"));
                }
                co.setProjectedDemand(Integer.valueOf(x.attributeValue("projectedDemand")));
                co.setDemand(Integer.valueOf(x.attributeValue("demand", "0")));
                co.setIsControl(Boolean.valueOf(x.attributeValue("isControl")));
                co.setPermId(x.attributeValue("permId"));
                courseOfferings.add(co);
            }
            io = new InstructionalOffering();
            io.setNotOffered(false);
            io.setSession(this.iSession);
            io.setInstrOfferingPermId(Long.valueOf(element.attributeValue("instrOfferingPermId")));
            io.setCourseOfferings(courseOfferings);
            io.setByReservationOnly(false);
            i = courseOfferings.iterator();
            while (i.hasNext()) {
                i.next().setInstructionalOffering(io);
            }
            this.hibSession.persist((Object)io);
            this.hibSession.flush();
            this.hibSession.refresh((Object)io);
        } else if (io.isNotOffered().booleanValue()) {
            sLog.info((Object)"  -- changing not offered offering");
            io.setNotOffered(false);
            this.hibSession.merge((Object)io);
        }
        Hashtable classTable = new Hashtable();
        i = element.elementIterator("instrOfferingConfig");
        if (io.getInstrOfferingConfigs() != null && !io.getInstrOfferingConfigs().isEmpty()) {
            Iterator<InstrOfferingConfig> j = io.getInstrOfferingConfigs().iterator();
            while (i.hasNext() && j.hasNext()) {
                c = j.next();
                Element x2 = (Element)i.next();
                int limit = Integer.parseInt(x2.attributeValue("limit"));
                if (limit != c.getLimit()) {
                    sLog.info((Object)("  -- changing limit to " + limit + " (was " + c.getLimit() + ")"));
                    c.setLimit(limit);
                }
                this.hibSession.merge((Object)c);
                Iterator k = x2.elementIterator("schedulingSubpart");
                while (k.hasNext()) {
                    this.importSchedulingSubpartStructure((Element)k.next(), null, c, classTable);
                }
            }
        }
        while (i.hasNext()) {
            x = (Element)i.next();
            c = new InstrOfferingConfig();
            c.setInstructionalOffering(io);
            c.setLimit(Integer.valueOf(x.attributeValue("limit")));
            c.setUnlimitedEnrollment(Boolean.FALSE);
            if (x.attributeValue("unlimitedEnrollment") != null) {
                c.setUnlimitedEnrollment(Boolean.valueOf(x.attributeValue("unlimitedEnrollment")));
            }
            this.hibSession.persist((Object)c);
            this.hibSession.flush();
            this.hibSession.refresh((Object)c);
            Iterator j = x.elementIterator("schedulingSubpart");
            while (j.hasNext()) {
                this.importSchedulingSubpartStructure((Element)j.next(), null, c, classTable);
            }
        }
    }

    public void importSchedulingSubpartStructure(Element element, SchedulingSubpart parent, InstrOfferingConfig cfg, Hashtable classTable) {
        ClassHash subpartHash = new ClassHash(cfg.getControllingCourseOffering().getSubjectAreaAbbv(), cfg.getControllingCourseOffering().getCourseNbr(), element.attributeValue("itype"), -1, element.attributeValue("suffix"));
        SchedulingSubpart subpart = (SchedulingSubpart)this.iAllSubparts.get(subpartHash);
        if (subpart == null) {
            subpart = new SchedulingSubpart();
            subpart.setItype((ItypeDesc)this.hibSession.createQuery("select i from ItypeDesc i where i.abbv=:abbv", ItypeDesc.class).setParameter("abbv", (Object)element.attributeValue("itype")).uniqueResult());
            subpart.setParentSubpart(parent);
            subpart.setInstrOfferingConfig(cfg);
            subpart.setMinutesPerWk(Integer.valueOf(element.attributeValue("minutesPerWk")));
            this.hibSession.persist((Object)subpart);
            this.iAllSubparts.put(subpartHash, subpart);
            sLog.info((Object)("  -- subpart " + subpartHash + " imported"));
            this.hibSession.flush();
            this.hibSession.refresh((Object)subpart);
        }
        Iterator i = element.elementIterator("class");
        while (i.hasNext()) {
            Element x = (Element)i.next();
            ClassHash clazzHash = new ClassHash(cfg.getControllingCourseOffering().getSubjectAreaAbbv(), cfg.getControllingCourseOffering().getCourseNbr(), subpart.getItypeDesc(), Integer.parseInt(x.attributeValue("sectionNumber")), element.attributeValue("suffix"));
            Class_ clazz = (Class_)this.iAllClasses.get(clazzHash);
            if (clazz == null) {
                int expectedCapacity;
                clazz = new Class_();
                clazz.setSchedulingSubpart(subpart);
                clazz.setCancelled(false);
                if (x.attributeValue("manager") != null) {
                    clazz.setManagingDept(this.getDepartment(x.attributeValue("manager")));
                }
                int maxExpectedCapacity = expectedCapacity = Integer.parseInt(x.attributeValue("expectedCapacity"));
                int numberOfRooms = Integer.parseInt(x.attributeValue("nbrRooms"));
                float roomRatio = 1.0f;
                if (x.attributeValue("roomRatio") != null) {
                    roomRatio = Float.parseFloat(x.attributeValue("roomRatio"));
                    maxExpectedCapacity = Integer.parseInt(x.attributeValue("maxExpectedCapacity"));
                } else {
                    int roomCapacity = Integer.parseInt(x.attributeValue("roomCapacity"));
                    if (expectedCapacity == 0) {
                        roomRatio = 0.0f;
                        expectedCapacity = roomCapacity;
                    } else {
                        roomRatio = (float)roomCapacity / (float)expectedCapacity;
                    }
                }
                clazz.setExpectedCapacity(expectedCapacity);
                clazz.setMaxExpectedCapacity(maxExpectedCapacity);
                clazz.setRoomRatio(Float.valueOf(roomRatio));
                clazz.setNbrRooms(numberOfRooms);
                clazz.setDisplayInstructor(Boolean.TRUE);
                clazz.setEnabledForStudentScheduling(Boolean.TRUE);
                if (x.attributeValue("parent") != null) {
                    clazz.setParentClass((Class_)classTable.get(Long.valueOf(x.attributeValue("parent"))));
                }
                this.hibSession.persist((Object)clazz);
                this.hibSession.flush();
                this.hibSession.refresh((Object)clazz);
                sLog.info((Object)("    -- class " + clazzHash + " imported"));
                this.iAllClasses.put(clazzHash, clazz);
            }
            classTable.put(Long.valueOf(x.attributeValue("uniqueId")), clazz);
        }
        i = element.elementIterator("schedulingSubpart");
        while (i.hasNext()) {
            this.importSchedulingSubpartStructure((Element)i.next(), subpart, cfg, classTable);
        }
    }

    public void importAll(File file) throws Exception {
        this.hibSession = SessionDAO.getInstance().getSession();
        this.tx = this.hibSession.beginTransaction();
        try {
            Document document = new SAXReader().read(file);
            Element root = document.getRootElement();
            sLog.info((Object)("academicYearTerm:" + root.attributeValue("academicYearTerm")));
            sLog.info((Object)("academicInitiative:" + root.attributeValue("academicInitiative")));
            sLog.info((Object)("puid:" + root.attributeValue("puid")));
            sLog.info((Object)("solverGroupName:" + root.attributeValue("solverGroupName")));
            this.iSession = (Session)this.hibSession.createQuery("select s from Session s where s.academicYearTerm=:academicYearTerm and s.academicInitiative=:academicInitiative", Session.class).setParameter("academicYearTerm", (Object)root.attributeValue("academicYearTerm")).setParameter("academicInitiative", (Object)root.attributeValue("academicInitiative")).uniqueResult();
            sLog.info((Object)("session:" + this.iSession));
            if (root.attributeValue("solverGroupName") != null) {
                this.iManager = SolverGroup.findBySessionIdName(this.iSession.getUniqueId(), root.attributeValue("solverGroupName"));
            } else {
                Object puid = root.attributeValue("puid");
                while (((String)puid).length() < 10) {
                    puid = "0" + (String)puid;
                }
                TimetableManager mgr = TimetableManager.findByExternalId((String)puid);
                sLog.info((Object)("manager:" + mgr));
                for (SolverGroup sg : mgr.getSolverGroups()) {
                    if (!sg.getSession().equals(this.iSession)) continue;
                    if (this.iManager != null) {
                        throw new Exception("Two or more solver groups associated with the manager.");
                    }
                    this.iManager = sg;
                }
                if (this.iManager == null) {
                    throw new Exception("No solver group associated with the manager.");
                }
            }
            sLog.info((Object)("manager:" + this.iManager));
            this.iAllClasses = new Hashtable();
            for (Class_ c : Class_.findAll(this.iSession.getUniqueId())) {
                if (c.getSchedulingSubpart() == null || c.getSchedulingSubpart().getControllingCourseOffering() == null) continue;
                this.iAllClasses.put(new ClassHash(c), c);
            }
            sLog.info((Object)("all classes:" + this.iAllClasses.size()));
            this.iAllSubparts = new Hashtable();
            for (SchedulingSubpart s : SchedulingSubpart.findAll(this.iSession.getUniqueId())) {
                if (s.getControllingCourseOffering() == null) continue;
                this.iAllSubparts.put(new ClassHash(s), s);
            }
            sLog.info((Object)("all subparts:" + this.iAllSubparts.size()));
            this.iAllInstructionalOfferings = new Hashtable();
            for (InstructionalOffering io : InstructionalOffering.findAll(this.iSession.getUniqueId())) {
                if (io.getControllingCourseOffering() == null) continue;
                this.iAllInstructionalOfferings.put(new ClassHash(io), io);
            }
            sLog.info((Object)("all instructional offerings:" + this.iAllInstructionalOfferings.size()));
            this.iSolution = new Solution();
            this.iSolution.setCreated(new Date());
            this.iSolution.setCommitDate(null);
            this.iSolution.setCommited(Boolean.FALSE);
            this.iSolution.setCreator("ImportPreferences");
            this.iSolution.setNote("Imported solution.");
            this.iSolution.setOwner(this.iManager);
            this.iSolution.setValid(Boolean.FALSE);
            this.hibSession.persist((Object)this.iSolution);
            Iterator<Object> i = root.elementIterator("instructionalOffering");
            while (i.hasNext()) {
                this.importInstructionalOffering((Element)i.next());
            }
            i = root.elementIterator("timePattern");
            while (i.hasNext()) {
                this.importTimePattern((Element)i.next());
            }
            i = root.elementIterator("datePattern");
            while (i.hasNext()) {
                this.importDatePattern((Element)i.next());
            }
            i = root.elementIterator("class");
            while (i.hasNext()) {
                this.importClass((Element)i.next());
            }
            i = root.elementIterator("schedulingSubpart");
            while (i.hasNext()) {
                this.importSchedulingSubpart((Element)i.next());
            }
            i = root.elementIterator("instructor");
            while (i.hasNext()) {
                this.importInstructor((Element)i.next());
            }
            i = root.elementIterator("distributionPref");
            while (i.hasNext()) {
                this.importDistributionPref((Element)i.next());
            }
            this.tx.commit();
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            this.tx.rollback();
        }
    }

    public static void main(String[] args) {
        try {
            ToolBox.configureLogging();
            HibernateUtil.configureHibernate(args[0]);
            new ImportPreferences().importAll(new File(args[1]));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class ClassHash {
        String subjectArea = null;
        String courseNbr = null;
        String itype = null;
        int section = -1;
        String suffix = null;
        Integer hashCode = null;

        public ClassHash(String subjectArea, String courseNbr, String itype, int section, String suffix) {
            this.subjectArea = subjectArea;
            this.courseNbr = courseNbr;
            this.itype = itype;
            this.section = section;
            this.suffix = suffix;
        }

        public ClassHash(Element element) {
            this.subjectArea = element.attributeValue("subjectArea");
            this.courseNbr = element.attributeValue("courseNbr");
            this.itype = element.attributeValue("itype");
            this.section = element.attributeValue("section") == null ? -1 : Integer.parseInt(element.attributeValue("section"));
            this.suffix = element.attributeValue("suffix");
        }

        public ClassHash(Class_ clazz) {
            this.subjectArea = clazz.getSchedulingSubpart().getControllingCourseOffering().getSubjectAreaAbbv();
            this.courseNbr = clazz.getSchedulingSubpart().getControllingCourseOffering().getCourseNbr();
            this.itype = clazz.getSchedulingSubpart().getItypeDesc();
            this.section = clazz.getSectionNumber();
            this.suffix = clazz.getSchedulingSubpart().getSchedulingSubpartSuffix();
        }

        public ClassHash(SchedulingSubpart subpart) {
            this.subjectArea = subpart.getControllingCourseOffering().getSubjectAreaAbbv();
            this.courseNbr = subpart.getControllingCourseOffering().getCourseNbr();
            this.itype = subpart.getItypeDesc();
            this.suffix = subpart.getSchedulingSubpartSuffix();
        }

        public ClassHash(InstructionalOffering io) {
            this.subjectArea = io.getControllingCourseOffering().getSubjectAreaAbbv();
            this.courseNbr = io.getControllingCourseOffering().getCourseNbr();
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof ClassHash)) {
                return false;
            }
            ClassHash x = (ClassHash)o;
            return ToolBox.equals((Object)this.subjectArea, (Object)x.subjectArea) && ToolBox.equals((Object)this.courseNbr, (Object)x.courseNbr) && ToolBox.equals((Object)this.itype, (Object)x.itype) && this.section == x.section && ToolBox.equals((Object)this.suffix, (Object)x.suffix);
        }

        public String toString() {
            return this.subjectArea + " " + this.courseNbr + " " + (this.itype == null ? "" : this.itype) + " " + (String)(this.section >= 0 ? "" + this.section : "") + (this.suffix == null ? "" : this.suffix);
        }

        public int hashCode() {
            if (this.hashCode == null) {
                this.hashCode = this.toString().hashCode();
            }
            return this.hashCode;
        }
    }
}

