/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.spring.ldap;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.security.ldap.SpringSecurityLdapTemplate;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.interfaces.ExternalUidLookup;
import org.unitime.timetable.spring.SpringApplicationContextHolder;

public class SpringLdapExternalUidLookup
implements ExternalUidLookup {
    private static Log sLog = LogFactory.getLog(SpringLdapExternalUidLookup.class);

    @Override
    public ExternalUidLookup.UserInfo doLookup(String uid) throws Exception {
        try {
            ContextSource source = (ContextSource)SpringApplicationContextHolder.getBean("unitimeLdapContextSource");
            String query = ApplicationProperty.AuthenticationLdapIdentify.value();
            String idAttributeName = ApplicationProperty.AuthenticationLdapIdAttribute.value();
            SpringSecurityLdapTemplate template = new SpringSecurityLdapTemplate(source);
            DirContextOperations user = template.retrieveEntry(query.replaceAll("\\{0\\}", uid), new String[]{"uid", idAttributeName, "cn", "givenName", "sn", "mail"});
            if (user == null || user.getStringAttribute(idAttributeName) == null) {
                return null;
            }
            ExternalUidLookup.UserInfo info = new ExternalUidLookup.UserInfo();
            info.setExternalId(user.getStringAttribute(idAttributeName));
            info.setUserName(user.getStringAttribute("uid"));
            if (info.getUserName() == null) {
                info.setUserName(uid);
            }
            info.setName(user.getStringAttribute("cn"));
            info.setFirstName(user.getStringAttribute("givenName"));
            info.setLastName(user.getStringAttribute("sn"));
            info.setEmail(user.getStringAttribute("mail"));
            if (info.getEmail() == null) {
                String email = info.getUserName() + "@";
                for (String x : user.getNameInNamespace().split(",")) {
                    if (!x.startsWith("dc=")) continue;
                    email = email + (email.endsWith("@") ? "" : ".") + x.substring(3);
                }
                if (!email.endsWith("@")) {
                    info.setEmail(email);
                }
            }
            return info;
        }
        catch (Exception e) {
            sLog.warn((Object)("Lookup for " + uid + " failed: " + e.getMessage()));
            return null;
        }
    }
}

