/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.ui;

import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.util.HashSet;
import java.util.Set;
import org.cpsolver.coursett.constraint.InstructorConstraint;
import org.cpsolver.coursett.constraint.SoftInstructorConstraint;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.coursett.model.TimetableModel;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.DistanceMetric;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.solver.interactive.ClassAssignmentDetails;
import org.unitime.timetable.util.Constants;

public class DiscouragedInstructorBtbReport
implements Serializable {
    private static final long serialVersionUID = 1L;
    private HashSet iGroups = new HashSet();

    public DiscouragedInstructorBtbReport(Solver solver) {
        TimetableModel model = (TimetableModel)solver.currentSolution().getModel();
        Assignment assignment = solver.currentSolution().getAssignment();
        for (InstructorConstraint ic : model.getInstructorConstraints()) {
            TimeLocation t2;
            TimeLocation t1;
            Placement p1;
            InstructorConstraint.InstructorConstraintContext context = (InstructorConstraint.InstructorConstraintContext)ic.getContext(assignment);
            HashSet<CallSite> checked = new HashSet<CallSite>();
            for (int slot = 1; slot < 288 * Constants.NR_DAYS; ++slot) {
                if (slot % 288 == 0) continue;
                for (Placement placement : context.getPlacements(slot)) {
                    for (Placement prevPlacement : context.getPlacements(slot - 1, placement)) {
                        if (prevPlacement.equals((Object)placement) || !checked.add((CallSite)((Object)(prevPlacement + "." + placement))) || placement.getTimeLocation().hasIntersection(prevPlacement.getTimeLocation())) continue;
                        double dist = Placement.getDistanceInMeters((DistanceMetric)model.getDistanceMetric(), (Placement)prevPlacement, (Placement)placement);
                        if (dist > model.getDistanceMetric().getInstructorNoPreferenceLimit() && dist <= model.getDistanceMetric().getInstructorDiscouragedLimit()) {
                            this.iGroups.add(new DiscouragedBtb(solver, ic, dist, prevPlacement, placement, PreferenceLevel.sDiscouraged));
                        }
                        if (dist > model.getDistanceMetric().getInstructorDiscouragedLimit() && dist <= model.getDistanceMetric().getInstructorProhibitedLimit()) {
                            this.iGroups.add(new DiscouragedBtb(solver, ic, dist, prevPlacement, placement, PreferenceLevel.sStronglyDiscouraged));
                        }
                        if (!(dist > model.getDistanceMetric().getInstructorProhibitedLimit())) continue;
                        this.iGroups.add(new DiscouragedBtb(solver, ic, dist, prevPlacement, placement, ic.isIgnoreDistances() ? PreferenceLevel.sStronglyDiscouraged : PreferenceLevel.sProhibited));
                    }
                }
            }
            if (model.getDistanceMetric().doComputeDistanceConflictsBetweenNonBTBClasses()) {
                for (Lecture l1 : ic.variables()) {
                    TimeLocation t0;
                    p1 = (Placement)assignment.getValue((Variable)l1);
                    TimeLocation timeLocation = t1 = p1 == null ? null : p1.getTimeLocation();
                    if (t1 == null) continue;
                    Placement before = null;
                    for (Lecture l2 : ic.variables()) {
                        TimeLocation t22;
                        Placement p2 = (Placement)assignment.getValue((Variable)l2);
                        if (p2 == null || l2.equals((Object)l1) || (t22 = p2.getTimeLocation()) == null || !t1.shareDays(t22) || !t1.shareWeeks(t22)) continue;
                        if (t22.getStartSlot() + t22.getLength() < t1.getStartSlot()) {
                            int distanceInMinutes = Placement.getDistanceInMinutes((DistanceMetric)model.getDistanceMetric(), (Placement)p1, (Placement)p2);
                            if (distanceInMinutes > t22.getBreakTime() + Constants.SLOT_LENGTH_MIN * (t1.getStartSlot() - t22.getStartSlot() - t22.getLength())) {
                                this.iGroups.add(new DiscouragedBtb(solver, ic, Placement.getDistanceInMeters((DistanceMetric)model.getDistanceMetric(), (Placement)p1, (Placement)p2), p1, p2, ic.isIgnoreDistances() ? PreferenceLevel.sStronglyDiscouraged : PreferenceLevel.sProhibited));
                            } else if (distanceInMinutes > Constants.SLOT_LENGTH_MIN * (t1.getStartSlot() - t22.getStartSlot() - t22.getLength())) {
                                this.iGroups.add(new DiscouragedBtb(solver, ic, Placement.getDistanceInMeters((DistanceMetric)model.getDistanceMetric(), (Placement)p1, (Placement)p2), p1, p2, PreferenceLevel.sDiscouraged));
                            }
                        }
                        if (t22.getStartSlot() + t22.getLength() > t1.getStartSlot() || before != null && before.getTimeLocation().getStartSlot() >= t22.getStartSlot()) continue;
                        before = p2;
                    }
                    if (ic.getUnavailabilities() != null) {
                        for (Placement c : ic.getUnavailabilities()) {
                            t2 = c.getTimeLocation();
                            if (t1 == null || t2 == null || !t1.shareDays(t2) || !t1.shareWeeks(t2) || t2.getStartSlot() + t2.getLength() > t1.getStartSlot() || before != null && before.getTimeLocation().getStartSlot() >= t2.getStartSlot()) continue;
                            before = c;
                        }
                    }
                    if (before == null || (t0 = before.getTimeLocation()).getStartSlot() + t0.getLength() >= t1.getStartSlot()) continue;
                    if (Placement.getDistanceInMinutes((DistanceMetric)model.getDistanceMetric(), before, (Placement)p1) > t0.getBreakTime() + Constants.SLOT_LENGTH_MIN * (t1.getStartSlot() - t0.getStartSlot() - t0.getLength())) {
                        this.iGroups.add(new DiscouragedBtb(solver, ic, -Placement.getDistanceInMinutes((DistanceMetric)model.getDistanceMetric(), (Placement)before, (Placement)p1), before, p1, ic.isIgnoreDistances() ? PreferenceLevel.sStronglyDiscouraged : PreferenceLevel.sProhibited));
                        continue;
                    }
                    if (before != null && (double)Placement.getDistanceInMinutes((DistanceMetric)model.getDistanceMetric(), (Placement)before, (Placement)p1) > model.getDistanceMetric().getInstructorLongTravelInMinutes()) {
                        this.iGroups.add(new DiscouragedBtb(solver, ic, -Placement.getDistanceInMinutes((DistanceMetric)model.getDistanceMetric(), (Placement)before, (Placement)p1), before, p1, PreferenceLevel.sStronglyDiscouraged));
                        continue;
                    }
                    if (Placement.getDistanceInMinutes((DistanceMetric)model.getDistanceMetric(), (Placement)before, (Placement)p1) <= Constants.SLOT_LENGTH_MIN * (t1.getStartSlot() - t0.getStartSlot() - t0.getLength())) continue;
                    this.iGroups.add(new DiscouragedBtb(solver, ic, -Placement.getDistanceInMinutes((DistanceMetric)model.getDistanceMetric(), (Placement)before, (Placement)p1), before, p1, PreferenceLevel.sDiscouraged));
                }
            }
            if (!(ic instanceof SoftInstructorConstraint)) continue;
            for (Lecture l1 : ic.variables()) {
                p1 = (Placement)assignment.getValue((Variable)l1);
                TimeLocation timeLocation = t1 = p1 == null ? null : p1.getTimeLocation();
                if (t1 == null) continue;
                for (Lecture l2 : ic.variables()) {
                    Placement p2;
                    if (l1.compareTo(l2) <= 0 || (p2 = (Placement)assignment.getValue((Variable)l2)) == null || p1.canShareRooms(p2) && p1.sameRooms(p2)) continue;
                    t2 = p2.getTimeLocation();
                    if (t1 == null || t2 == null || !t1.hasIntersection(t2)) continue;
                    this.iGroups.add(new DiscouragedBtb(solver, ic, 0.0, p1, p2, PreferenceLevel.sProhibited));
                }
                if (ic.getUnavailabilities() == null) continue;
                for (Placement c : ic.getUnavailabilities()) {
                    TimeLocation t23;
                    if (!(!c.getTimeLocation().hasIntersection(t1) || l1.canShareRoom((Lecture)c.variable()) && p1.sameRooms(c))) {
                        if (!checked.add((CallSite)((Object)(p1 + "." + c)))) continue;
                        this.iGroups.add(new DiscouragedBtb(solver, ic, 0.0, p1, c, PreferenceLevel.sProhibited));
                        continue;
                    }
                    if (ic.isIgnoreDistances() || !t1.shareDays(t23 = c.getTimeLocation()) || !t1.shareWeeks(t23) || t1.getStartSlot() + t1.getLength() != t23.getStartSlot() && t23.getStartSlot() + t23.getLength() != t1.getStartSlot() || !(Placement.getDistanceInMeters((DistanceMetric)model.getDistanceMetric(), (Placement)p1, (Placement)c) > model.getDistanceMetric().getInstructorProhibitedLimit()) || !checked.add((CallSite)((Object)(p1 + "." + c)))) continue;
                    this.iGroups.add(new DiscouragedBtb(solver, ic, Placement.getDistanceInMeters((DistanceMetric)model.getDistanceMetric(), (Placement)p1, (Placement)c), p1, c, PreferenceLevel.sProhibited));
                }
            }
        }
    }

    public Set getGroups() {
        return this.iGroups;
    }

    public class DiscouragedBtb
    implements Serializable {
        private static final long serialVersionUID = 1L;
        String iPreference;
        Long iInstructorId;
        String iInstructorName;
        ClassAssignmentDetails iFirst;
        ClassAssignmentDetails iSecond;
        double iDistance;

        public DiscouragedBtb(Solver solver, InstructorConstraint ic, double distance, Placement first, Placement second, String pref) {
            this.iPreference = pref;
            this.iInstructorId = ic.getResourceId();
            this.iInstructorName = ic.getName();
            this.iDistance = distance;
            this.iFirst = new ClassAssignmentDetails(solver, (Lecture)first.variable(), false);
            this.iSecond = new ClassAssignmentDetails(solver, (Lecture)second.variable(), false);
        }

        public String getPreference() {
            return this.iPreference;
        }

        public String getInstructorName() {
            return this.iInstructorName;
        }

        public Long getInstructorId() {
            return this.iInstructorId;
        }

        public ClassAssignmentDetails getFirst() {
            return this.iFirst;
        }

        public ClassAssignmentDetails getSecond() {
            return this.iSecond;
        }

        public double getDistance() {
            return this.iDistance;
        }
    }
}

