/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.ui;

import jakarta.servlet.jsp.JspWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.cpsolver.coursett.constraint.ClassLimitConstraint;
import org.cpsolver.coursett.constraint.DepartmentSpreadConstraint;
import org.cpsolver.coursett.constraint.FlexibleConstraint;
import org.cpsolver.coursett.constraint.GroupConstraint;
import org.cpsolver.coursett.constraint.InstructorConstraint;
import org.cpsolver.coursett.constraint.JenrlConstraint;
import org.cpsolver.coursett.constraint.MinimizeNumberOfUsedGroupsOfTime;
import org.cpsolver.coursett.constraint.MinimizeNumberOfUsedRoomsConstraint;
import org.cpsolver.coursett.constraint.RoomConstraint;
import org.cpsolver.coursett.constraint.SpreadConstraint;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.extension.AssignedValue;
import org.cpsolver.ifs.extension.ConflictStatistics;
import org.cpsolver.ifs.model.Constraint;
import org.cpsolver.ifs.solver.Solver;
import org.dom4j.Element;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.resources.CPSolverMessages;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.server.solver.TimetableGridSolverHelper;
import org.unitime.timetable.solver.ui.TimetableInfo;
import org.unitime.timetable.util.Constants;

public class ConflictStatisticsInfo
implements TimetableInfo,
Serializable {
    protected static CPSolverMessages MSG = Localization.create(CPSolverMessages.class);
    private static final long serialVersionUID = 7L;
    public static int sVersion = 8;
    public static final int sConstraintTypeRoom = 1;
    public static final int sConstraintTypeInstructor = 2;
    public static final int sConstraintTypeGroup = 3;
    public static final int sConstraintTypeBalanc = 4;
    public static final int sConstraintTypeSpread = 5;
    public static final int sConstraintTypeMinNrRoomUsed = 6;
    public static final int sConstraintTypeClassLimit = 7;
    public static final int sConstraintTypeMinNrGroupsOfTime = 8;
    public static final int sConstraintTypeJoinEnrollment = 9;
    public static final int sConstraintTypeFlexible = 10;
    private Map<Long, CBSVariable> iVariables = new HashMap<Long, CBSVariable>();
    private static String IMG_BASE = "images/";
    private static String IMG_EXPAND = IMG_BASE + "expand_node_btn.gif";
    private static String IMG_COLLAPSE = IMG_BASE + "collapse_node_btn.gif";
    private static String IMG_LEAF = IMG_BASE + "end_node_btn.gif";
    public static int TYPE_VARIABLE_BASED = 0;
    public static int TYPE_CONSTRAINT_BASED = 1;

    public Collection<CBSVariable> getCBS() {
        return this.iVariables.values();
    }

    public CBSVariable getCBS(Long classId) {
        return this.iVariables.get(classId);
    }

    public void load(Solver<Lecture, Placement> solver, ConflictStatistics cbs) {
        this.load(solver, cbs, null);
    }

    public ConflictStatisticsInfo getConflictStatisticsSubInfo(List variables) {
        ConflictStatisticsInfo ret = new ConflictStatisticsInfo();
        for (Lecture lecture : variables) {
            CBSVariable var = this.iVariables.get(lecture.getClassId());
            if (var == null) continue;
            ret.iVariables.put(lecture.getClassId(), var);
        }
        return ret;
    }

    public void merge(ConflictStatisticsInfo info) {
        if (info != null) {
            this.iVariables.putAll(info.iVariables);
        }
    }

    public void load(Solver<Lecture, Placement> solver, ConflictStatistics cbs, Long classId) {
        this.iVariables.clear();
        for (Map.Entry entry : cbs.getNoGoods().entrySet()) {
            AssignedValue assignment = (AssignedValue)entry.getKey();
            Placement placement = (Placement)assignment.getValue();
            Lecture lecture = (Lecture)placement.variable();
            if (classId != null && !classId.equals(lecture.getClassId())) continue;
            CBSVariable var = this.iVariables.get(lecture.getClassId());
            if (var == null) {
                String pref = TimetableGridSolverHelper.hardConflicts2pref((Assignment<Lecture, Placement>)solver.currentSolution().getAssignment(), lecture, null);
                var = new CBSVariable(lecture.getClassId(), lecture.getName(), pref);
                this.iVariables.put(lecture.getClassId(), var);
            }
            CBSValue val = new CBSValue(var, lecture.getInstructorName(), placement.getRoomNames(), placement.getTimeLocation().getDayCode(), placement.getTimeLocation().getStartSlot(), placement.getRoomIds(), placement.getTimeLocation().getPreference(), placement.getRoomPrefs(), placement.getTimeLocation().getLength(), placement.getTimeLocation().getDatePatternName(), placement.getTimeLocation().getTimePatternId(), placement.getTimeLocation().getBreakTime(), placement.getTimeLocation().getDatePatternId());
            var.values().add(val);
            List noGoods = (List)entry.getValue();
            Hashtable<Constraint, ArrayList<AssignedValue>> constr2assignments = new Hashtable<Constraint, ArrayList<AssignedValue>>();
            for (AssignedValue noGood : noGoods) {
                if (noGood.getConstraint() == null) continue;
                ArrayList<AssignedValue> aaa = (ArrayList<AssignedValue>)constr2assignments.get(noGood.getConstraint());
                if (aaa == null) {
                    aaa = new ArrayList<AssignedValue>();
                    constr2assignments.put(noGood.getConstraint(), aaa);
                }
                aaa.add(noGood);
            }
            for (Map.Entry entry2 : constr2assignments.entrySet()) {
                Constraint constraint = (Constraint)entry2.getKey();
                List noGoodsThisConstraint = (List)entry2.getValue();
                CBSConstraint con = null;
                con = constraint instanceof RoomConstraint ? new CBSConstraint(val, 1, ((RoomConstraint)constraint).getResourceId(), constraint.getName(), PreferenceLevel.sRequired) : (constraint instanceof InstructorConstraint ? new CBSConstraint(val, 2, ((InstructorConstraint)constraint).getResourceId(), constraint.getName(), PreferenceLevel.sRequired) : (constraint instanceof GroupConstraint ? new CBSConstraint(val, 3, ((GroupConstraint)constraint).getId(), constraint.getName(), ((GroupConstraint)constraint).getPrologPreference()) : (constraint instanceof DepartmentSpreadConstraint ? new CBSConstraint(val, 4, ((DepartmentSpreadConstraint)constraint).getDepartmentId(), constraint.getName(), PreferenceLevel.sRequired) : (constraint instanceof SpreadConstraint ? new CBSConstraint(val, 5, constraint.getId(), constraint.getName(), PreferenceLevel.sRequired) : (constraint instanceof MinimizeNumberOfUsedRoomsConstraint ? new CBSConstraint(val, 6, constraint.getId(), constraint.getName(), PreferenceLevel.sRequired) : (constraint instanceof ClassLimitConstraint ? new CBSConstraint(val, 7, constraint.getId(), constraint.getName(), PreferenceLevel.sRequired) : (constraint instanceof MinimizeNumberOfUsedGroupsOfTime ? new CBSConstraint(val, 8, constraint.getId(), constraint.getName(), PreferenceLevel.sRequired) : (constraint instanceof JenrlConstraint ? new CBSConstraint(val, 9, constraint.getId(), constraint.toString(), PreferenceLevel.sRequired) : (constraint instanceof FlexibleConstraint ? new CBSConstraint(val, 10, constraint.getId(), constraint.getName(), PreferenceLevel.sRequired) : new CBSConstraint(val, -1, constraint.getId(), constraint.getName(), PreferenceLevel.sRequired))))))))));
                val.constraints().add(con);
                for (AssignedValue ass : noGoodsThisConstraint) {
                    Placement p = (Placement)ass.getValue();
                    Lecture l = (Lecture)p.variable();
                    String pr = TimetableGridSolverHelper.hardConflicts2pref((Assignment<Lecture, Placement>)solver.currentSolution().getAssignment(), l, p);
                    CBSAssignment a = new CBSAssignment(con, l.getClassId(), l.getName(), l.getInstructorName(), p.getRoomNames(), p.getTimeLocation().getDayCode(), p.getTimeLocation().getStartSlot(), p.getRoomIds(), pr, p.getTimeLocation().getPreference(), p.getRoomPrefs(), p.getTimeLocation().getLength(), p.getTimeLocation().getDatePatternName(), p.getTimeLocation().getTimePatternId(), p.getTimeLocation().getBreakTime(), p.getTimeLocation().getDatePatternId());
                    con.assignments().add(a);
                    a.incCounter((int)ass.getCounter(0L));
                }
            }
        }
    }

    @Override
    public void load(Element root) {
        int version = Integer.parseInt(root.attributeValue("version"));
        if (version == sVersion) {
            this.iVariables.clear();
            Iterator i1 = root.elementIterator("var");
            while (i1.hasNext()) {
                CBSVariable var = new CBSVariable((Element)i1.next());
                this.iVariables.put(var.getId(), var);
            }
        }
    }

    @Override
    public void save(Element root) {
        root.addAttribute("version", String.valueOf(sVersion));
        Iterator<CBSVariable> i1 = this.iVariables.values().iterator();
        while (i1.hasNext()) {
            i1.next().save(root.addElement("var"));
        }
    }

    private static int combine(int a, int b) {
        int ret = 0;
        for (int i = 0; i < 15; ++i) {
            ret = ret | (a & 1 << i) << i | (b & 1 << i) << i + 1;
        }
        return ret;
    }

    private void menu_item(PrintWriter out, String id, String name, String description, String page, boolean isCollapsed) {
        out.println("<div style=\"margin-left:5px;\">");
        out.println("<A style=\"border:0;background:0\" id=\"__idMenu" + id + "\" href=\"javascript:toggle('" + id + "')\" name=\"" + name + "\">");
        out.println("<img id=\"__idMenuImg" + id + "\" border=\"0\" src=\"" + (isCollapsed ? IMG_EXPAND : IMG_COLLAPSE) + "\" align=\"absmiddle\"></A>");
        out.println("&nbsp;<A class='noFancyLinks' target=\"__idContentFrame\" " + (String)(page == null ? "" : page + " onmouseover=\"this.style.cursor='hand';this.style.cursor='pointer';\" ") + "title=\"" + (description == null ? "" : description) + "\" >" + name + (String)(description == null ? "" : " <font color='gray'>[" + description + "]</font>") + "</A><br>");
        out.println("</div>");
        out.println("<div ID=\"__idMenuDiv" + id + "\" style=\"display:" + (isCollapsed ? "none" : "block") + ";position:relative;margin-left:18px;\">");
    }

    private void leaf_item(PrintWriter out, String name, String description, String page) {
        out.println("<div style=\"margin-left:5px;\">");
        out.println("<img border=\"0\" src=\"" + IMG_LEAF + "\" align=\"absmiddle\">");
        out.println("&nbsp;<A class='noFancyLinks' target=\"__idContentFrame\" " + (String)(page == null ? "" : page + " onmouseover=\"this.style.cursor='hand';this.style.cursor='pointer';\" ") + "title=\"" + (description == null ? "" : description) + "\" >" + name + (String)(description == null ? "" : " <font color='gray'>[" + description + "]</font>") + "</A><br>");
        out.println("</div>");
    }

    private void end_item(PrintWriter out) {
        out.println("</div>");
    }

    private void unassignedVariableMenuItem(PrintWriter out, String menuId, CBSVariable variable, boolean clickable) {
        String name = "<font color='" + PreferenceLevel.prolog2color(variable.getPref()) + "'>" + variable.getName() + "</font>";
        String description = null;
        String onClick = null;
        if (clickable) {
            onClick = "onclick=\"(parent ? parent : window).showGwtDialog('Suggestions', 'suggestions.do?id=" + variable.getId() + "&op=Reset','900','90%');\"";
        }
        this.menu_item(out, menuId, variable.getCounter() + "&times; " + name, description, onClick, true);
    }

    private void unassignmentMenuItem(PrintWriter out, String menuId, CBSValue value, boolean clickable) {
        String name = "<font color='" + PreferenceLevel.int2color(value.getTimePref()) + "'>" + value.getDays() + " " + value.getStartTime() + " - " + value.getEndTime() + " " + value.getDatePatternName() + "</font> ";
        Object roomLink = "";
        for (int i = 0; i < value.getRoomIds().size(); ++i) {
            name = name + (i > 0 ? ", " : "") + "<font color='" + PreferenceLevel.int2color(value.getRoomPrefs().get(i)) + "'>" + value.getRoomNames().get(i) + "</font>";
            roomLink = (String)roomLink + "&room" + i + "=" + value.getRoomIds().get(i);
        }
        if (value.getInstructorName() != null) {
            name = name + " " + value.getInstructorName();
        }
        String description = null;
        String onClick = null;
        if (clickable) {
            onClick = "onclick=\"(parent ? parent : window).showGwtDialog('Suggestions', 'suggestions.do?id=" + value.variable().getId() + (String)roomLink + "&days=" + value.getDayCode() + "&pattern=" + value.getPatternId() + "&slot=" + value.getStartSlot() + "&dates=" + value.getDatePatternId() + "&op=Try&reset=1','900','90%');\"";
        }
        this.menu_item(out, menuId, value.getCounter() + "&times; " + name, description, onClick, true);
    }

    private void constraintMenuItem(PrintWriter out, String menuId, CBSConstraint constraint, boolean clickable) {
        String name = "<font color='" + PreferenceLevel.prolog2color(constraint.getPref()) + "'>";
        String link = null;
        switch (constraint.getType()) {
            case 4: {
                name = name + MSG.constraintDeptBalancing(constraint.getName());
                break;
            }
            case 5: {
                name = name + MSG.constraintSubpartBalancing(constraint.getName());
                break;
            }
            case 3: {
                name = name + MSG.constraintDistribution(constraint.getName());
                break;
            }
            case 2: {
                name = name + MSG.constraintInstructor(constraint.getName());
                if (!clickable) break;
                link = "timetable.do?filter=" + constraint.getName() + "&mode=i&op=Show";
                break;
            }
            case 1: {
                name = name + MSG.constraintRoom(constraint.getName());
                if (!clickable) break;
                link = "timetable.do?filter=" + constraint.getName() + "&mode=r&op=Show";
                break;
            }
            case 7: {
                name = name + MSG.constraintClassLimit(constraint.getName());
                break;
            }
            case 9: {
                name = name + MSG.constraintJointEnrollment(constraint.getName());
                break;
            }
            case 10: {
                name = name + MSG.constraintFlexible(constraint.getName());
                break;
            }
            case 6: 
            case 8: {
                name = name + constraint.getName();
                break;
            }
            default: {
                name = name + (constraint.getName() == null ? MSG.constraintWithNoName() : constraint.getName());
            }
        }
        name = name + "</font>";
        String description = null;
        String onClick = null;
        if (link != null) {
            onClick = "href=\"" + link + "\"";
        }
        this.menu_item(out, menuId, constraint.getCounter() + "&times; " + name, description, onClick, true);
    }

    private void assignmentLeafItem(PrintWriter out, CBSAssignment assignment, boolean clickable) {
        String name = "<font color='" + PreferenceLevel.prolog2color(assignment.getPref()) + "'>" + assignment.getVariableName() + "</font> &larr; <font color='" + PreferenceLevel.int2color(assignment.getTimePref()) + "'>" + assignment.getDays() + " " + assignment.getStartTime() + " - " + assignment.getEndTime() + " " + assignment.getDatePatternName() + "</font> ";
        Object roomLink = "";
        for (int i = 0; i < assignment.getRoomIds().size(); ++i) {
            name = name + (i > 0 ? ", " : "") + "<font color='" + PreferenceLevel.int2color((Integer)assignment.getRoomPrefs().get(i)) + "'>" + assignment.getRoomNames().get(i) + "</font>";
            roomLink = (String)roomLink + "&room" + i + "=" + assignment.getRoomIds().get(i);
        }
        if (assignment.getInstructorName() != null) {
            name = name + " " + assignment.getInstructorName();
        }
        String onClick = null;
        if (clickable) {
            onClick = "onclick=\"(parent ? parent : window).showGwtDialog('Suggestions', 'suggestions.do?id=" + assignment.getId() + (String)roomLink + "&days=" + assignment.getDayCode() + "&pattern=" + assignment.getPatternId() + "&slot=" + assignment.getStartSlot() + "&dates=" + assignment.getDatePatternId() + "&op=Try&reset=1','900','90%');\"";
        }
        this.leaf_item(out, assignment.getCounter() + "&times; " + name, null, onClick);
    }

    public static void printHtmlHeader(JspWriter jsp) {
        PrintWriter out = new PrintWriter((Writer)jsp);
        ConflictStatisticsInfo.printHtmlHeader(out, false);
    }

    public static void printHtmlHeader(PrintWriter out, boolean style) {
        if (style) {
            out.println("<style type=\"text/css\">");
            out.println("<!--");
            out.println("A:link     { color: blue; text-decoration: none; border:0; background:0; }");
            out.println("A:visited  { color: blue; text-decoration: none; border:0; background:0; }");
            out.println("A:active   { color: blue; text-decoration: none; border:0; background:0; }");
            out.println("A:hover    { color: blue; text-decoration: none; border:0; background:0; }");
            out.println(".TextBody  { background-color: white; color:black; font-size: 12px; }");
            out.println(".WelcomeHead { color: black; margin-top: 0px; margin-left: 0px; font-weight: bold; text-align: right; font-size: 30px; font-family: Comic Sans MS}");
            out.println("-->");
            out.println("</style>");
            out.println();
        }
        out.println("<script language=\"javascript\" type=\"text/javascript\">");
        out.println("function toggle(item) {");
        out.println("\tobj=document.getElementById(\"__idMenuDiv\"+item);");
        out.println("\tvisible=(obj.style.display!=\"none\");");
        out.println("\timg=document.getElementById(\"__idMenuImg\" + item);");
        out.println("\tmenu=document.getElementById(\"__idMenu\" + item);");
        out.println("\tif (visible) {obj.style.display=\"none\";img.src=\"" + IMG_EXPAND + "\";}");
        out.println("\telse {obj.style.display=\"block\";img.src=\"" + IMG_COLLAPSE + "\";}");
        out.println("}");
        out.println("</script>");
        out.flush();
    }

    public static <E extends Counter> List<E> filter(Collection<E> counters, double limit) {
        ArrayList<E> cnt = new ArrayList<E>(counters);
        Collections.sort(cnt);
        int total = 0;
        Iterator e = cnt.iterator();
        while (e.hasNext()) {
            total += ((Counter)e.next()).getCounter();
        }
        int totalLimit = (int)Math.ceil(limit * (double)total);
        int current = 0;
        ArrayList<Counter> ret = new ArrayList<Counter>();
        for (Counter c : cnt) {
            ret.add(c);
            if ((current += c.getCounter()) < totalLimit) continue;
            break;
        }
        return ret;
    }

    public void printHtml(JspWriter jsp, double limit, int type, boolean clickable) {
        this.printHtml(jsp, null, new double[]{limit, limit, limit, limit}, type, clickable);
    }

    public void printHtml(PrintWriter out, double limit, int type, boolean clickable) {
        this.printHtml(out, null, new double[]{limit, limit, limit, limit}, type, clickable);
    }

    public void printHtml(JspWriter jsp, double[] limit, int type, boolean clickable) {
        this.printHtml(jsp, null, limit, type, clickable);
    }

    public void printHtml(PrintWriter out, double[] limit, int type, boolean clickable) {
        this.printHtml(out, null, limit, type, clickable);
    }

    public void printHtml(JspWriter jsp, Long classId, double limit, int type, boolean clickable) {
        this.printHtml(jsp, classId, new double[]{limit, limit, limit, limit}, type, clickable);
    }

    public void printHtml(PrintWriter out, Long classId, double limit, int type, boolean clickable) {
        this.printHtml(out, classId, new double[]{limit, limit, limit, limit}, type, clickable);
    }

    public void printHtml(JspWriter jsp, Long classId, double[] limit, int type, boolean clickable) {
        PrintWriter out = new PrintWriter((Writer)jsp);
        this.printHtml(out, classId, limit, type, clickable);
    }

    public void printHtml(PrintWriter out, Long classId, double[] limit, int type, boolean clickable) {
        if (type == TYPE_VARIABLE_BASED) {
            List<CBSVariable> vars = ConflictStatisticsInfo.filter(this.iVariables.values(), limit[0]);
            if (classId != null) {
                CBSVariable var = this.iVariables.get(classId);
                vars.clear();
                if (var != null) {
                    vars.add(var);
                }
            }
            for (CBSVariable variable : vars) {
                String m1 = String.valueOf(variable.getId());
                if (classId == null) {
                    this.unassignedVariableMenuItem(out, m1, variable, clickable);
                }
                List<CBSValue> vals = ConflictStatisticsInfo.filter(variable.values(), limit[1]);
                int id = 0;
                for (CBSValue value : vals) {
                    String m2 = m1 + "." + id++;
                    this.unassignmentMenuItem(out, m2, value, clickable);
                    List<CBSConstraint> constraints = ConflictStatisticsInfo.filter(value.constraints(), limit[2]);
                    for (CBSConstraint constraint : constraints) {
                        String m3 = m2 + constraint.getType() + "." + constraint.getId();
                        this.constraintMenuItem(out, m3, constraint, clickable);
                        List<CBSAssignment> assignments = ConflictStatisticsInfo.filter(constraint.assignments(), limit[3]);
                        for (CBSAssignment assignment : assignments) {
                            this.assignmentLeafItem(out, assignment, clickable);
                        }
                        this.end_item(out);
                    }
                    this.end_item(out);
                }
                this.end_item(out);
            }
        } else if (type == TYPE_CONSTRAINT_BASED) {
            Hashtable<CallSite, CBSConstraint> constraints = new Hashtable<CallSite, CBSConstraint>();
            for (CBSVariable variable : this.iVariables.values()) {
                if (classId != null && classId.longValue() != variable.getId()) continue;
                for (CBSValue value : variable.values()) {
                    for (CBSConstraint constraint : value.constraints()) {
                        CBSConstraint xConstraint = (CBSConstraint)constraints.get(constraint.getType() + "." + constraint.getId());
                        if (xConstraint == null) {
                            xConstraint = new CBSConstraint(constraint.getType(), constraint.getId(), constraint.getName(), constraint.getPref());
                            constraints.put((CallSite)((Object)(constraint.getType() + "." + constraint.getId())), xConstraint);
                        }
                        CBSVariable xVariable = null;
                        for (CBSVariable v : xConstraint.variables()) {
                            if (v.getId() != variable.getId()) continue;
                            xVariable = v;
                            break;
                        }
                        if (xVariable == null) {
                            xVariable = new CBSVariable(xConstraint, variable.getId(), variable.getName(), variable.getPref());
                            xConstraint.variables().add(xVariable);
                        }
                        CBSValue xValue = new CBSValue(xVariable, value.getInstructorName(), value.getRoomNames(), value.getDayCode(), value.getStartSlot(), value.getRoomIds(), value.getTimePref(), value.getRoomPrefs(), value.getLength(), value.getDatePatternName(), value.getPatternId(), value.getBreakTime(), value.getDatePatternId());
                        xVariable.values().add(xValue);
                        for (CBSAssignment assignment : constraint.assignments()) {
                            xValue.assignments().add(assignment);
                            xValue.incCounter(assignment.getCounter());
                        }
                    }
                }
            }
            List<CBSConstraint> consts = ConflictStatisticsInfo.filter(constraints.values(), limit[0]);
            for (CBSConstraint constraint : consts) {
                String m1 = constraint.getType() + "." + constraint.getId();
                this.constraintMenuItem(out, m1, constraint, clickable);
                List<CBSVariable> variables = ConflictStatisticsInfo.filter(constraint.variables(), limit[1]);
                Collections.sort(variables);
                for (CBSVariable variable : variables) {
                    String m2 = m1 + "." + variable.getId();
                    if (classId == null) {
                        this.unassignedVariableMenuItem(out, m2, variable, clickable);
                    }
                    List<CBSValue> vals = ConflictStatisticsInfo.filter(variable.values(), limit[2]);
                    int id = 0;
                    for (CBSValue value : vals) {
                        String m3 = m2 + "." + id++;
                        this.unassignmentMenuItem(out, m3, value, clickable);
                        List<CBSAssignment> assignments = ConflictStatisticsInfo.filter(value.assignments(), limit[3]);
                        for (CBSAssignment assignment : assignments) {
                            this.assignmentLeafItem(out, assignment, clickable);
                        }
                        this.end_item(out);
                    }
                    if (classId != null) continue;
                    this.end_item(out);
                }
                this.end_item(out);
            }
        }
        out.flush();
    }

    @Override
    public boolean saveToFile() {
        return ApplicationProperty.ConflictStatisticsSaveToFile.isTrue();
    }

    public static Collection<CBSConstraint> transpose(Collection<CBSVariable> variables, Long classId) {
        HashMap<CallSite, CBSConstraint> constraints = new HashMap<CallSite, CBSConstraint>();
        for (CBSVariable variable : variables) {
            if (classId != null && !classId.equals(variable.getId())) continue;
            for (CBSValue value : variable.values()) {
                for (CBSConstraint constraint : value.constraints()) {
                    CBSConstraint xConstraint = (CBSConstraint)constraints.get(constraint.getType() + "." + constraint.getId());
                    if (xConstraint == null) {
                        xConstraint = new CBSConstraint(constraint.getType(), constraint.getId(), constraint.getName(), constraint.getPref());
                        constraints.put((CallSite)((Object)(constraint.getType() + "." + constraint.getId())), xConstraint);
                    }
                    CBSVariable xVariable = null;
                    for (CBSVariable v : xConstraint.variables()) {
                        if (v.getId() != variable.getId()) continue;
                        xVariable = v;
                        break;
                    }
                    if (xVariable == null) {
                        xVariable = new CBSVariable(xConstraint, variable.getId(), variable.getName(), variable.getPref());
                        xConstraint.variables().add(xVariable);
                    }
                    CBSValue xValue = new CBSValue(xVariable, value.getInstructorName(), value.getRoomNames(), value.getDayCode(), value.getStartSlot(), value.getRoomIds(), value.getTimePref(), value.getRoomPrefs(), value.getLength(), value.getDatePatternName(), value.getPatternId(), value.getBreakTime(), value.getDatePatternId());
                    xVariable.values().add(xValue);
                    for (CBSAssignment assignment : constraint.assignments()) {
                        xValue.assignments().add(assignment);
                        xValue.incCounter(assignment.getCounter());
                    }
                }
            }
        }
        return constraints.values();
    }

    public static class CBSVariable
    implements Counter,
    Serializable {
        private static final long serialVersionUID = 1L;
        int iCounter = 0;
        long iClassId;
        String iName;
        Set<CBSValue> iValues = new HashSet<CBSValue>();
        CBSConstraint iConstraint = null;
        String iPref = null;

        CBSVariable(long classId, String name, String pref) {
            this.iClassId = classId;
            this.iName = name;
            this.iPref = pref;
        }

        CBSVariable(CBSConstraint constraint, long classId, String name, String pref) {
            this.iConstraint = constraint;
            this.iClassId = classId;
            this.iName = name;
            this.iPref = pref;
        }

        CBSVariable(Element element) {
            this.iClassId = Long.parseLong(element.attributeValue("class"));
            this.iName = element.attributeValue("name");
            this.iPref = element.attributeValue("pref");
            Iterator i = element.elementIterator("val");
            while (i.hasNext()) {
                this.iValues.add(new CBSValue(this, (Element)i.next()));
            }
        }

        public long getId() {
            return this.iClassId;
        }

        @Override
        public int getCounter() {
            return this.iCounter;
        }

        public String getName() {
            return this.iName;
        }

        public String getPref() {
            return this.iPref;
        }

        @Override
        public void incCounter(int value) {
            this.iCounter += value;
            if (this.iConstraint != null) {
                this.iConstraint.incCounter(value);
            }
        }

        public Set<CBSValue> values() {
            return this.iValues;
        }

        public int hashCode() {
            return Long.valueOf(this.iClassId).hashCode();
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof CBSVariable)) {
                return false;
            }
            return ((CBSVariable)o).getId() == this.getId();
        }

        @Override
        public int compareTo(Counter o) {
            int ret = -Integer.valueOf(this.iCounter).compareTo(o.getCounter());
            if (ret != 0) {
                return ret;
            }
            return this.toString().compareTo(o.toString());
        }

        public String toString() {
            return this.iName;
        }

        public void save(Element element) {
            element.addAttribute("class", String.valueOf(this.iClassId));
            element.addAttribute("name", this.iName);
            if (this.iPref != null) {
                element.addAttribute("pref", this.iPref);
            }
            for (CBSValue v : this.iValues) {
                v.save(element.addElement("val"));
            }
        }
    }

    public static class CBSValue
    implements Counter,
    Serializable {
        private static final long serialVersionUID = 1L;
        int iCounter = 0;
        int iDays;
        int iStartSlot;
        List<Long> iRoomIds;
        String iInstructorName = null;
        List<String> iRoomNames;
        List<Integer> iRoomPrefs;
        int iTimePref;
        CBSVariable iVariable = null;
        HashSet<CBSConstraint> iConstraints = new HashSet();
        HashSet<CBSAssignment> iAssignments = new HashSet();
        int iLength;
        int iBreakTime;
        Long iDatePatternId = null;
        String iDatePatternName = null;
        Long iPatternId = null;

        CBSValue(CBSVariable var, String instructorName, List<String> roomNames, int days, int startSlot, List<Long> roomIds, int timePref, List<Integer> roomPrefs, int length, String datePatternName, Long patternId, int breakTime, Long datePatternId) {
            this.iStartSlot = startSlot;
            this.iDays = days;
            this.iRoomIds = roomIds;
            this.iVariable = var;
            this.iInstructorName = instructorName;
            this.iRoomNames = roomNames;
            this.iTimePref = timePref;
            this.iRoomPrefs = roomPrefs;
            this.iDatePatternName = datePatternName;
            this.iLength = length;
            this.iBreakTime = breakTime;
            this.iPatternId = patternId;
            this.iDatePatternId = datePatternId;
        }

        CBSValue(CBSVariable var, Element element) {
            this.iVariable = var;
            this.iDays = Integer.parseInt(element.attributeValue("days"));
            this.iStartSlot = Integer.parseInt(element.attributeValue("slot"));
            this.iRoomIds = new ArrayList<Long>();
            this.iRoomNames = new ArrayList<String>();
            this.iRoomPrefs = new ArrayList<Integer>();
            Iterator i = element.elementIterator("room");
            while (i.hasNext()) {
                Element r = (Element)i.next();
                this.iRoomIds.add(Long.valueOf(r.attributeValue("id")));
                this.iRoomNames.add(r.attributeValue("name"));
                this.iRoomPrefs.add(Integer.valueOf(r.attributeValue("pref")));
            }
            this.iInstructorName = element.attributeValue("iName");
            this.iTimePref = Integer.parseInt(element.attributeValue("tpref"));
            this.iDatePatternName = element.attributeValue("datePattern");
            this.iLength = Integer.parseInt(element.attributeValue("length"));
            this.iBreakTime = element.attributeValue("breakTime") == null ? 0 : Integer.parseInt(element.attributeValue("breakTime"));
            this.iPatternId = Long.valueOf(element.attributeValue("pattern"));
            this.iDatePatternId = Long.valueOf(element.attributeValue("datePatternId"));
            i = element.elementIterator("cons");
            while (i.hasNext()) {
                this.iConstraints.add(new CBSConstraint(this, (Element)i.next()));
            }
        }

        public CBSVariable variable() {
            return this.iVariable;
        }

        public int getDayCode() {
            return this.iDays;
        }

        public String getDays() {
            StringBuffer ret = new StringBuffer();
            for (int i = 0; i < Constants.DAY_NAMES_SHORT.length; ++i) {
                if ((Constants.DAY_CODES[i] & this.iDays) == 0) continue;
                ret.append(Constants.DAY_NAMES_SHORT[i]);
            }
            return ret.toString();
        }

        public int getStartSlot() {
            return this.iStartSlot;
        }

        public String getStartTime() {
            return Constants.toTime(this.iStartSlot * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN);
        }

        public String getEndTime() {
            return Constants.toTime((this.iStartSlot + this.iLength) * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN - this.iBreakTime);
        }

        public int getLength() {
            return this.iLength;
        }

        public int getBreakTime() {
            return this.iBreakTime;
        }

        public String getDatePatternName() {
            return this.iDatePatternName;
        }

        public Long getDatePatternId() {
            return this.iDatePatternId;
        }

        public List<String> getRoomNames() {
            return this.iRoomNames;
        }

        public String getInstructorName() {
            return this.iInstructorName;
        }

        public int getTimePref() {
            return this.iTimePref;
        }

        public List<Integer> getRoomPrefs() {
            return this.iRoomPrefs;
        }

        public String toString() {
            return this.getDays() + " " + this.getStartTime() + " " + this.iRoomNames + (String)(this.iInstructorName == null ? "" : " " + this.iInstructorName);
        }

        @Override
        public int getCounter() {
            return this.iCounter;
        }

        @Override
        public void incCounter(int value) {
            this.iCounter += value;
            if (this.iVariable != null) {
                this.iVariable.incCounter(value);
            }
        }

        public List<Long> getRoomIds() {
            return this.iRoomIds;
        }

        public Set<CBSConstraint> constraints() {
            return this.iConstraints;
        }

        public Set<CBSAssignment> assignments() {
            return this.iAssignments;
        }

        public int hashCode() {
            return ConflictStatisticsInfo.combine(ConflictStatisticsInfo.combine(this.iRoomIds == null ? 0 : this.iRoomIds.hashCode(), ConflictStatisticsInfo.combine(this.iStartSlot, this.iDays)), ConflictStatisticsInfo.combine(this.iPatternId == null ? 0 : this.iPatternId.intValue(), this.iDatePatternId == null ? 0 : this.iDatePatternId.intValue()));
        }

        public Long getPatternId() {
            return this.iPatternId;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof CBSValue)) {
                return false;
            }
            CBSValue v = (CBSValue)o;
            return v.getRoomIds().equals(this.getRoomIds()) && v.getDayCode() == this.getDayCode() && v.getStartSlot() == this.getStartSlot() && v.getPatternId().equals(this.getPatternId()) && v.getDatePatternId().equals(this.getDatePatternId());
        }

        @Override
        public int compareTo(Counter o) {
            int ret = -Integer.valueOf(this.iCounter).compareTo(o.getCounter());
            if (ret != 0) {
                return ret;
            }
            return this.toString().compareTo(o.toString());
        }

        public void save(Element element) {
            element.addAttribute("days", String.valueOf(this.iDays));
            element.addAttribute("slot", String.valueOf(this.iStartSlot));
            element.addAttribute("datePattern", this.getDatePatternName());
            element.addAttribute("length", String.valueOf(this.iLength));
            element.addAttribute("breakTime", String.valueOf(this.iBreakTime));
            if (this.iPatternId != null) {
                element.addAttribute("pattern", this.iPatternId.toString());
            }
            for (int i = 0; i < this.iRoomIds.size(); ++i) {
                Element r = element.addElement("room");
                r.addAttribute("id", this.iRoomIds.get(i).toString());
                r.addAttribute("name", this.iRoomNames.get(i).toString());
                r.addAttribute("pref", this.iRoomPrefs.get(i).toString());
            }
            if (this.iInstructorName != null) {
                element.addAttribute("iName", this.iInstructorName);
            }
            element.addAttribute("tpref", String.valueOf(this.iTimePref));
            Iterator<CBSConstraint> i = this.iConstraints.iterator();
            while (i.hasNext()) {
                i.next().save(element.addElement("cons"));
            }
            element.addAttribute("datePatternId", String.valueOf(this.iDatePatternId));
        }
    }

    public static class CBSConstraint
    implements Counter,
    Serializable {
        private static final long serialVersionUID = 1L;
        CBSValue iValue;
        int iCounter = 0;
        long iId;
        String iName = null;
        int iType;
        HashSet<CBSAssignment> iAssignments = new HashSet();
        HashSet<CBSVariable> iVariables = new HashSet();
        String iPref;

        CBSConstraint(int type, long id, String name, String pref) {
            this.iId = id;
            this.iType = type;
            this.iName = name;
            this.iPref = pref;
        }

        CBSConstraint(CBSValue value, int type, long id, String name, String pref) {
            this.iId = id;
            this.iType = type;
            this.iValue = value;
            this.iName = name;
            this.iPref = pref;
        }

        CBSConstraint(CBSValue value, Element element) {
            this.iValue = value;
            this.iId = Integer.parseInt(element.attributeValue("id"));
            this.iType = Integer.parseInt(element.attributeValue("type"));
            this.iName = element.attributeValue("name");
            this.iPref = element.attributeValue("pref");
            Iterator i = element.elementIterator("nogood");
            while (i.hasNext()) {
                this.iAssignments.add(new CBSAssignment(this, (Element)i.next()));
            }
        }

        public long getId() {
            return this.iId;
        }

        public int getType() {
            return this.iType;
        }

        public String getName() {
            return this.iName;
        }

        public CBSValue value() {
            return this.iValue;
        }

        public Set<CBSVariable> variables() {
            return this.iVariables;
        }

        public Set<CBSAssignment> assignments() {
            return this.iAssignments;
        }

        public String getPref() {
            return this.iPref;
        }

        @Override
        public int getCounter() {
            return this.iCounter;
        }

        @Override
        public void incCounter(int value) {
            this.iCounter += value;
            if (this.iValue != null) {
                this.iValue.incCounter(value);
            }
        }

        public int hashCode() {
            return ConflictStatisticsInfo.combine((int)this.iId, this.iType);
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof CBSConstraint)) {
                return false;
            }
            CBSConstraint c = (CBSConstraint)o;
            return c.getId() == this.getId() && c.getType() == this.getType();
        }

        @Override
        public int compareTo(Counter o) {
            int ret = -Integer.valueOf(this.iCounter).compareTo(o.getCounter());
            if (ret != 0) {
                return ret;
            }
            return this.toString().compareTo(o.toString());
        }

        public void save(Element element) {
            element.addAttribute("id", String.valueOf(this.iId));
            element.addAttribute("type", String.valueOf(this.iType));
            if (this.iName != null) {
                element.addAttribute("name", this.iName);
            }
            if (this.iPref != null) {
                element.addAttribute("pref", this.iPref);
            }
            Iterator<CBSAssignment> i = this.iAssignments.iterator();
            while (i.hasNext()) {
                i.next().save(element.addElement("nogood"));
            }
        }
    }

    public static class CBSAssignment
    implements Counter,
    Serializable {
        private static final long serialVersionUID = 1L;
        CBSConstraint iConstraint;
        long iClassId;
        int iDays;
        int iStartSlot;
        List<Long> iRoomIds;
        int iCounter = 0;
        String iVarName;
        String iInstructorName;
        String iPref;
        int iTimePref;
        List<Integer> iRoomPrefs;
        List<String> iRoomNames;
        int iLength;
        int iBreakTime;
        String iDatePatternName = null;
        Long iPatternId;
        Long iDatePatternId;

        CBSAssignment(CBSConstraint constraint, long classId, String varName, String instructorName, List roomNames, int days, int startSlot, List roomIds, String pref, int timePref, List roomPrefs, int length, String datePatternName, Long patternId, int breakTime, Long datePatternId) {
            this.iClassId = classId;
            this.iStartSlot = startSlot;
            this.iDays = days;
            this.iRoomIds = roomIds;
            this.iConstraint = constraint;
            this.iVarName = varName;
            this.iInstructorName = instructorName;
            this.iRoomNames = roomNames;
            this.iPref = pref;
            this.iTimePref = timePref;
            this.iRoomPrefs = roomPrefs;
            this.iDatePatternName = datePatternName;
            this.iLength = length;
            this.iPatternId = patternId;
            this.iBreakTime = breakTime;
            this.iDatePatternId = datePatternId;
        }

        CBSAssignment(CBSConstraint constraint, Element element) {
            this.iConstraint = constraint;
            this.iClassId = Long.parseLong(element.attributeValue("class"));
            this.iStartSlot = Integer.parseInt(element.attributeValue("slot"));
            this.iDays = Integer.parseInt(element.attributeValue("days"));
            this.iRoomIds = new ArrayList<Long>();
            this.iRoomNames = new ArrayList<String>();
            this.iRoomPrefs = new ArrayList<Integer>();
            Iterator i = element.elementIterator("room");
            while (i.hasNext()) {
                Element r = (Element)i.next();
                this.iRoomIds.add(Long.valueOf(r.attributeValue("id")));
                this.iRoomNames.add(r.attributeValue("name"));
                this.iRoomPrefs.add(Integer.valueOf(r.attributeValue("pref")));
            }
            this.iVarName = element.attributeValue("varName");
            this.iInstructorName = element.attributeValue("iName");
            this.iPref = element.attributeValue("pref");
            this.iTimePref = Integer.parseInt(element.attributeValue("tpref"));
            this.iDatePatternName = element.attributeValue("datePattern");
            this.iLength = Integer.parseInt(element.attributeValue("length"));
            this.iBreakTime = element.attributeValue("breakTime") == null ? 0 : Integer.parseInt(element.attributeValue("breakTime"));
            this.iPatternId = element.attributeValue("pattern") == null ? null : Long.valueOf(element.attributeValue("pattern"));
            this.iDatePatternId = element.attributeValue("datePatternId") == null ? null : Long.valueOf(element.attributeValue("datePatternId"));
            this.incCounter(Integer.parseInt(element.attributeValue("cnt")));
        }

        public long getId() {
            return this.iClassId;
        }

        public CBSConstraint getConstraint() {
            return this.iConstraint;
        }

        public int getDayCode() {
            return this.iDays;
        }

        public String getDays() {
            StringBuffer ret = new StringBuffer();
            for (int i = 0; i < Constants.DAY_NAMES_SHORT.length; ++i) {
                if ((Constants.DAY_CODES[i] & this.iDays) == 0) continue;
                ret.append(Constants.DAY_NAMES_SHORT[i]);
            }
            return ret.toString();
        }

        public int getStartSlot() {
            return this.iStartSlot;
        }

        public String getStartTime() {
            return Constants.toTime(this.iStartSlot * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN);
        }

        public String getEndTime() {
            return Constants.toTime((this.iStartSlot + this.iLength) * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN - this.iBreakTime);
        }

        public Long getPatternId() {
            return this.iPatternId;
        }

        public String toString() {
            return this.iVarName + " " + this.getDays() + " " + this.getStartTime() + " " + this.iRoomNames + (String)(this.iInstructorName == null ? "" : " " + this.iInstructorName);
        }

        public String getVariableName() {
            return this.iVarName;
        }

        public List<String> getRoomNames() {
            return this.iRoomNames;
        }

        public String getInstructorName() {
            return this.iInstructorName;
        }

        public List<Long> getRoomIds() {
            return this.iRoomIds;
        }

        public String getPref() {
            return this.iPref;
        }

        public int getTimePref() {
            return this.iTimePref;
        }

        public List getRoomPrefs() {
            return this.iRoomPrefs;
        }

        public int getLength() {
            return this.iLength;
        }

        public int getBreakTime() {
            return this.iBreakTime;
        }

        public String getDatePatternName() {
            return this.iDatePatternName;
        }

        public Long getDatePatternId() {
            return this.iDatePatternId;
        }

        public int hashCode() {
            return ConflictStatisticsInfo.combine(ConflictStatisticsInfo.combine((int)this.iClassId, ConflictStatisticsInfo.combine(this.iRoomIds.hashCode(), ConflictStatisticsInfo.combine(this.iStartSlot, this.iDays))), ConflictStatisticsInfo.combine(this.iPatternId == null ? 0 : this.iPatternId.intValue(), this.iDatePatternId == null ? 0 : this.iDatePatternId.intValue()));
        }

        @Override
        public int getCounter() {
            return this.iCounter;
        }

        @Override
        public void incCounter(int value) {
            this.iCounter += value;
            if (this.iConstraint != null) {
                this.iConstraint.incCounter(value);
            }
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof CBSAssignment)) {
                return false;
            }
            CBSAssignment a = (CBSAssignment)o;
            return a.getId() == this.getId() && a.getRoomIds().equals(this.getRoomIds()) && a.getDayCode() == this.getDayCode() && a.getStartSlot() == this.getStartSlot() && a.getPatternId().equals(this.getPatternId()) && a.getDatePatternId().equals(this.getDatePatternId());
        }

        @Override
        public int compareTo(Counter o) {
            int ret = -Integer.valueOf(this.iCounter).compareTo(o.getCounter());
            if (ret != 0) {
                return ret;
            }
            return this.toString().compareTo(o.toString());
        }

        public void save(Element element) {
            element.addAttribute("class", String.valueOf(this.iClassId));
            for (int i = 0; i < this.iRoomIds.size(); ++i) {
                Element r = element.addElement("room");
                r.addAttribute("id", this.iRoomIds.get(i).toString());
                r.addAttribute("name", this.iRoomNames.get(i).toString());
                r.addAttribute("pref", this.iRoomPrefs.get(i).toString());
            }
            element.addAttribute("datePattern", this.iDatePatternName);
            element.addAttribute("length", String.valueOf(this.iLength));
            element.addAttribute("breakTime", String.valueOf(this.iBreakTime));
            element.addAttribute("days", String.valueOf(this.iDays));
            element.addAttribute("slot", String.valueOf(this.iStartSlot));
            element.addAttribute("varName", this.iVarName);
            element.addAttribute("pattern", this.iPatternId.toString());
            element.addAttribute("datePatternId", this.iDatePatternId.toString());
            if (this.iInstructorName != null) {
                element.addAttribute("iName", this.iInstructorName);
            }
            element.addAttribute("cnt", String.valueOf(this.iCounter));
            if (this.iPref != null) {
                element.addAttribute("pref", this.iPref);
            }
            element.addAttribute("tpref", String.valueOf(this.iTimePref));
        }
    }

    public static interface Counter
    extends Comparable<Counter> {
        public int getCounter();

        public void incCounter(int var1);
    }
}

