/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.jgroups;

import java.io.File;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.appender.rolling.TimeBasedTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.TriggeringPolicy;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.cpsolver.ifs.util.DataProperties;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.JChannel;
import org.jgroups.MergeView;
import org.jgroups.Message;
import org.jgroups.SuspectedException;
import org.jgroups.View;
import org.jgroups.blocks.RequestOptions;
import org.jgroups.blocks.ResponseMode;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.fork.ForkChannel;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Rsp;
import org.jgroups.util.RspList;
import org.unitime.commons.hibernate.util.HibernateUtil;
import org.unitime.commons.jgroups.JGroupsUtils;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.interfaces.RoomAvailabilityInterface;
import org.unitime.timetable.model.ApplicationConfig;
import org.unitime.timetable.model.SolverParameterGroup;
import org.unitime.timetable.model.StudentSectioningPref;
import org.unitime.timetable.onlinesectioning.AcademicSessionInfo;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.model.XClassEnrollment;
import org.unitime.timetable.solver.SolverProxy;
import org.unitime.timetable.solver.exam.ExamSolverProxy;
import org.unitime.timetable.solver.instructor.InstructorSchedulingProxy;
import org.unitime.timetable.solver.jgroups.AbstractSolverServer;
import org.unitime.timetable.solver.jgroups.CourseSolverContainerRemote;
import org.unitime.timetable.solver.jgroups.ExaminationSolverContainerRemote;
import org.unitime.timetable.solver.jgroups.InstructorSchedulingContainerRemote;
import org.unitime.timetable.solver.jgroups.OnlineStudentSchedulingContainerRemote;
import org.unitime.timetable.solver.jgroups.OnlineStudentSchedulingGenericUpdater;
import org.unitime.timetable.solver.jgroups.RemoteRoomAvailability;
import org.unitime.timetable.solver.jgroups.RemoteSolverContainer;
import org.unitime.timetable.solver.jgroups.SolverContainer;
import org.unitime.timetable.solver.jgroups.SolverServer;
import org.unitime.timetable.solver.jgroups.StudentSolverContainerRemote;
import org.unitime.timetable.solver.jgroups.UniTimeRpcDispatcher;
import org.unitime.timetable.solver.service.SolverServerService;
import org.unitime.timetable.solver.studentsct.StudentSolverProxy;
import org.unitime.timetable.spring.SpringApplicationContextHolder;
import org.unitime.timetable.util.MessageLogAppender;
import org.unitime.timetable.util.queue.QueueProcessor;
import org.unitime.timetable.util.queue.RemoteQueueProcessor;

public class SolverServerImplementation
extends AbstractSolverServer {
    private static Log sLog = LogFactory.getLog(SolverServerImplementation.class);
    private static SolverServerImplementation sInstance = null;
    public static final RequestOptions sFirstResponse = new RequestOptions(ResponseMode.GET_FIRST, (long)ApplicationProperty.SolverClusterTimeout.intValue().intValue()).setFlags(new Message.Flag[]{Message.Flag.DONT_BUNDLE, Message.Flag.OOB});
    public static final RequestOptions sAllResponses = new RequestOptions(ResponseMode.GET_ALL, (long)ApplicationProperty.SolverClusterTimeout.intValue().intValue()).setFlags(new Message.Flag[]{Message.Flag.DONT_BUNDLE, Message.Flag.OOB});
    private JChannel iChannel;
    private ForkChannel iServerChannel;
    private RpcDispatcher iDispatcher;
    private CourseSolverContainerRemote iCourseSolverContainer;
    private ExaminationSolverContainerRemote iExamSolverContainer;
    private StudentSolverContainerRemote iStudentSolverContainer;
    private InstructorSchedulingContainerRemote iInstructorSchedulingContainer;
    private OnlineStudentSchedulingContainerRemote iOnlineStudentSchedulingContainer;
    private RemoteRoomAvailability iRemoteRoomAvailability;
    private OnlineStudentSchedulingGenericUpdater iUpdater;
    private RemoteQueueProcessor iRemoteQueueProcessor;
    protected boolean iLocal = false;

    public SolverServerImplementation(boolean local, JChannel channel) throws Exception {
        this.iLocal = local;
        this.iChannel = channel;
        this.iServerChannel = new ForkChannel(channel, String.valueOf(0), "fork-0", new Protocol[0]);
        this.iDispatcher = new UniTimeRpcDispatcher(this.iChannel, this){

            protected Object handleUpEvent(Event evt) throws Exception {
                Object ret = super.handleUpEvent(evt);
                switch (evt.getType()) {
                    case 6: {
                        View view = (View)evt.getArg();
                        sLog.info((Object)("viewAccepted(" + view + ")"));
                        if (SolverServerImplementation.this.iUpdater != null) {
                            SolverServerImplementation.this.iUpdater.viewChanged();
                        }
                        if (!(view instanceof MergeView)) break;
                        Thread t = new Thread(){

                            @Override
                            public void run() {
                                SolverServerImplementation.this.reset(ApplicationProperty.OnlineSchedulingReloadAfterMerge.isTrue());
                            }
                        };
                        t.setDaemon(true);
                        t.setName("SolverServer:Reset");
                        t.start();
                    }
                }
                return ret;
            }
        };
        this.iCourseSolverContainer = new CourseSolverContainerRemote(channel, 1, local);
        this.iExamSolverContainer = new ExaminationSolverContainerRemote(channel, 2);
        this.iStudentSolverContainer = new StudentSolverContainerRemote(channel, 3);
        this.iInstructorSchedulingContainer = new InstructorSchedulingContainerRemote(channel, 6);
        this.iOnlineStudentSchedulingContainer = new OnlineStudentSchedulingContainerRemote(channel, 5);
        this.iRemoteRoomAvailability = new RemoteRoomAvailability(channel, 4);
        this.iUpdater = new OnlineStudentSchedulingGenericUpdater(this.iDispatcher, this.iOnlineStudentSchedulingContainer);
        this.iRemoteQueueProcessor = new RemoteQueueProcessor(channel, 7);
    }

    public JChannel getChannel() {
        return this.iChannel;
    }

    public RpcDispatcher getDispatcher() {
        return this.iDispatcher;
    }

    @Override
    public void start() throws Exception {
        this.iServerChannel.connect("UniTime:RPC:Server");
        this.iCourseSolverContainer.start();
        this.iExamSolverContainer.start();
        this.iStudentSolverContainer.start();
        this.iInstructorSchedulingContainer.start();
        this.iOnlineStudentSchedulingContainer.start();
        this.iUpdater.start();
        this.iRemoteRoomAvailability.start();
        this.iRemoteQueueProcessor.start();
        super.start();
    }

    @Override
    public void stop() throws Exception {
        super.stop();
        this.iServerChannel.disconnect();
        this.iCourseSolverContainer.stop();
        this.iExamSolverContainer.stop();
        this.iStudentSolverContainer.stop();
        this.iInstructorSchedulingContainer.stop();
        this.iOnlineStudentSchedulingContainer.stop();
        this.iUpdater.stopUpdating();
        this.iRemoteRoomAvailability.stop();
    }

    @Override
    public boolean isLocal() {
        return this.iLocal;
    }

    @Override
    public Address getAddress() {
        return this.iChannel.getAddress();
    }

    @Override
    public Address getLocalAddress() {
        if (this.isLocal()) {
            return this.getAddress();
        }
        try {
            RspList ret = this.iDispatcher.callRemoteMethods(null, "isLocal", new Object[0], new Class[0], sAllResponses);
            for (Map.Entry entry : ret.entrySet()) {
                Address sender = (Address)entry.getKey();
                Rsp local = (Rsp)entry.getValue();
                if (!Boolean.TRUE.equals(local.getValue())) continue;
                return sender;
            }
            return null;
        }
        catch (Exception e) {
            sLog.error((Object)("Failed to retrieve local address: " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    @Override
    public boolean isLocalCoordinator() {
        if (!this.isLocal()) {
            return false;
        }
        try {
            int myIndex = this.iChannel.getView().getMembers().indexOf(this.iChannel.getAddress());
            RspList ret = this.iDispatcher.callRemoteMethods(null, "isLocal", new Object[0], new Class[0], sAllResponses);
            for (Map.Entry entry : ret.entrySet()) {
                int idx;
                Address sender = (Address)entry.getKey();
                Rsp local = (Rsp)entry.getValue();
                if (!Boolean.TRUE.equals(local.getValue()) || (idx = this.iChannel.getView().getMembers().indexOf(sender)) >= myIndex) continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            sLog.error((Object)("Failed to retrieve local address: " + e.getMessage()), (Throwable)e);
            return false;
        }
    }

    @Override
    public String getHost() {
        return this.iChannel.getAddressAsString();
    }

    @Override
    public int getUsage() {
        int ret = super.getUsage();
        ret += this.iCourseSolverContainer.getUsage();
        ret += this.iExamSolverContainer.getUsage();
        ret += this.iStudentSolverContainer.getUsage();
        ret += this.iInstructorSchedulingContainer.getUsage();
        return ret += this.iOnlineStudentSchedulingContainer.getUsage();
    }

    @Override
    public List<SolverServer> getServers(boolean onlyAvailable) {
        ArrayList<SolverServer> servers = new ArrayList<SolverServer>();
        if (!onlyAvailable || this.isActive()) {
            servers.add(this);
        }
        for (Address address : this.iChannel.getView().getMembers()) {
            if (address.equals(this.iChannel.getAddress())) continue;
            SolverServer server = this.crateServerProxy(address);
            if (onlyAvailable && !server.isAvailable()) continue;
            servers.add(server);
        }
        return servers;
    }

    @Override
    public SolverServer crateServerProxy(Address address) {
        ServerInvocationHandler handler = new ServerInvocationHandler(address);
        SolverServer px = (SolverServer)Proxy.newProxyInstance(SolverServerImplementation.class.getClassLoader(), new Class[]{SolverServer.class}, (InvocationHandler)handler);
        return px;
    }

    @Override
    public SolverContainer<SolverProxy> getCourseSolverContainer() {
        return this.iCourseSolverContainer;
    }

    public SolverContainer<SolverProxy> createCourseSolverContainerProxy(Address address) {
        ContainerInvocationHandler handler = new ContainerInvocationHandler(this, address, (RemoteSolverContainer)this.iCourseSolverContainer);
        SolverContainer px = (SolverContainer)Proxy.newProxyInstance(SolverServerImplementation.class.getClassLoader(), new Class[]{SolverContainer.class}, (InvocationHandler)handler);
        return px;
    }

    @Override
    public SolverContainer<ExamSolverProxy> getExamSolverContainer() {
        return this.iExamSolverContainer;
    }

    public SolverContainer<ExamSolverProxy> createExamSolverContainerProxy(Address address) {
        ContainerInvocationHandler handler = new ContainerInvocationHandler(this, address, (RemoteSolverContainer)this.iExamSolverContainer);
        SolverContainer px = (SolverContainer)Proxy.newProxyInstance(SolverServerImplementation.class.getClassLoader(), new Class[]{SolverContainer.class}, (InvocationHandler)handler);
        return px;
    }

    @Override
    public SolverContainer<InstructorSchedulingProxy> getInstructorSchedulingContainer() {
        return this.iInstructorSchedulingContainer;
    }

    public SolverContainer<InstructorSchedulingProxy> createInstructorSchedulingContainerProxy(Address address) {
        ContainerInvocationHandler handler = new ContainerInvocationHandler(this, address, (RemoteSolverContainer)this.iInstructorSchedulingContainer);
        SolverContainer px = (SolverContainer)Proxy.newProxyInstance(SolverServerImplementation.class.getClassLoader(), new Class[]{SolverContainer.class}, (InvocationHandler)handler);
        return px;
    }

    @Override
    public SolverContainer<StudentSolverProxy> getStudentSolverContainer() {
        return this.iStudentSolverContainer;
    }

    public SolverContainer<StudentSolverProxy> createStudentSolverContainerProxy(Address address) {
        ContainerInvocationHandler handler = new ContainerInvocationHandler(this, address, (RemoteSolverContainer)this.iStudentSolverContainer);
        SolverContainer px = (SolverContainer)Proxy.newProxyInstance(SolverServerImplementation.class.getClassLoader(), new Class[]{SolverContainer.class}, (InvocationHandler)handler);
        return px;
    }

    @Override
    public SolverContainer<OnlineSectioningServer> getOnlineStudentSchedulingContainer() {
        return this.iOnlineStudentSchedulingContainer;
    }

    public SolverContainer<OnlineSectioningServer> createOnlineStudentSchedulingContainerProxy(Address address) {
        ContainerInvocationHandler handler = new ContainerInvocationHandler(this, address, (RemoteSolverContainer)this.iOnlineStudentSchedulingContainer);
        SolverContainer px = (SolverContainer)Proxy.newProxyInstance(SolverServerImplementation.class.getClassLoader(), new Class[]{SolverContainer.class}, (InvocationHandler)handler);
        return px;
    }

    @Override
    public RoomAvailabilityInterface getRoomAvailability() {
        if (this.isLocal()) {
            return super.getRoomAvailability();
        }
        Address local = this.getLocalAddress();
        if (local != null) {
            return (RoomAvailabilityInterface)Proxy.newProxyInstance(SolverServerImplementation.class.getClassLoader(), new Class[]{RoomAvailabilityInterface.class}, (InvocationHandler)new RoomAvailabilityInvocationHandler(local, this.iRemoteRoomAvailability));
        }
        return null;
    }

    public void refreshCourseSolutionLocal(Long ... solutionIds) {
        if (this.isLocal()) {
            super.refreshCourseSolution(solutionIds);
        }
    }

    @Override
    public void refreshCourseSolution(Long ... solutionIds) {
        try {
            this.iDispatcher.callRemoteMethods(null, "refreshCourseSolutionLocal", new Object[]{solutionIds}, new Class[]{Long[].class}, sAllResponses);
        }
        catch (Exception e) {
            sLog.error((Object)("Failed to refresh solution: " + e.getMessage()), (Throwable)e);
        }
    }

    public void refreshExamSolutionLocal(Long sessionId, Long examTypeId) {
        if (this.isLocal()) {
            super.refreshExamSolution(sessionId, examTypeId);
        }
    }

    @Override
    public void refreshExamSolution(Long sessionId, Long examTypeId) {
        try {
            this.iDispatcher.callRemoteMethods(null, "refreshExamSolutionLocal", new Object[]{sessionId, examTypeId}, new Class[]{Long.class, Long.class}, sAllResponses);
        }
        catch (Exception e) {
            sLog.error((Object)("Failed to refresh solution: " + e.getMessage()), (Throwable)e);
        }
    }

    public void refreshInstructorSolutionLocal(Collection<Long> solverGroupIds) {
        if (this.isLocal()) {
            super.refreshInstructorSolution(solverGroupIds);
        }
    }

    @Override
    public void refreshInstructorSolution(Collection<Long> solverGroupIds) {
        try {
            this.iDispatcher.callRemoteMethods(null, "refreshInstructorSolutionLocal", new Object[]{solverGroupIds}, new Class[]{Collection.class}, sAllResponses);
        }
        catch (Exception e) {
            sLog.error((Object)("Failed to refresh solution: " + e.getMessage()), (Throwable)e);
        }
    }

    public Collection<XClassEnrollment> getUnavailabilitiesFromOtherSessionsLocal(AcademicSessionInfo session, String studentExternalId) {
        return this.iOnlineStudentSchedulingContainer.getUnavailabilitiesFromOtherSessions(session, studentExternalId);
    }

    @Override
    public Collection<XClassEnrollment> getUnavailabilitiesFromOtherSessions(AcademicSessionInfo session, String studentExternalId) {
        try {
            ArrayList<XClassEnrollment> unavailabilities = new ArrayList<XClassEnrollment>();
            RspList ret = this.iDispatcher.callRemoteMethods(null, "getUnavailabilitiesFromOtherSessionsLocal", new Object[]{session, studentExternalId}, new Class[]{AcademicSessionInfo.class, String.class}, sAllResponses);
            for (Rsp rsp : ret) {
                if (rsp == null || rsp.getValue() == null) continue;
                unavailabilities.addAll((Collection)rsp.getValue());
            }
            return unavailabilities;
        }
        catch (Exception e) {
            sLog.error((Object)("Failed to check for student unavailabilties from other academc sessions: " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    public float[] getCreditRangeFromOtherSessionsLocal(AcademicSessionInfo session, String studentExternalId) {
        return this.iOnlineStudentSchedulingContainer.getCreditRangeFromOtherSessions(session, studentExternalId);
    }

    @Override
    public float[] getCreditRangeFromOtherSessions(AcademicSessionInfo session, String studentExternalId) {
        try {
            float[] credits = new float[]{0.0f, 0.0f};
            RspList ret = this.iDispatcher.callRemoteMethods(null, "getCreditRangeFromOtherSessionsLocal", new Object[]{session, studentExternalId}, new Class[]{AcademicSessionInfo.class, String.class}, sAllResponses);
            for (Rsp rsp : ret) {
                if (rsp == null || rsp.getValue() == null) continue;
                float[] creds = (float[])rsp.getValue();
                credits[0] = credits[0] + creds[0];
                credits[1] = credits[1] + creds[1];
            }
            return credits;
        }
        catch (Exception e) {
            sLog.error((Object)("Failed to check for student credit from other academc sessions: " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    public void unloadSolverLocal(Integer type, String id) {
        switch (SolverParameterGroup.SolverType.values()[type]) {
            case COURSE: {
                this.getCourseSolverContainer().unloadSolver(id);
                break;
            }
            case EXAM: {
                this.getExamSolverContainer().unloadSolver(id);
                break;
            }
            case INSTRUCTOR: {
                this.getInstructorSchedulingContainer().unloadSolver(id);
                break;
            }
            case STUDENT: {
                this.getStudentSolverContainer().unloadSolver(id);
            }
        }
    }

    @Override
    public void unloadSolver(SolverParameterGroup.SolverType type, String id) {
        try {
            this.iDispatcher.callRemoteMethods(null, "unloadSolverLocal", new Object[]{type.ordinal(), id}, new Class[]{Integer.class, String.class}, sAllResponses);
        }
        catch (Exception e) {
            sLog.error((Object)("Failed to unload solver: " + e.getMessage()), (Throwable)e);
        }
    }

    @Override
    public void shutdown() {
        this.iActive = false;
        new ShutdownThread().start();
    }

    @Override
    public void reconnect() {
        this.iActive = false;
        new ReconnectThread().start();
    }

    public static SolverServer getInstance() {
        if (sInstance == null && SpringApplicationContextHolder.isInitialized()) {
            return ((SolverServerService)SpringApplicationContextHolder.getBean("solverServerService")).getLocalServer();
        }
        return sInstance;
    }

    public static void configureLogging(String logFile, Properties properties) {
        LoggerContext ctx = LoggerContext.getContext((boolean)false);
        Configuration config = ctx.getConfiguration();
        if (config.getAppender("unitime") == null && logFile != null) {
            File file = new File(logFile);
            System.out.println("Log File:" + file.getAbsolutePath());
            File logDir = file.getParentFile();
            if (logDir != null) {
                logDir.mkdirs();
            }
            TimeBasedTriggeringPolicy policy = TimeBasedTriggeringPolicy.newBuilder().build();
            PatternLayout layout = PatternLayout.newBuilder().withConfiguration(config).withPattern("%d{dd-MMM-yy HH:mm:ss.SSS} [%t] %-5p %c{2}: %m%n").build();
            RollingFileAppender appender = ((RollingFileAppender.Builder)((RollingFileAppender.Builder)((RollingFileAppender.Builder)RollingFileAppender.newBuilder().withFileName(file.getAbsolutePath()).withFilePattern((String)(logDir == null ? "" : logDir.getAbsolutePath() + File.separator) + file.getName() + ".%d{yyyy-MM-dd}").withPolicy((TriggeringPolicy)policy).setLayout((Layout)layout)).setName("unitime")).setConfiguration(config)).build();
            appender.start();
            config.addAppender((Appender)appender);
            ctx.getRootLogger().addAppender(config.getAppender("unitime"));
            config.getRootLogger().removeAppender("stdout");
            ctx.updateLoggers();
        }
        if (properties != null) {
            boolean update = false;
            for (Map.Entry<Object, Object> e : properties.entrySet()) {
                String property = (String)e.getKey();
                String value = (String)e.getValue();
                if (!property.startsWith("log4j.logger.")) continue;
                String name = property.substring("log4j.logger.".length());
                if (value.indexOf(44) < 0) {
                    Configurator.setLevel((String)name, (Level)Level.getLevel((String)value));
                    continue;
                }
                String level = value.substring(0, value.indexOf(44));
                LoggerConfig loggerConfig = config.getLoggerConfig(name);
                if (!name.equals(loggerConfig.getName())) {
                    loggerConfig = new LoggerConfig(name, loggerConfig.getLevel(), true);
                    config.addLogger(name, loggerConfig);
                }
                String appender = value.substring(value.indexOf(44) + 1);
                for (String a : appender.split(",")) {
                    loggerConfig.removeAppender(a);
                    Appender x = config.getAppender(a);
                    if (x == null) continue;
                    loggerConfig.addAppender(config.getAppender(a), Level.getLevel((String)level), null);
                    update = true;
                }
            }
            if (update) {
                ctx.updateLoggers();
            }
        }
        Logger log = LogManager.getRootLogger();
        log.info("-----------------------------------------------------------------------");
        log.info("UniTime Log File");
        log.info("");
        log.info("Created: " + new Date());
        log.info("");
        log.info("System info:");
        log.info("System:      " + System.getProperty("os.name") + " " + System.getProperty("os.version") + " " + System.getProperty("os.arch"));
        log.info("CPU:         " + System.getProperty("sun.cpu.isalist") + " endian:" + System.getProperty("sun.cpu.endian") + " encoding:" + System.getProperty("sun.io.unicode.encoding"));
        log.info("Java:        " + System.getProperty("java.vendor") + ", " + System.getProperty("java.runtime.name") + " " + System.getProperty("java.runtime.version", System.getProperty("java.version")));
        log.info("User:        " + System.getProperty("user.name"));
        log.info("Timezone:    " + System.getProperty("user.timezone"));
        log.info("Working dir: " + System.getProperty("user.dir"));
        log.info("Classpath:   " + System.getProperty("java.class.path"));
        log.info("Memory:      " + Runtime.getRuntime().maxMemory() / 1024L / 1024L + " MB");
        log.info("Cores:       " + Runtime.getRuntime().availableProcessors());
        try {
            log.info("Host:        " + InetAddress.getLocalHost().getHostName());
            log.info("Address:     " + InetAddress.getLocalHost().getHostAddress());
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        log.info("");
    }

    public static void main(String[] args) {
        try {
            if (ApplicationProperty.DataDir.value() == null) {
                ApplicationProperties.getDefaultProperties().setProperty(ApplicationProperty.DataDir.key(), ApplicationProperties.getProperty("tmtbl.solver.home", "."));
            }
            if (System.getProperty("catalina.base") == null) {
                ApplicationProperties.getDefaultProperties().setProperty("catalina.base", ApplicationProperty.DataDir.value());
            }
            SolverServerImplementation.configureLogging(ApplicationProperty.DataDir.value() + File.separator + "logs" + File.separator + "unitime.log", ApplicationProperties.getDefaultProperties());
            HibernateUtil.configureHibernate(ApplicationProperties.getProperties());
            ApplicationConfig.configureLogging();
            final MessageLogAppender appender = new MessageLogAppender();
            LoggerContext ctx = LoggerContext.getContext((boolean)false);
            Configuration config = ctx.getConfiguration();
            appender.start();
            config.addAppender((Appender)appender);
            config.getRootLogger().addAppender((Appender)appender, appender.getMinLevel(), null);
            ctx.updateLoggers();
            StudentSectioningPref.updateStudentSectioningPreferences();
            final JChannel channel = new JChannel(JGroupsUtils.getConfigurator(ApplicationProperty.SolverClusterConfiguration.value()));
            sInstance = new SolverServerImplementation(false, channel);
            channel.connect("UniTime:rpc");
            channel.getState(null, 0L);
            sInstance.start();
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    try {
                        SolverServerImplementation.sInstance.iActive = false;
                        sLog.info((Object)"Server is going down...");
                        sInstance.stop();
                        sLog.info((Object)"Disconnecting from the channel...");
                        channel.disconnect();
                        sLog.info((Object)"Closing the channel...");
                        channel.close();
                        sLog.info((Object)"Stopping message log appender...");
                        LoggerContext ctx = LoggerContext.getContext((boolean)false);
                        Configuration config = ctx.getConfiguration();
                        config.getRootLogger().removeAppender("message-log");
                        ctx.updateLoggers();
                        appender.stop();
                        sLog.info((Object)"Closing hibernate...");
                        HibernateUtil.closeHibernate();
                        sLog.info((Object)"This is the end.");
                    }
                    catch (Exception e) {
                        sLog.error((Object)("Failed to stop the server: " + e.getMessage()), (Throwable)e);
                    }
                }
            });
        }
        catch (Exception e) {
            sLog.error((Object)("Failed to start the server: " + e.getMessage()), (Throwable)e);
        }
    }

    @Override
    public boolean isCoordinator() {
        return this.iUpdater != null && this.iUpdater.isCoordinator();
    }

    @Override
    public synchronized void reset(boolean reload) {
        this.iUpdater.checkForNewServers(reload);
    }

    @Override
    public void setApplicationProperty(Long sessionId, String key, String value) {
        Properties properties;
        sLog.info((Object)("Set " + key + " to " + value + (String)(sessionId == null ? "" : " (for session " + sessionId + ")")));
        Properties properties2 = properties = sessionId == null ? ApplicationProperties.getConfigProperties() : ApplicationProperties.getSessionProperties(sessionId);
        if (properties == null) {
            return;
        }
        if (value == null) {
            properties.remove(key);
        } else {
            properties.setProperty(key, value);
        }
    }

    @Override
    public void setLoggingLevel(String name, String level) {
        sLog.info((Object)("Set logging level for " + (name == null ? "root" : name) + " to " + (level == null ? "null" : level)));
        if (level == null) {
            if (name == null || name.isEmpty()) {
                Configurator.setRootLevel((Level)Level.INFO);
            } else {
                Configurator.setLevel((String)name, (Level)null);
            }
        } else if (name == null || name.isEmpty()) {
            Configurator.setRootLevel((Level)Level.getLevel((String)level));
        } else {
            Configurator.setLevel((String)name, (Level)Level.getLevel((String)level));
        }
    }

    @Override
    public QueueProcessor getQueueProcessor() {
        Address local = this.getLocalAddress();
        if (local != null) {
            return (QueueProcessor)Proxy.newProxyInstance(SolverServerImplementation.class.getClassLoader(), new Class[]{QueueProcessor.class}, (InvocationHandler)new QueueProcessorInvocationHandler(local, this.iRemoteQueueProcessor));
        }
        return super.getQueueProcessor();
    }

    public class ServerInvocationHandler
    implements InvocationHandler {
        private Address iAddress;

        public ServerInvocationHandler(Address address) {
            this.iAddress = address;
        }

        public SolverContainer<SolverProxy> getCourseSolverContainer() {
            return SolverServerImplementation.this.createCourseSolverContainerProxy(this.iAddress);
        }

        public SolverContainer<ExamSolverProxy> getExamSolverContainer() {
            return SolverServerImplementation.this.createExamSolverContainerProxy(this.iAddress);
        }

        public SolverContainer<StudentSolverProxy> getStudentSolverContainer() {
            return SolverServerImplementation.this.createStudentSolverContainerProxy(this.iAddress);
        }

        public SolverContainer<InstructorSchedulingProxy> getInstructorSchedulingContainer() {
            return SolverServerImplementation.this.createInstructorSchedulingContainerProxy(this.iAddress);
        }

        public SolverContainer<OnlineSectioningServer> getOnlineStudentSchedulingContainer() {
            return SolverServerImplementation.this.createOnlineStudentSchedulingContainerProxy(this.iAddress);
        }

        public Address getAddress() {
            return this.iAddress;
        }

        public String getHost() {
            return this.iAddress.toString();
        }

        public boolean isActive() throws Exception {
            try {
                Boolean active = (Boolean)SolverServerImplementation.this.iDispatcher.callRemoteMethod(this.iAddress, "isActive", new Object[0], new Class[0], sFirstResponse);
                return active;
            }
            catch (SuspectedException e) {
                return false;
            }
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                return this.getClass().getMethod(method.getName(), method.getParameterTypes()).invoke((Object)this, args);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return SolverServerImplementation.this.iDispatcher.callRemoteMethod(this.iAddress, method.getName(), args, (Class[])method.getParameterTypes(), sFirstResponse);
            }
        }
    }

    public static class ContainerInvocationHandler<T extends RemoteSolverContainer>
    implements InvocationHandler {
        private Address iAddress;
        private T iContainer;
        final /* synthetic */ SolverServerImplementation this$0;

        private ContainerInvocationHandler(Address address, T container) {
            this.this$0 = this$0;
            this.iAddress = address;
            this.iContainer = container;
        }

        public Object createSolver(String user, DataProperties config) throws Throwable {
            this.iContainer.getDispatcher().callRemoteMethod(this.iAddress, "createRemoteSolver", new Object[]{user, config, this.this$0.iChannel.getAddress()}, new Class[]{String.class, DataProperties.class, Address.class}, sFirstResponse);
            return this.iContainer.createProxy(this.iAddress, user);
        }

        public Address getAddress() {
            return this.iAddress;
        }

        public String getHost() {
            return this.iAddress.toString();
        }

        public Object getSolver(String user) throws Exception {
            Boolean ret = (Boolean)this.iContainer.getDispatcher().callRemoteMethod(this.iAddress, "hasSolver", new Object[]{user}, new Class[]{String.class}, sFirstResponse);
            if (ret.booleanValue()) {
                return this.iContainer.createProxy(this.iAddress, user);
            }
            return null;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                return this.getClass().getMethod(method.getName(), method.getParameterTypes()).invoke((Object)this, args);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return this.iContainer.getDispatcher().callRemoteMethod(this.iAddress, method.getName(), args, (Class[])method.getParameterTypes(), sFirstResponse);
            }
        }
    }

    public static class RoomAvailabilityInvocationHandler
    implements InvocationHandler {
        private Address iAddress;
        private RemoteRoomAvailability iAvailability;

        private RoomAvailabilityInvocationHandler(Address address, RemoteRoomAvailability availability) {
            this.iAddress = address;
            this.iAvailability = availability;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            return this.iAvailability.dispatch(this.iAddress, method, args);
        }
    }

    private class ShutdownThread
    extends Thread {
        ShutdownThread() {
            this.setName("SolverServer:Shutdown");
        }

        @Override
        public void run() {
            try {
                try {
                    ShutdownThread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                sLog.info((Object)"Server is going down...");
                SolverServerImplementation.this.stop();
                sLog.info((Object)"Disconnecting from the channel...");
                SolverServerImplementation.this.getChannel().disconnect();
                sLog.info((Object)"This is the end.");
                System.exit(0);
            }
            catch (Exception e) {
                sLog.error((Object)("Failed to stop the server: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private class ReconnectThread
    extends Thread {
        ReconnectThread() {
            this.setName("SolverServer:Reconnect");
        }

        @Override
        public void run() {
            try {
                try {
                    ReconnectThread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                sLog.info((Object)"Reconnecting the server...");
                SolverServerImplementation.this.iActive = false;
                SolverServerImplementation.this.iUpdater.pauseUpading();
                JChannel oldChannel = SolverServerImplementation.this.iChannel;
                ForkChannel oldServerChannel = SolverServerImplementation.this.iServerChannel;
                sLog.info((Object)"Creating new channel...");
                JChannel channel = new JChannel(JGroupsUtils.getConfigurator(ApplicationProperty.SolverClusterConfiguration.value()));
                sLog.info((Object)"Connecting the new channel...");
                channel.connect("UniTime:rpc");
                ForkChannel serverChannel = new ForkChannel(channel, String.valueOf(0), "fork-0", new Protocol[0]);
                serverChannel.connect("UniTime:RPC:Server");
                sLog.info((Object)"Updating channel infromation...");
                SolverServerImplementation.this.iChannel = channel;
                SolverServerImplementation.this.iServerChannel = serverChannel;
                SolverServerImplementation.this.iDispatcher.setChannel(channel);
                SolverServerImplementation.this.iCourseSolverContainer.setChannel(channel, (short)1);
                SolverServerImplementation.this.iExamSolverContainer.setChannel(channel, (short)2);
                SolverServerImplementation.this.iStudentSolverContainer.setChannel(channel, (short)3);
                SolverServerImplementation.this.iInstructorSchedulingContainer.setChannel(channel, (short)6);
                SolverServerImplementation.this.iOnlineStudentSchedulingContainer.setChannel(channel, (short)5);
                SolverServerImplementation.this.iRemoteRoomAvailability.setChannel(channel, (short)4);
                SolverServerImplementation.this.iRemoteQueueProcessor.setChannel(channel, (short)7);
                SolverServerImplementation.this.iUpdater.resumeUpading();
                sLog.info((Object)"Disconnecting old channel...");
                oldServerChannel.disconnect();
                oldChannel.disconnect();
                SolverServerImplementation.this.iActive = true;
                sLog.info((Object)"Server reconnected.");
            }
            catch (Exception e) {
                sLog.error((Object)("Failed to reconnect the server: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public static class QueueProcessorInvocationHandler
    implements InvocationHandler {
        private Address iAddress;
        private RemoteQueueProcessor iProcessor;

        private QueueProcessorInvocationHandler(Address address, RemoteQueueProcessor processor) {
            this.iAddress = address;
            this.iProcessor = processor;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            return this.iProcessor.dispatch(this.iAddress, method, args);
        }
    }
}

