/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.jgroups;

import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.Address;
import org.jgroups.JChannel;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.fork.ForkChannel;
import org.jgroups.stack.Protocol;
import org.unitime.commons.hibernate.util.HibernateUtil;
import org.unitime.timetable.interfaces.RoomAvailabilityInterface;
import org.unitime.timetable.solver.jgroups.SolverServerImplementation;
import org.unitime.timetable.solver.jgroups.UniTimeRpcDispatcher;
import org.unitime.timetable.util.RoomAvailability;

public class RemoteRoomAvailability {
    private static Log sLog = LogFactory.getLog(RemoteRoomAvailability.class);
    private RpcDispatcher iDispatcher;
    private ForkChannel iChannel;

    public RemoteRoomAvailability(JChannel channel, short scope) throws Exception {
        this.iChannel = new ForkChannel(channel, String.valueOf(scope), "fork-" + scope, new Protocol[0]);
        this.iDispatcher = new UniTimeRpcDispatcher((JChannel)this.iChannel, this);
    }

    public void setChannel(JChannel channel, short scope) throws Exception {
        ForkChannel oldChannel = this.iChannel;
        if (channel != null) {
            this.iChannel = new ForkChannel(channel, String.valueOf(scope), "fork-" + scope, new Protocol[0]);
            this.iChannel.connect("UniTime:RPC:Remote");
            this.iDispatcher = new UniTimeRpcDispatcher((JChannel)this.iChannel, this);
        }
        if (oldChannel != null && oldChannel.isConnected()) {
            oldChannel.disconnect();
        }
    }

    public void start() throws Exception {
        this.iChannel.connect("UniTime:RPC:Availability");
    }

    public void stop() throws Exception {
        this.iChannel.disconnect();
    }

    public RpcDispatcher getDispatcher() {
        return this.iDispatcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(String method, Class[] types, Object[] args) throws Exception {
        try {
            RoomAvailabilityInterface availability = RoomAvailability.getInstance();
            if (availability == null) {
                throw new Exception("There is no room availability.");
            }
            Object object = availability.getClass().getMethod(method, types).invoke((Object)availability, args);
            return object;
        }
        finally {
            HibernateUtil.closeCurrentThreadSessions();
        }
    }

    public Object dispatch(Address address, Method method, Object[] args) throws Exception {
        try {
            return this.iDispatcher.callRemoteMethod(address, "invoke", new Object[]{method.getName(), method.getParameterTypes(), args}, new Class[]{String.class, Class[].class, Object[].class}, SolverServerImplementation.sFirstResponse);
        }
        catch (Exception e) {
            sLog.error((Object)("Excution of room availability method " + method + " failed: " + e.getMessage()), (Throwable)e);
            return null;
        }
    }
}

