/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.jgroups;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.ToolBox;
import org.jgroups.Address;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.util.Rsp;
import org.jgroups.util.RspList;
import org.unitime.commons.hibernate.util.HibernateUtil;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.solver.jgroups.OnlineStudentSchedulingContainerRemote;
import org.unitime.timetable.solver.jgroups.SolverServerImplementation;

public class OnlineStudentSchedulingGenericUpdater
extends Thread {
    private Log iLog;
    private long iSleepTimeInSeconds = 5L;
    private boolean iRun = true;
    private boolean iPause = false;
    private RpcDispatcher iDispatcher;
    private OnlineStudentSchedulingContainerRemote iContainer;
    private Long iLastViewChange = null;

    public OnlineStudentSchedulingGenericUpdater(RpcDispatcher dispatcher, OnlineStudentSchedulingContainerRemote container) {
        this.iDispatcher = dispatcher;
        this.iContainer = container;
        this.setDaemon(true);
        this.setName("Updater[generic]");
        this.iSleepTimeInSeconds = ApplicationProperty.OnlineSchedulingQueueLoadInterval.intValue().intValue();
        this.iLog = LogFactory.getLog((String)(OnlineStudentSchedulingGenericUpdater.class.getName() + ".updater[generic]"));
    }

    @Override
    public void run() {
        try {
            this.iLog.info((Object)"Generic updater started.");
            while (this.iRun) {
                try {
                    OnlineStudentSchedulingGenericUpdater.sleep(this.iSleepTimeInSeconds * 1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!this.iRun || this.iPause) continue;
                this.checkForNewServers(false);
            }
            this.iLog.info((Object)"Generic updater stopped.");
        }
        catch (Exception e) {
            this.iLog.error((Object)("Generic updater failed, " + e.getMessage()), (Throwable)e);
        }
    }

    public synchronized void pauseUpading() {
        this.iPause = true;
        this.iLog.info((Object)"Generic updater paused.");
    }

    public synchronized void resumeUpading() {
        this.interrupt();
        this.iPause = false;
        this.iLog.info((Object)"Generic updater resumed.");
    }

    public void stopUpdating() {
        this.iRun = false;
        this.interrupt();
        try {
            this.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void viewChanged() {
        this.iLastViewChange = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void checkForNewServers(boolean reload) {
        if (!this.isCoordinator()) {
            return;
        }
        if (!HibernateUtil.isConfigured()) {
            this.iLog.info((Object)"Hibernate is not configured yet, will check for new servers later...");
            return;
        }
        boolean create = this.iLastViewChange == null || System.currentTimeMillis() - this.iLastViewChange >= this.iSleepTimeInSeconds * 500L;
        try (org.hibernate.Session hibSession = SessionDAO.getInstance().getSession();){
            HashMap<String, HashSet<Address>> solvers = new HashMap<String, HashSet<Address>>();
            try {
                RspList ret = this.iContainer.getDispatcher().callRemoteMethods(null, "getSolvers", new Object[0], new Class[0], SolverServerImplementation.sAllResponses);
                for (Map.Entry entry : ret.entrySet()) {
                    Address sender = (Address)entry.getKey();
                    Rsp rsp = (Rsp)entry.getValue();
                    if (rsp.getValue() == null) continue;
                    for (String solver : (Set)rsp.getValue()) {
                        HashSet<Address> members = (HashSet<Address>)solvers.get(solver);
                        if (members == null) {
                            members = new HashSet<Address>();
                            solvers.put(solver, members);
                        }
                        members.add(sender);
                    }
                }
            }
            catch (Exception e) {
                this.iLog.error((Object)("Failed to retrieve servers: " + e.getMessage()), (Throwable)e);
                hibSession.close();
                return;
            }
            block14: for (Session session : SessionDAO.getInstance().findAll(hibSession)) {
                Address member2;
                if (solvers.containsKey(session.getUniqueId().toString())) {
                    try {
                        Address master;
                        Set members = (Set)solvers.get(session.getUniqueId().toString());
                        if (members.size() > 1) {
                            this.iLog.warn((Object)(members.size() + " members for " + session.getLabel() + " detected."));
                            master = (Address)ToolBox.random((Collection)members);
                            members.remove(master);
                            this.iLog.warn((Object)("Reloading " + master + " for " + session.getLabel() + "."));
                            this.iContainer.getDispatcher().callRemoteMethod(master, "invoke", new Object[]{"reload", session.getUniqueId().toString(), new Class[0], new Object[0]}, new Class[]{String.class, String.class, Class[].class, Object[].class}, SolverServerImplementation.sFirstResponse);
                            for (Address member2 : members) {
                                if (member2.equals(master)) continue;
                                this.iLog.warn((Object)("Unloading " + member2 + " for " + session.getLabel() + "."));
                                this.iContainer.getDispatcher().callRemoteMethod(member2, "unloadSolver", new Object[]{session.getUniqueId().toString()}, new Class[]{String.class}, SolverServerImplementation.sFirstResponse);
                            }
                            continue;
                        }
                        if (!reload || !(master = members.iterator()).hasNext()) continue;
                        Address member3 = (Address)master.next();
                        this.iLog.warn((Object)("Reloading " + member3 + " for " + session.getLabel() + "."));
                        this.iContainer.getDispatcher().callRemoteMethod(member3, "invoke", new Object[]{"reload", session.getUniqueId().toString(), new Class[0], new Object[0]}, new Class[]{String.class, String.class, Class[].class, Object[].class}, SolverServerImplementation.sFirstResponse);
                    }
                    catch (Exception e) {
                        this.iLog.error((Object)("Failed to release master locks for " + session.getLabel() + ": " + e.getMessage()), (Throwable)e);
                    }
                    continue;
                }
                if (session.getStatusType().isTestSession() || !session.getStatusType().canSectionAssistStudents() && !session.getStatusType().canOnlineSectionStudents()) continue;
                if (!create) {
                    this.iLog.info((Object)("Waiting with " + session.getLabel() + " -- too soon after a vew change, will load later."));
                    continue;
                }
                int nrSolutions = ((Number)hibSession.createQuery("select count(s) from Solution s where s.owner.session.uniqueId=:sessionId", Number.class).setParameter("sessionId", (Object)session.getUniqueId()).uniqueResult()).intValue();
                if (nrSolutions == 0) continue;
                ArrayList<Address> available = new ArrayList<Address>();
                try {
                    RspList ret = this.iDispatcher.callRemoteMethods(null, "isAvailable", new Object[0], new Class[0], SolverServerImplementation.sAllResponses);
                    member2 = ret.entrySet().iterator();
                    while (member2.hasNext()) {
                        Map.Entry entry = (Map.Entry)member2.next();
                        Address sender = (Address)entry.getKey();
                        Rsp rsp = (Rsp)entry.getValue();
                        if (!Boolean.TRUE.equals(rsp.getValue())) continue;
                        available.add(sender);
                    }
                }
                catch (Exception e) {
                    this.iLog.fatal((Object)("Unable to update session " + session.getAcademicTerm() + " " + session.getAcademicYear() + " (" + session.getAcademicInitiative() + "), reason: " + e.getMessage()), (Throwable)e);
                }
                if (available.isEmpty()) {
                    this.iLog.fatal((Object)("Unable to update session " + session.getAcademicTerm() + " " + session.getAcademicYear() + " (" + session.getAcademicInitiative() + "), reason: no server available."));
                    continue;
                }
                try {
                    HashMap<Address, Object> usages = new HashMap<Address, Object>();
                    member2 = available.iterator();
                    while (member2.hasNext()) {
                        Address address = (Address)member2.next();
                        Integer usage = (Integer)this.iDispatcher.callRemoteMethod(address, "getUsage", new Object[0], new Class[0], SolverServerImplementation.sFirstResponse);
                        usages.put(address, usage);
                    }
                    while (!usages.isEmpty()) {
                        Address bestAddress = null;
                        int bestUsage = 0;
                        for (Map.Entry entry : usages.entrySet()) {
                            if (bestAddress != null && bestUsage <= (Integer)entry.getValue()) continue;
                            bestAddress = (Address)entry.getKey();
                            bestUsage = (Integer)entry.getValue();
                        }
                        usages.remove(bestAddress);
                        this.iLog.info((Object)("Loading " + bestAddress + " for " + session.getLabel() + "."));
                        Boolean created = (Boolean)this.iContainer.getDispatcher().callRemoteMethod(bestAddress, "createRemoteSolver", new Object[]{session.getUniqueId().toString(), null, this.iDispatcher.getChannel().getAddress()}, new Class[]{String.class, DataProperties.class, Address.class}, SolverServerImplementation.sFirstResponse);
                        if (created.booleanValue()) continue block14;
                        this.iLog.info((Object)("Unable to load " + bestAddress + " for " + session.getLabel() + "."));
                    }
                }
                catch (Exception e) {
                    this.iLog.fatal((Object)("Unable to update session " + session.getAcademicTerm() + " " + session.getAcademicYear() + " (" + session.getAcademicInitiative() + "), reason: " + e.getMessage()), (Throwable)e);
                }
            }
        }
    }

    public boolean isCoordinator() {
        return ((Address)this.iDispatcher.getChannel().getView().getMembers().get(0)).equals(this.iDispatcher.getChannel().getAddress());
    }
}

