/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.jgroups;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cpsolver.ifs.util.DataProperties;
import org.jgroups.Address;
import org.jgroups.JChannel;
import org.jgroups.SuspectedException;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.fork.ForkChannel;
import org.jgroups.stack.Protocol;
import org.unitime.commons.hibernate.util.HibernateUtil;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServerContext;
import org.unitime.timetable.solver.SolverProxy;
import org.unitime.timetable.solver.jgroups.OnlineStudentSchedulingContainer;
import org.unitime.timetable.solver.jgroups.RemoteSolver;
import org.unitime.timetable.solver.jgroups.RemoteSolverContainer;
import org.unitime.timetable.solver.jgroups.SolverServerImplementation;
import org.unitime.timetable.solver.jgroups.UniTimeRpcDispatcher;

public class OnlineStudentSchedulingContainerRemote
extends OnlineStudentSchedulingContainer
implements RemoteSolverContainer<OnlineSectioningServer> {
    private static Log sLog = LogFactory.getLog(OnlineStudentSchedulingContainerRemote.class);
    private RpcDispatcher iDispatcher;
    private ForkChannel iChannel;

    public OnlineStudentSchedulingContainerRemote(JChannel channel, short scope) throws Exception {
        this.iChannel = new ForkChannel(channel, String.valueOf(scope), "fork-" + scope, new Protocol[0]);
        this.iDispatcher = new UniTimeRpcDispatcher((JChannel)this.iChannel, this);
    }

    @Override
    public void setChannel(JChannel channel, short scope) throws Exception {
        ForkChannel oldChannel = this.iChannel;
        if (channel != null) {
            this.iChannel = new ForkChannel(channel, String.valueOf(scope), "fork-" + scope, new Protocol[0]);
            this.iChannel.connect("UniTime:RPC:Online");
            this.iDispatcher = new UniTimeRpcDispatcher((JChannel)this.iChannel, this);
        }
        if (oldChannel != null && oldChannel.isConnected()) {
            oldChannel.disconnect();
        }
    }

    @Override
    public void start() throws Exception {
        this.iChannel.connect("UniTime:RPC:Online");
        super.start();
    }

    @Override
    public void stop() throws Exception {
        this.iChannel.disconnect();
        super.stop();
    }

    @Override
    public RpcDispatcher getDispatcher() {
        return this.iDispatcher;
    }

    @Override
    public boolean createRemoteSolver(String sessionId, DataProperties config, Address caller) {
        return super.createSolver(sessionId, config) != null;
    }

    @Override
    public Object invoke(String method, String sessionId, String locale, Class[] types, Object[] args) throws Exception {
        try {
            OnlineSectioningServer solver = (OnlineSectioningServer)this.iInstances.get(Long.valueOf(sessionId));
            if ("exists".equals(method) && types.length == 0) {
                Boolean bl = solver != null;
                return bl;
            }
            if (solver == null) {
                throw new Exception("Server " + sessionId + " does not exist.");
            }
            if (locale != null) {
                Localization.setLocale(locale);
            }
            Object object = solver.getClass().getMethod(method, types).invoke((Object)solver, args);
            return object;
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() != null && e.getTargetException() instanceof Exception) {
                throw (Exception)e.getTargetException();
            }
            throw e;
        }
        finally {
            HibernateUtil.closeCurrentThreadSessions();
        }
    }

    @Override
    public Object dispatch(Address address, String sessionId, Method method, Object[] args) throws Exception {
        try {
            return this.iDispatcher.callRemoteMethod(address, "invoke", new Object[]{method.getName(), sessionId, Localization.getLocale(), method.getParameterTypes(), args}, new Class[]{String.class, String.class, String.class, Class[].class, Object[].class}, SolverServerImplementation.sFirstResponse);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() != null && e.getTargetException() instanceof Exception) {
                throw (Exception)e.getTargetException();
            }
            throw e;
        }
        catch (Exception e) {
            if ("exists".equals(method.getName()) && e instanceof SuspectedException) {
                return false;
            }
            sLog.debug((Object)("Excution of " + method.getName() + " on server " + sessionId + " failed: " + e.getMessage()), (Throwable)e);
            throw e;
        }
    }

    @Override
    public OnlineSectioningServer createProxy(Address address, String user) {
        ServerInvocationHandler handler = new ServerInvocationHandler(address, user);
        OnlineSectioningServer px = (OnlineSectioningServer)Proxy.newProxyInstance(SolverProxy.class.getClassLoader(), new Class[]{OnlineSectioningServer.class, RemoteSolver.class}, (InvocationHandler)handler);
        return px;
    }

    @Override
    public OnlineSectioningServerContext getServerContext(final Long academicSessionId) {
        return new OnlineSectioningServerContext(){

            @Override
            public Long getAcademicSessionId() {
                return academicSessionId;
            }

            @Override
            public boolean isWaitTillStarted() {
                return false;
            }
        };
    }

    public class ServerInvocationHandler
    implements InvocationHandler {
        private Address iAddress;
        private String iUser;

        private ServerInvocationHandler(Address address, String user) {
            this.iAddress = address;
            this.iUser = user;
        }

        public String getHost() {
            return this.iAddress.toString();
        }

        public String getUser() {
            return this.iUser;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                return this.getClass().getMethod(method.getName(), method.getParameterTypes()).invoke((Object)this, args);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return OnlineStudentSchedulingContainerRemote.this.dispatch(this.iAddress, this.iUser, method, args);
            }
        }
    }
}

