/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.jgroups;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cpsolver.ifs.util.DataProperties;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentSectioningQueue;
import org.unitime.timetable.model.StudentSectioningStatus;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.onlinesectioning.AcademicSessionInfo;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLogger;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServerContext;
import org.unitime.timetable.onlinesectioning.model.XClassEnrollment;
import org.unitime.timetable.onlinesectioning.server.InMemoryServer;
import org.unitime.timetable.solver.jgroups.OnlineStudentSchedulingUpdater;
import org.unitime.timetable.solver.jgroups.SolverContainer;
import org.unitime.timetable.util.DateUtils;

public class OnlineStudentSchedulingContainer
implements SolverContainer<OnlineSectioningServer> {
    private static Log sLog = LogFactory.getLog(OnlineStudentSchedulingContainer.class);
    protected Hashtable<Long, OnlineSectioningServer> iInstances = new Hashtable();
    private Hashtable<Long, OnlineStudentSchedulingUpdater> iUpdaters = new Hashtable();
    private ReentrantReadWriteLock iGlobalLock = new ReentrantReadWriteLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getSolvers() {
        this.iGlobalLock.readLock().lock();
        try {
            TreeSet<String> ret = new TreeSet<String>();
            for (Map.Entry<Long, OnlineSectioningServer> entry : this.iInstances.entrySet()) {
                try {
                    ret.add(entry.getValue().getAcademicSession().getUniqueId().toString());
                }
                catch (IllegalStateException e) {
                    sLog.error((Object)("Server " + entry.getKey() + " appears to be in an inconsistent state: " + e.getMessage()));
                }
            }
            TreeSet<String> treeSet = ret;
            return treeSet;
        }
        finally {
            this.iGlobalLock.readLock().unlock();
        }
    }

    @Override
    public OnlineSectioningServer getSolver(String sessionId) {
        return this.getInstance(Long.valueOf(sessionId));
    }

    @Override
    public long getMemUsage(String user) {
        OnlineSectioningServer solver = this.getSolver(user);
        return solver == null ? 0L : solver.getMemUsage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OnlineSectioningServer getInstance(Long sessionId) {
        this.iGlobalLock.readLock().lock();
        try {
            OnlineSectioningServer instance = this.iInstances.get(sessionId);
            if (instance == null) {
                OnlineSectioningServer onlineSectioningServer = null;
                return onlineSectioningServer;
            }
            try {
                instance.getAcademicSession();
            }
            catch (IllegalStateException e) {
                sLog.error((Object)("Server " + sessionId + " appears to be in an inconsistent state: " + e.getMessage()), (Throwable)e);
                OnlineSectioningServer onlineSectioningServer = null;
                this.iGlobalLock.readLock().unlock();
                return onlineSectioningServer;
            }
            OnlineSectioningServer onlineSectioningServer = instance;
            return onlineSectioningServer;
        }
        finally {
            this.iGlobalLock.readLock().unlock();
        }
    }

    @Override
    public boolean hasSolver(String sessionId) {
        this.iGlobalLock.readLock().lock();
        try {
            boolean bl = this.iInstances.containsKey(Long.valueOf(sessionId));
            return bl;
        }
        finally {
            this.iGlobalLock.readLock().unlock();
        }
    }

    @Override
    public OnlineSectioningServer createSolver(String sessionId, DataProperties config) {
        if (!this.canCreateSolver(Long.valueOf(sessionId))) {
            return null;
        }
        return this.createInstance(Long.valueOf(sessionId), config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean canCreateSolver(Long sessionId) {
        try (org.hibernate.Session hibSession = SessionDAO.getInstance().createNewSession();){
            Session session = (Session)SessionDAO.getInstance().get(sessionId, hibSession);
            if (session == null) {
                boolean bl = false;
                return bl;
            }
            String year = ApplicationProperty.OnlineSchedulingAcademicYear.value();
            if (year != null && !session.getAcademicYear().matches(year)) {
                boolean bl = false;
                return bl;
            }
            String term = ApplicationProperty.OnlineSchedulingAcademicTerm.value();
            if (term != null && !session.getAcademicTerm().matches(term)) {
                boolean bl = false;
                return bl;
            }
            String campus = ApplicationProperty.OnlineSchedulingAcademicCampus.value();
            if (campus != null && !session.getAcademicInitiative().matches(campus)) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OnlineSectioningServer createInstance(Long academicSessionId, DataProperties config) {
        this.unload(academicSessionId, true);
        this.iGlobalLock.writeLock().lock();
        try {
            ApplicationProperties.setSessionId(academicSessionId);
            String serverClassName = ApplicationProperty.OnlineSchedulingServerClass.value();
            if (serverClassName == null) {
                serverClassName = InMemoryServer.class.getName();
            }
            Class<?> serverClass = Class.forName(serverClassName);
            OnlineSectioningServer server = (OnlineSectioningServer)serverClass.getConstructor(OnlineSectioningServerContext.class).newInstance(this.getServerContext(academicSessionId));
            this.iInstances.put(academicSessionId, server);
            try (org.hibernate.Session hibSession = SessionDAO.getInstance().createNewSession();){
                OnlineStudentSchedulingUpdater updater = new OnlineStudentSchedulingUpdater(this, server.getAcademicSession(), StudentSectioningQueue.getLastTimeStamp(hibSession, academicSessionId));
                this.iUpdaters.put(academicSessionId, updater);
                updater.start();
            }
            OnlineSectioningServer onlineSectioningServer = server;
            return onlineSectioningServer;
        }
        catch (SectioningException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SectioningException(e.getMessage(), e);
        }
        finally {
            this.iGlobalLock.writeLock().unlock();
            ApplicationProperties.setSessionId(null);
        }
    }

    public OnlineSectioningServerContext getServerContext(final Long academicSessionId) {
        return new OnlineSectioningServerContext(){

            @Override
            public Long getAcademicSessionId() {
                return academicSessionId;
            }

            @Override
            public boolean isWaitTillStarted() {
                return false;
            }
        };
    }

    @Override
    public void unloadSolver(String sessionId) {
        this.unload(Long.valueOf(sessionId), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unload(Long academicSessionId, boolean interrupt) {
        this.iGlobalLock.writeLock().lock();
        try {
            OnlineSectioningServer s;
            OnlineStudentSchedulingUpdater u = this.iUpdaters.get(academicSessionId);
            if (u != null) {
                u.stopUpdating(interrupt);
            }
            if ((s = this.iInstances.get(academicSessionId)) != null) {
                sLog.info((Object)("Unloading " + u.getAcademicSession() + "..."));
                s.unload();
            }
            this.iInstances.remove(academicSessionId);
            this.iUpdaters.remove(academicSessionId);
        }
        finally {
            this.iGlobalLock.writeLock().unlock();
        }
    }

    @Override
    public int getUsage() {
        return 100 * this.iInstances.size();
    }

    @Override
    public void start() throws Exception {
        sLog.info((Object)"Student Sectioning Service is starting up ...");
        OnlineSectioningLogger.startLogger();
    }

    public boolean isEnabled() {
        if (!this.iInstances.isEmpty()) {
            return true;
        }
        String year = ApplicationProperty.OnlineSchedulingAcademicYear.value();
        String term = ApplicationProperty.OnlineSchedulingAcademicTerm.value();
        String campus = ApplicationProperty.OnlineSchedulingAcademicCampus.value();
        for (Session session : SessionDAO.getInstance().findAll()) {
            if (year != null && !session.getAcademicYear().matches(year) || term != null && !session.getAcademicTerm().matches(term) || campus != null && !session.getAcademicInitiative().matches(campus) || session.getStatusType().isTestSession() || !session.getStatusType().canSectionAssistStudents() && !session.getStatusType().canOnlineSectionStudents()) continue;
            return true;
        }
        return false;
    }

    public boolean isRegistrationEnabled() {
        for (Session session : SessionDAO.getInstance().findAll()) {
            if (session.getStatusType().isTestSession() || session.getStatusType().canOnlineSectionStudents() || session.getStatusType().canSectionAssistStudents() || !session.getStatusType().canPreRegisterStudents()) continue;
            return true;
        }
        return false;
    }

    public Collection<XClassEnrollment> getUnavailabilitiesFromOtherSessions(AcademicSessionInfo session, String studentExternalId) {
        Set<String> serverIds = this.getSolvers();
        if (serverIds == null || serverIds.isEmpty()) {
            return null;
        }
        ArrayList<XClassEnrollment> ret = new ArrayList<XClassEnrollment>();
        for (String serverId : serverIds) {
            Collection<XClassEnrollment> u;
            AcademicSessionInfo other;
            OnlineSectioningServer server = this.getSolver(serverId);
            if (server == null || !server.isReady() || session.equals(other = server.getAcademicSession()) || session.getSessionBeginDate().after(other.getSessionEndDate()) || other.getSessionBeginDate().after(session.getSessionEndDate()) || (u = server.getStudentSchedule(studentExternalId)) == null || u.isEmpty()) continue;
            int shiftDays = DateUtils.daysBetween(session.getDatePatternFirstDate(), server.getAcademicSession().getDatePatternFirstDate());
            for (XClassEnrollment e : u) {
                e.setShiftDays(shiftDays);
                ret.add(e);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float[] getCreditRangeFromOtherSessions(AcademicSessionInfo session, String studentExternalId) {
        try (org.hibernate.Session hibSession = SessionDAO.getInstance().createNewSession();){
            Set<String> serverIds = this.getSolvers();
            if (serverIds == null || serverIds.isEmpty()) {
                float[] fArray = null;
                return fArray;
            }
            float minCredit = 0.0f;
            float maxCredit = 0.0f;
            for (String serverId : serverIds) {
                StudentSectioningStatus status;
                float[] credits;
                OnlineSectioningServer server = this.getSolver(serverId);
                if (server == null || !server.isReady()) continue;
                AcademicSessionInfo other = server.getAcademicSession();
                if (!session.getYear().equals(other.getYear()) || !session.getTerm().equals(other.getTerm()) || session.getCampus().equals(other.getCampus()) || (credits = server.getCredits(studentExternalId)) == null || !(credits[0] > 0.0f)) continue;
                Student student = Student.findByExternalId(hibSession, other.getUniqueId(), studentExternalId);
                StudentSectioningStatus studentSectioningStatus = status = student == null ? null : student.getEffectiveStatus();
                if (status != null && status.hasOption(StudentSectioningStatus.Option.reqval)) {
                    minCredit += credits[0];
                    maxCredit += credits[1];
                    continue;
                }
                minCredit += credits[2];
                maxCredit += credits[2];
            }
            Object object = new float[]{minCredit, maxCredit};
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unloadAll() {
        this.iGlobalLock.writeLock().lock();
        try {
            for (OnlineStudentSchedulingUpdater u : this.iUpdaters.values()) {
                OnlineSectioningServer s;
                u.stopUpdating(true);
                if (u.getAcademicSession() == null || (s = this.iInstances.get(u.getAcademicSession().getUniqueId())) == null) continue;
                s.unload();
            }
            this.iInstances.clear();
            this.iUpdaters.clear();
        }
        finally {
            this.iGlobalLock.writeLock().unlock();
        }
    }

    @Override
    public void stop() throws Exception {
        sLog.info((Object)"Student Sectioning Service is going down ...");
        this.unloadAll();
        OnlineSectioningLogger.stopLogger();
    }
}

