/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.jgroups;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.config.Configurator;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jgroups.Address;
import org.unitime.commons.hibernate.util.HibernateUtil;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.interfaces.RoomAvailabilityInterface;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.Solution;
import org.unitime.timetable.model.TeachingRequest;
import org.unitime.timetable.model.dao._RootDAO;
import org.unitime.timetable.solver.jgroups.SolverServer;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.RoomAvailability;
import org.unitime.timetable.util.queue.LocalQueueProcessor;
import org.unitime.timetable.util.queue.QueueProcessor;

public abstract class AbstractSolverServer
implements SolverServer {
    protected static Log sLog = LogFactory.getLog(AbstractSolverServer.class);
    protected int iUsageBase = 0;
    protected Date iStartTime = new Date();
    protected boolean iActive = false;

    @Override
    public void start() throws Exception {
        this.iActive = true;
        sLog.info((Object)"Solver server is up and running.");
    }

    @Override
    public void stop() throws Exception {
        sLog.info((Object)"Solver server is going down...");
        this.iActive = false;
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    @Override
    public boolean isCoordinator() {
        return true;
    }

    @Override
    public boolean isLocalCoordinator() {
        return this.isLocal() && this.isCoordinator();
    }

    @Override
    public Address getAddress() {
        return null;
    }

    @Override
    public Address getLocalAddress() {
        return this.getAddress();
    }

    @Override
    public String getHost() {
        return "local";
    }

    @Override
    public int getUsage() {
        int ret = this.iUsageBase;
        String baseUsage = ApplicationProperty.SolverBaseUsage.value();
        if (baseUsage == null || baseUsage.isEmpty()) {
            ret += this.isLocal() ? 500 : 0;
        } else {
            try {
                ret += Integer.parseInt(baseUsage);
            }
            catch (NumberFormatException e) {
                ret += this.isLocal() ? 500 : 0;
            }
        }
        return ret;
    }

    @Override
    public void setUsageBase(int base) {
        this.iUsageBase = base;
    }

    @Override
    public long getAvailableMemory() {
        return Runtime.getRuntime().maxMemory() - Runtime.getRuntime().totalMemory() + Runtime.getRuntime().freeMemory();
    }

    @Override
    public int getAvailableProcessors() {
        return Runtime.getRuntime().availableProcessors();
    }

    @Override
    public long getMemoryLimit() {
        return 0x100000L * Long.parseLong(ApplicationProperties.getProperty(ApplicationProperty.SolverMemoryLimit));
    }

    @Override
    public String getVersion() {
        return Constants.getVersion();
    }

    @Override
    public Date getStartTime() {
        return this.iStartTime;
    }

    @Override
    public boolean isActive() {
        return this.iActive;
    }

    @Override
    public boolean isAvailable() {
        if (!this.isActive()) {
            return false;
        }
        if (this.getMemoryLimit() > this.getAvailableMemory()) {
            System.gc();
        }
        return this.getMemoryLimit() <= this.getAvailableMemory();
    }

    @Override
    public RoomAvailabilityInterface getRoomAvailability() {
        return RoomAvailability.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshCourseSolution(Long ... solutionIds) {
        try {
            for (Long solutionId : solutionIds) {
                Solution.refreshSolution(solutionId);
            }
        }
        finally {
            HibernateUtil.closeCurrentThreadSessions();
        }
    }

    @Override
    public void refreshExamSolution(Long sessionId, Long examTypeId) {
        try {
            ExamType.refreshSolution(sessionId, examTypeId);
        }
        finally {
            HibernateUtil.closeCurrentThreadSessions();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshInstructorSolution(Collection<Long> solverGroupIds) {
        try (Session hibSession = new _RootDAO().createNewSession();){
            SessionFactory hibSessionFactory = hibSession.getSessionFactory();
            List classIds = hibSession.createQuery("select distinct c.uniqueId from Class_ c inner join c.teachingRequests r where c.controllingDept.solverGroup.uniqueId in :solverGroupId and c.cancelled = false", Long.class).setParameterList("solverGroupId", solverGroupIds).list();
            for (Object classId : classIds) {
                hibSessionFactory.getCache().evictEntityData(Class_.class, classId);
                hibSessionFactory.getCache().evictCollectionData(Class_.class.getName() + ".classInstructors", classId);
            }
            List instructorIds = hibSession.createQuery("select i.uniqueId from DepartmentalInstructor i, SolverGroup g inner join g.departments d where g.uniqueId in :solverGroupId and i.department = d", Long.class).setParameterList("solverGroupId", solverGroupIds).list();
            for (Object instructorId : instructorIds) {
                hibSessionFactory.getCache().evictEntityData(DepartmentalInstructor.class, instructorId);
                hibSessionFactory.getCache().evictCollectionData(DepartmentalInstructor.class.getName() + ".classes", instructorId);
            }
            List requestIds = hibSession.createQuery("select distinct r.uniqueId from Class_ c inner join c.teachingRequests r where c.controllingDept.solverGroup.uniqueId in :solverGroupId and c.cancelled = false", Long.class).setParameterList("solverGroupId", solverGroupIds).list();
            for (Long requestId : requestIds) {
                hibSessionFactory.getCache().evictEntityData(TeachingRequest.class, (Object)requestId);
                hibSessionFactory.getCache().evictCollectionData(TeachingRequest.class.getName() + ".assignedInstructors", (Object)requestId);
            }
            List offeringIds = hibSession.createQuery("select distinct c.schedulingSubpart.instrOfferingConfig.instructionalOffering.uniqueId from Class_ c inner join c.teachingRequests r where c.controllingDept.solverGroup.uniqueId in :solverGroupId and c.cancelled = false", Long.class).setParameterList("solverGroupId", solverGroupIds).list();
            for (Long offeringId : offeringIds) {
                hibSessionFactory.getCache().evictEntityData(InstructionalOffering.class, (Object)offeringId);
                hibSessionFactory.getCache().evictCollectionData(InstructionalOffering.class.getName() + ".offeringCoordinators", (Object)offeringId);
            }
        }
    }

    @Override
    public void setApplicationProperty(Long sessionId, String key, String value) {
        Properties properties;
        sLog.info((Object)("Set " + key + " to " + value + (String)(sessionId == null ? "" : " (for session " + sessionId + ")")));
        Properties properties2 = properties = sessionId == null ? ApplicationProperties.getConfigProperties() : ApplicationProperties.getSessionProperties(sessionId);
        if (properties == null) {
            return;
        }
        if (value == null) {
            properties.remove(key);
        } else {
            properties.setProperty(key, value);
        }
    }

    @Override
    public void setLoggingLevel(String name, String level) {
        sLog.info((Object)("Set logging level for " + (name == null ? "root" : name) + " to " + (level == null ? "null" : level)));
        if (level == null) {
            if (name == null || name.isEmpty()) {
                Configurator.setRootLevel((Level)Level.INFO);
            } else {
                Configurator.setLevel((String)name, (Level)null);
            }
        } else if (name == null || name.isEmpty()) {
            Configurator.setRootLevel((Level)Level.getLevel((String)level));
        } else {
            Configurator.setLevel((String)name, (Level)Level.getLevel((String)level));
        }
    }

    @Override
    public void reset(boolean reload) {
    }

    @Override
    public QueueProcessor getQueueProcessor() {
        return LocalQueueProcessor.getInstance();
    }

    @Override
    public void reconnectHibernate() {
        this.iActive = false;
        try {
            HibernateUtil.reconnect(!this.isLocal() ? ApplicationProperties.getProperties() : null);
            this.iActive = true;
        }
        catch (Exception e) {
            sLog.error((Object)("Failed to reconnect Hibenate: " + e.getMessage()), (Throwable)e);
        }
    }
}

