/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.exam.ui;

import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import org.cpsolver.exam.criteria.StudentBackToBackConflicts;
import org.cpsolver.exam.criteria.StudentDistanceBackToBackConflicts;
import org.cpsolver.exam.model.Exam;
import org.cpsolver.exam.model.ExamDistributionConstraint;
import org.cpsolver.exam.model.ExamInstructor;
import org.cpsolver.exam.model.ExamPlacement;
import org.cpsolver.exam.model.ExamStudent;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.Variable;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.model.ClassEvent;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.DistributionObject;
import org.unitime.timetable.model.DistributionPref;
import org.unitime.timetable.model.Event;
import org.unitime.timetable.model.ExamConflict;
import org.unitime.timetable.model.ExamOwner;
import org.unitime.timetable.model.ExamPeriod;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.Meeting;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.SolverParameterDef;
import org.unitime.timetable.model.SolverParameterGroup;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.dao.ClassEventDAO;
import org.unitime.timetable.model.dao.EventDAO;
import org.unitime.timetable.model.dao.ExamDAO;
import org.unitime.timetable.model.dao.ExamPeriodDAO;
import org.unitime.timetable.solver.exam.ExamModel;
import org.unitime.timetable.solver.exam.ExamResourceUnavailability;
import org.unitime.timetable.solver.exam.ui.ExamAssignment;
import org.unitime.timetable.solver.exam.ui.ExamInfo;
import org.unitime.timetable.solver.exam.ui.ExamRoomInfo;

public class ExamAssignmentInfo
extends ExamAssignment
implements Serializable {
    private static final long serialVersionUID = 6610082675208799753L;
    private TreeSet<DirectConflict> iDirects = new TreeSet();
    private TreeSet<BackToBackConflict> iBackToBacks = new TreeSet();
    private TreeSet<MoreThanTwoADayConflict> iMoreThanTwoADays = new TreeSet();
    private TreeSet<DirectConflict> iInstructorDirects = new TreeSet();
    private TreeSet<BackToBackConflict> iInstructorBackToBacks = new TreeSet();
    private TreeSet<MoreThanTwoADayConflict> iInstructorMoreThanTwoADays = new TreeSet();
    private TreeSet<DistributionConflict> iDistributions = new TreeSet();

    public ExamAssignmentInfo(ExamPlacement placement, Assignment<Exam, ExamPlacement> assignment) {
        this((Exam)placement.variable(), placement, assignment);
    }

    public ExamAssignmentInfo(Exam exam, ExamPlacement placement, Assignment<Exam, ExamPlacement> assignment) {
        super(exam, placement, assignment);
        if (placement != null) {
            ExamModel model = (ExamModel)exam.getModel();
            Hashtable<Exam, DirectConflict> directs = new Hashtable<Exam, DirectConflict>();
            for (ExamStudent student : exam.getStudents()) {
                for (Exam other : student.getExams(assignment, placement.getPeriod())) {
                    if (other.equals((Object)exam)) continue;
                    DirectConflict dc = (DirectConflict)directs.get(other);
                    if (dc == null) {
                        dc = new DirectConflict(new ExamAssignment((ExamPlacement)assignment.getValue((Variable)other), assignment));
                        directs.put(other, dc);
                    } else {
                        dc.incNrStudents();
                    }
                    dc.getStudents().add(student.getId());
                }
            }
            for (org.cpsolver.exam.model.ExamPeriod p : model.getPeriods()) {
                if (p.equals((Object)placement.getPeriod()) || !p.hasIntersection(placement.getPeriod())) continue;
                for (ExamStudent student : exam.getStudents()) {
                    for (Exam other : student.getExams(assignment, p)) {
                        if (other.equals((Object)exam) || !placement.getPeriod().hasIntersection(exam, other, p)) continue;
                        DirectConflict dc = (DirectConflict)directs.get(other);
                        if (dc == null) {
                            dc = new DirectConflict(new ExamAssignment((ExamPlacement)assignment.getValue((Variable)other), assignment));
                            directs.put(other, dc);
                        } else {
                            dc.incNrStudents();
                        }
                        dc.getStudents().add(student.getId());
                    }
                }
            }
            this.iDirects.addAll(directs.values());
            double btbDist = ((StudentDistanceBackToBackConflicts)model.getCriterion(StudentDistanceBackToBackConflicts.class)).getBackToBackDistance();
            boolean dayBreakBackToBack = ((StudentBackToBackConflicts)model.getCriterion(StudentBackToBackConflicts.class)).isDayBreakBackToBack();
            Hashtable<Exam, BackToBackConflict> backToBacks = new Hashtable<Exam, BackToBackConflict>();
            for (Object student : exam.getStudents()) {
                Set exams;
                if (placement.getPeriod().prev() != null && (dayBreakBackToBack || placement.getPeriod().prev().getDay() == placement.getPeriod().getDay())) {
                    exams = student.getExams(assignment, placement.getPeriod().prev());
                    for (Exam other : exams) {
                        if (other.equals((Object)exam) || placement.getPeriod().hasIntersection(exam, other, placement.getPeriod().prev())) continue;
                        double distance = placement.getDistanceInMeters((ExamPlacement)assignment.getValue((Variable)other));
                        BackToBackConflict btb = (BackToBackConflict)backToBacks.get(other);
                        if (btb == null) {
                            btb = new BackToBackConflict(new ExamAssignment((ExamPlacement)assignment.getValue((Variable)other), assignment), btbDist < 0.0 ? false : distance > btbDist, distance);
                            backToBacks.put(other, btb);
                        } else {
                            btb.incNrStudents();
                        }
                        btb.getStudents().add(student.getId());
                    }
                }
                if (placement.getPeriod().next() == null || !dayBreakBackToBack && placement.getPeriod().next().getDay() != placement.getPeriod().getDay()) continue;
                exams = student.getExams(assignment, placement.getPeriod().next());
                for (Exam other : exams) {
                    if (other.equals((Object)exam) || placement.getPeriod().hasIntersection(exam, other, placement.getPeriod().next())) continue;
                    BackToBackConflict btb = (BackToBackConflict)backToBacks.get(other);
                    double distance = placement.getDistanceInMeters((ExamPlacement)assignment.getValue((Variable)other));
                    if (btb == null) {
                        btb = new BackToBackConflict(new ExamAssignment((ExamPlacement)assignment.getValue((Variable)other), assignment), btbDist < 0.0 ? false : distance > btbDist, distance);
                        backToBacks.put(other, btb);
                    } else {
                        btb.incNrStudents();
                    }
                    btb.getStudents().add(student.getId());
                }
            }
            this.iBackToBacks.addAll(backToBacks.values());
            Hashtable<String, MoreThanTwoADayConflict> m2ds = new Hashtable<String, MoreThanTwoADayConflict>();
            for (Object student : exam.getStudents()) {
                Set exams = student.getExamsADay(assignment, placement.getPeriod());
                int nrExams = exams.size() + (exams.contains(exam) ? 0 : 1);
                if (nrExams <= 2) continue;
                TreeSet<Long> examIds = new TreeSet<Long>();
                TreeSet<ExamAssignment> otherExams = new TreeSet<ExamAssignment>();
                for (Exam other : exams) {
                    if (other.equals((Object)exam)) continue;
                    examIds.add(other.getId());
                    otherExams.add(new ExamAssignment((ExamPlacement)assignment.getValue((Variable)other), assignment));
                }
                MoreThanTwoADayConflict m2d = (MoreThanTwoADayConflict)m2ds.get(examIds.toString());
                if (m2d == null) {
                    m2d = new MoreThanTwoADayConflict(otherExams);
                    m2ds.put(examIds.toString(), m2d);
                } else {
                    m2d.incNrStudents();
                }
                m2d.getStudents().add(student.getId());
            }
            this.iMoreThanTwoADays.addAll(m2ds.values());
            Hashtable<Exam, DirectConflict> idirects = new Hashtable<Exam, DirectConflict>();
            for (ExamInstructor instructor : exam.getInstructors()) {
                for (Exam other : instructor.getExams(assignment, placement.getPeriod())) {
                    if (other.equals((Object)exam)) continue;
                    DirectConflict dc = (DirectConflict)idirects.get(other);
                    if (dc == null) {
                        dc = new DirectConflict(new ExamAssignment((ExamPlacement)assignment.getValue((Variable)other), assignment));
                        idirects.put(other, dc);
                    } else {
                        dc.incNrStudents();
                    }
                    dc.getStudents().add(instructor.getId());
                }
            }
            for (Object p : model.getPeriods()) {
                if (p.equals((Object)placement.getPeriod()) || !p.hasIntersection(placement.getPeriod())) continue;
                for (ExamInstructor instructor : exam.getInstructors()) {
                    for (Exam other : instructor.getExams(assignment, (org.cpsolver.exam.model.ExamPeriod)p)) {
                        if (other.equals((Object)exam) || !placement.getPeriod().hasIntersection(exam, other, (org.cpsolver.exam.model.ExamPeriod)p)) continue;
                        DirectConflict dc = (DirectConflict)idirects.get(other);
                        if (dc == null) {
                            dc = new DirectConflict(new ExamAssignment((ExamPlacement)assignment.getValue((Variable)other), assignment));
                            idirects.put(other, dc);
                        } else {
                            dc.incNrStudents();
                        }
                        dc.getStudents().add(instructor.getId());
                    }
                }
            }
            this.iInstructorDirects.addAll(idirects.values());
            Hashtable<Exam, BackToBackConflict> ibackToBacks = new Hashtable<Exam, BackToBackConflict>();
            for (ExamInstructor instructor : exam.getInstructors()) {
                Set exams;
                if (placement.getPeriod().prev() != null && (dayBreakBackToBack || placement.getPeriod().prev().getDay() == placement.getPeriod().getDay())) {
                    exams = instructor.getExams(assignment, placement.getPeriod().prev());
                    for (Exam other : exams) {
                        if (other.equals((Object)exam) || placement.getPeriod().hasIntersection(exam, other, placement.getPeriod().prev())) continue;
                        double distance = placement.getDistanceInMeters((ExamPlacement)assignment.getValue((Variable)other));
                        BackToBackConflict btb = (BackToBackConflict)ibackToBacks.get(other);
                        if (btb == null) {
                            btb = new BackToBackConflict(new ExamAssignment((ExamPlacement)assignment.getValue((Variable)other), assignment), btbDist < 0.0 ? false : distance > btbDist, distance);
                            ibackToBacks.put(other, btb);
                        } else {
                            btb.incNrStudents();
                        }
                        btb.getStudents().add(instructor.getId());
                    }
                }
                if (placement.getPeriod().next() == null || !dayBreakBackToBack && placement.getPeriod().next().getDay() != placement.getPeriod().getDay()) continue;
                exams = instructor.getExams(assignment, placement.getPeriod().next());
                for (Exam other : exams) {
                    if (other.equals((Object)exam) || placement.getPeriod().hasIntersection(exam, other, placement.getPeriod().next())) continue;
                    BackToBackConflict btb = (BackToBackConflict)ibackToBacks.get(other);
                    double distance = placement.getDistanceInMeters((ExamPlacement)assignment.getValue((Variable)other));
                    if (btb == null) {
                        btb = new BackToBackConflict(new ExamAssignment((ExamPlacement)assignment.getValue((Variable)other), assignment), btbDist < 0.0 ? false : distance > btbDist, distance);
                        ibackToBacks.put(other, btb);
                    } else {
                        btb.incNrStudents();
                    }
                    btb.getStudents().add(instructor.getId());
                }
            }
            this.iInstructorBackToBacks.addAll(ibackToBacks.values());
            Hashtable<String, MoreThanTwoADayConflict> im2ds = new Hashtable<String, MoreThanTwoADayConflict>();
            for (ExamInstructor instructor : exam.getInstructors()) {
                Set exams = instructor.getExamsADay(assignment, placement.getPeriod());
                int nrExams = exams.size() + (exams.contains(exam) ? 0 : 1);
                if (nrExams <= 2) continue;
                TreeSet<Long> examIds = new TreeSet<Long>();
                TreeSet<ExamAssignment> otherExams = new TreeSet<ExamAssignment>();
                for (Exam other : exams) {
                    if (other.equals((Object)exam)) continue;
                    examIds.add(other.getId());
                    otherExams.add(new ExamAssignment((ExamPlacement)assignment.getValue((Variable)other), assignment));
                }
                MoreThanTwoADayConflict m2d = (MoreThanTwoADayConflict)im2ds.get(examIds.toString());
                if (m2d == null) {
                    m2d = new MoreThanTwoADayConflict(otherExams);
                    im2ds.put(examIds.toString(), m2d);
                } else {
                    m2d.incNrStudents();
                }
                m2d.getStudents().add(instructor.getId());
            }
            this.iInstructorMoreThanTwoADays.addAll(im2ds.values());
            this.computeUnavailablility(exam, model.getUnavailabilities(placement.getPeriod()));
            for (ExamDistributionConstraint dc : exam.getDistributionConstraints()) {
                if (dc.isHard()) {
                    if (!dc.inConflict(assignment, placement)) continue;
                    this.iDistributions.add(new DistributionConflict(dc, exam, assignment));
                    continue;
                }
                if (dc.isSatisfied(assignment, placement)) continue;
                this.iDistributions.add(new DistributionConflict(dc, exam, assignment));
            }
        }
    }

    public ExamAssignmentInfo(org.unitime.timetable.model.Exam exam) {
        this(exam, ApplicationProperty.ExaminationCacheConflicts.isTrue());
    }

    public ExamAssignmentInfo(org.unitime.timetable.model.Exam exam, Hashtable<Long, Set<Long>> owner2students, Hashtable<Long, Hashtable<Long, Set<Long>>> onwer2course2students, Hashtable<Long, Set<org.unitime.timetable.model.Exam>> studentExams, Hashtable<Long, Set<Meeting>> period2meetings, Parameters p) {
        super(exam, owner2students, onwer2course2students);
        Hashtable<Long, Set<org.unitime.timetable.model.Exam>> examStudents = new Hashtable<Long, Set<org.unitime.timetable.model.Exam>>();
        for (ExamInfo.ExamSectionInfo section : this.getSections()) {
            for (Long studentId : section.getStudentIds()) {
                examStudents.put(studentId, studentExams.get(studentId));
            }
        }
        this.generateConflicts(exam, examStudents, null, period2meetings, p, owner2students, onwer2course2students);
    }

    public ExamAssignmentInfo(org.unitime.timetable.model.Exam exam, boolean useCache) {
        super(exam);
        if (!useCache) {
            this.generateConflicts(exam, exam.getStudentExams(), null);
            return;
        }
        if (exam.getConflicts() != null && !exam.getConflicts().isEmpty()) {
            for (ExamConflict conf : exam.getConflicts()) {
                TreeSet<ExamAssignment> other;
                if (conf.isDirectConflict()) {
                    other = null;
                    for (org.unitime.timetable.model.Exam x : conf.getExams()) {
                        if (x.equals(exam) || x.getAssignedPeriod() == null) continue;
                        other = new ExamAssignment(x);
                    }
                    if (conf.getNrStudents() > 0) {
                        this.iDirects.add(new DirectConflict((ExamAssignment)((Object)other), conf, true));
                        this.iNrDirectConflicts += conf.getNrStudents().intValue();
                    }
                    if (conf.getNrInstructors() <= 0) continue;
                    this.iInstructorDirects.add(new DirectConflict((ExamAssignment)((Object)other), conf, false));
                    this.iNrInstructorDirectConflicts += conf.getNrInstructors().intValue();
                    continue;
                }
                if (conf.isBackToBackConflict()) {
                    other = null;
                    for (org.unitime.timetable.model.Exam x : conf.getExams()) {
                        if (x.equals(exam) || x.getAssignedPeriod() == null) continue;
                        other = new ExamAssignment(x);
                    }
                    if (other == null) continue;
                    if (conf.getNrStudents() > 0) {
                        this.iBackToBacks.add(new BackToBackConflict((ExamAssignment)((Object)other), conf, true));
                        this.iNrBackToBackConflicts += conf.getNrStudents().intValue();
                        if (conf.isDistanceBackToBackConflict()) {
                            this.iNrDistanceBackToBackConflicts += conf.getNrStudents().intValue();
                        }
                    }
                    if (conf.getNrInstructors() <= 0) continue;
                    this.iInstructorBackToBacks.add(new BackToBackConflict((ExamAssignment)((Object)other), conf, false));
                    this.iNrInstructorBackToBackConflicts += conf.getNrInstructors().intValue();
                    if (!conf.isDistanceBackToBackConflict()) continue;
                    this.iNrInstructorDistanceBackToBackConflicts += conf.getNrInstructors().intValue();
                    continue;
                }
                if (!conf.isMoreThanTwoADayConflict()) continue;
                other = new TreeSet();
                for (org.unitime.timetable.model.Exam x : conf.getExams()) {
                    if (x.equals(exam) || x.getAssignedPeriod() == null) continue;
                    other.add(new ExamAssignment(x));
                }
                if (other.size() < 2) continue;
                if (conf.getNrStudents() > 0) {
                    this.iMoreThanTwoADays.add(new MoreThanTwoADayConflict(other, conf, true));
                    this.iNrMoreThanTwoADayConflicts += conf.getNrStudents().intValue();
                }
                if (conf.getNrInstructors() <= 0) continue;
                this.iInstructorMoreThanTwoADays.add(new MoreThanTwoADayConflict(other, conf, false));
                this.iNrInstructorMoreThanTwoADayConflicts += conf.getNrInstructors().intValue();
            }
        }
        for (DistributionObject dObj : exam.getDistributionObjects()) {
            DistributionPref pref = dObj.getDistributionPref();
            if (this.check(pref, exam, this.getPeriod(), this.getRooms(), null)) continue;
            this.iDistributions.add(new DistributionConflict(pref, exam));
        }
        if (exam.getAssignedPeriod() != null && ApplicationProperty.ExaminationConsiderEventConflicts.isTrue(exam.getExamType().getReference())) {
            this.computeUnavailablility(exam, exam.getAssignedPeriod().getUniqueId());
            Iterator<Comparable> i = exam.getInstructors().iterator();
            while (i.hasNext()) {
                this.computeUnavailablility((DepartmentalInstructor)i.next(), exam.getAssignedPeriod());
            }
        }
    }

    private void computeUnavailablility(Exam exam, Vector<ExamResourceUnavailability> unavailabilities) {
        if (unavailabilities == null || unavailabilities.isEmpty()) {
            return;
        }
        for (ExamResourceUnavailability unavailability : unavailabilities) {
            Vector<Long> commonStudents = new Vector<Long>();
            for (ExamStudent student : exam.getStudents()) {
                if (!unavailability.getStudentIds().contains(student.getId())) continue;
                commonStudents.add(student.getId());
            }
            if (!commonStudents.isEmpty()) {
                this.iDirects.add(new DirectConflict(unavailability, commonStudents));
            }
            Vector<Long> commonInstructors = new Vector<Long>();
            for (ExamInstructor instructor : exam.getInstructors()) {
                if (!unavailability.getInstructorIds().contains(instructor.getId())) continue;
                commonInstructors.add(instructor.getId());
            }
            if (commonInstructors.isEmpty()) continue;
            this.iInstructorDirects.add(new DirectConflict(unavailability, commonInstructors));
        }
    }

    private void computeUnavailablility(org.unitime.timetable.model.Exam exam, Long periodId, Hashtable<Long, Set<Meeting>> period2meetings) {
        if (period2meetings == null) {
            this.computeUnavailablility(exam, periodId);
        } else {
            Set<Meeting> meetings = period2meetings.get(periodId);
            if (meetings != null) {
                block0: for (Meeting meeting : meetings) {
                    for (DirectConflict dc : this.iDirects) {
                        if (!meeting.getEvent().getUniqueId().equals(dc.getOtherEventId())) continue;
                        dc.addMeeting(meeting);
                        continue block0;
                    }
                    HashSet<Long> students = new HashSet<Long>();
                    block2: for (Long studentId : meeting.getEvent().getStudentIds()) {
                        for (ExamInfo.ExamSectionInfo section : this.getSections()) {
                            if (!section.getStudentIds().contains(studentId)) continue;
                            students.add(studentId);
                            continue block2;
                        }
                    }
                    if (students.isEmpty()) continue;
                    this.iDirects.add(new DirectConflict(meeting, students));
                }
            }
        }
    }

    private void computeUnavailablility(org.unitime.timetable.model.Exam exam, Long periodId) {
        block0: for (Map.Entry<Meeting, Set<Long>> entry : exam.getOverlappingStudentMeetings(periodId).entrySet()) {
            for (DirectConflict dc : this.iDirects) {
                if (!entry.getKey().getEvent().getUniqueId().equals(dc.getOtherEventId())) continue;
                dc.addMeeting(entry.getKey());
                continue block0;
            }
            this.iDirects.add(new DirectConflict(entry.getKey(), (Collection<Long>)entry.getValue()));
        }
        block2: for (Map.Entry<Meeting, Set<Long>> entry : ((ExamPeriod)ExamPeriodDAO.getInstance().get(periodId)).findOverlappingCourseMeetingsWithReqAttendence(this.getStudentIds()).entrySet()) {
            for (DirectConflict dc : this.iDirects) {
                if (!entry.getKey().getEvent().getUniqueId().equals(dc.getOtherEventId())) continue;
                dc.addMeeting(entry.getKey());
                continue block2;
            }
            this.iDirects.add(new DirectConflict(entry.getKey(), (Collection<Long>)entry.getValue()));
        }
        block4: for (Map.Entry<Meeting, Set<Long>> entry : ((ExamPeriod)ExamPeriodDAO.getInstance().get(periodId)).findOverlappingExamMeetingsOfDifferentProblem(this.getStudentIds()).entrySet()) {
            for (DirectConflict dc : this.iDirects) {
                if (!entry.getKey().getEvent().getUniqueId().equals(dc.getOtherEventId())) continue;
                dc.addMeeting(entry.getKey());
                continue block4;
            }
            this.iDirects.add(new DirectConflict(entry.getKey(), (Collection<Long>)entry.getValue()));
        }
    }

    private void computeUnavailablility(DepartmentalInstructor instructor, ExamPeriod period, Hashtable<Long, Set<Meeting>> period2meetings) {
        if (period2meetings == null) {
            this.computeUnavailablility(instructor, period);
        } else {
            Set<Meeting> meetings = period2meetings.get(period.getUniqueId());
            if (meetings != null) {
                block0: for (Meeting meeting : meetings) {
                    if (!(meeting.getEvent() instanceof ClassEvent)) continue;
                    Class_ clazz = ((ClassEvent)meeting.getEvent()).getClazz();
                    for (ClassInstructor ci : clazz.getClassInstructors()) {
                        if (!ci.isLead().booleanValue() || !ci.getInstructor().getUniqueId().equals(instructor.getUniqueId()) && (ci.getInstructor().getExternalUniqueId() == null || !ci.getInstructor().getExternalUniqueId().equals(instructor.getExternalUniqueId()))) continue;
                        for (DirectConflict dc : this.iInstructorDirects) {
                            if (!meeting.getEvent().getUniqueId().equals(dc.getOtherEventId())) continue;
                            dc.incNrStudents();
                            dc.getStudents().add(instructor.getUniqueId());
                            dc.addMeeting(meeting);
                            continue block0;
                        }
                        DirectConflict dc = new DirectConflict(meeting);
                        dc.getStudents().add(instructor.getUniqueId());
                        this.iInstructorDirects.add(dc);
                        continue block0;
                    }
                }
            }
        }
    }

    private void computeUnavailablility(DepartmentalInstructor instructor, ExamPeriod period) {
        for (ClassInstructor ci : instructor.getClasses()) {
            if (!ci.isLead().booleanValue()) continue;
            block1: for (Meeting meeting : period.findOverlappingClassMeetings(ci.getClassInstructing().getUniqueId())) {
                for (DirectConflict dc : this.iInstructorDirects) {
                    if (!meeting.getEvent().getUniqueId().equals(dc.getOtherEventId())) continue;
                    dc.incNrStudents();
                    dc.getStudents().add(instructor.getUniqueId());
                    dc.addMeeting(meeting);
                    continue block1;
                }
                DirectConflict dc = new DirectConflict(meeting);
                dc.getStudents().add(instructor.getUniqueId());
                this.iInstructorDirects.add(dc);
            }
        }
    }

    public boolean check(DistributionPref pref, org.unitime.timetable.model.Exam exam, ExamPeriod assignedPeriod, Collection<ExamRoomInfo> assignedRooms, Hashtable<Long, ExamAssignment> table) {
        boolean positive;
        if (PreferenceLevel.sNeutral.equals(pref.getPrefLevel().getPrefProlog())) {
            return true;
        }
        boolean bl = positive = PreferenceLevel.sRequired.equals(pref.getPrefLevel().getPrefProlog()) || PreferenceLevel.sStronglyPreferred.equals(pref.getPrefLevel().getPrefProlog()) || PreferenceLevel.sPreferred.equals(pref.getPrefLevel().getPrefProlog());
        if ("EX_SAME_PER".equals(pref.getDistributionType().getReference())) {
            if (positive) {
                ExamPeriod period = null;
                Iterator<DistributionObject> i = pref.getDistributionObjects().iterator();
                while (i.hasNext()) {
                    org.unitime.timetable.model.Exam x = (org.unitime.timetable.model.Exam)i.next().getPrefGroup();
                    ExamPeriod p = x.equals(exam) ? assignedPeriod : ExamAssignmentInfo.getAssignedPeriod(x, table);
                    if (p == null) continue;
                    if (period == null) {
                        period = p;
                        continue;
                    }
                    if (period.equals(p)) continue;
                    return false;
                }
                return true;
            }
            HashSet<ExamPeriod> periods = new HashSet<ExamPeriod>();
            Iterator<DistributionObject> i = pref.getDistributionObjects().iterator();
            while (i.hasNext()) {
                org.unitime.timetable.model.Exam x = (org.unitime.timetable.model.Exam)i.next().getPrefGroup();
                ExamPeriod p = x.equals(exam) ? assignedPeriod : ExamAssignmentInfo.getAssignedPeriod(x, table);
                if (p == null || periods.add(p)) continue;
                return false;
            }
            return true;
        }
        if ("EX_PRECEDENCE".equals(pref.getDistributionType().getReference())) {
            TreeSet<DistributionObject> distObjects = new TreeSet<DistributionObject>(positive ? new Comparator<DistributionObject>(){

                @Override
                public int compare(DistributionObject d1, DistributionObject d2) {
                    return d1.getSequenceNumber().compareTo(d2.getSequenceNumber());
                }
            } : new Comparator<DistributionObject>(){

                @Override
                public int compare(DistributionObject d1, DistributionObject d2) {
                    return d2.getSequenceNumber().compareTo(d1.getSequenceNumber());
                }
            });
            distObjects.addAll(pref.getDistributionObjects());
            ExamPeriod prev = null;
            Iterator<DistributionObject> i = distObjects.iterator();
            while (i.hasNext()) {
                org.unitime.timetable.model.Exam x = (org.unitime.timetable.model.Exam)i.next().getPrefGroup();
                ExamPeriod p = x.equals(exam) ? assignedPeriod : ExamAssignmentInfo.getAssignedPeriod(x, table);
                if (p == null) continue;
                if (prev != null && prev.compareTo(p) >= 0) {
                    return false;
                }
                prev = p;
            }
            return true;
        }
        if ("EX_SAME_ROOM".equals(pref.getDistributionType().getReference())) {
            if (positive) {
                Collection<ExamRoomInfo> rooms = null;
                Iterator<DistributionObject> i = pref.getDistributionObjects().iterator();
                while (i.hasNext()) {
                    org.unitime.timetable.model.Exam x = (org.unitime.timetable.model.Exam)i.next().getPrefGroup();
                    Collection<ExamRoomInfo> r = x.equals(exam) ? assignedRooms : ExamAssignmentInfo.getAssignedRooms(x, table);
                    if (r == null) continue;
                    if (rooms == null) {
                        rooms = r;
                        continue;
                    }
                    if (rooms.containsAll(r) || r.containsAll(rooms)) continue;
                    return false;
                }
                return true;
            }
            HashSet<ExamRoomInfo> allRooms = new HashSet<ExamRoomInfo>();
            Iterator<DistributionObject> i = pref.getDistributionObjects().iterator();
            while (i.hasNext()) {
                Collection<ExamRoomInfo> r;
                org.unitime.timetable.model.Exam x = (org.unitime.timetable.model.Exam)i.next().getPrefGroup();
                Collection<ExamRoomInfo> collection = r = x.equals(exam) ? assignedRooms : ExamAssignmentInfo.getAssignedRooms(x, table);
                if (r == null) continue;
                for (ExamRoomInfo room : r) {
                    if (allRooms.add(room)) continue;
                    return false;
                }
            }
            return true;
        }
        if ("EX_SHARE_ROOM".equals(pref.getDistributionType().getReference())) {
            return true;
        }
        if ("EX_SAME_DAY".equals(pref.getDistributionType().getReference())) {
            if (positive) {
                ExamPeriod period = null;
                Iterator<DistributionObject> i = pref.getDistributionObjects().iterator();
                while (i.hasNext()) {
                    org.unitime.timetable.model.Exam x = (org.unitime.timetable.model.Exam)i.next().getPrefGroup();
                    ExamPeriod p = x.equals(exam) ? assignedPeriod : ExamAssignmentInfo.getAssignedPeriod(x, table);
                    if (p == null) continue;
                    if (period == null) {
                        period = p;
                        continue;
                    }
                    if (period.getDateOffset().equals(p.getDateOffset())) continue;
                    return false;
                }
                return true;
            }
            HashSet<Integer> periods = new HashSet<Integer>();
            Iterator<DistributionObject> i = pref.getDistributionObjects().iterator();
            while (i.hasNext()) {
                org.unitime.timetable.model.Exam x = (org.unitime.timetable.model.Exam)i.next().getPrefGroup();
                ExamPeriod p = x.equals(exam) ? assignedPeriod : ExamAssignmentInfo.getAssignedPeriod(x, table);
                if (p == null || periods.add(p.getDateOffset())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static ExamPeriod getAssignedPeriod(org.unitime.timetable.model.Exam exam, Hashtable<Long, ExamAssignment> table) {
        ExamAssignment assignment = table == null ? null : table.get(exam.getUniqueId());
        return assignment == null ? exam.getAssignedPeriod() : assignment.getPeriod();
    }

    public static TreeSet<ExamRoomInfo> getAssignedRooms(org.unitime.timetable.model.Exam exam, Hashtable<Long, ExamAssignment> table) {
        ExamAssignment assignment;
        ExamAssignment examAssignment = assignment = table == null ? null : table.get(exam.getUniqueId());
        if (assignment != null) {
            return assignment.getRooms();
        }
        TreeSet<ExamRoomInfo> rooms = new TreeSet<ExamRoomInfo>();
        for (Location location : exam.getAssignedRooms()) {
            rooms.add(new ExamRoomInfo(location, 0));
        }
        return rooms;
    }

    public static ExamAssignment getAssignment(org.unitime.timetable.model.Exam exam, Hashtable<Long, ExamAssignment> table, Hashtable<Long, Set<Long>> owner2students, Hashtable<Long, Hashtable<Long, Set<Long>>> onwer2course2students) {
        ExamAssignment assignment = table == null ? null : table.get(exam.getUniqueId());
        return assignment == null ? new ExamAssignment(exam, owner2students, onwer2course2students) : assignment;
    }

    public ExamAssignmentInfo(org.unitime.timetable.model.Exam exam, ExamPeriod period, Collection<ExamRoomInfo> rooms) throws Exception {
        this(exam, period, rooms, period == null ? null : exam.getStudentExams(), null);
    }

    public ExamAssignmentInfo(org.unitime.timetable.model.Exam exam, ExamPeriod period, Collection<ExamRoomInfo> rooms, Hashtable<Long, ExamAssignment> table) throws Exception {
        this(exam, period, rooms, exam.getStudentExams(), table);
    }

    public ExamAssignmentInfo(org.unitime.timetable.model.Exam exam, ExamPeriod period, Collection<ExamRoomInfo> rooms, Hashtable<Long, Set<org.unitime.timetable.model.Exam>> examStudents, Hashtable<Long, ExamAssignment> table) throws Exception {
        super(exam, period, rooms);
        if (period != null) {
            this.generateConflicts(exam, examStudents, table);
        }
    }

    public ExamAssignmentInfo(org.unitime.timetable.model.Exam exam, Hashtable<Long, ExamAssignment> table) {
        super(exam);
        this.generateConflicts(exam, exam.getStudentExams(), table);
    }

    public void generateConflicts(org.unitime.timetable.model.Exam exam, Hashtable<Long, Set<org.unitime.timetable.model.Exam>> examStudents, Hashtable<Long, ExamAssignment> table) {
        this.generateConflicts(exam, examStudents, table, null, new Parameters(exam.getSession().getUniqueId(), exam.getExamType().getUniqueId()), null, null);
    }

    public void generateConflicts(org.unitime.timetable.model.Exam exam, Hashtable<Long, Set<org.unitime.timetable.model.Exam>> examStudents, Hashtable<Long, ExamAssignment> table, Hashtable<Long, Set<Meeting>> period2meetings, Parameters p, Hashtable<Long, Set<Long>> owner2students, Hashtable<Long, Hashtable<Long, Set<Long>>> onwer2course2students) {
        if (this.getPeriod() == null) {
            return;
        }
        Hashtable<org.unitime.timetable.model.Exam, DirectConflict> directs = new Hashtable<org.unitime.timetable.model.Exam, DirectConflict>();
        Hashtable<org.unitime.timetable.model.Exam, BackToBackConflict> backToBacks = new Hashtable<org.unitime.timetable.model.Exam, BackToBackConflict>();
        Hashtable<String, MoreThanTwoADayConflict> m2ds = new Hashtable<String, MoreThanTwoADayConflict>();
        for (Map.Entry<Long, Set<org.unitime.timetable.model.Exam>> studentExams : examStudents.entrySet()) {
            TreeSet<org.unitime.timetable.model.Exam> sameDateExams = new TreeSet<org.unitime.timetable.model.Exam>();
            for (org.unitime.timetable.model.Exam other : studentExams.getValue()) {
                ExamPeriod otherPeriod;
                if (other.equals(this.getExam()) || (otherPeriod = ExamAssignmentInfo.getAssignedPeriod(other, table)) == null) continue;
                if (this.getPeriod().equals(otherPeriod) || this.getPeriod().overlap(exam, other, otherPeriod)) {
                    DirectConflict dc = (DirectConflict)directs.get(other);
                    if (dc == null) {
                        dc = new DirectConflict(ExamAssignmentInfo.getAssignment(other, table, owner2students, onwer2course2students));
                        directs.put(other, dc);
                    } else {
                        dc.incNrStudents();
                    }
                    dc.getStudents().add(studentExams.getKey());
                    ++this.iNrDirectConflicts;
                } else if (p.isBackToBack(this.getPeriod(), otherPeriod)) {
                    BackToBackConflict btb = (BackToBackConflict)backToBacks.get(other);
                    double distance = Location.getDistance(this.getRooms(), ExamAssignmentInfo.getAssignedRooms(other, table));
                    if (btb == null) {
                        btb = new BackToBackConflict(ExamAssignmentInfo.getAssignment(other, table, owner2students, onwer2course2students), p.getBackToBackDistance() < 0 ? false : distance > (double)p.getBackToBackDistance(), distance);
                        backToBacks.put(other, btb);
                    } else {
                        btb.incNrStudents();
                    }
                    btb.getStudents().add(studentExams.getKey());
                    ++this.iNrBackToBackConflicts;
                    if (btb.isDistance()) {
                        ++this.iNrDistanceBackToBackConflicts;
                    }
                }
                if (!this.getPeriod().getDateOffset().equals(otherPeriod.getDateOffset())) continue;
                sameDateExams.add(other);
            }
            if (sameDateExams.size() < 2) continue;
            TreeSet<Long> examIds = new TreeSet<Long>();
            TreeSet<ExamAssignment> otherExams = new TreeSet<ExamAssignment>();
            for (org.unitime.timetable.model.Exam other : sameDateExams) {
                examIds.add(other.getUniqueId());
                otherExams.add(ExamAssignmentInfo.getAssignment(other, table, owner2students, onwer2course2students));
            }
            MoreThanTwoADayConflict m2d = (MoreThanTwoADayConflict)m2ds.get(examIds.toString());
            if (m2d == null) {
                m2d = new MoreThanTwoADayConflict(otherExams);
                m2ds.put(examIds.toString(), m2d);
            } else {
                m2d.incNrStudents();
            }
            ++this.iNrMoreThanTwoADayConflicts;
            m2d.getStudents().add(studentExams.getKey());
        }
        this.iDirects.addAll(directs.values());
        this.iBackToBacks.addAll(backToBacks.values());
        this.iMoreThanTwoADays.addAll(m2ds.values());
        if (ApplicationProperty.ExaminationConsiderEventConflicts.isTrue(exam.getExamType().getReference())) {
            this.computeUnavailablility(exam, this.getPeriodId(), period2meetings);
        }
        Hashtable<org.unitime.timetable.model.Exam, DirectConflict> idirects = new Hashtable<org.unitime.timetable.model.Exam, DirectConflict>();
        Hashtable<org.unitime.timetable.model.Exam, BackToBackConflict> ibackToBacks = new Hashtable<org.unitime.timetable.model.Exam, BackToBackConflict>();
        Hashtable<String, MoreThanTwoADayConflict> im2ds = new Hashtable<String, MoreThanTwoADayConflict>();
        for (DepartmentalInstructor instructor : this.getExam().getInstructors()) {
            TreeSet<org.unitime.timetable.model.Exam> sameDateExams = new TreeSet<org.unitime.timetable.model.Exam>();
            for (org.unitime.timetable.model.Exam other : instructor.getExams(this.getExam().getExamType())) {
                ExamPeriod otherPeriod;
                if (other.equals(this.getExam()) || (otherPeriod = ExamAssignmentInfo.getAssignedPeriod(other, table)) == null) continue;
                if (this.getPeriod().equals(otherPeriod) || this.getPeriod().overlap(exam, other, otherPeriod)) {
                    DirectConflict dc = (DirectConflict)idirects.get(other);
                    if (dc == null) {
                        dc = new DirectConflict(ExamAssignmentInfo.getAssignment(other, table, owner2students, onwer2course2students));
                        idirects.put(other, dc);
                    } else {
                        dc.incNrStudents();
                    }
                    ++this.iNrInstructorDirectConflicts;
                    dc.getStudents().add(instructor.getUniqueId());
                } else if (p.isBackToBack(this.getPeriod(), otherPeriod)) {
                    BackToBackConflict btb = (BackToBackConflict)ibackToBacks.get(other);
                    double distance = Location.getDistance(this.getRooms(), ExamAssignmentInfo.getAssignedRooms(other, table));
                    if (btb == null) {
                        btb = new BackToBackConflict(ExamAssignmentInfo.getAssignment(other, table, owner2students, onwer2course2students), p.getBackToBackDistance() < 0 ? false : distance > (double)p.getBackToBackDistance(), distance);
                        ibackToBacks.put(other, btb);
                    } else {
                        btb.incNrStudents();
                    }
                    ++this.iNrInstructorBackToBackConflicts;
                    if (btb.isDistance()) {
                        ++this.iNrInstructorDistanceBackToBackConflicts;
                    }
                    btb.getStudents().add(instructor.getUniqueId());
                }
                if (!this.getPeriod().getDateOffset().equals(otherPeriod.getDateOffset())) continue;
                sameDateExams.add(other);
            }
            if (ApplicationProperty.ExaminationConsiderEventConflicts.isTrue(exam.getExamType().getReference())) {
                this.computeUnavailablility(instructor, this.getPeriod(), period2meetings);
            }
            if (sameDateExams.size() < 2) continue;
            TreeSet<Long> examIds = new TreeSet<Long>();
            TreeSet<ExamAssignment> otherExams = new TreeSet<ExamAssignment>();
            for (org.unitime.timetable.model.Exam other : sameDateExams) {
                examIds.add(other.getUniqueId());
                otherExams.add(ExamAssignmentInfo.getAssignment(other, table, owner2students, onwer2course2students));
            }
            MoreThanTwoADayConflict m2d = (MoreThanTwoADayConflict)im2ds.get(examIds.toString());
            if (m2d == null) {
                m2d = new MoreThanTwoADayConflict(otherExams);
                im2ds.put(examIds.toString(), m2d);
            } else {
                m2d.incNrStudents();
            }
            ++this.iNrInstructorMoreThanTwoADayConflicts;
            m2d.getStudents().add(instructor.getUniqueId());
        }
        this.iInstructorDirects.addAll(idirects.values());
        this.iInstructorBackToBacks.addAll(ibackToBacks.values());
        this.iInstructorMoreThanTwoADays.addAll(im2ds.values());
        for (DistributionObject dObj : this.getExam().getDistributionObjects()) {
            DistributionPref pref = dObj.getDistributionPref();
            if (this.check(pref, this.getExam(), this.getPeriod(), this.getRooms(), table)) continue;
            this.iDistributions.add(new DistributionConflict(pref, this.getExam()));
        }
    }

    public TreeSet<DirectConflict> getDirectConflicts() {
        return this.iDirects;
    }

    public TreeSet<BackToBackConflict> getBackToBackConflicts() {
        return this.iBackToBacks;
    }

    public TreeSet<MoreThanTwoADayConflict> getMoreThanTwoADaysConflicts() {
        return this.iMoreThanTwoADays;
    }

    public int getNrDirectConflicts() {
        int ret = 0;
        for (DirectConflict dc : this.iDirects) {
            ret += dc.getNrStudents();
        }
        return ret;
    }

    public int getNrNotAvailableDirectConflicts() {
        int ret = 0;
        for (DirectConflict dc : this.iDirects) {
            if (dc.getOtherExam() != null) continue;
            ret += dc.getNrStudents();
        }
        return ret;
    }

    public int getNrBackToBackConflicts() {
        int ret = 0;
        for (BackToBackConflict btb : this.iBackToBacks) {
            ret += btb.getNrStudents();
        }
        return ret;
    }

    public int getNrDistanceBackToBackConflicts() {
        int ret = 0;
        for (BackToBackConflict btb : this.iBackToBacks) {
            if (!btb.isDistance()) continue;
            ret += btb.getNrStudents();
        }
        return ret;
    }

    public int getNrMoreThanTwoConflicts() {
        int ret = 0;
        for (MoreThanTwoADayConflict m2d : this.iMoreThanTwoADays) {
            ret += m2d.getNrStudents();
        }
        return ret;
    }

    public int getNrDirectConflicts(ExamInfo.ExamSectionInfo section) {
        int ret = 0;
        for (DirectConflict dc : this.iDirects) {
            Enumeration<Long> f = dc.getStudents().elements();
            while (f.hasMoreElements()) {
                if (!section.getStudentIds().contains(f.nextElement())) continue;
                ++ret;
            }
        }
        return ret;
    }

    public int getNrBackToBackConflicts(ExamInfo.ExamSectionInfo section) {
        int ret = 0;
        for (BackToBackConflict btb : this.iBackToBacks) {
            Enumeration<Long> f = btb.getStudents().elements();
            while (f.hasMoreElements()) {
                if (!section.getStudentIds().contains(f.nextElement())) continue;
                ++ret;
            }
        }
        return ret;
    }

    public int getNrDistanceBackToBackConflicts(ExamInfo.ExamSectionInfo section) {
        int ret = 0;
        for (BackToBackConflict btb : this.iBackToBacks) {
            if (!btb.isDistance()) continue;
            Enumeration<Long> f = btb.getStudents().elements();
            while (f.hasMoreElements()) {
                if (!section.getStudentIds().contains(f.nextElement())) continue;
                ++ret;
            }
        }
        return ret;
    }

    public int getNrMoreThanTwoConflicts(ExamInfo.ExamSectionInfo section) {
        int ret = 0;
        for (MoreThanTwoADayConflict m2d : this.iMoreThanTwoADays) {
            Enumeration<Long> f = m2d.getStudents().elements();
            while (f.hasMoreElements()) {
                if (!section.getStudentIds().contains(f.nextElement())) continue;
                ++ret;
            }
        }
        return ret;
    }

    public TreeSet<DistributionConflict> getDistributionConflicts() {
        return this.iDistributions;
    }

    public String getDistributionConflictsHtml(String delim) {
        Object ret = "";
        for (DistributionConflict dc : this.iDistributions) {
            if (((String)ret).length() > 0) {
                ret = (String)ret + delim;
            }
            ret = (String)ret + dc.getTypeHtml();
        }
        return ret;
    }

    public String getDistributionConflictsList(String delim) {
        Object ret = "";
        for (DistributionConflict dc : this.iDistributions) {
            if (((String)ret).length() > 0) {
                ret = (String)ret + delim;
            }
            ret = (String)ret + PreferenceLevel.prolog2abbv(dc.getPreference()) + " " + dc.getType();
        }
        return ret;
    }

    public int getNrDistributionConflicts() {
        return this.iDistributions.size();
    }

    public boolean getHasConflicts() {
        return !this.getDirectConflicts().isEmpty() || !this.getBackToBackConflicts().isEmpty() || !this.getMoreThanTwoADaysConflicts().isEmpty();
    }

    public String getConflictTable() {
        return this.getConflictTable(true);
    }

    public String getConflictTable(boolean header) {
        Object ret = "<table border='0' width='100%' cellspacing='0' cellpadding='3'>";
        if (header) {
            ret = (String)ret + "<tr>";
            ret = (String)ret + "<td><i>" + MSG.colStudents() + "</i></td>";
            ret = (String)ret + "<td><i>" + MSG.colConflict() + "</i></td>";
            ret = (String)ret + "<td><i>" + MSG.colExamination() + "</i></td>";
            ret = (String)ret + "<td><i>" + MSG.colPeriod() + "</i></td>";
            ret = (String)ret + "<td><i>" + MSG.colRoom() + "</i></td>";
            ret = (String)ret + "</tr>";
        }
        Iterator<Comparable<DirectConflict>> i = this.getDirectConflicts().iterator();
        while (i.hasNext()) {
            ret = (String)ret + ((Object)i.next()).toString();
        }
        i = this.getMoreThanTwoADaysConflicts().iterator();
        while (i.hasNext()) {
            ret = (String)ret + i.next().toString();
        }
        i = this.getBackToBackConflicts().iterator();
        while (i.hasNext()) {
            ret = (String)ret + i.next().toString();
        }
        ret = (String)ret + "</table>";
        return ret;
    }

    public String getConflictInfoTable() {
        Object ret = "<table border='0' width='100%' cellspacing='0' cellpadding='3'>";
        ret = (String)ret + "<tr>";
        ret = (String)ret + "<td><i>" + MSG.colStudents() + "</i></td>";
        ret = (String)ret + "<td><i>" + MSG.colConflict() + "</i></td>";
        ret = (String)ret + "<td><i>" + MSG.colExamination() + "</i></td>";
        ret = (String)ret + "<td><i>" + MSG.colPeriod() + "</i></td>";
        ret = (String)ret + "<td><i>" + MSG.colRoom() + "</i></td>";
        ret = (String)ret + "</tr>";
        for (DirectConflict dc : this.getDirectConflicts()) {
            ret = (String)ret + dc.toString(true);
        }
        for (MoreThanTwoADayConflict m2d : this.getMoreThanTwoADaysConflicts()) {
            ret = (String)ret + m2d.toString(true);
        }
        for (BackToBackConflict btb : this.getBackToBackConflicts()) {
            ret = (String)ret + btb.toString(true);
        }
        ret = (String)ret + "</table>";
        return ret;
    }

    public String getDistributionConflictTable() {
        return this.getDistributionConflictTable(true);
    }

    public String getDistributionConflictTable(boolean header) {
        Object ret = "<table border='0' width='100%' cellspacing='0' cellpadding='3'>";
        if (header) {
            ret = (String)ret + "<tr>";
            ret = (String)ret + "<td><i>" + MSG.colPreference() + "</i></td>";
            ret = (String)ret + "<td><i>" + MSG.colDistribution() + "</i></td>";
            ret = (String)ret + "<td><i>" + MSG.colExamination() + "</i></td>";
            ret = (String)ret + "<td><i>" + MSG.colPeriod() + "</i></td>";
            ret = (String)ret + "<td><i>" + MSG.colRoom() + "</i></td>";
            ret = (String)ret + "</tr>";
        }
        Iterator<DistributionConflict> i = this.getDistributionConflicts().iterator();
        while (i.hasNext()) {
            ret = (String)ret + ((Object)i.next()).toString();
        }
        ret = (String)ret + "</table>";
        return ret;
    }

    public String getDistributionInfoConflictTable() {
        Object ret = "<table border='0' width='100%' cellspacing='0' cellpadding='3'>";
        ret = (String)ret + "<tr>";
        ret = (String)ret + "<td><i>" + MSG.colPreference() + "</i></td>";
        ret = (String)ret + "<td><i>" + MSG.colDistribution() + "</i></td>";
        ret = (String)ret + "<td><i>" + MSG.colExamination() + "</i></td>";
        ret = (String)ret + "<td><i>" + MSG.colPeriod() + "</i></td>";
        ret = (String)ret + "<td><i>" + MSG.colRoom() + "</i></td>";
        ret = (String)ret + "</tr>";
        for (DistributionConflict dc : this.getDistributionConflicts()) {
            ret = (String)ret + dc.toString(true);
        }
        ret = (String)ret + "</table>";
        return ret;
    }

    public TreeSet<DirectConflict> getInstructorDirectConflicts() {
        return this.iInstructorDirects;
    }

    public TreeSet<BackToBackConflict> getInstructorBackToBackConflicts() {
        return this.iInstructorBackToBacks;
    }

    public TreeSet<MoreThanTwoADayConflict> getInstructorMoreThanTwoADaysConflicts() {
        return this.iInstructorMoreThanTwoADays;
    }

    public int getNrInstructorDirectConflicts() {
        int ret = 0;
        for (DirectConflict dc : this.iInstructorDirects) {
            ret += dc.getNrStudents();
        }
        return ret;
    }

    public int getNrInstructorBackToBackConflicts() {
        int ret = 0;
        for (BackToBackConflict btb : this.iInstructorBackToBacks) {
            ret += btb.getNrStudents();
        }
        return ret;
    }

    public int getNrInstructorDistanceBackToBackConflicts() {
        int ret = 0;
        for (BackToBackConflict btb : this.iInstructorBackToBacks) {
            if (!btb.isDistance()) continue;
            ret += btb.getNrStudents();
        }
        return ret;
    }

    public int getNrInstructorMoreThanTwoConflicts() {
        int ret = 0;
        for (MoreThanTwoADayConflict m2d : this.iInstructorMoreThanTwoADays) {
            ret += m2d.getNrStudents();
        }
        return ret;
    }

    public int getNrInstructorDirectConflicts(ExamInfo.ExamSectionInfo section) {
        return this.getNrInstructorDirectConflicts();
    }

    public int getNrInstructorBackToBackConflicts(ExamInfo.ExamSectionInfo section) {
        return this.getNrInstructorBackToBackConflicts();
    }

    public int getNrInstructorDistanceBackToBackConflicts(ExamInfo.ExamSectionInfo section) {
        return this.getNrInstructorDistanceBackToBackConflicts();
    }

    public int getNrInstructorMoreThanTwoConflicts(ExamInfo.ExamSectionInfo section) {
        return this.getNrInstructorMoreThanTwoConflicts();
    }

    public boolean getHasInstructorConflicts() {
        return !this.getInstructorDirectConflicts().isEmpty() || !this.getInstructorBackToBackConflicts().isEmpty() || !this.getInstructorMoreThanTwoADaysConflicts().isEmpty();
    }

    public String getInstructorConflictTable() {
        return this.getInstructorConflictTable(true);
    }

    public String getInstructorConflictTable(boolean header) {
        Object ret = "<table border='0' width='100%' cellspacing='0' cellpadding='3'>";
        if (header) {
            ret = (String)ret + "<tr>";
            ret = (String)ret + "<td><i>" + MSG.colInstructors() + "</i></td>";
            ret = (String)ret + "<td><i>" + MSG.colConflict() + "</i></td>";
            ret = (String)ret + "<td><i>" + MSG.colExamination() + "</i></td>";
            ret = (String)ret + "<td><i>" + MSG.colPeriod() + "</i></td>";
            ret = (String)ret + "<td><i>" + MSG.colRoom() + "</i></td>";
            ret = (String)ret + "</tr>";
        }
        Iterator<Comparable<DirectConflict>> i = this.getInstructorDirectConflicts().iterator();
        while (i.hasNext()) {
            ret = (String)ret + ((Object)i.next()).toString();
        }
        i = this.getInstructorMoreThanTwoADaysConflicts().iterator();
        while (i.hasNext()) {
            ret = (String)ret + i.next().toString();
        }
        i = this.getInstructorBackToBackConflicts().iterator();
        while (i.hasNext()) {
            ret = (String)ret + i.next().toString();
        }
        ret = (String)ret + "</table>";
        return ret;
    }

    public String getInstructorConflictInfoTable() {
        Object ret = "<table border='0' width='100%' cellspacing='0' cellpadding='3'>";
        ret = (String)ret + "<tr>";
        ret = (String)ret + "<td><i>" + MSG.colInstructors() + "</i></td>";
        ret = (String)ret + "<td><i>" + MSG.colConflict() + "</i></td>";
        ret = (String)ret + "<td><i>" + MSG.colExamination() + "</i></td>";
        ret = (String)ret + "<td><i>" + MSG.colPeriod() + "</i></td>";
        ret = (String)ret + "<td><i>" + MSG.colRoom() + "</i></td>";
        ret = (String)ret + "</tr>";
        for (DirectConflict dc : this.getInstructorDirectConflicts()) {
            ret = (String)ret + dc.toString(true);
        }
        for (MoreThanTwoADayConflict m2d : this.getInstructorMoreThanTwoADaysConflicts()) {
            ret = (String)ret + m2d.toString(true);
        }
        for (BackToBackConflict btb : this.getInstructorBackToBackConflicts()) {
            ret = (String)ret + btb.toString(true);
        }
        ret = (String)ret + "</table>";
        return ret;
    }

    public ExamAssignmentInfo(ExamOwner examOwner, Student student, Set<ExamOwner> examsOfTheSameStudent) {
        super(examOwner.getExam());
        this.iSections = new Vector();
        HashSet<Long> studentIds = new HashSet<Long>();
        studentIds.add(student.getUniqueId());
        this.iSections.add(new ExamInfo.ExamSectionInfo(this, examOwner, studentIds));
        org.unitime.timetable.model.Exam exam = examOwner.getExam();
        if (this.getPeriod() != null) {
            Parameters p = new Parameters(exam.getSession().getUniqueId(), exam.getExamType().getUniqueId());
            TreeSet<org.unitime.timetable.model.Exam> sameDateExams = new TreeSet<org.unitime.timetable.model.Exam>();
            for (ExamOwner studentExamOwner : examsOfTheSameStudent) {
                ExamPeriod otherPeriod;
                org.unitime.timetable.model.Exam other = studentExamOwner.getExam();
                if (other.equals(this.getExam()) || (otherPeriod = other.getAssignedPeriod()) == null) continue;
                if (this.getPeriod().equals(otherPeriod) || this.getPeriod().overlap(exam, other, otherPeriod)) {
                    DirectConflict dc = new DirectConflict(new ExamAssignment(other));
                    dc.getStudents().add(student.getUniqueId());
                    ++this.iNrDirectConflicts;
                    this.iDirects.add(dc);
                } else if (p.isBackToBack(this.getPeriod(), otherPeriod)) {
                    ExamAssignment ea = new ExamAssignment(other);
                    double distance = Location.getDistance(this.getRooms(), ea.getRooms());
                    BackToBackConflict btb = new BackToBackConflict(ea, p.getBackToBackDistance() < 0 ? false : distance > (double)p.getBackToBackDistance(), distance);
                    btb.getStudents().add(student.getUniqueId());
                    ++this.iNrBackToBackConflicts;
                    if (btb.isDistance()) {
                        ++this.iNrDistanceBackToBackConflicts;
                    }
                    this.iBackToBacks.add(btb);
                }
                if (!this.getPeriod().getDateOffset().equals(otherPeriod.getDateOffset())) continue;
                sameDateExams.add(other);
            }
            if (sameDateExams.size() >= 2) {
                TreeSet<Long> examIds = new TreeSet<Long>();
                TreeSet<ExamAssignment> otherExams = new TreeSet<ExamAssignment>();
                for (org.unitime.timetable.model.Exam other : sameDateExams) {
                    examIds.add(other.getUniqueId());
                    otherExams.add(new ExamAssignment(other));
                }
                MoreThanTwoADayConflict m2d = new MoreThanTwoADayConflict(otherExams);
                ++this.iNrMoreThanTwoADayConflicts;
                m2d.getStudents().add(student.getUniqueId());
                this.iMoreThanTwoADays.add(m2d);
            }
            if (ApplicationProperty.ExaminationConsiderEventConflicts.isTrue(examOwner.getExam().getExamType().getReference())) {
                int nrTravelSlots = ApplicationProperty.ExaminationTravelTimeClass.intValue();
                Iterator i = ExamDAO.getInstance().getSession().createQuery("select m from ClassEvent e inner join e.meetings m, StudentClassEnrollment en where en.student.uniqueId=:studentId and e.clazz=en.clazz and m.meetingDate=:startDate and m.startPeriod < :endSlot and m.stopPeriod > :startSlot", Meeting.class).setParameter("studentId", (Object)student.getUniqueId()).setParameter("startDate", (Object)this.getPeriod().getStartDate()).setParameter("startSlot", (Object)(this.getPeriod().getStartSlot() - nrTravelSlots)).setParameter("endSlot", (Object)(this.getPeriod().getEndSlot() + nrTravelSlots)).setCacheable(true).list().iterator();
                while (i.hasNext()) {
                    this.iDirects.add(new DirectConflict((Meeting)i.next(), studentIds));
                }
                i = ExamDAO.getInstance().getSession().createQuery("select m from CourseEvent e inner join e.meetings m inner join e.relatedCourses o, StudentClassEnrollment s where e.reqAttendance=true and m.approvalStatus = 1 and m.meetingDate=:meetingDate and m.startPeriod < :endSlot and m.stopPeriod > :startSlot and s.student.uniqueId=:studentId and ((o.ownerType=:classType and s.clazz.uniqueId=o.ownerId) or (o.ownerType=:configType and s.clazz.schedulingSubpart.instrOfferingConfig.uniqueId=o.ownerId) or (o.ownerType=:courseType and s.courseOffering.uniqueId=o.ownerId) or (o.ownerType=:offeringType and s.courseOffering.instructionalOffering.uniqueId=o.ownerId))", Meeting.class).setParameter("studentId", (Object)student.getUniqueId()).setParameter("meetingDate", (Object)this.getPeriod().getStartDate()).setParameter("startSlot", (Object)(this.getPeriod().getStartSlot() - nrTravelSlots)).setParameter("endSlot", (Object)(this.getPeriod().getEndSlot() + nrTravelSlots)).setParameter("classType", (Object)3).setParameter("configType", (Object)2).setParameter("courseType", (Object)1).setParameter("offeringType", (Object)0).setCacheable(true).list().iterator();
                while (i.hasNext()) {
                    this.iDirects.add(new DirectConflict((Meeting)i.next(), studentIds));
                }
                i = ExamDAO.getInstance().getSession().createQuery("select m from ExamEvent e inner join e.meetings m inner join e.exam.owners o, StudentClassEnrollment s where e.exam.examType.uniqueId != :examTypeId and m.approvalStatus = 1 and m.meetingDate=:meetingDate and m.startPeriod < :endSlot and m.stopPeriod > :startSlot and s.student.uniqueId=:studentId and ((o.ownerType=:classType and s.clazz.uniqueId=o.ownerId) or (o.ownerType=:configType and s.clazz.schedulingSubpart.instrOfferingConfig.uniqueId=o.ownerId) or (o.ownerType=:courseType and s.courseOffering.uniqueId=o.ownerId) or (o.ownerType=:offeringType and s.courseOffering.instructionalOffering.uniqueId=o.ownerId))", Meeting.class).setParameter("studentId", (Object)student.getUniqueId()).setParameter("meetingDate", (Object)this.getPeriod().getStartDate()).setParameter("startSlot", (Object)(this.getPeriod().getStartSlot() - nrTravelSlots)).setParameter("endSlot", (Object)(this.getPeriod().getEndSlot() + nrTravelSlots)).setParameter("classType", (Object)3).setParameter("configType", (Object)2).setParameter("courseType", (Object)1).setParameter("offeringType", (Object)0).setParameter("examTypeId", (Object)this.getPeriod().getExamType().getUniqueId()).setCacheable(true).list().iterator();
                while (i.hasNext()) {
                    this.iDirects.add(new DirectConflict((Meeting)i.next(), studentIds));
                }
            }
        }
    }

    public static class DirectConflict
    implements Serializable,
    Comparable<DirectConflict> {
        private static final long serialVersionUID = 1300925620564937810L;
        protected ExamAssignment iOtherExam = null;
        protected int iNrStudents = 1;
        protected Vector<Long> iStudents = new Vector();
        protected String iOtherEventName = null;
        protected String iOtherEventTime = null;
        protected String iOtherEventDate = null;
        protected String iOtherEventRoom = null;
        protected int iOtherEventSize = 0;
        protected Long iOtherEventId;
        protected transient Event iOtherEvent = null;

        protected DirectConflict(ExamAssignment otherExam) {
            this.iOtherExam = otherExam;
        }

        protected DirectConflict(ExamAssignment otherExam, ExamConflict conflict, boolean students) {
            this.iOtherExam = otherExam;
            if (students) {
                this.iNrStudents = conflict.getStudents().size();
                for (Student student : conflict.getStudents()) {
                    this.iStudents.add(student.getUniqueId());
                }
            } else {
                this.iNrStudents = conflict.getInstructors().size();
                for (DepartmentalInstructor instructor : conflict.getInstructors()) {
                    this.iStudents.add(instructor.getUniqueId());
                }
            }
        }

        protected DirectConflict(Meeting otherMeeting) {
            this.iOtherEvent = otherMeeting.getEvent();
            this.iOtherEventSize = otherMeeting.getEvent().getStudentIds().size();
            this.iOtherEventId = otherMeeting.getEvent().getUniqueId();
            this.iOtherEventName = otherMeeting.getEvent().getEventName();
            this.iOtherEventDate = otherMeeting.dateStr();
            this.iOtherEventTime = otherMeeting.startTime() + " - " + otherMeeting.stopTime();
            this.iOtherEventRoom = otherMeeting.getRoomLabel();
        }

        protected void addMeeting(Meeting otherMeeting) {
            if (otherMeeting.getLocation() != null) {
                this.iOtherEventRoom = this.iOtherEventRoom + (this.iOtherEventRoom != null && this.iOtherEventRoom.length() > 0 ? ", " : "") + otherMeeting.getRoomLabel();
            }
        }

        protected DirectConflict(Meeting otherMeeting, Collection<Long> studentIds) {
            this(otherMeeting);
            this.iNrStudents = studentIds.size();
            this.iStudents.addAll(studentIds);
        }

        protected DirectConflict(ExamResourceUnavailability unavailability, Vector<Long> studentIds) {
            this.iOtherEventId = unavailability.getId();
            this.iOtherEventSize = unavailability.getSize();
            this.iOtherEventName = unavailability.getName();
            this.iOtherEventTime = unavailability.getTime();
            this.iOtherEventDate = unavailability.getDate();
            this.iOtherEventRoom = unavailability.getRoom();
            this.iNrStudents = studentIds.size();
            this.iStudents = studentIds;
        }

        protected void incNrStudents() {
            ++this.iNrStudents;
        }

        public int getNrStudents() {
            return this.iNrStudents;
        }

        public Vector<Long> getStudents() {
            return this.iStudents;
        }

        public ExamAssignment getOtherExam() {
            return this.iOtherExam;
        }

        public Long getOtherEventId() {
            return this.iOtherEventId;
        }

        public Event getOtherEvent() {
            if (this.iOtherEvent != null) {
                return this.iOtherEvent;
            }
            if (this.iOtherEventId == null) {
                return null;
            }
            this.iOtherEvent = (Event)EventDAO.getInstance().get(this.iOtherEventId);
            return this.iOtherEvent;
        }

        public String getOtherEventName() {
            return this.iOtherEventName;
        }

        public String getOtherEventRoom() {
            return this.iOtherEventRoom;
        }

        public String getOtherEventDate() {
            return this.iOtherEventDate;
        }

        public String getOtherEventTime() {
            return this.iOtherEventTime;
        }

        public int getOtherEventSize() {
            return this.iOtherEventSize;
        }

        public boolean isOtherClass() {
            return this.getOtherEvent() != null && this.getOtherEvent().getEventType() == 0;
        }

        public Class_ getOtherClass() {
            if (!this.isOtherClass()) {
                return null;
            }
            if (!(this.iOtherEvent instanceof ClassEvent)) {
                this.iOtherEvent = (Event)ClassEventDAO.getInstance().get(this.getOtherEventId());
            }
            return ((ClassEvent)this.iOtherEvent).getClazz();
        }

        @Override
        public int compareTo(DirectConflict c) {
            int cmp = -Double.compare(this.getNrStudents(), c.getNrStudents());
            if (cmp != 0) {
                return cmp;
            }
            if (this.getOtherExam() == null) {
                if (c.getOtherExam() == null) {
                    cmp = (this.getOtherEventName() == null ? "" : this.getOtherEventName()).compareTo(c.getOtherEventName() == null ? "" : c.getOtherEventName());
                    if (cmp != 0) {
                        return cmp;
                    }
                    return (this.getOtherEventId() == null ? Long.valueOf(0L) : this.getOtherEventId()).compareTo(c.getOtherEventId() == null ? Long.valueOf(0L) : c.getOtherEventId());
                }
                return -1;
            }
            if (c.getOtherExam() == null) {
                return 1;
            }
            return this.getOtherExam().compareTo(c.getOtherExam());
        }

        public String toString() {
            return this.toString(false);
        }

        public String toString(boolean links) {
            Object ret = "";
            ret = links && this.getOtherExam() != null ? (String)ret + "<tr onmouseover=\"this.style.backgroundColor='rgb(223,231,242)';this.style.cursor='hand';this.style.cursor='pointer';\" onmouseout=\"this.style.backgroundColor='transparent';\" onclick=\"document.location='examInfo.action?examId=" + this.getOtherExam().getExamId() + "&op=Select&noCacheTS=" + new Date().getTime() + "';\">" : (String)ret + "<tr onmouseover=\"this.style.backgroundColor='rgb(223,231,242)';\" onmouseout=\"this.style.backgroundColor='transparent';\">";
            ret = (String)ret + "<td style='font-weight:bold;color:" + PreferenceLevel.prolog2color("P") + ";'>";
            ret = (String)ret + String.valueOf(this.getNrStudents());
            ret = (String)ret + "</td>";
            ret = (String)ret + "<td style='font-weight:bold;color:" + PreferenceLevel.prolog2color("P") + ";'>";
            ret = (String)ret + (this.getOtherExam() == null ? (this.isOtherClass() ? ExamAssignment.MSG.typeClass() : ExamAssignment.MSG.typeEvent()) : ExamAssignment.MSG.conflictDirect());
            ret = (String)ret + "</td>";
            if (this.getOtherExam() == null) {
                if (this.iOtherEventName != null) {
                    ret = (String)ret + "<td>" + this.iOtherEventName + "</td>";
                    ret = (String)ret + "<td>" + this.iOtherEventDate + " " + this.iOtherEventTime + "</td>";
                    ret = (String)ret + "<td>" + this.iOtherEventRoom + "</td>";
                } else {
                    ret = (String)ret + "<td colspan='3'>" + ExamAssignment.MSG.infoNotAvailableForUnknownReason() + "</td>";
                }
            } else {
                ret = (String)ret + "<td>" + this.getOtherExam().getExamNameHtml() + "</td>";
                ret = (String)ret + "<td>" + this.getOtherExam().getPeriodAbbreviationWithPref() + "</td>";
                ret = (String)ret + "<td>" + this.getOtherExam().getRoomsNameWithPref(", ") + "</td>";
            }
            ret = (String)ret + "</tr>";
            return ret;
        }
    }

    public static class BackToBackConflict
    implements Serializable,
    Comparable<BackToBackConflict> {
        private static final long serialVersionUID = 4953777429653205613L;
        protected ExamAssignment iOtherExam;
        protected int iNrStudents = 1;
        protected boolean iIsDistance = false;
        protected Vector<Long> iStudents = new Vector();
        protected double iDistance = 0.0;

        protected BackToBackConflict(ExamAssignment otherExam, boolean isDistance, double distance) {
            this.iOtherExam = otherExam;
            this.iIsDistance = isDistance;
            this.iDistance = distance;
        }

        protected BackToBackConflict(ExamAssignment otherExam, ExamConflict conflict, boolean students) {
            this.iOtherExam = otherExam;
            if (students) {
                this.iNrStudents = conflict.getStudents().size();
                for (Student student : conflict.getStudents()) {
                    this.iStudents.add(student.getUniqueId());
                }
            } else {
                this.iNrStudents = conflict.getInstructors().size();
                for (DepartmentalInstructor instructor : conflict.getInstructors()) {
                    this.iStudents.add(instructor.getUniqueId());
                }
            }
            this.iIsDistance = conflict.isDistanceBackToBackConflict();
            this.iDistance = conflict.getDistance();
        }

        protected void incNrStudents() {
            ++this.iNrStudents;
        }

        public int getNrStudents() {
            return this.iNrStudents;
        }

        public boolean isDistance() {
            return this.iIsDistance;
        }

        public ExamAssignment getOtherExam() {
            return this.iOtherExam;
        }

        public Vector<Long> getStudents() {
            return this.iStudents;
        }

        public double getDistance() {
            return this.iDistance;
        }

        @Override
        public int compareTo(BackToBackConflict c) {
            int cmp = -Double.compare(this.getNrStudents(), c.getNrStudents());
            if (cmp != 0) {
                return cmp;
            }
            if (this.isDistance() != c.isDistance()) {
                return this.isDistance() ? -1 : 1;
            }
            return this.getOtherExam().compareTo(c.getOtherExam());
        }

        public String toString() {
            return this.toString(false);
        }

        public String toString(boolean links) {
            Object ret = "";
            ret = links && this.getOtherExam() != null ? (String)ret + "<tr onmouseover=\"this.style.backgroundColor='rgb(223,231,242)';this.style.cursor='hand';this.style.cursor='pointer';\" onmouseout=\"this.style.backgroundColor='transparent';\" onclick=\"document.location='examInfo.action?examId=" + this.getOtherExam().getExamId() + "&op=Select&noCacheTS=" + new Date().getTime() + "';\">" : (String)ret + "<tr onmouseover=\"this.style.backgroundColor='rgb(223,231,242)';\" onmouseout=\"this.style.backgroundColor='transparent';\">";
            ret = (String)ret + "<td style='font-weight:bold;color:" + PreferenceLevel.prolog2color("1") + ";'>";
            ret = (String)ret + String.valueOf(this.getNrStudents());
            ret = (String)ret + "</td>";
            ret = (String)ret + "<td style='font-weight:bold;color:" + PreferenceLevel.prolog2color("1") + ";'>";
            ret = (String)ret + ExamAssignment.MSG.conflictBackToBack();
            if (this.isDistance()) {
                ret = (String)ret + "<br>(" + Math.round(10.0 * this.getDistance()) + " m)";
            }
            ret = (String)ret + "</td>";
            ret = (String)ret + "<td>" + this.getOtherExam().getExamNameHtml() + "</td>";
            ret = (String)ret + "<td>" + this.getOtherExam().getPeriodAbbreviationWithPref() + "</td>";
            ret = (String)ret + "<td>" + this.getOtherExam().getRoomsNameWithPref(", ") + "</td>";
            ret = (String)ret + "</tr>";
            return ret;
        }
    }

    public static class MoreThanTwoADayConflict
    implements Serializable,
    Comparable<MoreThanTwoADayConflict> {
        private static final long serialVersionUID = -8320516715119699996L;
        protected TreeSet<ExamAssignment> iOtherExams;
        protected int iNrStudents = 1;
        protected Vector<Long> iStudents = new Vector();

        protected MoreThanTwoADayConflict(TreeSet<ExamAssignment> otherExams) {
            this.iOtherExams = otherExams;
        }

        protected MoreThanTwoADayConflict(TreeSet<ExamAssignment> otherExams, ExamConflict conflict, boolean students) {
            this.iOtherExams = otherExams;
            if (students) {
                this.iNrStudents = conflict.getStudents().size();
                for (Student student : conflict.getStudents()) {
                    this.iStudents.add(student.getUniqueId());
                }
            } else {
                this.iNrStudents = conflict.getInstructors().size();
                for (DepartmentalInstructor instructor : conflict.getInstructors()) {
                    this.iStudents.add(instructor.getUniqueId());
                }
            }
        }

        protected void incNrStudents() {
            ++this.iNrStudents;
        }

        public int getNrStudents() {
            return this.iNrStudents;
        }

        public Vector<Long> getStudents() {
            return this.iStudents;
        }

        public TreeSet<ExamAssignment> getOtherExams() {
            return this.iOtherExams;
        }

        @Override
        public int compareTo(MoreThanTwoADayConflict c) {
            int cmp = -Double.compare(this.getNrStudents(), c.getNrStudents());
            if (cmp != 0) {
                return cmp;
            }
            cmp = -Double.compare(this.getOtherExams().size(), c.getOtherExams().size());
            if (cmp != 0) {
                return cmp;
            }
            Iterator<ExamAssignment> i1 = this.getOtherExams().iterator();
            Iterator<ExamAssignment> i2 = c.getOtherExams().iterator();
            while (i1.hasNext()) {
                ExamAssignment a2;
                ExamAssignment a1 = i1.next();
                if (a1.equals(a2 = i2.next())) continue;
                return a1.compareTo(a2);
            }
            return 0;
        }

        public String toString() {
            return this.toString(false);
        }

        public String toString(boolean links) {
            Object ret = "";
            Object mouseOver = "";
            Object mouseOut = "";
            Object id = "";
            Iterator<ExamAssignment> i = this.getOtherExams().iterator();
            while (i.hasNext()) {
                ExamAssignment a = i.next();
                id = (String)id + a.getExamId();
                if (!i.hasNext()) continue;
                id = (String)id + ":";
            }
            int idx = 0;
            Vector<Long> ids = new Vector<Long>();
            for (ExamAssignment a : this.getOtherExams()) {
                ids.add(a.getExamId());
                mouseOver = (String)mouseOver + "document.getElementById('" + (String)id + ":" + idx + "').style.backgroundColor='rgb(223,231,242)';";
                if (links) {
                    mouseOver = (String)mouseOver + "this.style.cursor='hand';this.style.cursor='pointer';";
                }
                mouseOut = (String)mouseOut + "document.getElementById('" + (String)id + ":" + idx + "').style.backgroundColor='transparent';";
                ++idx;
            }
            idx = 0;
            ret = links ? (String)ret + "<tr id='" + (String)id + ":" + idx + "' onmouseover=\"" + (String)mouseOver + "\" onmouseout=\"" + (String)mouseOut + "\" onclick=\"document.location='examInfo.action?examId=" + ids.elementAt(idx) + "&op=Select&noCacheTS=" + new Date().getTime() + "';\">" : (String)ret + "<tr id='" + (String)id + ":" + idx + "' onmouseover=\"" + (String)mouseOver + "\" onmouseout=\"" + (String)mouseOut + "\">";
            ret = (String)ret + "<td valign='top' rowspan='" + this.getOtherExams().size() + "' style='font-weight:bold;color:" + PreferenceLevel.prolog2color("2") + ";'>";
            ret = (String)ret + String.valueOf(this.getNrStudents());
            ret = (String)ret + "</td>";
            ret = (String)ret + "<td valign='top' rowspan='" + this.getOtherExams().size() + "' style='font-weight:bold;color:" + PreferenceLevel.prolog2color("2") + ";'>";
            ret = (String)ret + ExamAssignment.MSG.conflictMoreThanTwoADay().replace(">", "&gt;");
            ret = (String)ret + "</td>";
            Iterator<ExamAssignment> i2 = this.getOtherExams().iterator();
            while (i2.hasNext()) {
                ExamAssignment a;
                a = i2.next();
                ret = (String)ret + "<td>" + a.getExamNameHtml() + "</td>";
                ret = (String)ret + "<td>" + a.getPeriodAbbreviationWithPref() + "</td>";
                ret = (String)ret + "<td>" + a.getRoomsNameWithPref(", ") + "</td>";
                ret = (String)ret + "</tr>";
                if (i2.hasNext()) {
                    ret = links ? (String)ret + "<tr id='" + (String)id + ":" + (1 + idx) + "' onmouseover=\"" + (String)mouseOver + "\" onmouseout=\"" + (String)mouseOut + "\" onclick=\"document.location='examInfo.action?examId=" + ids.elementAt(1 + idx) + "&op=Select&noCacheTS=" + new Date().getTime() + "';\">" : (String)ret + "<tr id='" + (String)id + ":" + (1 + idx) + "' onmouseover=\"" + (String)mouseOver + "\" onmouseout=\"" + (String)mouseOut + "\">";
                }
                ++idx;
            }
            return ret;
        }
    }

    public static class DistributionConflict
    implements Serializable,
    Comparable<DistributionConflict> {
        private static final long serialVersionUID = -1985853750381140103L;
        protected TreeSet<ExamInfo> iOtherExams;
        protected String iPreference;
        protected Long iId;
        protected String iType;
        protected transient DistributionPref iPref = null;

        protected DistributionConflict(Long id, String type, TreeSet<ExamInfo> otherExams, String preference) {
            this.iId = id;
            this.iType = type;
            this.iOtherExams = otherExams;
            this.iPreference = preference;
        }

        protected DistributionConflict(ExamDistributionConstraint dc, Exam exclude, Assignment<Exam, ExamPlacement> assignment) {
            this.iId = dc.getId();
            this.iType = dc.getTypeString();
            this.iOtherExams = new TreeSet();
            for (Exam exam : dc.variables()) {
                if (exam.equals((Object)exclude)) continue;
                this.iOtherExams.add(assignment.getValue((Variable)exam) == null ? new ExamInfo(exam) : new ExamAssignment(exam, (ExamPlacement)assignment.getValue((Variable)exam), assignment));
            }
            this.iPreference = dc.isHard() ? "R" : (dc.getWeight() >= 2 ? "-2" : "-1");
        }

        protected DistributionConflict(DistributionPref pref, org.unitime.timetable.model.Exam exclude) {
            this.iPref = pref;
            this.iId = pref.getUniqueId();
            this.iType = pref.getDistributionType().getLabel();
            this.iOtherExams = new TreeSet();
            for (DistributionObject dObj : pref.getDistributionObjects()) {
                org.unitime.timetable.model.Exam exam = (org.unitime.timetable.model.Exam)dObj.getPrefGroup();
                if (exam.equals(exclude)) continue;
                this.iOtherExams.add(exam.getAssignedPeriod() == null ? new ExamInfo(exam) : new ExamAssignment(exam));
            }
            this.iPreference = pref.getPrefLevel().getPrefProlog();
        }

        public Long getId() {
            return this.iId;
        }

        public String getType() {
            return this.iType;
        }

        public String getTypeHtml() {
            String title = PreferenceLevel.prolog2string(this.getPreference()) + " " + this.getType() + " with ";
            Iterator<ExamInfo> i = this.getOtherExams().iterator();
            while (i.hasNext()) {
                ExamInfo a = i.next();
                title = title + a.getExamName();
                if (!i.hasNext()) continue;
                title = title + " and ";
            }
            return "<span style='font-weight:bold;color:" + PreferenceLevel.prolog2color(this.getPreference()) + ";' title='" + title + "'>" + this.iType + "</span>";
        }

        public String getPreference() {
            return this.iPreference;
        }

        public TreeSet<ExamInfo> getOtherExams() {
            return this.iOtherExams;
        }

        public int hashCode() {
            return this.getId().hashCode();
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof DistributionConflict)) {
                return false;
            }
            DistributionConflict c = (DistributionConflict)o;
            return this.getId().equals(c.getId());
        }

        @Override
        public int compareTo(DistributionConflict c) {
            Iterator<ExamInfo> i1 = this.getOtherExams().iterator();
            Iterator<ExamInfo> i2 = c.getOtherExams().iterator();
            while (i1.hasNext() && i2.hasNext()) {
                ExamInfo a2;
                ExamInfo a1 = i1.next();
                if (a1.equals(a2 = i2.next())) continue;
                return a1.compareTo(a2);
            }
            return this.getId().compareTo(c.getId());
        }

        public String toString() {
            return this.toString(false);
        }

        public String toString(boolean links) {
            Object ret = "";
            Object mouseOver = "";
            Object mouseOut = "";
            Object id = "";
            Iterator<ExamInfo> i = this.getOtherExams().iterator();
            while (i.hasNext()) {
                ExamInfo a = i.next();
                id = (String)id + a.getExamId();
                if (!i.hasNext()) continue;
                id = (String)id + ":";
            }
            int idx = 0;
            Vector<Long> ids = new Vector<Long>();
            for (ExamInfo a : this.getOtherExams()) {
                ids.add(a.getExamId());
                mouseOver = (String)mouseOver + "document.getElementById('" + (String)id + ":" + idx + "').style.backgroundColor='rgb(223,231,242)';";
                if (links) {
                    mouseOver = (String)mouseOver + "this.style.cursor='hand';this.style.cursor='pointer';";
                }
                mouseOut = (String)mouseOut + "document.getElementById('" + (String)id + ":" + idx + "').style.backgroundColor='transparent';";
                ++idx;
            }
            idx = 0;
            ret = links ? (String)ret + "<tr id='" + (String)id + ":" + idx + "' onmouseover=\"" + (String)mouseOver + "\" onmouseout=\"" + (String)mouseOut + "\" onclick=\"document.location='examInfo.action?examId=" + ids.elementAt(idx) + "&op=Select&noCacheTS=" + new Date().getTime() + "';\">" : (String)ret + "<tr id='" + (String)id + ":" + idx + "' onmouseover=\"" + (String)mouseOver + "\" onmouseout=\"" + (String)mouseOut + "\">";
            ret = (String)ret + "<td valign='top' rowspan='" + this.getOtherExams().size() + "' style='font-weight:bold;color:" + PreferenceLevel.prolog2color(this.getPreference()) + ";'>";
            ret = (String)ret + PreferenceLevel.prolog2string(this.getPreference());
            ret = (String)ret + "</td>";
            ret = (String)ret + "<td valign='top' rowspan='" + this.getOtherExams().size() + "' style='font-weight:bold;color:" + PreferenceLevel.prolog2color(this.getPreference()) + ";'>";
            ret = (String)ret + this.getType();
            ret = (String)ret + "</td>";
            Iterator<ExamInfo> i2 = this.getOtherExams().iterator();
            while (i2.hasNext()) {
                ExamInfo a;
                a = i2.next();
                ret = (String)ret + "<td>" + a.getExamNameHtml() + "</td>";
                if (a instanceof ExamAssignment) {
                    ExamAssignment ea = (ExamAssignment)a;
                    ret = (String)ret + "<td>" + ea.getPeriodAbbreviationWithPref() + "</td>";
                    ret = (String)ret + "<td>" + ea.getRoomsNameWithPref(", ") + "</td>";
                } else {
                    ret = (String)ret + "<td></td>";
                    ret = (String)ret + "<td></td>";
                }
                ret = (String)ret + "</tr>";
                if (i2.hasNext()) {
                    ret = links ? (String)ret + "<tr id='" + (String)id + ":" + (1 + idx) + "' onmouseover=\"" + (String)mouseOver + "\" onmouseout=\"" + (String)mouseOut + "\" onclick=\"document.location='examInfo.action?examId=" + ids.elementAt(1 + idx) + "&op=Select&noCacheTS=" + new Date().getTime() + "';\">" : (String)ret + "<tr id='" + (String)id + ":" + (1 + idx) + "' onmouseover=\"" + (String)mouseOver + "\" onmouseout=\"" + (String)mouseOut + "\">";
                }
                ++idx;
            }
            return ret;
        }
    }

    public static class Parameters {
        private int iBtbDistance = -1;
        private boolean iBtbDayBreak = false;
        private Set iPeriods;

        public Parameters(Long sessionId, Long examTypeId) {
            SolverParameterDef btbDayBreakDef;
            this.iPeriods = ExamPeriod.findAll(sessionId, examTypeId);
            SolverParameterDef btbDistDef = SolverParameterDef.findByNameType("Exams.BackToBackDistance", SolverParameterGroup.SolverType.EXAM);
            if (btbDistDef != null && btbDistDef.getDefault() != null) {
                this.iBtbDistance = Integer.parseInt(btbDistDef.getDefault());
            }
            if ((btbDayBreakDef = SolverParameterDef.findByNameType("Exams.IsDayBreakBackToBack", SolverParameterGroup.SolverType.EXAM)) != null && btbDayBreakDef.getDefault() != null) {
                this.iBtbDayBreak = "true".equals(btbDayBreakDef.getDefault());
            }
        }

        public int getBackToBackDistance() {
            return this.iBtbDistance;
        }

        public boolean isDayBreakBackToBack() {
            return this.iBtbDayBreak;
        }

        public boolean isBackToBack(ExamPeriod p1, ExamPeriod p2) {
            if (!this.isDayBreakBackToBack() && !p1.getDateOffset().equals(p2.getDateOffset())) {
                return false;
            }
            for (ExamPeriod p : this.iPeriods) {
                if (p1.compareTo(p) < 0 && p.compareTo(p2) < 0) {
                    return false;
                }
                if (p1.compareTo(p) <= 0 || p.compareTo(p2) <= 0) continue;
                return false;
            }
            return true;
        }
    }
}

