/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.exam;

import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.cpsolver.exam.model.Exam;
import org.cpsolver.exam.model.ExamModel;
import org.cpsolver.exam.model.ExamPeriodPlacement;
import org.cpsolver.exam.model.ExamPlacement;
import org.cpsolver.exam.model.ExamRoomPlacement;
import org.cpsolver.exam.model.ExamStudent;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;
import org.unitime.timetable.solver.exam.ExamSolver;
import org.unitime.timetable.solver.exam.ui.ExamAssignment;
import org.unitime.timetable.solver.exam.ui.ExamAssignmentInfo;
import org.unitime.timetable.solver.exam.ui.ExamProposedChange;

public class ExamSuggestions {
    private ExamSolver iSolver;
    private ExamModel iModel;
    private Assignment<Exam, ExamPlacement> iAssignment;
    private Hashtable<Exam, ExamPlacement> iInitialAssignment;
    private Hashtable<Exam, ExamAssignment> iInitialInfo;
    private Vector<Exam> iInitialUnassignment;
    private TreeSet<ExamProposedChange> iSuggestions;
    private Vector<Exam> iResolvedExams;
    private Hashtable<Exam, ExamPlacement> iConflictsToResolve;
    private Exam iExam;
    private int iDepth = 2;
    private int iLimit = 20;
    private int iNrSolutions = 0;
    private int iNrCombinationsConsidered = 0;
    private long iTimeOut = 5000L;
    private long iStartTime = 0L;
    private boolean iTimeoutReached = false;
    private String iFilter = null;

    public ExamSuggestions(ExamSolver solver) {
        this.iSolver = solver;
        this.iModel = (ExamModel)solver.currentSolution().getModel();
        this.iAssignment = solver.currentSolution().getAssignment();
        this.iInitialAssignment = new Hashtable();
        this.iInitialUnassignment = new Vector();
        this.iInitialInfo = new Hashtable();
        for (Exam exam : this.iModel.variables()) {
            ExamPlacement placement = (ExamPlacement)this.iAssignment.getValue((Variable)exam);
            if (placement == null) {
                this.iInitialUnassignment.add(exam);
                continue;
            }
            this.iInitialAssignment.put(exam, placement);
            this.iInitialInfo.put(exam, new ExamAssignment(exam, placement, this.iAssignment));
        }
    }

    public int getDepth() {
        return this.iDepth;
    }

    public void setDepth(int depth) {
        this.iDepth = depth;
    }

    public int getLimit() {
        return this.iLimit;
    }

    public void setLimit(int limit) {
        this.iLimit = limit;
    }

    public long getTimeOut() {
        return this.iTimeOut;
    }

    public void setTimeOut(long timeOut) {
        this.iTimeOut = timeOut;
    }

    public String getFilter() {
        return this.iFilter;
    }

    public void setFilter(String filter) {
        this.iFilter = filter;
    }

    public int getNrSolutions() {
        return this.iNrSolutions;
    }

    public int getNrCombinationsConsidered() {
        return this.iNrCombinationsConsidered;
    }

    public boolean wasTimeoutReached() {
        return this.iTimeoutReached;
    }

    public boolean match(String name) {
        if (this.iFilter == null || this.iFilter.trim().length() == 0) {
            return true;
        }
        String n = name.toUpperCase();
        StringTokenizer stk1 = new StringTokenizer(this.iFilter.toUpperCase(), ";");
        while (stk1.hasMoreTokens()) {
            StringTokenizer stk2 = new StringTokenizer(stk1.nextToken(), " ,");
            boolean match = true;
            while (match && stk2.hasMoreTokens()) {
                String token = stk2.nextToken().trim();
                if (token.length() == 0) continue;
                if (token.indexOf(42) >= 0 || token.indexOf(63) >= 0) {
                    try {
                        String tokenRegExp = "\\s+" + token.replaceAll("\\.", "\\.").replaceAll("\\?", ".+").replaceAll("\\*", ".*") + "\\s";
                        if (Pattern.compile(tokenRegExp).matcher(" " + n + " ").find()) continue;
                        match = false;
                    }
                    catch (PatternSyntaxException e) {
                        match = false;
                    }
                    continue;
                }
                if (n.indexOf(token) >= 0) continue;
                match = false;
            }
            if (!match) continue;
            return true;
        }
        return false;
    }

    public synchronized TreeSet<ExamProposedChange> computeSuggestions(Exam exam, Collection<ExamAssignmentInfo> givenAssignments) {
        this.iSuggestions = new TreeSet();
        this.iResolvedExams = new Vector();
        this.iConflictsToResolve = new Hashtable();
        this.iNrSolutions = 0;
        this.iNrCombinationsConsidered = 0;
        this.iTimeoutReached = false;
        this.iExam = exam;
        if (givenAssignments != null) {
            for (ExamAssignment examAssignment : givenAssignments) {
                ExamPlacement placement = this.iSolver.getPlacement(examAssignment);
                if (placement == null || ((Exam)placement.variable()).equals((Object)exam)) continue;
                Set conflicts = this.iModel.conflictValues(this.iAssignment, (Value)placement);
                for (ExamPlacement conflictPlacement : conflicts) {
                    this.iConflictsToResolve.put((Exam)conflictPlacement.variable(), conflictPlacement);
                    this.iAssignment.unassign(0L, (Variable)((Exam)conflictPlacement.variable()));
                }
                this.iResolvedExams.add((Exam)placement.variable());
                this.iConflictsToResolve.remove((Exam)placement.variable());
                this.iAssignment.assign(0L, (Value)placement);
            }
        }
        this.iStartTime = System.currentTimeMillis();
        this.backtrack(this.iDepth);
        for (Exam exam2 : this.iInitialUnassignment) {
            if (this.iAssignment.getValue((Variable)exam2) == null) continue;
            this.iAssignment.unassign(0L, (Variable)exam2);
        }
        for (Map.Entry entry : this.iInitialAssignment.entrySet()) {
            if (((ExamPlacement)entry.getValue()).equals((Object)this.iAssignment.getValue((Variable)((Exam)entry.getKey())))) continue;
            this.iAssignment.assign(0L, (Value)((ExamPlacement)entry.getValue()));
        }
        return this.iSuggestions;
    }

    public Set findBestAvailableRooms(Exam exam, ExamPeriodPlacement period, boolean checkConstraints) {
        if (exam.getMaxRooms() == 0) {
            return new HashSet();
        }
        block0: for (int nrRooms = 1; nrRooms <= exam.getMaxRooms(); ++nrRooms) {
            int size;
            int bestSize;
            HashSet<ExamRoomPlacement> rooms = new HashSet<ExamRoomPlacement>();
            for (size = 0; rooms.size() < nrRooms && size < exam.getSize(); size += bestSize) {
                int minSize = (exam.getSize() - size) / (nrRooms - rooms.size());
                ExamRoomPlacement best = null;
                bestSize = 0;
                int bestPenalty = 0;
                for (ExamRoomPlacement room : exam.getRoomPlacements()) {
                    if (!room.isAvailable(period.getPeriod()) || checkConstraints && room.getRoom().inConflict(this.iAssignment, exam, period.getPeriod()) || rooms.contains(room) || checkConstraints && !exam.checkDistributionConstraints(this.iAssignment, room)) continue;
                    int s = room.getSize(exam.hasAltSeating());
                    if (s < minSize) break;
                    int p = room.getPenalty(period.getPeriod());
                    if (best != null && bestPenalty <= p && (bestPenalty != p || bestSize <= s)) continue;
                    best = room;
                    bestSize = s;
                    bestPenalty = p;
                }
                if (best == null) continue block0;
                rooms.add(best);
            }
            if (size < exam.getSize()) continue;
            return rooms;
        }
        return null;
    }

    private void tryPlacement(ExamPlacement placement, int depth) {
        if (placement.equals((Object)this.iAssignment.getValue((Variable)((Exam)placement.variable())))) {
            return;
        }
        if (((Exam)placement.variable()).equals((Object)this.iExam) && !this.match(placement.getPeriod().toString() + " " + placement.getRoomName(", "))) {
            return;
        }
        Set conflicts = this.iModel.conflictValues(this.iAssignment, (Value)placement);
        this.tryPlacement(placement, depth, conflicts);
        if (this.iConflictsToResolve.size() + conflicts.size() < depth) {
            Exam exam = (Exam)placement.variable();
            HashSet<ExamPlacement> adepts = new HashSet<ExamPlacement>();
            for (ExamStudent s : exam.getStudents()) {
                Set exams = s.getExams(this.iAssignment, placement.getPeriod());
                Iterator i = exams.iterator();
                while (i.hasNext()) {
                    ExamPlacement conf = (ExamPlacement)this.iAssignment.getValue((Variable)((Exam)i.next()));
                    if (conf == null || conflicts.contains(conf) || this.iResolvedExams.contains((Exam)conf.variable())) continue;
                    adepts.add(conf);
                }
            }
            for (ExamPlacement adept : adepts) {
                conflicts.add(adept);
                this.tryPlacement(placement, depth, conflicts);
                conflicts.remove(adept);
            }
            if (this.iConflictsToResolve.size() + conflicts.size() + 1 < depth) {
                for (ExamPlacement a1 : adepts) {
                    conflicts.add(a1);
                    for (ExamPlacement a2 : adepts) {
                        if (((Exam)a2.variable()).getId() >= ((Exam)a1.variable()).getId()) continue;
                        conflicts.add(a2);
                        this.tryPlacement(placement, depth, conflicts);
                        conflicts.remove(a2);
                    }
                    conflicts.remove(a1);
                }
            }
        }
    }

    private void tryPlacement(ExamPlacement placement, int depth, Set conflicts) {
        ++this.iNrCombinationsConsidered;
        if (this.iConflictsToResolve.size() + conflicts.size() > depth) {
            return;
        }
        for (ExamPlacement c : conflicts) {
            if (!this.iResolvedExams.contains((Exam)c.variable())) continue;
            return;
        }
        Exam exam = (Exam)placement.variable();
        ExamPlacement cur = (ExamPlacement)this.iAssignment.getValue((Variable)exam);
        if (conflicts != null) {
            for (ExamPlacement c : conflicts) {
                this.iAssignment.unassign(0L, (Variable)((Exam)c.variable()));
            }
        }
        this.iAssignment.assign(0L, (Value)placement);
        for (ExamPlacement c : conflicts) {
            this.iConflictsToResolve.put((Exam)c.variable(), c);
        }
        ExamPlacement resolvedConf = this.iConflictsToResolve.remove(exam);
        this.backtrack(depth - 1);
        if (cur == null) {
            this.iAssignment.unassign(0L, (Variable)exam);
        } else {
            this.iAssignment.assign(0L, (Value)cur);
        }
        for (ExamPlacement p : conflicts) {
            this.iAssignment.assign(0L, (Value)p);
            this.iConflictsToResolve.remove((Exam)p.variable());
        }
        if (resolvedConf != null) {
            this.iConflictsToResolve.put(exam, resolvedConf);
        }
    }

    private void backtrack(int depth) {
        Exam exam;
        if (this.iDepth > depth && this.iConflictsToResolve.isEmpty()) {
            if (this.iSuggestions.size() == this.iLimit && this.iSuggestions.last().isBetter(this.iModel, this.iAssignment)) {
                return;
            }
            this.iSuggestions.add(new ExamProposedChange(this.iModel, this.iAssignment, this.iInitialAssignment, this.iInitialInfo, this.iConflictsToResolve.values(), this.iResolvedExams));
            ++this.iNrSolutions;
            if (this.iSuggestions.size() > this.iLimit) {
                this.iSuggestions.remove(this.iSuggestions.last());
            }
            return;
        }
        if (depth <= 0) {
            return;
        }
        if (this.iTimeOut > 0L && System.currentTimeMillis() - this.iStartTime > this.iTimeOut) {
            this.iTimeoutReached = true;
            return;
        }
        Exam exam2 = exam = this.iDepth == depth && !this.iResolvedExams.contains(this.iExam) ? this.iExam : this.iConflictsToResolve.keys().nextElement();
        if (this.iResolvedExams.contains(exam)) {
            return;
        }
        this.iResolvedExams.add(exam);
        for (ExamPeriodPlacement period : exam.getPeriodPlacements()) {
            Set rooms = this.findBestAvailableRooms(exam, period, true);
            if (rooms != null) {
                this.tryPlacement(new ExamPlacement(exam, period, rooms), depth);
                continue;
            }
            rooms = this.findBestAvailableRooms(exam, period, false);
            if (rooms == null) continue;
            this.tryPlacement(new ExamPlacement(exam, period, rooms), depth);
        }
        this.iResolvedExams.remove(exam);
    }
}

