/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.exam;

import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.cpsolver.exam.model.Exam;
import org.cpsolver.exam.model.ExamPlacement;
import org.cpsolver.exam.model.ExamRoomPlacement;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.ProblemSaver;
import org.cpsolver.ifs.util.Progress;
import org.cpsolver.ifs.util.ToolBox;
import org.hibernate.CacheMode;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.EventContact;
import org.unitime.timetable.model.ExamConflict;
import org.unitime.timetable.model.ExamEvent;
import org.unitime.timetable.model.ExamOwner;
import org.unitime.timetable.model.ExamPeriod;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.TimetableManager;
import org.unitime.timetable.model.dao.DepartmentalInstructorDAO;
import org.unitime.timetable.model.dao.ExamDAO;
import org.unitime.timetable.model.dao.ExamPeriodDAO;
import org.unitime.timetable.model.dao.LocationDAO;
import org.unitime.timetable.model.dao.StudentDAO;
import org.unitime.timetable.solver.exam.ExamModel;
import org.unitime.timetable.solver.exam.ui.ExamAssignment;
import org.unitime.timetable.solver.exam.ui.ExamAssignmentInfo;
import org.unitime.timetable.solver.exam.ui.ExamInfo;
import org.unitime.timetable.solver.jgroups.SolverServerImplementation;

public class ExamDatabaseSaver
extends ProblemSaver<Exam, ExamPlacement, ExamModel> {
    private Long iSessionId;
    private Long iExamTypeId;
    private Progress iProgress = Progress.getInstance((Object)this.getModel());

    public ExamDatabaseSaver(Solver solver) {
        super(solver);
        this.iSessionId = ((ExamModel)this.getModel()).getProperties().getPropertyLong("General.SessionId", (Long)null);
        this.iExamTypeId = ((ExamModel)this.getModel()).getProperties().getPropertyLong("Exam.Type", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        ApplicationProperties.setSessionId(this.iSessionId);
        this.iProgress.setStatus("Saving solution ...");
        Session hibSession = ExamDAO.getInstance().getSession();
        hibSession.setCacheMode(CacheMode.IGNORE);
        Transaction tx = null;
        try {
            tx = hibSession.beginTransaction();
            this.saveSolution(hibSession);
            tx.commit();
            this.iProgress.setPhase("Refreshing solution ...", 1L);
            try {
                if (SolverServerImplementation.getInstance() != null) {
                    SolverServerImplementation.getInstance().refreshExamSolution(this.iSessionId, this.iExamTypeId);
                }
                this.iProgress.incProgress();
            }
            catch (Exception e) {
                this.iProgress.warn("Unable to refresh solution, reason:" + e.getMessage(), (Throwable)e);
            }
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
            }
            this.iProgress.fatal("Unable to save a solution, reason: " + e.getMessage(), (Throwable)e);
        }
        finally {
            if (hibSession != null && hibSession.isOpen()) {
                hibSession.close();
            }
        }
    }

    private String getExamLabel(org.unitime.timetable.model.Exam exam) {
        return "<A href='examDetail.action?examId=" + exam.getUniqueId() + "'>" + exam.getLabel() + "</A>";
    }

    protected void saveSolution(Session hibSession) {
        Iterator<ExamOwner> j;
        TimetableManager owner = TimetableManager.findByExternalId(((ExamModel)this.getModel()).getProperties().getProperty("General.OwnerPuid"));
        List<org.unitime.timetable.model.Exam> exams = org.unitime.timetable.model.Exam.findAll(this.iSessionId, this.iExamTypeId);
        Hashtable<Long, ExamEvent> examEvents = new Hashtable<Long, ExamEvent>();
        for (ExamEvent e : hibSession.createQuery("select e from ExamEvent e where e.exam.session.uniqueId=:sessionId and e.exam.examType.uniqueId=:examTypeId", ExamEvent.class).setParameter("sessionId", (Object)this.iSessionId).setParameter("examTypeId", (Object)this.iExamTypeId).list()) {
            examEvents.put(e.getExam().getUniqueId(), e);
        }
        this.iProgress.setPhase("Saving assignments...", (long)exams.size());
        Hashtable<Long, org.unitime.timetable.model.Exam> examTable = new Hashtable<Long, org.unitime.timetable.model.Exam>();
        Iterator i = exams.iterator();
        while (i.hasNext()) {
            this.iProgress.incProgress();
            org.unitime.timetable.model.Exam exam = (org.unitime.timetable.model.Exam)i.next();
            ExamAssignment oldAssignment = new ExamAssignment(exam);
            exam.setAssignedPeriod(null);
            exam.setAssignedPreference(null);
            exam.getAssignedRooms().clear();
            ExamEvent event = (ExamEvent)examEvents.get(exam.getUniqueId());
            if (event != null) {
                hibSession.remove((Object)event);
            }
            Iterator<ExamConflict> j2 = exam.getConflicts().iterator();
            while (j2.hasNext()) {
                ExamConflict conf = j2.next();
                hibSession.remove((Object)conf);
                j2.remove();
            }
            Exam examVar = null;
            for (Exam x : ((ExamModel)this.getModel()).variables()) {
                if (!exam.getUniqueId().equals(x.getId())) continue;
                examVar = x;
                break;
            }
            if (examVar == null) {
                this.iProgress.warn("Exam " + this.getExamLabel(exam) + " was not loaded.");
                if (oldAssignment.getPeriodId() == null) continue;
                SubjectArea subject = null;
                Department dept = null;
                Iterator<ExamOwner> j3 = new TreeSet<ExamOwner>(exam.getOwners()).iterator();
                if (j3.hasNext()) {
                    ExamOwner xo = j3.next();
                    subject = xo.getCourse().getSubjectArea();
                    dept = subject.getDepartment();
                }
                ChangeLog.addChange(hibSession, owner, exam.getSession(), exam, exam.getName() + " (" + oldAssignment.getPeriodAbbreviation() + " " + oldAssignment.getRoomsName(", ") + " &rarr; N/A)", ChangeLog.Source.EXAM_SOLVER, ChangeLog.Operation.UNASSIGN, subject, dept);
                continue;
            }
            examTable.put(examVar.getId(), exam);
            ExamPlacement placement = (ExamPlacement)this.getAssignment().getValue((Variable)examVar);
            if (placement == null) {
                this.iProgress.warn("Exam " + this.getExamLabel(exam) + " has no assignment.");
                if (oldAssignment.getPeriodId() == null) continue;
                SubjectArea subject = null;
                Department dept = null;
                Iterator<Comparable<ExamInfo>> j4 = new TreeSet<ExamOwner>(exam.getOwners()).iterator();
                if (j4.hasNext()) {
                    ExamOwner xo = (ExamOwner)j4.next();
                    subject = xo.getCourse().getSubjectArea();
                    dept = subject.getDepartment();
                }
                ChangeLog.addChange(hibSession, owner, exam.getSession(), exam, exam.getName() + " (" + oldAssignment.getPeriodAbbreviation() + " " + oldAssignment.getRoomsName(", ") + " &rarr; N/A)", ChangeLog.Source.EXAM_SOLVER, ChangeLog.Operation.UNASSIGN, subject, dept);
                continue;
            }
            ExamPeriod period = (ExamPeriod)ExamPeriodDAO.getInstance().get(placement.getPeriod().getId());
            if (period == null) {
                this.iProgress.warn("Examination period " + placement.getPeriod().getDayStr() + " " + placement.getPeriod().getTimeStr() + " not found.");
                if (oldAssignment.getPeriodId() == null) continue;
                SubjectArea subject = null;
                Department dept = null;
                j = new TreeSet<ExamOwner>(exam.getOwners()).iterator();
                if (j.hasNext()) {
                    ExamOwner xo = j.next();
                    subject = xo.getCourse().getSubjectArea();
                    dept = subject.getDepartment();
                }
                ChangeLog.addChange(hibSession, owner, exam.getSession(), exam, exam.getName() + " (" + oldAssignment.getPeriodAbbreviation() + " " + oldAssignment.getRoomsName(", ") + " &rarr; N/A)", ChangeLog.Source.EXAM_SOLVER, ChangeLog.Operation.UNASSIGN, subject, dept);
                continue;
            }
            exam.setAssignedPeriod(period);
            for (ExamRoomPlacement room : placement.getRoomPlacements()) {
                Location location = (Location)LocationDAO.getInstance().get(room.getId());
                if (location == null) {
                    this.iProgress.warn("Location " + room.getName() + " (id:" + room.getId() + ") not found.");
                    continue;
                }
                exam.getAssignedRooms().add(location);
            }
            exam.setAssignedPreference(new ExamAssignment(placement, (Assignment<Exam, ExamPlacement>)this.getAssignment()).getAssignedPreferenceString());
            hibSession.merge((Object)exam);
            ExamAssignment newAssignment = new ExamAssignment(exam);
            if (ToolBox.equals((Object)newAssignment.getPeriodId(), (Object)oldAssignment.getPeriodId()) && ToolBox.equals(newAssignment.getRooms(), oldAssignment.getRooms())) continue;
            SubjectArea subject = null;
            Department dept = null;
            Iterator<ExamOwner> j5 = new TreeSet<ExamOwner>(exam.getOwners()).iterator();
            if (j5.hasNext()) {
                ExamOwner xo = j5.next();
                subject = xo.getCourse().getSubjectArea();
                dept = subject.getDepartment();
            }
            ChangeLog.addChange(hibSession, owner, exam.getSession(), exam, exam.getName() + " (" + (String)(oldAssignment.getPeriod() == null ? "N/A" : oldAssignment.getPeriodAbbreviation() + " " + oldAssignment.getRoomsName(", ")) + " &rarr; " + newAssignment.getPeriodAbbreviation() + " " + newAssignment.getRoomsName(", ") + ")", ChangeLog.Source.EXAM_SOLVER, ChangeLog.Operation.ASSIGN, subject, dept);
        }
        this.iProgress.setPhase("Saving conflicts...", (long)this.getAssignment().nrAssignedVariables());
        for (Exam examVar : this.getAssignment().assignedVariables()) {
            org.unitime.timetable.model.Exam otherExam;
            HashSet<org.unitime.timetable.model.Exam> confExams;
            ExamConflict conf;
            org.unitime.timetable.model.Exam otherExam2;
            this.iProgress.incProgress();
            org.unitime.timetable.model.Exam exam = (org.unitime.timetable.model.Exam)examTable.get(examVar.getId());
            if (exam == null) continue;
            ExamPlacement placement = (ExamPlacement)this.getAssignment().getValue((Variable)examVar);
            ExamAssignmentInfo info = new ExamAssignmentInfo(placement, (Assignment<Exam, ExamPlacement>)this.getAssignment());
            for (ExamAssignmentInfo.DirectConflict dc : info.getDirectConflicts()) {
                if (dc.getOtherExam() == null || examVar.getId() >= dc.getOtherExam().getExamId()) continue;
                otherExam2 = (org.unitime.timetable.model.Exam)examTable.get(dc.getOtherExam().getExamId());
                if (otherExam2 == null) {
                    this.iProgress.warn("Exam " + dc.getOtherExam().getExamName() + " (id:" + dc.getOtherExam().getExamId() + ") not found.");
                    continue;
                }
                conf = new ExamConflict();
                conf.setConflictType(0);
                conf.setStudents(this.getStudents(hibSession, dc.getStudents()));
                conf.setNrStudents(conf.getStudents().size());
                hibSession.persist((Object)conf);
                exam.getConflicts().add(conf);
                otherExam2.getConflicts().add(conf);
                this.iProgress.debug("Direct conflict of " + dc.getStudents().size() + " students between " + exam.getLabel() + " and " + otherExam2.getLabel());
            }
            for (ExamAssignmentInfo.BackToBackConflict btb : info.getBackToBackConflicts()) {
                if (examVar.getId() >= btb.getOtherExam().getExamId()) continue;
                otherExam2 = (org.unitime.timetable.model.Exam)examTable.get(btb.getOtherExam().getExamId());
                if (otherExam2 == null) {
                    this.iProgress.warn("Exam " + btb.getOtherExam().getExamName() + " (id:" + btb.getOtherExam().getExamId() + ") not found.");
                    continue;
                }
                conf = new ExamConflict();
                conf.setConflictType(btb.isDistance() ? 2 : 3);
                conf.setDistance(btb.getDistance());
                conf.setStudents(this.getStudents(hibSession, btb.getStudents()));
                conf.setNrStudents(conf.getStudents().size());
                exam.getConflicts().add(conf);
                otherExam2.getConflicts().add(conf);
                hibSession.persist((Object)conf);
                this.iProgress.debug("Back-to-back conflict of " + btb.getStudents().size() + " students between " + exam.getLabel() + " and " + otherExam2.getLabel());
            }
            block8: for (ExamAssignmentInfo.MoreThanTwoADayConflict m2d : info.getMoreThanTwoADaysConflicts()) {
                confExams = new HashSet<org.unitime.timetable.model.Exam>();
                confExams.add(exam);
                for (ExamAssignment otherExamAsg : m2d.getOtherExams()) {
                    if (examVar.getId() >= otherExamAsg.getExamId()) continue block8;
                    otherExam = (org.unitime.timetable.model.Exam)examTable.get(otherExamAsg.getExamId());
                    if (otherExam == null) {
                        this.iProgress.warn("Exam " + otherExamAsg.getExamName() + " (id:" + otherExamAsg.getExamId() + ") not found.");
                        continue;
                    }
                    confExams.add(otherExam);
                }
                if (confExams.size() < 3) continue;
                conf = new ExamConflict();
                conf.setConflictType(1);
                conf.setStudents(this.getStudents(hibSession, m2d.getStudents()));
                conf.setNrStudents(conf.getStudents().size());
                hibSession.persist((Object)conf);
                j = confExams.iterator();
                while (j.hasNext()) {
                    ((org.unitime.timetable.model.Exam)((Object)j.next())).getConflicts().add(conf);
                }
                this.iProgress.debug("More than 2 a day conflict of " + m2d.getStudents().size() + " students between " + exam.getLabel() + " and " + m2d.getOtherExams());
            }
            for (ExamAssignmentInfo.DirectConflict dc : info.getInstructorDirectConflicts()) {
                if (dc.getOtherExam() == null || examVar.getId() >= dc.getOtherExam().getExamId()) continue;
                otherExam2 = (org.unitime.timetable.model.Exam)examTable.get(dc.getOtherExam().getExamId());
                if (otherExam2 == null) {
                    this.iProgress.warn("Exam " + dc.getOtherExam().getExamName() + " (id:" + dc.getOtherExam().getExamId() + ") not found.");
                    continue;
                }
                conf = new ExamConflict();
                conf.setConflictType(0);
                conf.setInstructors(this.getInstructors(hibSession, dc.getStudents()));
                conf.setNrInstructors(conf.getInstructors().size());
                hibSession.persist((Object)conf);
                exam.getConflicts().add(conf);
                otherExam2.getConflicts().add(conf);
                this.iProgress.debug("Direct conflict of " + dc.getStudents().size() + " instructors between " + exam.getLabel() + " and " + otherExam2.getLabel());
            }
            for (ExamAssignmentInfo.BackToBackConflict btb : info.getInstructorBackToBackConflicts()) {
                if (examVar.getId() >= btb.getOtherExam().getExamId()) continue;
                otherExam2 = (org.unitime.timetable.model.Exam)examTable.get(btb.getOtherExam().getExamId());
                if (otherExam2 == null) {
                    this.iProgress.warn("Exam " + btb.getOtherExam().getExamName() + " (id:" + btb.getOtherExam().getExamId() + ") not found.");
                    continue;
                }
                conf = new ExamConflict();
                conf.setConflictType(btb.isDistance() ? 2 : 3);
                conf.setDistance(btb.getDistance());
                conf.setInstructors(this.getInstructors(hibSession, btb.getStudents()));
                conf.setNrInstructors(conf.getInstructors().size());
                exam.getConflicts().add(conf);
                otherExam2.getConflicts().add(conf);
                hibSession.persist((Object)conf);
                this.iProgress.debug("Back-to-back conflict of " + btb.getStudents().size() + " instructors between " + exam.getLabel() + " and " + otherExam2.getLabel());
            }
            block13: for (ExamAssignmentInfo.MoreThanTwoADayConflict m2d : info.getInstructorMoreThanTwoADaysConflicts()) {
                confExams = new HashSet();
                confExams.add(exam);
                for (ExamAssignment otherExamAsg : m2d.getOtherExams()) {
                    if (examVar.getId() >= otherExamAsg.getExamId()) continue block13;
                    otherExam = (org.unitime.timetable.model.Exam)examTable.get(otherExamAsg.getExamId());
                    if (otherExam == null) {
                        this.iProgress.warn("Exam " + otherExamAsg.getExamName() + " (id:" + otherExamAsg.getExamId() + ") not found.");
                        continue;
                    }
                    confExams.add(otherExam);
                }
                if (confExams.size() < 3) continue;
                conf = new ExamConflict();
                conf.setConflictType(1);
                conf.setInstructors(this.getInstructors(hibSession, m2d.getStudents()));
                conf.setNrInstructors(conf.getInstructors().size());
                hibSession.persist((Object)conf);
                j = confExams.iterator();
                while (j.hasNext()) {
                    ((org.unitime.timetable.model.Exam)((Object)j.next())).getConflicts().add(conf);
                }
                this.iProgress.debug("More than 2 a day conflict of " + m2d.getStudents().size() + " instructors between " + exam.getLabel() + " and " + m2d.getOtherExams());
            }
        }
        this.iProgress.setPhase("Saving events...", (long)this.getAssignment().nrAssignedVariables());
        String ownerPuid = ((ExamModel)this.getModel()).getProperties().getProperty("General.OwnerPuid");
        EventContact contact = EventContact.findByExternalUniqueId(ownerPuid);
        if (contact == null) {
            TimetableManager manager = TimetableManager.findByExternalId(ownerPuid);
            contact = new EventContact();
            contact.setFirstName(manager.getFirstName());
            contact.setMiddleName(manager.getMiddleName());
            contact.setLastName(manager.getLastName());
            contact.setExternalUniqueId(manager.getExternalUniqueId());
            contact.setEmailAddress(manager.getEmailAddress());
            hibSession.persist((Object)contact);
        }
        for (Exam examVar : this.getAssignment().assignedVariables()) {
            this.iProgress.incProgress();
            org.unitime.timetable.model.Exam exam = (org.unitime.timetable.model.Exam)examTable.get(examVar.getId());
            if (exam == null) continue;
            ExamEvent event = exam.generateEvent(null, true);
            if (event != null) {
                event.setEventName(examVar.getName());
                event.setMinCapacity(examVar.getSize());
                event.setMaxCapacity(examVar.getSize());
                event.setMainContact(contact);
                if (event.getUniqueId() == null) {
                    hibSession.persist((Object)event);
                } else {
                    hibSession.merge((Object)event);
                }
            }
            if (event == null && exam.getConflicts().isEmpty()) continue;
            hibSession.merge((Object)exam);
        }
    }

    protected HashSet getStudents(Session hibSession, Collection studentIds) {
        HashSet<Student> students = new HashSet<Student>();
        if (studentIds == null || studentIds.isEmpty()) {
            return students;
        }
        for (Long studentId : studentIds) {
            Student student = (Student)StudentDAO.getInstance().get(studentId, hibSession);
            if (student == null) continue;
            students.add(student);
        }
        return students;
    }

    protected HashSet getInstructors(Session hibSession, Collection instructorIds) {
        HashSet<DepartmentalInstructor> instructors = new HashSet<DepartmentalInstructor>();
        if (instructorIds == null || instructorIds.isEmpty()) {
            return instructors;
        }
        for (Long instructorId : instructorIds) {
            DepartmentalInstructor instructor = (DepartmentalInstructor)DepartmentalInstructorDAO.getInstance().get(instructorId, hibSession);
            if (instructor == null) continue;
            instructors.add(instructor);
        }
        return instructors;
    }
}

