/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.curricula;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.DefaultSingleAssignment;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.IdGenerator;
import org.cpsolver.ifs.util.Progress;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.hibernate.query.Query;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.Curriculum;
import org.unitime.timetable.model.CurriculumClassification;
import org.unitime.timetable.model.CurriculumCourse;
import org.unitime.timetable.model.CurriculumCourseGroup;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.PosMajor;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.solver.curricula.CurriculaCourseDemands;
import org.unitime.timetable.solver.curricula.CurriculumEnrollmentPriorityProvider;
import org.unitime.timetable.solver.curricula.DefaultCurriculumEnrollmentPriorityProvider;
import org.unitime.timetable.solver.curricula.ParallelInitialization;
import org.unitime.timetable.solver.curricula.StudentCourseDemands;
import org.unitime.timetable.solver.curricula.StudentCourseRequests;
import org.unitime.timetable.solver.curricula.students.CurCourse;
import org.unitime.timetable.solver.curricula.students.CurModel;
import org.unitime.timetable.solver.curricula.students.CurStudent;
import org.unitime.timetable.solver.curricula.students.CurValue;
import org.unitime.timetable.solver.curricula.students.CurVariable;

public class CurriculaRequestsCourseDemands
implements StudentCourseDemands,
StudentCourseDemands.NeedsStudentIdGenerator {
    private static Log sLog = LogFactory.getLog(CurriculaRequestsCourseDemands.class);
    private StudentCourseRequests iStudentCourseRequests;
    private IdGenerator iLastStudentId = null;
    private Hashtable<Long, Set<StudentCourseDemands.WeightedStudentId>> iDemands = new Hashtable();
    private Hashtable<Long, Set<StudentCourseDemands.WeightedCourseOffering>> iStudentRequests = new Hashtable();
    private Hashtable<String, Set<String>> iLoadedCurricula = new Hashtable();
    private Hashtable<Long, Hashtable<Long, Double>> iEnrollmentPriorities = new Hashtable();
    private HashSet<Long> iCheckedCourses = new HashSet();
    private boolean iIncludeOtherStudents = true;
    private boolean iIncludeOtherCourses = true;
    private boolean iSetStudentCourseLimits = false;
    private boolean iCreateStudentGroups = true;
    private CurriculumEnrollmentPriorityProvider iEnrollmentPriorityProvider = null;
    private DataProperties iProperties = null;

    public CurriculaRequestsCourseDemands(DataProperties config) {
        this.iProperties = config;
        this.iStudentCourseRequests = new StudentCourseRequests(config);
        this.iIncludeOtherStudents = config.getPropertyBoolean("CurriculaCourseDemands.IncludeOtherStudents", this.iIncludeOtherStudents);
        this.iIncludeOtherCourses = config.getPropertyBoolean("CurriculaCourseDemands.IncludeOtherCourses", config.getPropertyBoolean("CurriculaCourseDemands.IncludeOtherStudents", this.iIncludeOtherCourses));
        this.iSetStudentCourseLimits = config.getPropertyBoolean("CurriculaCourseDemands.SetStudentCourseLimits", this.iSetStudentCourseLimits);
        this.iCreateStudentGroups = config.getPropertyBoolean("CurriculaCourseDemands.CreateStudentGroups", this.iCreateStudentGroups);
        this.iEnrollmentPriorityProvider = new DefaultCurriculumEnrollmentPriorityProvider(config);
        if (config.getProperty("CurriculaCourseDemands.CurriculumEnrollmentPriorityProvider") != null) {
            try {
                this.iEnrollmentPriorityProvider = (CurriculumEnrollmentPriorityProvider)Class.forName(config.getProperty("CurriculaCourseDemands.CurriculumEnrollmentPriorityProvider")).getConstructor(DataProperties.class).newInstance(config);
            }
            catch (Exception e) {
                sLog.error((Object)("Failed to use custom enrollment priority provider: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    @Override
    public void init(org.hibernate.Session hibSession, Progress progress, Session session, Collection<InstructionalOffering> offerings) {
        this.iStudentCourseRequests.init(hibSession, progress, session, offerings);
        ArrayList curricula = null;
        if (offerings != null && offerings.size() <= 1000) {
            Object courses = "";
            int nrCourses = 0;
            for (InstructionalOffering offering : offerings) {
                for (CourseOffering course : offering.getCourseOfferings()) {
                    if (!((String)courses).isEmpty()) {
                        courses = (String)courses + ",";
                    }
                    courses = (String)courses + course.getUniqueId();
                    ++nrCourses;
                }
            }
            if (nrCourses > 0 && nrCourses <= 1000) {
                HashSet curriculaSet = new HashSet(hibSession.createQuery("select distinct c from CurriculumCourse cc inner join cc.classification.curriculum c where c.academicArea.session.uniqueId = :sessionId and cc.course.uniqueId in (" + (String)courses + ")", Curriculum.class).setParameter("sessionId", (Object)session.getUniqueId()).list());
                curriculaSet.addAll(hibSession.createQuery("select distinct d from CurriculumCourse cc inner join cc.classification.curriculum c, Curriculum d where c.academicArea = d.academicArea and d.multipleMajors = true and size(c.majors) <= 1 and size(c.majors) < size(d.majors) and (select count(m) from Curriculum x inner join x.majors m where x.uniqueId = c.uniqueId and m not in elements(d.majors)) = 0 and c.academicArea.session.uniqueId = :sessionId and cc.course.uniqueId in (" + (String)courses + ")", Curriculum.class).setParameter("sessionId", (Object)session.getUniqueId()).list());
                curriculaSet.addAll(hibSession.createQuery("select distinct d from CurriculumCourse cc inner join cc.classification.curriculum c, Curriculum d where c.multipleMajors = true and size(c.majors) >= 1 and size(c.majors) > size(d.majors) and c.academicArea = d.academicArea and (select count(m) from Curriculum x inner join x.majors m where x.uniqueId = d.uniqueId and m not in elements(c.majors)) = 0 and c.academicArea.session.uniqueId = :sessionId and cc.course.uniqueId in (" + (String)courses + ")", Curriculum.class).setParameter("sessionId", (Object)session.getUniqueId()).list());
                curricula = new ArrayList(curriculaSet);
            }
        }
        if (curricula == null) {
            curricula = hibSession.createQuery("select c from Curriculum c where c.academicArea.session.uniqueId = :sessionId", Curriculum.class).setParameter("sessionId", (Object)session.getUniqueId()).list();
        }
        ArrayList<Initialization> inits = new ArrayList<Initialization>();
        for (Curriculum curriculum : curricula) {
            for (CurriculumClassification clasf : curriculum.getClassifications()) {
                if (clasf.getNrStudents() <= 0) continue;
                ArrayList<CurriculumClassification> templates = new ArrayList<CurriculumClassification>();
                if (curriculum.isMultipleMajors().booleanValue()) {
                    for (Curriculum parent : curricula) {
                        if (!parent.isTemplateFor(curriculum)) continue;
                        for (CurriculumClassification parentClasf : parent.getClassifications()) {
                            if (!parentClasf.getAcademicClassification().equals(clasf.getAcademicClassification())) continue;
                            templates.add(parentClasf);
                        }
                    }
                }
                inits.add(new Initialization(clasf, templates, this.loadCourseRegistrations(hibSession, clasf)));
            }
        }
        new ParallelInitialization("Loading curricula", this.iProperties.getPropertyInt("CurriculaCourseDemands.NrThreads", 1), inits).execute(hibSession, progress);
    }

    private Map<CourseOffering, Set<StudentCourseDemands.WeightedStudentId>> loadCourseRegistrations(org.hibernate.Session hibSession, CurriculumClassification cc) {
        List lines = null;
        String select = "distinct co, s, a.weight";
        Object from = "CourseRequest r inner join r.courseOffering co inner join r.courseDemand.student s inner join s.areaClasfMajors a";
        Object where = "s.session.uniqueId = :sessionId and a.academicArea.uniqueId = :acadAreaId and a.academicClassification.uniqueId = :clasfId and r.order = 0";
        if (cc.getCurriculum().getMajors().isEmpty()) {
            if (!cc.getCurriculum().isMultipleMajors().booleanValue()) {
                lines = hibSession.createQuery("select " + select + " from " + (String)from + " where " + (String)where, Object[].class).setParameter("sessionId", (Object)cc.getCurriculum().getAcademicArea().getSessionId()).setParameter("acadAreaId", (Object)cc.getCurriculum().getAcademicArea().getUniqueId()).setParameter("clasfId", (Object)cc.getAcademicClassification().getUniqueId()).setCacheable(true).list();
            }
        } else if (!cc.getCurriculum().isMultipleMajors().booleanValue() || cc.getCurriculum().getMajors().size() == 1) {
            ArrayList<Long> majorIds = new ArrayList<Long>();
            for (PosMajor posMajor : cc.getCurriculum().getMajors()) {
                majorIds.add(posMajor.getUniqueId());
            }
            lines = hibSession.createQuery("select " + select + " from " + (String)from + " where " + (String)where + " and a.major.uniqueId in :majorIds", Object[].class).setParameter("sessionId", (Object)cc.getCurriculum().getAcademicArea().getSessionId()).setParameter("acadAreaId", (Object)cc.getCurriculum().getAcademicArea().getUniqueId()).setParameter("clasfId", (Object)cc.getAcademicClassification().getUniqueId()).setParameterList("majorIds", majorIds).setCacheable(true).list();
        } else {
            HashMap<CallSite, Long> params = new HashMap<CallSite, Long>();
            int idx = 0;
            for (PosMajor posMajor : cc.getCurriculum().getMajors()) {
                if (idx == 0) {
                    where = (String)where + " and a.major.uniqueId = :m" + idx;
                } else {
                    from = (String)from + " inner join s.areaClasfMajors a" + idx;
                    where = (String)where + " and a" + idx + ".academicArea.uniqueId = :acadAreaId and a" + idx + ".academicClassification.uniqueId = :clasfId and a" + idx + ".major.uniqueId = :m" + idx;
                }
                params.put((CallSite)((Object)("m" + idx)), posMajor.getUniqueId());
                ++idx;
            }
            Query query = hibSession.createQuery("select " + select + " from " + (String)from + " where " + (String)where, Object[].class).setParameter("sessionId", (Object)cc.getCurriculum().getAcademicArea().getSessionId()).setParameter("acadAreaId", (Object)cc.getCurriculum().getAcademicArea().getUniqueId()).setParameter("clasfId", (Object)cc.getAcademicClassification().getUniqueId());
            for (Map.Entry entry : params.entrySet()) {
                query.setParameter((String)entry.getKey(), entry.getValue());
            }
            lines = query.setCacheable(true).list();
        }
        HashMap<CourseOffering, Set<StudentCourseDemands.WeightedStudentId>> course2req = new HashMap<CourseOffering, Set<StudentCourseDemands.WeightedStudentId>>();
        if (lines != null) {
            for (Object[] objectArray : lines) {
                CourseOffering courseOffering = (CourseOffering)objectArray[0];
                Student student = (Student)objectArray[1];
                Double weight = (Double)objectArray[2];
                StudentCourseDemands.WeightedStudentId studentId = new StudentCourseDemands.WeightedStudentId(student);
                studentId.setWeight(weight.floatValue());
                if (this.iCreateStudentGroups) {
                    studentId.getGroups().add(new StudentCourseDemands.Group(-cc.getUniqueId().longValue(), cc.getCurriculum().getAbbv() + " " + cc.getAcademicClassification().getCode()));
                }
                studentId.setCurriculum(cc.getCurriculum().getAbbv() + " " + cc.getAcademicClassification().getCode());
                HashSet<StudentCourseDemands.WeightedStudentId> students = (HashSet<StudentCourseDemands.WeightedStudentId>)course2req.get(courseOffering);
                if (students == null) {
                    students = new HashSet<StudentCourseDemands.WeightedStudentId>();
                    course2req.put(courseOffering, students);
                }
                students.add(studentId);
            }
        }
        return course2req;
    }

    protected String getCacheName() {
        return "curriculum-lastlike-demands";
    }

    protected void computeTargetShare(CurriculumClassification clasf, Collection<CurriculumCourse> courses, CurriculaCourseDemands.CurriculumCourseGroupsProvider course2groups, int nrStudents, double factor, double w, CurModel model) {
        for (CurriculumCourse c1 : courses) {
            double x1 = model.getCourse(c1.getCourse().getUniqueId()).getOriginalMaxSize();
            HashSet[] group = new HashSet[]{new HashSet(), new HashSet()};
            LinkedList<CurriculumCourse> queue = new LinkedList<CurriculumCourse>();
            queue.add(c1);
            HashSet<CurriculumCourseGroup> done = new HashSet<CurriculumCourseGroup>();
            while (!queue.isEmpty()) {
                CurriculumCourse c = (CurriculumCourse)queue.poll();
                for (CurriculumCourseGroup g : course2groups.getGroups(c)) {
                    if (!done.add(g)) continue;
                    for (CurriculumCourse x : courses) {
                        if (x.equals(c) || x.equals(c1) || !course2groups.getGroups(x).contains(g) || !group[group[0].contains(c) ? 0 : g.getType()].add(x)) continue;
                        queue.add(x);
                    }
                }
            }
            for (CurriculumCourse c2 : courses) {
                double defaultShare;
                boolean req;
                double x2 = model.getCourse(c2.getCourse().getUniqueId()).getOriginalMaxSize();
                boolean opt = group[0].contains(c2);
                boolean bl = req = !opt && group[1].contains(c2);
                double d = opt ? 0.0 : (defaultShare = req ? Math.min(x1, x2) : (double)(c1.getPercShare().floatValue() * c2.getPercShare().floatValue() * (float)nrStudents));
                if (c1.getUniqueId() >= c2.getUniqueId()) continue;
                double share = defaultShare;
                Set<StudentCourseDemands.WeightedStudentId> s1 = this.iStudentCourseRequests.getDemands(c1.getCourse());
                Set<StudentCourseDemands.WeightedStudentId> s2 = this.iStudentCourseRequests.getDemands(c2.getCourse());
                int sharedStudents = 0;
                int registered = 0;
                if (s1 != null && !s1.isEmpty() && s2 != null && !s2.isEmpty()) {
                    for (StudentCourseDemands.WeightedStudentId s : s1) {
                        if (!s.match(clasf)) continue;
                        ++registered;
                        if (!s2.contains(s)) continue;
                        ++sharedStudents;
                    }
                }
                share = registered == 0 ? (1.0 - w) * defaultShare : w * (x1 / (double)registered) * (double)sharedStudents + (1.0 - w) * defaultShare;
                model.setTargetShare(c1.getCourse().getUniqueId(), c2.getCourse().getUniqueId(), share, false);
            }
        }
    }

    @Override
    public Set<StudentCourseDemands.WeightedCourseOffering> getCourses(Long studentId) {
        Set<StudentCourseDemands.WeightedCourseOffering> courses = this.iStudentRequests.get(studentId);
        if (this.iIncludeOtherStudents && studentId >= 0L && courses == null) {
            return this.iStudentCourseRequests.getCourses(studentId);
        }
        return this.iStudentRequests.get(studentId);
    }

    @Override
    public Set<StudentCourseDemands.WeightedStudentId> getDemands(CourseOffering course) {
        if (this.iDemands.isEmpty()) {
            return this.iStudentCourseRequests.getDemands(course);
        }
        Set<StudentCourseDemands.WeightedStudentId> demands = this.iDemands.get(course.getUniqueId());
        if (!this.iIncludeOtherStudents) {
            return demands;
        }
        if (demands == null) {
            demands = new HashSet<StudentCourseDemands.WeightedStudentId>();
            this.iDemands.put(course.getUniqueId(), demands);
        }
        if (this.iCheckedCourses.add(course.getUniqueId())) {
            int was = demands.size();
            Set<StudentCourseDemands.WeightedStudentId> other = this.iStudentCourseRequests.getDemands(course);
            if (other == null) {
                sLog.debug((Object)(course.getCourseName() + " has no students."));
            } else {
                if (this.iLoadedCurricula == null || this.iLoadedCurricula.isEmpty()) {
                    demands.addAll(other);
                } else {
                    block0: for (StudentCourseDemands.WeightedStudentId student : other) {
                        for (StudentCourseDemands.AreaClasfMajor acm : student.getMajors()) {
                            Set<String> majors = this.iLoadedCurricula.get(acm.getArea());
                            if (majors == null || !majors.contains("") && !student.match(acm.getArea(), majors)) continue;
                            continue block0;
                        }
                        demands.add(student);
                    }
                }
                if (demands.size() > was) {
                    sLog.debug((Object)(course.getCourseName() + " has " + (demands.size() - was) + " other students (besides of the " + was + " curriculum students)."));
                }
            }
        }
        return demands;
    }

    @Override
    public boolean canUseStudentClassEnrollmentsAsSolution() {
        return false;
    }

    @Override
    public boolean isMakingUpStudents() {
        return false;
    }

    @Override
    public boolean isWeightStudentsToFillUpOffering() {
        return false;
    }

    @Override
    public Double getEnrollmentPriority(Long studentId, Long courseId) {
        if (studentId >= 0L) {
            return this.iStudentCourseRequests.getEnrollmentPriority(studentId, courseId);
        }
        Hashtable<Long, Double> priorities = this.iEnrollmentPriorities.get(studentId);
        return priorities == null ? null : priorities.get(courseId);
    }

    @Override
    public void setStudentIdGenerator(IdGenerator generator) {
        this.iLastStudentId = generator;
    }

    public class Initialization
    implements ParallelInitialization.Task {
        private CurriculumClassification iClassification;
        private List<CurriculumClassification> iTemplates;
        private Map<CourseOffering, Set<StudentCourseDemands.WeightedStudentId>> iCourseRequests;
        private boolean iUpdateClassification = false;
        private CurModel iModel;
        private Assignment<CurVariable, CurValue> iAssignment;
        private List<StudentCourseDemands.WeightedStudentId> iMadeUpStudents;
        private Hashtable<Long, StudentCourseDemands.WeightedStudentId> iStudentIds;
        private Hashtable<Long, CourseOffering> iCourses;
        private Hashtable<StudentCourseDemands.WeightedStudentId, Set<CourseOffering>> iStudents;

        public Initialization(CurriculumClassification clasf, List<CurriculumClassification> templates, Map<CourseOffering, Set<StudentCourseDemands.WeightedStudentId>> courseRequest) {
            this.iClassification = clasf;
            this.iCourseRequests = courseRequest;
            this.iTemplates = templates;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void setup(org.hibernate.Session hibSession) {
            void var11_30;
            Element cache;
            int n;
            sLog.debug((Object)("Processing " + this.iClassification.getCurriculum().getAbbv() + " " + this.iClassification.getName() + " ... (" + this.iClassification.getNrStudents() + " students, " + this.iClassification.getCourses().size() + " iCourses)"));
            this.iStudents = new Hashtable();
            if (this.iCourseRequests != null) {
                for (Map.Entry<CourseOffering, Set<StudentCourseDemands.WeightedStudentId>> entry : this.iCourseRequests.entrySet()) {
                    for (StudentCourseDemands.WeightedStudentId student : entry.getValue()) {
                        Set<CourseOffering> courses = this.iStudents.get(student);
                        if (courses == null) {
                            courses = new HashSet<CourseOffering>();
                            this.iStudents.put(student, courses);
                        }
                        courses.add(entry.getKey());
                    }
                }
            }
            float totalWeight = 0.0f;
            for (StudentCourseDemands.WeightedStudentId student : this.iStudents.keySet()) {
                totalWeight += student.getWeight();
            }
            sLog.debug((Object)("  registered students: " + totalWeight + ", target: " + this.iClassification.getNrStudents()));
            int n2 = this.iClassification.getNrStudents();
            this.iMadeUpStudents = new ArrayList<StudentCourseDemands.WeightedStudentId>();
            double w = Math.min((double)(totalWeight / (float)this.iClassification.getNrStudents().intValue()), 1.0);
            float factor = 1.0f;
            if (2.0f * totalWeight < (float)this.iClassification.getNrStudents().intValue()) {
                int studentsToMakeUp = Math.round((float)this.iClassification.getNrStudents().intValue() - totalWeight);
                sLog.debug((Object)("    making up " + studentsToMakeUp + " students"));
                Object majors = "";
                for (PosMajor major : this.iClassification.getCurriculum().getMajors()) {
                    if (!((String)majors).isEmpty()) {
                        majors = (String)majors + "|";
                    }
                    majors = (String)majors + major.getCode();
                }
                for (int i = 0; i < studentsToMakeUp; ++i) {
                    Iterator<CurriculumCourse> student = new StudentCourseDemands.WeightedStudentId(-CurriculaRequestsCourseDemands.this.iLastStudentId.newId(), this.iClassification);
                    if (CurriculaRequestsCourseDemands.this.iCreateStudentGroups) {
                        ((StudentCourseDemands.WeightedStudentId)((Object)student)).getGroups().add(new StudentCourseDemands.Group(-this.iClassification.getUniqueId().longValue(), this.iClassification.getCurriculum().getAbbv() + " " + this.iClassification.getAcademicClassification().getCode()));
                    }
                    this.iStudents.put((StudentCourseDemands.WeightedStudentId)((Object)student), new HashSet());
                    this.iMadeUpStudents.add((StudentCourseDemands.WeightedStudentId)((Object)student));
                }
            } else if (totalWeight < (float)this.iClassification.getNrStudents().intValue()) {
                factor = (float)this.iClassification.getNrStudents().intValue() / totalWeight;
                w = 1.0;
                sLog.debug((Object)("    changing student weight " + factor + " times"));
                for (StudentCourseDemands.WeightedStudentId student : this.iStudents.keySet()) {
                    student.setWeight(student.getWeight() * factor);
                }
            } else if (totalWeight > (float)this.iClassification.getNrStudents().intValue()) {
                sLog.debug((Object)"    more registered students than needed, keeping all");
                n = Math.round(totalWeight);
            }
            Collection<CurriculumCourse> courses = null;
            CurriculaCourseDemands.CurriculumCourseGroupsProvider course2groups = null;
            if (this.iTemplates == null || this.iTemplates.isEmpty()) {
                courses = this.iClassification.getCourses();
                course2groups = new CurriculaCourseDemands.DefaultCurriculumCourseGroupsProvider();
            } else {
                HashMap<Long, CurriculumCourse> curriculumCourses = new HashMap<Long, CurriculumCourse>();
                course2groups = new CurriculaCourseDemands.TableCurriculumCourseGroupsProvider();
                for (CurriculumClassification curriculumClassification : this.iTemplates) {
                    for (CurriculumCourse course : curriculumClassification.getCourses()) {
                        CurriculumCourse prev = (CurriculumCourse)curriculumCourses.get(course.getCourse().getUniqueId());
                        if (prev == null || prev.getPercShare().floatValue() < course.getPercShare().floatValue()) {
                            curriculumCourses.put(course.getCourse().getUniqueId(), course);
                        }
                        ((CurriculaCourseDemands.TableCurriculumCourseGroupsProvider)course2groups).add(course);
                    }
                }
                for (CurriculumCourse curriculumCourse : this.iClassification.getCourses()) {
                    curriculumCourses.put(curriculumCourse.getCourse().getUniqueId(), curriculumCourse);
                    ((CurriculaCourseDemands.TableCurriculumCourseGroupsProvider)course2groups).add(curriculumCourse);
                }
                courses = curriculumCourses.values();
            }
            ArrayList<CurStudent> curStudents = new ArrayList<CurStudent>();
            this.iStudentIds = new Hashtable();
            int idx = 0;
            for (StudentCourseDemands.WeightedStudentId student : this.iStudents.keySet()) {
                curStudents.add(new CurStudent(student.getStudentId() < 0L ? (long)(-(++idx)) : student.getStudentId(), student.getWeight()));
                this.iStudentIds.put(student.getStudentId() < 0L ? (long)(-idx) : student.getStudentId(), student);
            }
            this.iModel = new CurModel(curStudents);
            this.iCourses = new Hashtable();
            for (CurriculumCourse course : courses) {
                Set<StudentCourseDemands.WeightedStudentId> requests = this.iCourseRequests == null ? null : this.iCourseRequests.get(course.getCourse());
                double size = (double)(factor * (float)(requests == null ? 0 : requests.size())) + (1.0 - w) * (double)n * (double)course.getPercShare().floatValue();
                this.iModel.addCourse(course.getCourse().getUniqueId(), course.getCourse().getCourseName(), size, CurriculaRequestsCourseDemands.this.iEnrollmentPriorityProvider.getEnrollmentPriority(course, course2groups));
                this.iCourses.put(course.getCourse().getUniqueId(), course.getCourse());
            }
            CurriculaRequestsCourseDemands.this.computeTargetShare(this.iClassification, courses, course2groups, n, factor, w, this.iModel);
            if (CurriculaRequestsCourseDemands.this.iSetStudentCourseLimits) {
                this.iModel.setStudentLimits();
            }
            Object var11_28 = null;
            this.iAssignment = new DefaultSingleAssignment();
            Document cachedXml = this.iClassification.getStudentsDocument();
            Element element = cache = cachedXml == null ? null : cachedXml.getRootElement();
            if (cache != null && cache.getName().equals(CurriculaRequestsCourseDemands.this.getCacheName())) {
                Solution<CurVariable, CurValue> solution = CurModel.loadFromXml(cache);
                if (CurriculaRequestsCourseDemands.this.iSetStudentCourseLimits) {
                    ((CurModel)solution.getModel()).setStudentLimits();
                }
            }
            if (var11_30 != null && ((CurModel)var11_30.getModel()).isSameModel((Object)this.iModel)) {
                sLog.debug((Object)"  using cached model...");
                this.iModel = (CurModel)var11_30.getModel();
                this.iAssignment = var11_30.getAssignment();
            } else {
                for (CurStudent student : curStudents) {
                    for (CourseOffering course : this.iStudents.get(this.iStudentIds.get(student.getStudentId()))) {
                        CurCourse curCourse = this.iModel.getCourse(course.getUniqueId());
                        if (curCourse == null) continue;
                        CurVariable var = null;
                        for (CurVariable v : curCourse.variables()) {
                            if (this.iAssignment.getValue((Variable)v) != null) continue;
                            var = v;
                            break;
                        }
                        if (var != null) {
                            CurValue val = new CurValue(var, student);
                            if (!this.iModel.inConflict(this.iAssignment, val)) {
                                this.iAssignment.assign(0L, (Value)val);
                                continue;
                            }
                            sLog.debug((Object)("Unable to assign " + student + " to " + var));
                            Map conf = this.iModel.conflictConstraints(this.iAssignment, val);
                            for (Map.Entry entry : conf.entrySet()) {
                                sLog.debug((Object)(entry.getKey() + ": " + entry.getValue()));
                            }
                            continue;
                        }
                        sLog.debug((Object)("No variable for " + student + " to " + curCourse));
                    }
                }
                this.iUpdateClassification = true;
            }
        }

        @Override
        public void execute() {
            if (this.iUpdateClassification) {
                sLog.debug((Object)("Initial: " + this.iModel.getInfo(this.iAssignment)));
                this.iModel.solve(CurriculaRequestsCourseDemands.this.iProperties, this.iAssignment);
                sLog.debug((Object)("Final: " + this.iModel.getInfo(this.iAssignment)));
            }
        }

        @Override
        public void teardown(org.hibernate.Session hibSession) {
            if (this.iUpdateClassification) {
                Document doc = DocumentHelper.createDocument();
                this.iModel.saveAsXml(doc.addElement(CurriculaRequestsCourseDemands.this.getCacheName()), this.iAssignment);
                this.iClassification.setStudentsDocument(doc);
                hibSession.merge((Object)this.iClassification);
            }
            int idx = 0;
            for (CurStudent s : this.iModel.getStudents()) {
                Set<StudentCourseDemands.WeightedStudentId> courseStudents;
                Set<Object> studentCourses;
                StudentCourseDemands.WeightedStudentId student = null;
                student = s.getStudentId() < 0L ? this.iMadeUpStudents.get(idx++) : this.iStudentIds.get(s.getStudentId());
                if (CurriculaRequestsCourseDemands.this.iStudentCourseRequests.isIncludeAlternatives() && s.getStudentId() > 0L) {
                    studentCourses = CurriculaRequestsCourseDemands.this.iStudentCourseRequests.getCourses(s.getStudentId());
                    CurriculaRequestsCourseDemands.this.iStudentRequests.put(student.getStudentId(), studentCourses);
                    for (StudentCourseDemands.WeightedCourseOffering weightedCourseOffering : studentCourses) {
                        Set<StudentCourseDemands.WeightedStudentId> courseStudents2 = CurriculaRequestsCourseDemands.this.iDemands.get(weightedCourseOffering.getCourseOfferingId());
                        if (courseStudents2 == null) {
                            courseStudents2 = new HashSet<StudentCourseDemands.WeightedStudentId>();
                            CurriculaRequestsCourseDemands.this.iDemands.put(weightedCourseOffering.getCourseOfferingId(), courseStudents2);
                        }
                        StudentCourseDemands.WeightedStudentId copy = new StudentCourseDemands.WeightedStudentId(student, weightedCourseOffering.getWeight() * student.getWeight());
                        copy.setPrimaryOfferingId(weightedCourseOffering.getPrimaryOfferingId());
                        courseStudents2.add(copy);
                    }
                    continue;
                }
                studentCourses = new HashSet();
                CurriculaRequestsCourseDemands.this.iStudentRequests.put(student.getStudentId(), studentCourses);
                Hashtable<Long, Double> priorities = new Hashtable<Long, Double>();
                CurriculaRequestsCourseDemands.this.iEnrollmentPriorities.put(student.getStudentId(), priorities);
                for (CurCourse course : s.getCourses(this.iAssignment)) {
                    CourseOffering co = this.iCourses.get(course.getCourseId());
                    if (course.getPriority() != null) {
                        priorities.put(co.getUniqueId(), course.getPriority());
                    }
                    if ((courseStudents = CurriculaRequestsCourseDemands.this.iDemands.get(co.getUniqueId())) == null) {
                        courseStudents = new HashSet<StudentCourseDemands.WeightedStudentId>();
                        CurriculaRequestsCourseDemands.this.iDemands.put(co.getUniqueId(), courseStudents);
                    }
                    courseStudents.add(student);
                    studentCourses.add(new StudentCourseDemands.WeightedCourseOffering(co, student.getWeight()));
                }
                if (!CurriculaRequestsCourseDemands.this.iIncludeOtherCourses) continue;
                for (CourseOffering co : this.iStudents.get(this.iStudentIds.get(s.getStudentId()))) {
                    CurCourse curCourse = this.iModel.getCourse(co.getUniqueId());
                    if (curCourse != null) continue;
                    courseStudents = CurriculaRequestsCourseDemands.this.iDemands.get(co.getUniqueId());
                    if (courseStudents == null) {
                        courseStudents = new HashSet<StudentCourseDemands.WeightedStudentId>();
                        CurriculaRequestsCourseDemands.this.iDemands.put(co.getUniqueId(), courseStudents);
                    }
                    courseStudents.add(student);
                    studentCourses.add(new StudentCourseDemands.WeightedCourseOffering(co, student.getWeight()));
                }
            }
            Set<String> majors = CurriculaRequestsCourseDemands.this.iLoadedCurricula.get(this.iClassification.getCurriculum().getAcademicArea().getAcademicAreaAbbreviation() + ":" + this.iClassification.getAcademicClassification().getCode());
            if (majors == null) {
                majors = new HashSet<String>();
                CurriculaRequestsCourseDemands.this.iLoadedCurricula.put(this.iClassification.getCurriculum().getAcademicArea().getAcademicAreaAbbreviation() + ":" + this.iClassification.getAcademicClassification().getCode(), majors);
            }
            if (this.iClassification.getCurriculum().getMajors().isEmpty()) {
                majors.add("");
            } else {
                for (PosMajor mj : this.iClassification.getCurriculum().getMajors()) {
                    majors.add(mj.getCode());
                }
            }
        }
    }
}

