/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.curricula;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.DefaultSingleAssignment;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.IdGenerator;
import org.cpsolver.ifs.util.Progress;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.hibernate.query.Query;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.Curriculum;
import org.unitime.timetable.model.CurriculumClassification;
import org.unitime.timetable.model.CurriculumCourse;
import org.unitime.timetable.model.CurriculumCourseGroup;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.PosMajor;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.base.BasePosMajor;
import org.unitime.timetable.solver.curricula.CurriculaCourseDemands;
import org.unitime.timetable.solver.curricula.CurriculumEnrollmentPriorityProvider;
import org.unitime.timetable.solver.curricula.DefaultCurriculumEnrollmentPriorityProvider;
import org.unitime.timetable.solver.curricula.ParallelInitialization;
import org.unitime.timetable.solver.curricula.ProjectedStudentCourseDemands;
import org.unitime.timetable.solver.curricula.StudentCourseDemands;
import org.unitime.timetable.solver.curricula.students.CurCourse;
import org.unitime.timetable.solver.curricula.students.CurModel;
import org.unitime.timetable.solver.curricula.students.CurStudent;
import org.unitime.timetable.solver.curricula.students.CurValue;
import org.unitime.timetable.solver.curricula.students.CurVariable;

public class CurriculaLastLikeCourseDemands
implements StudentCourseDemands,
StudentCourseDemands.NeedsStudentIdGenerator {
    private static Log sLog = LogFactory.getLog(CurriculaLastLikeCourseDemands.class);
    private ProjectedStudentCourseDemands iProjectedDemands;
    private IdGenerator iLastStudentId = null;
    private Hashtable<Long, Set<StudentCourseDemands.WeightedStudentId>> iDemands = new Hashtable();
    private Hashtable<Long, Set<StudentCourseDemands.WeightedCourseOffering>> iStudentRequests = new Hashtable();
    private Hashtable<String, Set<String>> iLoadedCurricula = new Hashtable();
    private Hashtable<Long, Hashtable<Long, Double>> iEnrollmentPriorities = new Hashtable();
    private HashSet<Long> iCheckedCourses = new HashSet();
    private boolean iIncludeOtherStudents = true;
    private boolean iIncludeOtherCourses = true;
    private boolean iSetStudentCourseLimits = false;
    private boolean iCreateStudentGroups = true;
    private CurriculumEnrollmentPriorityProvider iEnrollmentPriorityProvider = null;
    private DataProperties iProperties = null;

    public CurriculaLastLikeCourseDemands(DataProperties config) {
        this.iProperties = config;
        this.iProjectedDemands = new ProjectedStudentCourseDemands(config);
        this.iIncludeOtherStudents = config.getPropertyBoolean("CurriculaCourseDemands.IncludeOtherStudents", this.iIncludeOtherStudents);
        this.iIncludeOtherCourses = config.getPropertyBoolean("CurriculaCourseDemands.IncludeOtherCourses", config.getPropertyBoolean("CurriculaCourseDemands.IncludeOtherStudents", this.iIncludeOtherCourses));
        this.iSetStudentCourseLimits = config.getPropertyBoolean("CurriculaCourseDemands.SetStudentCourseLimits", this.iSetStudentCourseLimits);
        this.iCreateStudentGroups = config.getPropertyBoolean("CurriculaCourseDemands.CreateStudentGroups", this.iCreateStudentGroups);
        this.iEnrollmentPriorityProvider = new DefaultCurriculumEnrollmentPriorityProvider(config);
        if (config.getProperty("CurriculaCourseDemands.CurriculumEnrollmentPriorityProvider") != null) {
            try {
                this.iEnrollmentPriorityProvider = (CurriculumEnrollmentPriorityProvider)Class.forName(config.getProperty("CurriculaCourseDemands.CurriculumEnrollmentPriorityProvider")).getConstructor(DataProperties.class).newInstance(config);
            }
            catch (Exception e) {
                sLog.error((Object)("Failed to use custom enrollment priority provider: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    @Override
    public void init(org.hibernate.Session hibSession, Progress progress, Session session, Collection<InstructionalOffering> offerings) {
        this.iProjectedDemands.init(hibSession, progress, session, offerings);
        ArrayList curricula = null;
        if (offerings != null && offerings.size() <= 1000) {
            Object courses = "";
            int nrCourses = 0;
            for (InstructionalOffering offering : offerings) {
                for (CourseOffering course : offering.getCourseOfferings()) {
                    if (!((String)courses).isEmpty()) {
                        courses = (String)courses + ",";
                    }
                    courses = (String)courses + course.getUniqueId();
                    ++nrCourses;
                }
            }
            if (nrCourses > 0 && nrCourses <= 1000) {
                HashSet curriculaSet = new HashSet(hibSession.createQuery("select distinct c from CurriculumCourse cc inner join cc.classification.curriculum c where c.academicArea.session.uniqueId = :sessionId and cc.course.uniqueId in (" + (String)courses + ")", Curriculum.class).setParameter("sessionId", (Object)session.getUniqueId()).list());
                curriculaSet.addAll(hibSession.createQuery("select distinct d from CurriculumCourse cc inner join cc.classification.curriculum c, Curriculum d where c.academicArea = d.academicArea and d.multipleMajors = true and size(c.majors) <= 1 and size(c.majors) < size(d.majors) and (select count(m) from Curriculum x inner join x.majors m where x.uniqueId = c.uniqueId and m not in elements(d.majors)) = 0 and c.academicArea.session.uniqueId = :sessionId and cc.course.uniqueId in (" + (String)courses + ")", Curriculum.class).setParameter("sessionId", (Object)session.getUniqueId()).list());
                curriculaSet.addAll(hibSession.createQuery("select distinct d from CurriculumCourse cc inner join cc.classification.curriculum c, Curriculum d where c.multipleMajors = true and size(c.majors) >= 1 and size(c.majors) > size(d.majors) and c.academicArea = d.academicArea and (select count(m) from Curriculum x inner join x.majors m where x.uniqueId = d.uniqueId and m not in elements(c.majors)) = 0 and c.academicArea.session.uniqueId = :sessionId and cc.course.uniqueId in (" + (String)courses + ")", Curriculum.class).setParameter("sessionId", (Object)session.getUniqueId()).list());
                curricula = new ArrayList(curriculaSet);
            }
        }
        if (curricula == null) {
            curricula = hibSession.createQuery("select c from Curriculum c where c.academicArea.session.uniqueId = :sessionId", Curriculum.class).setParameter("sessionId", (Object)session.getUniqueId()).list();
        }
        ArrayList<Initialization> inits = new ArrayList<Initialization>();
        for (Curriculum curriculum : curricula) {
            for (CurriculumClassification clasf : curriculum.getClassifications()) {
                if (clasf.getNrStudents() <= 0) continue;
                ArrayList<CurriculumClassification> templates = new ArrayList<CurriculumClassification>();
                if (curriculum.isMultipleMajors().booleanValue()) {
                    for (Curriculum parent : curricula) {
                        if (!parent.isTemplateFor(curriculum)) continue;
                        for (CurriculumClassification parentClasf : parent.getClassifications()) {
                            if (!parentClasf.getAcademicClassification().equals(clasf.getAcademicClassification())) continue;
                            templates.add(parentClasf);
                        }
                    }
                }
                inits.add(new Initialization(clasf, templates, this.loadLastLikeStudents(hibSession, clasf)));
            }
        }
        new ParallelInitialization("Loading curricula", this.iProperties.getPropertyInt("CurriculaCourseDemands.NrThreads", 1), inits).execute(hibSession, progress);
    }

    /*
     * WARNING - void declaration
     */
    private Map<CourseOffering, Set<StudentCourseDemands.WeightedStudentId>> loadLastLikeStudents(org.hibernate.Session hibSession, CurriculumClassification cc) {
        String select = "distinct co, s, a.weight";
        Object from = "CourseOffering co, LastLikeCourseDemand x inner join x.student s inner join s.areaClasfMajors a";
        String[] checks = new String[]{"x.subjectArea.session.uniqueId = :sessionId and a.academicArea.academicAreaAbbreviation = :acadAbbv and a.academicClassification.code = :clasfCode and co.subjectArea.uniqueId = x.subjectArea.uniqueId and x.coursePermId is not null and co.permId=x.coursePermId", "x.subjectArea.session.uniqueId = :sessionId and a.academicArea.academicAreaAbbreviation = :acadAbbv and a.academicClassification.code = :clasfCode and co.subjectArea.uniqueId = x.subjectArea.uniqueId and x.coursePermId is null and co.courseNbr=x.courseNbr", "x.subjectArea.session.uniqueId = :sessionId and a.academicArea.academicAreaAbbreviation = :acadAbbv and a.academicClassification.code = :clasfCode and co.demandOffering.subjectArea.uniqueId = x.subjectArea.uniqueId and x.coursePermId is not null and co.demandOffering.permId=x.coursePermId", "x.subjectArea.session.uniqueId = :sessionId and a.academicArea.academicAreaAbbreviation = :acadAbbv and a.academicClassification.code = :clasfCode and co.demandOffering.subjectArea.uniqueId = x.subjectArea.uniqueId and x.coursePermId is null and co.demandOffering.courseNbr=x.courseNbr"};
        HashMap<CourseOffering, Set<StudentCourseDemands.WeightedStudentId>> course2ll = new HashMap<CourseOffering, Set<StudentCourseDemands.WeightedStudentId>>();
        for (String string : checks) {
            List lines = null;
            if (cc.getCurriculum().getMajors().isEmpty()) {
                if (!cc.getCurriculum().isMultipleMajors().booleanValue()) {
                    lines = hibSession.createQuery("select " + select + " from " + (String)from + " where " + string, Object[].class).setParameter("sessionId", (Object)cc.getCurriculum().getAcademicArea().getSessionId()).setParameter("acadAbbv", (Object)cc.getCurriculum().getAcademicArea().getAcademicAreaAbbreviation()).setParameter("clasfCode", (Object)cc.getAcademicClassification().getCode()).setCacheable(true).list();
                }
            } else if (!cc.getCurriculum().isMultipleMajors().booleanValue() || cc.getCurriculum().getMajors().size() == 1) {
                ArrayList<String> codes = new ArrayList<String>();
                for (PosMajor posMajor : cc.getCurriculum().getMajors()) {
                    codes.add(posMajor.getCode());
                }
                lines = hibSession.createQuery("select " + select + " from " + (String)from + " where " + string + " and a.major.code in :majorCodes", Object[].class).setParameter("sessionId", (Object)cc.getCurriculum().getAcademicArea().getSessionId()).setParameter("acadAbbv", (Object)cc.getCurriculum().getAcademicArea().getAcademicAreaAbbreviation()).setParameter("clasfCode", (Object)cc.getAcademicClassification().getCode()).setParameterList("majorCodes", codes).setCacheable(true).list();
            } else {
                void var10_10;
                Object major22;
                HashMap<CallSite, String> params = new HashMap<CallSite, String>();
                int idx = 0;
                for (Object major22 : cc.getCurriculum().getMajors()) {
                    if (idx == 0) {
                        String string2 = (String)var10_10 + " and a.major.code = :m" + idx;
                    } else {
                        from = (String)from + " inner join s.areaClasfMajors a" + idx;
                        String string3 = (String)var10_10 + " and a" + idx + ".academicArea.academicAreaAbbreviation = :acadAbbv and a" + idx + ".academicClassification.code = :clasfCode and a" + idx + ".major.code = :m" + idx;
                    }
                    params.put((CallSite)((Object)("m" + idx)), ((BasePosMajor)major22).getCode());
                    ++idx;
                }
                Query query = hibSession.createQuery("select " + select + " from " + (String)from + " where " + (String)var10_10, Object[].class).setParameter("sessionId", (Object)cc.getCurriculum().getAcademicArea().getSessionId()).setParameter("acadAbbv", (Object)cc.getCurriculum().getAcademicArea().getAcademicAreaAbbreviation()).setParameter("clasfCode", (Object)cc.getAcademicClassification().getCode());
                major22 = params.entrySet().iterator();
                while (major22.hasNext()) {
                    Map.Entry entry = (Map.Entry)major22.next();
                    query.setParameter((String)entry.getKey(), entry.getValue());
                }
                lines = query.setCacheable(true).list();
            }
            if (lines == null) continue;
            for (Object[] o : lines) {
                HashSet<StudentCourseDemands.WeightedStudentId> students;
                CourseOffering courseOffering = (CourseOffering)o[0];
                Student student = (Student)o[1];
                Double d = (Double)o[2];
                StudentCourseDemands.WeightedStudentId studentId = new StudentCourseDemands.WeightedStudentId(student, this.iProjectedDemands);
                studentId.setWeight(d.floatValue());
                studentId.setCurriculum(cc.getCurriculum().getAbbv() + " " + cc.getAcademicClassification().getCode());
                if (this.iCreateStudentGroups) {
                    studentId.getGroups().add(new StudentCourseDemands.Group(-cc.getUniqueId().longValue(), cc.getCurriculum().getAbbv() + " " + cc.getAcademicClassification().getCode()));
                }
                if ((students = (HashSet<StudentCourseDemands.WeightedStudentId>)course2ll.get(courseOffering)) == null) {
                    students = new HashSet<StudentCourseDemands.WeightedStudentId>();
                    course2ll.put(courseOffering, students);
                }
                students.add(studentId);
            }
        }
        return course2ll;
    }

    protected String getCacheName() {
        return "curriculum-lastlike-demands";
    }

    protected void computeTargetShare(CurriculumClassification clasf, Collection<CurriculumCourse> courses, CurriculaCourseDemands.CurriculumCourseGroupsProvider course2groups, CurModel model) {
        for (CurriculumCourse c1 : courses) {
            double x1 = (float)clasf.getNrStudents().intValue() * c1.getPercShare().floatValue();
            HashSet[] group = new HashSet[]{new HashSet(), new HashSet()};
            LinkedList<CurriculumCourse> queue = new LinkedList<CurriculumCourse>();
            queue.add(c1);
            HashSet<CurriculumCourseGroup> done = new HashSet<CurriculumCourseGroup>();
            while (!queue.isEmpty()) {
                CurriculumCourse c = (CurriculumCourse)queue.poll();
                for (CurriculumCourseGroup g : course2groups.getGroups(c)) {
                    if (!done.add(g)) continue;
                    for (CurriculumCourse x : courses) {
                        if (x.equals(c) || x.equals(c1) || !course2groups.getGroups(x).contains(g) || !group[group[0].contains(c) ? 0 : g.getType()].add(x)) continue;
                        queue.add(x);
                    }
                }
            }
            for (CurriculumCourse c2 : courses) {
                double x2 = (float)clasf.getNrStudents().intValue() * c2.getPercShare().floatValue();
                if (c1.getUniqueId() >= c2.getUniqueId()) continue;
                double share = 0.0;
                Set<StudentCourseDemands.WeightedStudentId> s1 = this.iProjectedDemands.getDemands(c1.getCourse());
                Set<StudentCourseDemands.WeightedStudentId> s2 = this.iProjectedDemands.getDemands(c2.getCourse());
                double sharedStudents = 0.0;
                double lastLike = 0.0;
                if (s1 != null && !s1.isEmpty() && s2 != null && !s2.isEmpty()) {
                    for (StudentCourseDemands.WeightedStudentId s : s1) {
                        if (!s.match(clasf)) continue;
                        lastLike += (double)s.getWeight();
                        if (!s2.contains(s)) continue;
                        sharedStudents += (double)s.getWeight();
                    }
                }
                if (lastLike > 0.0) {
                    double requested = c1.getPercShare().floatValue() * (float)clasf.getNrStudents().intValue();
                    share = requested / lastLike * sharedStudents;
                } else {
                    share = c1.getPercShare().floatValue() * c2.getPercShare().floatValue() * (float)clasf.getNrStudents().intValue();
                }
                boolean opt = group[0].contains(c2);
                boolean req = !opt && group[1].contains(c2);
                model.setTargetShare(c1.getCourse().getUniqueId(), c2.getCourse().getUniqueId(), opt ? 0.0 : (req ? Math.min(x1, x2) : share), false);
            }
        }
    }

    @Override
    public Set<StudentCourseDemands.WeightedCourseOffering> getCourses(Long studentId) {
        Set<StudentCourseDemands.WeightedCourseOffering> courses = this.iStudentRequests.get(studentId);
        if (this.iIncludeOtherStudents && studentId >= 0L && courses == null) {
            return this.iProjectedDemands.getCourses(studentId);
        }
        return this.iStudentRequests.get(studentId);
    }

    @Override
    public Set<StudentCourseDemands.WeightedStudentId> getDemands(CourseOffering course) {
        if (this.iDemands.isEmpty()) {
            return this.iProjectedDemands.getDemands(course);
        }
        Set<StudentCourseDemands.WeightedStudentId> demands = this.iDemands.get(course.getUniqueId());
        if (!this.iIncludeOtherStudents) {
            return demands;
        }
        if (demands == null) {
            demands = new HashSet<StudentCourseDemands.WeightedStudentId>();
            this.iDemands.put(course.getUniqueId(), demands);
        }
        if (this.iCheckedCourses.add(course.getUniqueId())) {
            int was = demands.size();
            Set<StudentCourseDemands.WeightedStudentId> other = this.iProjectedDemands.getDemands(course);
            if (other == null) {
                sLog.debug((Object)(course.getCourseName() + " has no students."));
            } else {
                if (this.iLoadedCurricula == null || this.iLoadedCurricula.isEmpty()) {
                    demands.addAll(other);
                } else {
                    block0: for (StudentCourseDemands.WeightedStudentId student : other) {
                        for (StudentCourseDemands.AreaClasfMajor acm : student.getMajors()) {
                            Set<String> majors = this.iLoadedCurricula.get(acm.getArea());
                            if (majors == null || !majors.contains("") && !student.match(acm.getArea(), majors)) continue;
                            continue block0;
                        }
                        demands.add(student);
                    }
                }
                if (demands.size() > was) {
                    sLog.debug((Object)(course.getCourseName() + " has " + (demands.size() - was) + " other students (besides of the " + was + " curriculum students)."));
                }
            }
        }
        return demands;
    }

    @Override
    public boolean canUseStudentClassEnrollmentsAsSolution() {
        return false;
    }

    @Override
    public boolean isMakingUpStudents() {
        return false;
    }

    @Override
    public boolean isWeightStudentsToFillUpOffering() {
        return false;
    }

    @Override
    public Double getEnrollmentPriority(Long studentId, Long courseId) {
        Hashtable<Long, Double> priorities = this.iEnrollmentPriorities.get(studentId);
        return priorities == null ? null : priorities.get(courseId);
    }

    @Override
    public void setStudentIdGenerator(IdGenerator generator) {
        this.iLastStudentId = generator;
    }

    public class Initialization
    implements ParallelInitialization.Task {
        private CurriculumClassification iClassification;
        private List<CurriculumClassification> iTemplates;
        private boolean iUpdateClassification = false;
        private Map<CourseOffering, Set<StudentCourseDemands.WeightedStudentId>> iLastLikeStudents;
        private CurModel iModel;
        private Hashtable<Long, CourseOffering> iCourses;
        private List<CurStudent> iCurStudents;
        private Hashtable<StudentCourseDemands.WeightedStudentId, Set<CourseOffering>> iStudents;
        private List<StudentCourseDemands.WeightedStudentId> iMadeUpStudents;
        private Hashtable<Long, StudentCourseDemands.WeightedStudentId> iStudentIds;
        private Assignment<CurVariable, CurValue> iAssignment;

        public Initialization(CurriculumClassification classification, List<CurriculumClassification> templates, Map<CourseOffering, Set<StudentCourseDemands.WeightedStudentId>> lastLikeStudents) {
            this.iClassification = classification;
            this.iLastLikeStudents = lastLikeStudents;
            this.iTemplates = templates;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void setup(org.hibernate.Session hibSession) {
            Element cache;
            void var3_11;
            sLog.debug((Object)("Processing " + this.iClassification.getCurriculum().getAbbv() + " " + this.iClassification.getName() + " ... (" + this.iClassification.getNrStudents() + " students, " + this.iClassification.getCourses().size() + " iCourses)"));
            this.iStudents = new Hashtable();
            if (this.iLastLikeStudents != null) {
                for (Map.Entry<CourseOffering, Set<StudentCourseDemands.WeightedStudentId>> entry : this.iLastLikeStudents.entrySet()) {
                    for (StudentCourseDemands.WeightedStudentId weightedStudentId : entry.getValue()) {
                        Set<CourseOffering> courses = this.iStudents.get(weightedStudentId);
                        if (courses == null) {
                            courses = new HashSet<CourseOffering>();
                            this.iStudents.put(weightedStudentId, courses);
                        }
                        courses.add(entry.getKey());
                    }
                }
            }
            float totalWeight = 0.0f;
            for (StudentCourseDemands.WeightedStudentId student : this.iStudents.keySet()) {
                totalWeight += student.getWeight();
            }
            sLog.debug((Object)("  last-like students: " + totalWeight + ", target: " + this.iClassification.getNrStudents()));
            this.iMadeUpStudents = new ArrayList<StudentCourseDemands.WeightedStudentId>();
            if (2.0f * totalWeight < (float)this.iClassification.getNrStudents().intValue()) {
                void var5_16;
                int n = Math.round((float)this.iClassification.getNrStudents().intValue() - totalWeight);
                sLog.debug((Object)("    making up " + n + " students"));
                Object majors = "";
                for (PosMajor major : this.iClassification.getCurriculum().getMajors()) {
                    if (!((String)majors).isEmpty()) {
                        majors = (String)majors + "|";
                    }
                    majors = (String)majors + major.getCode();
                }
                boolean bl = false;
                while (var5_16 < n) {
                    Iterator<Object> student = new StudentCourseDemands.WeightedStudentId(-CurriculaLastLikeCourseDemands.this.iLastStudentId.newId(), this.iClassification);
                    if (CurriculaLastLikeCourseDemands.this.iCreateStudentGroups) {
                        ((StudentCourseDemands.WeightedStudentId)((Object)student)).getGroups().add(new StudentCourseDemands.Group(-this.iClassification.getUniqueId().longValue(), this.iClassification.getCurriculum().getAbbv() + " " + this.iClassification.getAcademicClassification().getCode()));
                    }
                    this.iStudents.put((StudentCourseDemands.WeightedStudentId)((Object)student), new HashSet());
                    this.iMadeUpStudents.add((StudentCourseDemands.WeightedStudentId)((Object)student));
                    ++var5_16;
                }
            } else {
                float f = (float)this.iClassification.getNrStudents().intValue() / totalWeight;
                sLog.debug((Object)("    changing student weight " + f + " times"));
                for (StudentCourseDemands.WeightedStudentId weightedStudentId : this.iStudents.keySet()) {
                    weightedStudentId.setWeight(weightedStudentId.getWeight() * f);
                }
            }
            Object var3_8 = null;
            CurriculaCourseDemands.CurriculumCourseGroupsProvider course2groups = null;
            if (this.iTemplates == null || this.iTemplates.isEmpty()) {
                Set<CurriculumCourse> set = this.iClassification.getCourses();
                course2groups = new CurriculaCourseDemands.DefaultCurriculumCourseGroupsProvider();
            } else {
                HashMap<Long, CurriculumCourse> hashMap = new HashMap<Long, CurriculumCourse>();
                course2groups = new CurriculaCourseDemands.TableCurriculumCourseGroupsProvider();
                for (CurriculumClassification template : this.iTemplates) {
                    for (CurriculumCourse course : template.getCourses()) {
                        CurriculumCourse prev = (CurriculumCourse)hashMap.get(course.getCourse().getUniqueId());
                        if (prev == null || prev.getPercShare().floatValue() < course.getPercShare().floatValue()) {
                            hashMap.put(course.getCourse().getUniqueId(), course);
                        }
                        ((CurriculaCourseDemands.TableCurriculumCourseGroupsProvider)course2groups).add(course);
                    }
                }
                for (CurriculumCourse course : this.iClassification.getCourses()) {
                    hashMap.put(course.getCourse().getUniqueId(), course);
                    ((CurriculaCourseDemands.TableCurriculumCourseGroupsProvider)course2groups).add(course);
                }
                Collection collection = hashMap.values();
            }
            this.iCurStudents = new ArrayList<CurStudent>();
            this.iStudentIds = new Hashtable();
            boolean bl = false;
            for (StudentCourseDemands.WeightedStudentId student : this.iStudents.keySet()) {
                void var5_21;
                this.iCurStudents.add(new CurStudent(student.getStudentId() < 0L ? (long)(-(++var5_21)) : student.getStudentId(), student.getWeight()));
                this.iStudentIds.put(student.getStudentId() < 0L ? (long)(-var5_21) : student.getStudentId(), student);
            }
            this.iModel = new CurModel(this.iCurStudents);
            this.iCourses = new Hashtable();
            for (CurriculumCourse course : var3_11) {
                this.iModel.addCourse(course.getCourse().getUniqueId(), course.getCourse().getCourseName(), (float)this.iClassification.getNrStudents().intValue() * course.getPercShare().floatValue(), CurriculaLastLikeCourseDemands.this.iEnrollmentPriorityProvider.getEnrollmentPriority(course, course2groups));
                this.iCourses.put(course.getCourse().getUniqueId(), course.getCourse());
            }
            CurriculaLastLikeCourseDemands.this.computeTargetShare(this.iClassification, (Collection<CurriculumCourse>)var3_11, course2groups, this.iModel);
            if (CurriculaLastLikeCourseDemands.this.iSetStudentCourseLimits) {
                this.iModel.setStudentLimits();
            }
            Solution<CurVariable, CurValue> cachedSolution = null;
            this.iAssignment = new DefaultSingleAssignment();
            Document cachedXml = this.iClassification.getStudentsDocument();
            Element element = cache = cachedXml == null ? null : cachedXml.getRootElement();
            if (cache != null && cache.getName().equals(CurriculaLastLikeCourseDemands.this.getCacheName())) {
                cachedSolution = CurModel.loadFromXml(cache);
                if (CurriculaLastLikeCourseDemands.this.iSetStudentCourseLimits) {
                    ((CurModel)cachedSolution.getModel()).setStudentLimits();
                }
            }
            if (cachedSolution != null && ((CurModel)cachedSolution.getModel()).isSameModel((Object)this.iModel)) {
                sLog.debug((Object)"  using cached model...");
                this.iModel = (CurModel)cachedSolution.getModel();
                this.iAssignment = cachedSolution.getAssignment();
            } else {
                for (CurStudent student : this.iCurStudents) {
                    for (CourseOffering course : this.iStudents.get(this.iStudentIds.get(student.getStudentId()))) {
                        CurCourse curCourse = this.iModel.getCourse(course.getUniqueId());
                        if (curCourse == null) continue;
                        CurVariable var = null;
                        for (CurVariable v : curCourse.variables()) {
                            if (this.iAssignment.getValue((Variable)v) != null) continue;
                            var = v;
                            break;
                        }
                        if (var != null) {
                            CurValue val = new CurValue(var, student);
                            if (!this.iModel.inConflict(this.iAssignment, val)) {
                                this.iAssignment.assign(0L, (Value)val);
                                continue;
                            }
                            sLog.debug((Object)("Unable to assign " + student + " to " + var));
                            Map conf = this.iModel.conflictConstraints(this.iAssignment, val);
                            for (Map.Entry entry : conf.entrySet()) {
                                sLog.debug((Object)(entry.getKey() + ": " + entry.getValue()));
                            }
                            continue;
                        }
                        sLog.debug((Object)("No variable for " + student + " to " + curCourse));
                    }
                }
                this.iUpdateClassification = true;
            }
        }

        @Override
        public void execute() {
            if (this.iUpdateClassification) {
                sLog.debug((Object)("Initial: " + this.iModel.getInfo(this.iAssignment)));
                this.iModel.solve(CurriculaLastLikeCourseDemands.this.iProperties, this.iAssignment);
                sLog.debug((Object)("Final: " + this.iModel.getInfo(this.iAssignment)));
            }
        }

        @Override
        public void teardown(org.hibernate.Session hibSession) {
            if (this.iUpdateClassification) {
                Document doc = DocumentHelper.createDocument();
                this.iModel.saveAsXml(doc.addElement(CurriculaLastLikeCourseDemands.this.getCacheName()), this.iAssignment);
                this.iClassification.setStudentsDocument(doc);
                hibSession.merge((Object)this.iClassification);
            }
            int idx = 0;
            for (CurStudent s : this.iModel.getStudents()) {
                Set<StudentCourseDemands.WeightedStudentId> courseStudents;
                StudentCourseDemands.WeightedStudentId student = null;
                student = s.getStudentId() < 0L ? this.iMadeUpStudents.get(idx++) : this.iStudentIds.get(s.getStudentId());
                HashSet<StudentCourseDemands.WeightedCourseOffering> studentCourses = new HashSet<StudentCourseDemands.WeightedCourseOffering>();
                CurriculaLastLikeCourseDemands.this.iStudentRequests.put(student.getStudentId(), studentCourses);
                Hashtable<Long, Double> priorities = new Hashtable<Long, Double>();
                CurriculaLastLikeCourseDemands.this.iEnrollmentPriorities.put(student.getStudentId(), priorities);
                for (CurCourse course : s.getCourses(this.iAssignment)) {
                    CourseOffering co = this.iCourses.get(course.getCourseId());
                    if (course.getPriority() != null) {
                        priorities.put(co.getUniqueId(), course.getPriority());
                    }
                    if ((courseStudents = CurriculaLastLikeCourseDemands.this.iDemands.get(co.getUniqueId())) == null) {
                        courseStudents = new HashSet<StudentCourseDemands.WeightedStudentId>();
                        CurriculaLastLikeCourseDemands.this.iDemands.put(co.getUniqueId(), courseStudents);
                    }
                    courseStudents.add(student);
                    studentCourses.add(new StudentCourseDemands.WeightedCourseOffering(co, student.getWeight()));
                }
                if (!CurriculaLastLikeCourseDemands.this.iIncludeOtherCourses) continue;
                for (CourseOffering co : this.iStudents.get(this.iStudentIds.get(s.getStudentId()))) {
                    CurCourse curCourse = this.iModel.getCourse(co.getUniqueId());
                    if (curCourse != null) continue;
                    courseStudents = CurriculaLastLikeCourseDemands.this.iDemands.get(co.getUniqueId());
                    if (courseStudents == null) {
                        courseStudents = new HashSet<StudentCourseDemands.WeightedStudentId>();
                        CurriculaLastLikeCourseDemands.this.iDemands.put(co.getUniqueId(), courseStudents);
                    }
                    courseStudents.add(student);
                    studentCourses.add(new StudentCourseDemands.WeightedCourseOffering(co, student.getWeight()));
                }
            }
            Set<String> majors = CurriculaLastLikeCourseDemands.this.iLoadedCurricula.get(this.iClassification.getCurriculum().getAcademicArea().getAcademicAreaAbbreviation());
            if (majors == null) {
                majors = new HashSet<String>();
                CurriculaLastLikeCourseDemands.this.iLoadedCurricula.put(this.iClassification.getCurriculum().getAcademicArea().getAcademicAreaAbbreviation(), majors);
            }
            if (this.iClassification.getCurriculum().getMajors().isEmpty()) {
                majors.add("");
            } else {
                for (PosMajor mj : this.iClassification.getCurriculum().getMajors()) {
                    majors.add(mj.getCode());
                }
            }
        }
    }
}

