/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.course.ui;

import java.io.Serializable;
import java.util.BitSet;
import org.springframework.web.util.HtmlUtils;
import org.unitime.commons.NaturalOrderComparator;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.dao.DatePatternDAO;

public class ClassDateInfo
implements Serializable,
Comparable<ClassDateInfo> {
    private static final long serialVersionUID = 1113308106992466641L;
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    private static NaturalOrderComparator sCmp = new NaturalOrderComparator();
    private Long iId;
    private Long iClassId;
    private String iName;
    private BitSet iPattern;
    private int iPreference;
    private transient DatePattern iDatePattern = null;

    public ClassDateInfo(Long id, Long classId, String name, BitSet pattern, int preference) {
        this.iId = id;
        this.iClassId = classId;
        this.iName = name;
        this.iPattern = pattern;
        this.iPreference = preference;
    }

    public ClassDateInfo(Assignment a, int preference) {
        this.iId = a.getDatePattern().getUniqueId();
        this.iClassId = a.getClassId();
        this.iName = a.getDatePattern().getName();
        this.iPattern = a.getDatePattern().getPatternBitSet();
        this.iPreference = preference;
    }

    public Long getId() {
        return this.iId;
    }

    public Long getClassId() {
        return this.iClassId;
    }

    public String getName() {
        return this.iName;
    }

    public BitSet getPattern() {
        return this.iPattern;
    }

    public int getPreference() {
        return this.iPreference;
    }

    public int hashCode() {
        return this.iId.hashCode();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof ClassDateInfo)) {
            return false;
        }
        return this.getId().equals(((ClassDateInfo)o).getId());
    }

    public String toString() {
        return this.getName();
    }

    public String toHtml() {
        return "<span style='color:" + PreferenceLevel.int2color(this.getPreference()) + "'>" + this.getName() + "</span>";
    }

    public String toLongHtml() {
        return "<span style='color:" + PreferenceLevel.int2color(this.getPreference()) + "'>" + this.getName() + "</span> <img style=\"cursor: pointer;\" src=\"images/calendar.png\" border=\"0\" onclick=\"showGwtDialog('" + HtmlUtils.htmlEscape((String)MSG.sectPreviewOfDatePattern(this.getName())) + "', 'dispDatePattern.action?id=" + this.getId() + "&classId=" + this.getClassId() + "','840','520');\">";
    }

    @Override
    public int compareTo(ClassDateInfo other) {
        int cmp = sCmp.compare(this.getName(), other.getName());
        return cmp == 0 ? this.getId().compareTo(other.getId()) : cmp;
    }

    public boolean overlaps(ClassDateInfo date) {
        return this.getPattern().intersects(date.getPattern());
    }

    public DatePattern getDatePattern() {
        if (this.iDatePattern == null) {
            this.iDatePattern = (DatePattern)DatePatternDAO.getInstance().get(this.getId());
        }
        return this.iDatePattern;
    }
}

