/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.Constraint;
import org.cpsolver.ifs.model.Model;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.solver.ParallelSolver;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.termination.TerminationCondition;
import org.cpsolver.ifs.util.Callback;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.ProblemLoader;
import org.cpsolver.ifs.util.ProblemSaver;
import org.cpsolver.ifs.util.Progress;
import org.cpsolver.ifs.util.ProgressListener;
import org.cpsolver.ifs.util.ProgressWriter;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.unitime.commons.Debug;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.resources.CPSolverMessages;
import org.unitime.timetable.solver.CommonSolverInterface;
import org.unitime.timetable.solver.SolverDisposeListener;
import org.unitime.timetable.solver.remote.BackupFileFilter;
import org.unitime.timetable.util.Constants;

public abstract class AbstractSolver<V extends Variable<V, T>, T extends Value<V, T>, M extends Model<V, T>>
extends ParallelSolver<V, T>
implements CommonSolverInterface {
    protected static CPSolverMessages MSG = Localization.create(CPSolverMessages.class);
    protected Log sLog = null;
    protected boolean iWorking = false;
    protected Date iLoadedDate = null;
    private SolverDisposeListener iDisposeListener = null;
    private long iLastTimeStamp = System.currentTimeMillis();
    private boolean iIsPassivated = false;
    private Map iProgressBeforePassivation = null;
    private Map<String, String> iCurrentSolutionInfoBeforePassivation = null;
    private Map<String, String> iBestSolutionInfoBeforePassivation = null;
    private File iPassivationFolder = null;
    private String iPassivationPuid = null;
    protected Thread iWorkThread = null;

    public AbstractSolver(DataProperties properties, SolverDisposeListener disposeListener) {
        super(properties);
        this.iDisposeListener = disposeListener;
        this.sLog = LogFactory.getLog(this.getClass());
    }

    @Override
    public Date getLoadedDate() {
        List log;
        if (this.iLoadedDate == null && !this.isPassivated() && (log = Progress.getInstance((Object)this.currentSolution().getModel()).getLog()) != null && !log.isEmpty()) {
            this.iLoadedDate = ((Progress.Message)log.get(0)).getDate();
        }
        return this.iLoadedDate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Progress.Message> getProgressLog(Integer level, String fromStage, Date since) {
        Progress p = Progress.getInstance((Object)this.currentSolution().getModel());
        List list = p.getLog();
        synchronized (list) {
            ArrayList<Progress.Message> log = new ArrayList<Progress.Message>();
            for (Progress.Message m : p.getLog()) {
                if (fromStage != null && m.getLevel() == 4 && m.getMessage().equals(fromStage)) {
                    log.clear();
                }
                if (level != null && m.getLevel() < level || since != null && !m.getDate().after(since)) continue;
                log.add(m);
            }
            return log;
        }
    }

    @Override
    public String getLog(int level, boolean includeDate, String fromStage) {
        if (fromStage == null) {
            return Progress.getInstance((Object)this.currentSolution().getModel()).getHtmlLog(level, includeDate);
        }
        return Progress.getInstance((Object)this.currentSolution().getModel()).getHtmlLog(level, includeDate, fromStage);
    }

    @Override
    public boolean isWorking() {
        if (this.isRunning()) {
            return true;
        }
        return this.iWorking;
    }

    @Override
    public void restoreBest() {
        this.currentSolution().restoreBest();
    }

    @Override
    public void saveBest() {
        this.currentSolution().saveBest();
    }

    @Override
    public Map getProgress() {
        if (this.isPassivated()) {
            return this.iProgressBeforePassivation;
        }
        try {
            Hashtable<String, Object> ret = new Hashtable<String, Object>();
            Progress p = Progress.getInstance((Object)super.currentSolution().getModel());
            ret.put("STATUS", p.getStatus());
            ret.put("PHASE", p.getPhase());
            ret.put("PROGRESS", p.getProgress());
            ret.put("MAX_PROGRESS", p.getProgressMax());
            ret.put("VERSION", Constants.getVersion());
            return ret;
        }
        catch (NullPointerException e) {
            return null;
        }
        catch (Exception e) {
            this.sLog.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public void setProperties(DataProperties properties) {
        this.activateIfNeeded();
        this.getProperties().putAll((Map)properties);
    }

    @Override
    public void setProperty(String name, String value) {
        this.activateIfNeeded();
        this.getProperties().setProperty(name, value);
    }

    @Override
    public void dispose() {
        this.disposeNoInherit(true);
    }

    protected void disposeNoInherit(boolean unregister) {
        super.dispose();
        if (this.currentSolution() != null && this.currentSolution().getModel() != null) {
            Progress.removeInstance((Object)this.currentSolution().getModel());
        }
        this.setInitalSolution(null);
        if (unregister && this.iDisposeListener != null) {
            this.iDisposeListener.onDispose();
        }
    }

    @Override
    public String getHost() {
        return "local";
    }

    @Override
    public String getUser() {
        return this.getProperties().getProperty("General.OwnerPuid");
    }

    @Override
    public Map<String, String> currentSolutionInfo() {
        if (this.isPassivated()) {
            return this.iCurrentSolutionInfoBeforePassivation;
        }
        Lock lock = this.currentSolution().getLock().readLock();
        lock.lock();
        try {
            Map map = super.currentSolution().getExtendedInfo();
            return map;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public Map<String, String> bestSolutionInfo() {
        if (this.isPassivated()) {
            return this.iBestSolutionInfoBeforePassivation;
        }
        Lock lock = this.currentSolution().getLock().readLock();
        lock.lock();
        try {
            Map map = super.currentSolution().getBestInfo();
            return map;
        }
        finally {
            lock.unlock();
        }
    }

    protected abstract ProblemSaver<V, T, M> getDatabaseSaver(Solver<V, T> var1);

    protected abstract ProblemLoader<V, T, M> getDatabaseLoader(M var1, Assignment<V, T> var2);

    protected ProblemSaver<V, T, M> getCustomValidator(Solver<V, T> solver) {
        return null;
    }

    protected void finishBeforeSave() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onFinish() {
        super.onFinish();
        try {
            this.iWorking = true;
            if (this.currentSolution().getBestInfo() != null) {
                this.currentSolution().restoreBest();
            }
            this.finishBeforeSave();
            if (!this.isStop() && this.currentSolution().getBestInfo() != null && this.getProperties().getPropertyBoolean("General.Save", false)) {
                ProblemSaver<V, T, M> saver = this.getDatabaseSaver((Solver<V, T>)this);
                saver.setTerminationCondition(new TerminationCondition<V, T>(){

                    public boolean canContinue(Solution<V, T> currentSolution) {
                        return !AbstractSolver.this.isStop();
                    }
                });
                Lock lock = this.currentSolution().getLock().readLock();
                lock.lock();
                try {
                    saver.save();
                }
                catch (Exception e) {
                    this.sLog.error((Object)("Failed to save the problem: " + e.getMessage()), (Throwable)e);
                }
                finally {
                    lock.unlock();
                }
            }
            if (!this.isStop() && this.getProperties().getPropertyBoolean("General.Unload", false)) {
                this.dispose();
            } else {
                Progress.getInstance((Object)this.currentSolution().getModel()).setStatus(MSG.statusReady());
            }
        }
        finally {
            this.iWorking = false;
        }
    }

    protected void onStop() {
        super.onStop();
        if (this.currentSolution().getBestInfo() != null && !this.getSolutionComparator().isBetterThanBestSolution(this.currentSolution())) {
            this.currentSolution().restoreBest();
        }
    }

    @Override
    public void save() {
        this.iWorking = true;
        ProblemSaver<V, T, M> saver = this.getDatabaseSaver((Solver<V, T>)this);
        saver.setCallback(this.getSavingDoneCallback());
        this.iWorkThread = new InterruptibleThread((Runnable)saver);
        saver.setTerminationCondition((TerminationCondition)((InterruptibleThread)this.iWorkThread));
        this.iWorkThread.setPriority(THREAD_PRIORITY);
        this.iWorkThread.start();
    }

    protected abstract M createModel(DataProperties var1);

    @Override
    public void load(DataProperties properties) {
        this.setProperties(properties);
        M model = this.createModel(this.getProperties());
        Progress.getInstance(model).addProgressListener((ProgressListener)new ProgressWriter(System.out));
        this.iWorking = true;
        this.setInitalSolution((Model)model);
        this.initSolver();
        ProblemLoader<V, T, M> loader = this.getDatabaseLoader(model, this.currentSolution().getAssignment());
        loader.setCallback(this.getLoadingDoneCallback());
        this.iWorkThread = new InterruptibleThread((Runnable)loader);
        loader.setTerminationCondition((TerminationCondition)((InterruptibleThread)this.iWorkThread));
        this.iWorkThread.setPriority(THREAD_PRIORITY);
        this.iWorkThread.start();
    }

    @Override
    public void reload(DataProperties properties) {
        if (this.currentSolution() == null || this.currentSolution().getModel() == null) {
            this.load(properties);
            return;
        }
        Callback callBack = this.getReloadingDoneCallback();
        this.setProperties(properties);
        M model = this.createModel(this.getProperties());
        this.iWorking = true;
        Progress.changeInstance((Object)this.currentSolution().getModel(), model);
        this.setInitalSolution((Model)model);
        this.initSolver();
        ProblemLoader<V, T, M> loader = this.getDatabaseLoader(model, this.currentSolution().getAssignment());
        loader.setCallback(callBack);
        this.iWorkThread = new InterruptibleThread((Runnable)loader);
        loader.setTerminationCondition((TerminationCondition)((InterruptibleThread)this.iWorkThread));
        this.iWorkThread.start();
    }

    public Callback getLoadingDoneCallback() {
        return new DefaultLoadingDoneCallback(this);
    }

    public Callback getReloadingDoneCallback() {
        return new DefaultReloadingDoneCallback(this, false);
    }

    public Callback getSavingDoneCallback() {
        return new DefaultSavingDoneCallback(this);
    }

    public Callback getValidationDoneCallback() {
        return new DefaultValidationDoneCallback(this);
    }

    protected void afterSave() {
    }

    protected void afterLoad() {
    }

    protected void afterValidate() {
    }

    protected abstract Document createCurrentSolutionBackup(boolean var1, boolean var2);

    protected void saveProperties(Document document) {
        Element configuration = document.getRootElement().addElement("configuration");
        for (Map.Entry e : this.getProperties().entrySet()) {
            configuration.addElement("property").addAttribute("name", e.getKey().toString()).setText(e.getValue().toString());
        }
    }

    protected void readProperties(Document document) {
        Element configuration = document.getRootElement().element("configuration");
        if (configuration != null) {
            Iterator i = configuration.elementIterator("property");
            while (i.hasNext()) {
                Element e = (Element)i.next();
                this.getProperties().setProperty(e.attributeValue("name"), e.getText());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean backup(File folder, String puid) {
        folder.mkdirs();
        if (this.currentSolution() == null) {
            return false;
        }
        Lock lock = this.currentSolution().getLock().readLock();
        lock.lock();
        try {
            File outXmlFile = new File(folder, this.getType().getPrefix() + puid + BackupFileFilter.sXmlExtension);
            try {
                FileOutputStream fos = null;
                try {
                    fos = new FileOutputStream(outXmlFile);
                    Document document = this.createCurrentSolutionBackup(false, false);
                    this.saveProperties(document);
                    new XMLWriter((OutputStream)fos, OutputFormat.createPrettyPrint()).write(document);
                    fos.flush();
                    fos.close();
                    fos = null;
                }
                finally {
                    try {
                        if (fos != null) {
                            fos.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
                boolean bl = true;
                return bl;
            }
            catch (Exception e) {
                this.sLog.error((Object)e.getMessage(), (Throwable)e);
                if (outXmlFile.exists()) {
                    outXmlFile.delete();
                }
                lock.unlock();
            }
        }
        finally {
            lock.unlock();
        }
        return false;
    }

    @Override
    public boolean restore(File folder, String puid) {
        return this.restore(folder, puid, false);
    }

    protected abstract void restureCurrentSolutionFromBackup(Document var1);

    @Override
    public boolean restore(File folder, String puid, boolean removeFiles) {
        this.sLog.debug((Object)("restore(folder=" + folder + "," + puid + ")"));
        File inXmlFile = new File(folder, this.getType().getPrefix() + puid + BackupFileFilter.sXmlExtension);
        Model model = null;
        try {
            List log;
            if (this.isRunning()) {
                this.stopSolver();
            }
            this.disposeNoInherit(false);
            Document document = new SAXReader().read(inXmlFile);
            this.readProperties(document);
            model = (Model)this.createModel(this.getProperties());
            Progress.getInstance(model).addProgressListener((ProgressListener)new ProgressWriter(System.out));
            this.setInitalSolution(model);
            this.initSolver();
            this.restureCurrentSolutionFromBackup(document);
            Progress.getInstance(model).setStatus(MSG.statusReady());
            if (removeFiles) {
                inXmlFile.delete();
            }
            if (this.iLoadedDate == null && (log = Progress.getInstance((Object)this.currentSolution().getModel()).getLog()) != null && !log.isEmpty()) {
                this.iLoadedDate = ((Progress.Message)log.get(0)).getDate();
            }
            return true;
        }
        catch (Exception e) {
            this.sLog.error((Object)e.getMessage(), (Throwable)e);
            if (model != null) {
                Progress.removeInstance(model);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Lock lock = this.currentSolution().getLock().writeLock();
        lock.lock();
        try {
            for (Variable v : this.currentSolution().getModel().variables()) {
                this.currentSolution().getAssignment().unassign(0L, v);
            }
            this.currentSolution().clearBest();
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public Long getSessionId() {
        return this.getProperties().getPropertyLong("General.SessionId", null);
    }

    public Solution<V, T> currentSolution() {
        this.activateIfNeeded();
        return super.currentSolution();
    }

    protected void beforeStart() {
    }

    @Override
    public void start() {
        this.activateIfNeeded();
        this.beforeStart();
        super.start();
    }

    @Override
    public synchronized boolean isPassivated() {
        return this.iIsPassivated;
    }

    @Override
    public synchronized long timeFromLastUsed() {
        return System.currentTimeMillis() - this.iLastTimeStamp;
    }

    @Override
    public synchronized boolean activateIfNeeded() {
        this.iLastTimeStamp = System.currentTimeMillis();
        if (!this.isPassivated()) {
            return false;
        }
        this.sLog.debug((Object)("<activate " + this.iPassivationPuid + ">"));
        this.iIsPassivated = false;
        System.gc();
        this.sLog.debug((Object)(" -- memory usage before activation:" + Debug.getMem()));
        this.restore(this.iPassivationFolder, this.iPassivationPuid, true);
        System.gc();
        this.sLog.debug((Object)(" -- memory usage after activation:" + Debug.getMem()));
        return true;
    }

    public boolean canPassivate() {
        return true;
    }

    @Override
    public synchronized boolean passivate(File folder, String puid) {
        if (!this.canPassivate()) {
            return false;
        }
        if (this.isPassivated() || super.currentSolution() == null || super.currentSolution().getModel() == null) {
            return false;
        }
        this.sLog.debug((Object)("<passivate " + puid + ">"));
        System.gc();
        this.sLog.debug((Object)(" -- memory usage before passivation:" + Debug.getMem()));
        this.iProgressBeforePassivation = this.getProgress();
        if (this.iProgressBeforePassivation != null) {
            this.iProgressBeforePassivation.put("STATUS", "Pasivated");
        }
        this.iCurrentSolutionInfoBeforePassivation = this.currentSolutionInfo();
        this.iBestSolutionInfoBeforePassivation = this.bestSolutionInfo();
        this.iPassivationFolder = folder;
        this.iPassivationPuid = puid;
        this.backup(this.iPassivationFolder, this.iPassivationPuid);
        this.disposeNoInherit(false);
        System.gc();
        this.sLog.debug((Object)(" -- memory usage after passivation:" + Debug.getMem()));
        this.iIsPassivated = true;
        return true;
    }

    @Override
    public synchronized boolean passivateIfNeeded(File folder, String puid) {
        if (!this.canPassivate()) {
            return false;
        }
        long inactiveTimeToPassivate = 60000L * (long)ApplicationProperty.SolverPasivationTime.intValue().intValue();
        if (this.isPassivated() || inactiveTimeToPassivate <= 0L || this.timeFromLastUsed() < inactiveTimeToPassivate || this.isWorking()) {
            return false;
        }
        return this.passivate(folder, puid);
    }

    @Override
    public Date getLastUsed() {
        return new Date(this.iLastTimeStamp);
    }

    @Override
    public void interrupt() {
        try {
            if (this.iSolverThread != null) {
                this.iStop = true;
                if (this.iSolverThread.isAlive() && !this.iSolverThread.isInterrupted()) {
                    this.iSolverThread.interrupt();
                }
            }
            if (this.iWorkThread != null && this.iWorkThread.isAlive() && !this.iWorkThread.isInterrupted()) {
                this.iWorkThread.interrupt();
            }
        }
        catch (Exception e) {
            this.sLog.error((Object)("Unable to interrupt the solver, reason: " + e.getMessage()), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> statusSolutionInfo() {
        if (this.isPassivated()) {
            return this.iBestSolutionInfoBeforePassivation == null ? this.iCurrentSolutionInfoBeforePassivation : this.iBestSolutionInfoBeforePassivation;
        }
        Lock lock = this.currentSolution().getLock().readLock();
        lock.lock();
        try {
            Map info = super.currentSolution().getBestInfo();
            try {
                Solution solution = this.getWorkingSolution();
                if (info == null || this.getSolutionComparator().isBetterThanBestSolution(solution)) {
                    info = solution.getModel().getInfo(solution.getAssignment());
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                // empty catch block
            }
            Map map = info;
            return map;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] exportXml() throws IOException {
        Lock lock = this.currentSolution().getLock().readLock();
        lock.lock();
        try {
            boolean anonymize = ApplicationProperty.SolverXMLExportNames.isFalse();
            boolean idconv = ApplicationProperty.SolverXMLExportConvertIds.isTrue();
            ByteArrayOutputStream ret = new ByteArrayOutputStream();
            Document document = this.createCurrentSolutionBackup(anonymize, idconv);
            if (ApplicationProperty.SolverXMLExportConfiguration.isTrue()) {
                this.saveProperties(document);
            }
            new XMLWriter((OutputStream)ret, OutputFormat.createPrettyPrint()).write(document);
            ret.flush();
            ret.close();
            byte[] byArray = ret.toByteArray();
            return byArray;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void importXml(byte[] data) throws IOException {
        try {
            Document document = new SAXReader().read((InputStream)new ByteArrayInputStream(data));
            this.readProperties(document);
            M model = this.createModel(this.getProperties());
            Progress.getInstance(model).addProgressListener((ProgressListener)new ProgressWriter(System.out));
            this.setInitalSolution((Model)model);
            this.initSolver();
            this.restureCurrentSolutionFromBackup(document);
            Progress.getInstance(model).setStatus(MSG.statusReady());
        }
        catch (DocumentException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    protected M getModel() {
        return (M)this.currentSolution().getModel();
    }

    @Override
    public boolean isCanValidate() {
        return this.getCustomValidator((Solver<V, T>)this) != null;
    }

    @Override
    public void validate() {
        this.iWorking = true;
        ProblemSaver<V, T, M> saver = this.getCustomValidator((Solver<V, T>)this);
        saver.setCallback(this.getValidationDoneCallback());
        this.iWorkThread = new InterruptibleThread((Runnable)saver);
        saver.setTerminationCondition((TerminationCondition)((InterruptibleThread)this.iWorkThread));
        this.iWorkThread.setPriority(THREAD_PRIORITY);
        this.iWorkThread.start();
    }

    public static class InterruptibleThread<V extends Variable<V, T>, T extends Value<V, T>>
    extends Thread
    implements TerminationCondition<V, T> {
        InterruptibleThread(Runnable runnable) {
            super(runnable);
        }

        InterruptibleThread() {
        }

        public boolean canContinue(Solution<V, T> currentSolution) {
            return !this.isInterrupted();
        }
    }

    protected static class DefaultLoadingDoneCallback<V extends Variable<V, T>, T extends Value<V, T>, M extends Model<V, T>>
    implements Callback {
        AbstractSolver<V, T, M> iSolver;

        protected DefaultLoadingDoneCallback(AbstractSolver<V, T, M> solver) {
            this.iSolver = solver;
        }

        public void execute() {
            this.iSolver.iLoadedDate = new Date();
            this.iSolver.iWorking = false;
            this.iSolver.afterLoad();
            Progress.getInstance((Object)this.iSolver.currentSolution().getModel()).setStatus(MSG.statusReady());
            if (this.iSolver.getProperties().getPropertyBoolean("General.StartSolver", false)) {
                this.iSolver.start();
            }
        }
    }

    public static class DefaultReloadingDoneCallback<V extends Variable<V, T>, T extends Value<V, T>, M extends Model<V, T>>
    implements Callback {
        Map<V, T> iCurrentAssignmentTable = new Hashtable<V, T>();
        Map<V, T> iBestAssignmentTable = new Hashtable<V, T>();
        Map<V, T> iInitialAssignmentTable = new Hashtable<V, T>();
        boolean iRestoreInitial = false;
        String iSolutionId = null;
        Progress iProgress = null;
        AbstractSolver<V, T, M> iSolver;

        public DefaultReloadingDoneCallback(AbstractSolver<V, T, M> solver, boolean restoreInitial) {
            this.iSolver = solver;
            this.iSolutionId = solver.getProperties().getProperty("General.SolutionId");
            Solution<V, T> solution = solver.currentSolution();
            for (Variable v : solution.getModel().variables()) {
                Value t = solution.getAssignment().getValue(v);
                if (t != null) {
                    this.iCurrentAssignmentTable.put((Value)v, (T)t);
                }
                if (v.getBestAssignment() != null) {
                    this.iBestAssignmentTable.put((Value)v, (T)v.getBestAssignment());
                }
                if (v.getInitialAssignment() == null) continue;
                this.iInitialAssignmentTable.put((Value)v, (T)v.getInitialAssignment());
            }
        }

        protected V getVariable(V old) {
            for (Variable v : this.iSolver.currentSolution().getModel().variables()) {
                if (!v.equals(old)) continue;
                return (V)v;
            }
            return null;
        }

        protected T getValue(V v, T old) {
            for (Value t : v.values(this.iSolver.currentSolution().getAssignment())) {
                if (!t.equals(old)) continue;
                return (T)t;
            }
            this.iProgress.warn("Assignment " + old.getName() + " is not available for " + v.getName() + ".");
            return null;
        }

        protected void assign(T t) {
            Solution<V, T> solution = this.iSolver.currentSolution();
            Map conflictConstraints = solution.getModel().conflictConstraints(solution.getAssignment(), t);
            if (conflictConstraints.isEmpty()) {
                solution.getAssignment().assign(0L, t);
            } else {
                this.iProgress.warn("Unable to assign " + t.variable().getName() + " := " + t.getName());
                this.iProgress.warn("&nbsp;&nbsp;Reason:");
                for (Constraint c : conflictConstraints.keySet()) {
                    Set vals = (Set)conflictConstraints.get(c);
                    for (Value v : vals) {
                        this.iProgress.warn("&nbsp;&nbsp;&nbsp;&nbsp;" + v.variable().getName() + " = " + v.getName());
                    }
                    this.iProgress.debug("&nbsp;&nbsp;&nbsp;&nbsp;in constraint " + c);
                }
            }
        }

        private void unassignAll() {
            Solution<V, T> solution = this.iSolver.currentSolution();
            for (Variable v : solution.getModel().variables()) {
                solution.getAssignment().unassign(0L, v);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute() {
            try {
                Value t;
                Variable v;
                Solution<V, T> solution = this.iSolver.currentSolution();
                this.iProgress = Progress.getInstance((Object)solution.getModel());
                if (!this.iBestAssignmentTable.isEmpty()) {
                    this.iProgress.setPhase(MSG.phaseCreatingBestAssignment(), (long)this.iBestAssignmentTable.size());
                    this.unassignAll();
                    for (Map.Entry<V, T> e : this.iBestAssignmentTable.entrySet()) {
                        this.iProgress.incProgress();
                        v = this.getVariable((Variable)e.getKey());
                        if (v == null || (t = this.getValue(v, (Value)e.getValue())) == null) continue;
                        this.assign(t);
                    }
                    solution.saveBest();
                }
                if (this.iRestoreInitial && !this.iInitialAssignmentTable.isEmpty()) {
                    this.iProgress.setPhase(MSG.phaseCreatingInitialAssignment(), (long)this.iInitialAssignmentTable.size());
                    for (Map.Entry<V, T> e : this.iInitialAssignmentTable.entrySet()) {
                        this.iProgress.incProgress();
                        v = this.getVariable((Variable)e.getKey());
                        if (v == null || (t = this.getValue(v, (Value)e.getValue())) == null) continue;
                        v.setInitialAssignment(t);
                    }
                }
                if (!this.iCurrentAssignmentTable.isEmpty()) {
                    this.iProgress.setPhase(MSG.phaseCreatingCurrentAssignment(), (long)this.iCurrentAssignmentTable.size());
                    this.unassignAll();
                    for (Map.Entry<V, T> e : this.iCurrentAssignmentTable.entrySet()) {
                        this.iProgress.incProgress();
                        v = this.getVariable((Variable)e.getKey());
                        if (v == null || (t = this.getValue(v, (Value)e.getValue())) == null) continue;
                        this.assign(t);
                    }
                }
                this.iCurrentAssignmentTable.clear();
                this.iBestAssignmentTable.clear();
                this.iInitialAssignmentTable.clear();
                this.iProgress = null;
                if (this.iSolutionId != null) {
                    this.iSolver.getProperties().setProperty("General.SolutionId", this.iSolutionId);
                }
            }
            catch (Exception e) {
                Progress.getInstance((Object)this.iSolver.currentSolution().getModel()).fatal(MSG.fataFailedToRestore(e.getMessage()), (Throwable)e);
            }
            finally {
                this.iSolver.iLoadedDate = new Date();
                this.iSolver.iWorking = false;
                this.iSolver.afterLoad();
                Progress.getInstance((Object)this.iSolver.currentSolution().getModel()).setStatus(MSG.statusReady());
            }
        }
    }

    protected static class DefaultSavingDoneCallback<V extends Variable<V, T>, T extends Value<V, T>, M extends Model<V, T>>
    implements Callback {
        AbstractSolver<V, T, M> iSolver;

        protected DefaultSavingDoneCallback(AbstractSolver<V, T, M> solver) {
            this.iSolver = solver;
        }

        public void execute() {
            this.iSolver.iWorking = false;
            this.iSolver.afterSave();
            Progress.getInstance((Object)this.iSolver.currentSolution().getModel()).setStatus(MSG.statusReady());
        }
    }

    protected static class DefaultValidationDoneCallback<V extends Variable<V, T>, T extends Value<V, T>, M extends Model<V, T>>
    implements Callback {
        AbstractSolver<V, T, M> iSolver;

        protected DefaultValidationDoneCallback(AbstractSolver<V, T, M> solver) {
            this.iSolver = solver;
        }

        public void execute() {
            this.iSolver.iWorking = false;
            this.iSolver.afterValidate();
            Progress.getInstance((Object)this.iSolver.currentSolution().getModel()).setStatus(MSG.statusReady());
        }
    }
}

