/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.solver;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.Progress;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.springframework.beans.factory.annotation.Autowired;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.gwt.client.sectioning.PublishedSectioningSolutionsTable;
import org.unitime.timetable.gwt.command.client.GwtRpcException;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.resources.CPSolverMessages;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.SolverInterface;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentStatusType;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.SectioningSolutionLog;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.Solution;
import org.unitime.timetable.model.SolverGroup;
import org.unitime.timetable.model.SolverParameter;
import org.unitime.timetable.model.SolverParameterDef;
import org.unitime.timetable.model.SolverParameterGroup;
import org.unitime.timetable.model.SolverPredefinedSetting;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.TimetableManager;
import org.unitime.timetable.model.dao.ExamTypeDAO;
import org.unitime.timetable.model.dao.SectioningSolutionLogDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.model.dao.SolutionDAO;
import org.unitime.timetable.model.dao.SolverGroupDAO;
import org.unitime.timetable.model.dao.SolverParameterDefDAO;
import org.unitime.timetable.model.dao.SolverPredefinedSettingDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.solver.CommonSolverInterface;
import org.unitime.timetable.solver.SolverProxy;
import org.unitime.timetable.solver.exam.ExamSolverProxy;
import org.unitime.timetable.solver.instructor.InstructorSchedulingProxy;
import org.unitime.timetable.solver.jgroups.SolverServer;
import org.unitime.timetable.solver.service.SolverServerService;
import org.unitime.timetable.solver.service.SolverService;
import org.unitime.timetable.solver.service.StudentSectioningSolverService;
import org.unitime.timetable.solver.studentsct.StudentSolverProxy;
import org.unitime.timetable.solver.ui.LogInfo;
import org.unitime.timetable.solver.ui.PropertiesInfo;
import org.unitime.timetable.util.Formats;
import org.unitime.timetable.webutil.BackTracker;

@GwtRpcImplements(value=SolverInterface.SolverPageRequest.class)
public class SolverPageBackend
implements GwtRpcImplementation<SolverInterface.SolverPageRequest, SolverInterface.SolverPageResponse> {
    protected static GwtMessages MESSAGES = Localization.create(GwtMessages.class);
    protected static CPSolverMessages SOLVERMSG = Localization.create(CPSolverMessages.class);
    protected static Formats.Format<Date> sTS = Formats.getDateFormat(Formats.Pattern.DATE_TIME_STAMP);
    @Autowired
    SolverServerService solverServerService;
    @Autowired
    SolverService<SolverProxy> courseTimetablingSolverService;
    @Autowired
    SolverService<ExamSolverProxy> examinationSolverService;
    @Autowired
    SolverService<StudentSolverProxy> studentSectioningSolverService;
    @Autowired
    SolverService<InstructorSchedulingProxy> instructorSchedulingSolverService;

    @Override
    public SolverInterface.SolverPageResponse execute(SolverInterface.SolverPageRequest request, SessionContext context) {
        switch (request.getType()) {
            case COURSE: {
                context.checkPermission(Right.Solver);
                break;
            }
            case EXAM: {
                context.checkPermission(Right.ExaminationSolver);
                break;
            }
            case STUDENT: {
                context.checkPermission(Right.StudentSectioningSolver);
                break;
            }
            case INSTRUCTOR: {
                context.checkPermission(Right.InstructorSchedulingSolver);
            }
        }
        SolverInterface.SolverPageResponse response = new SolverInterface.SolverPageResponse();
        response.setSolverType(request.getType());
        response.setOperation(request.getOperation());
        SolverService<? extends CommonSolverInterface> service = this.getSolverService(request.getType());
        CommonSolverInterface solver = this.executeOperation(context, service, request, response);
        this.fillHosts(context, solver, request, response);
        this.fillOwners(context, request, response);
        this.fillParameters(context, request, response);
        this.fillSolverInfos(context, solver, request, response);
        this.fillSolverLog(context, solver, request, response);
        this.fillSolverStatus(context, solver, request, response);
        this.fillAvailableOperations(context, solver, request, response);
        this.fillSolverWarnings(context, solver, request, response);
        switch (request.getType()) {
            case COURSE: {
                BackTracker.markForBack(context, "gwt.jsp?page=solver&type=course", MESSAGES.pageCourseTimetablingSolver(), true, true);
                break;
            }
            case EXAM: {
                BackTracker.markForBack(context, "gwt.jsp?page=solver&type=exam", MESSAGES.pageExaminationTimetablingSolver(), true, true);
                break;
            }
            case INSTRUCTOR: {
                BackTracker.markForBack(context, "gwt.jsp?page=solver&type=instructor", MESSAGES.pageInstructorSchedulingSolver(), true, true);
                break;
            }
            case STUDENT: {
                BackTracker.markForBack(context, "gwt.jsp?page=solver&type=student", MESSAGES.pageStudentSchedulingSolver(), true, true);
            }
        }
        return response;
    }

    protected CommonSolverInterface executeOperation(SessionContext context, SolverService<? extends CommonSolverInterface> service, SolverInterface.SolverPageRequest request, SolverInterface.SolverPageResponse response) {
        CommonSolverInterface solver = service.getSolver();
        switch (request.getOperation()) {
            case RESTORE_BEST: {
                if (solver == null) {
                    throw new GwtRpcException(MESSAGES.warnSolverNotStarted());
                }
                if (solver.isWorking()) {
                    throw new GwtRpcException(MESSAGES.warnSolverIsWorking());
                }
                solver.restoreBest();
                break;
            }
            case SAVE_BEST: {
                if (solver == null) {
                    throw new GwtRpcException(MESSAGES.warnSolverNotStarted());
                }
                if (solver.isWorking()) {
                    throw new GwtRpcException(MESSAGES.warnSolverIsWorking());
                }
                solver.saveBest();
                break;
            }
            case CLEAR: {
                if (solver == null) {
                    throw new GwtRpcException(MESSAGES.warnSolverNotStarted());
                }
                if (solver.isWorking()) {
                    throw new GwtRpcException(MESSAGES.warnSolverIsWorking());
                }
                solver.clear();
                break;
            }
            case SAVE: 
            case SAVE_AS_NEW: 
            case SAVE_AS_NEW_COMMIT: 
            case SAVE_COMMIT: 
            case SAVE_UNCOMMIT: {
                if (solver == null) {
                    throw new GwtRpcException(MESSAGES.warnSolverNotStarted());
                }
                if (solver.isWorking()) {
                    throw new GwtRpcException(MESSAGES.warnSolverIsWorking());
                }
                if (request.hasParameters()) {
                    for (SolverParameterDef parameter : SolverParameterDefDAO.getInstance().getSession().createQuery("from SolverParameterDef where uniqueId in :uniqueIds", SolverParameterDef.class).setParameterList("uniqueIds", request.getParameters().keySet()).list()) {
                        String value = request.getParameter(parameter.getUniqueId());
                        if (!parameter.getName().startsWith("Save.")) continue;
                        solver.setProperty(parameter.getName(), value);
                    }
                }
                switch (request.getType()) {
                    case COURSE: {
                        Long[] owners = solver.getProperties().getPropertyLongArry("General.SolverGroupId", null);
                        context.checkPermission((Serializable)owners, "SolverGroup", Right.SolverSolutionSave);
                        if (request.getOperation() == SolverInterface.SolverOperation.SAVE_AS_NEW_COMMIT || request.getOperation() == SolverInterface.SolverOperation.SAVE_COMMIT) {
                            context.checkPermission((Serializable)owners, "SolverGroup", Right.TimetablesSolutionCommit);
                        }
                        if (solver.bestSolutionInfo() != null) {
                            solver.restoreBest();
                        }
                        ((SolverProxy)solver).save(request.getOperation() == SolverInterface.SolverOperation.SAVE_AS_NEW || request.getOperation() == SolverInterface.SolverOperation.SAVE_AS_NEW_COMMIT, request.getOperation() == SolverInterface.SolverOperation.SAVE_AS_NEW_COMMIT || request.getOperation() == SolverInterface.SolverOperation.SAVE_COMMIT);
                        break;
                    }
                    case EXAM: {
                        solver.save();
                        break;
                    }
                    case STUDENT: {
                        context.checkPermission(Right.StudentSectioningSolverSave);
                        solver.save();
                        break;
                    }
                    case INSTRUCTOR: {
                        solver.setProperty("Save.Commit", request.getOperation() == SolverInterface.SolverOperation.SAVE_AS_NEW_COMMIT || request.getOperation() == SolverInterface.SolverOperation.SAVE_COMMIT ? "true" : "false");
                        solver.save();
                    }
                }
                break;
            }
            case VALIDATE: {
                if (solver == null) {
                    throw new GwtRpcException(MESSAGES.warnSolverNotStarted());
                }
                if (solver.isWorking()) {
                    throw new GwtRpcException(MESSAGES.warnSolverIsWorking());
                }
                if (request.hasParameters()) {
                    for (SolverParameterDef parameter : SolverParameterDefDAO.getInstance().getSession().createQuery("from SolverParameterDef where uniqueId in :uniqueIds", SolverParameterDef.class).setParameterList("uniqueIds", request.getParameters().keySet()).list()) {
                        String value = request.getParameter(parameter.getUniqueId());
                        if (!parameter.getName().startsWith("Save.")) continue;
                        solver.setProperty(parameter.getName(), value);
                    }
                }
                solver.validate();
                break;
            }
            case PUBLISH: {
                String mgrId;
                SolverPredefinedSetting config;
                context.checkPermission(Right.StudentSectioningSolverPublish);
                if (solver == null) {
                    throw new GwtRpcException(MESSAGES.warnSolverNotStarted());
                }
                if (solver.isWorking()) {
                    throw new GwtRpcException(MESSAGES.warnSolverIsWorking());
                }
                byte[] data = ((StudentSolverProxy)solver).backupXml();
                SectioningSolutionLog log = new SectioningSolutionLog();
                log.setData(data);
                log.setInfo(this.getGson().toJson(solver.currentSolutionInfo()));
                log.setTimeStamp(new Date());
                log.setSession((Session)SessionDAO.getInstance().get(solver.getSessionId()));
                Long configId = solver.getProperties().getPropertyLong("General.SettingsId", null);
                if (configId != null && (config = (SolverPredefinedSetting)SolverPredefinedSettingDAO.getInstance().get(configId)) != null) {
                    log.setConfig(config.getDescription());
                }
                log.setOwner(TimetableManager.findByExternalId((mgrId = solver.getProperties().getProperty("General.OwnerPuid")) == null ? context.getUser().getExternalUserId() : mgrId));
                SectioningSolutionLogDAO.getInstance().getSession().persist((Object)log);
                SectioningSolutionLogDAO.getInstance().getSession().flush();
                Long publishId = log.getUniqueId();
                ((StudentSectioningSolverService)service).publishSolver(publishId, solver.getProperties(), data);
                break;
            }
            case CLONE: {
                if (solver == null) {
                    throw new GwtRpcException(MESSAGES.warnSolverNotStarted());
                }
                if (solver.isWorking()) {
                    throw new GwtRpcException(MESSAGES.warnSolverIsWorking());
                }
                solver = ((StudentSectioningSolverService)service).createSolver(solver.getProperties(), ((StudentSolverProxy)solver).backupXml());
                response.setRefresh(true);
                break;
            }
            case UNLOAD: {
                if (solver == null) {
                    throw new GwtRpcException(MESSAGES.warnSolverNotStarted());
                }
                if (solver.isWorking()) {
                    throw new GwtRpcException(MESSAGES.warnSolverIsWorking());
                }
                service.removeSolver();
                request.clear();
                response.setRefresh(true);
                solver = null;
                break;
            }
            case UNPUBLISH: {
                context.removeAttribute(SessionAttribute.StudentSectioningSolver);
                if (solver != null) {
                    solver.interrupt();
                    solver.dispose();
                }
                context.removeAttribute(SessionAttribute.StudentSectioningUser);
                request.clear();
                response.setRefresh(true);
                solver = null;
                break;
            }
            case RELOAD: {
                if (solver == null) {
                    throw new GwtRpcException(MESSAGES.warnSolverNotStarted());
                }
                if (solver.isWorking()) {
                    throw new GwtRpcException(MESSAGES.warnSolverIsWorking());
                }
                service.reload(service.createConfig(request.getConfigurationId(), request.getParameters()));
                response.setRefresh(true);
                break;
            }
            case START: 
            case LOAD: {
                String solutionId;
                if (solver != null && solver.isWorking()) {
                    throw new GwtRpcException(MESSAGES.warnSolverIsWorking());
                }
                if (solver != null && request.getType() == SolverInterface.SolverType.STUDENT && ((StudentSolverProxy)solver).isPublished()) {
                    solver = null;
                }
                Long settingsId = request.getConfigurationId();
                DataProperties config = service.createConfig(settingsId, request.getParameters());
                if (request.getHost() != null) {
                    config.setProperty("General.Host", request.getHost());
                }
                config.setProperty("General.StartSolver", request.getOperation() == SolverInterface.SolverOperation.START ? "true" : "false");
                if (request.getType() == SolverInterface.SolverType.COURSE && (solutionId = (String)context.getAttribute(SessionAttribute.SelectedSolution)) != null) {
                    config.setProperty("General.SolutionId", solutionId);
                }
                if (request.hasOwerIds()) {
                    Object ownerIds = "";
                    for (Long ownerId : request.getOwnerIds()) {
                        ownerIds = (String)ownerIds + (((String)ownerIds).isEmpty() ? "" : ",") + ownerId;
                    }
                    if (request.getType() == SolverInterface.SolverType.COURSE) {
                        config.setProperty("General.SolverGroupId", (String)ownerIds);
                    } else if (request.getType() == SolverInterface.SolverType.INSTRUCTOR) {
                        config.setProperty("General.SolverGroupId", (String)ownerIds);
                    } else if (request.getType() == SolverInterface.SolverType.EXAM) {
                        config.setProperty("Exam.Type", (String)ownerIds);
                    }
                }
                if (solver == null) {
                    solver = service.createSolver(config);
                } else {
                    solver.setProperties(config);
                    solver.start();
                }
                response.setRefresh(true);
                break;
            }
            case STOP: {
                if (solver == null) {
                    throw new GwtRpcException(MESSAGES.warnSolverNotStarted());
                }
                if (!solver.isRunning()) break;
                solver.stopSolver();
                break;
            }
            case STUDENT_SECTIONING: {
                if (solver == null) {
                    throw new GwtRpcException(MESSAGES.warnSolverNotStarted());
                }
                if (solver.isWorking()) {
                    throw new GwtRpcException(MESSAGES.warnSolverIsWorking());
                }
                if (request.getType() != SolverInterface.SolverType.COURSE) break;
                ((SolverProxy)solver).finalSectioning();
                break;
            }
            case INIT: {
                response.setRefresh(true);
            }
        }
        return solver;
    }

    protected void fillHosts(SessionContext context, CommonSolverInterface solver, SolverInterface.SolverPageRequest request, SolverInterface.SolverPageResponse response) {
        if (context.hasPermission(Right.CanSelectSolverServer)) {
            for (SolverServer server : this.solverServerService.getServers(true)) {
                response.addHost(server.getHost());
            }
            if (response.hasHosts()) {
                Collections.sort(response.getHosts());
            }
            if (!(!ApplicationProperty.SolverLocalEnabled.isTrue() || response.hasHosts() && response.getHosts().contains("local"))) {
                response.addHost(0, "local");
            }
            response.addHost(0, "auto");
            if (solver != null) {
                response.setHost(solver.getHost());
            }
        }
    }

    protected void fillOwners(SessionContext context, SolverInterface.SolverPageRequest request, SolverInterface.SolverPageResponse response) {
        switch (request.getType()) {
            case COURSE: {
                for (SolverGroup owner : SolverGroup.getUserSolverGroups(context.getUser())) {
                    if (!context.hasPermission(owner, Right.TimetablesSolutionLoadEmpty)) continue;
                    response.addSolverOwner(new SolverInterface.SolverOwner(owner.getUniqueId(), owner.getName()));
                }
                if (response.hasSolverOwners() && response.getSolverOwners().size() == 1) {
                    response.addOwnerId(response.getSolverOwners().get(0).getId());
                    break;
                }
                if (!response.hasSolverOwners() || response.getSolverOwners().size() <= 1) break;
                response.setAllowMultipleOwners(true);
                break;
            }
            case EXAM: {
                for (ExamType type : ExamType.findAllUsedApplicable(context.getUser(), DepartmentStatusType.Status.ExamTimetable)) {
                    response.addSolverOwner(new SolverInterface.SolverOwner(type.getUniqueId(), type.getLabel()));
                }
                break;
            }
            case INSTRUCTOR: {
                for (SolverGroup owner : SolverGroup.getUserSolverGroups(context.getUser())) {
                    if (!context.hasPermission(owner, Right.InstructorScheduling)) continue;
                    response.addSolverOwner(new SolverInterface.SolverOwner(owner.getUniqueId(), owner.getName()));
                }
                break;
            }
        }
    }

    protected void fillParameters(SessionContext context, SolverInterface.SolverPageRequest request, SolverInterface.SolverPageResponse response) {
        SolverParameterGroup.SolverType type = null;
        String group = null;
        SolverPredefinedSetting.Appearance appearance = SolverPredefinedSetting.Appearance.SOLVER;
        String defaultConfig = null;
        switch (request.getType()) {
            case COURSE: {
                type = SolverParameterGroup.SolverType.COURSE;
                group = "Basic";
                appearance = SolverPredefinedSetting.Appearance.SOLVER;
                defaultConfig = ApplicationProperty.SolverConfigDefaultCourse.value();
                break;
            }
            case EXAM: {
                type = SolverParameterGroup.SolverType.EXAM;
                group = "ExamBasic";
                appearance = SolverPredefinedSetting.Appearance.EXAM_SOLVER;
                defaultConfig = ApplicationProperty.SolverConfigDefaultExam.value();
                break;
            }
            case STUDENT: {
                type = SolverParameterGroup.SolverType.STUDENT;
                group = "StudentSctBasic";
                appearance = SolverPredefinedSetting.Appearance.STUDENT_SOLVER;
                defaultConfig = ApplicationProperty.SolverConfigDefaultStudentSct.value();
                break;
            }
            case INSTRUCTOR: {
                type = SolverParameterGroup.SolverType.INSTRUCTOR;
                group = "InstrSchd.Basic";
                appearance = SolverPredefinedSetting.Appearance.INSTRUCTOR_SOLVER;
                defaultConfig = ApplicationProperty.SolverConfigDefaultInstrSchd.value();
                break;
            }
            default: {
                throw new IllegalArgumentException(MESSAGES.errorSolverInvalidType(request.getType().name()));
            }
        }
        List parameters = SolverParameterDefDAO.getInstance().getSession().createQuery("from SolverParameterDef d where d.visible = true and d.group.type = :type and d.group.name = :group order by d.order", SolverParameterDef.class).setParameter("type", (Object)type.ordinal()).setParameter("group", (Object)group).setCacheable(true).list();
        for (SolverParameterDef def : parameters) {
            SolverInterface.SolverParameter p = new SolverInterface.SolverParameter();
            p.setId(def.getUniqueId());
            p.setKey(def.getName());
            p.setName(def.getDescription());
            p.setDefaultValue(def.getDefault());
            p.setType(def.getType());
            if (request.hasParameters()) {
                p.setValue(request.getParameter(p.getId()));
            }
            response.addParameter(p);
        }
        List configs = SolverPredefinedSettingDAO.getInstance().getSession().createQuery("from SolverPredefinedSetting s where s.appearance = :appearance order by s.description", SolverPredefinedSetting.class).setParameter("appearance", (Object)appearance.ordinal()).setCacheable(true).list();
        response.setConfigurationId(request.getConfigurationId());
        for (SolverPredefinedSetting config : configs) {
            SolverInterface.SolverConfiguration c = new SolverInterface.SolverConfiguration();
            c.setId(config.getUniqueId());
            c.setName(config.getDescription());
            for (SolverParameter p : config.getParameters()) {
                if (!p.getDefinition().isVisible().booleanValue() || p.getDefinition().getGroup().getType().intValue() != type.ordinal() || !group.equals(p.getDefinition().getGroup().getName())) continue;
                c.addParameter(p.getDefinition().getUniqueId(), p.getValue());
            }
            response.addConfiguration(c);
            if (request.getConfigurationId() != null || !defaultConfig.equals(config.getName())) continue;
            response.setConfigurationId(c.getId());
            for (SolverParameter p : config.getParameters()) {
                if (!p.getDefinition().isVisible().booleanValue() || p.getDefinition().getGroup().getType().intValue() != type.ordinal() || !group.equals(p.getDefinition().getGroup().getName())) continue;
                response.getParameter(p.getDefinition().getUniqueId()).setValue(p.getValue());
            }
        }
    }

    protected SolverService<? extends CommonSolverInterface> getSolverService(SolverInterface.SolverType type) {
        switch (type) {
            case COURSE: {
                return this.courseTimetablingSolverService;
            }
            case EXAM: {
                return this.examinationSolverService;
            }
            case STUDENT: {
                return this.studentSectioningSolverService;
            }
            case INSTRUCTOR: {
                return this.instructorSchedulingSolverService;
            }
        }
        throw new IllegalArgumentException(MESSAGES.errorSolverInvalidType(type.name()));
    }

    protected CommonSolverInterface getSolver(SolverInterface.SolverType type) {
        switch (type) {
            case COURSE: {
                return this.courseTimetablingSolverService.getSolver();
            }
            case EXAM: {
                return this.examinationSolverService.getSolver();
            }
            case STUDENT: {
                return this.studentSectioningSolverService.getSolver();
            }
            case INSTRUCTOR: {
                return this.instructorSchedulingSolverService.getSolver();
            }
        }
        throw new IllegalArgumentException(MESSAGES.errorSolverInvalidType(type.name()));
    }

    /*
     * WARNING - void declaration
     */
    protected void fillSolverInfos(SessionContext context, CommonSolverInterface solver, SolverInterface.SolverPageRequest request, SolverInterface.SolverPageResponse response) {
        String id;
        Long[] keys;
        Map<String, String> best;
        Map<String, String> info = solver == null ? null : solver.currentSolutionInfo();
        Map<String, String> translations = SolverPageBackend.getInfoTranslations(request.getType());
        if (info != null) {
            SolverInterface.SolutionInfo si = new SolverInterface.SolutionInfo();
            TreeSet<String> keys2 = new TreeSet<String>(new PublishedSectioningSolutionsTable.InfoComparator());
            keys2.addAll(info.keySet());
            for (String string : keys2) {
                String string2;
                String string3 = string2 = translations == null ? null : translations.get(string);
                if (string2 != null) {
                    si.addPair(string2, info.get(string));
                    continue;
                }
                si.addPair(string, info.get(string));
            }
            response.setCurrentSolution(si);
        }
        Map<String, String> map = best = solver == null ? null : solver.bestSolutionInfo();
        if (best != null) {
            SolverInterface.SolutionInfo si = new SolverInterface.SolutionInfo();
            keys = new TreeSet(new PublishedSectioningSolutionsTable.InfoComparator());
            keys.addAll(best.keySet());
            for (String string : keys) {
                String translatedKey;
                String string4 = translatedKey = translations == null ? null : translations.get(string);
                if (translatedKey != null) {
                    si.addPair(translatedKey, best.get(string));
                    continue;
                }
                si.addPair(string, best.get(string));
            }
            response.setBestSolution(si);
        }
        if (solver != null) {
            if (response.hasOwerIds()) {
                response.getOwnerIds().clear();
            }
            switch (request.getType()) {
                case COURSE: {
                    void var11_19;
                    Long[] owners = solver.getProperties().getPropertyLongArry("General.SolverGroupId", null);
                    if (owners == null) break;
                    keys = owners;
                    int n = keys.length;
                    boolean bl = false;
                    while (var11_19 < n) {
                        Long owner = keys[var11_19];
                        response.addOwnerId(owner);
                        ++var11_19;
                    }
                    break;
                }
                case EXAM: {
                    Long owner = solver.getProperties().getPropertyLong("Exam.Type", null);
                    if (owner == null) break;
                    response.addOwnerId(owner);
                    break;
                }
                case INSTRUCTOR: {
                    Long owner = solver.getProperties().getPropertyLong("General.SolverGroupId", null);
                    if (owner == null) break;
                    response.addOwnerId(owner);
                }
            }
        }
        if (solver == null && request.getType() == SolverInterface.SolverType.COURSE && (id = (String)context.getAttribute(SessionAttribute.SelectedSolution)) != null && !id.isEmpty()) {
            StringTokenizer s = new StringTokenizer(id, ",");
            while (s.hasMoreTokens()) {
                PropertiesInfo propInfo;
                Solution solution = (Solution)SolutionDAO.getInstance().get(Long.valueOf(s.nextToken()));
                if (solution == null) continue;
                SolverInterface.SolutionInfo solutionInfo = new SolverInterface.SolutionInfo();
                solutionInfo.setName(solution.getOwner().getName());
                solutionInfo.setCreated(sTS.format(solution.getCreated()));
                if (solution.isCommited().booleanValue()) {
                    solutionInfo.setCommitted(sTS.format(solution.getCommitDate()));
                }
                solutionInfo.setOwner(solution.getOwner().getName());
                solutionInfo.setNote(solution.getNote());
                solutionInfo.setId(solution.getUniqueId());
                LogInfo logInfo = (LogInfo)solution.getInfo("LogInfo");
                if (logInfo != null) {
                    for (Progress.Message m : logInfo.getLog()) {
                        if (m.getLevel() == SolverInterface.ProgressLogLevel.STAGE.ordinal() && (SOLVERMSG.statusLoadingInputData().equals(m.getMessage()) || "Loading input data ...".equals(m.getMessage())) && solutionInfo.hasLog()) {
                            solutionInfo.getLog().clear();
                        }
                        if (m.getLevel() < SolverInterface.ProgressLogLevel.WARN.ordinal()) continue;
                        solutionInfo.addMessage(m.getLevel(), m.getDate(), m.getMessage(), m.getTrace());
                    }
                }
                if ((propInfo = (PropertiesInfo)solution.getInfo("GlobalInfo")) != null) {
                    TreeSet<String> keys3 = new TreeSet<String>(new PublishedSectioningSolutionsTable.InfoComparator());
                    for (Object o : propInfo.keySet()) {
                        keys3.add((String)o);
                    }
                    for (String key : keys3) {
                        solutionInfo.addPair(key, propInfo.getProperty(key));
                    }
                    response.addSelectedSolution(solutionInfo);
                }
                response.addOwnerId(solution.getOwner().getUniqueId());
            }
        }
    }

    protected void fillSolverLog(SessionContext context, CommonSolverInterface solver, SolverInterface.SolverPageRequest request, SolverInterface.SolverPageResponse response) {
        List<Progress.Message> log;
        if (solver != null && (log = solver.getProgressLog(SolverInterface.ProgressLogLevel.WARN.ordinal(), request.getType() == SolverInterface.SolverType.COURSE ? SOLVERMSG.statusLoadingInputData() : "Loading input data ...", null)) != null) {
            for (Progress.Message m : log) {
                response.addMessage(m.getLevel(), m.getDate(), m.getMessage(), m.getTrace());
            }
        }
    }

    protected void fillSolverStatus(SessionContext context, CommonSolverInterface solver, SolverInterface.SolverPageRequest request, SolverInterface.SolverPageResponse response) {
        if (solver != null) {
            SolverPredefinedSetting cfg;
            response.setLoadDate(solver.getLoadedDate());
            response.setWorking(solver.isRunning() || solver.isWorking());
            try {
                Map p = solver.getProgress();
                response.setSolverStatus((String)p.get("STATUS"));
                long progressMax = (Long)p.get("MAX_PROGRESS");
                if (progressMax > 0L) {
                    Object progress = (String)p.get("PHASE");
                    long progressCur = (Long)p.get("PROGRESS");
                    double progressPercent = 100.0 * (double)(progressCur < progressMax ? progressCur : progressMax) / (double)progressMax;
                    progress = (String)progress + " (" + new DecimalFormat("0.0").format(progressPercent) + "%)";
                    response.setSolverProgress((String)progress);
                }
            }
            catch (Exception p) {
                // empty catch block
            }
            DataProperties config = solver.getProperties();
            response.setConfigurationId(config.getPropertyLong("General.SettingsId", null));
            if (response.getConfigurationId() != null && response.getConfiguration(response.getConfigurationId()) == null && response.getSolverType() == SolverInterface.SolverType.COURSE && (cfg = (SolverPredefinedSetting)SolverPredefinedSettingDAO.getInstance().get(response.getConfigurationId())) != null && cfg.getAppearance().intValue() == SolverPredefinedSetting.Appearance.TIMETABLES.ordinal()) {
                SolverInterface.SolverConfiguration c = new SolverInterface.SolverConfiguration();
                c.setId(cfg.getUniqueId());
                c.setName(cfg.getDescription());
                for (SolverParameter p : cfg.getParameters()) {
                    if (!p.getDefinition().isVisible().booleanValue() || p.getDefinition().getGroup().getType().intValue() != SolverParameterGroup.SolverType.COURSE.ordinal() || !"Basic".equals(p.getDefinition().getGroup().getName())) continue;
                    c.addParameter(p.getDefinition().getUniqueId(), p.getValue());
                }
                response.addConfiguration(c);
            }
            if (response.hasParameters()) {
                for (SolverInterface.SolverParameter p : response.getParameters()) {
                    p.setValue(config.getProperty(p.getKey()));
                }
            }
            if (solver != null && request.getType() == SolverInterface.SolverType.STUDENT && ((StudentSolverProxy)solver).isPublished()) {
                response.setSolverStatus(MESSAGES.solverStatusNotStarted());
                response.setLoadDate(null);
            }
        } else {
            response.setSolverStatus(MESSAGES.solverStatusNotStarted());
        }
    }

    protected void fillAvailableOperations(SessionContext context, CommonSolverInterface solver, SolverInterface.SolverPageRequest request, SolverInterface.SolverPageResponse response) {
        if (solver == null) {
            response.setCanExecute(SolverInterface.SolverOperation.LOAD, SolverInterface.SolverOperation.START, SolverInterface.SolverOperation.CHECK);
        } else {
            if (request.getType() == SolverInterface.SolverType.STUDENT && ((StudentSolverProxy)solver).isPublished()) {
                response.setCanExecute(SolverInterface.SolverOperation.LOAD, SolverInterface.SolverOperation.START, SolverInterface.SolverOperation.CHECK);
                if (context.hasPermission(Right.StudentSectioningSolverPublish)) {
                    response.setCanExecute(SolverInterface.SolverOperation.UNPUBLISH, SolverInterface.SolverOperation.CLONE);
                }
                if (context.hasPermission(Right.StudentSectioningSolutionExportXml)) {
                    response.setCanExecute(SolverInterface.SolverOperation.EXPORT_XML);
                }
                return;
            }
            response.setCanExecute(SolverInterface.SolverOperation.CHECK);
            if (solver.isRunning()) {
                response.setCanExecute(SolverInterface.SolverOperation.STOP);
            } else if (!solver.isWorking()) {
                response.setCanExecute(SolverInterface.SolverOperation.START, SolverInterface.SolverOperation.UNLOAD, SolverInterface.SolverOperation.SAVE_BEST, SolverInterface.SolverOperation.RELOAD);
                if (solver.bestSolutionInfo() != null) {
                    response.setCanExecute(SolverInterface.SolverOperation.RESTORE_BEST);
                }
                switch (request.getType()) {
                    case COURSE: {
                        response.setCanExecute(SolverInterface.SolverOperation.CLEAR);
                        Long[] owners = solver.getProperties().getPropertyLongArry("General.SolverGroupId", null);
                        if (context.hasPermission((Serializable)owners, "SolverGroup", Right.SolverSolutionExportCsv)) {
                            response.setCanExecute(SolverInterface.SolverOperation.EXPORT_CSV);
                        }
                        if (context.hasPermission((Serializable)owners, "SolverGroup", Right.SolverSolutionExportXml)) {
                            response.setCanExecute(SolverInterface.SolverOperation.EXPORT_XML);
                        }
                        if (((SolverProxy)solver).hasFinalSectioning()) {
                            response.setCanExecute(SolverInterface.SolverOperation.STUDENT_SECTIONING);
                        }
                        Long[] iSolutionIds = solver.getProperties().getPropertyLongArry("General.SolutionId", null);
                        boolean hasSolution = false;
                        boolean canOverwrite = true;
                        if (iSolutionIds != null && iSolutionIds.length > 0) {
                            for (int i = 0; i < iSolutionIds.length; ++i) {
                                Solution solution;
                                Solution solution2 = solution = iSolutionIds[i] == null ? null : (Solution)SolutionDAO.getInstance().get(iSolutionIds[i]);
                                if (solution == null) continue;
                                hasSolution = true;
                                if (!solution.getCommited().booleanValue()) continue;
                                canOverwrite = false;
                            }
                        }
                        if (context.hasPermission((Serializable)owners, "SolverGroup", Right.SolverSolutionSave)) {
                            response.setCanExecute(SolverInterface.SolverOperation.SAVE_AS_NEW);
                            if (hasSolution && canOverwrite) {
                                response.setCanExecute(SolverInterface.SolverOperation.SAVE);
                            }
                        }
                        if (!context.hasPermission((Serializable)owners, "SolverGroup", Right.TimetablesSolutionCommit)) break;
                        response.setCanExecute(SolverInterface.SolverOperation.SAVE_AS_NEW_COMMIT);
                        if (!hasSolution) break;
                        response.setCanExecute(SolverInterface.SolverOperation.SAVE_COMMIT);
                        break;
                    }
                    case EXAM: {
                        response.setCanExecute(SolverInterface.SolverOperation.CLEAR);
                        if (context.hasPermission(Right.ExaminationSolutionExportXml)) {
                            response.setCanExecute(SolverInterface.SolverOperation.EXPORT_XML);
                        }
                        boolean hasSolution = Exam.hasTimetable(context.getUser().getCurrentAcademicSessionId());
                        response.setCanExecute(hasSolution ? SolverInterface.SolverOperation.SAVE : SolverInterface.SolverOperation.SAVE_AS_NEW);
                        break;
                    }
                    case STUDENT: {
                        response.setCanExecute(SolverInterface.SolverOperation.CLEAR);
                        if (context.hasPermission(Right.StudentSectioningSolutionExportXml)) {
                            response.setCanExecute(SolverInterface.SolverOperation.EXPORT_XML);
                        }
                        if (context.hasPermission(Right.StudentSectioningSolverSave)) {
                            boolean hasSolution = Session.hasStudentSchedule(context.getUser().getCurrentAcademicSessionId());
                            response.setCanExecute(hasSolution ? SolverInterface.SolverOperation.SAVE : SolverInterface.SolverOperation.SAVE_AS_NEW);
                        }
                        if (!context.hasPermission(Right.StudentSectioningSolverPublish)) break;
                        response.setCanExecute(SolverInterface.SolverOperation.PUBLISH);
                        break;
                    }
                    case INSTRUCTOR: {
                        response.setCanExecute(SolverInterface.SolverOperation.CLEAR);
                        if (context.hasPermission(Right.InstructorSchedulingSolutionExportXml)) {
                            response.setCanExecute(SolverInterface.SolverOperation.EXPORT_XML);
                        }
                        if (solver.getProperties().getPropertyBoolean("Save.Commit", false)) {
                            response.setCanExecute(SolverInterface.SolverOperation.SAVE_UNCOMMIT);
                        } else {
                            response.setCanExecute(SolverInterface.SolverOperation.SAVE);
                        }
                        response.setCanExecute(SolverInterface.SolverOperation.SAVE_COMMIT);
                    }
                }
                if (solver.isCanValidate()) {
                    response.setCanExecute(SolverInterface.SolverOperation.VALIDATE);
                }
            }
        }
    }

    protected void fillSolverWarnings(SessionContext context, CommonSolverInterface solver, SolverInterface.SolverPageRequest request, SolverInterface.SolverPageResponse response) {
        SolverPageBackend.fillSolverWarnings(context, solver, request.getType(), response);
    }

    public static void fillSolverWarnings(SessionContext context, CommonSolverInterface solver, SolverInterface.SolverType solverType, SolverInterface.HasPageMessages response) {
        switch (solverType) {
            case EXAM: {
                ExamType type;
                if (solver == null || (type = (ExamType)ExamTypeDAO.getInstance().get(solver.getProperties().getPropertyLong("Exam.Type", null))) == null) break;
                String ts = solver.getProperties().getProperty("RoomAvailability.TimeStamp");
                if (ts == null) {
                    response.addPageMessage(new SolverInterface.PageMessage(SolverInterface.PageMessageType.WARNING, MESSAGES.warnExamSolverNoRoomAvailability(type.getLabel().toLowerCase())));
                } else {
                    response.addPageMessage(new SolverInterface.PageMessage(SolverInterface.PageMessageType.INFO, MESSAGES.infoExamSolverRoomAvailabilityLastUpdated(type.getLabel().toLowerCase(), ts)));
                }
                response.addPageMessage(new SolverInterface.PageMessage(SolverInterface.PageMessageType.INFO, MESSAGES.infoExamSolverShowingSolution(type.getLabel()), "gwt.jsp?page=solver&type=exam"));
                break;
            }
            case COURSE: {
                TreeSet<SolverGroup> solverGroups;
                if (solver != null) {
                    String warn = solver.getProperties().getProperty("General.SolverWarnings");
                    if (warn != null && !warn.isEmpty()) {
                        response.addPageMessage(new SolverInterface.PageMessage(SolverInterface.PageMessageType.WARNING, warn));
                    }
                    Long[] solverGroupId = solver.getProperties().getPropertyLongArry("General.SolverGroupId", null);
                    ArrayList<String> names = new ArrayList<String>();
                    boolean interactive = solver.getProperties().getPropertyBoolean("General.InteractiveMode", false);
                    if (solverGroupId != null) {
                        for (int i = 0; i < solverGroupId.length; ++i) {
                            SolverGroup sg = (SolverGroup)SolverGroupDAO.getInstance().get(solverGroupId[i]);
                            names.add(sg == null ? MESSAGES.notApplicable() : (solverGroupId.length <= 3 ? sg.getName() : sg.getAbbv()));
                        }
                    }
                    if (names == null || names.isEmpty()) {
                        names.add(MESSAGES.notApplicable());
                    }
                    response.addPageMessage(new SolverInterface.PageMessage(SolverInterface.PageMessageType.INFO, MESSAGES.infoSolverShowingSolution(SolverPageBackend.toString(names)), interactive ? "gwt.jsp?page=listSolutions" : "gwt.jsp?page=solver&type=course"));
                    break;
                }
                String id = (String)context.getAttribute(SessionAttribute.SelectedSolution);
                Object warn = "";
                if (id == null || id.isEmpty()) break;
                ArrayList<String> names = new ArrayList<String>();
                String[] solutionIds = id.split(",");
                for (int i = 0; i < solutionIds.length; ++i) {
                    Solution solution = (Solution)SolutionDAO.getInstance().get(Long.valueOf(solutionIds[i]));
                    names.add(solutionIds.length <= 3 ? solution.getOwner().getName() : solution.getOwner().getAbbv());
                    for (SolverParameter p : solution.getParameters()) {
                        if (!"General.SolverWarnings".equals(p.getDefinition().getName()) || p.getValue() == null) continue;
                        if (!((String)warn).isEmpty()) {
                            warn = (String)warn + "<br>";
                        }
                        warn = (String)warn + p.getValue();
                    }
                }
                if (((String)warn).isEmpty() && !(solverGroups = SolverGroup.getUserSolverGroups(context.getUser())).isEmpty()) {
                    int maxDistPriority = Integer.MIN_VALUE;
                    int nrWarns = 0;
                    for (SolverGroup sg : solverGroups) {
                        maxDistPriority = Math.max(maxDistPriority, sg.getMaxDistributionPriority());
                    }
                    for (SolverGroup sg : SolverGroup.findBySessionId(context.getUser().getCurrentAcademicSessionId())) {
                        if (solverGroups.contains(sg) || sg.getMinDistributionPriority() >= maxDistPriority || sg.getCommittedSolution() != null) continue;
                        if (nrWarns > 0) {
                            warn = (String)warn + "<br>";
                        }
                        boolean dept = false;
                        ArrayList<String> subjects = new ArrayList<String>();
                        for (Department d : sg.getDepartments()) {
                            if (d.isExternalManager().booleanValue()) {
                                subjects.add(d.getExternalMgrAbbv());
                                continue;
                            }
                            dept = true;
                            for (SubjectArea sa : d.getSubjectAreas()) {
                                subjects.add(sa.getSubjectAreaAbbreviation());
                            }
                        }
                        warn = dept ? (String)warn + MESSAGES.warnSolverNoCommittedSolutionDepartmental(sg.getAbbv(), SolverPageBackend.toString(subjects)) : (String)warn + MESSAGES.warnSolverNoCommittedSolutionExternal(sg.getAbbv(), SolverPageBackend.toString(subjects));
                        if (++nrWarns < 3) continue;
                        warn = (String)warn + "<br>...";
                        break;
                    }
                }
                if (warn != null && !((String)warn).isEmpty()) {
                    response.addPageMessage(new SolverInterface.PageMessage(SolverInterface.PageMessageType.WARNING, (String)warn));
                }
                response.addPageMessage(new SolverInterface.PageMessage(SolverInterface.PageMessageType.INFO, names.size() == 1 ? MESSAGES.infoSolverShowingSelectedSolution((String)names.get(0)) : MESSAGES.infoSolverShowingSelectedSolutions(SolverPageBackend.toString(names)), "gwt.jsp?page=listSolutions"));
                break;
            }
            case STUDENT: {
                String published;
                if (solver == null || !((StudentSolverProxy)solver).isPublished() || (published = solver.getProperties().getProperty("StudentSct.Published")) == null) break;
                response.addPageMessage(new SolverInterface.PageMessage(SolverInterface.PageMessageType.INFO, MESSAGES.infoSolverShowingPublishedSectioningSolution(Formats.getDateFormat(Formats.Pattern.DATE_TIME_STAMP).format(new Date(Long.valueOf(published)))), context.hasPermission(Right.StudentSectioningSolverPublish) ? "gwt.jsp?page=publishedSolutions" : null));
            }
        }
    }

    public static String toString(Collection<String> items) {
        if (items == null || items.isEmpty()) {
            return "";
        }
        if (items.size() == 1) {
            return items.iterator().next();
        }
        if (items.size() == 2) {
            Iterator<String> i = items.iterator();
            return MESSAGES.itemSeparatorPair(i.next(), i.next());
        }
        Iterator<String> i = items.iterator();
        String list = i.next();
        while (i.hasNext()) {
            String item = i.next();
            if (i.hasNext()) {
                list = MESSAGES.itemSeparatorMiddle(list, item);
                continue;
            }
            list = MESSAGES.itemSeparatorLast(list, item);
        }
        return list;
    }

    public static Map<String, String> translateInfo(SolverInterface.SolverType type, Map<String, String> info) {
        Map<String, String> translations = SolverPageBackend.getInfoTranslations(type);
        if (info == null || info.isEmpty() || translations == null || translations.isEmpty()) {
            return info;
        }
        HashMap<String, String> translatedInfo = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : info.entrySet()) {
            String translatedKey = translations.get(entry.getKey());
            if (translatedKey != null) {
                translatedInfo.put(translatedKey, entry.getValue());
                continue;
            }
            translatedInfo.put(entry.getKey(), entry.getValue());
        }
        return translatedInfo;
    }

    public static Map<String, String> getInfoTranslations(SolverInterface.SolverType type) {
        switch (type) {
            case COURSE: {
                return SOLVERMSG.courseInfoMessages();
            }
            case EXAM: {
                return SOLVERMSG.examInfoMessages();
            }
            case STUDENT: {
                return SOLVERMSG.studentInfoMessages();
            }
            case INSTRUCTOR: {
                return SOLVERMSG.instructorInfoMessages();
            }
        }
        return null;
    }

    protected Gson getGson() {
        GsonBuilder builder = new GsonBuilder().registerTypeAdapter(DateTime.class, (Object)new JsonSerializer<DateTime>(){

            public JsonElement serialize(DateTime src, Type typeOfSrc, JsonSerializationContext context) {
                return new JsonPrimitive(src.toString("yyyy-MM-dd'T'HH:mm:ss'Z'"));
            }
        }).registerTypeAdapter(DateTime.class, (Object)new JsonDeserializer<DateTime>(){

            public DateTime deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                return new DateTime((Object)json.getAsJsonPrimitive().getAsString(), DateTimeZone.UTC);
            }
        }).registerTypeAdapter(Date.class, (Object)new JsonSerializer<Date>(){

            public JsonElement serialize(Date src, Type typeOfSrc, JsonSerializationContext context) {
                return new JsonPrimitive(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'").format(src));
            }
        }).registerTypeAdapter(Date.class, (Object)new JsonDeserializer<Date>(){

            public Date deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                try {
                    return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(json.getAsJsonPrimitive().getAsString());
                }
                catch (ParseException e) {
                    throw new JsonParseException(e.getMessage(), (Throwable)e);
                }
            }
        });
        builder.setPrettyPrinting();
        return builder.create();
    }
}

