/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.sectioning;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.cpsolver.ifs.util.DataProperties;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.springframework.beans.factory.annotation.Autowired;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.gwt.command.client.GwtRpcException;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseList;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.PublishedSectioningSolutionInterface;
import org.unitime.timetable.model.SectioningSolutionLog;
import org.unitime.timetable.model.dao.SectioningSolutionLogDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.solver.service.StudentSectioningSolverService;
import org.unitime.timetable.solver.studentsct.StudentSolverProxy;
import org.unitime.timetable.util.NameFormat;

@GwtRpcImplements(value=PublishedSectioningSolutionInterface.PublishedSectioningSolutionsRequest.class)
public class PublishedSectioningSolutionsBackend
implements GwtRpcImplementation<PublishedSectioningSolutionInterface.PublishedSectioningSolutionsRequest, GwtRpcResponseList<PublishedSectioningSolutionInterface>> {
    protected static GwtMessages MESSAGES = Localization.create(GwtMessages.class);
    @Autowired
    StudentSectioningSolverService studentSectioningSolverService;

    @Override
    public GwtRpcResponseList<PublishedSectioningSolutionInterface> execute(PublishedSectioningSolutionInterface.PublishedSectioningSolutionsRequest request, SessionContext context) {
        context.checkPermission(Right.StudentSectioningSolverPublish);
        SectioningSolutionLog solution = null;
        if (request.getUniqueId() != null && (solution = (SectioningSolutionLog)SectioningSolutionLogDAO.getInstance().get(request.getUniqueId())) == null) {
            throw new GwtRpcException(MESSAGES.errorSolutionDoesNotExist(request.getUniqueId().toString()));
        }
        StudentSolverProxy publishedSolver = this.studentSectioningSolverService.getSolver("PUBLISHED_" + context.getUser().getCurrentAcademicSessionId(), context.getUser().getCurrentAcademicSessionId());
        DataProperties publishedSolverProperties = publishedSolver == null ? null : publishedSolver.getProperties();
        Long selectedId = publishedSolverProperties == null ? null : publishedSolverProperties.getPropertyLong("StudentSct.PublishId", null);
        StudentSolverProxy mySolver = this.studentSectioningSolverService.getSolver(context.getUser().getExternalUserId(), context.getUser().getCurrentAcademicSessionId());
        DataProperties mySolverProperties = mySolver == null ? null : mySolver.getProperties();
        Long mySolverId = null;
        if (mySolverProperties != null && context.getUser().getExternalUserId().equals(mySolverProperties.getProperty("General.OwnerPuid"))) {
            mySolverId = mySolverProperties.getPropertyLong("StudentSct.PublishId", null);
        }
        switch (request.getOperation()) {
            case LIST: {
                break;
            }
            case PUBLISH: {
                publishedSolverProperties = this.getConfig(solution.getData());
                selectedId = solution.getUniqueId();
                publishedSolver = this.studentSectioningSolverService.publishSolver(solution.getUniqueId(), publishedSolverProperties, solution.getData());
                break;
            }
            case UNPUBLISH: {
                if (publishedSolver != null) {
                    publishedSolver.interrupt();
                    publishedSolver.dispose();
                }
                context.removeAttribute(SessionAttribute.StudentSectioningSolver);
                context.removeAttribute(SessionAttribute.StudentSectioningUser);
                publishedSolver = null;
                publishedSolverProperties = null;
                selectedId = null;
                break;
            }
            case LOAD: {
                if (mySolver != null && mySolver.isWorking()) {
                    throw new GwtRpcException(MESSAGES.warnSolverIsWorking());
                }
                mySolverProperties = this.getConfig(solution.getData());
                mySolverProperties.setProperty("StudentSct.PublishId", solution.getUniqueId().toString());
                mySolverProperties.remove((Object)"General.Host");
                mySolver = this.studentSectioningSolverService.createSolver(mySolverProperties, solution.getData());
                mySolverId = solution.getUniqueId();
                break;
            }
            case UNLOAD: {
                if (mySolver != null) {
                    mySolver.interrupt();
                    mySolver.dispose();
                }
                context.setAttribute(SessionAttribute.StudentSectioningUser, (Object)context.getUser().getExternalUserId());
                context.removeAttribute(SessionAttribute.StudentSectioningSolver);
                mySolver = null;
                mySolverProperties = null;
                mySolverId = null;
                break;
            }
            case SELECT: {
                context.setAttribute(SessionAttribute.StudentSectioningUser, (Object)("PUBLISHED_" + context.getUser().getCurrentAcademicSessionId()));
                context.removeAttribute(SessionAttribute.StudentSectioningSolver);
                break;
            }
            case DESELECT: {
                context.removeAttribute(SessionAttribute.StudentSectioningUser);
                context.removeAttribute(SessionAttribute.StudentSectioningSolver);
                break;
            }
            case REMOVE: {
                SectioningSolutionLogDAO.getInstance().getSession().remove((Object)solution);
                SectioningSolutionLogDAO.getInstance().getSession().flush();
                break;
            }
            case NOTE: {
                solution.setNote(request.getNote());
                SectioningSolutionLogDAO.getInstance().getSession().merge((Object)solution);
                SectioningSolutionLogDAO.getInstance().getSession().flush();
            }
        }
        GwtRpcResponseList<PublishedSectioningSolutionInterface> ret = new GwtRpcResponseList<PublishedSectioningSolutionInterface>();
        NameFormat nf = NameFormat.fromReference(UserProperty.NameFormat.get(context.getUser()));
        Gson gson = this.getGson();
        for (SectioningSolutionLog log : SectioningSolutionLogDAO.getInstance().getSession().createQuery("from SectioningSolutionLog where session.uniqueId = :sessionId order by timeStamp", SectioningSolutionLog.class).setParameter("sessionId", (Object)context.getUser().getCurrentAcademicSessionId()).setCacheable(true).list()) {
            PublishedSectioningSolutionInterface pss = new PublishedSectioningSolutionInterface();
            pss.setUniqueId(log.getUniqueId());
            pss.setInfo(new HashMap<String, String>((Map)gson.fromJson(log.getInfo(), Map.class)));
            pss.setOwner(nf.format(log.getOwner()));
            pss.setTimeStamp(log.getTimeStamp());
            pss.setLoaded(log.getUniqueId().equals(selectedId));
            pss.setCanLoad(!pss.isLoaded());
            pss.setClonned(log.getUniqueId().equals(mySolverId));
            pss.setCanClone(mySolver == null);
            pss.setConfig(log.getConfig());
            pss.setNote(log.getNote());
            pss.setCanChangeNote(true);
            if (pss.isLoaded()) {
                pss.setSelected(("PUBLISHED_" + context.getUser().getCurrentAcademicSessionId()).equals(context.getAttribute(SessionAttribute.StudentSectioningUser)));
            } else {
                pss.setSelected(false);
            }
            pss.setCanSelect(mySolver != null);
            ret.add(pss);
        }
        return ret;
    }

    protected Gson getGson() {
        GsonBuilder builder = new GsonBuilder().registerTypeAdapter(DateTime.class, (Object)new JsonSerializer<DateTime>(){

            public JsonElement serialize(DateTime src, Type typeOfSrc, JsonSerializationContext context) {
                return new JsonPrimitive(src.toString("yyyy-MM-dd'T'HH:mm:ss'Z'"));
            }
        }).registerTypeAdapter(DateTime.class, (Object)new JsonDeserializer<DateTime>(){

            public DateTime deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                return new DateTime((Object)json.getAsJsonPrimitive().getAsString(), DateTimeZone.UTC);
            }
        }).registerTypeAdapter(Date.class, (Object)new JsonSerializer<Date>(){

            public JsonElement serialize(Date src, Type typeOfSrc, JsonSerializationContext context) {
                return new JsonPrimitive(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'").format(src));
            }
        }).registerTypeAdapter(Date.class, (Object)new JsonDeserializer<Date>(){

            public Date deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                try {
                    return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(json.getAsJsonPrimitive().getAsString());
                }
                catch (ParseException e) {
                    throw new JsonParseException(e.getMessage(), (Throwable)e);
                }
            }
        });
        builder.setPrettyPrinting();
        return builder.create();
    }

    protected DataProperties getConfig(byte[] data) {
        try {
            Document document = new SAXReader().read((InputStream)new GZIPInputStream(new ByteArrayInputStream(data)));
            DataProperties config = new DataProperties();
            Iterator i = document.getRootElement().element("configuration").elementIterator("property");
            while (i.hasNext()) {
                Element e = (Element)i.next();
                config.setProperty(e.attributeValue("name"), e.getText());
            }
            return config;
        }
        catch (Exception e) {
            throw new GwtRpcException(MESSAGES.failedLoadData(e.getMessage()), e);
        }
    }
}

