/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.script;

import com.google.gson.FieldNamingStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import jakarta.activation.FileTypeMap;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.unitime.timetable.api.BinaryFileApiHelper;
import org.unitime.timetable.api.connectors.ScriptConnector;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.gwt.server.UploadServlet;
import org.unitime.timetable.gwt.shared.ScriptInterface;
import org.unitime.timetable.gwt.shared.TaskInterface;
import org.unitime.timetable.model.ScriptParameter;
import org.unitime.timetable.model.TaskExecution;
import org.unitime.timetable.model.TaskParameter;
import org.unitime.timetable.model.dao.TaskExecutionDAO;
import org.unitime.timetable.security.Qualifiable;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.UserContext;
import org.unitime.timetable.security.authority.OtherAuthority;
import org.unitime.timetable.security.context.UniTimeUserContext;
import org.unitime.timetable.security.evaluation.PermissionCheck;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.script.ScriptExecution;

public class TaskExecutionItem
extends ScriptExecution {
    private static final long serialVersionUID = 1L;

    public TaskExecutionItem(TaskExecution execution, PermissionCheck check) {
        super(TaskExecutionItem.createRequest(execution), new TaskContext(execution, check));
    }

    private static ScriptInterface.ExecuteScriptRpcRequest createRequest(TaskExecution execution) {
        ScriptInterface.ExecuteScriptRpcRequest request = new ScriptInterface.ExecuteScriptRpcRequest();
        request.setEmail(execution.getTask().getEmail());
        for (TaskParameter p : execution.getTask().getParameters()) {
            request.setParameter(p.getName(), p.getValue());
        }
        request.setScriptId(execution.getTask().getScript().getUniqueId());
        request.setScriptName(execution.getTask().getName());
        return request;
    }

    @Override
    public void executeItem() {
        this.onStarted();
        try {
            super.executeItem();
        }
        finally {
            this.onFinished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onStarted() {
        Session hibSession = TaskExecutionDAO.getInstance().createNewSession();
        Transaction tx = hibSession.beginTransaction();
        try {
            TaskExecution execution = (TaskExecution)TaskExecutionDAO.getInstance().get(this.getTaskExecutionId(), hibSession);
            if (execution != null) {
                execution.setStartedDate(new java.util.Date());
                execution.setExecutionStatus(TaskInterface.ExecutionStatus.RUNNING.ordinal());
                hibSession.merge((Object)execution);
            }
            hibSession.flush();
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
        }
        finally {
            hibSession.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onFinished() {
        Session hibSession = TaskExecutionDAO.getInstance().createNewSession();
        Transaction tx = hibSession.beginTransaction();
        try {
            TaskExecution execution = (TaskExecution)TaskExecutionDAO.getInstance().get(this.getTaskExecutionId(), hibSession);
            if (execution != null) {
                execution.setFinishedDate(new java.util.Date());
                execution.setExecutionStatus(this.hasError() ? TaskInterface.ExecutionStatus.FAILED.ordinal() : TaskInterface.ExecutionStatus.FINISHED.ordinal());
                execution.setStatusMessageCheckLength(this.status());
                execution.setLogFile(TaskExecutionItem.createGson().toJson(this.getLog()));
                if (this.output() != null && this.output().exists()) {
                    execution.setOutputName(this.getOutputName());
                    execution.setOutputContentType(FileTypeMap.getDefaultFileTypeMap().getContentType(this.output()));
                    try (FileInputStream is = new FileInputStream(this.output());){
                        execution.setOutputFile(IOUtils.toByteArray((InputStream)is));
                    }
                }
                hibSession.merge((Object)execution);
            }
            hibSession.flush();
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
        }
        finally {
            hibSession.close();
        }
    }

    public static Gson createGson() {
        return new GsonBuilder().registerTypeAdapter(Timestamp.class, (Object)new JsonSerializer<Timestamp>(){

            public JsonElement serialize(Timestamp src, Type typeOfSrc, JsonSerializationContext context) {
                return new JsonPrimitive(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'").format(src));
            }
        }).registerTypeAdapter(Date.class, (Object)new JsonSerializer<Date>(){

            public JsonElement serialize(Date src, Type typeOfSrc, JsonSerializationContext context) {
                return new JsonPrimitive(new SimpleDateFormat("yyyy-MM-dd").format(src));
            }
        }).registerTypeAdapter(java.util.Date.class, (Object)new JsonSerializer<java.util.Date>(){

            public JsonElement serialize(java.util.Date src, Type typeOfSrc, JsonSerializationContext context) {
                return new JsonPrimitive(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'").format(src));
            }
        }).setFieldNamingStrategy(new FieldNamingStrategy(){
            Pattern iPattern = Pattern.compile("i([A-Z])(.*)");

            public String translateName(Field f) {
                Matcher matcher = this.iPattern.matcher(f.getName());
                if (matcher.matches()) {
                    return matcher.group(1).toLowerCase() + matcher.group(2);
                }
                return f.getName();
            }
        }).setPrettyPrinting().create();
    }

    private static class TaskContext
    implements SessionContext {
        private UserContext iUser;
        private PermissionCheck iCheck;
        private Map<String, Object> iAttributes = new HashMap<String, Object>();

        TaskContext(TaskExecution execution, PermissionCheck check) {
            this.iCheck = check;
            if (execution.getTask().getInputFile() != null) {
                String type = null;
                String name = "unknown.file";
                for (ScriptParameter scriptParameter : execution.getTask().getScript().getParameters()) {
                    if (!"file".equalsIgnoreCase(scriptParameter.getType())) continue;
                    type = scriptParameter.getName();
                }
                if (type != null) {
                    for (TaskParameter taskParameter : execution.getTask().getParameters()) {
                        if (!type.equals(taskParameter.getName())) continue;
                        name = taskParameter.getValue();
                    }
                }
                this.iAttributes.put(UploadServlet.SESSION_LAST_FILE, new ScriptConnector.BinaryFileItem(new BinaryFileApiHelper.BinaryFile(execution.getTask().getInputFile(), "application/octet-stream", name)));
            }
            this.iUser = new UniTimeUserContext(execution.getTask().getOwner(), execution.getTask().getSession());
        }

        @Override
        public boolean isAuthenticated() {
            return true;
        }

        @Override
        public UserContext getUser() {
            return this.iUser;
        }

        @Override
        public boolean isHttpSessionNew() {
            return false;
        }

        @Override
        public String getHttpSessionId() {
            return null;
        }

        @Override
        public Object getAttribute(String name) {
            return this.iAttributes.get(name);
        }

        @Override
        public void removeAttribute(String name) {
            this.iAttributes.remove(name);
        }

        @Override
        public void setAttribute(String name, Object value) {
            this.iAttributes.put(name, value);
        }

        @Override
        public void removeAttribute(SessionAttribute attribute) {
            this.removeAttribute(attribute.key());
        }

        @Override
        public void setAttribute(SessionAttribute attribute, Object value) {
            this.setAttribute(attribute.key(), value);
        }

        @Override
        public Object getAttribute(SessionAttribute attribute) {
            return this.getAttribute(attribute.key());
        }

        @Override
        public void checkPermission(Right right) {
            this.iCheck.checkPermission(this.getUser(), null, null, right);
        }

        @Override
        public void checkPermission(Serializable targetId, String targetType, Right right) {
            this.iCheck.checkPermission(this.getUser(), targetId, targetType, right);
        }

        @Override
        public void checkPermission(Object targetObject, Right right) {
            this.iCheck.checkPermission(this.getUser(), targetObject, right);
        }

        @Override
        public boolean hasPermission(Right right) {
            return this.iCheck.hasPermission(this.getUser(), null, null, right);
        }

        @Override
        public boolean hasPermission(Serializable targetId, String targetType, Right right) {
            return this.iCheck.hasPermission(this.getUser(), targetId, targetType, right);
        }

        @Override
        public boolean hasPermission(Object targetObject, Right right) {
            return this.iCheck.hasPermission(this.getUser(), targetObject, right);
        }

        @Override
        public void checkPermissionAnyAuthority(Right right, Qualifiable ... filter) {
            this.iCheck.checkPermissionAnyAuthority(this.getUser(), null, null, right, filter);
        }

        @Override
        public void checkPermissionAnyAuthority(Serializable targetId, String targetType, Right right, Qualifiable ... filter) {
            this.iCheck.checkPermissionAnyAuthority(this.getUser(), targetId, targetType, right, filter);
        }

        @Override
        public void checkPermissionAnyAuthority(Object targetObject, Right right, Qualifiable ... filter) {
            this.iCheck.checkPermissionAnyAuthority(this.getUser(), targetObject, right, filter);
        }

        @Override
        public boolean hasPermissionAnyAuthority(Right right, Qualifiable ... filter) {
            return this.iCheck.hasPermissionAnyAuthority(this.getUser(), null, null, right, filter);
        }

        @Override
        public boolean hasPermissionAnyAuthority(Serializable targetId, String targetType, Right right, Qualifiable ... filter) {
            return this.iCheck.hasPermissionAnyAuthority(this.getUser(), targetId, targetType, right, filter);
        }

        @Override
        public boolean hasPermissionAnyAuthority(Object targetObject, Right right, Qualifiable ... filter) {
            return this.iCheck.hasPermissionAnyAuthority(this.getUser(), targetObject, right, filter);
        }

        @Override
        public void checkPermissionAnySession(Right right, Qualifiable ... filter) {
            this.iCheck.checkPermissionAnySession(this.getUser(), null, null, right, filter);
        }

        @Override
        public void checkPermissionAnySession(Serializable targetId, String targetType, Right right, Qualifiable ... filter) {
            this.iCheck.checkPermissionAnySession(this.getUser(), targetId, targetType, right, filter);
        }

        @Override
        public void checkPermissionAnySession(Object targetObject, Right right, Qualifiable ... filter) {
            this.iCheck.checkPermissionAnySession(this.getUser(), targetObject, right, filter);
        }

        @Override
        public boolean hasPermissionAnySession(Right right, Qualifiable ... filter) {
            return this.iCheck.hasPermissionAnySession(this.getUser(), null, null, right, filter);
        }

        @Override
        public boolean hasPermissionAnySession(Serializable targetId, String targetType, Right right, Qualifiable ... filter) {
            return this.iCheck.hasPermissionAnySession(this.getUser(), targetId, targetType, right, filter);
        }

        @Override
        public boolean hasPermissionAnySession(Object targetObject, Right right, Qualifiable ... filter) {
            return this.iCheck.hasPermissionAnySession(this.getUser(), targetObject, right, filter);
        }

        @Override
        public void checkPermissionOtherAuthority(Right right, OtherAuthority other) {
            this.iCheck.checkPermission(this.getUser(), null, null, right, other);
        }

        @Override
        public void checkPermissionOtherAuthority(Serializable targetId, String targetType, Right right, OtherAuthority other) {
            this.iCheck.checkPermission(this.getUser(), targetId, targetType, right, other);
        }

        @Override
        public void checkPermissionOtherAuthority(Object targetObject, Right right, OtherAuthority other) {
            this.iCheck.checkPermission(this.getUser(), targetObject, right, other);
        }

        @Override
        public boolean hasPermissionOtherAuthority(Right right, OtherAuthority other) {
            return this.iCheck.hasPermission(this.getUser(), null, null, right, other);
        }

        @Override
        public boolean hasPermissionOtherAuthority(Serializable targetId, String targetType, Right right, OtherAuthority other) {
            return this.iCheck.hasPermission(this.getUser(), targetId, targetType, right, other);
        }

        @Override
        public boolean hasPermissionOtherAuthority(Object targetObject, Right right, OtherAuthority other) {
            return this.iCheck.hasPermission(this.getUser(), targetObject, right, other);
        }
    }
}

