/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.script;

import java.util.Collections;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseList;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.shared.EventInterface;
import org.unitime.timetable.gwt.shared.TaskInterface;
import org.unitime.timetable.model.PeriodicTask;
import org.unitime.timetable.model.TaskExecution;
import org.unitime.timetable.model.TaskParameter;
import org.unitime.timetable.model.dao.PeriodicTaskDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.script.LoadAllScriptsBackend;
import org.unitime.timetable.util.CalendarUtils;
import org.unitime.timetable.util.Constants;

@GwtRpcImplements(value=TaskInterface.GetTasksRpcRequest.class)
public class GetTasksBackend
implements GwtRpcImplementation<TaskInterface.GetTasksRpcRequest, GwtRpcResponseList<TaskInterface>> {
    @Override
    public GwtRpcResponseList<TaskInterface> execute(TaskInterface.GetTasksRpcRequest request, SessionContext context) {
        context.checkPermission(Right.Tasks);
        GwtRpcResponseList<TaskInterface> tasks = new GwtRpcResponseList<TaskInterface>();
        for (PeriodicTask t : PeriodicTaskDAO.getInstance().getSession().createQuery("from PeriodicTask where session.uniqueId = :sessionId", PeriodicTask.class).setParameter("sessionId", (Object)context.getUser().getCurrentAcademicSessionId()).setCacheable(true).list()) {
            tasks.add(GetTasksBackend.getTask(t, context));
        }
        Collections.sort(tasks);
        return tasks;
    }

    public static TaskInterface getTask(PeriodicTask t, SessionContext context) {
        TaskInterface task = new TaskInterface();
        task.setId(t.getUniqueId());
        task.setName(t.getName());
        task.setEmail(t.getEmail());
        String nameFormat = context.getUser().getProperty(UserProperty.NameFormat);
        EventInterface.ContactInterface owner = new EventInterface.ContactInterface();
        owner.setAcademicTitle(t.getOwner().getAcademicTitle());
        owner.setEmail(t.getOwner().getEmailAddress());
        owner.setExternalId(t.getOwner().getExternalUniqueId());
        owner.setFirstName(t.getOwner().getFirstName());
        owner.setMiddleName(t.getOwner().getMiddleName());
        owner.setLastName(t.getOwner().getLastName());
        owner.setFormattedName(t.getOwner().getName(nameFormat));
        task.setOwner(owner);
        task.setScript(LoadAllScriptsBackend.load(t.getScript(), context));
        task.setCanEdit(context.hasPermission(Right.TaskEdit) && task.getScript().canEdit());
        task.setCanView(context.hasPermission(Right.TaskDetail) && task.getScript().canExecute());
        for (TaskParameter p : t.getParameters()) {
            task.setParameter(p.getName(), p.getValue());
        }
        for (TaskExecution e : t.getSchedule()) {
            TaskInterface.TaskExecutionInterface exec = new TaskInterface.TaskExecutionInterface();
            exec.setId(e.getUniqueId());
            exec.setCreated(e.getCreatedDate());
            exec.setStatus(TaskInterface.ExecutionStatus.values()[e.getExecutionStatus()]);
            exec.setExecutionDate(t.getSession().getDate(e.getExecutionDate()));
            exec.setSlot(e.getExecutionPeriod());
            exec.setDayOfWeek(Constants.getDayOfWeek(exec.getExecutionDate()));
            exec.setDayOfYear(CalendarUtils.date2dayOfYear(t.getSession().getSessionStartYear(), exec.getExecutionDate()));
            exec.setFinished(e.getFinishedDate());
            exec.setQueued(e.getQueuedDate());
            exec.setStarted(e.getStartedDate());
            exec.setStatusMessage(e.getStatusMessage());
            if (e.getStartedDate() != null && (task.getLastExecuted() == null || task.getLastExecuted().before(e.getStartedDate()))) {
                task.setLastExecuted(e.getStartedDate());
                task.setLastStatus(TaskInterface.ExecutionStatus.values()[e.getExecutionStatus()]);
            }
            exec.setOutput(e.getOutputName());
            task.addExecution(exec);
        }
        return task;
    }
}

