/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.rooms;

import org.springframework.beans.factory.annotation.Autowired;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.CommonValues;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.events.EventAction;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.RoomInterface;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.ExamLocationPref;
import org.unitime.timetable.model.ExamPeriod;
import org.unitime.timetable.model.ExamPeriodPref;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.dao.ExamDAO;
import org.unitime.timetable.model.dao.ExamTypeDAO;
import org.unitime.timetable.model.dao.LocationDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.solver.exam.ExamSolverProxy;
import org.unitime.timetable.solver.exam.ui.ExamAssignment;
import org.unitime.timetable.solver.service.SolverService;

@GwtRpcImplements(value=RoomInterface.PeriodPreferenceRequest.class)
public class PeriodPreferencesBackend
implements GwtRpcImplementation<RoomInterface.PeriodPreferenceRequest, RoomInterface.PeriodPreferenceModel> {
    protected static final GwtConstants CONSTANTS = Localization.create(GwtConstants.class);
    protected static final GwtMessages MESSAGES = Localization.create(GwtMessages.class);
    @Autowired
    SolverService<ExamSolverProxy> examinationSolverService;

    @Override
    public RoomInterface.PeriodPreferenceModel execute(RoomInterface.PeriodPreferenceRequest request, SessionContext context) {
        if (request.hasSessionId()) {
            context = new EventAction.EventContext(context, request.getSessionId());
        }
        switch (request.getOperation()) {
            case LOAD: {
                return this.loadPeriodPreferences(request, context);
            }
            case LOAD_FOR_EXAM: {
                return this.loadExamPeriodPreferences(request, context);
            }
            case SAVE: {
                return this.savePeriodPreferences(request, context);
            }
        }
        return null;
    }

    public RoomInterface.PeriodPreferenceModel loadPeriodPreferences(RoomInterface.PeriodPreferenceRequest request, SessionContext context) {
        Location location = request.getLocationId() == null ? null : (Location)LocationDAO.getInstance().get(request.getLocationId());
        ExamType type = (ExamType)ExamTypeDAO.getInstance().get(request.getExamTypeId());
        context.checkPermission(location, Right.RoomDetailPeriodPreferences);
        return this.loadPeriodPreferences(location, type, context);
    }

    public RoomInterface.PeriodPreferenceModel loadExamPeriodPreferences(RoomInterface.PeriodPreferenceRequest request, SessionContext context) {
        Exam exam = request.getExamId() == null ? null : (Exam)ExamDAO.getInstance().get(request.getExamId());
        ExamType type = exam == null ? (ExamType)ExamTypeDAO.getInstance().get(request.getExamTypeId()) : exam.getExamType();
        return this.loadExamPeriodPreferences(exam, type, context);
    }

    public static RoomInterface.PeriodPreferenceModel createPeriodPreferenceModel(Session session, ExamType type, SessionContext context, boolean roomPref) {
        RoomInterface.PeriodPreferenceModel model = new RoomInterface.PeriodPreferenceModel();
        model.setDefaultHorizontal(CommonValues.HorizontalGrid.eq(context.getUser().getProperty(UserProperty.GridOrientation)));
        model.setReqConfirmation(CommonValues.Yes.eq(context.getUser().getProperty(UserProperty.ConfirmationDialogs)));
        model.setExamType(new RoomInterface.ExamTypeInterface(type.getUniqueId(), type.getReference(), type.getLabel(), type.getType() == 0));
        model.setFirstDate(session.getExamBeginDate());
        for (ExamPeriod period : ExamPeriod.findAll(session.getUniqueId(), type)) {
            model.addPeriod(new RoomInterface.PeriodInterface(period.getUniqueId(), period.getDateOffset(), period.getStartSlot(), period.getLength()));
        }
        for (PreferenceLevel pref : PreferenceLevel.getPreferenceLevelList(model.getPeriods().size() < model.getDays().size() * model.getSlots().size())) {
            RoomInterface.PreferenceInterface p = new RoomInterface.PreferenceInterface(pref.getUniqueId(), PreferenceLevel.prolog2bgColor(pref.getPrefProlog()), pref.getPrefProlog(), pref.getPrefName(), pref.getAbbreviation(), true);
            if (PreferenceLevel.sRequired.equals(pref.getPrefProlog()) && roomPref) continue;
            if ((roomPref || model.getExamType().isFinal() ? PreferenceLevel.sNeutral : PreferenceLevel.sProhibited).equals(pref.getPrefProlog())) {
                model.setDefaultPreference(p);
            }
            if (PreferenceLevel.sNeutral.equals(pref.getPrefProlog())) {
                model.setSelectedPreference(p);
            }
            if (PreferenceLevel.sNotAvailable.equals(pref.getPrefProlog())) {
                p.setEditable(false);
            }
            model.addPreference(p);
        }
        return model;
    }

    public RoomInterface.PeriodPreferenceModel loadPeriodPreferences(Location location, ExamType type, SessionContext context) {
        Session session = location == null ? (Session)SessionDAO.getInstance().get(context.getUser().getCurrentAcademicSessionId()) : location.getSession();
        RoomInterface.PeriodPreferenceModel model = PeriodPreferencesBackend.createPeriodPreferenceModel(session, type, context, true);
        if (location != null) {
            model.setLocationId(location.getUniqueId());
            for (ExamLocationPref pref : location.getExamPreferences()) {
                if (!type.equals(pref.getExamPeriod().getExamType())) continue;
                model.setPreference((int)pref.getExamPeriod().getDateOffset(), (int)pref.getExamPeriod().getStartSlot(), pref.getPrefLevel().getUniqueId());
            }
        }
        return model;
    }

    public RoomInterface.PeriodPreferenceModel loadExamPeriodPreferences(Exam exam, ExamType type, SessionContext context) {
        return this.loadExamPeriodPreferences(this.examinationSolverService == null ? null : this.examinationSolverService.getSolver(), exam, type, context);
    }

    public RoomInterface.PeriodPreferenceModel loadExamPeriodPreferences(ExamSolverProxy solver, Exam exam, ExamType type, SessionContext context) {
        Session session = exam == null ? (Session)SessionDAO.getInstance().get(context.getUser().getCurrentAcademicSessionId()) : exam.getSession();
        RoomInterface.PeriodPreferenceModel model = PeriodPreferencesBackend.createPeriodPreferenceModel(session, type, context, false);
        if (exam != null) {
            model.setExamId(exam.getUniqueId());
            for (ExamPeriodPref pref : exam.getPreferences(ExamPeriodPref.class)) {
                model.setPreference((int)pref.getExamPeriod().getDateOffset(), (int)pref.getExamPeriod().getStartSlot(), pref.getPrefLevel().getUniqueId());
            }
            if (solver != null && solver.getExamTypeId().equals(exam.getExamType().getUniqueId())) {
                ExamAssignment assignment = solver.getAssignment(exam.getUniqueId());
                if (assignment != null) {
                    model.setAssignedPeriodId(assignment.getPeriodId());
                }
            } else if (exam.getAssignedPeriod() != null) {
                model.setAssignedPeriodId(exam.getAssignedPeriod().getUniqueId());
            }
        }
        return model;
    }

    public RoomInterface.PeriodPreferenceModel savePeriodPreferences(RoomInterface.PeriodPreferenceRequest request, SessionContext context) {
        Location location = request.getLocationId() == null ? null : (Location)LocationDAO.getInstance().get(request.getLocationId());
        ExamType type = (ExamType)ExamTypeDAO.getInstance().get(request.getExamTypeId());
        context.checkPermission(location, Right.RoomEditChangeExaminationStatus);
        return this.savePeriodPreferences(location, type, request.getModel(), context);
    }

    public RoomInterface.PeriodPreferenceModel savePeriodPreferences(Location location, ExamType type, RoomInterface.PeriodPreferenceModel model, SessionContext context) {
        location.clearExamPreferences(type);
        for (ExamPeriod period : ExamPeriod.findAll(location.getSession().getUniqueId(), type)) {
            RoomInterface.PreferenceInterface pref = model.getPreference(period.getDateOffset(), period.getStartSlot());
            if (pref == null || PreferenceLevel.sNeutral.equals(pref.getCode())) continue;
            location.addExamPreference(period, PreferenceLevel.getPreferenceLevel(pref.getCode()));
        }
        return model;
    }
}

