/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.rooms;

import org.cpsolver.ifs.util.DistanceMetric;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.shared.RoomInterface;
import org.unitime.timetable.model.Building;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;

@GwtRpcImplements(value=RoomInterface.GetBuildingsRequest.class)
public class GetBuidlingsDataBackend
implements GwtRpcImplementation<RoomInterface.GetBuildingsRequest, RoomInterface.BuildingsDataResponse> {
    @Override
    public RoomInterface.BuildingsDataResponse execute(RoomInterface.GetBuildingsRequest request, SessionContext context) {
        context.checkPermission(Right.BuildingList);
        RoomInterface.BuildingsDataResponse response = new RoomInterface.BuildingsDataResponse();
        response.setCanAdd(context.hasPermission(Right.BuildingAdd));
        response.setCanExportPDF(context.hasPermission(Right.BuildingExportPdf));
        response.setCanUpdateData(context.hasPermission(Right.BuildingUpdateData));
        DistanceMetric.Ellipsoid ellipsoid = DistanceMetric.Ellipsoid.valueOf((String)ApplicationProperty.DistanceEllipsoid.value());
        response.setEllipsoid(ellipsoid.getEclipsoindName());
        for (Building building : Building.findAll(context.getUser().getCurrentAcademicSessionId())) {
            RoomInterface.BuildingInterface b = new RoomInterface.BuildingInterface();
            b.setId(building.getUniqueId());
            b.setAbbreviation(building.getAbbreviation());
            b.setName(building.getName());
            b.setX(building.getCoordinateX());
            b.setY(building.getCoordinateY());
            b.setExternalId(building.getExternalUniqueId());
            b.setCanEdit(context.hasPermission(building, Right.BuildingEdit));
            response.addBuilding(b);
        }
        return response;
    }
}

