/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.menu;

import jakarta.servlet.ServletException;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.hibernate.Session;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.DependsOn;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.PageNames;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.action.PersonalizedExamReportAction;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.command.client.GwtRpcException;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseList;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.command.server.GwtRpcLogging;
import org.unitime.timetable.gwt.shared.MenuInterface;
import org.unitime.timetable.model.PointInTimeData;
import org.unitime.timetable.model.SavedHQL;
import org.unitime.timetable.model.SolverGroup;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.Qualifiable;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.UserAuthority;
import org.unitime.timetable.security.UserContext;
import org.unitime.timetable.security.qualifiers.SimpleQualifier;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.solver.service.SolverServerService;
import org.unitime.timetable.util.RoomAvailability;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

@GwtRpcImplements(value=MenuInterface.MenuRpcRequest.class)
@GwtRpcLogging(value=GwtRpcLogging.Level.ON_EXCEPTION)
@DependsOn(value={"startupService"})
public class MenuBackend
implements GwtRpcImplementation<MenuInterface.MenuRpcRequest, GwtRpcResponseList<MenuInterface>>,
InitializingBean {
    private static Log sLog = LogFactory.getLog(MenuBackend.class);
    protected Element iRoot = null;
    private static PageNames sPageNames = Localization.create(PageNames.class);
    @Autowired
    private SolverServerService solverServerService;
    @Autowired
    private SessionContext sessionContext;

    public void afterPropertiesSet() throws Exception {
        try {
            String menu = ApplicationProperty.MenuFile.value();
            Document document = null;
            URL menuUrl = ApplicationProperties.class.getClassLoader().getResource(menu);
            SAXReader sax = new SAXReader();
            sax.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) {
                    if (publicId.equals("-//UniTime//UniTime Menu DTD/EN")) {
                        return new InputSource(ApplicationProperties.class.getClassLoader().getResourceAsStream("menu.dtd"));
                    }
                    return null;
                }
            });
            if (menuUrl != null) {
                sLog.info((Object)("Reading menu from " + URLDecoder.decode(menuUrl.getPath(), "UTF-8") + " ..."));
                document = sax.read(menuUrl.openStream());
            } else if (new File(menu).exists()) {
                sLog.info((Object)("Reading menu from " + menu + " ..."));
                document = sax.read(new File(menu));
            }
            if (document == null) {
                throw new ServletException("Unable to create menu, reason: resource " + menu + " not found.");
            }
            if (!"unitime-menu".equals(document.getRootElement().getName())) {
                throw new ServletException("Menu has an unknown format.");
            }
            this.iRoot = document.getRootElement();
            String customMenu = ApplicationProperty.CustomMenuFile.value();
            Document customDocument = null;
            URL customMenuUrl = ApplicationProperties.class.getClassLoader().getResource(customMenu);
            if (customMenuUrl != null) {
                sLog.info((Object)("Reading custom menu from " + URLDecoder.decode(customMenuUrl.getPath(), "UTF-8") + " ..."));
                customDocument = sax.read(customMenuUrl.openStream());
            } else if (new File(customMenu).exists()) {
                sLog.info((Object)("Reading custom menu from " + customMenu + " ..."));
                customDocument = sax.read(new File(customMenu));
            }
            if (customDocument != null) {
                this.merge(this.iRoot, customDocument.getRootElement());
            }
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException("Unable to initialize, reason: " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GwtRpcResponseList<MenuInterface> execute(MenuInterface.MenuRpcRequest request, SessionContext context) {
        GwtRpcResponseList<MenuInterface> gwtRpcResponseList;
        Session hibSession = SessionDAO.getInstance().getSession();
        try {
            GwtRpcResponseList<MenuInterface> menu = new GwtRpcResponseList<MenuInterface>();
            if (this.iRoot == null) {
                throw new GwtRpcException("menu is not configured properly");
            }
            Iterator i = this.iRoot.elementIterator();
            while (i.hasNext()) {
                Element element = (Element)i.next();
                MenuInterface m = this.getMenu(element);
                if (m == null) continue;
                menu.add(m);
            }
            if (menu.isEmpty()) {
                throw new GwtRpcException("no menu");
            }
            gwtRpcResponseList = menu;
        }
        catch (Throwable throwable) {
            try {
                hibSession.close();
                throw throwable;
            }
            catch (GwtRpcException e) {
                throw e;
            }
            catch (Exception e) {
                throw new GwtRpcException(e.getMessage());
            }
        }
        hibSession.close();
        return gwtRpcResponseList;
    }

    private void merge(Element menu, Element custom) {
        if ("remove".equals(custom.getName())) {
            menu.getParent().remove(menu);
            return;
        }
        Iterator i = custom.attributeIterator();
        while (i.hasNext()) {
            Attribute a = (Attribute)i.next();
            menu.addAttribute(a.getName(), a.getValue());
        }
        i = custom.elementIterator();
        while (i.hasNext()) {
            Iterator j;
            Element e = (Element)i.next();
            if ("parameter".equals(e.getName())) {
                j = menu.elementIterator("parameter");
                while (j.hasNext()) {
                    menu.remove((Element)j.next());
                }
                menu.add(e.createCopy());
                continue;
            }
            if ("condition".equals(e.getName())) {
                menu.add(e.createCopy());
                continue;
            }
            if ("new-condition".equals(e.getName())) {
                j = menu.elementIterator("condition");
                while (j.hasNext()) {
                    menu.remove((Element)j.next());
                }
                Element f = e.createCopy();
                f.setName("condition");
                menu.add(f);
                continue;
            }
            String name = e.attributeValue("name");
            Element x = null;
            if (name != null) {
                Iterator j2 = menu.elementIterator();
                while (j2.hasNext()) {
                    Element f = (Element)j2.next();
                    if (!name.equals(f.attributeValue("name"))) continue;
                    x = f;
                    break;
                }
            }
            if (x != null) {
                this.merge(x, e);
                continue;
            }
            int pos = Integer.parseInt(e.attributeValue("position", "-1"));
            if (pos >= 0) {
                ArrayList<Element> after = new ArrayList<Element>();
                Iterator j3 = menu.elementIterator();
                while (j3.hasNext()) {
                    Element f = (Element)j3.next();
                    if ("condition".equals(f.getName())) continue;
                    if (pos > 0) {
                        --pos;
                        continue;
                    }
                    after.add(f);
                    menu.remove(f);
                }
                menu.add(e.createCopy());
                for (Element f : after) {
                    menu.add(f);
                }
                continue;
            }
            menu.add(e.createCopy());
        }
    }

    private MenuInterface getMenu(Element menuElement) {
        try {
            MenuInterface menu = new MenuInterface();
            String name = menuElement.attributeValue("name");
            String localizedName = name == null ? null : sPageNames.translateMessage(name.trim().replace(' ', '-').replace("(", "").replace(")", "").replace(':', '-').toLowerCase(), null, new Object[0]);
            menu.setName(localizedName == null ? name : localizedName);
            menu.setTitle(menuElement.attributeValue("title"));
            menu.setTarget(menuElement.attributeValue("target"));
            menu.setPage(menuElement.attributeValue("page"));
            menu.setHash(menuElement.attributeValue("hash"));
            String type = menuElement.attributeValue("type");
            if ("gwt".equals(type)) {
                menu.setGWT(true);
            }
            if ("property".equals(type) && menu.getPage() != null) {
                menu.setPage(ApplicationProperties.getProperty(menu.getPage()));
                if (menu.getPage() == null) {
                    return null;
                }
            }
            boolean sep = true;
            Iterator i = menuElement.elementIterator();
            while (i.hasNext()) {
                Element element = (Element)i.next();
                if ("condition".equals(element.getName())) {
                    if (this.check(element)) continue;
                    return null;
                }
                if ("parameter".equals(element.getName())) {
                    menu.addParameter(element.attributeValue("name"), element.attributeValue("value", element.getText()));
                    continue;
                }
                MenuInterface m = this.getMenu(element);
                if (m == null || sep && m.isSeparator()) continue;
                menu.addSubMenu(m);
                sep = m.isSeparator();
            }
            while (menu.hasSubMenus() && menu.getSubMenus().get(menu.getSubMenus().size() - 1).isSeparator()) {
                menu.getSubMenus().remove(menu.getSubMenus().size() - 1);
            }
            return menu.isSeparator() || menu.hasPage() || menu.hasSubMenus() ? menu : null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean check(Element conditionElement) {
        UserAuthority userAuthority;
        UserContext user;
        Right right;
        block51: {
            String cond;
            block52: {
                block49: {
                    String role;
                    String authority;
                    block50: {
                        cond = conditionElement.getName();
                        if ("and".equals(cond) || "condition".equals(cond)) {
                            Element element;
                            Iterator i = conditionElement.elementIterator();
                            do {
                                if (!i.hasNext()) return true;
                            } while (this.check(element = (Element)i.next()));
                            return false;
                        }
                        if ("or".equals(cond)) {
                            Element element;
                            Iterator i = conditionElement.elementIterator();
                            do {
                                if (!i.hasNext()) return false;
                            } while (!this.check(element = (Element)i.next()));
                            return true;
                        }
                        if ("not".equals(cond)) {
                            Element element;
                            Iterator i = conditionElement.elementIterator();
                            do {
                                if (!i.hasNext()) return true;
                            } while (!this.check(element = (Element)i.next()));
                            return false;
                        }
                        if ("isAuthenticated".equals(cond)) {
                            return this.sessionContext.isAuthenticated();
                        }
                        if ("hasRole".equals(cond)) {
                            UserContext user2 = this.sessionContext.getUser();
                            if (user2 == null) {
                                return false;
                            }
                            String role2 = conditionElement.attributeValue("name");
                            if (role2 == null) {
                                return this.sessionContext.hasPermission(Right.HasRole);
                            }
                            if (user2.getCurrentAuthority() != null) return role2.equalsIgnoreCase(user2.getCurrentAuthority().getRole());
                            return "Anonymous".equals(role2);
                        }
                        if ("propertyEquals".equals(cond)) {
                            return conditionElement.attributeValue("value", "true").equalsIgnoreCase(ApplicationProperties.getProperty(conditionElement.attributeValue("name", "dummy"), conditionElement.attributeValue("defaultValue", "false")));
                        }
                        if ("hasProperty".equals(cond)) {
                            if (ApplicationProperties.getProperty(conditionElement.attributeValue("name", "dummy")) == null) return false;
                            return true;
                        }
                        if (!"hasPermission".equals(cond)) break block49;
                        right = null;
                        try {
                            right = Right.valueOf(conditionElement.attributeValue("name"));
                        }
                        catch (IllegalArgumentException e) {
                            sLog.warn((Object)("Unknown right: " + conditionElement.attributeValue("name")));
                        }
                        if (right == null) {
                            return false;
                        }
                        authority = conditionElement.attributeValue("authority", "current");
                        String check = conditionElement.attributeValue("check", "true");
                        if (!"false".equals(check)) break block50;
                        if (!this.sessionContext.isAuthenticated()) return false;
                        UserContext userContext = this.sessionContext.getUser();
                        user = userContext;
                        if (user == null) {
                            return false;
                        }
                        if ("session".equals(authority)) break block51;
                        if ("role".equals(authority)) {
                            List<? extends UserAuthority> authorities;
                            String role3 = user.getCurrentAuthority() != null ? user.getCurrentAuthority().getRole() : null;
                            List<? extends UserAuthority> list = authorities = role3 == null ? null : user.getAuthorities(role3, new Qualifiable[0]);
                            if (authorities != null) {
                                for (UserAuthority userAuthority2 : authorities) {
                                    if (!userAuthority2.hasRight(right)) continue;
                                    return true;
                                }
                            }
                            break block52;
                        } else {
                            if ("any".equals(authority)) {
                                UserAuthority userAuthority3;
                                Collection<? extends UserAuthority> authorities = user.getAuthorities();
                                if (authorities == null) return false;
                                Iterator<? extends UserAuthority> iterator = authorities.iterator();
                                do {
                                    if (!iterator.hasNext()) return false;
                                } while (!(userAuthority3 = iterator.next()).hasRight(right));
                                return true;
                            }
                            if (user.getCurrentAuthority() == null) return false;
                            if (!user.getCurrentAuthority().hasRight(right)) return false;
                            return true;
                        }
                    }
                    if ("session".equals(authority)) {
                        if (!this.sessionContext.isAuthenticated()) return false;
                        Long l = this.sessionContext.getUser().getCurrentAcademicSessionId();
                        Long sessionId = l;
                        if (sessionId == null) {
                            return false;
                        }
                        boolean bl = this.sessionContext.hasPermissionAnyAuthority(right, new SimpleQualifier("Session", sessionId));
                        return bl;
                    }
                    if (!"role".equals(authority)) {
                        if (!"any".equals(authority)) return this.sessionContext.hasPermission(right);
                        return this.sessionContext.hasPermissionAnyAuthority(right, new Qualifiable[0]);
                    }
                    UserAuthority ua = this.sessionContext.isAuthenticated() ? this.sessionContext.getUser().getCurrentAuthority() : null;
                    String string = role = ua != null ? ua.getRole() : "Anonymous";
                    if (role == null) {
                        return false;
                    }
                    boolean bl = this.sessionContext.hasPermissionAnyAuthority(right, new SimpleQualifier("Role", (Serializable)((Object)role)));
                    return bl;
                }
                if ("hasRight".equals(cond)) {
                    String right2 = conditionElement.attributeValue("name", "unknown");
                    if ("canSeeEvents".equals(right2)) {
                        return this.sessionContext.hasPermissionAnyAuthority(Right.Events, new Qualifiable[0]);
                    }
                    if ("hasRoomAvailability".equals(right2)) {
                        if (RoomAvailability.getInstance() == null) return false;
                        return true;
                    }
                    if ("hasPersonalReport".equals(right2)) {
                        if (!this.sessionContext.isAuthenticated()) return false;
                        if (!PersonalizedExamReportAction.hasPersonalReport(this.sessionContext.getUser().getExternalUserId())) return false;
                        return true;
                    }
                    if ("isChameleon".equals(right2)) {
                        if (!this.sessionContext.isAuthenticated()) return false;
                        if (this.sessionContext.hasPermission(Right.Chameleon)) return true;
                        if (!(this.sessionContext.getUser() instanceof UserContext.Chameleon)) return false;
                        return true;
                    }
                    if ("isSectioningEnabled".equals(right2)) {
                        return this.solverServerService.isOnlineStudentSchedulingEnabled();
                    }
                    if ("isStudent".equals(right2)) {
                        if (!this.sessionContext.isAuthenticated()) return false;
                        if (!this.sessionContext.getUser().hasRole("Student")) return false;
                        return true;
                    }
                    if ("isInstructor".equals(right2)) {
                        if (!this.sessionContext.isAuthenticated()) return false;
                        if (!this.sessionContext.getUser().hasRole("Instructor")) return false;
                        return true;
                    }
                    if ("isRegistrationEnabled".equals(right2)) {
                        return this.solverServerService.isStudentRegistrationEnabled();
                    }
                    if ("canSeeCourses".equals(right2)) {
                        if (this.sessionContext.hasPermission(Right.InstructionalOfferings)) return true;
                        if (this.sessionContext.hasPermission(Right.Classes)) return true;
                        return false;
                    }
                    if ("canSeeTimetable".equals(right2)) {
                        return this.sessionContext.hasPermission(Right.ClassAssignments);
                    }
                    if ("canDoTimetable".equals(right2)) {
                        return this.sessionContext.hasPermission(Right.CourseTimetabling);
                    }
                    if ("hasASolverGroup".equals(right2)) {
                        if (!this.sessionContext.isAuthenticated()) return false;
                        if (SolverGroup.getUserSolverGroups(this.sessionContext.getUser()).isEmpty()) return false;
                        return true;
                    }
                    if ("canSectionStudents".equals(right2)) {
                        return this.sessionContext.hasPermission(Right.StudentScheduling);
                    }
                    if ("canSeeExams".equals(right2)) {
                        return this.sessionContext.hasPermission(Right.Examinations);
                    }
                    if ("canTimetableExams".equals(right2)) {
                        return this.sessionContext.hasPermission(Right.ExaminationTimetabling);
                    }
                    if ("canAudit".equals(right2)) {
                        return this.sessionContext.hasPermission(Right.CourseTimetablingAudit);
                    }
                    if ("hasCourseReports".equals(right2)) {
                        if (!this.sessionContext.hasPermission(Right.HQLReportsCourses)) return false;
                        if (!SavedHQL.hasQueries(SavedHQL.Flag.APPEARANCE_COURSES, this.sessionContext.hasPermission(Right.HQLReportsAdminOnly))) return false;
                        return true;
                    }
                    if ("hasExamReports".equals(right2)) {
                        if (!this.sessionContext.hasPermission(Right.HQLReportsExaminations)) return false;
                        if (!SavedHQL.hasQueries(SavedHQL.Flag.APPEARANCE_EXAMS, this.sessionContext.hasPermission(Right.HQLReportsAdminOnly))) return false;
                        return true;
                    }
                    if ("hasEventReports".equals(right2)) {
                        if (!this.sessionContext.hasPermission(Right.HQLReportsEvents)) return false;
                        if (!SavedHQL.hasQueries(SavedHQL.Flag.APPEARANCE_EVENTS, this.sessionContext.hasPermission(Right.HQLReportsAdminOnly))) return false;
                        return true;
                    }
                    if ("hasStudentReports".equals(right2)) {
                        if (!this.sessionContext.hasPermission(Right.HQLReportsStudents)) return false;
                        if (!SavedHQL.hasQueries(SavedHQL.Flag.APPEARANCE_SECTIONING, this.sessionContext.hasPermission(Right.HQLReportsAdminOnly))) return false;
                        return true;
                    }
                    if ("hasPointInTimeDataReports".equals(right2) && !PointInTimeData.findAllForSession(this.sessionContext.getUser().getCurrentAcademicSessionId()).isEmpty()) {
                        return this.sessionContext.hasPermission(Right.PointInTimeDataReports);
                    }
                    sLog.warn((Object)("Unknown right " + right2 + "."));
                    return true;
                }
            }
            sLog.warn((Object)("Unknown condition " + cond + "."));
            return true;
        }
        Long sessionId = user.getCurrentAcademicSessionId();
        Collection<? extends UserAuthority> authorities = user.getAuthorities();
        if (authorities == null) return false;
        if (sessionId == null) return false;
        Iterator<? extends UserAuthority> iterator = authorities.iterator();
        do {
            if (!iterator.hasNext()) return false;
        } while (!sessionId.equals((userAuthority = iterator.next()).getAcademicSession() == null ? null : userAuthority.getAcademicSession().getQualifierId()) || !userAuthority.hasRight(right));
        return true;
    }
}

