/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.courses;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.shared.CourseOfferingInterface;
import org.unitime.timetable.interfaces.ExternalLinkLookup;
import org.unitime.timetable.model.CourseCreditUnitConfig;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.FixedCreditUnitConfig;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.OfferingCoordinator;
import org.unitime.timetable.model.OverrideType;
import org.unitime.timetable.model.VariableFixedCreditUnitConfig;
import org.unitime.timetable.model.VariableRangeCreditUnitConfig;
import org.unitime.timetable.model.comparators.OfferingCoordinatorComparator;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.Constants;

@GwtRpcImplements(value=CourseOfferingInterface.GetCourseOfferingRequest.class)
public class GetCourseOfferingBackend
implements GwtRpcImplementation<CourseOfferingInterface.GetCourseOfferingRequest, CourseOfferingInterface.GetCourseOfferingResponse> {
    @Override
    public CourseOfferingInterface.GetCourseOfferingResponse execute(CourseOfferingInterface.GetCourseOfferingRequest request, SessionContext context) {
        if (!(context.hasPermission(request.getCourseOfferingId(), "CourseOffering", Right.EditCourseOffering) || context.hasPermission(request.getCourseOfferingId(), "CourseOffering", Right.EditCourseOfferingCoordinators) || context.hasPermission(request.getCourseOfferingId(), "CourseOffering", Right.EditCourseOfferingNote))) {
            context.checkPermission(request.getCourseOfferingId(), "CourseOffering", Right.EditCourseOffering);
        }
        CourseOfferingInterface.GetCourseOfferingResponse response = new CourseOfferingInterface.GetCourseOfferingResponse();
        CourseOffering courseOffering = CourseOffering.findByUniqueId(request.getCourseOfferingId());
        InstructionalOffering instructionalOffering = courseOffering.getInstructionalOffering();
        CourseOfferingInterface cof = new CourseOfferingInterface();
        cof.setId(courseOffering.getUniqueId());
        cof.setInstrOfferingId(instructionalOffering.getUniqueId());
        cof.setCourseNbr(courseOffering.getCourseNbr());
        cof.setTitle(courseOffering.getTitle());
        cof.setCourseName(courseOffering.getCourseName());
        cof.setScheduleBookNote(courseOffering.getScheduleBookNote());
        cof.setSubjectAreaAbbv(courseOffering.getSubjectAreaAbbv());
        cof.setSubjectAreaId(courseOffering.getSubjectArea().getUniqueId());
        if (courseOffering.getConsentType() != null) {
            cof.setConsent(courseOffering.getConsentType().getUniqueId());
            cof.setConsentText(courseOffering.getConsentType().getLabel());
        } else {
            cof.setConsent(-1L);
            cof.setConsentText("");
        }
        if (courseOffering.getCredit() != null) {
            CourseCreditUnitConfig credit = courseOffering.getCredit();
            cof.setCreditText(credit.creditText());
            cof.setCreditFormat(credit.getCreditFormat());
            cof.setCreditType(credit.getCreditType().getUniqueId());
            cof.setCreditUnitType(credit.getCreditUnitType().getUniqueId());
            if (credit instanceof FixedCreditUnitConfig) {
                cof.setUnits(((FixedCreditUnitConfig)credit).getFixedUnits());
            } else if (credit instanceof VariableFixedCreditUnitConfig) {
                cof.setUnits(((VariableFixedCreditUnitConfig)credit).getMinUnits());
                cof.setMaxUnits(((VariableFixedCreditUnitConfig)credit).getMaxUnits());
                if (credit instanceof VariableRangeCreditUnitConfig) {
                    cof.setFractionalIncrementsAllowed(((VariableRangeCreditUnitConfig)credit).isFractionalIncrementsAllowed());
                }
            }
        }
        cof.setExternalId(courseOffering.getExternalUniqueId());
        response.setWkEnrollDefault(instructionalOffering.getSession().getLastWeekToEnroll());
        response.setWkChangeDefault(instructionalOffering.getSession().getLastWeekToChange());
        response.setWkDropDefault(instructionalOffering.getSession().getLastWeekToDrop());
        response.setWeekStartDayOfWeek(Localization.getDateFormat("EEEE").format(instructionalOffering.getSession().getSessionBeginDateTime()));
        if (courseOffering.getDemandOffering() != null) {
            cof.setDemandOfferingId(courseOffering.getDemandOffering().getUniqueId());
            cof.setDemandOfferingText(courseOffering.getDemandOffering().getCourseNameWithTitle());
        }
        if (courseOffering.getAlternativeOffering() != null) {
            cof.setAlternativeCourseOfferingId(courseOffering.getAlternativeOffering().getUniqueId());
        }
        if (courseOffering.getFundingDept() != null) {
            cof.setFundingDepartmentId(courseOffering.getFundingDept().getUniqueId());
        }
        if (courseOffering.getEffectiveFundingDept() != null) {
            cof.setEffectiveFundingDepartmentId(courseOffering.getEffectiveFundingDept().getUniqueId());
        }
        if (courseOffering.getCourseType() != null) {
            cof.setCourseTypeId(courseOffering.getCourseType().getUniqueId());
        }
        ArrayList<OfferingCoordinator> coordinatorList = new ArrayList<OfferingCoordinator>(instructionalOffering.getOfferingCoordinators());
        Collections.sort(coordinatorList, new OfferingCoordinatorComparator(context));
        for (OfferingCoordinator coordinator : coordinatorList) {
            CourseOfferingInterface.CoordinatorInterface coordinatorObject = new CourseOfferingInterface.CoordinatorInterface();
            coordinatorObject.setInstructorId(coordinator.getInstructor().getUniqueId().toString());
            coordinatorObject.setPercShare(coordinator.getPercentShare() == null ? "0" : coordinator.getPercentShare().toString());
            coordinatorObject.setResponsibilityId(coordinator.getResponsibility() == null ? Constants.BLANK_OPTION_VALUE : coordinator.getResponsibility().getUniqueId().toString());
            cof.addCoordinator(coordinatorObject);
        }
        cof.setByReservationOnly(instructionalOffering.getByReservationOnly());
        cof.setLastWeekToChange(instructionalOffering.getLastWeekToChange());
        cof.setLastWeekToDrop(instructionalOffering.getLastWeekToDrop());
        cof.setLastWeekToEnroll(instructionalOffering.getLastWeekToEnroll());
        cof.setNotes(instructionalOffering.getNotes());
        cof.setInstrOfferingId(instructionalOffering.getUniqueId());
        cof.setIsControl(courseOffering.getIsControl());
        try {
            String linkLookupClass;
            if (cof.getIsControl().booleanValue() && (linkLookupClass = ApplicationProperty.CourseCatalogLinkProvider.value()) != null && linkLookupClass.trim().length() > 0) {
                ExternalLinkLookup lookup = (ExternalLinkLookup)Class.forName(linkLookupClass).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                Map results = lookup.getLink(instructionalOffering);
                if (results == null) {
                    throw new Exception(lookup.getErrorMessage());
                }
                cof.setCatalogLinkLabel((String)results.get("label"));
                cof.setCatalogLinkLocation((String)results.get("href"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        cof.setIoNotOffered(instructionalOffering.getNotOffered());
        cof.clearCourseOverrides();
        for (OverrideType override : courseOffering.getDisabledOverrides()) {
            cof.addCourseOverride(override.getUniqueId().toString());
        }
        cof.setWaitList(instructionalOffering.getWaitlistMode());
        response.setCourseOffering(cof);
        return response;
    }
}

