/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.courses;

import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.CommonValues;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.gwt.client.offerings.OfferingsInterface;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.FilterInterface;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.ItypeDesc;
import org.unitime.timetable.model.LearningManagementSystemInfo;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.comparators.ClassCourseComparator;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.webutil.BackTracker;

@GwtRpcImplements(value=OfferingsInterface.ClassesFilterRequest.class)
public class ClassesFilterBackend
implements GwtRpcImplementation<OfferingsInterface.ClassesFilterRequest, OfferingsInterface.ClassesFilterResponse> {
    protected static CourseMessages MESSAGES = Localization.create(CourseMessages.class);
    protected static GwtMessages GWT = Localization.create(GwtMessages.class);

    @Override
    public OfferingsInterface.ClassesFilterResponse execute(OfferingsInterface.ClassesFilterRequest request, SessionContext context) {
        context.checkPermission(Right.Classes);
        OfferingsInterface.ClassesFilterResponse filter = new OfferingsInterface.ClassesFilterResponse();
        filter.addParameter(this.createToggle(context, "divSec", MESSAGES.columnExternalId(), false));
        filter.addParameter(this.createToggle(context, "demand", MESSAGES.columnDemand(), true));
        filter.addParameter(this.createToggle(context, "limit", MESSAGES.columnLimit(), true));
        filter.addParameter(this.createToggle(context, "snapshotLimit", MESSAGES.columnSnapshotLimit(), false));
        filter.addParameter(this.createToggle(context, "roomLimit", MESSAGES.columnRoomRatio(), true));
        filter.addParameter(this.createToggle(context, "manager", MESSAGES.columnManager(), true));
        if (ApplicationProperty.CoursesFundingDepartmentsEnabled.isTrue()) {
            filter.addParameter(this.createToggle(context, "fundingDepartment", MESSAGES.columnFundingDepartment(), false));
        }
        filter.addParameter(this.createToggle(context, "datePattern", MESSAGES.columnDatePattern(), true));
        filter.addParameter(this.createToggle(context, "timePattern", MESSAGES.columnTimePattern(), true));
        filter.addParameter(this.createToggle(context, "preferences", MESSAGES.columnPreferences(), true));
        filter.addParameter(this.createToggle(context, "instructorAssignment", MESSAGES.includeInstructorScheduling(), false));
        filter.addParameter(this.createToggle(context, "instructor", MESSAGES.columnInstructor(), true));
        filter.addParameter(this.createToggle(context, "timetable", MESSAGES.columnTimetable(), true));
        filter.addParameter(this.createToggle(context, "schedulePrintNote", MESSAGES.columnSchedulePrintNote(), true));
        if (LearningManagementSystemInfo.isLmsInfoDefinedForSession(context.getUser().getCurrentAcademicSessionId())) {
            filter.addParameter(this.createToggle(context, "lms", MESSAGES.columnLms(), false));
        }
        filter.addParameter(this.createToggle(context, "note", MESSAGES.columnNote(), false));
        if (context.hasPermission(Right.Examinations)) {
            filter.addParameter(this.createToggle(context, "exams", MESSAGES.columnExams(), false));
        }
        FilterInterface.FilterParameterInterface manager = new FilterInterface.FilterParameterInterface();
        manager.setName("filterManager");
        manager.setLabel(MESSAGES.filterManager());
        manager.setType("list");
        manager.setMultiSelect(true);
        manager.addOption("-2", MESSAGES.dropDeptDepartment());
        for (Department department : Department.findAllExternal(context.getUser().getCurrentAcademicSessionId())) {
            manager.addOption(department.getUniqueId().toString(), department.getExternalMgrAbbv() + " - " + department.getExternalMgrLabel());
        }
        manager.setDefaultValue(context.getUser().getProperty("ClassList.filterManager"));
        manager.setMaxLinesToShow(3);
        filter.addParameter(manager);
        FilterInterface.FilterParameterInterface itype = new FilterInterface.FilterParameterInterface();
        itype.setName("filterIType");
        itype.setLabel(MESSAGES.filterInstructionalType());
        itype.addOption("", MESSAGES.dropITypeAll());
        for (ItypeDesc t : ItypeDesc.findAll(true)) {
            itype.addOption(t.getItype().toString(), t.getDesc());
        }
        itype.setDefaultValue(context.getUser().getProperty("ClassList.filterIType", ""));
        filter.addParameter(itype);
        FilterInterface.FilterParameterInterface filterParameterInterface = new FilterInterface.FilterParameterInterface();
        filterParameterInterface.setName("filterInstructor");
        filterParameterInterface.setLabel(MESSAGES.filterInstructor());
        filterParameterInterface.setType("text");
        filterParameterInterface.setDefaultValue(context.getUser().getProperty("ClassList.filterInstructor", ""));
        filter.addParameter(filterParameterInterface);
        FilterInterface.FilterParameterInterface days = new FilterInterface.FilterParameterInterface();
        days.setName("filterDayCode");
        days.setLabel(MESSAGES.filterAssignedTime());
        days.setType("dayCode");
        days.setDefaultValue(context.getUser().getProperty("ClassList.filterDayCode", ""));
        filter.addParameter(days);
        FilterInterface.FilterParameterInterface startTime = new FilterInterface.FilterParameterInterface();
        startTime.setName("filterStartTime");
        startTime.setLabel(MESSAGES.filterAssignedTime());
        startTime.setType("time");
        startTime.setDefaultValue(context.getUser().getProperty("ClassList.filterStartTime", ""));
        startTime.setPrefix(GWT.propFrom());
        startTime.setComposite(true);
        filter.addParameter(startTime);
        FilterInterface.FilterParameterInterface endTime = new FilterInterface.FilterParameterInterface();
        endTime.setName("filterEndTime");
        endTime.setLabel(MESSAGES.filterAssignedTime());
        endTime.setType("time");
        endTime.setDefaultValue(context.getUser().getProperty("ClassList.filterEndTime", ""));
        endTime.setPrefix(GWT.propTo());
        endTime.setComposite(true);
        filter.addParameter(endTime);
        FilterInterface.FilterParameterInterface room = new FilterInterface.FilterParameterInterface();
        room.setName("filterAssignedRoom");
        room.setLabel(MESSAGES.filterAssignedRoom());
        room.setType("text");
        room.setDefaultValue(context.getUser().getProperty("ClassList.filterAssignedRoom", ""));
        filter.addParameter(room);
        FilterInterface.FilterParameterInterface sortBy = new FilterInterface.FilterParameterInterface();
        sortBy.setName("sortBy");
        sortBy.setLabel(MESSAGES.filterSortBy());
        sortBy.setType("list");
        for (String name : ClassCourseComparator.getNames()) {
            sortBy.addOption(name, name);
        }
        sortBy.setDefaultValue(context.getUser().getProperty("ClassList.sortBy", ClassCourseComparator.getName(ClassCourseComparator.SortBy.NAME)));
        filter.addParameter(sortBy);
        FilterInterface.FilterParameterInterface sortByKeepSubparts = this.createToggle(context, "sortByKeepSubparts", MESSAGES.checkSortWithinSubparts(), true);
        sortByKeepSubparts.setLabel(MESSAGES.filterSortBy());
        filter.addParameter(sortByKeepSubparts);
        FilterInterface.FilterParameterInterface crossList = this.createToggle(context, "showCrossListedClasses", MESSAGES.showCrossListedClasses(), false);
        crossList.setLabel(MESSAGES.filterCrossList());
        filter.addParameter(crossList);
        FilterInterface.FilterParameterInterface includeCancelledClasses = this.createToggle(context, "includeCancelledClasses", MESSAGES.showCancelledClasses(), true);
        includeCancelledClasses.setLabel(MESSAGES.filterCancelledClasses());
        filter.addParameter(includeCancelledClasses);
        FilterInterface.FilterParameterInterface filterNeedInstructor = this.createToggle(context, "filterNeedInstructor", MESSAGES.showNeedInstructorClasses(), false);
        filterNeedInstructor.setLabel(MESSAGES.filterNeedInstructorAssignment());
        filter.addParameter(filterNeedInstructor);
        FilterInterface.FilterParameterInterface subjectArea = new FilterInterface.FilterParameterInterface();
        subjectArea.setName("subjectArea");
        subjectArea.setType("list");
        subjectArea.setMultiSelect(true);
        subjectArea.setCollapsible(false);
        subjectArea.setLabel(MESSAGES.filterSubject());
        for (SubjectArea subject : SubjectArea.getUserSubjectAreas(context.getUser())) {
            subjectArea.addOption(subject.getUniqueId().toString(), subject.getLabel());
        }
        subjectArea.setDefaultValue((String)context.getAttribute(SessionAttribute.ClassesSubjectAreas));
        subjectArea.setEnterToSubmit(true);
        filter.addParameter(subjectArea);
        FilterInterface.FilterParameterInterface courseNbr = new FilterInterface.FilterParameterInterface();
        courseNbr.setName("courseNbr");
        courseNbr.setLabel(MESSAGES.filterCourseNumber());
        courseNbr.setType("courseNumber");
        courseNbr.setDefaultValue((String)context.getAttribute(SessionAttribute.ClassesCourseNumber));
        courseNbr.setCollapsible(false);
        courseNbr.setConfig("subjectId=${subjectArea};notOffered=false;crossListed=${showCrossListedClasses}");
        courseNbr.setEnterToSubmit(true);
        filter.addParameter(courseNbr);
        if (subjectArea.getDefaultValue() == null && courseNbr.getDefaultValue() == null) {
            subjectArea.setDefaultValue((String)context.getAttribute(SessionAttribute.OfferingsSubjectArea));
            courseNbr.setDefaultValue((String)context.getAttribute(SessionAttribute.OfferingsCourseNumber));
        }
        filter.setSticky(CommonValues.Yes.eq(UserProperty.StickyTables.get(context.getUser())));
        filter.setMaxSubjectsToSearchAutomatically(ApplicationProperty.MaxSubjectsToSearchAutomatically.intValue());
        filter.setCanExport(context.hasPermission(Right.ClassesExportPDF));
        filter.setSessionId(context.getUser().getCurrentAcademicSessionId());
        BackTracker.markForBack(context, null, null, false, true);
        return filter;
    }

    protected FilterInterface.FilterParameterInterface createToggle(SessionContext context, String name, String label, Boolean defaultValue) {
        FilterInterface.FilterParameterInterface toggle = new FilterInterface.FilterParameterInterface();
        toggle.setName(name);
        toggle.setLabel(MESSAGES.filterOptionalColumns());
        toggle.setType("boolean");
        toggle.setSuffix(label);
        toggle.setDefaultValue(context.getUser().getProperty("ClassList." + name, defaultValue == null ? null : (defaultValue != false ? "1" : "0")));
        return toggle;
    }
}

