/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.courses;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.cpsolver.ifs.util.ToolBox;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.springframework.beans.factory.annotation.Autowired;
import org.unitime.commons.Debug;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.CommonValues;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.gwt.command.client.GwtRpcException;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.shared.ClassSetupInterface;
import org.unitime.timetable.interfaces.ExternalInstrOffrConfigChangeAction;
import org.unitime.timetable.model.Building;
import org.unitime.timetable.model.BuildingPref;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentRoomFeature;
import org.unitime.timetable.model.DepartmentStatusType;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalMethod;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.LearningManagementSystemInfo;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.Preference;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.Room;
import org.unitime.timetable.model.RoomDept;
import org.unitime.timetable.model.RoomFeature;
import org.unitime.timetable.model.RoomFeaturePref;
import org.unitime.timetable.model.RoomGroup;
import org.unitime.timetable.model.RoomGroupPref;
import org.unitime.timetable.model.RoomPref;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.StudentClassEnrollment;
import org.unitime.timetable.model.TimePattern;
import org.unitime.timetable.model.TimePref;
import org.unitime.timetable.model.comparators.ClassComparator;
import org.unitime.timetable.model.comparators.SchedulingSubpartComparator;
import org.unitime.timetable.model.dao.Class_DAO;
import org.unitime.timetable.model.dao.DatePatternDAO;
import org.unitime.timetable.model.dao.DepartmentDAO;
import org.unitime.timetable.model.dao.InstrOfferingConfigDAO;
import org.unitime.timetable.model.dao.InstructionalMethodDAO;
import org.unitime.timetable.model.dao.LearningManagementSystemInfoDAO;
import org.unitime.timetable.model.dao.SchedulingSubpartDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.permissions.Permission;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.courses.InstrOfferingConfigBackend;
import org.unitime.timetable.solver.ClassAssignmentProxy;
import org.unitime.timetable.solver.service.AssignmentService;

@GwtRpcImplements(value=ClassSetupInterface.class)
public class ClassSetupBackend
implements GwtRpcImplementation<ClassSetupInterface, ClassSetupInterface> {
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    @Autowired
    AssignmentService<ClassAssignmentProxy> classAssignmentService;
    @Autowired
    Permission.PermissionDepartment permissionDepartment;

    @Override
    public ClassSetupInterface execute(ClassSetupInterface request, SessionContext context) {
        context.checkPermission(request.getConfigId(), "InstrOfferingConfig", Right.MultipleClassSetup);
        switch (request.getOperation()) {
            case LOAD: {
                return this.load(request, context);
            }
            case SAVE: {
                return this.save(request, context);
            }
        }
        throw new GwtRpcException("Operation " + request.getOperation() + " not supported.");
    }

    protected ClassSetupInterface load(ClassSetupInterface request, SessionContext context) {
        InstrOfferingConfig ioc = (InstrOfferingConfig)InstrOfferingConfigDAO.getInstance().get(request.getConfigId());
        InstructionalOffering io = ioc.getInstructionalOffering();
        ClassSetupInterface form = new ClassSetupInterface();
        form.setDisplayOptionForMaxLimit(CommonValues.Yes.eq(context.getUser().getProperty(UserProperty.VariableClassLimits)));
        form.setDisplayMaxLimit(false);
        form.setConfigId(ioc.getUniqueId());
        form.setLimit(ioc.getLimit());
        form.setUnlimited(ioc.isUnlimitedEnrollment());
        form.setOfferingId(io.getUniqueId());
        form.setDisplayInstructors(ApplicationProperty.ClassSetupDisplayInstructorFlags.isTrue());
        form.setDisplayEnabledForStudentScheduling(ApplicationProperty.ClassSetupEnabledForStudentScheduling.isTrue());
        form.setDisplayExternalId(ApplicationProperty.ClassSetupShowExternalIds.isTrue() && !ApplicationProperty.ClassSetupEditExternalIds.isTrue());
        form.setEditExternalId(ApplicationProperty.ClassSetupEditExternalIds.isTrue());
        form.setEditSnapshotLimits(ApplicationProperty.ClassSetupEditSnapshotLimits.isTrue() && io.getSnapshotLimitDate() != null && context.hasPermission(Right.MultipleClassSetupSnapshotLimits));
        form.setInstructionalMethodId(ioc.getInstructionalMethod() == null ? -1L : ioc.getInstructionalMethod().getUniqueId());
        form.setInstructionalMethodEditable(ApplicationProperty.WaitListCanChangeInstructionalMethod.isTrue() || !ioc.getInstructionalOffering().effectiveReScheduleNow() || ioc.getEnrollment() == 0);
        form.setDisplayLms(LearningManagementSystemInfo.isLmsInfoDefinedForSession(context.getUser().getCurrentAcademicSessionId()));
        form.setDisplaySnapshotLimit(io.getSnapshotLimitDate() != null);
        form.setValidateLimits(ApplicationProperty.ConfigEditCheckLimits.isTrue());
        Object name = io.getCourseNameWithTitle();
        if (io.hasMultipleConfigurations()) {
            name = (String)name + " [" + ioc.getName() + "]";
        }
        form.setName((String)name);
        if (ioc.getSchedulingSubparts() == null || ioc.getSchedulingSubparts().isEmpty()) {
            throw new GwtRpcException(MSG.errorIOConfigNotDefined());
        }
        ClassAssignmentProxy proxy = this.classAssignmentService.getAssignment();
        ArrayList<SchedulingSubpart> subparts = new ArrayList<SchedulingSubpart>(ioc.getSchedulingSubparts());
        Collections.sort(subparts, new SchedulingSubpartComparator());
        form.setEditUnlimited(true);
        form.setDisplayEnrollments(StudentClassEnrollment.sessionHasEnrollments(io.getSessionId()));
        for (SchedulingSubpart schedulingSubpart : subparts) {
            if (schedulingSubpart.getClasses() == null || schedulingSubpart.getClasses().isEmpty()) {
                throw new GwtRpcException(MSG.errorInitialIOSetupIncomplete());
            }
            DatePattern datePattern = schedulingSubpart.effectiveDatePattern();
            form.addSubpart(schedulingSubpart.getUniqueId(), schedulingSubpart.getItype().getAbbv(), schedulingSubpart.getItype().getDesc(), datePattern == null ? null : datePattern.getName());
            if (schedulingSubpart.getParentSubpart() != null) continue;
            this.loadClasses(form, schedulingSubpart.getClasses(), true, 0, proxy, context);
        }
        Department contrDept = io.getControllingCourseOffering().getSubjectArea().getDepartment();
        form.addDepartment(contrDept.getUniqueId(), contrDept.getDeptCode(), MSG.dropDeptDepartment());
        for (Department department : Department.findAllExternal(io.getSessionId())) {
            form.addDepartment(department.getUniqueId(), department.getDeptCode(), department.getExternalMgrLabel(), context.hasPermission(department, Right.MultipleClassSetupDepartment) && this.permissionDepartment.check(context.getUser(), contrDept, DepartmentStatusType.Status.OwnerEdit, department, DepartmentStatusType.Status.ManagerEdit));
        }
        LearningManagementSystemInfo learningManagementSystemInfo = LearningManagementSystemInfo.getDefaultIfExists(io.getSessionId());
        form.addLMS(-1L, MSG.dropDefaultLearningManagementSystem(), MSG.dropDefaultLearningManagementSystem() + (String)(learningManagementSystemInfo == null ? "" : " (" + learningManagementSystemInfo.getLabel() + ")"));
        for (LearningManagementSystemInfo lms : LearningManagementSystemInfo.findAll(io.getSessionId())) {
            form.addLMS(lms.getUniqueId(), lms.getReference(), lms.getLabel());
        }
        List<InstructionalMethod> list = InstructionalMethod.findAll();
        if (!list.isEmpty()) {
            InstructionalMethod defaultType = io.getSession().getDefaultInstructionalMethod();
            if (defaultType == null) {
                form.addInstructionalMethod(-1L, "", MSG.selectNoInstructionalMethod());
            } else {
                form.addInstructionalMethod(-1L, defaultType.getReference(), MSG.defaultInstructionalMethod(defaultType.getLabel()));
            }
            for (InstructionalMethod type : InstructionalMethod.findAll()) {
                if (!type.isVisible().booleanValue() && !type.equals(ioc.getInstructionalMethod())) continue;
                form.addInstructionalMethod(type.getUniqueId(), type.getReference(), type.getLabel());
            }
        }
        try {
            for (DatePattern dp : DatePattern.findAll(context.getUser(), io.getDepartment(), io.getSession().getDefaultDatePatternNotNull())) {
                form.addDatePattern(dp.getUniqueId(), dp.getName(), dp.getName(), !dp.isExtended());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return form;
    }

    private void loadClasses(ClassSetupInterface form, Set<Class_> classes, boolean editable, int indent, ClassAssignmentProxy proxy, SessionContext context) {
        if (classes != null && classes.size() > 0) {
            ArrayList<Class_> classList = new ArrayList<Class_>(classes);
            Collections.sort(classList, new ClassComparator(3));
            for (Class_ cls : classList) {
                boolean editableClass;
                boolean bl = editableClass = editable && context.hasPermission(cls, Right.MultipleClassSetupClass);
                if (!editableClass) {
                    form.setEditUnlimited(false);
                }
                if (cls.getExpectedCapacity() != null && cls.getMaxExpectedCapacity() != null && !cls.getExpectedCapacity().equals(cls.getMaxExpectedCapacity())) {
                    form.setDisplayOptionForMaxLimit(true);
                    form.setDisplayMaxLimit(true);
                }
                ClassSetupInterface.ClassLine line = this.toLine(cls, proxy, UserProperty.NameFormat.get(context.getUser()));
                line.setEditable(editableClass);
                line.setEditableDatePattern(line.isEditable() && (!ApplicationProperty.WaitListCanChangeDatePattern.isFalse() || cls.getEnrollment() == null || cls.getEnrollment() <= 0 || !cls.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().effectiveReScheduleNow()));
                line.setCanDelete(context.hasPermission(cls, Right.ClassDelete));
                line.setCanCancel(context.hasPermission(cls, Right.ClassCancel));
                line.setIndent(indent);
                if (!form.isHasTimeRooms()) {
                    try {
                        if (proxy.getAssignment(cls) != null) {
                            form.setHasTimeRooms(true);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (!" ".equals(line.getInstructor())) {
                    form.setHasInstructors(true);
                }
                form.addClassLine(line);
                this.loadClasses(form, cls.getChildClasses(), true, indent + 1, proxy, context);
            }
        }
    }

    private ClassSetupInterface.ClassLine toLine(Class_ clazz, ClassAssignmentProxy proxy, String nameFormat) {
        ClassSetupInterface.ClassLine line = new ClassSetupInterface.ClassLine();
        line.setClassId(clazz.getUniqueId());
        line.setSubpartId(clazz.getSchedulingSubpart().getUniqueId());
        line.setIType(clazz.getSchedulingSubpart().getItype().getItype());
        line.setEnrollment(clazz.getEnrollment());
        line.setSnapshotLimit(clazz.getSnapshotLimit());
        line.setMinClassLimit(clazz.getExpectedCapacity());
        line.setMaxClassLimit(clazz.getMaxExpectedCapacity());
        line.setNumberOfRooms(clazz.getNbrRooms());
        line.setDisplayInstructors(clazz.isDisplayInstructor());
        line.setEnabledForStudentScheduling(clazz.isEnabledForStudentScheduling());
        line.setRoomRatio(clazz.getRoomRatio());
        line.setParentId(clazz.getParentClass() == null ? null : clazz.getParentClass().getUniqueId());
        line.setDepartmentId(clazz.getManagingDept() == null ? null : clazz.getManagingDept().getUniqueId());
        line.setDatePatternId(clazz.getDatePattern() == null ? null : clazz.getDatePattern().getUniqueId());
        line.setCancelled(clazz.isCancelled());
        line.setLMS(clazz.getLmsInfo() == null ? -1L : clazz.getLmsInfo().getUniqueId());
        line.setSplitAttendance(clazz.getNbrRooms() > 1 && Boolean.TRUE.equals(clazz.isRoomsSplitAttendance()));
        line.setExternalId(clazz.getClassSuffix() == null ? "" : clazz.getClassSuffix());
        line.setLabel(clazz.htmlLabel());
        String suffix = clazz.getSchedulingSubpart().getSchedulingSubpartSuffix();
        line.setSubpartLabel(clazz.getSchedulingSubpart().getItypeDesc() + (String)(suffix.isEmpty() ? "" : " (" + suffix + ")"));
        line.setTime(clazz.buildAssignedTimeHtml(proxy));
        line.setDate(clazz.buildAssignedDateHtml(proxy));
        ClassAssignmentProxy.AssignmentInfo a = null;
        try {
            a = proxy.getAssignment(clazz);
        }
        catch (Exception e) {
            Debug.error(e);
        }
        if (a != null) {
            for (Location room : a.getRooms()) {
                line.addRoom(room.getUniqueId(), room.getLabel(), room.getCapacity());
            }
        } else if (clazz.getEffectiveTimePreferences().isEmpty()) {
            for (RoomPref rp : clazz.getEffectiveRoomPreferences()) {
                if (!rp.getPrefLevel().getPrefId().toString().equals(PreferenceLevel.PREF_LEVEL_REQUIRED)) continue;
                line.addRoom(rp.getRoom().getUniqueId(), rp.getRoom().getLabel(), rp.getRoom().getCapacity());
            }
        }
        line.setInstructor(clazz.buildInstructorHtml(nameFormat));
        return line;
    }

    protected ClassSetupInterface save(ClassSetupInterface form, SessionContext context) {
        Session hibSession = InstrOfferingConfigDAO.getInstance().getSession();
        Transaction tx = null;
        try {
            InstructionalMethod imeth;
            tx = hibSession.beginTransaction();
            InstrOfferingConfig ioc = (InstrOfferingConfig)InstrOfferingConfigDAO.getInstance().get(form.getConfigId(), hibSession);
            if (form.isUnlimited() != ioc.isUnlimitedEnrollment()) {
                ioc.setUnlimitedEnrollment(form.isUnlimited());
                ioc.setLimit(form.isUnlimited() != false ? 0 : form.getLimit());
                hibSession.merge((Object)ioc);
            } else if (!form.getLimit().equals(ioc.getLimit())) {
                ioc.setLimit(form.getLimit());
                hibSession.merge((Object)ioc);
            }
            InstructionalMethod instructionalMethod = imeth = form.getInstructionalMethodId() == null || form.getInstructionalMethodId() < 0L ? null : (InstructionalMethod)InstructionalMethodDAO.getInstance().get(form.getInstructionalMethodId(), hibSession);
            if (!ToolBox.equals((Object)ioc.getInstructionalMethod(), imeth)) {
                ioc.setInstructionalMethod(imeth);
                hibSession.merge((Object)ioc);
            }
            HashMap<Long, Department> origSubpartManagingDept = new HashMap<Long, Department>();
            for (SchedulingSubpart ss : ioc.getSchedulingSubparts()) {
                origSubpartManagingDept.put(ss.getUniqueId(), ss.getManagingDept());
            }
            this.addOrUpdateClasses(form, ioc, hibSession, context);
            this.modifySubparts(form, ioc, origSubpartManagingDept, hibSession, context);
            String className = ApplicationProperty.ExternalActionInstrOffrConfigChange.value();
            ExternalInstrOffrConfigChangeAction configChangeAction = null;
            if (className != null && className.trim().length() > 0 && !(configChangeAction = (ExternalInstrOffrConfigChangeAction)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0])).validateConfigChangeCanOccur(ioc.getInstructionalOffering(), hibSession)) {
                throw new Exception("Configuration change violates rules for Add On, rolling back the change.");
            }
            ioc.getInstructionalOffering().computeLabels(hibSession);
            ChangeLog.addChange(hibSession, context, ioc, ChangeLog.Source.CLASS_SETUP, ChangeLog.Operation.UPDATE, ioc.getInstructionalOffering().getControllingCourseOffering().getSubjectArea(), null);
            tx.commit();
            if (configChangeAction != null) {
                configChangeAction.performExternalInstrOffrConfigChangeAction(ioc.getInstructionalOffering(), hibSession);
            }
            return null;
        }
        catch (Exception e) {
            Debug.error(e);
            try {
                if (tx != null && tx.isActive()) {
                    tx.rollback();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new GwtRpcException(e.getMessage(), e);
        }
    }

    protected static boolean hasPreference(Preference p, Department currentManagingDept) {
        if (p instanceof RoomPref) {
            Location loc = ((RoomPref)p).getRoom();
            for (RoomDept rd : loc.getRoomDepts()) {
                if (!rd.getDepartment().equals(currentManagingDept)) continue;
                return true;
            }
        } else if (p instanceof BuildingPref) {
            Building b = ((BuildingPref)p).getBuilding();
            for (RoomDept rd : currentManagingDept.getRoomDepts()) {
                if (!(rd.getRoom() instanceof Room) || !((Room)rd.getRoom()).getBuilding().equals(b)) continue;
                return true;
            }
        } else {
            if (p instanceof RoomFeaturePref) {
                RoomFeature rf = ((RoomFeaturePref)p).getRoomFeature();
                return !(rf instanceof DepartmentRoomFeature) || ((DepartmentRoomFeature)rf).getDepartment().equals(currentManagingDept);
            }
            if (p instanceof RoomGroupPref) {
                RoomGroup rg = ((RoomGroupPref)p).getRoomGroup();
                return rg.isGlobal() != false || currentManagingDept.equals(rg.getDepartment());
            }
        }
        return false;
    }

    protected static boolean wouldGetWeakened(Preference p, boolean weaken) {
        if (!weaken) {
            return false;
        }
        return PreferenceLevel.sRequired.equals(p.getPrefLevel().getPrefProlog()) || PreferenceLevel.sProhibited.equals(p.getPrefLevel().getPrefProlog());
    }

    protected void updatePreferences(SchedulingSubpart ss, Department controllingDept, Department origManagingDept, Department currentManagingDept, Session hibSession, SessionContext context) {
        if (ApplicationProperty.ClearPreferencesWhenManagingDepartmentIsChanged.isTrue()) {
            if (!origManagingDept.equals(controllingDept)) {
                for (Class_ c : ss.getClasses()) {
                    boolean classChanged = false;
                    if (!c.getManagingDept().equals(origManagingDept)) continue;
                    Set<TimePattern> timePatterns = c.getTimePatterns();
                    for (TimePref timePref : ss.getTimePreferences()) {
                        if (timePatterns == null || timePatterns.contains(timePref.getTimePattern())) continue;
                        TimePref timePref2 = new TimePref();
                        timePref2.setOwner(c);
                        timePref2.setPrefLevel(PreferenceLevel.getPreferenceLevel(PreferenceLevel.sRequired));
                        timePref2.setTimePattern(timePref.getTimePattern());
                        timePref2.setPreference(timePref.getPreference());
                        c.addToPreferences(timePref2);
                        classChanged = true;
                    }
                    HashSet<Building> buildings = new HashSet<Building>();
                    for (BuildingPref buildingPref : c.getBuildingPreferences()) {
                        buildings.add(buildingPref.getBuilding());
                    }
                    for (BuildingPref buildingPref : ss.getBuildingPreferences()) {
                        if (buildings.contains(buildingPref.getBuilding())) continue;
                        BuildingPref buildingPref2 = new BuildingPref();
                        buildingPref2.setOwner(c);
                        buildingPref2.setPrefLevel(buildingPref.getPrefLevel());
                        buildingPref2.setBuilding(buildingPref.getBuilding());
                        buildingPref2.setDistanceFrom(buildingPref.getDistanceFrom());
                        c.addToPreferences(buildingPref2);
                        classChanged = true;
                    }
                    HashSet<Location> hashSet = new HashSet<Location>();
                    for (RoomPref roomPref : c.getRoomPreferences()) {
                        hashSet.add(roomPref.getRoom());
                    }
                    for (RoomPref roomPref : ss.getRoomPreferences()) {
                        if (hashSet.contains(roomPref.getRoom())) continue;
                        RoomPref roomPref2 = new RoomPref();
                        roomPref2.setOwner(c);
                        roomPref2.setPrefLevel(roomPref.getPrefLevel());
                        roomPref2.setRoom(roomPref.getRoom());
                        c.addToPreferences(roomPref2);
                        classChanged = true;
                    }
                    HashSet<RoomFeature> hashSet2 = new HashSet<RoomFeature>();
                    for (RoomFeaturePref roomFeaturePref : c.getRoomFeaturePreferences()) {
                        hashSet2.add(roomFeaturePref.getRoomFeature());
                    }
                    for (RoomFeaturePref roomFeaturePref : ss.getRoomFeaturePreferences()) {
                        if (hashSet2.contains(roomFeaturePref.getRoomFeature())) continue;
                        RoomFeaturePref roomFeaturePref2 = new RoomFeaturePref();
                        roomFeaturePref2.setOwner(c);
                        roomFeaturePref2.setPrefLevel(roomFeaturePref.getPrefLevel());
                        roomFeaturePref2.setRoomFeature(roomFeaturePref.getRoomFeature());
                        c.addToPreferences(roomFeaturePref2);
                        classChanged = true;
                    }
                    HashSet<RoomGroup> hashSet3 = new HashSet<RoomGroup>();
                    for (RoomGroupPref roomGroupPref : c.getRoomGroupPreferences()) {
                        hashSet3.add(roomGroupPref.getRoomGroup());
                    }
                    for (RoomGroupPref roomGroupPref : ss.getRoomGroupPreferences()) {
                        if (hashSet3.contains(roomGroupPref.getRoomGroup())) continue;
                        RoomGroupPref nrgp = new RoomGroupPref();
                        nrgp.setOwner(c);
                        nrgp.setPrefLevel(roomGroupPref.getPrefLevel());
                        nrgp.setRoomGroup(roomGroupPref.getRoomGroup());
                        c.addToPreferences(nrgp);
                        classChanged = true;
                    }
                    if (!classChanged) continue;
                    hibSession.merge((Object)c);
                }
            }
        } else if (!origManagingDept.equals(controllingDept)) {
            boolean weakenTime = true;
            boolean weakenRoom = true;
            if (!currentManagingDept.isExternalManager().booleanValue()) {
                weakenTime = false;
                weakenRoom = false;
            }
            if (weakenTime && (Boolean.TRUE.equals(currentManagingDept.isAllowReqTime()) || Boolean.TRUE.equals(controllingDept.isAllowReqTime()))) {
                weakenTime = false;
            }
            if (weakenRoom && (Boolean.TRUE.equals(currentManagingDept.isAllowReqRoom()) || Boolean.TRUE.equals(controllingDept.isAllowReqRoom()))) {
                weakenRoom = false;
            }
            for (Class_ c : ss.getClasses()) {
                boolean classChanged = false;
                if (!c.getManagingDept().equals(origManagingDept)) continue;
                Set<TimePattern> set = c.getTimePatterns();
                for (TimePref timePref : ss.getTimePreferences()) {
                    if (InstrOfferingConfigBackend.hasPreference(timePref, currentManagingDept) && !InstrOfferingConfigBackend.toBeWeakened(timePref, weakenRoom) || set == null || set.contains(timePref.getTimePattern())) continue;
                    TimePref timePref3 = new TimePref();
                    timePref3.setOwner(c);
                    timePref3.setPrefLevel(PreferenceLevel.getPreferenceLevel(PreferenceLevel.sRequired));
                    timePref3.setTimePattern(timePref.getTimePattern());
                    timePref3.setPreference(timePref.getPreference());
                    c.addToPreferences(timePref3);
                    classChanged = true;
                }
                HashSet<Building> hashSet = new HashSet<Building>();
                for (BuildingPref buildingPref : c.getBuildingPreferences()) {
                    hashSet.add(buildingPref.getBuilding());
                }
                for (BuildingPref buildingPref : ss.getBuildingPreferences()) {
                    if (InstrOfferingConfigBackend.hasPreference(buildingPref, currentManagingDept) && !InstrOfferingConfigBackend.toBeWeakened(buildingPref, weakenRoom) || hashSet.contains(buildingPref.getBuilding())) continue;
                    BuildingPref buildingPref3 = new BuildingPref();
                    buildingPref3.setOwner(c);
                    buildingPref3.setPrefLevel(buildingPref.getPrefLevel());
                    buildingPref3.setBuilding(buildingPref.getBuilding());
                    buildingPref3.setDistanceFrom(buildingPref.getDistanceFrom());
                    c.addToPreferences(buildingPref3);
                    classChanged = true;
                }
                HashSet<Location> hashSet4 = new HashSet<Location>();
                for (RoomPref roomPref : c.getRoomPreferences()) {
                    hashSet4.add(roomPref.getRoom());
                }
                for (RoomPref roomPref : ss.getRoomPreferences()) {
                    if (InstrOfferingConfigBackend.hasPreference(roomPref, currentManagingDept) && !InstrOfferingConfigBackend.toBeWeakened(roomPref, weakenRoom) || hashSet4.contains(roomPref.getRoom()) || ss.getAvailableRooms().contains(roomPref.getRoom())) continue;
                    RoomPref nrp = new RoomPref();
                    nrp.setOwner(c);
                    nrp.setPrefLevel(roomPref.getPrefLevel());
                    nrp.setRoom(roomPref.getRoom());
                    c.addToPreferences(nrp);
                    classChanged = true;
                }
                HashSet<RoomFeature> hashSet5 = new HashSet<RoomFeature>();
                for (RoomFeaturePref rfp : c.getRoomFeaturePreferences()) {
                    hashSet5.add(rfp.getRoomFeature());
                }
                for (RoomFeaturePref rfp : ss.getRoomFeaturePreferences()) {
                    if (InstrOfferingConfigBackend.hasPreference(rfp, currentManagingDept) && !InstrOfferingConfigBackend.toBeWeakened(rfp, weakenRoom) || hashSet5.contains(rfp.getRoomFeature()) || ss.getAvailableRoomFeatures().contains(rfp.getRoomFeature())) continue;
                    RoomFeaturePref nrfp = new RoomFeaturePref();
                    nrfp.setOwner(c);
                    nrfp.setPrefLevel(rfp.getPrefLevel());
                    nrfp.setRoomFeature(rfp.getRoomFeature());
                    c.addToPreferences(nrfp);
                    classChanged = true;
                }
                HashSet<RoomGroup> hashSet6 = new HashSet<RoomGroup>();
                for (RoomGroupPref rgp : c.getRoomGroupPreferences()) {
                    hashSet6.add(rgp.getRoomGroup());
                }
                for (RoomGroupPref rgp : ss.getRoomGroupPreferences()) {
                    if (InstrOfferingConfigBackend.hasPreference(rgp, currentManagingDept) && !InstrOfferingConfigBackend.toBeWeakened(rgp, weakenRoom) || hashSet6.contains(rgp.getRoomGroup()) || ss.getAvailableRoomGroups().contains(rgp.getRoomGroup())) continue;
                    RoomGroupPref nrgp = new RoomGroupPref();
                    nrgp.setOwner(c);
                    nrgp.setPrefLevel(rgp.getPrefLevel());
                    nrgp.setRoomGroup(rgp.getRoomGroup());
                    c.addToPreferences(nrgp);
                    classChanged = true;
                }
                if (!classChanged) continue;
                hibSession.merge((Object)c);
            }
        }
        InstrOfferingConfigBackend.updatePreferences(ss, controllingDept, currentManagingDept, hibSession, context);
    }

    private void addOrUpdateClasses(ClassSetupInterface form, InstrOfferingConfig ioc, Session hibSession, SessionContext context) {
        HashMap<Long, Class_> tmpClsToRealClass = new HashMap<Long, Class_>();
        HashMap<Long, Class_> deleteClasses = new HashMap<Long, Class_>();
        for (SchedulingSubpart ss : ioc.getSchedulingSubparts()) {
            for (Class_ c : ss.getClasses()) {
                deleteClasses.put(c.getUniqueId(), c);
            }
        }
        Date timeStamp = new Date();
        for (ClassSetupInterface.ClassLine cl : form.getClassLines()) {
            Long datePatternId;
            Long classId = cl.getClassId();
            Long subpartId = cl.getSubpartId();
            Long parentClassId = cl.getParentId();
            Integer minClassLimit = cl.getMinClassLimit();
            Long managingDeptId = cl.getDepartmentId();
            if (managingDeptId != null && managingDeptId < 0L) {
                managingDeptId = null;
            }
            if ((datePatternId = cl.getDatePatternId()) != null && datePatternId < 0L) {
                datePatternId = null;
            }
            Integer numberOfRooms = cl.getNumberOfRooms();
            Integer maxClassLimit = cl.getMaxClassLimit();
            Float roomRatio = cl.getRoomRatio();
            if (form.isUnlimited().booleanValue()) {
                roomRatio = Float.valueOf(1.0f);
                minClassLimit = 0;
                maxClassLimit = 0;
                numberOfRooms = 0;
            }
            Boolean displayInstructor = cl.getDisplayInstructors();
            Boolean enabledForStudentScheduling = cl.getEnabledForStudentScheduling();
            String suffix = cl.getExternalId();
            if (suffix != null && suffix.isEmpty()) {
                suffix = null;
            }
            Integer snapshotLimit = cl.getSnapshotLimit();
            Long lmsId = cl.getLMS();
            if (lmsId != null && lmsId < 0L) {
                lmsId = null;
            }
            Boolean splitAttendance = cl.getSplitAttendance();
            Boolean cancelled = cl.getCancelled();
            if (classId <= 0L) {
                Class_ newClass = new Class_();
                SchedulingSubpart ss = (SchedulingSubpart)SchedulingSubpartDAO.getInstance().get(subpartId, hibSession);
                newClass.setSchedulingSubpart(ss);
                ss.addToClasses(newClass);
                if (parentClassId != null) {
                    Class_ parentClass = parentClassId > 0L ? (Class_)Class_DAO.getInstance().get(parentClassId, hibSession) : (Class_)tmpClsToRealClass.get(parentClassId);
                    newClass.setParentClass(parentClass);
                    parentClass.addToChildClasses(newClass);
                }
                newClass.setControllingDept(ss.getControllingDept());
                if (managingDeptId != null) {
                    newClass.setManagingDept((Department)DepartmentDAO.getInstance().get(managingDeptId, hibSession), context.getUser(), hibSession);
                }
                if (datePatternId != null) {
                    newClass.setDatePattern((DatePattern)DatePatternDAO.getInstance().get(datePatternId, hibSession));
                }
                newClass.setExpectedCapacity(minClassLimit);
                newClass.setNbrRooms(numberOfRooms);
                newClass.setMaxExpectedCapacity(maxClassLimit);
                newClass.setRoomRatio(roomRatio);
                newClass.setDisplayInstructor(displayInstructor);
                newClass.setEnabledForStudentScheduling(enabledForStudentScheduling);
                newClass.setClassSuffix(suffix);
                newClass.setSnapshotLimit(snapshotLimit);
                newClass.setSnapshotLimitDate(timeStamp);
                newClass.setCancelled(false);
                if (lmsId != null) {
                    newClass.setLmsInfo((LearningManagementSystemInfo)LearningManagementSystemInfoDAO.getInstance().get(lmsId, hibSession));
                }
                newClass.setRoomsSplitAttendance(splitAttendance);
                hibSession.persist((Object)newClass);
                hibSession.merge((Object)ss);
                tmpClsToRealClass.put(classId, newClass);
                continue;
            }
            boolean changed = false;
            Class_ modifiedClass = (Class_)deleteClasses.remove(classId);
            if (modifiedClass.getParentClass() != null && parentClassId != null && !modifiedClass.getParentClass().getUniqueId().equals(parentClassId)) {
                Class_ origParent = modifiedClass.getParentClass();
                if (parentClassId < 0L) {
                    modifiedClass.setParentClass((Class_)tmpClsToRealClass.get(parentClassId));
                } else {
                    modifiedClass.setParentClass((Class_)Class_DAO.getInstance().get(parentClassId, hibSession));
                }
                origParent.getChildClasses().remove(modifiedClass);
                modifiedClass.getParentClass().addToChildClasses(modifiedClass);
                hibSession.merge((Object)modifiedClass.getParentClass());
                hibSession.merge((Object)origParent);
            }
            if (managingDeptId == null) {
                managingDeptId = modifiedClass.getControllingDept().getUniqueId();
            }
            if (!modifiedClass.getManagingDept().getUniqueId().equals(managingDeptId)) {
                changed = true;
                Department managingDept = (Department)DepartmentDAO.getInstance().get(managingDeptId, hibSession);
                modifiedClass.setManagingDept(managingDept, context.getUser(), hibSession);
                InstrOfferingConfigBackend.updatePreferences(modifiedClass, managingDept, modifiedClass.getControllingDept(), hibSession, context);
            }
            if (!ToolBox.equals((Object)(modifiedClass.getDatePattern() == null ? null : modifiedClass.getDatePattern().getUniqueId()), (Object)datePatternId)) {
                changed = true;
                modifiedClass.setDatePattern(datePatternId == null ? null : (DatePattern)DatePatternDAO.getInstance().get(datePatternId, hibSession));
            }
            if (!ToolBox.equals((Object)(modifiedClass.getLmsInfo() == null ? null : modifiedClass.getLmsInfo().getUniqueId()), (Object)lmsId)) {
                changed = true;
                modifiedClass.setLms(lmsId == null ? null : (LearningManagementSystemInfo)LearningManagementSystemInfoDAO.getInstance().get(lmsId, hibSession));
            }
            if (!modifiedClass.getExpectedCapacity().equals(minClassLimit)) {
                changed = true;
                modifiedClass.setExpectedCapacity(minClassLimit);
            }
            if (!modifiedClass.getNbrRooms().equals(numberOfRooms)) {
                changed = true;
                modifiedClass.setNbrRooms(numberOfRooms);
            }
            if (!modifiedClass.getMaxExpectedCapacity().equals(maxClassLimit)) {
                changed = true;
                modifiedClass.setMaxExpectedCapacity(maxClassLimit);
            }
            if (!modifiedClass.getRoomRatio().equals(roomRatio)) {
                changed = true;
                modifiedClass.setRoomRatio(roomRatio);
            }
            if (form.isDisplayInstructors() && !modifiedClass.isDisplayInstructor().equals(displayInstructor)) {
                changed = true;
                modifiedClass.setDisplayInstructor(displayInstructor);
            }
            if (form.isDisplayEnabledForStudentScheduling() && !modifiedClass.isEnabledForStudentScheduling().equals(enabledForStudentScheduling)) {
                changed = true;
                modifiedClass.setEnabledForStudentScheduling(enabledForStudentScheduling);
            }
            if (form.isEditExternalId() && (suffix == null ? modifiedClass.getClassSuffix() != null : !suffix.equals(modifiedClass.getClassSuffix()))) {
                modifiedClass.setClassSuffix(suffix);
                changed = true;
            }
            if (form.isEditSnapshotLimits() && (snapshotLimit == null ? modifiedClass.getSnapshotLimit() != null : !snapshotLimit.equals(modifiedClass.getSnapshotLimit()))) {
                modifiedClass.setSnapshotLimit(snapshotLimit);
                modifiedClass.setSnapshotLimitDate(timeStamp);
                changed = true;
            }
            if (!modifiedClass.isCancelled().equals(cancelled)) {
                modifiedClass.setCancelled(cancelled);
                modifiedClass.cancelEvent(context.getUser(), hibSession, cancelled);
                changed = true;
            }
            if (modifiedClass.isRoomsSplitAttendance() == null || !modifiedClass.isRoomsSplitAttendance().equals(splitAttendance)) {
                modifiedClass.setRoomsSplitAttendance(splitAttendance);
                changed = true;
            }
            if (!changed) continue;
            hibSession.merge((Object)modifiedClass);
        }
        for (Class_ c : deleteClasses.values()) {
            if (c.getParentClass() != null && !deleteClasses.containsKey(c.getParentClass().getUniqueId())) {
                Class_ parent = c.getParentClass();
                parent.getChildClasses().remove(c);
                hibSession.merge((Object)parent);
            }
            if (c.getPreferences() != null) {
                c.getPreferences().removeAll(c.getPreferences());
            }
            c.deleteAllDependentObjects(hibSession, false);
            c.getSchedulingSubpart().getClasses().remove(c);
            hibSession.remove((Object)c);
        }
    }

    private void modifySubparts(ClassSetupInterface form, InstrOfferingConfig ioc, Map<Long, Department> origSubpartManagingDept, Session hibSession, SessionContext context) {
        for (SchedulingSubpart ss : ioc.getSchedulingSubparts()) {
            Department controllingDept = ss.getControllingDept();
            Department currentManagingDept = ss.getManagingDept();
            Department origManagingDept = origSubpartManagingDept.get(ss.getUniqueId());
            if (origManagingDept == null || currentManagingDept.equals(origManagingDept)) continue;
            this.updatePreferences(ss, controllingDept, origManagingDept, currentManagingDept, hibSession, context);
        }
    }
}

