/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.courses;

import java.util.List;
import java.util.TreeSet;
import org.unitime.commons.Debug;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.client.tables.TableInterface;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.LearningManagementSystemInfo;
import org.unitime.timetable.model.PreferenceGroup;
import org.unitime.timetable.model.base.BaseSubjectArea;
import org.unitime.timetable.model.comparators.InstructorComparator;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.courses.ClassesTableBuilder;
import org.unitime.timetable.solver.CachedClassAssignmentProxy;
import org.unitime.timetable.solver.ClassAssignmentProxy;
import org.unitime.timetable.solver.exam.ExamAssignmentProxy;
import org.unitime.timetable.webutil.Navigation;

public class ClassAssignmentsTableBuilder
extends ClassesTableBuilder {
    @Override
    public String additionalNote() {
        return " " + MSG.classAssignmentsAdditionalNote();
    }

    public void generateTableForClassAssignments(SessionContext context, ClassAssignmentProxy classAssignment, ExamAssignmentProxy examAssignment, TableInterface.FilterInterface filter, String[] subjectAreaIds, boolean displayHeader, List<TableInterface> tables, String backType, String backId) {
        this.disabledColor = "inherit";
        this.setBackType(backType);
        this.setBackId(backId);
        this.setShowLabel(true);
        this.setShowDivSec(true);
        this.setShowDemand(false);
        this.setShowProjectedDemand(false);
        this.setShowMinPerWk(false);
        this.setShowLimit(true);
        this.setShowSnapshotLimit(false);
        this.setShowRoomRatio(false);
        this.setShowFundingDepartment(false);
        this.setShowManager(false);
        this.setShowDatePattern(true);
        this.setShowTimePattern(false);
        this.setShowPreferences(false);
        this.setShowInstructor(true);
        this.setShowTimetable(true);
        this.setShowCredit(false);
        this.setShowSubpartCredit(false);
        this.setShowSchedulePrintNote(true);
        this.setShowNote(false);
        this.setShowTitle(false);
        this.setShowConsent(false);
        this.setShowExam(false);
        this.setShowInstructorAssignment(false);
        this.setShowLms(false);
        this.setShowWaitlistMode(false);
        TreeSet classes = ClassAssignmentsTableBuilder.getClasses(filter, subjectAreaIds, classAssignment);
        Navigation.set(context, Navigation.sClassLevel, classes);
        if (this.isShowTimetable()) {
            boolean hasTimetable = false;
            if (context.hasPermission(Right.ClassAssignments) && classAssignment != null) {
                try {
                    if (classAssignment instanceof CachedClassAssignmentProxy) {
                        ((CachedClassAssignmentProxy)classAssignment).setCache(classes);
                    }
                    for (Object[] o : classes) {
                        Class_ clazz = (Class_)o[0];
                        if (classAssignment.getAssignment(clazz) == null) continue;
                        hasTimetable = true;
                        break;
                    }
                }
                catch (Exception i) {
                    // empty catch block
                }
            }
            this.setDisplayTimetable(hasTimetable);
        }
        this.setUserSettings(context.getUser());
        if (examAssignment != null || Exam.hasTimetable(context.getUser().getCurrentAcademicSessionId())) {
            this.setShowExam(true);
            this.setShowExamTimetable(true);
            this.setShowExamName(false);
        }
        if (this.sessionHasEnrollments(context.getUser().getCurrentAcademicSessionId())) {
            this.setShowDemand(true);
        }
        if (LearningManagementSystemInfo.isLmsInfoDefinedForSession(context.getUser().getCurrentAcademicSessionId())) {
            this.setShowLms(true);
        }
        TableInterface table = null;
        BaseSubjectArea subjectArea = null;
        String prevLabel = null;
        int ct = 0;
        for (Object o : classes) {
            Class_ c = (Class_)((Object[])o)[0];
            CourseOffering co = (CourseOffering)((Object[])o)[1];
            if (subjectArea == null || !subjectArea.getUniqueId().equals(co.getSubjectArea().getUniqueId())) {
                subjectArea = co.getSubjectArea();
                table = this.initTable(context.getUser().getCurrentAcademicSessionId());
                table.setName(subjectArea.getSubjectAreaAbbreviation() + " - " + subjectArea.getSession().getLabel() + this.additionalNote());
                tables.add(table);
                ct = 0;
            }
            this.buildClassRow(classAssignment, examAssignment, ++ct, table, co, c, 0, context, prevLabel);
            prevLabel = c.getClassLabel(co);
        }
    }

    @Override
    protected TableInterface.CellInterface buildDatePatternCell(ClassAssignmentProxy classAssignment, PreferenceGroup prefGroup, boolean isEditable) {
        ClassAssignmentProxy.AssignmentInfo a = null;
        if (this.getDisplayTimetable() && this.isShowTimetable() && classAssignment != null && prefGroup instanceof Class_) {
            try {
                a = classAssignment.getAssignment((Class_)prefGroup);
            }
            catch (Exception e) {
                Debug.error(e);
            }
        }
        DatePattern dp = a != null ? a.getDatePattern() : prefGroup.effectiveDatePattern();
        TableInterface.CellInterface cell = null;
        if (dp == null) {
            cell = this.initNormalCell("", isEditable);
        } else {
            cell = this.initNormalCell(dp.getName(), isEditable);
            cell.setTitle(sDateFormat.format(dp.getStartDate()) + " - " + sDateFormat.format(dp.getEndDate()));
        }
        cell.setTextAlignment(TableInterface.CellInterface.Alignment.CENTER);
        return cell;
    }

    @Override
    protected TableInterface.CellInterface buildInstructor(PreferenceGroup prefGroup, boolean isEditable) {
        Class_ aClass;
        super.buildInstructor(prefGroup, isEditable);
        TableInterface.CellInterface cell = this.initNormalCell(null, isEditable);
        if (prefGroup instanceof Class_ && (aClass = (Class_)prefGroup).isDisplayInstructor().booleanValue() && !aClass.getClassInstructors().isEmpty()) {
            InstructorComparator ic = new InstructorComparator();
            if (ApplicationProperty.InstructorsDropdownFollowNameFormatting.isTrue()) {
                ic.setNameFormat(this.getInstructorNameFormat());
            }
            TreeSet<ClassInstructor> sortedInstructors = new TreeSet<ClassInstructor>(ic);
            sortedInstructors.addAll(aClass.getClassInstructors());
            for (ClassInstructor ci : sortedInstructors) {
                TableInterface.CellInterface c = cell.add(ci.getInstructor().getName(this.getInstructorNameFormat()));
                c.setInline(false);
                c.setTitle(ci.getInstructor().getNameLastFirst() + " (" + (String)(ci.getResponsibility() == null ? "" : ci.getResponsibility().getLabel() + " ") + ci.getPercentShare() + "%" + (String)(ci.isLead() != false ? ", " + MSG.toolTipInstructorLead() : "") + ")");
            }
        }
        return cell.setTextAlignment(TableInterface.CellInterface.Alignment.LEFT);
    }
}

