/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.courses;

import org.springframework.beans.factory.annotation.Autowired;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.gwt.client.offerings.OfferingsInterface;
import org.unitime.timetable.gwt.client.tables.TableInterface;
import org.unitime.timetable.gwt.command.client.GwtRpcException;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseList;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.shared.FilterInterface;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.dao.SubjectAreaDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.courses.ClassAssignmentsTableBuilder;
import org.unitime.timetable.solver.ClassAssignmentProxy;
import org.unitime.timetable.solver.exam.ExamSolverProxy;
import org.unitime.timetable.solver.service.AssignmentService;
import org.unitime.timetable.solver.service.SolverService;
import org.unitime.timetable.webutil.BackTracker;

@GwtRpcImplements(value=OfferingsInterface.ClassAssignmentsRequest.class)
public class ClassAssignmentsBackend
implements GwtRpcImplementation<OfferingsInterface.ClassAssignmentsRequest, GwtRpcResponseList<TableInterface>> {
    protected static CourseMessages MESSAGES = Localization.create(CourseMessages.class);
    @Autowired
    AssignmentService<ClassAssignmentProxy> classAssignmentService;
    @Autowired
    SolverService<ExamSolverProxy> examinationSolverService;

    @Override
    public GwtRpcResponseList<TableInterface> execute(OfferingsInterface.ClassAssignmentsRequest request, SessionContext context) {
        context.checkPermission(Right.ClassAssignments);
        String subjectArea = request.getFilter().getParameterValue("subjectArea");
        if (subjectArea == null || subjectArea.isEmpty()) {
            throw new GwtRpcException(MESSAGES.errorSubjectRequired());
        }
        GwtRpcResponseList<TableInterface> response = new GwtRpcResponseList<TableInterface>();
        ClassAssignmentsTableBuilder builder = new ClassAssignmentsTableBuilder();
        for (FilterInterface.FilterParameterInterface p : request.getFilter().getParameters()) {
            if ("subjectArea".equals(p.getName())) {
                context.setAttribute(SessionAttribute.ClassAssignmentsSubjectAreas, (Object)(p.getValue() != null ? p.getValue() : p.getDefaultValue()));
                continue;
            }
            if (p.getValue() == null) continue;
            context.getUser().setProperty("ClassAssignments." + p.getName(), p.getValue());
        }
        try {
            Object subjects = "";
            int count = 0;
            for (String id : subjectArea.split(",")) {
                SubjectArea sa = (SubjectArea)SubjectAreaDAO.getInstance().get(Long.valueOf(id));
                if (sa == null) continue;
                if (++count == 1) {
                    subjects = (String)subjects + sa.getSubjectAreaAbbreviation();
                    continue;
                }
                if (count <= 3) {
                    subjects = (String)subjects + ", " + sa.getSubjectAreaAbbreviation();
                    continue;
                }
                if (count != 4) continue;
                subjects = (String)subjects + "\u2026";
            }
            BackTracker.markForBack(context, "gwt.jsp?page=classAssignments&subjectArea=" + request.getFilter().getParameterValue("subjectArea"), MESSAGES.backClassAssignments((String)subjects), true, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        builder.generateTableForClassAssignments(context, this.classAssignmentService.getAssignment(), this.examinationSolverService.getSolver(), request.getFilter(), subjectArea.split(","), true, response, request.getBackType(), request.getBackId());
        if (response.isEmpty()) {
            throw new GwtRpcException(MESSAGES.errorNoRecords());
        }
        return response;
    }
}

