/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.admin;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.cpsolver.ifs.util.ToolBox;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.SimpleEditInterface;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.CourseType;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.StudentSectioningStatus;
import org.unitime.timetable.model.dao.CourseTypeDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.model.dao.StudentSectioningStatusDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.admin.AdminTable;
import org.unitime.timetable.util.Formats;

@Service(value="gwtAdminTable[type=sectioning]")
public class StudentSchedulingStatusTypes
implements AdminTable {
    protected static final GwtMessages MESSAGES = Localization.create(GwtMessages.class);

    @Override
    public SimpleEditInterface.PageName name() {
        return new SimpleEditInterface.PageName(MESSAGES.pageStudentSchedulingStatusType(), MESSAGES.pageStudentSchedulingStatusTypes());
    }

    @Override
    @PreAuthorize(value="checkPermission('StudentSchedulingStatusTypes')")
    public SimpleEditInterface load(SessionContext context, org.hibernate.Session hibSession) {
        List courseTypes = CourseTypeDAO.getInstance().getSession().createQuery("from CourseType order by reference", CourseType.class).setCacheable(true).list();
        SimpleEditInterface.Field[] fields = new SimpleEditInterface.Field[courseTypes.isEmpty() ? 10 + StatusOption.values().length : 11 + StatusOption.values().length];
        int idx = 0;
        fields[idx++] = new SimpleEditInterface.Field(MESSAGES.fieldAbbreviation(), SimpleEditInterface.FieldType.text, 160, 20, SimpleEditInterface.Flag.UNIQUE);
        fields[idx++] = new SimpleEditInterface.Field(MESSAGES.fieldName(), SimpleEditInterface.FieldType.text, 300, 60, SimpleEditInterface.Flag.UNIQUE);
        for (StatusOption t : StatusOption.values()) {
            fields[idx++] = new SimpleEditInterface.Field(t.getLabel(), SimpleEditInterface.FieldType.toggle, 40, new SimpleEditInterface.Flag[0]);
        }
        fields[idx++] = new SimpleEditInterface.Field(MESSAGES.fieldMessage(), SimpleEditInterface.FieldType.textarea, 40, 500, new SimpleEditInterface.Flag[0]);
        ArrayList<SimpleEditInterface.ListItem> notifications = new ArrayList<SimpleEditInterface.ListItem>();
        for (StudentSectioningStatus.NotificationType t : StudentSectioningStatus.NotificationType.values()) {
            notifications.add(new SimpleEditInterface.ListItem(t.name(), t.label()));
        }
        fields[idx++] = new SimpleEditInterface.Field(MESSAGES.fieldNotifications(), SimpleEditInterface.FieldType.multi, 200, notifications, new SimpleEditInterface.Flag[0]);
        if (!courseTypes.isEmpty()) {
            ArrayList<SimpleEditInterface.ListItem> courseTypeItems = new ArrayList<SimpleEditInterface.ListItem>();
            courseTypeItems.add(new SimpleEditInterface.ListItem("-", MESSAGES.toggleNoCourseType()));
            for (CourseType type : courseTypes) {
                courseTypeItems.add(new SimpleEditInterface.ListItem(type.getUniqueId().toString(), type.getReference()));
            }
            fields[idx++] = new SimpleEditInterface.Field(MESSAGES.fieldCourseTypes(), SimpleEditInterface.FieldType.multi, 100, courseTypeItems, new SimpleEditInterface.Flag[0]);
        }
        ArrayList<SimpleEditInterface.ListItem> fallbacks = new ArrayList<SimpleEditInterface.ListItem>();
        List<StudentSectioningStatus> statuses = StudentSectioningStatus.findAll(context.getUser().getCurrentAcademicSessionId());
        fallbacks.add(new SimpleEditInterface.ListItem("", ""));
        for (StudentSectioningStatus status : statuses) {
            fallbacks.add(new SimpleEditInterface.ListItem(status.getUniqueId().toString(), status.getLabel()));
        }
        fields[idx++] = new SimpleEditInterface.Field(MESSAGES.fieldStudentStatusEffectiveStartDate(), SimpleEditInterface.FieldType.date, 80, new SimpleEditInterface.Flag[0]);
        fields[idx++] = new SimpleEditInterface.Field(MESSAGES.fieldStudentStatusEffectiveStartTime(), SimpleEditInterface.FieldType.time, 50, new SimpleEditInterface.Flag[0]);
        fields[idx++] = new SimpleEditInterface.Field(MESSAGES.fieldStudentStatusEffectiveEndDate(), SimpleEditInterface.FieldType.date, 80, new SimpleEditInterface.Flag[0]);
        fields[idx++] = new SimpleEditInterface.Field(MESSAGES.fieldStudentStatusEffectiveEndTime(), SimpleEditInterface.FieldType.time, 50, new SimpleEditInterface.Flag[0]);
        fields[idx++] = new SimpleEditInterface.Field(MESSAGES.fieldStudentStatusFallback(), SimpleEditInterface.FieldType.list, 100, fallbacks, SimpleEditInterface.Flag.NO_CYCLE);
        fields[idx++] = new SimpleEditInterface.Field(MESSAGES.fieldSession(), SimpleEditInterface.FieldType.toggle, 40, new SimpleEditInterface.Flag[0]);
        SimpleEditInterface data = new SimpleEditInterface(fields);
        data.setSortBy(0, 1);
        Formats.Format<Date> dateFormat = Formats.getDateFormat(Formats.Pattern.DATE_EVENT);
        for (StudentSectioningStatus status : statuses) {
            SimpleEditInterface.Record r = data.addRecord(status.getUniqueId());
            idx = 0;
            r.setField(idx++, status.getReference());
            r.setField(idx++, status.getLabel());
            for (StatusOption statusOption : StatusOption.values()) {
                r.setField(idx++, status.hasOption(statusOption.getOption()) ? "true" : "false");
            }
            r.setField(idx++, status.getMessage());
            for (Enum enum_ : StudentSectioningStatus.NotificationType.values()) {
                if (!status.hasNotification(new StudentSectioningStatus.NotificationType[]{enum_})) continue;
                r.addToField(idx, enum_.name());
            }
            ++idx;
            if (!courseTypes.isEmpty()) {
                for (CourseType type : courseTypes) {
                    if (!status.getTypes().contains(type)) continue;
                    r.addToField(idx, type.getUniqueId().toString());
                }
                if (!status.hasOption(StudentSectioningStatus.Option.notype)) {
                    r.addToField(idx, "-");
                }
            }
            int n = ++idx;
            ++idx;
            r.setField(n, status.getEffectiveStartDate() == null ? "" : dateFormat.format(status.getEffectiveStartDate()));
            r.setField(idx++, status.getEffectiveStartPeriod() == null ? "" : status.getEffectiveStartPeriod().toString());
            r.setField(idx++, status.getEffectiveStopDate() == null ? "" : dateFormat.format(status.getEffectiveStopDate()));
            r.setField(idx++, status.getEffectiveStopPeriod() == null ? "" : status.getEffectiveStopPeriod().toString());
            r.setField(idx++, status.getFallBackStatus() == null ? "" : status.getFallBackStatus().getUniqueId().toString());
            r.setField(idx++, status.getSession() == null ? "false" : "true");
        }
        data.setEditable(context.hasPermission(Right.StudentSchedulingStatusTypeEdit));
        return data;
    }

    @Override
    @PreAuthorize(value="checkPermission('StudentSchedulingStatusTypeEdit')")
    public void save(SimpleEditInterface data, SessionContext context, org.hibernate.Session hibSession) {
        for (StudentSectioningStatus status : StudentSectioningStatus.findAll(context.getUser().getCurrentAcademicSessionId())) {
            SimpleEditInterface.Record r = data.getRecord(status.getUniqueId());
            if (r == null) {
                this.delete(status, context, hibSession);
                continue;
            }
            this.update(status, r, context, hibSession);
        }
        for (SimpleEditInterface.Record r : data.getNewRecords()) {
            this.save(r, context, hibSession);
        }
    }

    @Override
    @PreAuthorize(value="checkPermission('StudentSchedulingStatusTypeEdit')")
    public void save(SimpleEditInterface.Record record, SessionContext context, org.hibernate.Session hibSession) {
        StudentSectioningStatus status = new StudentSectioningStatus();
        int value = 0;
        for (int i = 0; i < StatusOption.values().length; ++i) {
            if (!"true".equals(record.getField(2 + i))) continue;
            value += StatusOption.values()[i].getOption().toggle();
        }
        status.setTypes(new HashSet<CourseType>());
        List courseTypes = CourseTypeDAO.getInstance().getSession().createQuery("from CourseType order by reference", CourseType.class).setCacheable(true).list();
        status.setReference(record.getField(0));
        status.setLabel(record.getField(1));
        status.setStatus(value);
        status.setMessage(record.getField(2 + StatusOption.values().length));
        int notification = 0;
        for (String option : record.getValues(3 + StatusOption.values().length)) {
            notification += StudentSectioningStatus.NotificationType.valueOf(option).toggle();
        }
        status.setNotifications(notification);
        int idx = 4 + StatusOption.values().length;
        status.setTypes(new HashSet<CourseType>());
        if (!courseTypes.isEmpty()) {
            boolean other = false;
            for (String option : record.getValues(idx)) {
                if ("-".equals(option)) {
                    other = true;
                    continue;
                }
                status.getTypes().add((CourseType)CourseTypeDAO.getInstance().get(Long.valueOf(option)));
            }
            if (!other) {
                value += StudentSectioningStatus.Option.notype.toggle();
            }
            ++idx;
        }
        Formats.Format<Date> dateFormat = Formats.getDateFormat(Formats.Pattern.DATE_EVENT);
        Date startDate = null;
        try {
            startDate = record.getField(idx) == null || record.getField(idx).isEmpty() ? null : dateFormat.parse(record.getField(idx));
            ++idx;
        }
        catch (ParseException option) {
            // empty catch block
        }
        Integer startTime = record.getField(idx) == null || record.getField(idx).isEmpty() ? null : Integer.valueOf(record.getField(idx));
        ++idx;
        Date endDate = null;
        try {
            endDate = record.getField(idx) == null || record.getField(idx).isEmpty() ? null : dateFormat.parse(record.getField(idx));
            ++idx;
        }
        catch (ParseException option) {
            // empty catch block
        }
        Integer endTime = record.getField(idx) == null || record.getField(idx).isEmpty() ? null : Integer.valueOf(record.getField(idx));
        Long fallBackId = record.getField(++idx) == null || record.getField(idx).isEmpty() ? null : Long.valueOf(record.getField(idx));
        boolean session = "true".equals(record.getField(++idx));
        ++idx;
        status.setEffectiveStartDate(startDate);
        status.setEffectiveStartPeriod(startTime);
        status.setEffectiveStopDate(endDate);
        status.setEffectiveStopPeriod(endTime);
        status.setFallBackStatus(fallBackId == null ? null : (StudentSectioningStatus)StudentSectioningStatusDAO.getInstance().get(fallBackId, hibSession));
        status.setSession(session ? (Session)SessionDAO.getInstance().get(context.getUser().getCurrentAcademicSessionId()) : null);
        hibSession.persist((Object)status);
        record.setUniqueId(status.getUniqueId());
        ChangeLog.addChange(hibSession, context, status, status.getReference() + " " + status.getLabel() + (String)(status.getSession() == null ? " (global)" : " (" + status.getSession().getLabel() + ")"), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.CREATE, null, null);
    }

    protected void update(StudentSectioningStatus status, SimpleEditInterface.Record record, SessionContext context, org.hibernate.Session hibSession) {
        if (status == null) {
            return;
        }
        int value = 0;
        for (int i = 0; i < StatusOption.values().length; ++i) {
            if (!"true".equals(record.getField(2 + i))) continue;
            value += StatusOption.values()[i].getOption().toggle();
        }
        HashSet<CourseType> types = new HashSet<CourseType>();
        List courseTypes = CourseTypeDAO.getInstance().getSession().createQuery("from CourseType order by reference", CourseType.class).setCacheable(true).list();
        int notification = 0;
        for (String option : record.getValues(3 + StatusOption.values().length)) {
            notification += StudentSectioningStatus.NotificationType.valueOf(option).toggle();
        }
        int idx = 4 + StatusOption.values().length;
        if (!courseTypes.isEmpty()) {
            boolean other = false;
            for (String option : record.getValues(idx)) {
                if ("-".equals(option)) {
                    other = true;
                    continue;
                }
                types.add((CourseType)CourseTypeDAO.getInstance().get(Long.valueOf(option)));
            }
            if (!other) {
                value += StudentSectioningStatus.Option.notype.toggle();
            }
            ++idx;
        }
        Formats.Format<Date> dateFormat = Formats.getDateFormat(Formats.Pattern.DATE_EVENT);
        Date startDate = null;
        try {
            startDate = record.getField(idx) == null || record.getField(idx).isEmpty() ? null : dateFormat.parse(record.getField(idx));
            ++idx;
        }
        catch (ParseException option) {
            // empty catch block
        }
        Integer startTime = record.getField(idx) == null || record.getField(idx).isEmpty() ? null : Integer.valueOf(record.getField(idx));
        ++idx;
        Date endDate = null;
        try {
            endDate = record.getField(idx) == null || record.getField(idx).isEmpty() ? null : dateFormat.parse(record.getField(idx));
            ++idx;
        }
        catch (ParseException option) {
            // empty catch block
        }
        Integer endTime = record.getField(idx) == null || record.getField(idx).isEmpty() ? null : Integer.valueOf(record.getField(idx));
        Long fallBackId = record.getField(++idx) == null || record.getField(idx).isEmpty() ? null : Long.valueOf(record.getField(idx));
        boolean session = "true".equals(record.getField(++idx));
        ++idx;
        boolean changed = !ToolBox.equals((Object)status.getReference(), (Object)record.getField(0)) || !ToolBox.equals((Object)status.getLabel(), (Object)record.getField(1)) || !ToolBox.equals((Object)status.getStatus(), (Object)value) || !ToolBox.equals(status.getTypes(), types) || !ToolBox.equals((Object)status.getMessage(), (Object)record.getField(2 + StatusOption.values().length)) || !ToolBox.equals((Object)status.getEffectiveStartDate(), (Object)startDate) || !ToolBox.equals((Object)status.getEffectiveStartPeriod(), (Object)startTime) || !ToolBox.equals((Object)status.getEffectiveStopDate(), (Object)endDate) || !ToolBox.equals((Object)status.getEffectiveStopPeriod(), (Object)endTime) || !ToolBox.equals((Object)(status.getFallBackStatus() == null ? null : status.getFallBackStatus().getUniqueId()), (Object)fallBackId) || !ToolBox.equals((Object)status.getNotifications(), (Object)notification) || session && status.getSession() == null || !session && status.getSession() != null;
        status.setReference(record.getField(0));
        status.setLabel(record.getField(1));
        status.setStatus(value);
        status.setTypes(types);
        status.setMessage(record.getField(2 + StatusOption.values().length));
        status.setEffectiveStartDate(startDate);
        status.setEffectiveStartPeriod(startTime);
        status.setEffectiveStopDate(endDate);
        status.setEffectiveStopPeriod(endTime);
        status.setFallBackStatus(fallBackId == null ? null : (StudentSectioningStatus)StudentSectioningStatusDAO.getInstance().get(fallBackId, hibSession));
        status.setSession(session ? (Session)SessionDAO.getInstance().get(context.getUser().getCurrentAcademicSessionId()) : null);
        status.setNotifications(notification);
        hibSession.merge((Object)status);
        if (changed) {
            ChangeLog.addChange(hibSession, context, status, status.getReference() + " " + status.getLabel() + (String)(status.getSession() == null ? " (global)" : " (" + status.getSession().getLabel() + ")"), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.UPDATE, null, null);
        }
        if (session) {
            StudentSectioningStatus other;
            HashMap<Long, StudentSectioningStatus> others = new HashMap<Long, StudentSectioningStatus>();
            for (Session s : hibSession.createQuery("select distinct s.session from Student s where s.sectioningStatus.uniqueId = :uniqueId and s.session.uniqueId != :sessionId", Session.class).setParameter("uniqueId", (Object)status.getUniqueId()).setParameter("sessionId", (Object)status.getSession().getUniqueId()).list()) {
                other = (StudentSectioningStatus)hibSession.createQuery("from StudentSectioningStatus where session.uniqueId = :sessionId and reference = :reference", StudentSectioningStatus.class).setParameter("sessionId", (Object)s.getUniqueId()).setParameter("reference", (Object)status.getReference()).uniqueResult();
                if (other == null) {
                    System.out.println("Creating " + status.getReference() + " for " + s.getLabel());
                    other = new StudentSectioningStatus();
                    other.setSession(s);
                    other.setReference(status.getReference());
                    other.setLabel(status.getLabel());
                    other.setMessage(status.getMessage());
                    other.setStatus(status.getStatus());
                    other.setEffectiveStartDate(status.getEffectiveStartDate());
                    other.setEffectiveStartPeriod(status.getEffectiveStartPeriod());
                    other.setEffectiveStopDate(status.getEffectiveStopDate());
                    other.setEffectiveStopPeriod(status.getEffectiveStopPeriod());
                    other.setFallBackStatus(status.getFallBackStatus() == null ? null : StudentSectioningStatus.getStatus(status.getFallBackStatus().getReference(), s.getUniqueId(), hibSession));
                    other.setTypes(new HashSet<CourseType>(status.getTypes()));
                    other.setNotifications(status.getNotifications());
                    hibSession.persist((Object)other);
                    others.put(s.getUniqueId(), other);
                    hibSession.flush();
                }
                hibSession.createMutationQuery("update Student set sectioningStatus.uniqueId = :newId where sectioningStatus.uniqueId = :oldId and session.uniqueId = :sessionId").setParameter("newId", (Object)other.getUniqueId()).setParameter("oldId", (Object)status.getUniqueId()).setParameter("sessionId", (Object)s.getUniqueId()).executeUpdate();
            }
            for (Session s : hibSession.createQuery("from Session where defaultSectioningStatus.uniqueId = :uniqueId and uniqueId != :sessionId", Session.class).setParameter("uniqueId", (Object)status.getUniqueId()).setParameter("sessionId", (Object)status.getSession().getUniqueId()).list()) {
                other = (StudentSectioningStatus)others.get(s.getUniqueId());
                if (other == null) {
                    other = (StudentSectioningStatus)hibSession.createQuery("from StudentSectioningStatus where session.uniqueId = :sessionId and reference = :reference", StudentSectioningStatus.class).setParameter("sessionId", (Object)s.getUniqueId()).setParameter("reference", (Object)status.getReference()).uniqueResult();
                }
                if (other == null) {
                    System.out.println("Creating " + status.getReference() + " for " + s.getLabel());
                    other = new StudentSectioningStatus();
                    other.setSession(s);
                    other.setReference(status.getReference());
                    other.setLabel(status.getLabel());
                    other.setMessage(status.getMessage());
                    other.setStatus(status.getStatus());
                    other.setEffectiveStartDate(status.getEffectiveStartDate());
                    other.setEffectiveStartPeriod(status.getEffectiveStartPeriod());
                    other.setEffectiveStopDate(status.getEffectiveStopDate());
                    other.setEffectiveStopPeriod(status.getEffectiveStopPeriod());
                    other.setFallBackStatus(status.getFallBackStatus() == null ? null : StudentSectioningStatus.getStatus(status.getFallBackStatus().getReference(), s.getUniqueId(), hibSession));
                    other.setTypes(new HashSet<CourseType>(status.getTypes()));
                    other.setNotifications(status.getNotifications());
                    hibSession.persist((Object)other);
                }
                s.setDefaultSectioningStatus(other);
                hibSession.merge((Object)s);
            }
        } else {
            for (StudentSectioningStatus other : hibSession.createQuery("from StudentSectioningStatus where uniqueId != :uniqueId and reference = :reference", StudentSectioningStatus.class).setParameter("uniqueId", (Object)status.getUniqueId()).setParameter("reference", (Object)status.getReference()).list()) {
                System.out.println("Removing " + other.getReference() + " from " + (other.getSession() == null ? "GLOBAL" : other.getSession().getLabel()));
                hibSession.createMutationQuery("update Student set sectioningStatus.uniqueId = :newId where sectioningStatus.uniqueId = :oldId").setParameter("newId", (Object)status.getUniqueId()).setParameter("oldId", (Object)other.getUniqueId()).executeUpdate();
                hibSession.createMutationQuery("update Session set defaultSectioningStatus.uniqueId = :newId where defaultSectioningStatus.uniqueId = :oldId").setParameter("newId", (Object)status.getUniqueId()).setParameter("oldId", (Object)other.getUniqueId()).executeUpdate();
                hibSession.remove((Object)other);
            }
        }
    }

    @Override
    @PreAuthorize(value="checkPermission('StudentSchedulingStatusTypeEdit')")
    public void update(SimpleEditInterface.Record record, SessionContext context, org.hibernate.Session hibSession) {
        this.update((StudentSectioningStatus)StudentSectioningStatusDAO.getInstance().get(record.getUniqueId(), hibSession), record, context, hibSession);
    }

    protected void delete(StudentSectioningStatus status, SessionContext context, org.hibernate.Session hibSession) {
        if (status == null) {
            return;
        }
        for (StudentSectioningStatus s : hibSession.createQuery("from StudentSectioningStatus s where s.fallBackStatus.uniqueId = :statusId", StudentSectioningStatus.class).setParameter("statusId", (Object)status.getUniqueId()).list()) {
            s.setFallBackStatus(null);
            hibSession.merge((Object)s);
        }
        ChangeLog.addChange(hibSession, context, status, status.getReference() + " " + status.getLabel(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.DELETE, null, null);
        hibSession.remove((Object)status);
    }

    @Override
    @PreAuthorize(value="checkPermission('StudentSchedulingStatusTypeEdit')")
    public void delete(SimpleEditInterface.Record record, SessionContext context, org.hibernate.Session hibSession) {
        this.delete((StudentSectioningStatus)StudentSectioningStatusDAO.getInstance().get(record.getUniqueId(), hibSession), context, hibSession);
    }

    static enum StatusOption {
        Access(MESSAGES.toggleAccess(), StudentSectioningStatus.Option.enabled),
        Enrollment(MESSAGES.toggleEnrollment(), StudentSectioningStatus.Option.enrollment),
        Advisor(MESSAGES.toggleAdvisor(), StudentSectioningStatus.Option.advisor),
        Admin(MESSAGES.toggleAdmin(), StudentSectioningStatus.Option.admin),
        RegAccess(MESSAGES.toggleRegAccess(), StudentSectioningStatus.Option.regenabled),
        Registration(MESSAGES.toggleRegistration(), StudentSectioningStatus.Option.registration),
        RegAdvisor(MESSAGES.toggleRegAdvisor(), StudentSectioningStatus.Option.regadvisor),
        RegAdmin(MESSAGES.toggleRegAdmin(), StudentSectioningStatus.Option.regadmin),
        Email(MESSAGES.toggleEmail(), StudentSectioningStatus.Option.email),
        ReSchedule(MESSAGES.toggleReSchedule(), StudentSectioningStatus.Option.reschedule),
        WaitListing(MESSAGES.toggleWaitList(), StudentSectioningStatus.Option.waitlist),
        NoSubs(MESSAGES.toggleNoSubs(), StudentSectioningStatus.Option.nosubs),
        NoBatch(MESSAGES.toggleNoBatch(), StudentSectioningStatus.Option.nobatch),
        AdvisorCanSet(MESSAGES.toggleAdvisorCanSetStatus(), StudentSectioningStatus.Option.advcanset),
        CReqValidation(MESSAGES.toggleCourseRequestValidation(), StudentSectioningStatus.Option.reqval),
        SpecReg(MESSAGES.toggleSpecialRequests(), StudentSectioningStatus.Option.specreg),
        CanReq(MESSAGES.toggleCanRequire(), StudentSectioningStatus.Option.canreq),
        NoSchedule(MESSAGES.toggleNoSchedule(), StudentSectioningStatus.Option.noschedule);

        private StudentSectioningStatus.Option iOption;
        private String iLabel;

        private StatusOption(String label, StudentSectioningStatus.Option option) {
            this.iLabel = label;
            this.iOption = option;
        }

        public String getLabel() {
            return this.iLabel;
        }

        public StudentSectioningStatus.Option getOption() {
            return this.iOption;
        }
    }
}

