/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.admin;

import java.util.ArrayList;
import java.util.HashSet;
import org.cpsolver.ifs.util.ToolBox;
import org.hibernate.Session;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.SimpleEditInterface;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.StudentGroupType;
import org.unitime.timetable.model.dao.StudentGroupTypeDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.admin.AdminTable;

@Service(value="gwtAdminTable[type=stdgrtypes]")
public class StudentGroupTypes
implements AdminTable {
    protected static final GwtMessages MESSAGES = Localization.create(GwtMessages.class);

    @Override
    public SimpleEditInterface.PageName name() {
        return new SimpleEditInterface.PageName(MESSAGES.pageStudentGroupType(), MESSAGES.pageStudentGroupTypes());
    }

    @Override
    @PreAuthorize(value="checkPermission('StudentGroupTypes')")
    public SimpleEditInterface load(SessionContext context, Session hibSession) {
        ArrayList<SimpleEditInterface.ListItem> allow = new ArrayList<SimpleEditInterface.ListItem>();
        allow.add(new SimpleEditInterface.ListItem(String.valueOf(StudentGroupType.AllowDisabledSection.NotAllowed.ordinal()), MESSAGES.itemAllowDisabledSectionsNotAllowed()));
        allow.add(new SimpleEditInterface.ListItem(String.valueOf(StudentGroupType.AllowDisabledSection.WithGroupReservation.ordinal()), MESSAGES.itemAllowDisabledSectionsAllowedReservation()));
        allow.add(new SimpleEditInterface.ListItem(String.valueOf(StudentGroupType.AllowDisabledSection.AlwaysAllowed.ordinal()), MESSAGES.itemAllowDisabledSectionsAlwaysAllowed()));
        SimpleEditInterface data = new SimpleEditInterface(new SimpleEditInterface.Field(MESSAGES.fieldCode(), SimpleEditInterface.FieldType.text, 150, 20, SimpleEditInterface.Flag.UNIQUE), new SimpleEditInterface.Field(MESSAGES.fieldName(), SimpleEditInterface.FieldType.text, 400, 60, SimpleEditInterface.Flag.UNIQUE), new SimpleEditInterface.Field(MESSAGES.fieldKeepTogether(), SimpleEditInterface.FieldType.toggle, 40, new SimpleEditInterface.Flag[0]), new SimpleEditInterface.Field(MESSAGES.fieldAllowDisabledSections(), SimpleEditInterface.FieldType.list, 100, allow, SimpleEditInterface.Flag.NOT_EMPTY), new SimpleEditInterface.Field(MESSAGES.fieldAdvisorsCanSet(), SimpleEditInterface.FieldType.toggle, 40, new SimpleEditInterface.Flag[0]));
        data.setSortBy(1);
        HashSet used = new HashSet(StudentGroupTypeDAO.getInstance().getSession().createQuery("select distinct g.type.uniqueId from StudentGroup g", Long.class).setCacheable(true).list());
        for (StudentGroupType type : StudentGroupTypeDAO.getInstance().findAll()) {
            SimpleEditInterface.Record r = data.addRecord(type.getUniqueId());
            r.setField(0, type.getReference());
            r.setField(1, type.getLabel());
            r.setField(2, type.isKeepTogether() != false ? "true" : "false");
            r.setField(3, type.getAllowDisabled().toString());
            r.setField(4, type.isAdvisorsCanSet() != false ? "true" : "false");
            r.setDeletable(!used.contains(type.getUniqueId()));
        }
        data.setEditable(context.hasPermission(Right.StudentGroupTypeEdit));
        return data;
    }

    @Override
    @PreAuthorize(value="checkPermission('StudentGroupTypeEdit')")
    public void save(SimpleEditInterface data, SessionContext context, Session hibSession) {
        for (StudentGroupType type : StudentGroupTypeDAO.getInstance().findAll()) {
            SimpleEditInterface.Record r = data.getRecord(type.getUniqueId());
            if (r == null) {
                this.delete(type, context, hibSession);
                continue;
            }
            this.update(type, r, context, hibSession);
        }
        for (SimpleEditInterface.Record r : data.getNewRecords()) {
            this.save(r, context, hibSession);
        }
    }

    @Override
    @PreAuthorize(value="checkPermission('StudentGroupTypeEdit')")
    public void save(SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        StudentGroupType type = new StudentGroupType();
        type.setReference(record.getField(0));
        type.setLabel(record.getField(1));
        type.setKeepTogether("true".equals(record.getField(2)));
        type.setAllowDisabled(record.getField(3) == null ? (short)0 : Short.valueOf(record.getField(3)));
        type.setAdvisorsCanSet("true".equals(record.getField(4)));
        hibSession.persist((Object)type);
        record.setUniqueId(type.getUniqueId());
        ChangeLog.addChange(hibSession, context, type, type.getReference() + " " + type.getLabel(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.CREATE, null, null);
    }

    protected void update(StudentGroupType type, SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        if (type == null) {
            return;
        }
        boolean changed = !ToolBox.equals((Object)type.getReference(), (Object)record.getField(0)) || !ToolBox.equals((Object)type.getLabel(), (Object)record.getField(1)) || !ToolBox.equals((Object)type.isKeepTogether(), (Object)"true".equals(record.getField(2))) || !ToolBox.equals((Object)type.getAllowDisabled().toString(), (Object)record.getField(3)) || !ToolBox.equals((Object)type.isAdvisorsCanSet(), (Object)"true".equals(record.getField(4)));
        type.setReference(record.getField(0));
        type.setLabel(record.getField(1));
        type.setKeepTogether("true".equals(record.getField(2)));
        type.setAllowDisabled(record.getField(3) == null ? (short)0 : Short.valueOf(record.getField(3)));
        type.setAdvisorsCanSet("true".equals(record.getField(4)));
        hibSession.merge((Object)type);
        if (changed) {
            ChangeLog.addChange(hibSession, context, type, type.getReference() + " " + type.getLabel(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.UPDATE, null, null);
        }
    }

    @Override
    @PreAuthorize(value="checkPermission('StudentGroupTypeEdit')")
    public void update(SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        this.update((StudentGroupType)StudentGroupTypeDAO.getInstance().get(record.getUniqueId()), record, context, hibSession);
    }

    protected void delete(StudentGroupType type, SessionContext context, Session hibSession) {
        if (type == null) {
            return;
        }
        ChangeLog.addChange(hibSession, context, type, type.getReference() + " " + type.getLabel(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.DELETE, null, null);
        hibSession.remove((Object)type);
    }

    @Override
    @PreAuthorize(value="checkPermission('StudentGroupTypeEdit')")
    public void delete(SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        this.delete((StudentGroupType)StudentGroupTypeDAO.getInstance().get(record.getUniqueId()), context, hibSession);
    }
}

