/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.admin;

import java.util.ArrayList;
import java.util.List;
import org.cpsolver.ifs.util.ToolBox;
import org.hibernate.Session;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.SimpleEditInterface;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.Roles;
import org.unitime.timetable.model.dao.DepartmentDAO;
import org.unitime.timetable.model.dao.DepartmentalInstructorDAO;
import org.unitime.timetable.model.dao.RolesDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.admin.AdminTable;
import org.unitime.timetable.util.NameFormat;

@Service(value="gwtAdminTable[type=instructorRole]")
public class InstructorRoles
implements AdminTable {
    protected static final GwtMessages MESSAGES = Localization.create(GwtMessages.class);

    @Override
    public SimpleEditInterface.PageName name() {
        return new SimpleEditInterface.PageName(MESSAGES.pageInstructorRole(), MESSAGES.pageInstructorRoles());
    }

    @Override
    @PreAuthorize(value="checkPermission('InstructorRoles')")
    public SimpleEditInterface load(SessionContext context, Session hibSession) {
        ArrayList<SimpleEditInterface.ListItem> departments = new ArrayList<SimpleEditInterface.ListItem>();
        ArrayList<SimpleEditInterface.ListItem> instructorRoles = new ArrayList<SimpleEditInterface.ListItem>();
        instructorRoles.add(new SimpleEditInterface.ListItem("", ""));
        for (Roles role : Roles.findAllInstructorRoles()) {
            instructorRoles.add(new SimpleEditInterface.ListItem(role.getUniqueId().toString(), role.getAbbv()));
        }
        SimpleEditInterface data = new SimpleEditInterface(new SimpleEditInterface.Field(MESSAGES.fieldDepartment(), SimpleEditInterface.FieldType.list, 160, departments, new SimpleEditInterface.Flag[0]), new SimpleEditInterface.Field(MESSAGES.fieldInstructor(), SimpleEditInterface.FieldType.person, 300, new SimpleEditInterface.Flag[0]), new SimpleEditInterface.Field(MESSAGES.fieldRole(), SimpleEditInterface.FieldType.list, 300, instructorRoles, new SimpleEditInterface.Flag[0]));
        data.setSortBy(0, 1);
        boolean deptIndep = context.getUser().getCurrentAuthority().hasRight(Right.DepartmentIndependent);
        NameFormat nameFormat = NameFormat.fromReference(context.getUser().getProperty(UserProperty.NameFormat));
        for (Department department : Department.getUserDepartments(context.getUser())) {
            if (!department.isAllowEvents().booleanValue()) continue;
            departments.add(new SimpleEditInterface.ListItem(department.getUniqueId().toString(), department.getLabel()));
            for (DepartmentalInstructor instructor : hibSession.createQuery("from DepartmentalInstructor i where i.department.uniqueId = :departmentId and i.externalUniqueId is not null order by i.lastName, i.firstName", DepartmentalInstructor.class).setParameter("departmentId", (Object)department.getUniqueId()).list()) {
                if (deptIndep && instructor.getRole() == null) continue;
                SimpleEditInterface.Record r = data.addRecord(instructor.getUniqueId(), false);
                r.setField(0, instructor.getDepartment().getUniqueId().toString(), false);
                r.setField(1, null, false);
                r.addToField(1, instructor.getLastName() == null ? "" : instructor.getLastName());
                r.addToField(1, instructor.getFirstName() == null ? "" : instructor.getFirstName());
                r.addToField(1, instructor.getMiddleName() == null ? "" : instructor.getMiddleName());
                r.addToField(1, instructor.getExternalUniqueId());
                r.addToField(1, instructor.getEmail() == null ? "" : instructor.getEmail());
                r.addToField(1, instructor.getAcademicTitle() == null ? "" : instructor.getAcademicTitle());
                r.addToField(1, nameFormat.format(instructor));
                r.setField(2, instructor.getRole() == null ? "" : instructor.getRole().getUniqueId().toString());
                r.setDeletable(deptIndep);
            }
        }
        data.setEditable(context.hasPermission(Right.InstructorRoleEdit));
        return data;
    }

    @Override
    @PreAuthorize(value="checkPermission('InstructorRoleEdit')")
    public void save(SimpleEditInterface data, SessionContext context, Session hibSession) {
        for (Department department : Department.getUserDepartments(context.getUser())) {
            if (!department.isAllowEvents().booleanValue()) continue;
            List instructors = hibSession.createQuery("from DepartmentalInstructor i where i.department.uniqueId = :departmentId and i.externalUniqueId is not null order by i.lastName, i.firstName", DepartmentalInstructor.class).setParameter("departmentId", (Object)department.getUniqueId()).list();
            for (DepartmentalInstructor instructor : instructors) {
                SimpleEditInterface.Record r = data.getRecord(instructor.getUniqueId());
                if (r == null) {
                    this.delete(instructor, context, hibSession);
                    continue;
                }
                this.update(instructor, r, context, hibSession);
            }
            for (SimpleEditInterface.Record r : data.getNewRecords()) {
                if (!department.getUniqueId().toString().equals(r.getField(0))) continue;
                this.save(department, instructors, r, context, hibSession);
            }
        }
    }

    protected void save(Department department, List<DepartmentalInstructor> instructors, SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        if (department == null) {
            return;
        }
        if (record.getField(1) == null || record.getField(1).isEmpty()) {
            return;
        }
        String[] name = record.getValues(1);
        DepartmentalInstructor instructor = null;
        boolean add = true;
        if (instructors == null) {
            instructor = DepartmentalInstructor.findByPuidDepartmentId(name[3], department.getUniqueId());
        } else {
            for (DepartmentalInstructor i : instructors) {
                if (!name[3].equals(i.getExternalUniqueId())) continue;
                instructor = i;
                add = false;
                break;
            }
        }
        if (instructor == null) {
            instructor = new DepartmentalInstructor();
            instructor.setExternalUniqueId(name[3]);
            instructor.setLastName(name[0]);
            instructor.setFirstName(name[1]);
            instructor.setMiddleName(name[2].isEmpty() ? null : name[2]);
            instructor.setEmail(name.length <= 4 || name[4].isEmpty() ? null : name[4]);
            instructor.setAcademicTitle(name.length <= 5 || name[5].isEmpty() ? null : name[5]);
            instructor.setIgnoreToFar(false);
            instructor.setDepartment(department);
            instructor.setRole(record.getField(2) == null || record.getField(2).isEmpty() ? null : (Roles)RolesDAO.getInstance().get(Long.valueOf(record.getField(2))));
            hibSession.persist((Object)instructor);
            record.setUniqueId(instructor.getUniqueId());
        } else {
            record.setUniqueId(instructor.getUniqueId());
            instructor.setRole(record.getField(2) == null || record.getField(2).isEmpty() ? null : (Roles)RolesDAO.getInstance().get(Long.valueOf(record.getField(2))));
            hibSession.merge((Object)instructor);
        }
        record.setDeletable(false);
        record.setField(0, record.getField(0), false);
        record.setField(1, record.getField(1), false);
        ChangeLog.addChange(hibSession, context, instructor, instructor.getName(DepartmentalInstructor.sNameFormatLastInitial) + ": " + (instructor.getRole() == null ? MESSAGES.noRole() : instructor.getRole().getAbbv()), ChangeLog.Source.SIMPLE_EDIT, add ? ChangeLog.Operation.CREATE : ChangeLog.Operation.UPDATE, null, instructor.getDepartment());
    }

    @Override
    @PreAuthorize(value="checkPermission('InstructorRoleEdit')")
    public void save(SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        this.save((Department)DepartmentDAO.getInstance().get(Long.valueOf(record.getField(0))), null, record, context, hibSession);
    }

    protected void update(DepartmentalInstructor instructor, SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        if (instructor == null) {
            return;
        }
        if (ToolBox.equals((Object)(instructor.getRole() == null ? "" : instructor.getRole().getUniqueId().toString()), (Object)record.getField(2))) {
            return;
        }
        instructor.setRole(record.getField(2) == null || record.getField(2).isEmpty() ? null : (Roles)RolesDAO.getInstance().get(Long.valueOf(record.getField(2))));
        hibSession.merge((Object)instructor);
        ChangeLog.addChange(hibSession, context, instructor, instructor.getName(DepartmentalInstructor.sNameFormatLastInitial) + ": " + (instructor.getRole() == null ? MESSAGES.noRole() : instructor.getRole().getAbbv()), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.UPDATE, null, instructor.getDepartment());
    }

    @Override
    @PreAuthorize(value="checkPermission('InstructorRoleEdit')")
    public void update(SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        this.update((DepartmentalInstructor)DepartmentalInstructorDAO.getInstance().get(record.getUniqueId(), hibSession), record, context, hibSession);
    }

    protected void delete(DepartmentalInstructor instructor, SessionContext context, Session hibSession) {
        if (instructor == null) {
            return;
        }
        if (instructor.getRole() == null) {
            return;
        }
        instructor.setRole(null);
        hibSession.merge((Object)instructor);
        ChangeLog.addChange(hibSession, context, instructor, instructor.getName(DepartmentalInstructor.sNameFormatLastInitial) + ": " + MESSAGES.noRole(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.DELETE, null, instructor.getDepartment());
    }

    @Override
    @PreAuthorize(value="checkPermission('InstructorRoleEdit')")
    public void delete(SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        this.delete((DepartmentalInstructor)DepartmentalInstructorDAO.getInstance().get(record.getUniqueId(), hibSession), context, hibSession);
    }
}

