/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.admin;

import org.cpsolver.ifs.util.ToolBox;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.SimpleEditInterface;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.Degree;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.dao.DegreeDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.admin.AdminTable;

@Service(value="gwtAdminTable[type=degree]")
public class Degrees
implements AdminTable {
    protected static final GwtMessages MESSAGES = Localization.create(GwtMessages.class);

    @Override
    public SimpleEditInterface.PageName name() {
        return new SimpleEditInterface.PageName(MESSAGES.pageDegree(), MESSAGES.pageDegrees());
    }

    @Override
    @PreAuthorize(value="checkPermission('Degrees')")
    public SimpleEditInterface load(SessionContext context, org.hibernate.Session hibSession) {
        SimpleEditInterface data = new SimpleEditInterface(new SimpleEditInterface.Field(MESSAGES.fieldExternalId(), SimpleEditInterface.FieldType.text, 240, 40, SimpleEditInterface.Flag.READ_ONLY), new SimpleEditInterface.Field(MESSAGES.fieldCode(), SimpleEditInterface.FieldType.text, 120, 20, SimpleEditInterface.Flag.NOT_EMPTY, SimpleEditInterface.Flag.UNIQUE), new SimpleEditInterface.Field(MESSAGES.fieldName(), SimpleEditInterface.FieldType.text, 360, 60, SimpleEditInterface.Flag.NOT_EMPTY));
        data.setSortBy(1, 2);
        for (Degree degree : Degree.findBySession(hibSession, context.getUser().getCurrentAcademicSessionId())) {
            SimpleEditInterface.Record r = data.addRecord(degree.getUniqueId());
            r.setField(0, degree.getExternalUniqueId());
            r.setField(1, degree.getReference());
            r.setField(2, degree.getLabel());
            r.setDeletable(degree.getExternalUniqueId() == null);
        }
        data.setEditable(context.hasPermission(Right.DegreeEdit));
        return data;
    }

    @Override
    @PreAuthorize(value="checkPermission('DegreeEdit')")
    public void save(SimpleEditInterface data, SessionContext context, org.hibernate.Session hibSession) {
        for (Degree degree : Degree.findBySession(hibSession, context.getUser().getCurrentAcademicSessionId())) {
            SimpleEditInterface.Record r = data.getRecord(degree.getUniqueId());
            if (r == null) {
                this.delete(degree, context, hibSession);
                continue;
            }
            this.update(degree, r, context, hibSession);
        }
        for (SimpleEditInterface.Record r : data.getNewRecords()) {
            this.save(r, context, hibSession);
        }
    }

    @Override
    @PreAuthorize(value="checkPermission('DegreeEdit')")
    public void save(SimpleEditInterface.Record record, SessionContext context, org.hibernate.Session hibSession) {
        Degree degree = new Degree();
        degree.setExternalUniqueId(record.getField(0));
        degree.setReference(record.getField(1));
        degree.setLabel(record.getField(2));
        degree.setSession((Session)SessionDAO.getInstance().get(context.getUser().getCurrentAcademicSessionId(), hibSession));
        hibSession.persist((Object)degree);
        record.setUniqueId(degree.getUniqueId());
        ChangeLog.addChange(hibSession, context, degree, degree.getReference() + " " + degree.getLabel(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.CREATE, null, null);
    }

    protected void update(Degree degree, SimpleEditInterface.Record record, SessionContext context, org.hibernate.Session hibSession) {
        if (degree == null) {
            return;
        }
        if (!(ToolBox.equals((Object)degree.getExternalUniqueId(), (Object)record.getField(0)) && ToolBox.equals((Object)degree.getReference(), (Object)record.getField(1)) && ToolBox.equals((Object)degree.getLabel(), (Object)record.getField(2)))) {
            degree.setExternalUniqueId(record.getField(0));
            degree.setReference(record.getField(1));
            degree.setLabel(record.getField(2));
            hibSession.merge((Object)degree);
            ChangeLog.addChange(hibSession, context, degree, degree.getReference() + " " + degree.getLabel(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.UPDATE, null, null);
        }
    }

    @Override
    @PreAuthorize(value="checkPermission('DegreeEdit')")
    public void update(SimpleEditInterface.Record record, SessionContext context, org.hibernate.Session hibSession) {
        this.update((Degree)DegreeDAO.getInstance().get(record.getUniqueId(), hibSession), record, context, hibSession);
    }

    protected void delete(Degree degree, SessionContext context, org.hibernate.Session hibSession) {
        if (degree == null) {
            return;
        }
        ChangeLog.addChange(hibSession, context, degree, degree.getReference() + " " + degree.getLabel(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.DELETE, null, null);
        hibSession.remove((Object)degree);
    }

    @Override
    @PreAuthorize(value="checkPermission('DegreeEdit')")
    public void delete(SimpleEditInterface.Record record, SessionContext context, org.hibernate.Session hibSession) {
        this.delete((Degree)DegreeDAO.getInstance().get(record.getUniqueId(), hibSession), context, hibSession);
    }
}

