/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.admin;

import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.security.access.AccessDeniedException;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.CommonValues;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.gwt.command.client.GwtRpcException;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.PageAccessException;
import org.unitime.timetable.gwt.shared.SimpleEditInterface;
import org.unitime.timetable.model.dao._RootDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.server.admin.AdminTable;

public class AdminBackend {
    protected static final GwtMessages MESSAGES = Localization.create(GwtMessages.class);
    private static Log sLog = LogFactory.getLog(AdminBackend.class);

    public static AdminTable getTable(ApplicationContext context, String type) {
        return (AdminTable)context.getBean("gwtAdminTable[type=" + type + "]", AdminTable.class);
    }

    @GwtRpcImplements(value=SimpleEditInterface.GetFilterRpcRequest.class)
    public static class GetFilterBackend
    implements GwtRpcImplementation<SimpleEditInterface.GetFilterRpcRequest, SimpleEditInterface.Filter> {
        @Autowired
        ApplicationContext applicationContext;

        @Override
        public SimpleEditInterface.Filter execute(SimpleEditInterface.GetFilterRpcRequest request, SessionContext context) {
            Session hibSession = new _RootDAO().getSession();
            Transaction tx = null;
            SimpleEditInterface.Filter ret = null;
            try {
                tx = hibSession.beginTransaction();
                AdminTable at = AdminBackend.getTable(this.applicationContext, request.getType());
                if (at instanceof AdminTable.HasFilter) {
                    ret = ((AdminTable.HasFilter)((Object)at)).getFilter(context, hibSession);
                }
                hibSession.flush();
                tx.commit();
                tx = null;
                SimpleEditInterface.Filter filter = ret;
                return filter;
            }
            catch (PageAccessException e) {
                throw e;
            }
            catch (GwtRpcException e) {
                throw e;
            }
            catch (Exception e) {
                sLog.error((Object)e.getMessage(), (Throwable)e);
                throw new GwtRpcException(e.getMessage(), e);
            }
            finally {
                try {
                    if (tx != null && tx.isActive()) {
                        tx.rollback();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    @GwtRpcImplements(value=SimpleEditInterface.LoadRecordRpcRequest.class)
    public static class LoadRecordBackend
    implements GwtRpcImplementation<SimpleEditInterface.LoadRecordRpcRequest, SimpleEditInterface.Record> {
        @Autowired
        ApplicationContext applicationContext;

        @Override
        public SimpleEditInterface.Record execute(SimpleEditInterface.LoadRecordRpcRequest request, SessionContext context) {
            Session hibSession = new _RootDAO().getSession();
            Transaction tx = null;
            try {
                tx = hibSession.beginTransaction();
                AdminTable at = AdminBackend.getTable(this.applicationContext, request.getType());
                if (at instanceof AdminTable.HasLazyFields) {
                    ((AdminTable.HasLazyFields)((Object)at)).load(request.getRecord(), context, hibSession);
                }
                hibSession.flush();
                tx.commit();
                tx = null;
                SimpleEditInterface.Record record = request.getRecord();
                return record;
            }
            catch (PageAccessException e) {
                throw e;
            }
            catch (GwtRpcException e) {
                throw e;
            }
            catch (Exception e) {
                sLog.error((Object)e.getMessage(), (Throwable)e);
                throw new GwtRpcException(e.getMessage(), e);
            }
            finally {
                try {
                    if (tx != null && tx.isActive()) {
                        tx.rollback();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    @GwtRpcImplements(value=SimpleEditInterface.DeleteRecordRpcRequest.class)
    public static class DeleteRecordBackend
    implements GwtRpcImplementation<SimpleEditInterface.DeleteRecordRpcRequest, SimpleEditInterface.Record> {
        @Autowired
        ApplicationContext applicationContext;

        @Override
        public SimpleEditInterface.Record execute(SimpleEditInterface.DeleteRecordRpcRequest request, SessionContext context) {
            Session hibSession = new _RootDAO().getSession();
            Transaction tx = null;
            try {
                tx = hibSession.beginTransaction();
                AdminBackend.getTable(this.applicationContext, request.getType()).delete(request.getRecord(), context, hibSession);
                hibSession.flush();
                tx.commit();
                tx = null;
                SimpleEditInterface.Record record = request.getRecord();
                return record;
            }
            catch (PageAccessException e) {
                throw e;
            }
            catch (GwtRpcException e) {
                throw e;
            }
            catch (Exception e) {
                sLog.error((Object)e.getMessage(), (Throwable)e);
                throw new GwtRpcException(e.getMessage(), e);
            }
            finally {
                try {
                    if (tx != null && tx.isActive()) {
                        tx.rollback();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    @GwtRpcImplements(value=SimpleEditInterface.SaveRecordRpcRequest.class)
    public static class SaveRecordBackend
    implements GwtRpcImplementation<SimpleEditInterface.SaveRecordRpcRequest, SimpleEditInterface.Record> {
        @Autowired
        ApplicationContext applicationContext;

        @Override
        public SimpleEditInterface.Record execute(SimpleEditInterface.SaveRecordRpcRequest request, SessionContext context) {
            Session hibSession = new _RootDAO().getSession();
            Transaction tx = null;
            try {
                tx = hibSession.beginTransaction();
                if (request.getRecord().getUniqueId() == null) {
                    AdminBackend.getTable(this.applicationContext, request.getType()).save(request.getRecord(), context, hibSession);
                } else {
                    AdminBackend.getTable(this.applicationContext, request.getType()).update(request.getRecord(), context, hibSession);
                }
                hibSession.flush();
                tx.commit();
                tx = null;
                SimpleEditInterface.Record record = request.getRecord();
                return record;
            }
            catch (PageAccessException e) {
                throw e;
            }
            catch (GwtRpcException e) {
                throw e;
            }
            catch (Exception e) {
                sLog.error((Object)e.getMessage(), (Throwable)e);
                throw new GwtRpcException(e.getMessage(), e);
            }
            finally {
                try {
                    if (tx != null && tx.isActive()) {
                        tx.rollback();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    @GwtRpcImplements(value=SimpleEditInterface.SaveDataRpcRequest.class)
    public static class SaveDataBackend
    implements GwtRpcImplementation<SimpleEditInterface.SaveDataRpcRequest, SimpleEditInterface> {
        @Autowired
        ApplicationContext applicationContext;

        @Override
        public SimpleEditInterface execute(SimpleEditInterface.SaveDataRpcRequest request, SessionContext context) {
            Session hibSession = new _RootDAO().getSession();
            Transaction tx = null;
            try {
                tx = hibSession.beginTransaction();
                SimpleEditInterface data = request.getData();
                AdminTable at = AdminBackend.getTable(this.applicationContext, request.getType());
                if (request.getFilter() != null && at instanceof AdminTable.HasFilter) {
                    ((AdminTable.HasFilter)((Object)at)).save(request.getFilter(), request.getData(), context, hibSession);
                } else {
                    at.save(request.getData(), context, hibSession);
                }
                hibSession.flush();
                tx.commit();
                tx = null;
                Iterator<SimpleEditInterface.Record> i = data.getRecords().iterator();
                while (i.hasNext()) {
                    if (i.next().getUniqueId() != null) continue;
                    i.remove();
                }
                SimpleEditInterface simpleEditInterface = data;
                return simpleEditInterface;
            }
            catch (PageAccessException e) {
                throw e;
            }
            catch (GwtRpcException e) {
                throw e;
            }
            catch (Exception e) {
                sLog.error((Object)e.getMessage(), (Throwable)e);
                throw new GwtRpcException(e.getMessage(), e);
            }
            finally {
                try {
                    if (tx != null && tx.isActive()) {
                        tx.rollback();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    @GwtRpcImplements(value=SimpleEditInterface.LoadDataRpcRequest.class)
    public static class LoadDataBackend
    implements GwtRpcImplementation<SimpleEditInterface.LoadDataRpcRequest, SimpleEditInterface> {
        @Autowired
        ApplicationContext applicationContext;

        @Override
        public SimpleEditInterface execute(SimpleEditInterface.LoadDataRpcRequest request, SessionContext context) {
            Session hibSession = new _RootDAO().getSession();
            Transaction tx = null;
            try {
                tx = hibSession.beginTransaction();
                SimpleEditInterface data = null;
                AdminTable at = AdminBackend.getTable(this.applicationContext, request.getType());
                data = request.getFilter() != null && at instanceof AdminTable.HasFilter ? ((AdminTable.HasFilter)((Object)at)).load(request.getFilter(), context, hibSession) : at.load(context, hibSession);
                if (!data.hasConfirmDelete() && CommonValues.Yes.eq(context.getUser().getProperty(UserProperty.ConfirmationDialogs))) {
                    data.setConfirmDelete(MESSAGES.confirmDeleteItem(at.name().singular().toLowerCase()));
                }
                hibSession.flush();
                tx.commit();
                tx = null;
                SimpleEditInterface simpleEditInterface = data;
                return simpleEditInterface;
            }
            catch (PageAccessException e) {
                throw e;
            }
            catch (GwtRpcException e) {
                throw e;
            }
            catch (AccessDeniedException e) {
                throw new PageAccessException(e.getMessage(), e);
            }
            catch (Exception e) {
                sLog.error((Object)e.getMessage(), (Throwable)e);
                throw new GwtRpcException(e.getMessage(), e);
            }
            finally {
                try {
                    if (tx != null && tx.isActive()) {
                        tx.rollback();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    @GwtRpcImplements(value=SimpleEditInterface.GetPageNameRpcRequest.class)
    public static class PageNameBackend
    implements GwtRpcImplementation<SimpleEditInterface.GetPageNameRpcRequest, SimpleEditInterface.PageName> {
        @Autowired
        ApplicationContext applicationContext;

        @Override
        public SimpleEditInterface.PageName execute(SimpleEditInterface.GetPageNameRpcRequest request, SessionContext context) {
            return AdminBackend.getTable(this.applicationContext, request.getType()).name();
        }
    }
}

