/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.access;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpSessionEvent;
import jakarta.servlet.http.HttpSessionListener;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiConsumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Session;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.filter.BusySessions;
import org.unitime.timetable.gwt.client.access.AccessControlInterface;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.command.server.GwtRpcLogging;
import org.unitime.timetable.model.AccessStatistics;
import org.unitime.timetable.model.dao.AccessStatisticsDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.UserAuthority;
import org.unitime.timetable.security.UserQualifier;

@GwtRpcImplements(value=AccessControlInterface.PingRequest.class)
@GwtRpcLogging(value=GwtRpcLogging.Level.DISABLED)
public class AccessControllBackend
implements GwtRpcImplementation<AccessControlInterface.PingRequest, AccessControlInterface.PingResponse>,
InitializingBean,
DisposableBean {
    private static Log sLog = LogFactory.getLog(AccessControllBackend.class);
    private ConcurrentMap<String, ConcurrentMap<String, PingData>> iData = new ConcurrentHashMap<String, ConcurrentMap<String, PingData>>();
    private Updater iUpdater;
    @Autowired
    private BusySessions.Tracker unitimeBusySessions;

    @Override
    public AccessControlInterface.PingResponse execute(AccessControlInterface.PingRequest request, SessionContext context) {
        long t0 = System.currentTimeMillis();
        ConcurrentMap data = this.iData.computeIfAbsent(request.getPage(), key -> new ConcurrentHashMap());
        PingData pd = data.compute(context.getHttpSessionId(), (key, current) -> {
            if (current == null) {
                current = new PingData(t0);
            }
            current.update(request, context, t0);
            return current;
        });
        AccessControlInterface.PingResponse ret = new AccessControlInterface.PingResponse();
        if (request.getOperation() != AccessControlInterface.Operation.LOGOUT) {
            if (!pd.isAccess()) {
                Integer maxActiveUsers = this.getMaxActiveUsers(request.getPage());
                if (maxActiveUsers == null) {
                    pd.setAccess(true, t0);
                } else {
                    CheckQueue cq = new CheckQueue(request.getPage(), context.getHttpSessionId(), pd, t0);
                    data.forEach(cq);
                    if (cq.getUsersWithAccess() + cq.getUsersInQueueBeforeMe() + 1 <= maxActiveUsers) {
                        pd.setAccess(true, t0);
                    } else {
                        ret.setQueue(1 + cq.getUsersInQueueBeforeMe());
                    }
                }
            } else {
                Integer activeLimitInSeconds = this.getActiveLimitInSeconds(request.getPage());
                if (activeLimitInSeconds != null && pd.getActiveAge(t0) > (long)activeLimitInSeconds.intValue() && !this.unitimeBusySessions.isWorking(context.getHttpSessionId())) {
                    ret.setInactive(activeLimitInSeconds / 60);
                }
            }
        }
        if (sLog.isTraceEnabled()) {
            sLog.trace((Object)(context.getHttpSessionId() + ": " + request.getOperation() + " " + pd.toString(t0)));
        }
        ret.setAccess(pd.isAccess());
        return ret;
    }

    public Integer getMaxActiveUsers(String page) {
        Integer maxActiveUsers = ApplicationProperty.AccessControlMaxActiveUsers.intValue(page);
        return maxActiveUsers == null || maxActiveUsers <= 0 ? null : maxActiveUsers;
    }

    public Integer getActiveLimitInSeconds(String page) {
        Integer limitInMinutes = ApplicationProperty.AccessControlActiveLimitInMinutes.intValue(page);
        return limitInMinutes == null || limitInMinutes <= 0 ? null : Integer.valueOf(limitInMinutes * 60);
    }

    public void destroy() throws Exception {
        if (this.iUpdater != null) {
            this.iUpdater.interrupt();
            this.iUpdater = null;
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.iUpdater = new Updater();
        this.iUpdater.start();
    }

    protected ConcurrentMap<String, ConcurrentMap<String, PingData>> getData() {
        return this.iData;
    }

    private static class PingData
    implements Comparable<PingData> {
        private String iPage;
        private String iUser;
        private String iSession;
        private String iAutority;
        private long iFirstUse;
        private long iLastPing;
        private long iLastActive;
        private long iGotAccess;
        private boolean iAccess = false;
        private boolean iLoggedOut = false;
        private boolean iCountedIn = false;
        private boolean iCountedOut = false;

        PingData(long t0) {
            this.iLastActive = this.iLastPing = (this.iFirstUse = t0);
        }

        void update(AccessControlInterface.PingRequest request, SessionContext context, long t0) {
            if (request.getOperation() == AccessControlInterface.Operation.PING) {
                if (!this.iAccess) {
                    this.iGotAccess = t0;
                    this.iCountedIn = false;
                    this.iFirstUse = t0;
                }
                this.iAccess = true;
            } else if (request.getOperation() == AccessControlInterface.Operation.LOGOUT) {
                if (this.iAccess) {
                    this.iCountedOut = false;
                }
                this.iAccess = false;
            }
            if (request.getOperation() == AccessControlInterface.Operation.CHECK_ACCESS && !this.iAccess && !this.isOpened(t0)) {
                this.iFirstUse = t0;
                this.iGotAccess = 0L;
            }
            this.iLastPing = t0;
            boolean bl = this.iLoggedOut = request.getOperation() == AccessControlInterface.Operation.LOGOUT;
            if (request.isActive()) {
                this.iLastActive = t0;
            }
            this.iPage = request.getPage();
            if (context.isAuthenticated()) {
                this.iUser = context.getUser().getExternalUserId();
                UserAuthority auth = context.getUser().getCurrentAuthority();
                if (auth != null) {
                    this.iAutority = auth.getRole();
                    UserQualifier session = auth.getAcademicSession();
                    this.iSession = session == null ? null : session.getQualifierReference();
                } else {
                    this.iAutority = null;
                    this.iSession = null;
                }
            } else {
                this.iUser = null;
                this.iAutority = null;
                this.iSession = null;
            }
        }

        public void logout() {
            if (this.iAccess) {
                this.iCountedOut = false;
            }
            this.iAccess = false;
            this.iLoggedOut = true;
        }

        public long getActiveAge(long t0) {
            return (t0 - this.iLastActive) / 1000L;
        }

        public long getPingAge(long t0) {
            return (t0 - this.iLastPing) / 1000L;
        }

        public long getAge(long t0) {
            return (t0 - this.iFirstUse) / 1000L;
        }

        public boolean hadAccess() {
            return this.iGotAccess > 0L;
        }

        public long getAccessTime() {
            return (this.iLastPing - this.iGotAccess) / 1000L;
        }

        public long getWaitingTime() {
            if (this.iGotAccess > 0L) {
                return (this.iGotAccess - this.iFirstUse) / 1000L;
            }
            return (this.iLastPing - this.iFirstUse) / 1000L;
        }

        public long getFirstUse() {
            return this.iFirstUse;
        }

        public String getPage() {
            return this.iPage;
        }

        public boolean isOpened(long t0) {
            return this.getPingAge(t0) <= 60L && !this.isLoggedOut();
        }

        public boolean isActive(long t0, Integer activeLimitInSeconds) {
            return this.isOpened(t0) && (activeLimitInSeconds == null || this.getActiveAge(t0) <= (long)(activeLimitInSeconds + 120));
        }

        public boolean isAccess() {
            return this.iAccess;
        }

        public void setAccess(boolean access, long t0) {
            if (!this.iAccess && access) {
                this.iGotAccess = t0;
                this.iCountedIn = false;
            }
            if (this.iAccess && !access) {
                this.iCountedOut = false;
            }
            this.iAccess = access;
        }

        public boolean isLoggedOut() {
            return this.iLoggedOut;
        }

        public boolean countIn() {
            if (!this.iCountedIn) {
                this.iCountedIn = true;
                return true;
            }
            return false;
        }

        public boolean countOut() {
            if (!this.iCountedOut) {
                this.iCountedOut = true;
                return true;
            }
            return false;
        }

        public String toString(long t0) {
            return "PingData{" + (this.isLoggedOut() || !this.isOpened(t0) ? "expired, " : (this.isAccess() ? "access, " : "waiting, ")) + this.getAge(t0) / 60L + "m old, " + this.getActiveAge(t0) / 60L + "m inactive, " + this.getPingAge(t0) / 60L + "m unchecked, page=" + this.iPage + ", user=" + this.iUser + ", session=" + this.iSession + ", role=" + this.iAutority + "}";
        }

        public String toString() {
            return this.toString(System.currentTimeMillis());
        }

        @Override
        public int compareTo(PingData pd) {
            return Long.compare(pd.iLastActive, this.iLastActive);
        }
    }

    private class CheckQueue
    implements BiConsumer<String, PingData> {
        private String iPage;
        private String iSession;
        private PingData iPingData;
        private int iAccess;
        private int iQueue;
        private Integer iActiveLimitInSeconds;
        private long iT0;

        private CheckQueue(String myPage, String mySession, PingData myData, long t0) {
            this.iPage = myPage;
            this.iSession = mySession;
            this.iPingData = myData;
            this.iActiveLimitInSeconds = AccessControllBackend.this.getActiveLimitInSeconds(myPage);
            this.iT0 = t0;
        }

        @Override
        public void accept(String t, PingData u) {
            if (!this.iSession.equals(t) && this.iPage.equals(u.getPage()) && u.isActive(this.iT0, this.iActiveLimitInSeconds)) {
                if (u.isAccess()) {
                    ++this.iAccess;
                } else if (u.getFirstUse() < this.iPingData.getFirstUse()) {
                    ++this.iQueue;
                }
            }
        }

        public int getUsersWithAccess() {
            return this.iAccess;
        }

        public int getUsersInQueueBeforeMe() {
            return this.iQueue;
        }

        public String toString() {
            return "access: " + this.iAccess + ", queue: " + this.iQueue;
        }
    }

    private class Updater
    extends Thread {
        private boolean iActive;
        private String iHost;

        public Updater() {
            super("PingBackend.Updater");
            this.iActive = true;
            this.iHost = "localhost";
            this.setDaemon(true);
            try {
                this.iHost = InetAddress.getLocalHost().getHostName();
                if (this.iHost.indexOf(46) > 0) {
                    this.iHost = this.iHost.substring(0, this.iHost.indexOf(46));
                }
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }

        @Override
        public void interrupt() {
            this.iActive = false;
            super.interrupt();
            try {
                this.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        @Override
        public void run() {
            sLog.debug((Object)"Access Controll Updater is up.");
            while (true) {
                try {
                    do {
                        try {
                            Updater.sleep(60000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        Counter c = new Counter();
                        AccessControllBackend.this.iData.forEach(c);
                        if (c.isEmpty()) continue;
                        sLog.info((Object)c);
                        try {
                            c.record(this.iHost);
                        }
                        catch (Exception e) {
                            sLog.warn((Object)("Failed to record statistics: " + e.getMessage()), (Throwable)e);
                        }
                    } while (this.iActive);
                }
                catch (Exception e) {
                    sLog.error((Object)e.getMessage(), (Throwable)e);
                    continue;
                }
                break;
            }
            sLog.debug((Object)"Access Controll Updater is down.");
        }
    }

    public static class Listener
    implements HttpSessionListener {
        private AccessControllBackend iBackend;

        private AccessControllBackend getBackend(HttpSessionEvent event) {
            if (this.iBackend == null) {
                WebApplicationContext applicationContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)event.getSession().getServletContext());
                this.iBackend = (AccessControllBackend)applicationContext.getBean(AccessControlInterface.PingRequest.class.getName());
            }
            return this.iBackend;
        }

        protected ConcurrentMap<String, ConcurrentMap<String, PingData>> getData(HttpSessionEvent event) {
            return this.getBackend(event).getData();
        }

        public void sessionCreated(HttpSessionEvent event) {
        }

        public void sessionDestroyed(HttpSessionEvent event) {
            this.getData(event).forEach((page, data) -> {
                PingData pd = (PingData)data.get(event.getSession().getId());
                if (pd != null) {
                    pd.logout();
                    if (sLog.isTraceEnabled()) {
                        sLog.trace((Object)(event.getSession().getId() + ": REMOVE " + pd.toString(System.currentTimeMillis())));
                    }
                }
            });
        }
    }

    private class Counter
    implements BiConsumer<String, ConcurrentMap<String, PingData>> {
        private long iT0 = System.currentTimeMillis();
        List<PingCounter> iCounters = new ArrayList<PingCounter>();

        private Counter() {
        }

        @Override
        public void accept(String page, ConcurrentMap<String, PingData> u) {
            PingCounter pc = new PingCounter(page, this.iT0);
            Iterator i = u.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry e = i.next();
                if (pc.accept((String)e.getKey(), (PingData)e.getValue())) continue;
                if (sLog.isTraceEnabled()) {
                    sLog.trace((Object)((String)e.getKey() + ": removed"));
                }
                i.remove();
            }
            if (!pc.isEmpty()) {
                this.iCounters.add(pc);
            }
        }

        public String toString() {
            Object ret = "";
            for (PingCounter pc : this.iCounters) {
                ret = (String)(((String)ret).isEmpty() ? "" : (String)ret + "\n") + pc;
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void record(String host) {
            try (Session hibSession = AccessStatisticsDAO.getInstance().createNewSession();){
                for (PingCounter pc : this.iCounters) {
                    AccessStatistics stat = pc.generateAccessStatisticsRecord();
                    stat.setHost(host);
                    hibSession.persist((Object)stat);
                }
                hibSession.flush();
            }
        }

        public boolean isEmpty() {
            return this.iCounters.isEmpty();
        }
    }

    private class PingCounter {
        private String iPage;
        private Integer iActiveLimitInSeconds;
        private Integer iMaxActiveUsers;
        private long iT0;
        private int iWaiting = 0;
        private int iActive1 = 0;
        private int iActive2 = 0;
        private int iActive5 = 0;
        private int iActive10 = 0;
        private int iActive15 = 0;
        private int iActive = 0;
        private int iAccess = 0;
        private int iOpened = 0;
        private int iTotal = 0;
        private int iGaveUp = 0;
        private int iLeft = 0;
        private int iGotIn = 0;
        private Average iWaitTime = new Average();
        private Average iWaitTimeWhenGotIn = new Average();
        private Average iAccessTime = new Average();
        private Average iGaveUpTime = new Average();
        private Average iAccessTimeWhenLeft = new Average();

        PingCounter(String page, long t0) {
            this.iPage = page;
            this.iActiveLimitInSeconds = AccessControllBackend.this.getActiveLimitInSeconds(page);
            this.iMaxActiveUsers = AccessControllBackend.this.getMaxActiveUsers(page);
            this.iT0 = t0;
        }

        public void inc(PingData u) {
            ++this.iTotal;
            if (u.isAccess()) {
                ++this.iAccess;
                if (u.getActiveAge(this.iT0) <= 60L) {
                    ++this.iActive1;
                }
                if (u.getActiveAge(this.iT0) <= 120L) {
                    ++this.iActive2;
                }
                if (u.getActiveAge(this.iT0) <= 300L) {
                    ++this.iActive5;
                }
                if (u.getActiveAge(this.iT0) <= 600L) {
                    ++this.iActive10;
                }
                if (u.getActiveAge(this.iT0) <= 900L) {
                    ++this.iActive15;
                }
                if (u.isActive(this.iT0, this.iActiveLimitInSeconds)) {
                    ++this.iActive;
                }
                this.iAccessTime.add(u.getAccessTime());
                if (u.countIn()) {
                    ++this.iGotIn;
                    this.iWaitTimeWhenGotIn.add(u.getWaitingTime());
                }
            } else if (u.isLoggedOut()) {
                if (u.hadAccess()) {
                    ++this.iLeft;
                    this.iAccessTimeWhenLeft.add(u.getAccessTime());
                } else {
                    ++this.iGaveUp;
                    this.iGaveUpTime.add(u.getWaitingTime());
                }
            } else if (u.isActive(this.iT0, this.iActiveLimitInSeconds)) {
                ++this.iWaiting;
                this.iWaitTime.add(u.getWaitingTime());
            } else if (u.countOut()) {
                if (u.hadAccess()) {
                    ++this.iLeft;
                    this.iAccessTimeWhenLeft.add(u.getAccessTime());
                } else {
                    ++this.iGaveUp;
                    this.iGaveUpTime.add(u.getWaitingTime());
                }
            }
            if (u.isOpened(this.iT0)) {
                ++this.iOpened;
            }
        }

        public String toString() {
            DecimalFormat df = new DecimalFormat("0.0");
            return this.iPage + "{access: " + this.iAccess + (String)(this.iMaxActiveUsers == null ? "" : " of " + this.iMaxActiveUsers) + ", active: " + this.iActive + " (avg: " + df.format((double)this.iAccessTime.getAverage() / 60.0) + "m, <1m: " + this.iActive1 + ", <2m: " + this.iActive2 + ", <5m: " + this.iActive5 + ", <10m: " + this.iActive10 + ", <15m: " + this.iActive15 + "), waiting: " + this.iWaiting + (String)(this.iWaiting > 0 ? " (avg: " + df.format((double)this.iWaitTime.getAverage() / 60.0) + "m)" : "") + ", gotin: " + this.iGotIn + (String)(this.iGotIn > 0 && this.iWaitTimeWhenGotIn.getTotal() > 0L ? " (avg: " + df.format((double)this.iWaitTimeWhenGotIn.getAverage() / 60.0) + "m)" : "") + ", left: " + this.iLeft + (String)(this.iLeft > 0 ? " (avg: " + df.format((double)this.iAccessTimeWhenLeft.getAverage() / 60.0) + "m)" : "") + ", gaveup: " + this.iGaveUp + (String)(this.iGaveUp > 0 ? " (avg: " + df.format((double)this.iGaveUpTime.getAverage() / 60.0) + "m)" : "") + ", opened: " + this.iOpened + ", tracking: " + this.iTotal + "}";
        }

        public AccessStatistics generateAccessStatisticsRecord() {
            AccessStatistics stat = new AccessStatistics();
            stat.setTimeStamp(new Date(this.iT0));
            stat.setPage(this.iPage);
            stat.setAccess(this.iAccess);
            stat.setActive(this.iActive);
            stat.setOpened(this.iOpened);
            stat.setWaiting(this.iWaiting);
            stat.setTracking(this.iTotal);
            stat.setActive1m(this.iActive1);
            stat.setActive2m(this.iActive2);
            stat.setActive5m(this.iActive5);
            stat.setActive10m(this.iActive10);
            stat.setActive15m(this.iActive15);
            stat.setGotIn(this.iGotIn);
            stat.setGaveUp(this.iGaveUp);
            stat.setLeft(this.iLeft);
            stat.setAvgAccessTime(this.iAccessTime.getAverage());
            stat.setAvgAccessTimeWhenLeft(this.iAccessTimeWhenLeft.getAverage());
            stat.setAvgWaitTime(this.iWaitTime.getAverage());
            stat.setAvgWaitTimeWhenGotIn(this.iWaitTimeWhenGotIn.getAverage());
            return stat;
        }

        public boolean accept(String t, PingData u) {
            if (sLog.isDebugEnabled()) {
                sLog.debug((Object)(t + ": " + u.toString(this.iT0)));
            }
            if (u.getPingAge(this.iT0) > 1800L) {
                return false;
            }
            if (u.isAccess() && !u.isOpened(this.iT0)) {
                u.setAccess(false, this.iT0);
            }
            this.inc(u);
            return !u.isLoggedOut();
        }

        public boolean isEmpty() {
            return this.iTotal == 0;
        }
    }

    public static class Average {
        private long iTotal = 0L;
        private int iCount = 0;

        Average() {
        }

        private void add(long value) {
            this.iTotal += value;
            ++this.iCount;
        }

        public int getCount() {
            return this.iCount;
        }

        public long getTotal() {
            return this.iTotal;
        }

        private long getAverage() {
            return this.iCount == 0 ? 0L : this.iTotal / (long)this.iCount;
        }
    }
}

