/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server;

import java.util.List;
import org.hibernate.query.Query;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseList;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.shared.LastChangesInterface;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.NonUniversityLocation;
import org.unitime.timetable.model.Room;
import org.unitime.timetable.model.dao.ChangeLogDAO;
import org.unitime.timetable.security.SessionContext;

@GwtRpcImplements(value=LastChangesInterface.LastChangesRequest.class)
public class LastChangesBackend
implements GwtRpcImplementation<LastChangesInterface.LastChangesRequest, GwtRpcResponseList<LastChangesInterface.ChangeLogInterface>> {
    @Override
    public GwtRpcResponseList<LastChangesInterface.ChangeLogInterface> execute(LastChangesInterface.LastChangesRequest request, SessionContext context) {
        GwtRpcResponseList<LastChangesInterface.ChangeLogInterface> response = new GwtRpcResponseList<LastChangesInterface.ChangeLogInterface>();
        for (ChangeLog cl : this.findChangeLog(request)) {
            LastChangesInterface.ChangeLogInterface log = new LastChangesInterface.ChangeLogInterface();
            if (cl.getDepartment() != null) {
                log.setDepartment(cl.getDepartment().getDeptCode());
                log.setDepartmentId(cl.getDepartment().getUniqueId());
            }
            if (cl.getSubjectArea() != null) {
                log.setSubject(cl.getSubjectArea().getSubjectAreaAbbreviation());
                log.setSubjectId(cl.getSubjectArea().getUniqueId());
            }
            if (cl.getSession() != null) {
                log.setSession(cl.getSession().getLabel());
                log.setSessionId(cl.getSession().getUniqueId());
                log.setSessionDate(cl.getSession().getSessionBeginDateTime());
                log.setSessionInitiative(cl.getSession().getAcademicInitiative());
            }
            if (cl.getManager() != null) {
                log.setManager(cl.getManager().getName());
            }
            if (cl.getTimeStamp() != null) {
                log.setDate(cl.getTimeStamp());
            }
            if (cl.getOperation() != null) {
                log.setOperation(cl.getOperation().getTitle());
            }
            if (cl.getObjectTitle() != null) {
                log.setObject(cl.getObjectTitle());
            }
            if (cl.getSource() != null) {
                log.setPage(cl.getSource().getTitle());
            }
            log.setId(cl.getUniqueId());
            response.add(log);
        }
        return response;
    }

    private List<ChangeLog> findChangeLog(LastChangesInterface.LastChangesRequest request) {
        String from = "ChangeLog l";
        Object where = "l.objectType = :type and l.objectUniqueId = :id";
        String groupBy = null;
        String orderBy = "l.timeStamp desc";
        if (Location.class.getName().equals(request.getObjectType())) {
            if ("true".equalsIgnoreCase(request.getOption("multi-session"))) {
                from = "ChangeLog l, Location r1, Location r2";
                where = "l.objectType in (:type, :roomType, :locType) and r1.uniqueId = :id and r2.permanentId = r1.permanentId and r2.uniqueId = l.objectUniqueId";
            } else {
                where = "l.objectType in (:type, :roomType, :locType) and l.objectUniqueId = :id";
            }
        }
        if (request.hasOption("operation")) {
            where = (String)where + " and l.operationString = :operation";
        }
        if (request.hasOption("page")) {
            where = (String)where + " and l.sourceString = :source";
        }
        String query = "select l from " + from + " where " + (String)where + (String)(groupBy == null ? "" : " group by " + groupBy) + " order by " + orderBy;
        Query q = ChangeLogDAO.getInstance().getSession().createQuery(query, ChangeLog.class);
        if (request.hasOption("limit")) {
            q.setMaxResults(Integer.valueOf(request.getOption("limit")).intValue());
        } else {
            q.setMaxResults(ApplicationProperty.LastChangesLimit.intValue().intValue());
        }
        if (request.hasOption("operation")) {
            q.setParameter("operation", (Object)request.getOption("operation").toUpperCase());
        }
        if (request.hasOption("page")) {
            q.setParameter("source", (Object)request.getOption("page").replace(' ', '_').toUpperCase());
        }
        if (Location.class.getName().equals(request.getObjectType())) {
            q.setParameter("roomType", (Object)Room.class.getName());
            q.setParameter("locType", (Object)NonUniversityLocation.class.getName());
        }
        q.setParameter("type", (Object)request.getObjectType());
        q.setParameter("id", (Object)request.getObjectId());
        q.setCacheable(true);
        return q.list();
    }
}

