/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.security.permissions;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.model.ClassEvent;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseEvent;
import org.unitime.timetable.model.DepartmentStatusType;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.Event;
import org.unitime.timetable.model.EventContact;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.ExamEvent;
import org.unitime.timetable.model.ExamOwner;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.Meeting;
import org.unitime.timetable.model.OfferingCoordinator;
import org.unitime.timetable.model.RelatedCourseInfo;
import org.unitime.timetable.model.RoomTypeOption;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.Solution;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentSectioningStatus;
import org.unitime.timetable.model.dao.ClassEventDAO;
import org.unitime.timetable.model.dao.CourseEventDAO;
import org.unitime.timetable.model.dao.ExamEventDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.model.dao.StudentDAO;
import org.unitime.timetable.security.UserAuthority;
import org.unitime.timetable.security.UserContext;
import org.unitime.timetable.security.UserQualifier;
import org.unitime.timetable.security.permissions.Permission;
import org.unitime.timetable.security.permissions.PermissionForRight;
import org.unitime.timetable.security.permissions.SimpleSessionPermission;
import org.unitime.timetable.security.rights.Right;

public class EventPermissions {

    @PermissionForRight(value=Right.EventCanSeeUnpublishedEvents)
    public static class EventCanSeeUnpublishedClassEvents
    extends SimpleSessionPermission {
    }

    @PermissionForRight(value=Right.EventMeetingInquire)
    public static class EventMeetingInquire
    extends EventPermission<Meeting> {
        @Autowired
        Permission<Location> permissionEventLocation;

        @Override
        public boolean check(UserContext user, Meeting source) {
            if (source.getStatus() != Meeting.Status.PENDING && source.getStatus() != Meeting.Status.APPROVED) {
                return false;
            }
            switch (source.getEvent().getEventType()) {
                case 0: 
                case 1: 
                case 2: {
                    return false;
                }
            }
            if (this.isOutside(source.getMeetingDate(), (Session)SessionDAO.getInstance().get(user.getCurrentAcademicSessionId()))) {
                return false;
            }
            if (!user.getCurrentAuthority().hasRight(Right.EventApprovePast) && this.isPast(source.getMeetingDate())) {
                return false;
            }
            return this.permissionEventLocation.check(user, source.getLocation());
        }

        @Override
        public Class<Meeting> type() {
            return Meeting.class;
        }
    }

    @PermissionForRight(value=Right.EventMeetingApprove)
    public static class EventMeetingApprove
    extends EventPermission<Meeting> {
        @Autowired
        Permission<Location> permissionEventLocationApprove;

        @Override
        public boolean check(UserContext user, Meeting source) {
            if (source.getStatus() != Meeting.Status.PENDING) {
                return false;
            }
            switch (source.getEvent().getEventType()) {
                case 0: 
                case 1: 
                case 2: 
                case 5: {
                    return false;
                }
            }
            if (this.isOutside(source.getMeetingDate(), (Session)SessionDAO.getInstance().get(user.getCurrentAcademicSessionId()))) {
                return false;
            }
            if (!user.getCurrentAuthority().hasRight(Right.EventApprovePast) && this.isPast(source.getMeetingDate())) {
                return false;
            }
            return this.permissionEventLocationApprove.check(user, source.getLocation());
        }

        @Override
        public Class<Meeting> type() {
            return Meeting.class;
        }
    }

    @PermissionForRight(value=Right.EventMeetingInquireExam)
    public static class EventMeetingInquireExam
    extends EventPermission<Meeting> {
        @Autowired
        Permission<Date> permissionEventDate;
        @Autowired
        Permission.PermissionSession permissionSession;

        @Override
        public boolean check(UserContext user, Meeting source) {
            if (source.getEvent().getEventType() != 1 && source.getEvent().getEventType() != 2) {
                return false;
            }
            if (source.getStatus() != Meeting.Status.PENDING && source.getStatus() != Meeting.Status.APPROVED) {
                return false;
            }
            if (source.getStatus() != Meeting.Status.APPROVED) {
                return false;
            }
            if (!this.permissionEventDate.check(user, source.getMeetingDate())) {
                return false;
            }
            Exam exam = (source.getEvent() instanceof ExamEvent ? (ExamEvent)source.getEvent() : (ExamEvent)ExamEventDAO.getInstance().get(source.getEvent().getUniqueId())).getExam();
            if (exam == null) {
                return false;
            }
            if ("Instructor".equals(user.getCurrentAuthority().getRole())) {
                for (ExamOwner owner : exam.getOwners()) {
                    for (OfferingCoordinator coordinator : owner.getCourse().getInstructionalOffering().getOfferingCoordinators()) {
                        if (!user.getExternalUserId().equals(coordinator.getInstructor().getExternalUniqueId())) continue;
                        return true;
                    }
                }
                return false;
            }
            return this.permissionSession.check(user, exam.getSession(), DepartmentStatusType.Status.OwnerView, DepartmentStatusType.Status.ManagerView);
        }

        @Override
        public Class<Meeting> type() {
            return Meeting.class;
        }
    }

    @PermissionForRight(value=Right.EventMeetingInquireClass)
    public static class EventMeetingInquireClass
    extends EventPermission<Meeting> {
        @Autowired
        Permission<Date> permissionEventDate;
        @Autowired
        Permission.PermissionDepartment permissionDepartment;

        @Override
        public boolean check(UserContext user, Meeting source) {
            if (source.getEvent().getEventType() != 0) {
                return false;
            }
            if (source.getStatus() != Meeting.Status.PENDING && source.getStatus() != Meeting.Status.APPROVED) {
                return false;
            }
            if (!this.permissionEventDate.check(user, source.getMeetingDate())) {
                return false;
            }
            Class_ clazz = (source.getEvent() instanceof ClassEvent ? (ClassEvent)source.getEvent() : (ClassEvent)ClassEventDAO.getInstance().get(source.getEvent().getUniqueId())).getClazz();
            if (clazz == null) {
                return false;
            }
            if ("Instructor".equals(user.getCurrentAuthority().getRole())) {
                for (OfferingCoordinator coordinator : clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().getOfferingCoordinators()) {
                    if (!user.getExternalUserId().equals(coordinator.getInstructor().getExternalUniqueId())) continue;
                    return true;
                }
                return false;
            }
            return this.permissionDepartment.check(user, clazz.getControllingDept(), DepartmentStatusType.Status.OwnerView);
        }

        @Override
        public Class<Meeting> type() {
            return Meeting.class;
        }
    }

    @PermissionForRight(value=Right.EventMeetingCancelExam)
    public static class EventMeetingCancelExam
    extends EventPermission<Meeting> {
        @Autowired
        Permission<Date> permissionEventDate;
        @Autowired
        Permission.PermissionSession permissionSession;

        @Override
        public boolean check(UserContext user, Meeting source) {
            if (source.getEvent().getEventType() != 1 && source.getEvent().getEventType() != 2) {
                return false;
            }
            if (source.getStatus() != Meeting.Status.APPROVED) {
                return false;
            }
            if (!this.permissionEventDate.check(user, source.getMeetingDate())) {
                return false;
            }
            Exam exam = (source.getEvent() instanceof ExamEvent ? (ExamEvent)source.getEvent() : (ExamEvent)ExamEventDAO.getInstance().get(source.getEvent().getUniqueId())).getExam();
            if (exam == null) {
                return false;
            }
            if ("Instructor".equals(user.getCurrentAuthority().getRole())) {
                for (ExamOwner owner : exam.getOwners()) {
                    for (OfferingCoordinator coordinator : owner.getCourse().getInstructionalOffering().getOfferingCoordinators()) {
                        if (!user.getExternalUserId().equals(coordinator.getInstructor().getExternalUniqueId())) continue;
                        return true;
                    }
                }
                return false;
            }
            return this.permissionSession.check(user, exam.getSession(), DepartmentStatusType.Status.ExamTimetable);
        }

        @Override
        public Class<Meeting> type() {
            return Meeting.class;
        }
    }

    @PermissionForRight(value=Right.EventMeetingCancelClass)
    public static class EventMeetingCancelClass
    extends EventPermission<Meeting> {
        @Autowired
        Permission<Date> permissionEventDate;
        @Autowired
        Permission.PermissionDepartment permissionDepartment;

        @Override
        public boolean check(UserContext user, Meeting source) {
            if (source.getEvent().getEventType() != 0) {
                return false;
            }
            if (source.getStatus() != Meeting.Status.APPROVED) {
                return false;
            }
            if (!this.permissionEventDate.check(user, source.getMeetingDate())) {
                return false;
            }
            Class_ clazz = (source.getEvent() instanceof ClassEvent ? (ClassEvent)source.getEvent() : (ClassEvent)ClassEventDAO.getInstance().get(source.getEvent().getUniqueId())).getClazz();
            if (clazz == null) {
                return false;
            }
            if ("Instructor".equals(user.getCurrentAuthority().getRole())) {
                for (OfferingCoordinator coordinator : clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().getOfferingCoordinators()) {
                    if (!user.getExternalUserId().equals(coordinator.getInstructor().getExternalUniqueId())) continue;
                    return true;
                }
                return false;
            }
            return this.permissionDepartment.check(user, clazz.getManagingDept(), DepartmentStatusType.Status.Timetable);
        }

        @Override
        public Class<Meeting> type() {
            return Meeting.class;
        }
    }

    @PermissionForRight(value=Right.EventMeetingCancel)
    public static class EventMeetingCancel
    extends EventPermission<Meeting> {
        @Autowired
        Permission<Date> permissionEventDate;
        @Autowired
        Permission<Location> permissionEventLocationApprove;

        @Override
        public boolean check(UserContext user, Meeting source) {
            switch (source.getEvent().getEventType()) {
                case 0: {
                    return false;
                }
                case 1: 
                case 2: {
                    return false;
                }
                case 3: 
                case 4: {
                    if (source.getStatus() == Meeting.Status.PENDING || source.getStatus() == Meeting.Status.APPROVED) break;
                    return false;
                }
                case 5: {
                    if (source.getStatus() == Meeting.Status.APPROVED) break;
                    return false;
                }
            }
            if (this.permissionEventDate.check(user, source.getMeetingDate())) {
                if (user.getExternalUserId().equals(source.getEvent().getMainContact().getExternalUniqueId())) {
                    return true;
                }
                if (source.getEvent().getEventType() == 3 && "Instructor".equals(user.getCurrentAuthority().getRole())) {
                    CourseEvent event = (CourseEvent)CourseEventDAO.getInstance().get(source.getEvent().getUniqueId());
                    for (RelatedCourseInfo owner : event.getRelatedCourses()) {
                        for (OfferingCoordinator coordinator : owner.getCourse().getInstructionalOffering().getOfferingCoordinators()) {
                            if (!user.getExternalUserId().equals(coordinator.getInstructor().getExternalUniqueId())) continue;
                            return true;
                        }
                    }
                }
            }
            if (!user.getCurrentAuthority().hasRight(Right.EventLookupContact)) {
                return false;
            }
            if (this.isOutside(source.getMeetingDate(), (Session)SessionDAO.getInstance().get(user.getCurrentAcademicSessionId()))) {
                return false;
            }
            if (!user.getCurrentAuthority().hasRight(Right.EventApprovePast) && this.isPast(source.getMeetingDate())) {
                return false;
            }
            return this.permissionEventLocationApprove.check(user, source.getLocation());
        }

        @Override
        public Class<Meeting> type() {
            return Meeting.class;
        }
    }

    @PermissionForRight(value=Right.EventMeetingDelete)
    public static class EventMeetingDelete
    extends EventPermission<Meeting> {
        @Autowired
        Permission<Date> permissionEventDate;
        @Autowired
        Permission<Location> permissionEventLocation;

        @Override
        public boolean check(UserContext user, Meeting source) {
            switch (source.getEvent().getEventType()) {
                case 0: 
                case 1: 
                case 2: {
                    return false;
                }
                case 3: 
                case 4: {
                    Location location;
                    if (source.getStatus() == Meeting.Status.APPROVED && ((location = source.getLocation()) == null || location.getEffectiveEventStatus().isAutomaticApproval())) {
                        return true;
                    }
                    if (source.getStatus() == Meeting.Status.PENDING) break;
                    return false;
                }
                case 5: {
                    if (source.getStatus() == Meeting.Status.APPROVED) break;
                    return false;
                }
            }
            if (!this.permissionEventDate.check(user, source.getMeetingDate())) {
                return false;
            }
            if (user.getExternalUserId().equals(source.getEvent().getMainContact().getExternalUniqueId())) {
                return true;
            }
            return this.permissionEventLocation.check(user, source.getLocation());
        }

        @Override
        public Class<Meeting> type() {
            return Meeting.class;
        }
    }

    @PermissionForRight(value=Right.EventMeetingEdit)
    public static class EventMeetingEdit
    extends EventPermission<Meeting> {
        @Autowired
        Permission<Event> permissionEventEdit;
        @Autowired
        Permission<Date> permissionEventDate;
        @Autowired
        Permission<Location> permissionEventLocation;

        @Override
        public boolean check(UserContext user, Meeting source) {
            if (source.getStatus() != Meeting.Status.PENDING && source.getStatus() != Meeting.Status.APPROVED) {
                return false;
            }
            if (!this.permissionEventEdit.check(user, source.getEvent())) {
                return false;
            }
            if (!this.permissionEventDate.check(user, source.getMeetingDate())) {
                return false;
            }
            return this.permissionEventLocation.check(user, source.getLocation());
        }

        @Override
        public Class<Meeting> type() {
            return Meeting.class;
        }
    }

    @PermissionForRight(value=Right.EventLocationOverbook)
    public static class EventLocationOverbook
    extends EventPermission<Location> {
        @Autowired
        Permission<Location> permissionEventLocation;
        @Autowired
        Permission.PermissionDepartment permissionDepartment;

        @Override
        public boolean check(UserContext user, Location source) {
            if (user.getCurrentAuthority().hasRight(Right.EventAnyLocation)) {
                return true;
            }
            if (!this.locations(user.getCurrentAcademicSessionId(), user).contains(source.getUniqueId())) {
                return false;
            }
            if (!source.getEffectiveEventStatus().isEventManagersCanRequestEvents()) {
                return false;
            }
            return this.permissionDepartment.check(user, source.getEventDepartment());
        }

        @Override
        public Class<Location> type() {
            return Location.class;
        }
    }

    @PermissionForRight(value=Right.EventLocationUnavailable)
    public static class EventLocationUnavailable
    extends EventPermission<Location> {
        @Autowired
        Permission<Location> permissionEventLocation;
        @Autowired
        Permission.PermissionDepartment permissionDepartment;

        @Override
        public boolean check(UserContext user, Location source) {
            if (user.getCurrentAuthority().hasRight(Right.EventAnyLocation)) {
                return true;
            }
            if (!this.locations(user.getCurrentAcademicSessionId(), user).contains(source.getUniqueId())) {
                return false;
            }
            if (!source.getEffectiveEventStatus().isEventManagersCanRequestEvents()) {
                return false;
            }
            return this.permissionDepartment.check(user, source.getEventDepartment());
        }

        @Override
        public Class<Location> type() {
            return Location.class;
        }
    }

    @PermissionForRight(value=Right.EventLocationApprove)
    public static class EventLocationApprove
    extends EventPermission<Location> {
        @Autowired
        Permission<Location> permissionEventLocation;
        @Autowired
        Permission.PermissionDepartment permissionDepartment;

        @Override
        public boolean check(UserContext user, Location source) {
            if (user.getCurrentAuthority().hasRight(Right.EventAnyLocation)) {
                return true;
            }
            if (!this.locations(user.getCurrentAcademicSessionId(), user).contains(source.getUniqueId())) {
                return false;
            }
            if (!user.getCurrentAuthority().hasRight(Right.StatusIndependent) && !source.getEffectiveEventStatus().isEventManagersCanApprove()) {
                return false;
            }
            return this.permissionDepartment.check(user, source.getEventDepartment());
        }

        @Override
        public Class<Location> type() {
            return Location.class;
        }
    }

    @PermissionForRight(value=Right.EventLocation)
    public static class EventLocation
    extends EventPermission<Location> {
        @Override
        public boolean check(UserContext user, Location source) {
            return source == null || user.getCurrentAuthority().hasRight(Right.EventAnyLocation) || this.locations(user.getCurrentAcademicSessionId(), user).contains(source.getUniqueId());
        }

        @Override
        public Class<Location> type() {
            return Location.class;
        }
    }

    @PermissionForRight(value=Right.EventDate)
    public static class EventDate
    extends EventPermission<Date> {
        @Override
        public boolean check(UserContext user, Date source) {
            return (user.getCurrentAuthority().hasRight(Right.EventEditPast) || !this.isPast(source)) && !this.isOutside(source, (Session)SessionDAO.getInstance().get(user.getCurrentAcademicSessionId()));
        }

        @Override
        public Class<Date> type() {
            return Date.class;
        }
    }

    @PermissionForRight(value=Right.EventEditExam)
    public static class EventEditExam
    extends EventPermission<ExamEvent> {
        @Autowired
        Permission.PermissionSession permissionSession;

        @Override
        public boolean check(UserContext user, ExamEvent source) {
            if (source == null || source.getExam() == null) {
                return false;
            }
            if (user.getCurrentAuthority().hasRight(Right.ExaminationEdit) && this.permissionSession.check(user, source.getSession(), DepartmentStatusType.Status.ExamTimetable)) {
                return true;
            }
            if ("Instructor".equals(user.getCurrentAuthority().getRole())) {
                for (ExamOwner owner : source.getExam().getOwners()) {
                    for (OfferingCoordinator coordinator : owner.getCourse().getInstructionalOffering().getOfferingCoordinators()) {
                        if (!user.getExternalUserId().equals(coordinator.getInstructor().getExternalUniqueId())) continue;
                        return true;
                    }
                }
            }
            return false;
        }

        @Override
        public Class<ExamEvent> type() {
            return ExamEvent.class;
        }
    }

    @PermissionForRight(value=Right.EventEditClass)
    public static class EventEditClass
    extends EventPermission<ClassEvent> {
        @Autowired
        Permission.PermissionDepartment permissionDepartment;

        @Override
        public boolean check(UserContext user, ClassEvent source) {
            if (source == null || source.getClazz() == null) {
                return false;
            }
            if (user.getCurrentAuthority().hasRight(Right.ClassEdit) && this.permissionDepartment.check(user, source.getClazz().getManagingDept(), DepartmentStatusType.Status.Timetable)) {
                return true;
            }
            if ("Instructor".equals(user.getCurrentAuthority().getRole())) {
                for (OfferingCoordinator coordinator : source.getClazz().getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().getOfferingCoordinators()) {
                    if (!user.getExternalUserId().equals(coordinator.getInstructor().getExternalUniqueId())) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public Class<ClassEvent> type() {
            return ClassEvent.class;
        }
    }

    @PermissionForRight(value=Right.EventEdit)
    public static class EventEdit
    extends EventPermission<Event> {
        @Autowired
        Permission.PermissionSession permissionSession;
        @Autowired
        Permission<Date> permissionEventDate;
        @Autowired
        Permission<ClassEvent> permissionEventEditClass;
        @Autowired
        Permission<ExamEvent> permissionEventEditExam;

        @Override
        public boolean check(UserContext user, Event source) {
            switch (source.getEventType()) {
                case 0: {
                    return user.getCurrentAuthority().hasRight(Right.EventEditClass) && this.permissionEventEditClass.check(user, source instanceof ClassEvent ? (ClassEvent)source : (ClassEvent)ClassEventDAO.getInstance().get(source.getUniqueId()));
                }
                case 1: 
                case 2: {
                    return user.getCurrentAuthority().hasRight(Right.EventEditExam) && this.permissionEventEditExam.check(user, source instanceof ExamEvent ? (ExamEvent)source : (ExamEvent)ExamEventDAO.getInstance().get(source.getUniqueId()));
                }
                case 5: {
                    if (user.getCurrentAuthority().hasRight(Right.EventAddUnavailable)) break;
                    return false;
                }
                case 3: {
                    if (user.getCurrentAuthority().hasRight(Right.EventAddCourseRelated)) break;
                    return false;
                }
                case 4: {
                    if (user.getCurrentAuthority().hasRight(Right.EventAddSpecial)) break;
                    return false;
                }
            }
            return user.getCurrentAuthority().hasRight(Right.EventLookupContact) || user.getExternalUserId().equals(source.getMainContact().getExternalUniqueId());
        }

        @Override
        public Class<Event> type() {
            return Event.class;
        }
    }

    @PermissionForRight(value=Right.EventDetailArrangeHourClass)
    public static class EventDetailArrangeHourClass
    implements Permission<Class_> {
        @Autowired
        Permission<Class_> permissionClassDetail;
        @Autowired
        Permission<Exam> permissionExaminationDetail;

        @Override
        public boolean check(UserContext user, Class_ source) {
            if (user.getCurrentAuthority().hasRight(Right.ClassDetail) && this.permissionClassDetail.check(user, source)) {
                return true;
            }
            if ("Instructor".equals(user.getCurrentAuthority().getRole())) {
                for (OfferingCoordinator coordinator : source.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().getOfferingCoordinators()) {
                    if (!user.getExternalUserId().equals(coordinator.getInstructor().getExternalUniqueId())) continue;
                    return true;
                }
                for (ClassInstructor instructor : source.getClassInstructors()) {
                    if (!user.getExternalUserId().equals(instructor.getInstructor().getExternalUniqueId())) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public Class<Class_> type() {
            return Class_.class;
        }
    }

    @PermissionForRight(value=Right.EventDetailEmailStudents)
    public static class EventDetailEmailStudents
    extends Events {
    }

    @PermissionForRight(value=Right.EventDetail)
    public static class EventDetail
    implements Permission<Event> {
        @Autowired
        Permission<Class_> permissionClassDetail;
        @Autowired
        Permission<Exam> permissionExaminationDetail;

        @Override
        public boolean check(UserContext user, Event source) {
            if (source.getMainContact() != null && user.getExternalUserId().equals(source.getMainContact().getExternalUniqueId())) {
                return true;
            }
            for (EventContact contact : source.getAdditionalContacts()) {
                if (!user.getExternalUserId().equals(contact.getExternalUniqueId())) continue;
                return true;
            }
            switch (source.getEventType()) {
                case 0: {
                    Class_ clazz;
                    if (user.getCurrentAuthority().hasRight(Right.ClassDetail) && this.permissionClassDetail.check(user, clazz = (source instanceof ClassEvent ? (ClassEvent)source : (ClassEvent)ClassEventDAO.getInstance().get(source.getUniqueId())).getClazz())) {
                        return true;
                    }
                    if ("Instructor".equals(user.getCurrentAuthority().getRole())) {
                        clazz = (source instanceof ClassEvent ? (ClassEvent)source : (ClassEvent)ClassEventDAO.getInstance().get(source.getUniqueId())).getClazz();
                        if (clazz == null) {
                            return false;
                        }
                        for (OfferingCoordinator coordinator : clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().getOfferingCoordinators()) {
                            if (!user.getExternalUserId().equals(coordinator.getInstructor().getExternalUniqueId())) continue;
                            return true;
                        }
                        for (ClassInstructor instructor : clazz.getClassInstructors()) {
                            if (!user.getExternalUserId().equals(instructor.getInstructor().getExternalUniqueId())) continue;
                            return true;
                        }
                    }
                    return false;
                }
                case 1: 
                case 2: {
                    Exam exam;
                    if (user.getCurrentAuthority().hasRight(Right.ExaminationDetail) && this.permissionExaminationDetail.check(user, exam = (source instanceof ExamEvent ? (ExamEvent)source : (ExamEvent)ExamEventDAO.getInstance().get(source.getUniqueId())).getExam())) {
                        return true;
                    }
                    if ("Instructor".equals(user.getCurrentAuthority().getRole())) {
                        exam = (source instanceof ExamEvent ? (ExamEvent)source : (ExamEvent)ExamEventDAO.getInstance().get(source.getUniqueId())).getExam();
                        if (exam == null) {
                            return false;
                        }
                        for (DepartmentalInstructor instructor : exam.getInstructors()) {
                            if (!user.getExternalUserId().equals(instructor.getExternalUniqueId())) continue;
                            return true;
                        }
                        for (ExamOwner owner : exam.getOwners()) {
                            for (OfferingCoordinator coordinator : owner.getCourse().getInstructionalOffering().getOfferingCoordinators()) {
                                if (!user.getExternalUserId().equals(coordinator.getInstructor().getExternalUniqueId())) continue;
                                return true;
                            }
                        }
                    }
                    return false;
                }
                case 3: {
                    if ("Instructor".equals(user.getCurrentAuthority().getRole())) {
                        CourseEvent event = (CourseEvent)CourseEventDAO.getInstance().get(source.getUniqueId());
                        for (RelatedCourseInfo owner : event.getRelatedCourses()) {
                            for (OfferingCoordinator coordinator : owner.getCourse().getInstructionalOffering().getOfferingCoordinators()) {
                                if (!user.getExternalUserId().equals(coordinator.getInstructor().getExternalUniqueId())) continue;
                                return true;
                            }
                        }
                    }
                    return user.getCurrentAuthority().hasRight(Right.EventLookupContact);
                }
            }
            return user.getCurrentAuthority().hasRight(Right.EventLookupContact);
        }

        @Override
        public Class<Event> type() {
            return Event.class;
        }
    }

    @PermissionForRight(value=Right.EventAddUnavailable)
    public static class EventAddUnavailable
    extends EventPermission<Session> {
        @Autowired
        Permission<Session> permissionEventAddSpecial;

        @Override
        public boolean check(UserContext user, Session source) {
            return user.getCurrentAuthority().hasRight(Right.EventLocationUnavailable) && this.permissionEventAddSpecial.check(user, source);
        }

        @Override
        public Class<Session> type() {
            return Session.class;
        }
    }

    @PermissionForRight(value=Right.EventAddCourseRelated)
    public static class EventAddCourseRelated
    extends EventAddSpecial {
    }

    @PermissionForRight(value=Right.EventAddSpecial)
    public static class EventAddSpecial
    extends EventPermission<Session> {
        @Override
        public boolean check(UserContext user, Session source) {
            return !(this.isPast(this.end(source)) && !user.getCurrentAuthority().hasRight(Right.EventEditPast) || !user.getCurrentAuthority().hasRight(Right.EventAnyLocation) && this.locations(source, user).isEmpty());
        }

        @Override
        public Class<Session> type() {
            return Session.class;
        }
    }

    @PermissionForRight(value=Right.Events)
    public static class Events
    extends EventPermission<Session> {
        @Override
        public boolean check(UserContext user, Session source) {
            return source.getStatusType().canNoRoleReport() || user.getCurrentAuthority().hasRight(Right.EventAnyLocation) || !this.locations(source, user).isEmpty();
        }

        @Override
        public Class<Session> type() {
            return Session.class;
        }
    }

    protected static abstract class EventPermission<T>
    implements Permission<T> {
        @Autowired
        Permission.PermissionSession permissionSession;

        protected EventPermission() {
        }

        protected Date today() {
            Calendar cal = Calendar.getInstance(Localization.getJavaLocale());
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            return cal.getTime();
        }

        protected Date begin(Session session) {
            return session.getEventBeginDate();
        }

        protected Date end(Session session) {
            Calendar cal = Calendar.getInstance(Localization.getJavaLocale());
            cal.setTime(session.getEventEndDate());
            cal.add(6, 1);
            return cal.getTime();
        }

        protected boolean isOutside(Date date, Session session) {
            return date == null || date.before(this.begin(session)) || !date.before(this.end(session));
        }

        protected boolean isPast(Date date) {
            return date == null || date.before(this.today());
        }

        protected List<Long> locations(Long sessionId, UserContext user) {
            if (sessionId == null) {
                return new ArrayList<Long>();
            }
            return this.locations((Session)SessionDAO.getInstance().get(sessionId), user);
        }

        /*
         * WARNING - void declaration
         */
        protected List<Long> locations(Session session, UserContext user) {
            void var9_16;
            if (session == null || !this.permissionSession.check(user, session, DepartmentStatusType.Status.EventManagement)) {
                return new ArrayList<Long>();
            }
            Object anyRequest = "";
            Object deptRequest = "";
            Object mgrRequest = "";
            for (RoomTypeOption.Status status : RoomTypeOption.Status.values()) {
                if (status.isAuthenticatedUsersCanRequestEvents()) {
                    anyRequest = (String)anyRequest + (((String)anyRequest).isEmpty() ? "" : ", ") + status.ordinal();
                    continue;
                }
                if (status.isDepartmentalUsersCanRequestEvents()) {
                    deptRequest = (String)deptRequest + (((String)deptRequest).isEmpty() ? "" : ", ") + status.ordinal();
                }
                if (!status.isEventManagersCanRequestEvents()) continue;
                mgrRequest = (String)mgrRequest + (((String)mgrRequest).isEmpty() ? "" : ", ") + status.ordinal();
            }
            HashSet<Serializable> roleDeptIds = new HashSet<Serializable>();
            HashSet<Serializable> mgrDeptIds = new HashSet<Serializable>();
            if (!user.getCurrentAuthority().hasRight(Right.DepartmentIndependent)) {
                for (UserAuthority userAuthority : user.getAuthorities()) {
                    if (!session.getUniqueId().equals(userAuthority.getAcademicSession().getQualifierId())) continue;
                    for (UserQualifier userQualifier : userAuthority.getQualifiers("Department")) {
                        roleDeptIds.add(userQualifier.getQualifierId());
                        if (!userAuthority.hasRight(Right.EventMeetingApprove)) continue;
                        mgrDeptIds.add(userQualifier.getQualifierId());
                    }
                }
            }
            String roleDept = null;
            Object var9_15 = null;
            for (Serializable serializable : roleDeptIds) {
                roleDept = (String)(roleDept == null ? "" : roleDept + ",") + serializable;
            }
            for (Serializable serializable : mgrDeptIds) {
                String string = (String)(var9_16 == null ? "" : (String)var9_16 + ",") + serializable;
            }
            return SessionDAO.getInstance().getSession().createQuery("select distinct l.uniqueId from Location l, RoomTypeOption o where l.eventDepartment.allowEvents = true and l.session.uniqueId = :sessionId and ((l.eventStatus in (" + (String)anyRequest + ") or (l.eventStatus is null and o.status in (" + (String)anyRequest + ") and o.roomType = l.roomType and o.department = l.eventDepartment))" + (String)(user.getCurrentAuthority().hasRight(Right.DepartmentIndependent) ? " or (l.eventStatus in (" + (String)deptRequest + ") or (l.eventStatus is null and o.status in (" + (String)deptRequest + ") and o.roomType = l.roomType and o.department = l.eventDepartment))" : (roleDept == null ? "" : " or ((l.eventStatus in (" + (String)deptRequest + ") or (l.eventStatus is null and o.status in (" + (String)deptRequest + ") and o.roomType = l.roomType and o.department = l.eventDepartment)) and l.eventDepartment.uniqueId in (" + roleDept + "))")) + (String)(user.getCurrentAuthority().hasRight(Right.DepartmentIndependent) && user.getCurrentAuthority().hasRight(Right.EventMeetingApprove) ? " or (l.eventStatus in (" + (String)mgrRequest + ") or (l.eventStatus is null and o.status in (" + (String)mgrRequest + ") and o.roomType = l.roomType and o.department = l.eventDepartment))" : (var9_16 == null ? "" : " or ((l.eventStatus in (" + (String)mgrRequest + ") or (l.eventStatus is null and o.status in (" + (String)mgrRequest + ") and o.roomType = l.roomType and o.department = l.eventDepartment)) and l.eventDepartment.uniqueId in (" + (String)var9_16 + "))")) + ")", Long.class).setParameter("sessionId", (Object)session.getUniqueId()).setCacheable(true).list();
        }
    }

    @PermissionForRight(value=Right.PersonalScheduleLookup)
    public static class PersonalScheduleLookup
    extends PersonalSchedule {
    }

    @PermissionForRight(value=Right.PersonalSchedule)
    public static class PersonalSchedule
    implements Permission<Session> {
        @Autowired
        Permission.PermissionSession permissionSession;

        @Override
        public boolean check(UserContext user, Session source) {
            if ("Student".equals(user.getCurrentAuthority().getRole())) {
                StudentSectioningStatus status;
                List<? extends UserQualifier> q = user.getCurrentAuthority().getQualifiers("Student");
                Student student = q == null || q.isEmpty() ? null : (Student)StudentDAO.getInstance().get((Long)q.get(0).getQualifierId());
                StudentSectioningStatus studentSectioningStatus = status = student == null ? null : student.getEffectiveStatus();
                if (status != null && status.hasOption(StudentSectioningStatus.Option.noschedule)) {
                    return false;
                }
            }
            return this.permissionSession.check(user, source, DepartmentStatusType.Status.ReportClasses) && Solution.hasTimetable(source.getSessionId()) || this.permissionSession.check(user, source, DepartmentStatusType.Status.ReportExamsFinal) && Exam.hasTimetable(source.getUniqueId(), 0) || this.permissionSession.check(user, source, DepartmentStatusType.Status.ReportExamsMidterm) && Exam.hasTimetable(source.getUniqueId(), 1);
        }

        @Override
        public Class<Session> type() {
            return Session.class;
        }
    }
}

